/* rygel-media-container.c generated by valac 0.21.1, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>


#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainerPrivate {
	gint _child_count;
	gint _empty_child_count;
	gboolean _create_mode_enabled;
	gchar* _sort_criteria;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_media_container_parent_class = NULL;

GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerPrivate))
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_CONTAINER_CHILD_COUNT,
	RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT,
	RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT,
	RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED,
	RYGEL_MEDIA_CONTAINER_SORT_CRITERIA,
	RYGEL_MEDIA_CONTAINER_OCM_FLAGS
};
#define RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA "+upnp:class,+dc:title"
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".album.musicAlbum"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".person.musicArtist"
#define RYGEL_MEDIA_CONTAINER_MUSIC_GENRE RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".genre.musicGenre"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".playlistContainer"
#define RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA "+upnp:class," "+rygel:originalVolumeNumber," "+upnp:originalTrackNumber," "+dc:title"
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count);
static void rygel_media_container_real_constructed (GObject* base);
void rygel_media_container_set_empty_child_count (RygelMediaContainer* self, gint value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
void rygel_media_container_set_create_mode_enabled (RygelMediaContainer* self, gboolean value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaObject* sub_tree_root);
static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteContainer* rygel_serializer_add_container (RygelSerializer* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
void rygel_media_container_add_resources (RygelMediaContainer* self, RygelHTTPServer* http_server, GUPnPDIDLLiteContainer* didl_container, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static GUPnPDIDLLiteResource* rygel_media_container_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
void rygel_media_container_check_search_expression (RygelMediaContainer* self, RygelSearchExpression* expression);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_set_child_count (RygelMediaContainer* self, gint value);
gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self);
gint rygel_media_container_get_all_child_count (RygelMediaContainer* self);
gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
void rygel_media_container_set_sort_criteria (RygelMediaContainer* self, const gchar* value);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_container_finalize (GObject* obj);
static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType rygel_object_event_type_get_type (void) {
	static volatile gsize rygel_object_event_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_event_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_OBJECT_EVENT_TYPE_ADDED, "RYGEL_OBJECT_EVENT_TYPE_ADDED", "added"}, {RYGEL_OBJECT_EVENT_TYPE_MODIFIED, "RYGEL_OBJECT_EVENT_TYPE_MODIFIED", "modified"}, {RYGEL_OBJECT_EVENT_TYPE_DELETED, "RYGEL_OBJECT_EVENT_TYPE_DELETED", "deleted"}, {0, NULL, NULL}};
		GType rygel_object_event_type_type_id;
		rygel_object_event_type_type_id = g_enum_register_static ("RygelObjectEventType", values);
		g_once_init_leave (&rygel_object_event_type_type_id__volatile, rygel_object_event_type_type_id);
	}
	return rygel_object_event_type_type_id__volatile;
}


/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = child_count;
	self = (RygelMediaContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", _tmp3_, NULL);
	return self;
}


/**
     * Create a root media container with the specified details,
     * with no parent container, and with an appropriate ID.
     *
     * @param title See the title property of the #RygelMediaObject.
     * @param child_count The initially-known number of child items.
     */
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = title;
	_tmp1_ = child_count;
	self = (RygelMediaContainer*) g_object_new (object_type, "id", "0", "parent", NULL, "title", _tmp0_, "child-count", _tmp1_, NULL);
	return self;
}


static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	rygel_media_container_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
}


static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
	rygel_media_container_on_sub_tree_updates_finished (self, _sender, sub_tree_root);
}


static void rygel_media_container_real_constructed (GObject* base) {
	RygelMediaContainer * self;
	self = (RygelMediaContainer*) base;
	G_OBJECT_CLASS (rygel_media_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject));
	rygel_media_container_set_empty_child_count (self, 0);
	self->update_id = (guint32) 0;
	self->storage_used = (gint64) (-1);
	self->total_deleted_child_count = (gint64) 0;
	rygel_media_object_set_upnp_class ((RygelMediaObject*) self, RYGEL_MEDIA_CONTAINER_UPNP_CLASS);
	rygel_media_container_set_create_mode_enabled (self, FALSE);
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
	g_signal_connect_object (self, "sub-tree-updates-finished", (GCallback) _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
}


void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
}


RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
}


/**
     * This method should be called each time this container is updated.
     *
     * For instance, this should be called if there are metadata changes
     * for this container, if items under it are removed or added, if
     * there are metadata changes to items under it, etc.
     *
     * If sub_tree_update is true then the caller should later emit the 
     * sub_tree_updates_finished signal on the root container of the sub-tree
     * that was updated.
     *
     * It will eventually result in the server emitting a UPnP LastChange event,
     * though that may be for a batch of these calls.
     *
     * See the #RygelMediaContainer::container_updated signal.
     *
     * @param object The object that has changed, or null to mean the container itself.
     * @param event_type This describes what actually happened to the object.
     * @param sub_tree_update Whether the modification is part of a sub-tree update.
     */
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp3_ = NULL;
	RygelObjectEventType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = object;
	if (_tmp1_ != NULL) {
		RygelMediaObject* _tmp2_ = NULL;
		_tmp2_ = object;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = (RygelMediaObject*) self;
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = event_type;
	_tmp5_ = sub_tree_update;
	g_signal_emit_by_name (self, "container-updated", self, _tmp3_, _tmp4_, _tmp5_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteContainer* didl_container = NULL;
	RygelSerializer* _tmp0_ = NULL;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
	GUPnPDIDLLiteContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	RygelMediaContainer* _tmp4_ = NULL;
	GUPnPDIDLLiteContainer* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GUPnPDIDLLiteContainer* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GUPnPDIDLLiteContainer* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GUPnPDIDLLiteContainer* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GUPnPDIDLLiteContainer* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	RygelHTTPServer* _tmp58_ = NULL;
	GUPnPDIDLLiteContainer* _tmp59_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = serializer;
	_tmp1_ = rygel_serializer_add_container (_tmp0_);
	didl_container = _tmp1_;
	_tmp2_ = didl_container;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (didl_container);
		return result;
	}
	_tmp3_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		GUPnPDIDLLiteContainer* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp5_ = didl_container;
		_tmp6_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp5_, _tmp9_);
	} else {
		GUPnPDIDLLiteContainer* _tmp10_ = NULL;
		_tmp10_ = didl_container;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp10_, "-1");
	}
	_tmp11_ = didl_container;
	_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp13_ = _tmp12_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp11_, _tmp13_);
	_tmp14_ = didl_container;
	_tmp15_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	_tmp16_ = _tmp15_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp14_, _tmp16_);
	_tmp17_ = didl_container;
	_tmp18_ = self->priv->_child_count;
	gupnp_didl_lite_container_set_child_count (_tmp17_, _tmp18_);
	_tmp19_ = didl_container;
	_tmp20_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp21_ = _tmp20_;
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp19_, _tmp21_);
	_tmp22_ = didl_container;
	gupnp_didl_lite_container_set_searchable (_tmp22_, G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER));
	_tmp23_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp24_ = _tmp23_;
	if (g_strcmp0 (_tmp24_, RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER) == 0) {
		GUPnPDIDLLiteContainer* _tmp25_ = NULL;
		gint64 _tmp26_ = 0LL;
		_tmp25_ = didl_container;
		_tmp26_ = self->storage_used;
		gupnp_didl_lite_container_set_storage_used (_tmp25_, _tmp26_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		GUPnPDIDLLiteContainer* _tmp27_ = NULL;
		guint32 _tmp28_ = 0U;
		GUPnPDIDLLiteContainer* _tmp29_ = NULL;
		guint _tmp30_ = 0U;
		guint _tmp31_ = 0U;
		GUPnPDIDLLiteContainer* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		_tmp27_ = didl_container;
		_tmp28_ = self->update_id;
		gupnp_didl_lite_container_set_container_update_id (_tmp27_, (guint) _tmp28_);
		_tmp29_ = didl_container;
		_tmp30_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
		_tmp31_ = _tmp30_;
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp29_, _tmp31_);
		_tmp32_ = didl_container;
		_tmp33_ = self->total_deleted_child_count;
		gupnp_didl_lite_container_set_total_deleted_child_count (_tmp32_, (guint) _tmp33_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
		GUPnPDIDLLiteContainer* _tmp34_ = NULL;
		_tmp34_ = didl_container;
		rygel_searchable_container_serialize_search_parameters (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) self) : NULL, _tmp34_);
	}
	_tmp35_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	_tmp36_ = _tmp35_;
	if (!_tmp36_) {
		GUPnPDIDLLiteContainer* _tmp37_ = NULL;
		GUPnPDIDLLiteContainer* _tmp38_ = NULL;
		GUPnPOCMFlags _tmp39_ = 0;
		GUPnPOCMFlags _tmp40_ = 0;
		RygelWritableContainer* writable = NULL;
		RygelWritableContainer* _tmp41_ = NULL;
		_tmp37_ = didl_container;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp37_, FALSE);
		_tmp38_ = didl_container;
		_tmp39_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		_tmp40_ = _tmp39_;
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp38_, _tmp40_);
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) self) : NULL);
		writable = _tmp41_;
		{
			GeeArrayList* _create_class_list = NULL;
			RygelWritableContainer* _tmp42_ = NULL;
			GeeArrayList* _tmp43_ = NULL;
			GeeArrayList* _tmp44_ = NULL;
			GeeArrayList* _tmp45_ = NULL;
			gint _create_class_size = 0;
			GeeArrayList* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gint _create_class_index = 0;
			_tmp42_ = writable;
			_tmp43_ = rygel_writable_container_get_create_classes (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = _g_object_ref0 (_tmp44_);
			_create_class_list = _tmp45_;
			_tmp46_ = _create_class_list;
			_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_create_class_size = _tmp48_;
			_create_class_index = -1;
			while (TRUE) {
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gchar* create_class = NULL;
				GeeArrayList* _tmp52_ = NULL;
				gint _tmp53_ = 0;
				gpointer _tmp54_ = NULL;
				GUPnPDIDLLiteContainer* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				_tmp49_ = _create_class_index;
				_create_class_index = _tmp49_ + 1;
				_tmp50_ = _create_class_index;
				_tmp51_ = _create_class_size;
				if (!(_tmp50_ < _tmp51_)) {
					break;
				}
				_tmp52_ = _create_class_list;
				_tmp53_ = _create_class_index;
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, _tmp53_);
				create_class = (gchar*) _tmp54_;
				_tmp55_ = didl_container;
				_tmp56_ = create_class;
				gupnp_didl_lite_container_add_create_class (_tmp55_, _tmp56_);
				_g_free0 (create_class);
			}
			_g_object_unref0 (_create_class_list);
		}
		_g_object_unref0 (writable);
	} else {
		GUPnPDIDLLiteContainer* _tmp57_ = NULL;
		_tmp57_ = didl_container;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp57_, TRUE);
	}
	_tmp58_ = http_server;
	_tmp59_ = didl_container;
	rygel_media_container_add_resources (self, _tmp58_, _tmp59_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (didl_container);
		return NULL;
	}
	result = (GUPnPDIDLLiteObject*) didl_container;
	return result;
}


void rygel_media_container_add_resources (RygelMediaContainer* self, RygelHTTPServer* http_server, GUPnPDIDLLiteContainer* didl_container, GError** error) {
	RygelHTTPItemURI* uri = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPItemURI* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteContainer* _tmp3_ = NULL;
	RygelHTTPItemURI* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	RygelHTTPServer* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GUPnPDIDLLiteResource* _tmp10_ = NULL;
	GUPnPDIDLLiteResource* _tmp11_ = NULL;
	GUPnPDIDLLiteResource* _tmp12_ = NULL;
	RygelHTTPServer* _tmp19_ = NULL;
	RygelHTTPItemURI* _tmp20_ = NULL;
	RygelHTTPItemURI* _tmp21_ = NULL;
	GUPnPDIDLLiteResource* _tmp22_ = NULL;
	GUPnPDIDLLiteContainer* _tmp23_ = NULL;
	RygelHTTPItemURI* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RygelHTTPServer* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GUPnPDIDLLiteResource* _tmp30_ = NULL;
	GUPnPDIDLLiteResource* _tmp31_ = NULL;
	GUPnPDIDLLiteResource* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (http_server != NULL);
	g_return_if_fail (didl_container != NULL);
	_tmp0_ = http_server;
	_tmp1_ = rygel_http_item_uri_new ((RygelMediaObject*) self, _tmp0_, -1, -1, NULL, "DIDL_S");
	uri = _tmp1_;
	_tmp2_ = uri;
	rygel_http_item_uri_set_extension (_tmp2_, "xml");
	_tmp3_ = didl_container;
	_tmp4_ = uri;
	_tmp5_ = rygel_http_item_uri_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = http_server;
	_tmp8_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_media_object_add_resource ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp3_, _tmp6_, _tmp9_, NULL, &_inner_error_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	res = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (uri);
		return;
	}
	_tmp12_ = res;
	if (_tmp12_ != NULL) {
		GUPnPDIDLLiteResource* _tmp13_ = NULL;
		GUPnPProtocolInfo* _tmp14_ = NULL;
		GUPnPProtocolInfo* _tmp15_ = NULL;
		GUPnPDIDLLiteResource* _tmp16_ = NULL;
		GUPnPProtocolInfo* _tmp17_ = NULL;
		GUPnPProtocolInfo* _tmp18_ = NULL;
		_tmp13_ = res;
		_tmp14_ = gupnp_didl_lite_resource_get_protocol_info (_tmp13_);
		_tmp15_ = _tmp14_;
		gupnp_protocol_info_set_mime_type (_tmp15_, "text/xml");
		_tmp16_ = res;
		_tmp17_ = gupnp_didl_lite_resource_get_protocol_info (_tmp16_);
		_tmp18_ = _tmp17_;
		gupnp_protocol_info_set_dlna_profile (_tmp18_, "DIDL_S");
	}
	_tmp19_ = http_server;
	_tmp20_ = rygel_http_item_uri_new ((RygelMediaObject*) self, _tmp19_, -1, -1, NULL, "M3U");
	_g_object_unref0 (uri);
	uri = _tmp20_;
	_tmp21_ = uri;
	rygel_http_item_uri_set_extension (_tmp21_, "m3u");
	_tmp23_ = didl_container;
	_tmp24_ = uri;
	_tmp25_ = rygel_http_item_uri_to_string (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = http_server;
	_tmp28_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = rygel_media_object_add_resource ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp23_, _tmp26_, _tmp29_, NULL, &_inner_error_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	_tmp22_ = _tmp31_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (res);
		_g_object_unref0 (uri);
		return;
	}
	_g_object_unref0 (res);
	res = _tmp22_;
	_tmp32_ = res;
	if (_tmp32_ != NULL) {
		GUPnPDIDLLiteResource* _tmp33_ = NULL;
		GUPnPProtocolInfo* _tmp34_ = NULL;
		GUPnPProtocolInfo* _tmp35_ = NULL;
		_tmp33_ = res;
		_tmp34_ = gupnp_didl_lite_resource_get_protocol_info (_tmp33_);
		_tmp35_ = _tmp34_;
		gupnp_protocol_info_set_mime_type (_tmp35_, "audio/x-mpegurl");
	}
	_g_object_unref0 (res);
	_g_object_unref0 (uri);
}


static GUPnPDIDLLiteResource* rygel_media_container_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteResource* result = NULL;
	gint _tmp0_ = 0;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPDIDLLiteResource* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp11_ = NULL;
	GUPnPProtocolInfo* _tmp12_ = NULL;
	GUPnPProtocolInfo* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPProtocolInfo* _tmp15_ = NULL;
	GUPnPDIDLLiteResource* _tmp16_ = NULL;
	GUPnPProtocolInfo* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) base;
	g_return_val_if_fail (didl_object != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = self->priv->_child_count;
	if (_tmp0_ <= 0) {
		gpointer _tmp1_ = NULL;
		GUPnPDIDLLiteResource* _tmp2_ = NULL;
		_tmp1_ = NULL;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gupnp_didl_lite_resource_get_type ()) ? ((GUPnPDIDLLiteResource*) _tmp1_) : NULL);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = didl_object;
	_tmp4_ = uri;
	_tmp5_ = protocol;
	_tmp6_ = import_uri;
	_tmp7_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_container_parent_class)->add_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp3_, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
	res = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp8_ = uri;
	if (_tmp8_ != NULL) {
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = res;
		_tmp10_ = uri;
		gupnp_didl_lite_resource_set_uri (_tmp9_, _tmp10_);
	}
	_tmp11_ = gupnp_protocol_info_new ();
	protocol_info = _tmp11_;
	_tmp12_ = protocol_info;
	gupnp_protocol_info_set_mime_type (_tmp12_, "");
	_tmp13_ = protocol_info;
	_tmp14_ = protocol;
	gupnp_protocol_info_set_protocol (_tmp13_, _tmp14_);
	_tmp15_ = protocol_info;
	gupnp_protocol_info_set_dlna_flags (_tmp15_, ((GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
	_tmp16_ = res;
	_tmp17_ = protocol_info;
	gupnp_didl_lite_resource_set_protocol_info (_tmp16_, _tmp17_);
	result = res;
	_g_object_unref0 (protocol_info);
	return result;
}


/**
     * The handler for the container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container The container that emitted the signal
     * @param updated_container The container that just got updated
     */
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (updated_container != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaContainer* _tmp3_ = NULL;
		RygelMediaContainer* _tmp4_ = NULL;
		RygelMediaObject* _tmp5_ = NULL;
		RygelObjectEventType _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = updated_container;
		_tmp5_ = object;
		_tmp6_ = event_type;
		_tmp7_ = sub_tree_update;
		g_signal_emit_by_name (_tmp3_, "container-updated", _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	}
}


static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaObject* sub_tree_root) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sub_tree_root != NULL);
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaContainer* _tmp3_ = NULL;
		RygelMediaObject* _tmp4_ = NULL;
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = sub_tree_root;
		g_signal_emit_by_name (_tmp3_, "sub-tree-updates-finished", _tmp4_);
	}
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


void rygel_media_container_check_search_expression (RygelMediaContainer* self, RygelSearchExpression* expression) {
	gboolean _tmp0_ = FALSE;
	RygelSearchExpression* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	rygel_media_container_set_create_mode_enabled (self, FALSE);
	_tmp1_ = expression;
	if (_tmp1_ != NULL) {
		RygelSearchExpression* _tmp2_ = NULL;
		_tmp2_ = expression;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_RELATIONAL_EXPRESSION);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		RygelRelationalExpression* relational_exp = NULL;
		RygelSearchExpression* _tmp4_ = NULL;
		RygelRelationalExpression* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		RygelRelationalExpression* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp4_ = expression;
		_tmp5_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp4_) : NULL);
		relational_exp = _tmp5_;
		_tmp7_ = relational_exp;
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->op;
		if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp8_)) == GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM) {
			RygelRelationalExpression* _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
			_tmp9_ = relational_exp;
			_tmp10_ = ((RygelSearchExpression*) _tmp9_)->operand1;
			_tmp6_ = g_strcmp0 ((const gchar*) _tmp10_, "upnp:createClass") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp11_ = _tmp6_;
		if (_tmp11_) {
			rygel_media_container_set_create_mode_enabled (self, TRUE);
		}
		_rygel_search_expression_unref0 (relational_exp);
	}
}


gint rygel_media_container_get_child_count (RygelMediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_child_count;
	result = _tmp0_;
	return result;
}


void rygel_media_container_set_child_count (RygelMediaContainer* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_child_count = _tmp0_;
	g_object_notify ((GObject *) self, "child-count");
}


gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_empty_child_count;
	result = _tmp0_;
	return result;
}


void rygel_media_container_set_empty_child_count (RygelMediaContainer* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_empty_child_count = _tmp0_;
	g_object_notify ((GObject *) self, "empty-child-count");
}


gint rygel_media_container_get_all_child_count (RygelMediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_child_count;
	_tmp1_ = self->priv->_empty_child_count;
	result = _tmp0_ + _tmp1_;
	return result;
}


gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_create_mode_enabled;
	result = _tmp0_;
	return result;
}


void rygel_media_container_set_create_mode_enabled (RygelMediaContainer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_create_mode_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "create-mode-enabled");
}


const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sort_criteria;
	result = _tmp0_;
	return result;
}


void rygel_media_container_set_sort_criteria (RygelMediaContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sort_criteria);
	self->priv->_sort_criteria = _tmp1_;
	g_object_notify ((GObject *) self, "sort-criteria");
}


static GUPnPOCMFlags rygel_media_container_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaContainer* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GUPnPOCMFlags flags = 0;
	gboolean allow_upload = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp5_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean allow_deletion = FALSE;
	gboolean _tmp14_ = FALSE;
	GUPnPOCMFlags _tmp17_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) base;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER)) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = ((RygelMediaObject*) self)->uris;
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == 0;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		result = GUPNP_OCM_FLAGS_NONE;
		return result;
	}
	flags = GUPNP_OCM_FLAGS_NONE;
	allow_upload = TRUE;
	_tmp5_ = rygel_meta_config_get_default ();
	config = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		RygelMetaConfig* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = config;
		_tmp8_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp7_, &_inner_error_);
		_tmp6_ = _tmp8_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		allow_upload = _tmp6_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = allow_upload;
	if (_tmp9_) {
		GUPnPOCMFlags _tmp10_ = 0;
		_tmp10_ = flags;
		flags = _tmp10_ | ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE) | GUPNP_OCM_FLAGS_CREATE_CONTAINER);
	}
	allow_deletion = TRUE;
	{
		gboolean _tmp11_ = FALSE;
		RygelMetaConfig* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = config;
		_tmp13_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp12_, &_inner_error_);
		_tmp11_ = _tmp13_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		allow_deletion = _tmp11_;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = allow_deletion;
	if (_tmp14_) {
		GUPnPOCMFlags _tmp15_ = 0;
		_tmp15_ = flags;
		flags = _tmp15_ | GUPNP_OCM_FLAGS_DESTROYABLE;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
		GUPnPOCMFlags _tmp16_ = 0;
		_tmp16_ = flags;
		flags = _tmp16_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
	}
	_tmp17_ = flags;
	result = _tmp17_;
	_g_object_unref0 (config);
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaContainerPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_media_container_real_constructed;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_container_real_serialize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->add_resource = rygel_media_container_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_container_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_CHILD_COUNT, g_param_spec_int ("child-count", "child-count", "child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT, g_param_spec_int ("empty-child-count", "empty-child-count", "empty-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT, g_param_spec_int ("all-child-count", "all-child-count", "all-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED, g_param_spec_boolean ("create-mode-enabled", "create-mode-enabled", "create-mode-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_SORT_CRITERIA, g_param_spec_string ("sort-criteria", "sort-criteria", "sort-criteria", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The container_updated signal is emitted if a child container under the
	     * tree of this container has been updated. The object parameter is set to
	     * the MediaObject that is the source of the container update. Note that
	     * it may even be set to the container itself.
	     *
	     * @see rygel_media_container_updated().
	     *
	     * @param container The child container that has been updated.
	     * @param object The object that has changed. This may be the container itself, or a child item.
	     * @param event_type This describes what actually happened to the object.
	     * @param sub_tree_update Whether the modification is part of a sub-tree update. See the #RygelMediaContainer::sub_tree_updates_finished signal.
	     */
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN, G_TYPE_NONE, 4, RYGEL_TYPE_MEDIA_CONTAINER, RYGEL_TYPE_MEDIA_OBJECT, RYGEL_TYPE_OBJECT_EVENT_TYPE, G_TYPE_BOOLEAN);
	/**
	     * The sub_tree_updates_finished signal is emitted when all of
	     * the sub-tree operations are finished.
	     * See the #RygelMediaContainer::container_updated signal.
	     *
	     * @param sub_tree_root - root of a sub-tree where all operations
	     * were performed.
	     */
	g_signal_new ("sub_tree_updates_finished", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
	gchar* _tmp0_ = NULL;
	self->priv = RYGEL_MEDIA_CONTAINER_GET_PRIVATE (self);
	_tmp0_ = g_strdup (RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA);
	self->priv->_sort_criteria = _tmp0_;
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	_g_free0 (self->priv->_sort_criteria);
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


/**
 * This is a container (folder) for media items and child containers.
 *
 * It provides a basic serialization implementation (to DIDLLiteWriter).
 *
 * A derived class should provide a working implementation of get_children
 * and should emit the container_updated signal.
 *
 * When used as a root container, you may wish to use the variables, such as
 * REALNAME, in in the title. See the title property of the #RygelMediaObject.
 *
 * If the container should support UPnP search operations then you also implement
 * the #RygelSearchableContainer interface.
 *
 * If the container should be writable, meaning that it allows adding (via upload),
 * removal and editing of items then you should also implement the #RygelWritableContainer
 * interface.
 *
 * If the container should support the change tracking profile of the UPnP
 * ContentDirectory:3 specification then you should also implement the 
 * #RygelTrackableContainer interface.
 *
 * The #RygelSimpleContainer class contains a simple memory-based container
 * implementation, but most real-world uses will require custom container
 * implementations.
 */
GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_CHILD_COUNT:
		g_value_set_int (value, rygel_media_container_get_child_count (self));
		break;
		case RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT:
		g_value_set_int (value, rygel_media_container_get_empty_child_count (self));
		break;
		case RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT:
		g_value_set_int (value, rygel_media_container_get_all_child_count (self));
		break;
		case RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED:
		g_value_set_boolean (value, rygel_media_container_get_create_mode_enabled (self));
		break;
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA:
		g_value_set_string (value, rygel_media_container_get_sort_criteria (self));
		break;
		case RYGEL_MEDIA_CONTAINER_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_CHILD_COUNT:
		rygel_media_container_set_child_count (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT:
		rygel_media_container_set_empty_child_count (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED:
		rygel_media_container_set_create_mode_enabled (self, g_value_get_boolean (value));
		break;
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA:
		rygel_media_container_set_sort_criteria (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



