/* rygel-media-device.c generated by valac 0.21.1, the Vala compiler
 * generated from rygel-media-device.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_DEVICE_CONTEXT (rygel_device_context_get_type ())
#define RYGEL_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext))
#define RYGEL_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))
#define RYGEL_IS_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_IS_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_DEVICE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))

typedef struct _RygelDeviceContext RygelDeviceContext;
typedef struct _RygelDeviceContextClass RygelDeviceContextClass;
typedef struct _RygelDeviceContextPrivate RygelDeviceContextPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_device_context_unref0(var) ((var == NULL) ? NULL : (var = (rygel_device_context_unref (var), NULL)))
typedef struct _RygelParamSpecDeviceContext RygelParamSpecDeviceContext;

#define RYGEL_TYPE_MEDIA_DEVICE (rygel_media_device_get_type ())
#define RYGEL_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice))
#define RYGEL_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))
#define RYGEL_IS_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_IS_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_MEDIA_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))

typedef struct _RygelMediaDevice RygelMediaDevice;
typedef struct _RygelMediaDeviceClass RygelMediaDeviceClass;
typedef struct _RygelMediaDevicePrivate RygelMediaDevicePrivate;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelDeviceContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDeviceContextPrivate * priv;
	RygelRootDevice* device;
	RygelRootDeviceFactory* factory;
	GUPnPContext* context;
};

struct _RygelDeviceContextClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDeviceContext *self);
};

struct _RygelParamSpecDeviceContext {
	GParamSpec parent_instance;
};

struct _RygelMediaDevice {
	GObject parent_instance;
	RygelMediaDevicePrivate * priv;
};

struct _RygelMediaDeviceClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelMediaDevicePrivate {
	GeeArrayList* interfaces;
	GeeHashMap* contexts;
	GeeHashMap* devices;
	GUPnPContextManager* manager;
	RygelPlugin* _plugin;
	gchar* _title;
	RygelPluginCapabilities _capabilities;
};


static gpointer rygel_device_context_parent_class = NULL;
static gpointer rygel_media_device_parent_class = NULL;

gpointer rygel_device_context_ref (gpointer instance);
void rygel_device_context_unref (gpointer instance);
GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_device_context (GValue* value, gpointer v_object);
void rygel_value_take_device_context (GValue* value, gpointer v_object);
gpointer rygel_value_get_device_context (const GValue* value);
GType rygel_device_context_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DEVICE_CONTEXT_DUMMY_PROPERTY
};
GType rygel_plugin_get_type (void) G_GNUC_CONST;
RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
static void rygel_device_context_finalize (RygelDeviceContext* obj);
GType rygel_media_device_get_type (void) G_GNUC_CONST;
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevicePrivate))
enum  {
	RYGEL_MEDIA_DEVICE_DUMMY_PROPERTY,
	RYGEL_MEDIA_DEVICE_PLUGIN,
	RYGEL_MEDIA_DEVICE_TITLE,
	RYGEL_MEDIA_DEVICE_CAPABILITIES
};
static void rygel_media_device_real_constructed (GObject* base);
static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface);
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface);
GList* rygel_media_device_get_interfaces (RygelMediaDevice* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self);
RygelMediaDevice* rygel_media_device_construct (GType object_type);
void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value);
const gchar* rygel_media_device_get_title (RygelMediaDevice* self);
static void rygel_media_device_set_title (RygelMediaDevice* self, const gchar* value);
RygelPluginCapabilities rygel_media_device_get_capabilities (RygelMediaDevice* self);
static void rygel_media_device_set_capabilities (RygelMediaDevice* self, RygelPluginCapabilities value);
static void rygel_media_device_finalize (GObject* obj);
static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error) {
	RygelDeviceContext* self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	RygelRootDeviceFactory* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	RygelRootDeviceFactory* _tmp4_ = NULL;
	RygelRootDevice* _tmp5_ = NULL;
	RygelRootDeviceFactory* _tmp6_ = NULL;
	RygelPlugin* _tmp7_ = NULL;
	RygelRootDevice* _tmp8_ = NULL;
	RygelRootDevice* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (RygelDeviceContext*) g_type_create_instance (object_type);
	_tmp0_ = context;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->context);
	self->context = _tmp1_;
	_tmp3_ = context;
	_tmp4_ = rygel_root_device_factory_new (_tmp3_, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_rygel_device_context_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->factory);
	self->factory = _tmp2_;
	_tmp6_ = self->factory;
	_tmp7_ = plugin;
	_tmp8_ = rygel_root_device_factory_create (_tmp6_, _tmp7_, &_inner_error_);
	_tmp5_ = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_rygel_device_context_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->device);
	self->device = _tmp5_;
	_tmp9_ = self->device;
	gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp9_, TRUE);
	return self;
}


RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error) {
	return rygel_device_context_construct (RYGEL_TYPE_DEVICE_CONTEXT, context, plugin, error);
}


static void rygel_value_device_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_device_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_device_context_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_device_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_device_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_device_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_device_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelDeviceContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_device_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_device_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelDeviceContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_device_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecDeviceContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_device_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_device_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_device_context_unref (old);
	}
}


void rygel_value_take_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_device_context_unref (old);
	}
}


static void rygel_device_context_class_init (RygelDeviceContextClass * klass) {
	rygel_device_context_parent_class = g_type_class_peek_parent (klass);
	RYGEL_DEVICE_CONTEXT_CLASS (klass)->finalize = rygel_device_context_finalize;
}


static void rygel_device_context_instance_init (RygelDeviceContext * self) {
	self->ref_count = 1;
}


static void rygel_device_context_finalize (RygelDeviceContext* obj) {
	RygelDeviceContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext);
	_g_object_unref0 (self->device);
	_g_object_unref0 (self->factory);
	_g_object_unref0 (self->context);
}


GType rygel_device_context_get_type (void) {
	static volatile gsize rygel_device_context_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_device_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_device_context_init, rygel_value_device_context_free_value, rygel_value_device_context_copy_value, rygel_value_device_context_peek_pointer, "p", rygel_value_device_context_collect_value, "p", rygel_value_device_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDeviceContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_device_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDeviceContext), 0, (GInstanceInitFunc) rygel_device_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_device_context_type_id;
		rygel_device_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDeviceContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_device_context_type_id__volatile, rygel_device_context_type_id);
	}
	return rygel_device_context_type_id__volatile;
}


gpointer rygel_device_context_ref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_device_context_unref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_DEVICE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
	rygel_media_device_on_context_available (self, context);
}


static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
	rygel_media_device_on_context_unavailable (self, context);
}


static void rygel_media_device_real_constructed (GObject* base) {
	RygelMediaDevice * self;
	GUPnPContextManager* _tmp0_ = NULL;
	GUPnPContextManager* _tmp1_ = NULL;
	GUPnPContextManager* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	self = (RygelMediaDevice*) base;
	G_OBJECT_CLASS (rygel_media_device_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gupnp_context_manager_create ((guint) 0);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	_tmp1_ = self->priv->manager;
	g_signal_connect_object (_tmp1_, "context-available", (GCallback) _rygel_media_device_on_context_available_gupnp_context_manager_context_available, self, 0);
	_tmp2_ = self->priv->manager;
	g_signal_connect_object (_tmp2_, "context-unavailable", (GCallback) _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->interfaces);
	self->priv->interfaces = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, gupnp_context_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->contexts);
	self->priv->contexts = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_DEVICE_CONTEXT, (GBoxedCopyFunc) rygel_device_context_ref, rygel_device_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp5_;
}


/**
     * Add a network interface the device should listen on.
     *
     * If the network interface is not already up, it will be used as soon as
     * it's ready. Otherwise it's used right away.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = iface;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		GeeArrayList* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GeeHashMap* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp3_ = self->priv->interfaces;
		_tmp4_ = iface;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
		_tmp5_ = self->priv->contexts;
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = iface;
		_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp8_);
		if (_tmp11_) {
			GeeHashMap* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			GUPnPContext* _tmp15_ = NULL;
			_tmp12_ = self->priv->contexts;
			_tmp13_ = iface;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
			_tmp15_ = (GUPnPContext*) _tmp14_;
			rygel_media_device_on_context_available (self, _tmp15_);
			_g_object_unref0 (_tmp15_);
		}
	}
}


/**
     * Remove a previously added network interface from the device.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
	GeeSet* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = iface;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->interfaces;
	_tmp4_ = iface;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->devices;
	_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = iface;
	_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp8_);
	if (_tmp11_) {
		GeeHashMap* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GeeHashMap* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gpointer _tmp16_ = NULL;
		RygelDeviceContext* _tmp17_ = NULL;
		GUPnPContext* _tmp18_ = NULL;
		GeeHashMap* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp12_ = self->priv->contexts;
		_tmp13_ = iface;
		_tmp14_ = self->priv->devices;
		_tmp15_ = iface;
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
		_tmp17_ = (RygelDeviceContext*) _tmp16_;
		_tmp18_ = _tmp17_->context;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp18_);
		_rygel_device_context_unref0 (_tmp17_);
		_tmp19_ = self->priv->devices;
		_tmp20_ = iface;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp20_, NULL);
	}
}


/**
     * Get a list of the network interfaces the device is currently allowed
     * to use.
     *
     * @return list of interface names.
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


GList* rygel_media_device_get_interfaces (RygelMediaDevice* self) {
	GList* result = NULL;
	GList* _result_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		GeeArrayList* _iface_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _iface_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _iface_index = 0;
		_tmp0_ = self->priv->interfaces;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_iface_list = _tmp1_;
		_tmp2_ = _iface_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_iface_size = _tmp4_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gchar* iface = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp5_ = _iface_index;
			_iface_index = _tmp5_ + 1;
			_tmp6_ = _iface_index;
			_tmp7_ = _iface_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _iface_list;
			_tmp9_ = _iface_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			iface = (gchar*) _tmp10_;
			_tmp11_ = iface;
			_tmp12_ = g_strdup (_tmp11_);
			_result_ = g_list_prepend (_result_, _tmp12_);
			_g_free0 (iface);
		}
		_g_object_unref0 (_iface_list);
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	return result;
}


static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context) {
	GeeArrayList* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = context;
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		{
			RygelDeviceContext* ctx = NULL;
			GUPnPContext* _tmp5_ = NULL;
			RygelPlugin* _tmp6_ = NULL;
			RygelDeviceContext* _tmp7_ = NULL;
			GeeHashMap* _tmp8_ = NULL;
			GUPnPContext* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			RygelDeviceContext* _tmp12_ = NULL;
			_tmp5_ = context;
			_tmp6_ = self->priv->_plugin;
			_tmp7_ = rygel_device_context_new (_tmp5_, _tmp6_, &_inner_error_);
			ctx = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch36_g_error;
			}
			_tmp8_ = self->priv->devices;
			_tmp9_ = context;
			_tmp10_ = gssdp_client_get_interface ((GSSDPClient*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = ctx;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
			_rygel_device_context_unref0 (ctx);
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = _error_;
			_tmp14_ = _tmp13_->message;
			g_warning ("rygel-media-device.vala:131: Failed to create device context: %s", _tmp14_);
			_g_error_free0 (_error_);
		}
		__finally36:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		GeeHashMap* _tmp15_ = NULL;
		GUPnPContext* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GUPnPContext* _tmp19_ = NULL;
		_tmp15_ = self->priv->contexts;
		_tmp16_ = context;
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = context;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
	}
}


static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context) {
	GeeHashMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = context;
	_tmp5_ = gssdp_client_get_interface ((GSSDPClient*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp3_);
	if (_tmp8_) {
		GeeHashMap* _tmp9_ = NULL;
		GUPnPContext* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp9_ = self->priv->devices;
		_tmp10_ = context;
		_tmp11_ = gssdp_client_get_interface ((GSSDPClient*) _tmp10_);
		_tmp12_ = _tmp11_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp12_, NULL);
	} else {
		GeeHashMap* _tmp13_ = NULL;
		GUPnPContext* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp13_ = self->priv->contexts;
		_tmp14_ = context;
		_tmp15_ = gssdp_client_get_interface ((GSSDPClient*) _tmp14_);
		_tmp16_ = _tmp15_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp16_, NULL);
	}
}


RygelMediaDevice* rygel_media_device_construct (GType object_type) {
	RygelMediaDevice * self = NULL;
	self = (RygelMediaDevice*) g_object_new (object_type, NULL);
	return self;
}


RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self) {
	RygelPlugin* result;
	RygelPlugin* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin;
	result = _tmp0_;
	return result;
}


void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value) {
	RygelPlugin* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_plugin);
	self->priv->_plugin = _tmp1_;
	g_object_notify ((GObject *) self, "plugin");
}


const gchar* rygel_media_device_get_title (RygelMediaDevice* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void rygel_media_device_set_title (RygelMediaDevice* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


RygelPluginCapabilities rygel_media_device_get_capabilities (RygelMediaDevice* self) {
	RygelPluginCapabilities result;
	RygelPluginCapabilities _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_capabilities;
	result = _tmp0_;
	return result;
}


static void rygel_media_device_set_capabilities (RygelMediaDevice* self, RygelPluginCapabilities value) {
	RygelPluginCapabilities _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_capabilities = _tmp0_;
	g_object_notify ((GObject *) self, "capabilities");
}


static void rygel_media_device_class_init (RygelMediaDeviceClass * klass) {
	rygel_media_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaDevicePrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_media_device_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_PLUGIN, g_param_spec_object ("plugin", "plugin", "plugin", RYGEL_TYPE_PLUGIN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_CAPABILITIES, g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, RYGEL_PLUGIN_CAPABILITIES_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_media_device_instance_init (RygelMediaDevice * self) {
	self->priv = RYGEL_MEDIA_DEVICE_GET_PRIVATE (self);
	self->priv->_capabilities = RYGEL_PLUGIN_CAPABILITIES_NONE;
}


static void rygel_media_device_finalize (GObject* obj) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
	_g_object_unref0 (self->priv->interfaces);
	_g_object_unref0 (self->priv->contexts);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->_plugin);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_device_parent_class)->finalize (obj);
}


/**
 * This is a base class for implementations of UPnP devices,
 * such as RygelMediaServer and RygelMediaRenderer.
 *
 * Use rygel_media_device_add_interface() to allow this
 * device to respond to UPnP messages on a network interface.
 */
GType rygel_media_device_get_type (void) {
	static volatile gsize rygel_media_device_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDevice), 0, (GInstanceInitFunc) rygel_media_device_instance_init, NULL };
		GType rygel_media_device_type_id;
		rygel_media_device_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDevice", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_device_type_id__volatile, rygel_media_device_type_id);
	}
	return rygel_media_device_type_id__volatile;
}


static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
	switch (property_id) {
		case RYGEL_MEDIA_DEVICE_PLUGIN:
		g_value_set_object (value, rygel_media_device_get_plugin (self));
		break;
		case RYGEL_MEDIA_DEVICE_TITLE:
		g_value_set_string (value, rygel_media_device_get_title (self));
		break;
		case RYGEL_MEDIA_DEVICE_CAPABILITIES:
		g_value_set_flags (value, rygel_media_device_get_capabilities (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
	switch (property_id) {
		case RYGEL_MEDIA_DEVICE_PLUGIN:
		rygel_media_device_set_plugin (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_DEVICE_TITLE:
		rygel_media_device_set_title (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_DEVICE_CAPABILITIES:
		rygel_media_device_set_capabilities (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



