/* world.c generated by valac 0.21.1.24-dd24, the Vala compiler
 * generated from world.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgweather/gweather.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>


#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;
typedef struct _ClocksWorldItemPrivate ClocksWorldItemPrivate;
#define __vala_GWeatherLocation_free0(var) ((var == NULL) ? NULL : (var = (_vala_GWeatherLocation_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GWeatherTimezone_free0(var) ((var == NULL) ? NULL : (var = (_vala_GWeatherTimezone_free (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_WORLD_TYPE_LOCATION_DIALOG (clocks_world_location_dialog_get_type ())
#define CLOCKS_WORLD_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog))
#define CLOCKS_WORLD_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))

typedef struct _ClocksWorldLocationDialog ClocksWorldLocationDialog;
typedef struct _ClocksWorldLocationDialogClass ClocksWorldLocationDialogClass;
typedef struct _ClocksWorldLocationDialogPrivate ClocksWorldLocationDialogPrivate;

#define CLOCKS_WORLD_TYPE_STANDALONE_PANEL (clocks_world_standalone_panel_get_type ())
#define CLOCKS_WORLD_STANDALONE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel))
#define CLOCKS_WORLD_STANDALONE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanelClass))
#define CLOCKS_WORLD_IS_STANDALONE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_STANDALONE_PANEL))
#define CLOCKS_WORLD_IS_STANDALONE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_STANDALONE_PANEL))
#define CLOCKS_WORLD_STANDALONE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanelClass))

typedef struct _ClocksWorldStandalonePanel ClocksWorldStandalonePanel;
typedef struct _ClocksWorldStandalonePanelClass ClocksWorldStandalonePanelClass;
typedef struct _ClocksWorldStandalonePanelPrivate ClocksWorldStandalonePanelPrivate;

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())

#define CLOCKS_WORLD_TYPE_MAIN_PANEL (clocks_world_main_panel_get_type ())
#define CLOCKS_WORLD_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel))
#define CLOCKS_WORLD_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanelClass))
#define CLOCKS_WORLD_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_MAIN_PANEL))
#define CLOCKS_WORLD_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_MAIN_PANEL))
#define CLOCKS_WORLD_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanelClass))

typedef struct _ClocksWorldMainPanel ClocksWorldMainPanel;
typedef struct _ClocksWorldMainPanelClass ClocksWorldMainPanelClass;
typedef struct _ClocksWorldMainPanelPrivate ClocksWorldMainPanelPrivate;

#define CLOCKS_TYPE_CONTENT_VIEW (clocks_content_view_get_type ())
#define CLOCKS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView))
#define CLOCKS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))
#define CLOCKS_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))

typedef struct _ClocksContentView ClocksContentView;
typedef struct _ClocksContentViewClass ClocksContentViewClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block2Data Block2Data;

#define CLOCKS_HEADER_BAR_TYPE_MODE (clocks_header_bar_mode_get_type ())
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*get_thumb_properties) (ClocksContentItem* self, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksWorldItem {
	GObject parent_instance;
	ClocksWorldItemPrivate * priv;
};

struct _ClocksWorldItemClass {
	GObjectClass parent_class;
};

struct _ClocksWorldItemPrivate {
	GWeatherLocation* _location;
	gchar* _name;
	GTimeZone* time_zone;
	GDateTime* local_time;
	GDateTime* date_time;
	GWeatherInfo* weather_info;
};

struct _ClocksWorldLocationDialog {
	GtkDialog parent_instance;
	ClocksWorldLocationDialogPrivate * priv;
};

struct _ClocksWorldLocationDialogClass {
	GtkDialogClass parent_class;
};

struct _ClocksWorldLocationDialogPrivate {
	GWeatherLocationEntry* location_entry;
};

struct _ClocksWorldStandalonePanel {
	GtkEventBox parent_instance;
	ClocksWorldStandalonePanelPrivate * priv;
};

struct _ClocksWorldStandalonePanelClass {
	GtkEventBoxClass parent_class;
};

struct _ClocksWorldStandalonePanelPrivate {
	ClocksWorldItem* _location;
	GtkLabel* time_label;
	GtkLabel* day_label;
	GtkLabel* sunrise_label;
	GtkLabel* sunset_label;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

struct _ClocksWorldMainPanel {
	GtkStack parent_instance;
	ClocksWorldMainPanelPrivate * priv;
};

struct _ClocksWorldMainPanelClass {
	GtkStackClass parent_class;
};

struct _ClocksWorldMainPanelPrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	GList* locations;
	GSettings* settings;
	GtkButton* new_button;
	GtkButton* back_button;
	GdkPixbuf* day_pixbuf;
	GdkPixbuf* night_pixbuf;
	ClocksContentView* content_view;
	ClocksWorldStandalonePanel* standalone;
};

struct _Block2Data {
	int _ref_count_;
	ClocksWorldMainPanel * self;
	ClocksHeaderBar* header_bar;
};

typedef enum  {
	CLOCKS_HEADER_BAR_MODE_NORMAL,
	CLOCKS_HEADER_BAR_MODE_SELECTION,
	CLOCKS_HEADER_BAR_MODE_STANDALONE
} ClocksHeaderBarMode;


static gpointer clocks_world_item_parent_class = NULL;
static GdkPixbuf* clocks_world_item_day_pixbuf;
static GdkPixbuf* clocks_world_item_day_pixbuf = NULL;
static GdkPixbuf* clocks_world_item_night_pixbuf;
static GdkPixbuf* clocks_world_item_night_pixbuf = NULL;
static ClocksContentItemIface* clocks_world_item_clocks_content_item_parent_iface = NULL;
static gpointer clocks_world_location_dialog_parent_class = NULL;
static gpointer clocks_world_standalone_panel_parent_class = NULL;
static gpointer clocks_world_main_panel_parent_class = NULL;
static ClocksClockIface* clocks_world_main_panel_clocks_clock_parent_iface = NULL;

GType clocks_content_item_get_type (void) G_GNUC_CONST;
GType clocks_world_item_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemPrivate))
enum  {
	CLOCKS_WORLD_ITEM_DUMMY_PROPERTY,
	CLOCKS_WORLD_ITEM_LOCATION,
	CLOCKS_WORLD_ITEM_NAME,
	CLOCKS_WORLD_ITEM_CITY_NAME,
	CLOCKS_WORLD_ITEM_NATION_NAME,
	CLOCKS_WORLD_ITEM_IS_DAYTIME,
	CLOCKS_WORLD_ITEM_SUNRISE_LABEL,
	CLOCKS_WORLD_ITEM_SUNSET_LABEL,
	CLOCKS_WORLD_ITEM_TIME_LABEL,
	CLOCKS_WORLD_ITEM_DAY_LABEL
};
GdkPixbuf* clocks_utils_load_image (const gchar* image);
static void _vala_GWeatherLocation_free (GWeatherLocation* self);
ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location);
static GWeatherTimezone* _vala_GWeatherTimezone_copy (GWeatherTimezone* self);
void clocks_world_item_tick (ClocksWorldItem* self);
static void _vala_GWeatherTimezone_free (GWeatherTimezone* self);
GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST;
ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self);
static void clocks_world_item_real_get_thumb_properties (ClocksContentItem* base, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
gchar* clocks_world_item_get_time_label (ClocksWorldItem* self);
const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self);
gboolean clocks_world_item_get_is_daytime (ClocksWorldItem* self);
void clocks_world_item_serialize (ClocksWorldItem* self, GVariantBuilder* builder);
ClocksWorldItem* clocks_world_item_deserialize (GVariant* location_variant);
static GWeatherLocation* _vala_GWeatherLocation_copy (GWeatherLocation* self);
void clocks_world_item_set_location (ClocksWorldItem* self, GWeatherLocation* value);
gchar* clocks_world_item_get_nation_name (ClocksWorldItem* self);
gchar* clocks_world_item_get_city_name (ClocksWorldItem* self);
gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self);
gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time);
gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self);
static void clocks_world_item_finalize (GObject* obj);
const gchar* clocks_content_item_get_name (ClocksContentItem* self);
static void _vala_clocks_world_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_content_item_set_name (ClocksContentItem* self, const gchar* value);
static void _vala_clocks_world_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_world_location_dialog_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogPrivate))
enum  {
	CLOCKS_WORLD_LOCATION_DIALOG_DUMMY_PROPERTY
};
ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent);
ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type, GtkWindow* parent);
static void clocks_world_location_dialog_icon_released (ClocksWorldLocationDialog* self);
static void _clocks_world_location_dialog_icon_released_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void clocks_world_location_dialog_location_changed (ClocksWorldLocationDialog* self);
static void _clocks_world_location_dialog_location_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
ClocksWorldItem* clocks_world_location_dialog_get_location (ClocksWorldLocationDialog* self);
static void clocks_world_location_dialog_finalize (GObject* obj);
GType clocks_world_standalone_panel_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_STANDALONE_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanelPrivate))
enum  {
	CLOCKS_WORLD_STANDALONE_PANEL_DUMMY_PROPERTY,
	CLOCKS_WORLD_STANDALONE_PANEL_LOCATION
};
ClocksWorldStandalonePanel* clocks_world_standalone_panel_new (void);
ClocksWorldStandalonePanel* clocks_world_standalone_panel_construct (GType object_type);
GtkBuilder* clocks_utils_load_ui (const gchar* ui);
void clocks_world_standalone_panel_update (ClocksWorldStandalonePanel* self);
ClocksWorldItem* clocks_world_standalone_panel_get_location (ClocksWorldStandalonePanel* self);
void clocks_world_standalone_panel_set_location (ClocksWorldStandalonePanel* self, ClocksWorldItem* value);
static void clocks_world_standalone_panel_finalize (GObject* obj);
static void _vala_clocks_world_standalone_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_world_standalone_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_world_main_panel_get_type (void) G_GNUC_CONST;
GType clocks_content_view_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_MAIN_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanelPrivate))
enum  {
	CLOCKS_WORLD_MAIN_PANEL_DUMMY_PROPERTY,
	CLOCKS_WORLD_MAIN_PANEL_LABEL,
	CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR,
	CLOCKS_WORLD_MAIN_PANEL_PANEL_ID
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ClocksWorldMainPanel* clocks_world_main_panel_new (ClocksHeaderBar* header_bar);
ClocksWorldMainPanel* clocks_world_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda18_ (ClocksWorldMainPanel* self);
static void ___lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
ClocksContentView* clocks_content_view_new (GtkWidget* e, ClocksHeaderBar* b);
ClocksContentView* clocks_content_view_construct (GType object_type, GtkWidget* e, ClocksHeaderBar* b);
static void __lambda19_ (ClocksWorldMainPanel* self, GObject* item);
static void ___lambda19__clocks_content_view_item_activated (ClocksContentView* _sender, GObject* item, gpointer self);
static void __lambda20_ (ClocksWorldMainPanel* self);
GList* clocks_content_view_get_selected_items (ClocksContentView* self);
static void clocks_world_main_panel_save (ClocksWorldMainPanel* self);
static void ___lambda20__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self);
static void clocks_world_main_panel_load (ClocksWorldMainPanel* self);
static void __lambda21_ (Block2Data* _data2_);
GType clocks_header_bar_mode_get_type (void) G_GNUC_CONST;
void clocks_header_bar_set_mode (ClocksHeaderBar* self, ClocksHeaderBarMode value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda22_ (ClocksWorldMainPanel* self);
static void ___lambda22__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self);
void clocks_content_view_add_item (ClocksContentView* self, ClocksContentItem* item);
static void clocks_world_main_panel_real_activate_new (ClocksClock* base);
static void __lambda23_ (ClocksWorldMainPanel* self, GtkDialog* dialog, gint response);
static void ___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void clocks_world_main_panel_real_activate_select_all (ClocksClock* base);
void clocks_content_view_select_all (ClocksContentView* self);
static void clocks_world_main_panel_real_activate_select_none (ClocksClock* base);
void clocks_content_view_unselect_all (ClocksContentView* self);
static gboolean clocks_world_main_panel_real_escape_pressed (ClocksClock* base);
gboolean clocks_content_view_escape_pressed (ClocksContentView* self);
static void clocks_world_main_panel_real_update_header_bar (ClocksClock* base);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self);
void clocks_content_view_update_header_bar (ClocksContentView* self);
static void clocks_world_main_panel_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _vala_clocks_world_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
void clocks_clock_set_panel_id (ClocksClock* self, ClocksPanelId value);
static void _vala_clocks_world_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GWeatherLocation_free (GWeatherLocation* self) {
	g_boxed_free (gweather_location_get_type (), self);
}


static GWeatherTimezone* _vala_GWeatherTimezone_copy (GWeatherTimezone* self) {
	return g_boxed_copy (gweather_timezone_get_type (), self);
}


static gpointer __vala_GWeatherTimezone_copy0 (gpointer self) {
	return self ? _vala_GWeatherTimezone_copy (self) : NULL;
}


static void _vala_GWeatherTimezone_free (GWeatherTimezone* self) {
	g_boxed_free (gweather_timezone_get_type (), self);
}


ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location) {
	ClocksWorldItem * self = NULL;
	GWeatherLocation* _tmp0_ = NULL;
	GWeatherTimezone* weather_time_zone = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	GWeatherTimezone* _tmp2_ = NULL;
	GWeatherTimezone* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GTimeZone* _tmp5_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = location;
	self = (ClocksWorldItem*) g_object_new (object_type, "location", _tmp0_, NULL);
	_tmp1_ = location;
	_tmp2_ = gweather_location_get_timezone (_tmp1_);
	_tmp3_ = __vala_GWeatherTimezone_copy0 (_tmp2_);
	weather_time_zone = _tmp3_;
	_tmp4_ = gweather_timezone_get_tzid (weather_time_zone);
	_tmp5_ = g_time_zone_new (_tmp4_);
	_g_time_zone_unref0 (self->priv->time_zone);
	self->priv->time_zone = _tmp5_;
	clocks_world_item_tick (self);
	__vala_GWeatherTimezone_free0 (weather_time_zone);
	return self;
}


ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location) {
	return clocks_world_item_construct (CLOCKS_WORLD_TYPE_ITEM, location);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void clocks_world_item_tick (ClocksWorldItem* self) {
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GTimeZone* _tmp5_ = NULL;
	GDateTime* _tmp6_ = NULL;
	GWeatherLocation* _tmp7_ = NULL;
	GWeatherInfo* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = clocks_utils_wall_clock_get_date_time (wallclock);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	_g_date_time_unref0 (self->priv->local_time);
	self->priv->local_time = _tmp3_;
	_tmp4_ = self->priv->local_time;
	_tmp5_ = self->priv->time_zone;
	_tmp6_ = g_date_time_to_timezone (_tmp4_, _tmp5_);
	_g_date_time_unref0 (self->priv->date_time);
	self->priv->date_time = _tmp6_;
	_tmp7_ = self->priv->_location;
	_tmp8_ = gweather_info_new (_tmp7_, GWEATHER_FORECAST_LIST);
	_g_object_unref0 (self->priv->weather_info);
	self->priv->weather_info = _tmp8_;
	_g_object_unref0 (wallclock);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void clocks_world_item_real_get_thumb_properties (ClocksContentItem* base, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class) {
	ClocksWorldItem * self;
	gchar* _vala_text = NULL;
	gchar* _vala_subtext = NULL;
	GdkPixbuf* _vala_pixbuf = NULL;
	gchar* _vala_css_class = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	self = (ClocksWorldItem*) base;
	_tmp0_ = clocks_world_item_get_time_label (self);
	_tmp1_ = _tmp0_;
	_g_free0 (_vala_text);
	_vala_text = _tmp1_;
	_tmp2_ = clocks_world_item_get_day_label (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_subtext);
	_vala_subtext = _tmp4_;
	_tmp5_ = clocks_world_item_get_is_daytime (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp7_ = clocks_world_item_day_pixbuf;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_vala_pixbuf);
		_vala_pixbuf = _tmp8_;
		_tmp9_ = g_strdup ("light");
		_g_free0 (_vala_css_class);
		_vala_css_class = _tmp9_;
	} else {
		GdkPixbuf* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp10_ = clocks_world_item_night_pixbuf;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (_vala_pixbuf);
		_vala_pixbuf = _tmp11_;
		_tmp12_ = g_strdup ("dark");
		_g_free0 (_vala_css_class);
		_vala_css_class = _tmp12_;
	}
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	if (subtext) {
		*subtext = _vala_subtext;
	} else {
		_g_free0 (_vala_subtext);
	}
	if (pixbuf) {
		*pixbuf = _vala_pixbuf;
	} else {
		_g_object_unref0 (_vala_pixbuf);
	}
	if (css_class) {
		*css_class = _vala_css_class;
	} else {
		_g_free0 (_vala_css_class);
	}
}


void clocks_world_item_serialize (ClocksWorldItem* self, GVariantBuilder* builder) {
	GVariantBuilder* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_ = NULL;
	GWeatherLocation* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariantBuilder* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = g_variant_type_new ("a{sv}");
	_tmp2_ = _tmp1_;
	g_variant_builder_open (_tmp0_, _tmp2_);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = builder;
	_tmp4_ = self->priv->_location;
	_tmp5_ = gweather_location_serialize (_tmp4_);
	g_variant_builder_add (_tmp3_, "{sv}", "location", _tmp5_, NULL);
	_tmp6_ = builder;
	g_variant_builder_close (_tmp6_);
}


static GWeatherLocation* _vala_GWeatherLocation_copy (GWeatherLocation* self) {
	return g_boxed_copy (gweather_location_get_type (), self);
}


static gpointer __vala_GWeatherLocation_copy0 (gpointer self) {
	return self ? _vala_GWeatherLocation_copy (self) : NULL;
}


ClocksWorldItem* clocks_world_item_deserialize (GVariant* location_variant) {
	ClocksWorldItem* result = NULL;
	GWeatherLocation* location = NULL;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp0_ = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	ClocksWorldItem* _tmp21_ = NULL;
	GWeatherLocation* _tmp22_ = NULL;
	g_return_val_if_fail (location_variant != NULL, NULL);
	location = NULL;
	_tmp0_ = gweather_location_get_world ();
	_tmp1_ = __vala_GWeatherLocation_copy0 (_tmp0_);
	world = _tmp1_;
	{
		GVariantIter* _v_it = NULL;
		GVariant* _tmp2_ = NULL;
		GVariantIter* _tmp3_ = NULL;
		GVariant* v = NULL;
		_tmp2_ = location_variant;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		_v_it = _tmp3_;
		while (TRUE) {
			GVariantIter* _tmp4_ = NULL;
			GVariant* _tmp5_ = NULL;
			GVariant* _tmp6_ = NULL;
			gchar* key = NULL;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			_tmp4_ = _v_it;
			_tmp5_ = g_variant_iter_next_value (_tmp4_);
			_g_variant_unref0 (v);
			v = _tmp5_;
			_tmp6_ = v;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = v;
			_tmp8_ = g_variant_get_child_value (_tmp7_, (gsize) 0);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_variant_get_string (_tmp9_, NULL);
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_variant_unref0 (_tmp9_);
			key = _tmp12_;
			_tmp13_ = key;
			if (g_strcmp0 (_tmp13_, "location") == 0) {
				GWeatherLocation* _tmp14_ = NULL;
				GVariant* _tmp15_ = NULL;
				GVariant* _tmp16_ = NULL;
				GVariant* _tmp17_ = NULL;
				GVariant* _tmp18_ = NULL;
				GVariant* _tmp19_ = NULL;
				GWeatherLocation* _tmp20_ = NULL;
				_tmp14_ = world;
				_tmp15_ = v;
				_tmp16_ = g_variant_get_child_value (_tmp15_, (gsize) 1);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_variant_get_child_value (_tmp17_, (gsize) 0);
				_tmp19_ = _tmp18_;
				_tmp20_ = gweather_location_deserialize (_tmp14_, _tmp19_);
				__vala_GWeatherLocation_free0 (location);
				location = _tmp20_;
				_g_variant_unref0 (_tmp19_);
				_g_variant_unref0 (_tmp17_);
			}
			_g_free0 (key);
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	_tmp22_ = location;
	if (_tmp22_ != NULL) {
		GWeatherLocation* _tmp23_ = NULL;
		ClocksWorldItem* _tmp24_ = NULL;
		_tmp23_ = location;
		_tmp24_ = clocks_world_item_new (_tmp23_);
		_g_object_unref0 (_tmp21_);
		_tmp21_ = _tmp24_;
	} else {
		_g_object_unref0 (_tmp21_);
		_tmp21_ = NULL;
	}
	result = _tmp21_;
	__vala_GWeatherLocation_free0 (world);
	__vala_GWeatherLocation_free0 (location);
	return result;
}


GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self) {
	GWeatherLocation* result;
	GWeatherLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void clocks_world_item_set_location (ClocksWorldItem* self, GWeatherLocation* value) {
	GWeatherLocation* _tmp0_ = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __vala_GWeatherLocation_copy0 (_tmp0_);
	__vala_GWeatherLocation_free0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


static const gchar* clocks_world_item_real_get_name (ClocksContentItem* base) {
	const gchar* result;
	ClocksWorldItem* self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp13_ = NULL;
	self = (ClocksWorldItem*) base;
	_tmp0_ = clocks_world_item_get_nation_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp4_ = clocks_world_item_get_city_name (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = clocks_world_item_get_nation_name (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s, %s", _tmp6_, _tmp9_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	} else {
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = clocks_world_item_get_city_name (self);
		_tmp12_ = _tmp11_;
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp12_;
	}
	_tmp13_ = self->priv->_name;
	result = _tmp13_;
	return result;
}


static void clocks_world_item_real_set_name (ClocksContentItem* base, const gchar* value) {
	ClocksWorldItem* self;
	self = (ClocksWorldItem*) base;
	g_object_notify ((GObject *) self, "name");
}


gchar* clocks_world_item_get_city_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_city_name (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_nation_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* nation = NULL;
	GWeatherLocation* _tmp0_ = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	const gchar* _tmp10_ = NULL;
	GWeatherLocation* _tmp11_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = __vala_GWeatherLocation_copy0 (_tmp0_);
	nation = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GWeatherLocation* _tmp3_ = NULL;
		gboolean _tmp6_ = FALSE;
		GWeatherLocation* _tmp7_ = NULL;
		GWeatherLocation* _tmp8_ = NULL;
		GWeatherLocation* _tmp9_ = NULL;
		_tmp3_ = nation;
		if (_tmp3_ != NULL) {
			GWeatherLocation* _tmp4_ = NULL;
			GWeatherLocationLevel _tmp5_ = 0;
			_tmp4_ = nation;
			_tmp5_ = gweather_location_get_level (_tmp4_);
			_tmp2_ = _tmp5_ != GWEATHER_LOCATION_COUNTRY;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp6_ = _tmp2_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = nation;
		_tmp8_ = gweather_location_get_parent (_tmp7_);
		_tmp9_ = __vala_GWeatherLocation_copy0 (_tmp8_);
		__vala_GWeatherLocation_free0 (nation);
		nation = _tmp9_;
	}
	_tmp11_ = nation;
	if (_tmp11_ != NULL) {
		GWeatherLocation* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp12_ = nation;
		_tmp13_ = gweather_location_get_name (_tmp12_);
		_tmp10_ = _tmp13_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp14_ = _tmp10_;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	__vala_GWeatherLocation_free0 (nation);
	return result;
}


gboolean clocks_world_item_get_is_daytime (ClocksWorldItem* self) {
	gboolean result;
	GWeatherInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->weather_info;
	_tmp1_ = gweather_info_is_daytime (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self) {
	gchar* result;
	gulong sunrise = 0UL;
	GWeatherInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GDateTime* sunrise_time = NULL;
	gulong _tmp4_ = 0UL;
	GDateTime* _tmp5_ = NULL;
	GDateTime* _tmp6_ = NULL;
	GTimeZone* _tmp7_ = NULL;
	GDateTime* _tmp8_ = NULL;
	ClocksUtilsWallClock* _tmp9_ = NULL;
	ClocksUtilsWallClock* _tmp10_ = NULL;
	GDateTime* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	_tmp2_ = gweather_info_get_value_sunrise (_tmp0_, &_tmp1_);
	sunrise = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("-");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = sunrise;
	_tmp5_ = g_date_time_new_from_unix_local ((gint64) _tmp4_);
	sunrise_time = _tmp5_;
	_tmp6_ = sunrise_time;
	_tmp7_ = self->priv->time_zone;
	_tmp8_ = g_date_time_to_timezone (_tmp6_, _tmp7_);
	_g_date_time_unref0 (sunrise_time);
	sunrise_time = _tmp8_;
	_tmp9_ = clocks_utils_wall_clock_get_default ();
	_tmp10_ = _tmp9_;
	_tmp11_ = sunrise_time;
	_tmp12_ = clocks_utils_wall_clock_format_time (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	result = _tmp13_;
	_g_date_time_unref0 (sunrise_time);
	return result;
}


gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self) {
	gchar* result;
	gulong sunset = 0UL;
	GWeatherInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GDateTime* sunset_time = NULL;
	gulong _tmp4_ = 0UL;
	GDateTime* _tmp5_ = NULL;
	GDateTime* _tmp6_ = NULL;
	GTimeZone* _tmp7_ = NULL;
	GDateTime* _tmp8_ = NULL;
	ClocksUtilsWallClock* _tmp9_ = NULL;
	ClocksUtilsWallClock* _tmp10_ = NULL;
	GDateTime* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	_tmp2_ = gweather_info_get_value_sunset (_tmp0_, &_tmp1_);
	sunset = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("-");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = sunset;
	_tmp5_ = g_date_time_new_from_unix_local ((gint64) _tmp4_);
	sunset_time = _tmp5_;
	_tmp6_ = sunset_time;
	_tmp7_ = self->priv->time_zone;
	_tmp8_ = g_date_time_to_timezone (_tmp6_, _tmp7_);
	_g_date_time_unref0 (sunset_time);
	sunset_time = _tmp8_;
	_tmp9_ = clocks_utils_wall_clock_get_default ();
	_tmp10_ = _tmp9_;
	_tmp11_ = sunset_time;
	_tmp12_ = clocks_utils_wall_clock_format_time (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	result = _tmp13_;
	_g_date_time_unref0 (sunset_time);
	return result;
}


gchar* clocks_world_item_get_time_label (ClocksWorldItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->date_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self) {
	const gchar* result;
	gint d = 0;
	GDateTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint t = 0;
	GDateTime* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->date_time;
	_tmp1_ = g_date_time_get_day_of_year (_tmp0_);
	d = _tmp1_;
	_tmp2_ = self->priv->local_time;
	_tmp3_ = g_date_time_get_day_of_year (_tmp2_);
	t = _tmp3_;
	_tmp4_ = d;
	_tmp5_ = t;
	if (_tmp4_ < _tmp5_) {
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		const gchar* _tmp10_ = NULL;
		_tmp7_ = d;
		if (_tmp7_ == 1) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = _ ("Tomorrow");
			_tmp6_ = _tmp8_;
		} else {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = _ ("Yesterday");
			_tmp6_ = _tmp9_;
		}
		_tmp10_ = _tmp6_;
		result = _tmp10_;
		return result;
	} else {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp11_ = d;
		_tmp12_ = t;
		if (_tmp11_ > _tmp12_) {
			const gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			const gchar* _tmp17_ = NULL;
			_tmp14_ = t;
			if (_tmp14_ == 1) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = _ ("Yesterday");
				_tmp13_ = _tmp15_;
			} else {
				const gchar* _tmp16_ = NULL;
				_tmp16_ = _ ("Tomorrow");
				_tmp13_ = _tmp16_;
			}
			_tmp17_ = _tmp13_;
			result = _tmp17_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


static void clocks_world_item_class_init (ClocksWorldItemClass * klass) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	clocks_world_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_LOCATION, g_param_spec_boxed ("location", "location", "location", gweather_location_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_CITY_NAME, g_param_spec_string ("city-name", "city-name", "city-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_NATION_NAME, g_param_spec_string ("nation-name", "nation-name", "nation-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_IS_DAYTIME, g_param_spec_boolean ("is-daytime", "is-daytime", "is-daytime", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNRISE_LABEL, g_param_spec_string ("sunrise-label", "sunrise-label", "sunrise-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNSET_LABEL, g_param_spec_string ("sunset-label", "sunset-label", "sunset-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_TIME_LABEL, g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_DAY_LABEL, g_param_spec_string ("day-label", "day-label", "day-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = clocks_utils_load_image ("day.png");
	clocks_world_item_day_pixbuf = _tmp0_;
	_tmp1_ = clocks_utils_load_image ("night.png");
	clocks_world_item_night_pixbuf = _tmp1_;
}


static void clocks_world_item_clocks_content_item_interface_init (ClocksContentItemIface * iface) {
	clocks_world_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_thumb_properties = (void (*)(ClocksContentItem*, gchar**, gchar**, GdkPixbuf**, gchar**)) clocks_world_item_real_get_thumb_properties;
	iface->get_name = clocks_world_item_real_get_name;
	iface->set_name = clocks_world_item_real_set_name;
}


static void clocks_world_item_instance_init (ClocksWorldItem * self) {
	self->priv = CLOCKS_WORLD_ITEM_GET_PRIVATE (self);
}


static void clocks_world_item_finalize (GObject* obj) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	__vala_GWeatherLocation_free0 (self->priv->_location);
	_g_free0 (self->priv->_name);
	_g_time_zone_unref0 (self->priv->time_zone);
	_g_date_time_unref0 (self->priv->local_time);
	_g_date_time_unref0 (self->priv->date_time);
	_g_object_unref0 (self->priv->weather_info);
	G_OBJECT_CLASS (clocks_world_item_parent_class)->finalize (obj);
}


GType clocks_world_item_get_type (void) {
	static volatile gsize clocks_world_item_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldItem), 0, (GInstanceInitFunc) clocks_world_item_instance_init, NULL };
		static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_world_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_world_item_type_id;
		clocks_world_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksWorldItem", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_world_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
		g_once_init_leave (&clocks_world_item_type_id__volatile, clocks_world_item_type_id);
	}
	return clocks_world_item_type_id__volatile;
}


static void _vala_clocks_world_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION:
		g_value_set_boxed (value, clocks_world_item_get_location (self));
		break;
		case CLOCKS_WORLD_ITEM_NAME:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_WORLD_ITEM_CITY_NAME:
		g_value_take_string (value, clocks_world_item_get_city_name (self));
		break;
		case CLOCKS_WORLD_ITEM_NATION_NAME:
		g_value_take_string (value, clocks_world_item_get_nation_name (self));
		break;
		case CLOCKS_WORLD_ITEM_IS_DAYTIME:
		g_value_set_boolean (value, clocks_world_item_get_is_daytime (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNRISE_LABEL:
		g_value_take_string (value, clocks_world_item_get_sunrise_label (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNSET_LABEL:
		g_value_take_string (value, clocks_world_item_get_sunset_label (self));
		break;
		case CLOCKS_WORLD_ITEM_TIME_LABEL:
		g_value_take_string (value, clocks_world_item_get_time_label (self));
		break;
		case CLOCKS_WORLD_ITEM_DAY_LABEL:
		g_value_set_string (value, clocks_world_item_get_day_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION:
		clocks_world_item_set_location (self, g_value_get_boxed (value));
		break;
		case CLOCKS_WORLD_ITEM_NAME:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type, GtkWindow* parent) {
	ClocksWorldLocationDialog * self = NULL;
	GtkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	self = (ClocksWorldLocationDialog*) g_object_new (object_type, "transient-for", _tmp0_, NULL);
	return self;
}


ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent) {
	return clocks_world_location_dialog_construct (CLOCKS_WORLD_TYPE_LOCATION_DIALOG, parent);
}


static void clocks_world_location_dialog_icon_released (ClocksWorldLocationDialog* self) {
	GWeatherLocationEntry* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->location_entry;
	g_object_get ((GtkEntry*) _tmp0_, "secondary-icon-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "edit-clear-symbolic") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GWeatherLocationEntry* _tmp5_ = NULL;
		_tmp5_ = self->priv->location_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp5_, "");
	}
}


static void _clocks_world_location_dialog_icon_released_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	clocks_world_location_dialog_icon_released (self);
}


static void clocks_world_location_dialog_location_changed (ClocksWorldLocationDialog* self) {
	GWeatherLocation* l = NULL;
	GWeatherTimezone* t = NULL;
	GWeatherLocationEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp12_ = FALSE;
	GWeatherLocation* _tmp13_ = NULL;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	l = NULL;
	t = NULL;
	_tmp0_ = self->priv->location_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GWeatherLocationEntry* _tmp2_ = NULL;
		GWeatherLocation* _tmp3_ = NULL;
		GWeatherLocation* _tmp4_ = NULL;
		_tmp2_ = self->priv->location_entry;
		_tmp3_ = gweather_location_entry_get_location (_tmp2_);
		__vala_GWeatherLocation_free0 (l);
		l = _tmp3_;
		_tmp4_ = l;
		if (_tmp4_ != NULL) {
			GWeatherLocation* _tmp5_ = NULL;
			GWeatherTimezone* _tmp6_ = NULL;
			GWeatherTimezone* _tmp7_ = NULL;
			GWeatherTimezone* _tmp8_ = NULL;
			_tmp5_ = l;
			_tmp6_ = gweather_location_get_timezone (_tmp5_);
			_tmp7_ = __vala_GWeatherTimezone_copy0 (_tmp6_);
			__vala_GWeatherTimezone_free0 (t);
			t = _tmp7_;
			_tmp8_ = t;
			if (_tmp8_ == NULL) {
				GWeatherLocation* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				_tmp9_ = l;
				_tmp10_ = gweather_location_get_city_name (_tmp9_);
				_tmp11_ = _tmp10_;
				g_warning ("world.vala:200: Timezone not defined for %s. This is a bug in libgweat" \
"her database", _tmp11_);
				_g_free0 (_tmp11_);
			}
		}
	}
	_tmp13_ = l;
	if (_tmp13_ != NULL) {
		GWeatherTimezone* _tmp14_ = NULL;
		_tmp14_ = t;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, 1, _tmp15_);
	__vala_GWeatherTimezone_free0 (t);
	__vala_GWeatherLocation_free0 (l);
}


static void _clocks_world_location_dialog_location_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	clocks_world_location_dialog_location_changed (self);
}


ClocksWorldItem* clocks_world_location_dialog_get_location (ClocksWorldLocationDialog* self) {
	ClocksWorldItem* result = NULL;
	GWeatherLocation* location = NULL;
	GWeatherLocationEntry* _tmp0_ = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	ClocksWorldItem* _tmp2_ = NULL;
	GWeatherLocation* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->location_entry;
	_tmp1_ = gweather_location_entry_get_location (_tmp0_);
	location = _tmp1_;
	_tmp3_ = location;
	if (_tmp3_ != NULL) {
		GWeatherLocation* _tmp4_ = NULL;
		ClocksWorldItem* _tmp5_ = NULL;
		_tmp4_ = location;
		_tmp5_ = clocks_world_item_new (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp2_);
		_tmp2_ = NULL;
	}
	result = _tmp2_;
	__vala_GWeatherLocation_free0 (location);
	return result;
}


static void clocks_world_location_dialog_class_init (ClocksWorldLocationDialogClass * klass) {
	gint ClocksWorldLocationDialog_private_offset;
	clocks_world_location_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldLocationDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_world_location_dialog_finalize;
	ClocksWorldLocationDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/worldlocationdialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_entry", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, location_entry));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "icon_released", G_CALLBACK(_clocks_world_location_dialog_icon_released_gtk_entry_icon_release));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "location_changed", G_CALLBACK(_clocks_world_location_dialog_location_changed_gtk_editable_changed));
}


static void clocks_world_location_dialog_instance_init (ClocksWorldLocationDialog * self) {
	self->priv = CLOCKS_WORLD_LOCATION_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_world_location_dialog_finalize (GObject* obj) {
	ClocksWorldLocationDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog);
	_g_object_unref0 (self->priv->location_entry);
	G_OBJECT_CLASS (clocks_world_location_dialog_parent_class)->finalize (obj);
}


GType clocks_world_location_dialog_get_type (void) {
	static volatile gsize clocks_world_location_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_location_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldLocationDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_location_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldLocationDialog), 0, (GInstanceInitFunc) clocks_world_location_dialog_instance_init, NULL };
		GType clocks_world_location_dialog_type_id;
		clocks_world_location_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ClocksWorldLocationDialog", &g_define_type_info, 0);
		g_once_init_leave (&clocks_world_location_dialog_type_id__volatile, clocks_world_location_dialog_type_id);
	}
	return clocks_world_location_dialog_type_id__volatile;
}


ClocksWorldStandalonePanel* clocks_world_standalone_panel_construct (GType object_type) {
	ClocksWorldStandalonePanel * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkGrid* grid = NULL;
	GObject* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	self = (ClocksWorldStandalonePanel*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "view");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "content-view");
	_tmp2_ = clocks_utils_load_ui ("world.ui");
	builder = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "standalone_content");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp3_) : NULL);
	grid = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "time_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->time_label);
	self->priv->time_label = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "day_label");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->day_label);
	self->priv->day_label = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "sunrise_label");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->sunrise_label);
	self->priv->sunrise_label = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "sunset_label");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp11_) : NULL);
	_g_object_unref0 (self->priv->sunset_label);
	self->priv->sunset_label = _tmp12_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	return self;
}


ClocksWorldStandalonePanel* clocks_world_standalone_panel_new (void) {
	return clocks_world_standalone_panel_construct (CLOCKS_WORLD_TYPE_STANDALONE_PANEL);
}


void clocks_world_standalone_panel_update (ClocksWorldStandalonePanel* self) {
	ClocksWorldItem* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_ = NULL;
		ClocksWorldItem* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GtkLabel* _tmp6_ = NULL;
		ClocksWorldItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkLabel* _tmp10_ = NULL;
		ClocksWorldItem* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GtkLabel* _tmp15_ = NULL;
		ClocksWorldItem* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp1_ = self->priv->time_label;
		_tmp2_ = self->priv->_location;
		_tmp3_ = clocks_world_item_get_time_label (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		gtk_label_set_label (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->day_label;
		_tmp7_ = self->priv->_location;
		_tmp8_ = clocks_world_item_get_day_label (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp6_, _tmp9_);
		_tmp10_ = self->priv->sunrise_label;
		_tmp11_ = self->priv->_location;
		_tmp12_ = clocks_world_item_get_sunrise_label (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		gtk_label_set_label (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = self->priv->sunset_label;
		_tmp16_ = self->priv->_location;
		_tmp17_ = clocks_world_item_get_sunset_label (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		gtk_label_set_label (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
	}
}


ClocksWorldItem* clocks_world_standalone_panel_get_location (ClocksWorldStandalonePanel* self) {
	ClocksWorldItem* result;
	ClocksWorldItem* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void clocks_world_standalone_panel_set_location (ClocksWorldStandalonePanel* self, ClocksWorldItem* value) {
	ClocksWorldItem* _tmp0_ = NULL;
	ClocksWorldItem* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


static void clocks_world_standalone_panel_class_init (ClocksWorldStandalonePanelClass * klass) {
	clocks_world_standalone_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldStandalonePanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_standalone_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_standalone_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_standalone_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_STANDALONE_PANEL_LOCATION, g_param_spec_object ("location", "location", "location", CLOCKS_WORLD_TYPE_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_world_standalone_panel_instance_init (ClocksWorldStandalonePanel * self) {
	self->priv = CLOCKS_WORLD_STANDALONE_PANEL_GET_PRIVATE (self);
}


static void clocks_world_standalone_panel_finalize (GObject* obj) {
	ClocksWorldStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->day_label);
	_g_object_unref0 (self->priv->sunrise_label);
	_g_object_unref0 (self->priv->sunset_label);
	G_OBJECT_CLASS (clocks_world_standalone_panel_parent_class)->finalize (obj);
}


GType clocks_world_standalone_panel_get_type (void) {
	static volatile gsize clocks_world_standalone_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_standalone_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldStandalonePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_standalone_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldStandalonePanel), 0, (GInstanceInitFunc) clocks_world_standalone_panel_instance_init, NULL };
		GType clocks_world_standalone_panel_type_id;
		clocks_world_standalone_panel_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ClocksWorldStandalonePanel", &g_define_type_info, 0);
		g_once_init_leave (&clocks_world_standalone_panel_type_id__volatile, clocks_world_standalone_panel_type_id);
	}
	return clocks_world_standalone_panel_type_id__volatile;
}


static void _vala_clocks_world_standalone_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel);
	switch (property_id) {
		case CLOCKS_WORLD_STANDALONE_PANEL_LOCATION:
		g_value_set_object (value, clocks_world_standalone_panel_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_standalone_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel);
	switch (property_id) {
		case CLOCKS_WORLD_STANDALONE_PANEL_LOCATION:
		clocks_world_standalone_panel_set_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ClocksWorldMainPanel * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->header_bar);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda18_ (ClocksWorldMainPanel* self) {
	ClocksContentView* _tmp0_ = NULL;
	_tmp0_ = self->priv->content_view;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
}


static void ___lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda18_ (self);
}


static void __lambda19_ (ClocksWorldMainPanel* self, GObject* item) {
	ClocksWorldItem* location = NULL;
	GObject* _tmp0_ = NULL;
	ClocksWorldItem* _tmp1_ = NULL;
	ClocksWorldStandalonePanel* _tmp2_ = NULL;
	ClocksWorldStandalonePanel* _tmp3_ = NULL;
	ClocksWorldStandalonePanel* _tmp4_ = NULL;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	location = _tmp1_;
	_tmp2_ = self->priv->standalone;
	clocks_world_standalone_panel_set_location (_tmp2_, location);
	_tmp3_ = self->priv->standalone;
	clocks_world_standalone_panel_update (_tmp3_);
	_tmp4_ = self->priv->standalone;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp4_);
	_g_object_unref0 (location);
}


static void ___lambda19__clocks_content_view_item_activated (ClocksContentView* _sender, GObject* item, gpointer self) {
	__lambda19_ (self, item);
}


static void __lambda20_ (ClocksWorldMainPanel* self) {
	ClocksContentView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	_tmp0_ = self->priv->content_view;
	_tmp1_ = clocks_content_view_get_selected_items (_tmp0_);
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp1_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GObject* _tmp2_ = NULL;
			GObject* i = NULL;
			_tmp2_ = _g_object_ref0 ((GObject*) i_it->data);
			i = _tmp2_;
			{
				GObject* _tmp3_ = NULL;
				_tmp3_ = i;
				self->priv->locations = g_list_remove (self->priv->locations, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
				_g_object_unref0 (i);
			}
		}
		__g_list_free__g_object_unref0_0 (i_collection);
	}
	clocks_world_main_panel_save (self);
}


static void ___lambda20__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self) {
	__lambda20_ (self);
}


static void __lambda21_ (Block2Data* _data2_) {
	ClocksWorldMainPanel * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	ClocksContentView* _tmp2_ = NULL;
	self = _data2_->self;
	_tmp0_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->content_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WIDGET, GtkWidget)) {
		ClocksHeaderBar* _tmp3_ = NULL;
		_tmp3_ = _data2_->header_bar;
		clocks_header_bar_set_mode (_tmp3_, CLOCKS_HEADER_BAR_MODE_NORMAL);
	} else {
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		ClocksWorldStandalonePanel* _tmp6_ = NULL;
		_tmp4_ = gtk_stack_get_visible_child ((GtkStack*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->standalone;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_WIDGET, GtkWidget)) {
			ClocksHeaderBar* _tmp7_ = NULL;
			_tmp7_ = _data2_->header_bar;
			clocks_header_bar_set_mode (_tmp7_, CLOCKS_HEADER_BAR_MODE_STANDALONE);
		}
	}
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda21_ (self);
}


static void __lambda22_ (ClocksWorldMainPanel* self) {
	GList* _tmp0_ = NULL;
	ClocksContentView* _tmp3_ = NULL;
	ClocksWorldStandalonePanel* _tmp4_ = NULL;
	_tmp0_ = self->priv->locations;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			ClocksWorldItem* _tmp1_ = NULL;
			ClocksWorldItem* l = NULL;
			_tmp1_ = _g_object_ref0 ((ClocksWorldItem*) l_it->data);
			l = _tmp1_;
			{
				ClocksWorldItem* _tmp2_ = NULL;
				_tmp2_ = l;
				clocks_world_item_tick (_tmp2_);
				_g_object_unref0 (l);
			}
		}
	}
	_tmp3_ = self->priv->content_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->standalone;
	clocks_world_standalone_panel_update (_tmp4_);
}


static void ___lambda22__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self) {
	__lambda22_ (self);
}


ClocksWorldMainPanel* clocks_world_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksWorldMainPanel * self = NULL;
	Block2Data* _data2_;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ClocksHeaderBar* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	ClocksHeaderBar* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkImage* back_button_image = NULL;
	GtkImage* _tmp15_ = NULL;
	GtkImage* _tmp16_ = NULL;
	GtkTextDirection _tmp17_ = 0;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkImage* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	ClocksHeaderBar* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GtkWidget* empty_view = NULL;
	GObject* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	ClocksHeaderBar* _tmp30_ = NULL;
	ClocksContentView* _tmp31_ = NULL;
	ClocksContentView* _tmp32_ = NULL;
	ClocksContentView* _tmp33_ = NULL;
	ClocksContentView* _tmp34_ = NULL;
	ClocksWorldStandalonePanel* _tmp35_ = NULL;
	ClocksWorldStandalonePanel* _tmp36_ = NULL;
	ClocksContentView* _tmp37_ = NULL;
	ClocksUtilsWallClock* _tmp38_ = NULL;
	ClocksUtilsWallClock* _tmp39_ = NULL;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = header_bar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->header_bar);
	_data2_->header_bar = _tmp1_;
	_tmp2_ = _ ("World");
	_tmp3_ = _data2_->header_bar;
	self = (ClocksWorldMainPanel*) g_object_new (object_type, "label", _tmp2_, "header-bar", _tmp3_, "transition-type", GTK_STACK_TRANSITION_TYPE_CROSSFADE, "panel-id", CLOCKS_PANEL_ID_WORLD, NULL);
	_data2_->self = g_object_ref (self);
	__g_list_free__g_object_unref0_0 (self->priv->locations);
	self->priv->locations = NULL;
	_tmp4_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = clocks_utils_load_image ("day.png");
	_g_object_unref0 (self->priv->day_pixbuf);
	self->priv->day_pixbuf = _tmp5_;
	_tmp6_ = clocks_utils_load_image ("night.png");
	_g_object_unref0 (self->priv->night_pixbuf);
	self->priv->night_pixbuf = _tmp6_;
	_tmp7_ = _ ("New");
	_tmp8_ = (GtkButton*) gtk_button_new_with_label (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->new_button);
	self->priv->new_button = _tmp8_;
	_tmp9_ = self->priv->new_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	_tmp10_ = self->priv->new_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->new_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp11_, "win.new");
	_tmp12_ = _data2_->header_bar;
	_tmp13_ = self->priv->new_button;
	gtk_header_bar_pack_start ((GtkHeaderBar*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->back_button);
	self->priv->back_button = _tmp14_;
	_tmp15_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp15_);
	back_button_image = _tmp15_;
	_tmp16_ = back_button_image;
	g_object_set (_tmp16_, "icon-size", (gint) GTK_ICON_SIZE_MENU, NULL);
	_tmp17_ = gtk_widget_get_direction ((GtkWidget*) self);
	if (_tmp17_ == GTK_TEXT_DIR_LTR) {
		GtkImage* _tmp18_ = NULL;
		_tmp18_ = back_button_image;
		g_object_set (_tmp18_, "icon-name", "go-previous-symbolic", NULL);
	} else {
		GtkImage* _tmp19_ = NULL;
		_tmp19_ = back_button_image;
		g_object_set (_tmp19_, "icon-name", "go-previous-rtl-symbolic", NULL);
	}
	_tmp20_ = self->priv->back_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	_tmp21_ = self->priv->back_button;
	_tmp22_ = back_button_image;
	gtk_button_set_image (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->back_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = self->priv->back_button;
	g_signal_connect_object (_tmp24_, "clicked", (GCallback) ___lambda18__gtk_button_clicked, self, 0);
	_tmp25_ = _data2_->header_bar;
	_tmp26_ = self->priv->back_button;
	gtk_header_bar_pack_start ((GtkHeaderBar*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = clocks_utils_load_ui ("world.ui");
	builder = _tmp27_;
	_tmp28_ = gtk_builder_get_object (builder, "empty_panel");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp28_) : NULL);
	empty_view = _tmp29_;
	_tmp30_ = _data2_->header_bar;
	_tmp31_ = clocks_content_view_new (empty_view, _tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->content_view);
	self->priv->content_view = _tmp31_;
	_tmp32_ = self->priv->content_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->content_view;
	g_signal_connect_object (_tmp33_, "item-activated", (GCallback) ___lambda19__clocks_content_view_item_activated, self, 0);
	_tmp34_ = self->priv->content_view;
	g_signal_connect_object (_tmp34_, "delete-selected", (GCallback) ___lambda20__clocks_content_view_delete_selected, self, 0);
	_tmp35_ = clocks_world_standalone_panel_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->standalone);
	self->priv->standalone = _tmp35_;
	_tmp36_ = self->priv->standalone;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp36_);
	clocks_world_main_panel_load (self);
	g_signal_connect_data ((GObject*) self, "notify::visible-child", (GCallback) ___lambda21__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp37_ = self->priv->content_view;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp37_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp38_ = clocks_utils_wall_clock_get_default ();
	_tmp39_ = _tmp38_;
	g_signal_connect_object (_tmp39_, "tick", (GCallback) ___lambda22__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (empty_view);
	_g_object_unref0 (builder);
	_g_object_unref0 (back_button_image);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}


ClocksWorldMainPanel* clocks_world_main_panel_new (ClocksHeaderBar* header_bar) {
	return clocks_world_main_panel_construct (CLOCKS_WORLD_TYPE_MAIN_PANEL, header_bar);
}


static void clocks_world_main_panel_load (ClocksWorldMainPanel* self) {
	g_return_if_fail (self != NULL);
	{
		GVariantIter* _l_it = NULL;
		GSettings* _tmp0_ = NULL;
		GVariant* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		GVariantIter* _tmp3_ = NULL;
		GVariantIter* _tmp4_ = NULL;
		GVariant* l = NULL;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_value (_tmp0_, "world-clocks");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_unref0 (_tmp2_);
		_l_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_ = NULL;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			ClocksWorldItem* location = NULL;
			GVariant* _tmp8_ = NULL;
			ClocksWorldItem* _tmp9_ = NULL;
			ClocksWorldItem* _tmp10_ = NULL;
			_tmp5_ = _l_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (l);
			l = _tmp6_;
			_tmp7_ = l;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = l;
			_tmp9_ = clocks_world_item_deserialize (_tmp8_);
			location = _tmp9_;
			_tmp10_ = location;
			if (_tmp10_ != NULL) {
				ClocksWorldItem* _tmp11_ = NULL;
				ClocksWorldItem* _tmp12_ = NULL;
				ClocksContentView* _tmp13_ = NULL;
				ClocksWorldItem* _tmp14_ = NULL;
				_tmp11_ = location;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				self->priv->locations = g_list_prepend (self->priv->locations, _tmp12_);
				_tmp13_ = self->priv->content_view;
				_tmp14_ = location;
				clocks_content_view_add_item (_tmp13_, (ClocksContentItem*) _tmp14_);
			}
			_g_object_unref0 (location);
		}
		_g_variant_unref0 (l);
		_g_variant_iter_free0 (_l_it);
	}
	self->priv->locations = g_list_reverse (self->priv->locations);
}


static void clocks_world_main_panel_save (ClocksWorldMainPanel* self) {
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantBuilder* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GSettings* _tmp8_ = NULL;
	GVariantBuilder* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_variant_type_new ("aa{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = self->priv->locations;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp4_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksWorldItem* _tmp5_ = NULL;
			ClocksWorldItem* i = NULL;
			_tmp5_ = _g_object_ref0 ((ClocksWorldItem*) i_it->data);
			i = _tmp5_;
			{
				ClocksWorldItem* _tmp6_ = NULL;
				GVariantBuilder* _tmp7_ = NULL;
				_tmp6_ = i;
				_tmp7_ = builder;
				clocks_world_item_serialize (_tmp6_, _tmp7_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = builder;
	_tmp10_ = g_variant_builder_end (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_settings_set_value (_tmp8_, "world-clocks", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_g_variant_builder_unref0 (builder);
}


static void __lambda23_ (ClocksWorldMainPanel* self, GtkDialog* dialog, gint response) {
	gint _tmp0_ = 0;
	GtkDialog* _tmp7_ = NULL;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		ClocksWorldItem* location = NULL;
		GtkDialog* _tmp1_ = NULL;
		ClocksWorldItem* _tmp2_ = NULL;
		ClocksWorldItem* _tmp3_ = NULL;
		ClocksWorldItem* _tmp4_ = NULL;
		ClocksContentView* _tmp5_ = NULL;
		ClocksWorldItem* _tmp6_ = NULL;
		_tmp1_ = dialog;
		_tmp2_ = clocks_world_location_dialog_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog));
		location = _tmp2_;
		_tmp3_ = location;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		self->priv->locations = g_list_append (self->priv->locations, _tmp4_);
		_tmp5_ = self->priv->content_view;
		_tmp6_ = location;
		clocks_content_view_add_item (_tmp5_, (ClocksContentItem*) _tmp6_);
		clocks_world_main_panel_save (self);
		_g_object_unref0 (location);
	}
	_tmp7_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
}


static void ___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda23_ (self, _sender, response_id);
}


static void clocks_world_main_panel_real_activate_new (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksWorldLocationDialog* dialog = NULL;
	GtkWidget* _tmp0_ = NULL;
	ClocksWorldLocationDialog* _tmp1_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = clocks_world_location_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_WINDOW, GtkWindow));
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda23__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void clocks_world_main_panel_real_activate_select_all (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksContentView* _tmp0_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_select_all (_tmp0_);
}


static void clocks_world_main_panel_real_activate_select_none (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksContentView* _tmp0_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_unselect_all (_tmp0_);
}


static gboolean clocks_world_main_panel_real_escape_pressed (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	gboolean result = FALSE;
	ClocksContentView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	_tmp1_ = clocks_content_view_escape_pressed (_tmp0_);
	result = _tmp1_;
	return result;
}


static void clocks_world_main_panel_real_update_header_bar (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	ClocksHeaderBarMode _tmp2_ = 0;
	ClocksHeaderBarMode _tmp3_ = 0;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = clocks_clock_get_header_bar ((ClocksClock*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_header_bar_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case CLOCKS_HEADER_BAR_MODE_NORMAL:
		{
			GtkButton* _tmp4_ = NULL;
			ClocksContentView* _tmp5_ = NULL;
			_tmp4_ = self->priv->new_button;
			gtk_widget_show ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp5_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_SELECTION:
		{
			ClocksContentView* _tmp6_ = NULL;
			_tmp6_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp6_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_STANDALONE:
		{
			ClocksHeaderBar* _tmp7_ = NULL;
			ClocksHeaderBar* _tmp8_ = NULL;
			ClocksWorldStandalonePanel* _tmp9_ = NULL;
			ClocksWorldItem* _tmp10_ = NULL;
			ClocksWorldItem* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			ClocksHeaderBar* _tmp17_ = NULL;
			ClocksHeaderBar* _tmp18_ = NULL;
			ClocksWorldStandalonePanel* _tmp19_ = NULL;
			ClocksWorldItem* _tmp20_ = NULL;
			ClocksWorldItem* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			GtkButton* _tmp27_ = NULL;
			_tmp7_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->standalone;
			_tmp10_ = clocks_world_standalone_panel_get_location (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = clocks_world_item_get_city_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = g_markup_escape_text (_tmp14_, (gssize) (-1));
			_tmp16_ = _tmp15_;
			gtk_header_bar_set_title ((GtkHeaderBar*) _tmp8_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_tmp17_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = self->priv->standalone;
			_tmp20_ = clocks_world_standalone_panel_get_location (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = clocks_world_item_get_nation_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_;
			_tmp25_ = g_markup_escape_text (_tmp24_, (gssize) (-1));
			_tmp26_ = _tmp25_;
			gtk_header_bar_set_subtitle ((GtkHeaderBar*) _tmp18_, _tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_tmp27_ = self->priv->back_button;
			gtk_widget_show ((GtkWidget*) _tmp27_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static const gchar* clocks_world_main_panel_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksWorldMainPanel* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_world_main_panel_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksWorldMainPanel* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksHeaderBar* clocks_world_main_panel_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksWorldMainPanel* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_world_main_panel_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksWorldMainPanel* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp1_;
	g_object_notify ((GObject *) self, "header-bar");
}


static ClocksPanelId clocks_world_main_panel_real_get_panel_id (ClocksClock* base) {
	ClocksPanelId result;
	ClocksWorldMainPanel* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->_panel_id;
	result = _tmp0_;
	return result;
}


static void clocks_world_main_panel_real_set_panel_id (ClocksClock* base, ClocksPanelId value) {
	ClocksWorldMainPanel* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = value;
	self->priv->_panel_id = _tmp0_;
	g_object_notify ((GObject *) self, "panel-id");
}


static void clocks_world_main_panel_class_init (ClocksWorldMainPanelClass * klass) {
	clocks_world_main_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldMainPanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_main_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_main_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_main_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_MAIN_PANEL_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR, g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_MAIN_PANEL_PANEL_ID, g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void clocks_world_main_panel_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_world_main_panel_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*)(ClocksClock*)) clocks_world_main_panel_real_activate_new;
	iface->activate_select_all = (void (*)(ClocksClock*)) clocks_world_main_panel_real_activate_select_all;
	iface->activate_select_none = (void (*)(ClocksClock*)) clocks_world_main_panel_real_activate_select_none;
	iface->escape_pressed = (gboolean (*)(ClocksClock*)) clocks_world_main_panel_real_escape_pressed;
	iface->update_header_bar = (void (*)(ClocksClock*)) clocks_world_main_panel_real_update_header_bar;
	iface->get_label = clocks_world_main_panel_real_get_label;
	iface->set_label = clocks_world_main_panel_real_set_label;
	iface->get_header_bar = clocks_world_main_panel_real_get_header_bar;
	iface->set_header_bar = clocks_world_main_panel_real_set_header_bar;
	iface->get_panel_id = clocks_world_main_panel_real_get_panel_id;
	iface->set_panel_id = clocks_world_main_panel_real_set_panel_id;
}


static void clocks_world_main_panel_instance_init (ClocksWorldMainPanel * self) {
	self->priv = CLOCKS_WORLD_MAIN_PANEL_GET_PRIVATE (self);
}


static void clocks_world_main_panel_finalize (GObject* obj) {
	ClocksWorldMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	__g_list_free__g_object_unref0_0 (self->priv->locations);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->new_button);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->day_pixbuf);
	_g_object_unref0 (self->priv->night_pixbuf);
	_g_object_unref0 (self->priv->content_view);
	_g_object_unref0 (self->priv->standalone);
	G_OBJECT_CLASS (clocks_world_main_panel_parent_class)->finalize (obj);
}


GType clocks_world_main_panel_get_type (void) {
	static volatile gsize clocks_world_main_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_main_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldMainPanel), 0, (GInstanceInitFunc) clocks_world_main_panel_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_world_main_panel_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_world_main_panel_type_id;
		clocks_world_main_panel_type_id = g_type_register_static (GTK_TYPE_STACK, "ClocksWorldMainPanel", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_world_main_panel_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_world_main_panel_type_id__volatile, clocks_world_main_panel_type_id);
	}
	return clocks_world_main_panel_type_id__volatile;
}


static void _vala_clocks_world_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel);
	switch (property_id) {
		case CLOCKS_WORLD_MAIN_PANEL_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_MAIN_PANEL_PANEL_ID:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel);
	switch (property_id) {
		case CLOCKS_WORLD_MAIN_PANEL_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		case CLOCKS_WORLD_MAIN_PANEL_PANEL_ID:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



