/* cheese-window.c generated by valac 0.21.1.32-328f, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cheese-camera-device.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <cheese-config.h>
#include <stdio.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _CheeseMainWindow {
	GtkApplicationWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GSettings* settings;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkGrid* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkGrid* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkGrid* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterActor* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterActor* background_layer;
	ClutterText* error_layer;
	ClutterText* timeout_layer;
	ClutterActor* current_effects_grid;
	guint current_effects_page;
	GList* effects_grids;
	GtkAction* countdown_action;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean action_cancelled;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
};

typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE ((guint) 9)
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void cheese_main_window_on_file_open (CheeseMainWindow* self);
static void _cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_file_saveas (CheeseMainWindow* self);
static void _cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_file_trash (CheeseMainWindow* self);
static void _cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_file_delete (CheeseMainWindow* self);
static void _cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_effects_next (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_effects_previous (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application);
gboolean cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_set_fullscreen (CheeseMainWindow* self, gboolean fullscreen);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda2_ (CheeseMainWindow* self);
static gboolean ___lambda2__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self);
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_show_error (CheeseMainWindow* self, const gchar* _error_);
void cheese_main_window_set_effects (CheeseMainWindow* self, gboolean effects);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterTapAction* tap, ClutterActor* source);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static void _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_camera_state_change_null (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHEESE_MAIN_WINDOW_actions[6] = {{"file-open", _cheese_main_window_on_file_open_gsimple_action_activate_callback}, {"file-saveas", _cheese_main_window_on_file_saveas_gsimple_action_activate_callback}, {"file-trash", _cheese_main_window_on_file_trash_gsimple_action_activate_callback}, {"file-delete", _cheese_main_window_on_file_delete_gsimple_action_activate_callback}, {"effects-next", _cheese_main_window_on_effects_next_gsimple_action_activate_callback}, {"effects-previous", _cheese_main_window_on_effects_previous_gsimple_action_activate_callback}};

/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType cheese_main_window_delete_response_get_type (void) {
	static volatile gsize cheese_main_window_delete_response_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__volatile)) {
		static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
		g_once_init_leave (&cheese_main_window_delete_response_type_id__volatile, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_open (self);
}


static void _cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_saveas (self);
}


static void _cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_trash (self);
}


static void _cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_delete (self);
}


static void _cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_effects_next (self);
}


static void _cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_effects_previous (self);
}


CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application) {
	CheeseMainWindow * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CheeseMainWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (GtkApplication* application) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW, application);
}


/**
    * Popup a context menu when right-clicking on a thumbnail.
    *
    * @param iconview the thumbnail view that emitted the signal
    * @param event the event
    * @return false to allow further processing of the event, true to indicate
    * that the event was handled completely
    */
static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GdkEventButton _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	GdkEventButton _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreePath* _tmp7_ = NULL;
	CheeseThumbView* _tmp8_ = NULL;
	GtkTreePath* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GdkEventButton _tmp16_ = {0};
	GdkEventType _tmp17_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
	_tmp6_ = _gtk_tree_path_copy0 (_tmp5_);
	_gtk_tree_path_free0 (path);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp8_ = self->priv->thumb_view;
	_tmp9_ = path;
	_tmp10_ = gtk_icon_view_path_is_selected ((GtkIconView*) _tmp8_, _tmp9_);
	if (!_tmp10_) {
		CheeseThumbView* _tmp11_ = NULL;
		CheeseThumbView* _tmp12_ = NULL;
		GtkTreePath* _tmp13_ = NULL;
		CheeseThumbView* _tmp14_ = NULL;
		GtkTreePath* _tmp15_ = NULL;
		_tmp11_ = self->priv->thumb_view;
		g_signal_emit_by_name ((GtkIconView*) _tmp11_, "unselect-all");
		_tmp12_ = self->priv->thumb_view;
		_tmp13_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->thumb_view;
		_tmp15_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp14_, _tmp15_, NULL, FALSE);
	}
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.type;
	if (_tmp17_ == GDK_BUTTON_PRESS) {
		GdkEvent* button_press = NULL;
		GdkEvent* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		button_press = (GdkEvent*) (event);
		_tmp18_ = button_press;
		_tmp19_ = gdk_event_triggers_context_menu (_tmp18_);
		if (_tmp19_) {
			GtkMenu* _tmp20_ = NULL;
			CheeseThumbView* _tmp21_ = NULL;
			GdkEventButton _tmp22_ = {0};
			guint _tmp23_ = 0U;
			GdkEventButton _tmp24_ = {0};
			guint32 _tmp25_ = 0U;
			_tmp20_ = self->priv->thumbnail_popup;
			_tmp21_ = self->priv->thumb_view;
			_tmp22_ = *event;
			_tmp23_ = _tmp22_.button;
			_tmp24_ = *event;
			_tmp25_ = _tmp24_.time;
			gtk_menu_popup (_tmp20_, NULL, (GtkWidget*) _tmp21_, NULL, NULL, _tmp23_, _tmp25_);
		} else {
			GdkEventButton _tmp26_ = {0};
			GdkEventType _tmp27_ = 0;
			_tmp26_ = *event;
			_tmp27_ = _tmp26_.type;
			if (_tmp27_ == GDK_2BUTTON_PRESS) {
				cheese_main_window_on_file_open (self);
			}
		}
		result = TRUE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


/**
   * Open an image associated with a thumbnail in the default application.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void cheese_main_window_on_file_open (CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GdkScreen* _tmp6_ = NULL;
		GdkScreen* _tmp7_ = NULL;
		GdkScreen* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		guint32 _tmp10_ = 0U;
		_tmp4_ = filename;
		_tmp5_ = g_filename_to_uri (_tmp4_, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_g_free0 (uri);
		uri = _tmp3_;
		_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (screen);
		screen = _tmp7_;
		_tmp8_ = screen;
		_tmp9_ = uri;
		_tmp10_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* err = NULL;
		GtkMessageDialog* error_dialog = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkMessageDialog* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		GtkMessageDialog* _tmp15_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _ ("Could not open %s");
		_tmp12_ = filename;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_, _tmp12_);
		g_object_ref_sink (_tmp13_);
		error_dialog = _tmp13_;
		_tmp14_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp14_);
		_tmp15_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   */
static void cheese_main_window_on_file_delete (CheeseMainWindow* self) {
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors = FALSE;
	GList* files = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint files_length = 0U;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkMessageDialog* confirmation_dialog = NULL;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GtkMessageDialog* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	const gchar* _tmp12_ = NULL;
	GtkMessageDialog* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GtkMessageDialog* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	_tmp3_ = g_list_length (_tmp2_);
	files_length = _tmp3_;
	_tmp4_ = files_length;
	_tmp5_ = ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) _tmp4_);
	_tmp6_ = files_length;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp5_, _tmp6_);
	g_object_ref_sink (_tmp7_);
	confirmation_dialog = _tmp7_;
	_tmp8_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp9_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
	_tmp10_ = confirmation_dialog;
	_tmp11_ = files_length;
	_tmp12_ = ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) _tmp11_);
	gtk_message_dialog_format_secondary_text (_tmp10_, "%s", _tmp12_);
	_tmp13_ = confirmation_dialog;
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
	response = _tmp14_;
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp16_ = NULL;
		_tmp16_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp16_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp17_ = NULL;
				GFile* file = NULL;
				_tmp17_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp17_;
				{
					GFile* _tmp18_ = NULL;
					_tmp18_ = file;
					if (_tmp18_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						return;
					}
					{
						GFile* _tmp19_ = NULL;
						_tmp19_ = file;
						g_file_delete (_tmp19_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch7_g_error;
						}
					}
					goto __finally7;
					__catch7_g_error:
					{
						GError* err = NULL;
						GError* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp20_ = err;
						_tmp21_ = _tmp20_->message;
						g_warning ("cheese-window.vala:241: Unable to delete file: %s", _tmp21_);
						_tmp22_ = skip_all_errors;
						if (!_tmp22_) {
							GtkMessageDialog* error_dialog = NULL;
							GFile* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							GtkMessageDialog* _tmp26_ = NULL;
							GtkMessageDialog* _tmp27_ = NULL;
							GtkMessageDialog* _tmp28_ = NULL;
							GtkMessageDialog* _tmp29_ = NULL;
							GtkMessageDialog* _tmp30_ = NULL;
							GtkMessageDialog* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							GtkMessageDialog* _tmp35_ = NULL;
							_tmp23_ = file;
							_tmp24_ = g_file_get_path (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Could not delete %s", _tmp25_);
							g_object_ref_sink (_tmp26_);
							_tmp27_ = _tmp26_;
							_g_free0 (_tmp25_);
							error_dialog = _tmp27_;
							_tmp28_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp28_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
							_tmp29_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp29_, "Skip", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp30_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp30_, "Skip all", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp31_ = error_dialog;
							_tmp32_ = gtk_dialog_run ((GtkDialog*) _tmp31_);
							error_response = _tmp32_;
							_tmp33_ = error_response;
							if (_tmp33_ == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								gint _tmp34_ = 0;
								_tmp34_ = error_response;
								if (_tmp34_ == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp35_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp35_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally7:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp36_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp36_);
	_g_object_unref0 (confirmation_dialog);
	__g_list_free__g_object_unref0_0 (files);
}


/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   */
static void cheese_main_window_on_file_trash (CheeseMainWindow* self) {
	GFile* file = NULL;
	GList* files = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				GList* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
				GList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = files;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = files;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _g_object_ref0 ((GFile*) _tmp11_);
				_g_object_unref0 (file);
				file = _tmp12_;
				_tmp13_ = file;
				if (_tmp13_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp14_ = NULL;
					_tmp14_ = file;
					g_file_trash (_tmp14_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch8_g_error;
					}
				}
				goto __finally8;
				__catch8_g_error:
				{
					GError* err = NULL;
					GtkMessageDialog* error_dialog = NULL;
					const gchar* _tmp15_ = NULL;
					GFile* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					GtkMessageDialog* _tmp19_ = NULL;
					GtkMessageDialog* _tmp20_ = NULL;
					GtkMessageDialog* _tmp21_ = NULL;
					GtkMessageDialog* _tmp22_ = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp15_ = _ ("Could not move %s to trash");
					_tmp16_ = file;
					_tmp17_ = g_file_get_path (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp15_, _tmp18_);
					g_object_ref_sink (_tmp19_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					error_dialog = _tmp20_;
					_tmp21_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp21_);
					_tmp22_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp22_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally8:
				if (_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   */
static void cheese_main_window_on_file_saveas (CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GtkFileChooserDialog* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkFileChooserDialog* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = _ ("Save File");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp3_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp4_;
	_tmp5_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp5_, TRUE);
	_tmp6_ = filename;
	_tmp7_ = g_filename_display_basename (_tmp6_);
	_g_free0 (basename);
	basename = _tmp7_;
	_tmp8_ = save_as_dialog;
	_tmp9_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp8_, _tmp9_);
	_tmp10_ = save_as_dialog;
	_tmp11_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp10_, _tmp11_);
	_tmp12_ = save_as_dialog;
	_tmp13_ = gtk_dialog_run ((GtkDialog*) _tmp12_);
	response = _tmp13_;
	_tmp14_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp14_);
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GFile* src = NULL;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		GFile* dest = NULL;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		_tmp16_ = save_as_dialog;
		_tmp17_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp16_);
		_g_free0 (target_filename);
		target_filename = _tmp17_;
		_tmp18_ = filename;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		src = _tmp19_;
		_tmp20_ = target_filename;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		dest = _tmp21_;
		{
			GFile* _tmp22_ = NULL;
			GFile* _tmp23_ = NULL;
			_tmp22_ = src;
			_tmp23_ = dest;
			g_file_copy (_tmp22_, _tmp23_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* err = NULL;
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GtkMessageDialog* _tmp26_ = NULL;
			GtkMessageDialog* _tmp27_ = NULL;
			GtkMessageDialog* _tmp28_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = _ ("Could not save %s");
			_tmp25_ = target_filename;
			_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp24_, _tmp25_);
			g_object_ref_sink (_tmp26_);
			error_dialog = _tmp26_;
			_tmp27_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp27_);
			_tmp28_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp28_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp29_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


/**
     * Toggle fullscreen mode.
     *
     * @param fullscreen whether the window should be fullscreen
     */
void cheese_main_window_set_fullscreen (CheeseMainWindow* self, gboolean fullscreen) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen;
	cheese_main_window_set_fullscreen_mode (self, _tmp0_);
}


/**
     * Make the media capture mode actions sensitive.
     */
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_ = NULL;
	GtkApplication* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, TRUE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, TRUE);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}


/**
     * Make the media capture mode actions insensitive.
     */
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_ = NULL;
	GtkApplication* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, FALSE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, FALSE);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}


/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseCamera* _tmp0_ = NULL;
	GList* formats = NULL;
	CheeseCamera* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	CheeseVideoFormat* format = NULL;
	gint width = 0;
	gint height = 0;
	CheeseMediaMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = mode;
	switch (_tmp4_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			GSettings* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_int (_tmp5_, "photo-x-resolution");
			width = _tmp6_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, "photo-y-resolution");
			height = _tmp8_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			GSettings* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp9_ = self->priv->settings;
			_tmp10_ = g_settings_get_int (_tmp9_, "video-x-resolution");
			width = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, "video-y-resolution");
			height = _tmp12_;
			break;
		}
		default:
		break;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				gint _tmp16_ = 0;
				GList* _tmp17_ = NULL;
				guint _tmp18_ = 0U;
				GList* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				GList* _tmp21_ = NULL;
				gconstpointer _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_ = 0;
				CheeseVideoFormat* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gboolean _tmp30_ = FALSE;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_ = 0;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = formats;
				_tmp18_ = g_list_length (_tmp17_);
				if (!(((guint) _tmp16_) < _tmp18_)) {
					break;
				}
				_tmp19_ = formats;
				_tmp20_ = i;
				_tmp21_ = g_list_nth (_tmp19_, (guint) _tmp20_);
				_tmp22_ = _tmp21_->data;
				format = (CheeseVideoFormat*) _tmp22_;
				_tmp24_ = width;
				_tmp25_ = format;
				_tmp26_ = _tmp25_->width;
				if (_tmp24_ == _tmp26_) {
					gint _tmp27_ = 0;
					CheeseVideoFormat* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					_tmp27_ = height;
					_tmp28_ = format;
					_tmp29_ = _tmp28_->height;
					_tmp23_ = _tmp27_ == _tmp29_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp30_ = _tmp23_;
				if (_tmp30_) {
					CheeseCamera* _tmp31_ = NULL;
					CheeseVideoFormat* _tmp32_ = NULL;
					_tmp31_ = self->priv->camera;
					_tmp32_ = format;
					cheese_camera_set_video_format (_tmp31_, _tmp32_);
					break;
				}
			}
		}
	}
}


/**
   * Set the current media capture mode, and update the UI sensitivities.
   *
   * @param mode the new capture mode to set
   */
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	g_return_if_fail (self != NULL);
}


/**
   * Clear the fullscreen activity timeout.
   */
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_ = NULL;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean __lambda2_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	GtkGrid* _tmp0_ = NULL;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	GSource* _tmp1_ = NULL;
	GSource* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda2__gsource_func, g_object_ref (self), g_object_unref);
}


/**
   * Show the UI in fullscreen if there is any mouse activity.
   *
   * Start a new timeout at the end of every mouse pointer movement. All
   * timeouts will be cancelled, except one created during the last movement
   * event. Show() is called even if the button is not hidden.
   *
   * @param viewport the widget to check for mouse activity on
   * @param e the (unused) event
   */
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	GtkGrid* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen;
	self->priv->is_fullscreen = _tmp0_;
	_tmp1_ = fullscreen;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		GtkGrid* _tmp5_ = NULL;
		GtkGrid* _tmp6_ = NULL;
		GtkButton** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		GtkClutterEmbed* _tmp12_ = NULL;
		_tmp2_ = self->priv->is_wide_mode;
		if (_tmp2_) {
			GtkAlignment* _tmp3_ = NULL;
			_tmp3_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkAlignment* _tmp4_ = NULL;
			_tmp4_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, FALSE);
		_tmp6_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->buttons;
		_tmp7__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp7_;
			b_collection_length1 = _tmp7__length1;
			for (b_it = 0; b_it < _tmp7__length1; b_it = b_it + 1) {
				GtkButton* _tmp8_ = NULL;
				GtkButton* b = NULL;
				_tmp8_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp8_;
				{
					GtkButton* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					_tmp9_ = b;
					_tmp10_ = gtk_buildable_get_name ((GtkBuildable*) _tmp9_);
					if (g_strcmp0 (_tmp10_, "take_action_button") != 0) {
						GtkButton* _tmp11_ = NULL;
						_tmp11_ = b;
						gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
					}
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp12_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp12_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp13_ = FALSE;
		GtkGrid* _tmp16_ = NULL;
		GtkButton** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		GtkGrid* _tmp22_ = NULL;
		GtkClutterEmbed* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		_tmp13_ = self->priv->is_wide_mode;
		if (_tmp13_) {
			GtkAlignment* _tmp14_ = NULL;
			_tmp14_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp14_);
		} else {
			GtkAlignment* _tmp15_ = NULL;
			_tmp15_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp15_);
		}
		_tmp16_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_hide ((GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->buttons;
		_tmp17__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp17_;
			b_collection_length1 = _tmp17__length1;
			for (b_it = 0; b_it < _tmp17__length1; b_it = b_it + 1) {
				GtkButton* _tmp18_ = NULL;
				GtkButton* b = NULL;
				_tmp18_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp18_;
				{
					GtkButton* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp19_ = b;
					_tmp20_ = gtk_buildable_get_name ((GtkBuildable*) _tmp19_);
					if (g_strcmp0 (_tmp20_, "take_action_button") != 0) {
						GtkButton* _tmp21_ = NULL;
						_tmp21_ = b;
						gtk_button_set_relief (_tmp21_, GTK_RELIEF_NORMAL);
					}
					_g_object_unref0 (b);
				}
			}
		}
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp22_ = self->priv->buttons_area;
		gtk_widget_show ((GtkWidget*) _tmp22_);
		_tmp23_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp24_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	gboolean _tmp0_ = FALSE;
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	GtkClutterEmbed* _tmp3_ = NULL;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GtkRequisition req = {0};
	GtkRequisition _tmp31_ = {0};
	GtkRequisition _tmp32_ = {0};
	GtkRequisition _tmp33_ = {0};
	gint _tmp34_ = 0;
	GtkRequisition _tmp35_ = {0};
	gint _tmp36_ = 0;
	GtkClutterEmbed* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = wide_mode;
	self->priv->is_wide_mode = _tmp0_;
	_tmp1_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = self->priv->viewport_widget;
	_tmp4_ = alloc;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = self->priv->is_wide_mode;
	if (_tmp8_) {
		CheeseThumbView* _tmp9_ = NULL;
		EogThumbNav* _tmp10_ = NULL;
		GtkAlignment* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkAlignment* _tmp15_ = NULL;
		EogThumbNav* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp9_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp9_, TRUE);
		_tmp10_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp10_, TRUE);
		_tmp11_ = self->priv->thumbnails_bottom;
		_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
		if (_tmp12_ != NULL) {
			GtkAlignment* _tmp13_ = NULL;
			EogThumbNav* _tmp14_ = NULL;
			_tmp13_ = self->priv->thumbnails_bottom;
			_tmp14_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		}
		_tmp15_ = self->priv->thumbnails_right;
		_tmp16_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->is_fullscreen;
		if (!_tmp17_) {
			GtkAlignment* _tmp18_ = NULL;
			GtkAlignment* _tmp19_ = NULL;
			_tmp18_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp18_);
			_tmp19_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp19_);
		}
	} else {
		CheeseThumbView* _tmp20_ = NULL;
		EogThumbNav* _tmp21_ = NULL;
		GtkAlignment* _tmp22_ = NULL;
		GtkWidget* _tmp23_ = NULL;
		GtkAlignment* _tmp26_ = NULL;
		EogThumbNav* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		_tmp20_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp20_, FALSE);
		_tmp21_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp21_, FALSE);
		_tmp22_ = self->priv->thumbnails_right;
		_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
		if (_tmp23_ != NULL) {
			GtkAlignment* _tmp24_ = NULL;
			EogThumbNav* _tmp25_ = NULL;
			_tmp24_ = self->priv->thumbnails_right;
			_tmp25_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
		}
		_tmp26_ = self->priv->thumbnails_bottom;
		_tmp27_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->is_fullscreen;
		if (!_tmp28_) {
			GtkAlignment* _tmp29_ = NULL;
			GtkAlignment* _tmp30_ = NULL;
			_tmp29_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp29_);
			_tmp30_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp30_);
		}
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp31_, &_tmp32_);
	req = _tmp31_;
	req = _tmp32_;
	_tmp33_ = req;
	_tmp34_ = _tmp33_.width;
	_tmp35_ = req;
	_tmp36_ = _tmp35_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp34_, _tmp36_);
	_tmp37_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp37_, -1, -1);
}


/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	ClutterActor* _tmp0_ = NULL;
	ClutterStage* _tmp1_ = NULL;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	ClutterStage* _tmp4_ = NULL;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	ClutterActor* _tmp7_ = NULL;
	ClutterStage* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gfloat _tmp10_ = 0.0F;
	ClutterStage* _tmp11_ = NULL;
	gfloat _tmp12_ = 0.0F;
	gfloat _tmp13_ = 0.0F;
	ClutterText* _tmp14_ = NULL;
	ClutterTexture* _tmp15_ = NULL;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	ClutterStage* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterStage* _tmp21_ = NULL;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size (_tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size (_tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->timeout_layer;
	_tmp15_ = self->priv->video_preview;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->viewport;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->viewport;
	_tmp22_ = clutter_actor_get_height ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, (_tmp17_ / 3) + (_tmp20_ / 2), _tmp23_ - 20);
}


/**
   * Toggle whether the countdown is active.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GSettings* _tmp0_ = NULL;
	GtkToggleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = action;
	_tmp2_ = gtk_toggle_action_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


/**
   * The method to call when the countdown is finished.
   */
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	CheeseMediaMode _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		gchar* file_name = NULL;
		CheeseFileUtil* _tmp1_ = NULL;
		CheeseMediaMode _tmp2_ = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GSettings* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		GtkGrid* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		CheeseCamera* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		file_name = _tmp4_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "flash");
		if (_tmp6_) {
			CheeseFlash* _tmp7_ = NULL;
			_tmp7_ = self->priv->flash;
			cheese_flash_fire (_tmp7_);
		}
		_tmp8_ = self->priv->main_vbox;
		_tmp9_ = _ ("Shutter sound");
		ca_gtk_play_for_widget ((GtkWidget*) _tmp8_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp9_, NULL, NULL);
		_tmp10_ = self->priv->camera;
		_tmp11_ = file_name;
		cheese_camera_take_photo (_tmp10_, _tmp11_);
		_g_free0 (file_name);
	}
	_tmp12_ = self->priv->current_mode;
	if (_tmp12_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "countdown");
	if (_tmp1_) {
		CheeseMediaMode _tmp2_ = 0;
		ClutterText* _tmp3_ = NULL;
		CheeseCountdown* _tmp4_ = NULL;
		CheeseCountdown* _tmp5_ = NULL;
		_tmp2_ = self->priv->current_mode;
		if (_tmp2_ == CHEESE_MEDIA_MODE_PHOTO) {
			cheese_main_window_disable_mode_change (self);
		}
		_tmp3_ = self->priv->countdown_layer;
		_tmp4_ = cheese_countdown_new (_tmp3_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp4_;
		_tmp5_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp5_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_ = 0;
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-repeat");
		_tmp0_ = _tmp2_ < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_ = 0;
		cheese_main_window_take_photo (self);
		_tmp6_ = self->priv->burst_count;
		self->priv->burst_count = _tmp6_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (key);
	key = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = key;
	_tmp6_ = _tmp4_ (_tmp5_, "Escape");
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		CheeseCountdown* _tmp10_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp10_ = self->priv->current_countdown;
		if (_tmp10_ != NULL) {
			CheeseCountdown* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp11_ = self->priv->current_countdown;
			_tmp12_ = _tmp11_->running;
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp14_ = FALSE;
			_tmp14_ = self->priv->is_bursting;
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp16_ = FALSE;
			_tmp16_ = self->priv->is_recording;
			_tmp7_ = _tmp16_;
		}
		_tmp17_ = _tmp7_;
		if (_tmp17_) {
			CheeseMediaMode _tmp18_ = 0;
			self->priv->action_cancelled = TRUE;
			_tmp18_ = self->priv->current_mode;
			switch (_tmp18_) {
				case CHEESE_MEDIA_MODE_PHOTO:
				{
					CheeseCountdown* _tmp19_ = NULL;
					_tmp19_ = self->priv->current_countdown;
					cheese_countdown_stop (_tmp19_);
					cheese_main_window_finish_countdown_callback (self);
					break;
				}
				case CHEESE_MEDIA_MODE_BURST:
				{
					cheese_main_window_toggle_photo_bursting (self, FALSE);
					break;
				}
				case CHEESE_MEDIA_MODE_VIDEO:
				{
					cheese_main_window_toggle_video_recording (self, FALSE);
					break;
				}
				default:
				break;
			}
			self->priv->action_cancelled = FALSE;
		} else {
			gboolean _tmp20_ = FALSE;
			_tmp20_ = self->priv->is_effects_selector_active;
			if (_tmp20_) {
				GtkToggleButton* _tmp21_ = NULL;
				_tmp21_ = self->priv->effects_toggle_button;
				gtk_toggle_button_set_active (_tmp21_, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_update_timeout_layer (self);
	return result;
}


void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		CheeseCamera* _tmp1_ = NULL;
		CheeseFileUtil* _tmp2_ = NULL;
		CheeseMediaMode _tmp3_ = 0;
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GtkButton* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkImage* _tmp13_ = NULL;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->fileutil;
		_tmp3_ = self->priv->current_mode;
		_tmp4_ = cheese_fileutil_get_new_media_filename (_tmp2_, _tmp3_);
		cheese_camera_start_video_recording (_tmp1_, _tmp4_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _cheese_main_window_update_timeout_layer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp5_ = self->priv->take_action_button_label;
		_tmp6_ = _ ("Stop _Recording");
		_tmp7_ = g_strconcat ("<b>", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "</b>", NULL);
		_tmp10_ = _tmp9_;
		gtk_label_set_label (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp11_ = self->priv->take_action_button;
		_tmp12_ = _ ("Stop recording");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
		_tmp13_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp13_, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp14_ = NULL;
		ClutterText* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GtkButton* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GtkImage* _tmp24_ = NULL;
		_tmp14_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp14_);
		_tmp15_ = self->priv->timeout_layer;
		clutter_text_set_text (_tmp15_, "00:00:00");
		_tmp16_ = self->priv->take_action_button_label;
		_tmp17_ = _ ("_Record a Video");
		_tmp18_ = g_strconcat ("<b>", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, "</b>", NULL);
		_tmp21_ = _tmp20_;
		gtk_label_set_label (_tmp16_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp22_ = self->priv->take_action_button;
		_tmp23_ = _ ("Record a video");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp23_);
		_tmp24_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp24_, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Update the timeout layer displayed timer.
   *
   * @return false, if the source, Timeout.add_seconds (used
   * in the toogle_video_recording method), should be removed.
   */
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_recording;
	if (_tmp0_) {
		ClutterText* _tmp1_ = NULL;
		CheeseCamera* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp1_ = self->priv->timeout_layer;
		_tmp2_ = self->priv->camera;
		_tmp3_ = cheese_camera_get_recorded_time (_tmp2_);
		_tmp4_ = _tmp3_;
		clutter_text_set_text (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		GtkLabel* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GtkButton* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint burst_delay = 0;
		GSettings* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint countdown_duration = 0;
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gboolean _tmp18_ = FALSE;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp1_ = self->priv->take_action_button_label;
		_tmp2_ = _ ("Stop _Taking Pictures");
		_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp1_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp7_ = self->priv->take_action_button;
		_tmp8_ = _ ("Stop taking pictures");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp8_);
		cheese_main_window_burst_take_photo (self);
		_tmp9_ = self->priv->settings;
		_tmp10_ = g_settings_get_int (_tmp9_, "burst-delay");
		burst_delay = _tmp10_;
		_tmp11_ = self->priv->settings;
		_tmp12_ = g_settings_get_int (_tmp11_, "countdown-duration");
		countdown_duration = 500 + (_tmp12_ * 1000);
		_tmp14_ = burst_delay;
		_tmp15_ = countdown_duration;
		if ((_tmp14_ - _tmp15_) < 1000) {
			GSettings* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = self->priv->settings;
			_tmp17_ = g_settings_get_boolean (_tmp16_, "countdown");
			_tmp13_ = _tmp17_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp18_ = _tmp13_;
		if (_tmp18_) {
			gint _tmp19_ = 0;
			guint _tmp20_ = 0U;
			_tmp19_ = countdown_duration;
			_tmp20_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp19_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp20_;
		} else {
			gint _tmp21_ = 0;
			guint _tmp22_ = 0U;
			_tmp21_ = burst_delay;
			_tmp22_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp21_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp22_;
		}
	} else {
		gboolean _tmp23_ = FALSE;
		CheeseCountdown* _tmp24_ = NULL;
		gboolean _tmp27_ = FALSE;
		GtkLabel* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		GtkButton* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		CheeseFileUtil* _tmp37_ = NULL;
		guint _tmp38_ = 0U;
		_tmp24_ = self->priv->current_countdown;
		if (_tmp24_ != NULL) {
			CheeseCountdown* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = self->priv->current_countdown;
			_tmp26_ = _tmp25_->running;
			_tmp23_ = _tmp26_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp27_ = _tmp23_;
		if (_tmp27_) {
			CheeseCountdown* _tmp28_ = NULL;
			_tmp28_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp28_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp29_ = self->priv->take_action_button_label;
		_tmp30_ = _ ("Take Multiple Photos");
		_tmp31_ = g_strconcat ("<b>", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "</b>", NULL);
		_tmp34_ = _tmp33_;
		gtk_label_set_label (_tmp29_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_tmp35_ = self->priv->take_action_button;
		_tmp36_ = _ ("Take multiple photos");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp36_);
		self->priv->burst_count = 0;
		_tmp37_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp37_);
		_tmp38_ = self->priv->burst_callback_id;
		g_source_remove (_tmp38_);
	}
}


/**
     * Take a photo or burst of photos, or record a video, based on the current
     * capture mode.
     */
void cheese_main_window_shoot (CheeseMainWindow* self) {
	CheeseMediaMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_mode;
	switch (_tmp0_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			cheese_main_window_take_photo (self);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp1_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->is_bursting;
			cheese_main_window_toggle_photo_bursting (self, !_tmp2_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


/**
     * Show an error.
     *
     * @param error the error to display, or null to hide the error layer
     */
void cheese_main_window_show_error (CheeseMainWindow* self, const gchar* _error_) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_ = NULL;
		ClutterTexture* _tmp2_ = NULL;
		ClutterText* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		ClutterText* _tmp5_ = NULL;
		_tmp1_ = self->priv->current_effects_grid;
		clutter_actor_hide (_tmp1_);
		_tmp2_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->error_layer;
		_tmp4_ = _error_;
		clutter_text_set_text (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->error_layer;
		clutter_actor_show ((ClutterActor*) _tmp5_);
	} else {
		ClutterText* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->error_layer;
		clutter_actor_hide ((ClutterActor*) _tmp6_);
		_tmp7_ = self->priv->is_effects_selector_active;
		if (_tmp7_) {
			ClutterActor* _tmp8_ = NULL;
			_tmp8_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp8_);
		} else {
			ClutterTexture* _tmp9_ = NULL;
			_tmp9_ = self->priv->video_preview;
			clutter_actor_show ((ClutterActor*) _tmp9_);
		}
	}
}


/**
     * Toggle the display of the effect selector.
     *
     * @param effects whether effects should be enabled
     */
void cheese_main_window_set_effects (CheeseMainWindow* self, gboolean effects) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = effects;
	cheese_main_window_toggle_effects_selector (self, _tmp0_);
}


/**
   * Change the selected effect, as a new one was selected.
   *
   * @param tap unused
   * @param source the actor (with associated effect) that was selected
   */
void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterTapAction* tap, ClutterActor* source) {
	GtkToggleButton* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	CheeseEffect* _tmp3_ = NULL;
	CheeseCamera* _tmp4_ = NULL;
	CheeseEffect* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	CheeseEffect* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->effects_toggle_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_tmp1_ = source;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "effect");
	_tmp3_ = _g_object_ref0 ((CheeseEffect*) _tmp2_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp3_;
	_tmp4_ = self->priv->camera;
	_tmp5_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->selected_effect;
	_tmp8_ = cheese_effect_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	g_settings_set_string (_tmp6_, "selected-effect", _tmp9_);
}


/**
     * Navigate back one page of effects.
     */
static void cheese_main_window_on_effects_previous (CheeseMainWindow* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_page;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp1_) - 1);
	}
}


/**
     * Navigate forward one page of effects.
     */
static void cheese_main_window_on_effects_next (CheeseMainWindow* self) {
	guint _tmp0_ = 0U;
	CheeseEffectsManager* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp0_ != (_tmp3_ / EFFECTS_PER_PAGE)) {
		guint _tmp4_ = 0U;
		_tmp4_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp4_) + 1);
	}
}


/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	ClutterActor* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	GList* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gconstpointer _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterActor* _tmp20_ = NULL;
	ClutterActor* _tmp21_ = NULL;
	guint i = 0U;
	CheeseEffectsManager* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = number;
	self->priv->current_effects_page = (guint) _tmp1_;
	_tmp2_ = self->priv->viewport_layout;
	_tmp3_ = clutter_actor_get_children (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_effects_grid;
	_tmp6_ = g_list_index (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_ != (-1);
	_g_list_free0 (_tmp4_);
	if (_tmp7_) {
		ClutterActor* _tmp8_ = NULL;
		ClutterActor* _tmp9_ = NULL;
		_tmp8_ = self->priv->viewport_layout;
		_tmp9_ = self->priv->current_effects_grid;
		clutter_actor_remove_child (_tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->effects_grids;
	_tmp11_ = number;
	_tmp12_ = g_list_nth_data (_tmp10_, (guint) _tmp11_);
	_tmp13_ = _g_object_ref0 ((ClutterActor*) _tmp12_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = _tmp13_;
	_tmp14_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp14_, (guint) 0);
	_tmp15_ = self->priv->viewport_layout;
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_add_child (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->current_effects_grid;
	clutter_actor_save_easing_state (_tmp17_);
	_tmp18_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_mode (_tmp18_, CLUTTER_LINEAR);
	_tmp19_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_duration (_tmp19_, (guint) 500);
	_tmp20_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp20_, (guint) 255);
	_tmp21_ = self->priv->current_effects_grid;
	clutter_actor_restore_easing_state (_tmp21_);
	i = (guint) 0;
	_tmp22_ = self->priv->effects_manager;
	_tmp23_ = _tmp22_->effects;
	{
		GList* effect_collection = NULL;
		GList* effect_it = NULL;
		effect_collection = _tmp23_;
		for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
			CheeseEffect* _tmp24_ = NULL;
			CheeseEffect* effect = NULL;
			_tmp24_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
			effect = _tmp24_;
			{
				guint page_nr = 0U;
				guint _tmp25_ = 0U;
				guint _tmp26_ = 0U;
				gint _tmp27_ = 0;
				guint _tmp40_ = 0U;
				_tmp25_ = i;
				page_nr = _tmp25_ / EFFECTS_PER_PAGE;
				_tmp26_ = page_nr;
				_tmp27_ = number;
				if (_tmp26_ == ((guint) _tmp27_)) {
					CheeseEffect* _tmp28_ = NULL;
					gboolean _tmp29_ = FALSE;
					CheeseEffect* _tmp36_ = NULL;
					_tmp28_ = effect;
					_tmp29_ = cheese_effect_is_preview_connected (_tmp28_);
					if (!_tmp29_) {
						ClutterTexture* texture = NULL;
						CheeseEffect* _tmp30_ = NULL;
						gconstpointer _tmp31_ = NULL;
						ClutterTexture* _tmp32_ = NULL;
						CheeseCamera* _tmp33_ = NULL;
						CheeseEffect* _tmp34_ = NULL;
						ClutterTexture* _tmp35_ = NULL;
						_tmp30_ = effect;
						_tmp31_ = g_object_get_data ((GObject*) _tmp30_, "texture");
						_tmp32_ = _g_object_ref0 ((ClutterTexture*) _tmp31_);
						texture = _tmp32_;
						_tmp33_ = self->priv->camera;
						_tmp34_ = effect;
						_tmp35_ = texture;
						cheese_camera_connect_effect_texture (_tmp33_, _tmp34_, _tmp35_);
						_g_object_unref0 (texture);
					}
					_tmp36_ = effect;
					cheese_effect_enable_preview (_tmp36_);
				} else {
					CheeseEffect* _tmp37_ = NULL;
					gboolean _tmp38_ = FALSE;
					_tmp37_ = effect;
					_tmp38_ = cheese_effect_is_preview_connected (_tmp37_);
					if (_tmp38_) {
						CheeseEffect* _tmp39_ = NULL;
						_tmp39_ = effect;
						cheese_effect_disable_preview (_tmp39_);
					}
				}
				_tmp40_ = i;
				i = _tmp40_ + 1;
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
     * Control the sensitivity of the effects page navigation buttons.
     */
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	GSimpleAction* effects_next = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* effects_previous = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GSimpleAction* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects-next");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects_next = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "effects-previous");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	effects_previous = _tmp3_;
	_tmp5_ = self->priv->is_effects_selector_active;
	if (_tmp5_) {
		guint _tmp6_ = 0U;
		CheeseEffectsManager* _tmp7_ = NULL;
		GList* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		_tmp6_ = self->priv->current_effects_page;
		_tmp7_ = self->priv->effects_manager;
		_tmp8_ = _tmp7_->effects;
		_tmp9_ = g_list_length (_tmp8_);
		_tmp4_ = _tmp6_ != (_tmp9_ / EFFECTS_PER_PAGE);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp10_ = effects_next;
	_tmp11_ = _tmp4_;
	g_simple_action_set_enabled (_tmp10_, _tmp11_);
	_tmp13_ = self->priv->is_effects_selector_active;
	if (_tmp13_) {
		guint _tmp14_ = 0U;
		_tmp14_ = self->priv->current_effects_page;
		_tmp12_ = _tmp14_ != ((guint) 0);
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = effects_previous;
	_tmp16_ = _tmp12_;
	g_simple_action_set_enabled (_tmp15_, _tmp16_);
	_g_object_unref0 (effects_previous);
	_g_object_unref0 (effects_next);
}


/**
     * Toggle the visibility of the effects selector.
     *
     * @param active whether the selector should be active
     */
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	CheeseCamera* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_effects_selector_active = _tmp0_;
	_tmp1_ = self->priv->effects_grids;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = active;
		if (_tmp4_) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _ ("No effects found");
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = NULL;
		}
		_tmp6_ = _tmp3_;
		cheese_main_window_show_error (self, _tmp6_);
	} else {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = active;
		if (_tmp7_) {
			ClutterTexture* _tmp8_ = NULL;
			ClutterActor* _tmp9_ = NULL;
			guint _tmp10_ = 0U;
			_tmp8_ = self->priv->video_preview;
			clutter_actor_hide ((ClutterActor*) _tmp8_);
			_tmp9_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp9_);
			_tmp10_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, (gint) _tmp10_);
		} else {
			ClutterActor* _tmp11_ = NULL;
			ClutterTexture* _tmp12_ = NULL;
			_tmp11_ = self->priv->current_effects_grid;
			clutter_actor_hide (_tmp11_);
			_tmp12_ = self->priv->video_preview;
			clutter_actor_show ((ClutterActor*) _tmp12_);
		}
	}
	_tmp13_ = self->priv->camera;
	_tmp14_ = active;
	cheese_camera_toggle_effects_pipeline (_tmp13_, _tmp14_);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Create the effects selector.
   */
static void _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self) {
	cheese_main_window_on_selected_effect_change (self, _sender, actor);
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_ = NULL;
		CheeseEffectsManager* _tmp2_ = NULL;
		CheeseEffectsManager* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		CheeseEffectsManager* _tmp6_ = NULL;
		GList* _tmp7_ = NULL;
		guint i = 0U;
		CheeseEffectsManager* _tmp17_ = NULL;
		GList* _tmp18_ = NULL;
		GList* _tmp77_ = NULL;
		gconstpointer _tmp78_ = NULL;
		ClutterActor* _tmp79_ = NULL;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
		self->priv->effects_grids = NULL;
		_tmp3_ = self->priv->effects_manager;
		_tmp4_ = _tmp3_->effects;
		_tmp5_ = g_list_length (_tmp4_);
		if (_tmp5_ == ((guint) 0)) {
			g_warning ("cheese-window.vala:1066: gnome-video-effects is not installed.");
			return;
		}
		_tmp6_ = self->priv->effects_manager;
		_tmp7_ = _tmp6_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp7_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp8_ = NULL;
				CheeseEffect* effect = NULL;
				_tmp8_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp8_;
				{
					ClutterTableLayout* table_layout = NULL;
					ClutterTableLayout* _tmp9_ = NULL;
					ClutterActor* grid = NULL;
					ClutterActor* _tmp10_ = NULL;
					ClutterActor* _tmp11_ = NULL;
					ClutterTableLayout* _tmp12_ = NULL;
					ClutterActor* _tmp13_ = NULL;
					ClutterActor* _tmp14_ = NULL;
					ClutterTableLayout* _tmp15_ = NULL;
					ClutterTableLayout* _tmp16_ = NULL;
					_tmp9_ = (ClutterTableLayout*) clutter_table_layout_new ();
					g_object_ref_sink (_tmp9_);
					table_layout = _tmp9_;
					_tmp10_ = clutter_actor_new ();
					g_object_ref_sink (_tmp10_);
					grid = _tmp10_;
					_tmp11_ = grid;
					_tmp12_ = table_layout;
					clutter_actor_set_layout_manager (_tmp11_, (ClutterLayoutManager*) _tmp12_);
					_tmp13_ = grid;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					self->priv->effects_grids = g_list_append (self->priv->effects_grids, _tmp14_);
					_tmp15_ = table_layout;
					clutter_table_layout_set_column_spacing (_tmp15_, (guint) 10);
					_tmp16_ = table_layout;
					clutter_table_layout_set_row_spacing (_tmp16_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (table_layout);
					_g_object_unref0 (effect);
				}
			}
		}
		i = (guint) 0;
		_tmp17_ = self->priv->effects_manager;
		_tmp18_ = _tmp17_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp18_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp19_ = NULL;
				CheeseEffect* effect = NULL;
				_tmp19_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp19_;
				{
					ClutterTexture* texture = NULL;
					ClutterTexture* _tmp20_ = NULL;
					ClutterBinLayout* layout = NULL;
					ClutterBinLayout* _tmp21_ = NULL;
					ClutterActor* box = NULL;
					ClutterActor* _tmp22_ = NULL;
					ClutterActor* _tmp23_ = NULL;
					ClutterBinLayout* _tmp24_ = NULL;
					ClutterText* text = NULL;
					ClutterText* _tmp25_ = NULL;
					ClutterActor* rect = NULL;
					ClutterActor* _tmp26_ = NULL;
					ClutterActor* _tmp27_ = NULL;
					ClutterActor* _tmp28_ = NULL;
					ClutterColor _tmp29_ = {0};
					ClutterTexture* _tmp30_ = NULL;
					ClutterActor* _tmp31_ = NULL;
					ClutterTexture* _tmp32_ = NULL;
					ClutterActor* _tmp33_ = NULL;
					ClutterTapAction* tap = NULL;
					ClutterTapAction* _tmp34_ = NULL;
					ClutterActor* _tmp35_ = NULL;
					ClutterTapAction* _tmp36_ = NULL;
					ClutterTapAction* _tmp37_ = NULL;
					ClutterActor* _tmp38_ = NULL;
					CheeseEffect* _tmp39_ = NULL;
					CheeseEffect* _tmp40_ = NULL;
					CheeseEffect* _tmp41_ = NULL;
					ClutterTexture* _tmp42_ = NULL;
					ClutterTexture* _tmp43_ = NULL;
					ClutterText* _tmp44_ = NULL;
					CheeseEffect* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					ClutterText* _tmp48_ = NULL;
					ClutterColor _tmp49_ = {0};
					ClutterActor* _tmp50_ = NULL;
					ClutterText* _tmp51_ = NULL;
					gfloat _tmp52_ = 0.0F;
					gfloat _tmp53_ = 0.0F;
					ClutterActor* _tmp54_ = NULL;
					ClutterActor* _tmp55_ = NULL;
					ClutterActor* _tmp56_ = NULL;
					ClutterActor* _tmp57_ = NULL;
					ClutterActor* _tmp58_ = NULL;
					ClutterActor* _tmp59_ = NULL;
					ClutterText* _tmp60_ = NULL;
					ClutterText* _tmp61_ = NULL;
					ClutterText* _tmp62_ = NULL;
					ClutterText* _tmp63_ = NULL;
					ClutterActor* _tmp64_ = NULL;
					ClutterText* _tmp65_ = NULL;
					ClutterTableLayout* table_layout = NULL;
					GList* _tmp66_ = NULL;
					guint _tmp67_ = 0U;
					gconstpointer _tmp68_ = NULL;
					ClutterLayoutManager* _tmp69_ = NULL;
					ClutterLayoutManager* _tmp70_ = NULL;
					ClutterTableLayout* _tmp71_ = NULL;
					ClutterTableLayout* _tmp72_ = NULL;
					ClutterActor* _tmp73_ = NULL;
					guint _tmp74_ = 0U;
					guint _tmp75_ = 0U;
					guint _tmp76_ = 0U;
					_tmp20_ = (ClutterTexture*) clutter_texture_new ();
					g_object_ref_sink (_tmp20_);
					texture = _tmp20_;
					_tmp21_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					g_object_ref_sink (_tmp21_);
					layout = _tmp21_;
					_tmp22_ = clutter_actor_new ();
					g_object_ref_sink (_tmp22_);
					box = _tmp22_;
					_tmp23_ = box;
					_tmp24_ = layout;
					clutter_actor_set_layout_manager (_tmp23_, (ClutterLayoutManager*) _tmp24_);
					_tmp25_ = (ClutterText*) clutter_text_new ();
					g_object_ref_sink (_tmp25_);
					text = _tmp25_;
					_tmp26_ = clutter_actor_new ();
					g_object_ref_sink (_tmp26_);
					rect = _tmp26_;
					_tmp27_ = rect;
					clutter_actor_set_opacity (_tmp27_, (guint) 128);
					_tmp28_ = rect;
					clutter_color_from_string (&_tmp29_, "black");
					clutter_actor_set_background_color (_tmp28_, &_tmp29_);
					_tmp30_ = texture;
					clutter_texture_set_keep_aspect_ratio (_tmp30_, TRUE);
					_tmp31_ = box;
					_tmp32_ = texture;
					clutter_actor_add_child (_tmp31_, (ClutterActor*) _tmp32_);
					_tmp33_ = box;
					clutter_actor_set_reactive (_tmp33_, TRUE);
					_tmp34_ = (ClutterTapAction*) clutter_tap_action_new ();
					g_object_ref_sink (_tmp34_);
					tap = _tmp34_;
					_tmp35_ = box;
					_tmp36_ = tap;
					clutter_actor_add_action (_tmp35_, (ClutterAction*) _tmp36_);
					_tmp37_ = tap;
					g_signal_connect_object (_tmp37_, "tap", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap, self, 0);
					_tmp38_ = box;
					_tmp39_ = effect;
					_tmp40_ = _g_object_ref0 (_tmp39_);
					g_object_set_data_full ((GObject*) _tmp38_, "effect", _tmp40_, g_object_unref);
					_tmp41_ = effect;
					_tmp42_ = texture;
					_tmp43_ = _g_object_ref0 (_tmp42_);
					g_object_set_data_full ((GObject*) _tmp41_, "texture", _tmp43_, g_object_unref);
					_tmp44_ = text;
					_tmp45_ = effect;
					_tmp46_ = cheese_effect_get_name (_tmp45_);
					_tmp47_ = _tmp46_;
					clutter_text_set_text (_tmp44_, _tmp47_);
					_tmp48_ = text;
					clutter_color_from_string (&_tmp49_, "white");
					clutter_text_set_color (_tmp48_, &_tmp49_);
					_tmp50_ = rect;
					_tmp51_ = text;
					_tmp52_ = clutter_actor_get_height ((ClutterActor*) _tmp51_);
					_tmp53_ = _tmp52_;
					clutter_actor_set_height (_tmp50_, _tmp53_ + 5);
					_tmp54_ = rect;
					clutter_actor_set_x_align (_tmp54_, CLUTTER_ACTOR_ALIGN_FILL);
					_tmp55_ = rect;
					clutter_actor_set_y_align (_tmp55_, CLUTTER_ACTOR_ALIGN_END);
					_tmp56_ = rect;
					clutter_actor_set_x_expand (_tmp56_, TRUE);
					_tmp57_ = rect;
					clutter_actor_set_y_expand (_tmp57_, TRUE);
					_tmp58_ = box;
					_tmp59_ = rect;
					clutter_actor_add_child (_tmp58_, _tmp59_);
					_tmp60_ = text;
					clutter_actor_set_x_align ((ClutterActor*) _tmp60_, CLUTTER_ACTOR_ALIGN_CENTER);
					_tmp61_ = text;
					clutter_actor_set_y_align ((ClutterActor*) _tmp61_, CLUTTER_ACTOR_ALIGN_END);
					_tmp62_ = text;
					clutter_actor_set_x_expand ((ClutterActor*) _tmp62_, TRUE);
					_tmp63_ = text;
					clutter_actor_set_y_expand ((ClutterActor*) _tmp63_, TRUE);
					_tmp64_ = box;
					_tmp65_ = text;
					clutter_actor_add_child (_tmp64_, (ClutterActor*) _tmp65_);
					_tmp66_ = self->priv->effects_grids;
					_tmp67_ = i;
					_tmp68_ = g_list_nth_data (_tmp66_, _tmp67_ / EFFECTS_PER_PAGE);
					_tmp69_ = clutter_actor_get_layout_manager ((ClutterActor*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, clutter_table_layout_get_type (), ClutterTableLayout));
					table_layout = _tmp71_;
					_tmp72_ = table_layout;
					_tmp73_ = box;
					_tmp74_ = i;
					_tmp75_ = i;
					clutter_table_layout_pack (_tmp72_, _tmp73_, ((gint) (_tmp74_ % EFFECTS_PER_PAGE)) % 3, ((gint) (_tmp75_ % EFFECTS_PER_PAGE)) / 3);
					_tmp76_ = i;
					i = _tmp76_ + 1;
					_g_object_unref0 (table_layout);
					_g_object_unref0 (tap);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp77_ = self->priv->effects_grids;
		_tmp78_ = g_list_nth_data (_tmp77_, (guint) 0);
		_tmp79_ = _g_object_ref0 ((ClutterActor*) _tmp78_);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = _tmp79_;
	}
}


/**
     * Update the UI when the camera starts playing.
     */
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self) {
	CheeseEffect* effect = NULL;
	CheeseEffectsManager* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	CheeseEffect* _tmp4_ = NULL;
	CheeseEffect* _tmp5_ = NULL;
	CheeseEffect* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	cheese_main_window_show_error (self, NULL);
	_tmp0_ = self->priv->effects_manager;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "selected-effect");
	_tmp3_ = _tmp2_;
	_tmp4_ = cheese_effects_manager_get_effect (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	effect = _tmp5_;
	_tmp6_ = effect;
	if (_tmp6_ != NULL) {
		CheeseCamera* _tmp7_ = NULL;
		CheeseEffect* _tmp8_ = NULL;
		_tmp7_ = self->priv->camera;
		_tmp8_ = effect;
		cheese_camera_set_effect (_tmp7_, _tmp8_);
	}
	_g_object_unref0 (effect);
}


/**
     * Report an error as the camerabin switched to the NULL state.
     */
void cheese_main_window_camera_state_change_null (CheeseMainWindow* self) {
	ClutterText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->error_layer;
	g_object_get ((ClutterActor*) _tmp0_, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("There was an error playing video from the webcam");
		cheese_main_window_show_error (self, _tmp3_);
	}
}


/**
   * Load the UI from the GtkBuilder description.
   */
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, box, flags);
}


static gboolean _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_button_press_event (self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release (self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GtkBuilder* _tmp0_ = NULL;
	ClutterScript* _tmp1_ = NULL;
	CheeseFileUtil* _tmp2_ = NULL;
	CheeseFlash* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp5_ = NULL;
	GMenu* section = NULL;
	GMenu* _tmp6_ = NULL;
	GMenu* _tmp7_ = NULL;
	GMenu* _tmp8_ = NULL;
	GMenuItem* item = NULL;
	const gchar* _tmp9_ = NULL;
	GMenuItem* _tmp10_ = NULL;
	GMenuItem* _tmp11_ = NULL;
	GMenu* _tmp12_ = NULL;
	GMenuItem* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GMenuItem* _tmp15_ = NULL;
	GMenuItem* _tmp16_ = NULL;
	GMenu* _tmp17_ = NULL;
	GMenuItem* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GMenuItem* _tmp20_ = NULL;
	GMenuItem* _tmp21_ = NULL;
	GMenu* _tmp22_ = NULL;
	GMenuItem* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GMenuItem* _tmp25_ = NULL;
	GMenuItem* _tmp26_ = NULL;
	GMenu* _tmp27_ = NULL;
	GMenuItem* _tmp28_ = NULL;
	GMenu* _tmp29_ = NULL;
	GtkMenu* _tmp30_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkGrid* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkWidget* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkClutterEmbed* _tmp47_ = NULL;
	GtkClutterEmbed* _tmp48_ = NULL;
	ClutterActor* _tmp49_ = NULL;
	ClutterStage* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkAlignment* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkAlignment* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkGrid* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkToggleButton* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkToggleButton* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkToggleButton* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkButton* _tmp71_ = NULL;
	GtkBuilder* _tmp72_ = NULL;
	GObject* _tmp73_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	GObject* _tmp76_ = NULL;
	GtkImage* _tmp77_ = NULL;
	GtkBuilder* _tmp78_ = NULL;
	GObject* _tmp79_ = NULL;
	GtkToggleButton* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	GObject* _tmp82_ = NULL;
	GtkButton* _tmp83_ = NULL;
	GtkBuilder* _tmp84_ = NULL;
	GObject* _tmp85_ = NULL;
	GtkGrid* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	GObject* _tmp88_ = NULL;
	GtkAction* _tmp89_ = NULL;
	GtkToggleButton* _tmp90_ = NULL;
	GtkButton* _tmp91_ = NULL;
	GtkToggleButton* _tmp92_ = NULL;
	GtkButton* _tmp93_ = NULL;
	GtkToggleButton* _tmp94_ = NULL;
	GtkButton* _tmp95_ = NULL;
	GtkButton* _tmp96_ = NULL;
	GtkButton* _tmp97_ = NULL;
	GtkToggleButton* _tmp98_ = NULL;
	GtkButton* _tmp99_ = NULL;
	GtkButton* _tmp100_ = NULL;
	GtkButton* _tmp101_ = NULL;
	GtkButton** _tmp102_ = NULL;
	ClutterScript* _tmp103_ = NULL;
	GObject* _tmp104_ = NULL;
	ClutterTexture* _tmp105_ = NULL;
	ClutterScript* _tmp106_ = NULL;
	GObject* _tmp107_ = NULL;
	ClutterActor* _tmp108_ = NULL;
	ClutterScript* _tmp109_ = NULL;
	GObject* _tmp110_ = NULL;
	ClutterBinLayout* _tmp111_ = NULL;
	ClutterScript* _tmp112_ = NULL;
	GObject* _tmp113_ = NULL;
	ClutterText* _tmp114_ = NULL;
	ClutterScript* _tmp115_ = NULL;
	GObject* _tmp116_ = NULL;
	ClutterActor* _tmp117_ = NULL;
	ClutterScript* _tmp118_ = NULL;
	GObject* _tmp119_ = NULL;
	ClutterText* _tmp120_ = NULL;
	ClutterScript* _tmp121_ = NULL;
	GObject* _tmp122_ = NULL;
	ClutterText* _tmp123_ = NULL;
	ClutterTexture* _tmp124_ = NULL;
	ClutterTexture* _tmp125_ = NULL;
	ClutterStage* _tmp126_ = NULL;
	ClutterActor* _tmp127_ = NULL;
	ClutterActor* _tmp128_ = NULL;
	ClutterBinLayout* _tmp129_ = NULL;
	ClutterStage* _tmp130_ = NULL;
	ClutterActor* _tmp131_ = NULL;
	ClutterStage* _tmp132_ = NULL;
	ClutterText* _tmp133_ = NULL;
	ClutterStage* _tmp134_ = NULL;
	CheeseThumbView* _tmp135_ = NULL;
	CheeseThumbView* _tmp136_ = NULL;
	EogThumbNav* _tmp137_ = NULL;
	GtkMenu* _tmp138_ = NULL;
	CheeseThumbView* _tmp139_ = NULL;
	GtkCssProvider* css = NULL;
	GdkScreen* _tmp146_ = NULL;
	GdkScreen* _tmp147_ = NULL;
	CheeseThumbView* _tmp148_ = NULL;
	GtkGrid* _tmp149_ = NULL;
	GtkGrid* _tmp150_ = NULL;
	GtkClutterEmbed* _tmp151_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->gtk_builder);
	self->priv->gtk_builder = _tmp0_;
	_tmp1_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp1_;
	_tmp2_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp2_;
	_tmp3_ = cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = g_menu_new ();
	menu = _tmp5_;
	_tmp6_ = g_menu_new ();
	section = _tmp6_;
	_tmp7_ = menu;
	_tmp8_ = section;
	g_menu_append_section (_tmp7_, NULL, (GMenuModel*) _tmp8_);
	_tmp9_ = _ ("Open");
	_tmp10_ = g_menu_item_new (_tmp9_, "win.file-open");
	item = _tmp10_;
	_tmp11_ = item;
	g_menu_item_set_attribute (_tmp11_, "accel", "s", "<Primary>o", NULL);
	_tmp12_ = section;
	_tmp13_ = item;
	g_menu_append_item (_tmp12_, _tmp13_);
	_tmp14_ = _ ("Save _As…");
	_tmp15_ = g_menu_item_new (_tmp14_, "win.file-saveas");
	_g_object_unref0 (item);
	item = _tmp15_;
	_tmp16_ = item;
	g_menu_item_set_attribute (_tmp16_, "accel", "s", "<Primary>S", NULL);
	_tmp17_ = section;
	_tmp18_ = item;
	g_menu_append_item (_tmp17_, _tmp18_);
	_tmp19_ = _ ("Move to _Trash");
	_tmp20_ = g_menu_item_new (_tmp19_, "win.file-trash");
	_g_object_unref0 (item);
	item = _tmp20_;
	_tmp21_ = item;
	g_menu_item_set_attribute (_tmp21_, "accel", "s", "Delete", NULL);
	_tmp22_ = section;
	_tmp23_ = item;
	g_menu_append_item (_tmp22_, _tmp23_);
	_tmp24_ = _ ("Delete");
	_tmp25_ = g_menu_item_new (_tmp24_, "win.file-delete");
	_g_object_unref0 (item);
	item = _tmp25_;
	_tmp26_ = item;
	g_menu_item_set_attribute (_tmp26_, "accel", "s", "<Shift>Delete", NULL);
	_tmp27_ = section;
	_tmp28_ = item;
	g_menu_append_item (_tmp27_, _tmp28_);
	_tmp29_ = menu;
	_tmp30_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp30_;
	g_action_map_add_action_entries ((GActionMap*) self, CHEESE_MAIN_WINDOW_actions, G_N_ELEMENTS (CHEESE_MAIN_WINDOW_actions), self);
	{
		GtkBuilder* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		GtkBuilder* _tmp34_ = NULL;
		ClutterScript* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp31_ = self->priv->gtk_builder;
		_tmp32_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL);
		_tmp33_ = _tmp32_;
		gtk_builder_add_from_file (_tmp31_, _tmp33_, &_inner_error_);
		_g_free0 (_tmp33_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_tmp34_ = self->priv->gtk_builder;
		gtk_builder_connect_signals (_tmp34_, self);
		_tmp35_ = self->priv->clutter_builder;
		_tmp36_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL);
		_tmp37_ = _tmp36_;
		clutter_script_load_from_file (_tmp35_, _tmp37_, &_inner_error_);
		_g_free0 (_tmp37_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp38_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = err->message;
		g_error ("cheese-window.vala:1193: Error: %s", _tmp38_);
		_g_error_free0 (err);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (item);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp39_ = self->priv->gtk_builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "mainbox_normal");
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp40_) : NULL);
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp41_;
	_tmp42_ = self->priv->gtk_builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "thumbnails");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp43_) : NULL);
	_g_object_unref0 (self->priv->thumbnails);
	self->priv->thumbnails = _tmp44_;
	_tmp45_ = self->priv->gtk_builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "viewport");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, gtk_clutter_embed_get_type ()) ? ((GtkClutterEmbed*) _tmp46_) : NULL);
	_g_object_unref0 (self->priv->viewport_widget);
	self->priv->viewport_widget = _tmp47_;
	_tmp48_ = self->priv->viewport_widget;
	_tmp49_ = gtk_clutter_embed_get_stage (_tmp48_);
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp49_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp50_;
	_tmp51_ = self->priv->gtk_builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "thumbnails_right");
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp52_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_right);
	self->priv->thumbnails_right = _tmp53_;
	_tmp54_ = self->priv->gtk_builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "thumbnails_bottom");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp55_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	self->priv->thumbnails_bottom = _tmp56_;
	_tmp57_ = self->priv->gtk_builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "leave_fullscreen_button_bin");
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp58_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	self->priv->leave_fullscreen_button_container = _tmp59_;
	_tmp60_ = self->priv->gtk_builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "photo_toggle_button");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp61_) : NULL);
	_g_object_unref0 (self->priv->photo_toggle_button);
	self->priv->photo_toggle_button = _tmp62_;
	_tmp63_ = self->priv->gtk_builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "video_toggle_button");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp64_) : NULL);
	_g_object_unref0 (self->priv->video_toggle_button);
	self->priv->video_toggle_button = _tmp65_;
	_tmp66_ = self->priv->gtk_builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "burst_toggle_button");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp67_) : NULL);
	_g_object_unref0 (self->priv->burst_toggle_button);
	self->priv->burst_toggle_button = _tmp68_;
	_tmp69_ = self->priv->gtk_builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "take_action_button");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp70_) : NULL);
	_g_object_unref0 (self->priv->take_action_button);
	self->priv->take_action_button = _tmp71_;
	_tmp72_ = self->priv->gtk_builder;
	_tmp73_ = gtk_builder_get_object (_tmp72_, "take_action_button_internal_label");
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp73_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_label);
	self->priv->take_action_button_label = _tmp74_;
	_tmp75_ = self->priv->gtk_builder;
	_tmp76_ = gtk_builder_get_object (_tmp75_, "take_action_button_internal_image");
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp76_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_image);
	self->priv->take_action_button_image = _tmp77_;
	_tmp78_ = self->priv->gtk_builder;
	_tmp79_ = gtk_builder_get_object (_tmp78_, "effects_toggle_button");
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp79_) : NULL);
	_g_object_unref0 (self->priv->effects_toggle_button);
	self->priv->effects_toggle_button = _tmp80_;
	_tmp81_ = self->priv->gtk_builder;
	_tmp82_ = gtk_builder_get_object (_tmp81_, "leave_fullscreen_button");
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp82_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	self->priv->leave_fullscreen_button = _tmp83_;
	_tmp84_ = self->priv->gtk_builder;
	_tmp85_ = gtk_builder_get_object (_tmp84_, "buttons_area");
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp85_) : NULL);
	_g_object_unref0 (self->priv->buttons_area);
	self->priv->buttons_area = _tmp86_;
	_tmp87_ = self->priv->gtk_builder;
	_tmp88_ = gtk_builder_get_object (_tmp87_, "countdown");
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp88_) : NULL);
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->countdown_action = _tmp89_;
	_tmp90_ = self->priv->photo_toggle_button;
	_tmp91_ = _g_object_ref0 ((GtkButton*) _tmp90_);
	_tmp92_ = self->priv->video_toggle_button;
	_tmp93_ = _g_object_ref0 ((GtkButton*) _tmp92_);
	_tmp94_ = self->priv->burst_toggle_button;
	_tmp95_ = _g_object_ref0 ((GtkButton*) _tmp94_);
	_tmp96_ = self->priv->take_action_button;
	_tmp97_ = _g_object_ref0 (_tmp96_);
	_tmp98_ = self->priv->effects_toggle_button;
	_tmp99_ = _g_object_ref0 ((GtkButton*) _tmp98_);
	_tmp100_ = self->priv->leave_fullscreen_button;
	_tmp101_ = _g_object_ref0 (_tmp100_);
	_tmp102_ = g_new0 (GtkButton*, 6 + 1);
	_tmp102_[0] = _tmp91_;
	_tmp102_[1] = _tmp93_;
	_tmp102_[2] = _tmp95_;
	_tmp102_[3] = _tmp97_;
	_tmp102_[4] = _tmp99_;
	_tmp102_[5] = _tmp101_;
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->buttons = _tmp102_;
	self->priv->buttons_length1 = 6;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp103_ = self->priv->clutter_builder;
	_tmp104_ = clutter_script_get_object (_tmp103_, "video_preview");
	_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, clutter_texture_get_type ()) ? ((ClutterTexture*) _tmp104_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp105_;
	_tmp106_ = self->priv->clutter_builder;
	_tmp107_ = clutter_script_get_object (_tmp106_, "viewport_layout");
	_tmp108_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp107_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp108_;
	_tmp109_ = self->priv->clutter_builder;
	_tmp110_ = clutter_script_get_object (_tmp109_, "viewport_layout_manager");
	_tmp111_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, clutter_bin_layout_get_type ()) ? ((ClutterBinLayout*) _tmp110_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp111_;
	_tmp112_ = self->priv->clutter_builder;
	_tmp113_ = clutter_script_get_object (_tmp112_, "countdown_layer");
	_tmp114_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, clutter_text_get_type ()) ? ((ClutterText*) _tmp113_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp114_;
	_tmp115_ = self->priv->clutter_builder;
	_tmp116_ = clutter_script_get_object (_tmp115_, "background");
	_tmp117_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp116_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp117_;
	_tmp118_ = self->priv->clutter_builder;
	_tmp119_ = clutter_script_get_object (_tmp118_, "error_layer");
	_tmp120_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp119_, clutter_text_get_type ()) ? ((ClutterText*) _tmp119_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp120_;
	_tmp121_ = self->priv->clutter_builder;
	_tmp122_ = clutter_script_get_object (_tmp121_, "timeout_layer");
	_tmp123_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp122_, clutter_text_get_type ()) ? ((ClutterText*) _tmp122_) : NULL);
	_g_object_unref0 (self->priv->timeout_layer);
	self->priv->timeout_layer = _tmp123_;
	_tmp124_ = self->priv->video_preview;
	clutter_texture_set_keep_aspect_ratio (_tmp124_, TRUE);
	_tmp125_ = self->priv->video_preview;
	clutter_actor_set_request_mode ((ClutterActor*) _tmp125_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp126_ = self->priv->viewport;
	_tmp127_ = self->priv->background_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp126_, _tmp127_);
	_tmp128_ = self->priv->viewport_layout;
	_tmp129_ = self->priv->viewport_layout_manager;
	clutter_actor_set_layout_manager (_tmp128_, (ClutterLayoutManager*) _tmp129_);
	_tmp130_ = self->priv->viewport;
	_tmp131_ = self->priv->viewport_layout;
	clutter_actor_add_child ((ClutterActor*) _tmp130_, _tmp131_);
	_tmp132_ = self->priv->viewport;
	_tmp133_ = self->priv->timeout_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp132_, (ClutterActor*) _tmp133_);
	_tmp134_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp134_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp135_ = cheese_thumb_view_new ();
	g_object_ref_sink (_tmp135_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp135_;
	_tmp136_ = self->priv->thumb_view;
	_tmp137_ = eog_thumb_nav_new ((GtkWidget*) _tmp136_, FALSE);
	g_object_ref_sink (_tmp137_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp137_;
	_tmp138_ = self->priv->thumbnail_popup;
	_tmp139_ = self->priv->thumb_view;
	gtk_menu_attach_to_widget (_tmp138_, (GtkWidget*) _tmp139_, NULL);
	{
		GtkCssProvider* _tmp140_ = NULL;
		gchar* _tmp141_ = NULL;
		gchar* _tmp142_ = NULL;
		_tmp140_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp140_;
		_tmp141_ = g_build_filename (PACKAGE_DATADIR, "cheese.css", NULL);
		_tmp142_ = _tmp141_;
		gtk_css_provider_load_from_path (css, _tmp142_, &_inner_error_);
		_g_free0 (_tmp142_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp143_ = NULL;
		GError* _tmp144_ = NULL;
		const gchar* _tmp145_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp143_ = stdout;
		_tmp144_ = e;
		_tmp145_ = _tmp144_->message;
		fprintf (_tmp143_, "Error: %s\n", _tmp145_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css);
		_g_object_unref0 (item);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp146_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp147_ = _tmp146_;
	gtk_style_context_add_provider_for_screen (_tmp147_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp148_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp148_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp149_ = self->priv->main_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp149_);
	_tmp150_ = self->priv->main_vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp150_);
	_tmp151_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp151_);
	cheese_main_window_set_wide_mode (self, FALSE);
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (css);
	_g_object_unref0 (item);
	_g_object_unref0 (section);
	_g_object_unref0 (menu);
}


ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self) {
	ClutterTexture* result = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->video_preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Setup the thumbview thumbnail monitors.
   */
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self) {
	CheeseThumbView* _tmp0_ = NULL;
	CheeseFileUtil* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CheeseThumbView* _tmp3_ = NULL;
	CheeseFileUtil* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * @param mode the media mode to set
     */
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_ = 0;
	CheeseMediaMode _tmp1_ = 0;
	ClutterText* _tmp2_ = NULL;
	CheeseMediaMode _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
	_tmp1_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp1_);
	_tmp2_ = self->priv->timeout_layer;
	clutter_actor_hide ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->current_mode;
	switch (_tmp3_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkLabel* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GtkButton* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp4_ = self->priv->take_action_button_label;
			_tmp5_ = _ ("_Take a Photo");
			_tmp6_ = g_strconcat ("<b>", _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, "</b>", NULL);
			_tmp9_ = _tmp8_;
			gtk_label_set_label (_tmp4_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			_tmp10_ = self->priv->take_action_button;
			_tmp11_ = _ ("Take a photo using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp11_);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkLabel* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			GtkButton* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			ClutterText* _tmp20_ = NULL;
			ClutterText* _tmp21_ = NULL;
			_tmp12_ = self->priv->take_action_button_label;
			_tmp13_ = _ ("_Record a Video");
			_tmp14_ = g_strconcat ("<b>", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp15_, "</b>", NULL);
			_tmp17_ = _tmp16_;
			gtk_label_set_label (_tmp12_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = self->priv->take_action_button;
			_tmp19_ = _ ("Record a video using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _tmp19_);
			_tmp20_ = self->priv->timeout_layer;
			clutter_text_set_text (_tmp20_, "00:00:00");
			_tmp21_ = self->priv->timeout_layer;
			clutter_actor_show ((ClutterActor*) _tmp21_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkLabel* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			GtkButton* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			_tmp22_ = self->priv->take_action_button_label;
			_tmp23_ = _ ("Take _Multiple Photos");
			_tmp24_ = g_strconcat ("<b>", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "</b>", NULL);
			_tmp27_ = _tmp26_;
			gtk_label_set_label (_tmp22_, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp28_ = self->priv->take_action_button;
			_tmp29_ = _ ("Take multiple photos using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _tmp29_);
			break;
		}
		default:
		break;
	}
}


/**
     * Set the camera.
     *
     * @param camera the camera to set
     */
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera) {
	CheeseCamera* _tmp0_ = NULL;
	CheeseCamera* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = camera;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp1_;
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = (guint) 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->timeout_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



