/* rygel-http-time-seek.c generated by valac 0.20.1.64-fa28c, the Vala compiler
 * generated from rygel-http-time-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK_TYPE (rygel_http_seek_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_TYPE_BYTE,
	RYGEL_HTTP_SEEK_TYPE_TIME
} RygelHTTPSeekType;


static gpointer rygel_http_time_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value);
static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
GType rygel_http_seek_type_get_type (void) G_GNUC_CONST;
void rygel_http_seek_set_seek_type (RygelHTTPSeek* self, RygelHTTPSeekType value);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPTimeSeek * self = NULL;
	gchar* range = NULL;
	gchar** range_tokens = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start = 0LL;
	gint64 duration = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 stop = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 parsed_value = 0LL;
	gboolean parsing_start = FALSE;
	RygelHTTPGet* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessageHeaders* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	RygelHTTPGet* _tmp55_ = NULL;
	SoupMessage* _tmp56_ = NULL;
	gint64 _tmp57_ = 0LL;
	gint64 _tmp58_ = 0LL;
	gint64 _tmp59_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	start = (gint64) 0;
	_tmp0_ = request;
	_tmp1_ = _tmp0_->object;
	_tmp2_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp1_) : NULL)->duration;
	duration = _tmp2_ * G_TIME_SPAN_SECOND;
	_tmp3_ = duration;
	stop = _tmp3_ - G_TIME_SPAN_MILLISECOND;
	parsed_value = (gint64) 0;
	parsing_start = TRUE;
	_tmp4_ = request;
	_tmp5_ = _tmp4_->msg;
	_tmp6_ = _tmp5_->request_headers;
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "TimeSeekRange.dlna.org");
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (range);
	range = _tmp8_;
	_tmp9_ = range;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gint64 _tmp50_ = 0LL;
		gint64 _tmp51_ = 0LL;
		_tmp10_ = range;
		_tmp11_ = g_str_has_prefix (_tmp10_, "npt=");
		if (!_tmp11_) {
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			_tmp12_ = range;
			_tmp13_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, "Invalid Range '%s'", _tmp12_);
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp14_ = range;
		_tmp15_ = string_substring (_tmp14_, (glong) 4, (glong) (-1));
		_tmp16_ = _tmp15_;
		_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "-", 2);
		range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
		range_tokens = _tmp18_;
		range_tokens_length1 = _vala_array_length (_tmp17_);
		_range_tokens_size_ = range_tokens_length1;
		_g_free0 (_tmp16_);
		_tmp21_ = range_tokens;
		_tmp21__length1 = range_tokens_length1;
		_tmp22_ = _tmp21_[0];
		if (_tmp22_ == NULL) {
			_tmp20_ = TRUE;
		} else {
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = range_tokens;
			_tmp23__length1 = range_tokens_length1;
			_tmp24_ = _tmp23_[0];
			_tmp20_ = g_strcmp0 (_tmp24_, "") == 0;
		}
		_tmp25_ = _tmp20_;
		if (_tmp25_) {
			_tmp19_ = TRUE;
		} else {
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			_tmp26_ = range_tokens;
			_tmp26__length1 = range_tokens_length1;
			_tmp27_ = _tmp26_[1];
			_tmp19_ = _tmp27_ == NULL;
		}
		_tmp28_ = _tmp19_;
		if (_tmp28_) {
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			GError* _tmp31_ = NULL;
			_tmp29_ = _ ("Invalid Range '%s'");
			_tmp30_ = range;
			_tmp31_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp29_, _tmp30_);
			_inner_error_ = _tmp31_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp32_ = range_tokens;
		_tmp32__length1 = range_tokens_length1;
		{
			gchar** range_token_collection = NULL;
			gint range_token_collection_length1 = 0;
			gint _range_token_collection_size_ = 0;
			gint range_token_it = 0;
			range_token_collection = _tmp32_;
			range_token_collection_length1 = _tmp32__length1;
			for (range_token_it = 0; range_token_it < _tmp32__length1; range_token_it = range_token_it + 1) {
				gchar* _tmp33_ = NULL;
				gchar* range_token = NULL;
				_tmp33_ = g_strdup (range_token_collection[range_token_it]);
				range_token = _tmp33_;
				{
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gboolean _tmp47_ = FALSE;
					_tmp34_ = range_token;
					if (g_strcmp0 (_tmp34_, "") == 0) {
						_g_free0 (range_token);
						continue;
					}
					_tmp35_ = range_token;
					_tmp36_ = string_index_of (_tmp35_, ":", 0);
					if (_tmp36_ == (-1)) {
						const gchar* _tmp37_ = NULL;
						gboolean _tmp38_ = FALSE;
						_tmp37_ = range_token;
						_tmp38_ = rygel_http_time_seek_parse_seconds (_tmp37_, &parsed_value);
						if (!_tmp38_) {
							const gchar* _tmp39_ = NULL;
							const gchar* _tmp40_ = NULL;
							GError* _tmp41_ = NULL;
							_tmp39_ = _ ("Invalid Range '%s'");
							_tmp40_ = range;
							_tmp41_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp39_, _tmp40_);
							_inner_error_ = _tmp41_;
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					} else {
						const gchar* _tmp42_ = NULL;
						gboolean _tmp43_ = FALSE;
						_tmp42_ = range_token;
						_tmp43_ = rygel_http_time_seek_parse_time (_tmp42_, &parsed_value);
						if (!_tmp43_) {
							const gchar* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
							GError* _tmp46_ = NULL;
							_tmp44_ = _ ("Invalid Range '%s'");
							_tmp45_ = range;
							_tmp46_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp44_, _tmp45_);
							_inner_error_ = _tmp46_;
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
					_tmp47_ = parsing_start;
					if (_tmp47_) {
						gint64 _tmp48_ = 0LL;
						parsing_start = FALSE;
						_tmp48_ = parsed_value;
						start = _tmp48_;
					} else {
						gint64 _tmp49_ = 0LL;
						_tmp49_ = parsed_value;
						stop = _tmp49_;
					}
					_g_free0 (range_token);
				}
			}
		}
		_tmp50_ = start;
		_tmp51_ = stop;
		if (_tmp50_ > _tmp51_) {
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			GError* _tmp54_ = NULL;
			_tmp52_ = _ ("Invalid Range '%s'");
			_tmp53_ = range;
			_tmp54_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp52_, _tmp53_);
			_inner_error_ = _tmp54_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp55_ = request;
	_tmp56_ = _tmp55_->msg;
	_tmp57_ = start;
	_tmp58_ = stop;
	_tmp59_ = duration;
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, _tmp56_, _tmp57_, _tmp58_ - 1, (gint64) G_TIME_SPAN_MILLISECOND, _tmp59_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_TIME);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (range);
	return self;
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error) {
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, request, error);
}


gboolean rygel_http_time_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = request;
		_tmp1_ = _tmp0_->msg;
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
		hack = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp3_ = rygel_client_hacks_force_seek (hack);
		force_seek = _tmp3_;
		_g_object_unref0 (hack);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = force_seek;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		RygelHTTPGet* _tmp8_ = NULL;
		RygelMediaObject* _tmp9_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp8_ = request;
		_tmp9_ = _tmp8_->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_AUDIO_ITEM)) {
			RygelHTTPGet* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			_tmp10_ = request;
			_tmp11_ = _tmp10_->object;
			_tmp12_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp11_) : NULL)->duration;
			_tmp7_ = _tmp12_ > ((gint64) 0);
		} else {
			_tmp7_ = FALSE;
		}
		_tmp13_ = _tmp7_;
		if (_tmp13_) {
			gboolean _tmp14_ = FALSE;
			RygelHTTPGet* _tmp15_ = NULL;
			RygelHTTPTranscodeHandler* _tmp16_ = NULL;
			gboolean _tmp28_ = FALSE;
			_tmp15_ = request;
			_tmp16_ = _tmp15_->handler;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_HTTP_TRANSCODE_HANDLER)) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				RygelHTTPGet* _tmp19_ = NULL;
				RygelThumbnail* _tmp20_ = NULL;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp27_ = FALSE;
				_tmp19_ = request;
				_tmp20_ = _tmp19_->thumbnail;
				if (_tmp20_ == NULL) {
					RygelHTTPGet* _tmp21_ = NULL;
					RygelSubtitle* _tmp22_ = NULL;
					_tmp21_ = request;
					_tmp22_ = _tmp21_->subtitle;
					_tmp18_ = _tmp22_ == NULL;
				} else {
					_tmp18_ = FALSE;
				}
				_tmp23_ = _tmp18_;
				if (_tmp23_) {
					RygelHTTPGet* _tmp24_ = NULL;
					RygelMediaObject* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
					_tmp24_ = request;
					_tmp25_ = _tmp24_->object;
					_tmp26_ = rygel_media_item_is_live_stream (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp25_) : NULL);
					_tmp17_ = _tmp26_;
				} else {
					_tmp17_ = FALSE;
				}
				_tmp27_ = _tmp17_;
				_tmp14_ = _tmp27_;
			}
			_tmp28_ = _tmp14_;
			_tmp6_ = _tmp28_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp29_ = _tmp6_;
		_tmp4_ = _tmp29_;
	}
	_tmp30_ = _tmp4_;
	result = _tmp30_;
	return result;
}


gboolean rygel_http_time_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = _tmp0_->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "TimeSeekRange.dlna.org");
	result = _tmp3_ != NULL;
	return result;
}


static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPTimeSeek * self;
	gdouble start = 0.0;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gdouble stop = 0.0;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gdouble total = 0.0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* start_str = NULL;
	gchar* _tmp6_ = NULL;
	gint start_str_length1 = 0;
	gint _start_str_size_ = 0;
	gchar* stop_str = NULL;
	gchar* _tmp7_ = NULL;
	gint stop_str_length1 = 0;
	gint _stop_str_size_ = 0;
	gchar* total_str = NULL;
	gchar* _tmp8_ = NULL;
	gint total_str_length1 = 0;
	gint _total_str_size_ = 0;
	gchar* range = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	SoupMessage* _tmp22_ = NULL;
	SoupMessage* _tmp23_ = NULL;
	SoupMessageHeaders* _tmp24_ = NULL;
	self = (RygelHTTPTimeSeek*) base;
	_tmp0_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
	_tmp1_ = _tmp0_;
	start = ((gdouble) _tmp1_) / G_TIME_SPAN_SECOND;
	_tmp2_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
	_tmp3_ = _tmp2_;
	stop = ((gdouble) _tmp3_) / G_TIME_SPAN_SECOND;
	_tmp4_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
	_tmp5_ = _tmp4_;
	total = ((gdouble) _tmp5_) / G_TIME_SPAN_SECOND;
	_tmp6_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	start_str = _tmp6_;
	start_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_start_str_size_ = start_str_length1;
	_tmp7_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	stop_str = _tmp7_;
	stop_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_stop_str_size_ = stop_str_length1;
	_tmp8_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	total_str = _tmp8_;
	total_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_total_str_size_ = total_str_length1;
	_tmp9_ = g_ascii_formatd (start_str, start_str_length1, "%.3f", start);
	_tmp10_ = g_strconcat ("npt=", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_ascii_formatd (stop_str, stop_str_length1, "%.3f", stop);
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_ascii_formatd (total_str, total_str_length1, "%.3f", total);
	_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	range = _tmp21_;
	_tmp22_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_->response_headers;
	soup_message_headers_append (_tmp24_, "TimeSeekRange.dlna.org", range);
	_g_free0 (range);
	total_str = (g_free (total_str), NULL);
	stop_str = (g_free (stop_str), NULL);
	start_str = (g_free (start_str), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (range_token != NULL, FALSE);
	_tmp0_ = range_token;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	_tmp2_ = g_ascii_isdigit (_tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = range_token;
		_tmp4_ = double_parse (_tmp3_);
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint64 _tmp23_ = 0LL;
	g_return_val_if_fail (range_token != NULL, FALSE);
	seconds_sum = (gint64) 0;
	time_factor = 0;
	seconds_sum = (gint64) 0;
	time_factor = 3600;
	_tmp0_ = range_token;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 3);
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	time_tokens = _tmp2_;
	time_tokens_length1 = _vala_array_length (_tmp1_);
	_time_tokens_size_ = time_tokens_length1;
	_tmp5_ = time_tokens;
	_tmp5__length1 = time_tokens_length1;
	_tmp6_ = _tmp5_[0];
	if (_tmp6_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = time_tokens;
		_tmp7__length1 = time_tokens_length1;
		_tmp8_ = _tmp7_[1];
		_tmp4_ = _tmp8_ == NULL;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
		_tmp10_ = time_tokens;
		_tmp10__length1 = time_tokens_length1;
		_tmp11_ = _tmp10_[2];
		_tmp3_ = _tmp11_ == NULL;
	}
	_tmp12_ = _tmp3_;
	if (_tmp12_) {
		result = FALSE;
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp13_ = time_tokens;
	_tmp13__length1 = time_tokens_length1;
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
		time_collection = _tmp13_;
		time_collection_length1 = _tmp13__length1;
		for (time_it = 0; time_it < _tmp13__length1; time_it = time_it + 1) {
			gchar* _tmp14_ = NULL;
			gchar* time = NULL;
			_tmp14_ = g_strdup (time_collection[time_it]);
			time = _tmp14_;
			{
				const gchar* _tmp15_ = NULL;
				gchar _tmp16_ = '\0';
				gboolean _tmp17_ = FALSE;
				gint _tmp22_ = 0;
				_tmp15_ = time;
				_tmp16_ = string_get (_tmp15_, (glong) 0);
				_tmp17_ = g_ascii_isdigit (_tmp16_);
				if (_tmp17_) {
					gint64 _tmp18_ = 0LL;
					const gchar* _tmp19_ = NULL;
					gdouble _tmp20_ = 0.0;
					gint _tmp21_ = 0;
					_tmp18_ = seconds_sum;
					_tmp19_ = time;
					_tmp20_ = double_parse (_tmp19_);
					_tmp21_ = time_factor;
					seconds_sum = _tmp18_ + ((gint64) ((_tmp20_ * G_TIME_SPAN_SECOND) * _tmp21_));
				} else {
					result = FALSE;
					_g_free0 (time);
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp22_ = time_factor;
				time_factor = _tmp22_ / 60;
				_g_free0 (time);
			}
		}
	}
	_tmp23_ = seconds_sum;
	*value = _tmp23_;
	result = TRUE;
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_time_seek_real_add_response_headers;
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



