/* rygel-media-export-media-cache.c generated by valac 0.20.1.64-fa28c, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <uuid/uuid.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID
} RygelMediaExportDetailColumn;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_ensure_exists (GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, gboolean override_guarded, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count);
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new_root (void);
RygelNullContainer* rygel_null_container_construct_root (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error);
gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded);
gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error);
static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "15"
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
	return dup;
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
	g_free (self);
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	gchar* db_name = NULL;
	gchar* _tmp0_ = NULL;
	RygelMediaExportSQLFactory* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaExportObjectFactory* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("media-export");
	db_name = _tmp0_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = rygel_meta_config_get_default ();
		config = _tmp1_;
		_tmp3_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "use-temp-db", &_inner_error_);
		_tmp2_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch5_g_error;
		}
		if (_tmp2_) {
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup (":memory:");
			_g_free0 (db_name);
			db_name = _tmp4_;
		}
		_g_object_unref0 (config);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp5_ = rygel_media_export_sql_factory_new ();
	_g_object_unref0 (self->priv->sql);
	self->priv->sql = _tmp5_;
	_tmp6_ = db_name;
	rygel_media_export_media_cache_open_db (self, _tmp6_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp7_ = rygel_media_export_object_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp7_;
	_g_free0 (db_name);
	return self;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) (-1));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


void rygel_media_export_media_cache_ensure_exists (GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_instance;
	if (_tmp0_ == NULL) {
		RygelMediaExportMediaCache* _tmp1_ = NULL;
		RygelMediaExportMediaCache* _tmp2_ = NULL;
		_tmp2_ = rygel_media_export_media_cache_new (&_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_g_object_unref0 (rygel_media_export_media_cache_instance);
		rygel_media_export_media_cache_instance = _tmp1_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* _tmp1_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabase* _tmp3_ = NULL;
	RygelMediaExportSQLFactory* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp3_ = self->priv->db;
	_tmp4_ = self->priv->sql;
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
	rygel_media_export_database_exec (_tmp3_, _tmp5_, values, values_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_media_export_media_cache_remove_by_id (self, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Add the container to the cache, in a database transcation,
     * rolling back the transaction if necessary.
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaContainer* _tmp1_ = NULL;
		RygelMediaExportDatabase* _tmp2_ = NULL;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = container;
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp1_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
		_tmp2_ = self->priv->db;
		rygel_media_export_database_commit (_tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = self->priv->db;
		rygel_media_export_database_rollback (_tmp3_);
		_tmp4_ = _error_;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_inner_error_ = _tmp5_;
		_g_error_free0 (_error_);
		goto __finally6;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Add the item to the cache.
     */
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, gboolean override_guarded, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaItem* _tmp1_ = NULL;
		RygelMediaItem* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = item;
		rygel_media_export_media_cache_save_metadata (self, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
		_tmp2_ = item;
		_tmp3_ = override_guarded;
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
		_tmp4_ = self->priv->db;
		rygel_media_export_database_commit (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally7;
	__catch7_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		RygelMediaItem* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		RygelMediaExportDatabase* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _ ("Failed to add item with ID %s: %s");
		_tmp6_ = item;
		_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		g_warning (_tmp5_, _tmp8_, _tmp10_);
		_tmp11_ = self->priv->db;
		rygel_media_export_database_rollback (_tmp11_);
		_tmp12_ = _error_;
		_tmp13_ = _g_error_copy0 (_tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (_error_);
		goto __finally7;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Create a new container or item instance based on the ID.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     */
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* parent = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	_tmp0_ = object_id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	parent = NULL;
	_tmp3_ = values;
	_tmp3__length1 = values_length1;
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp3_, _tmp3__length1, &_inner_error_);
	cursor = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return NULL;
		} else {
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
		_tmp5_ = cursor;
		_tmp6_ = rygel_media_export_database_cursor_iterator (_tmp5_);
		_statement_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp10_ = NULL;
			sqlite3_stmt* _tmp11_ = NULL;
			RygelMediaContainer* parent_container = NULL;
			RygelMediaObject* _tmp12_ = NULL;
			RygelMediaContainer* _tmp13_ = NULL;
			RygelMediaObject* object = NULL;
			RygelMediaContainer* _tmp14_ = NULL;
			sqlite3_stmt* _tmp15_ = NULL;
			RygelMediaObject* _tmp16_ = NULL;
			RygelMediaObject* _tmp17_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			RygelMediaObject* _tmp19_ = NULL;
			RygelMediaObject* _tmp20_ = NULL;
			_tmp8_ = _statement_it;
			_tmp9_ = rygel_media_export_database_cursor_iterator_next (_tmp8_, &_inner_error_);
			_tmp7_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp7_) {
				break;
			}
			_tmp10_ = _statement_it;
			_tmp11_ = rygel_media_export_database_cursor_iterator_get (_tmp10_, &_inner_error_);
			statement = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = parent;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp12_) : NULL);
			parent_container = _tmp13_;
			_tmp14_ = parent_container;
			_tmp15_ = statement;
			_tmp16_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp14_, _tmp15_);
			object = _tmp16_;
			_tmp17_ = object;
			_tmp18_ = parent_container;
			rygel_media_object_set_parent_ref (_tmp17_, _tmp18_);
			_tmp19_ = object;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (parent);
			parent = _tmp20_;
			_g_object_unref0 (object);
			_g_object_unref0 (parent_container);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = parent;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	RygelMediaObject* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelMediaObject* _tmp8_ = NULL;
	RygelMediaContainer* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = container_id;
	_tmp1_ = rygel_media_export_media_cache_get_object (self, _tmp0_, &_inner_error_);
	object = _tmp1_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = object;
	if (_tmp3_ != NULL) {
		RygelMediaObject* _tmp4_ = NULL;
		_tmp4_ = object;
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_CONTAINER);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = container_id;
		_tmp7_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", _tmp6_);
		_inner_error_ = _tmp7_;
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			return NULL;
		} else {
			_g_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = object;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp8_) : NULL);
	result = _tmp9_;
	_g_object_unref0 (object);
	return result;
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (container_id != NULL, 0);
	_tmp0_ = container_id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp4_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
	_tmp3_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp3_;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self) {
	guint32 result = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		_tmp1_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID, NULL, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		result = (guint32) _tmp0_;
		return result;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	result = (guint32) 0;
	return result;
}


void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count) {
	guint32 _vala_object_update_id = 0U;
	guint32 _vala_container_update_id = 0U;
	guint32 _vala_total_deleted_child_count = 0U;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_vala_object_update_id = (guint32) 0;
	_vala_container_update_id = (guint32) 0;
	_vala_total_deleted_child_count = (guint32) 0;
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		GValue* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		sqlite3_stmt* statement = NULL;
		RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
		sqlite3_stmt* _tmp7_ = NULL;
		sqlite3_stmt* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		sqlite3_stmt* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		sqlite3_stmt* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp3_ = self->priv->db;
		_tmp4_ = values;
		_tmp4__length1 = values_length1;
		_tmp5_ = rygel_media_export_database_exec_cursor (_tmp3_, "SELECT object_update_id, " "container_update_id, " "deleted_child_count " "FROM Object WHERE upnp_id = ?", _tmp4_, _tmp4__length1, &_inner_error_);
		cursor = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp6_ = cursor;
		_tmp7_ = rygel_media_export_database_cursor_next (_tmp6_, &_inner_error_);
		statement = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cursor);
			goto __catch9_g_error;
		}
		_tmp8_ = statement;
		_tmp9_ = sqlite3_column_int64 (_tmp8_, 0);
		_vala_object_update_id = (guint32) _tmp9_;
		_tmp10_ = statement;
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 1);
		_vala_container_update_id = (guint32) _tmp11_;
		_tmp12_ = statement;
		_tmp13_ = sqlite3_column_int64 (_tmp12_, 2);
		_vala_total_deleted_child_count = (guint32) _tmp13_;
		_g_object_unref0 (cursor);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		if (object_update_id) {
			*object_update_id = _vala_object_update_id;
		}
		if (container_update_id) {
			*container_update_id = _vala_container_update_id;
		}
		if (total_deleted_child_count) {
			*total_deleted_child_count = _vala_total_deleted_child_count;
		}
		return;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = _error_;
		_tmp15_ = _tmp14_->message;
		g_warning ("rygel-media-export-media-cache.vala:213: Failed to get update ids: %s", _tmp15_);
		_g_error_free0 (_error_);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	if (object_update_id) {
		*object_update_id = _vala_object_update_id;
	}
	if (container_update_id) {
		*container_update_id = _vala_container_update_id;
	}
	if (total_deleted_child_count) {
		*total_deleted_child_count = _vala_total_deleted_child_count;
	}
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gboolean result = FALSE;
	gchar* uri = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue* values = NULL;
	const gchar* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GeeHashMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp18_ = NULL;
	sqlite3_stmt* statement = NULL;
	RygelMediaExportDatabaseCursor* _tmp19_ = NULL;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gint64 _tmp23_ = 0LL;
	gint64 _tmp24_ = 0LL;
	sqlite3_stmt* _tmp25_ = NULL;
	gint64 _tmp26_ = 0LL;
	sqlite3_stmt* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_set_string (&_tmp3_, _tmp2_);
	_tmp4_ = g_new0 (GValue, 1);
	_tmp4_[0] = _tmp3_;
	values = _tmp4_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp5_ = self->priv->exists_cache;
	_tmp6_ = uri;
	_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
	if (_tmp7_) {
		RygelMediaExportExistsCacheEntry* entry = NULL;
		GeeHashMap* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		GeeHashMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportExistsCacheEntry* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		RygelMediaExportExistsCacheEntry* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
		_tmp8_ = self->priv->exists_cache;
		_tmp9_ = uri;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
		entry = (RygelMediaExportExistsCacheEntry*) _tmp10_;
		_tmp11_ = self->priv->exists_cache;
		_tmp12_ = uri;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
		_tmp13_ = entry;
		_tmp14_ = (*_tmp13_).mtime;
		_vala_timestamp = _tmp14_;
		_tmp15_ = entry;
		_tmp16_ = (*_tmp15_).size;
		_vala_size = _tmp16_;
		result = TRUE;
		_rygel_media_export_exists_cache_entry_free0 (entry);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (uri);
		if (timestamp) {
			*timestamp = _vala_timestamp;
		}
		if (size) {
			*size = _vala_size;
		}
		return result;
	}
	_tmp17_ = values;
	_tmp17__length1 = values_length1;
	_tmp18_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp17_, _tmp17__length1, &_inner_error_);
	cursor = _tmp18_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp19_ = cursor;
	_tmp20_ = rygel_media_export_database_cursor_next (_tmp19_, &_inner_error_);
	statement = _tmp20_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			return FALSE;
		} else {
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp21_ = statement;
	_tmp22_ = sqlite3_column_int64 (_tmp21_, 1);
	_vala_timestamp = _tmp22_;
	_tmp23_ = _vala_timestamp;
	_tmp24_ = G_MAXINT64;
	if (_tmp23_ == _tmp24_) {
		_vala_timestamp = (gint64) 0;
	}
	_tmp25_ = statement;
	_tmp26_ = sqlite3_column_int64 (_tmp25_, 2);
	_vala_size = _tmp26_;
	_tmp27_ = statement;
	_tmp28_ = sqlite3_column_int (_tmp27_, 0);
	result = _tmp28_ == 1;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (uri);
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	if (size) {
		*size = _vala_size;
	}
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue* values = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	glong _tmp5_ = 0L;
	GValue _tmp6_ = {0};
	glong _tmp7_ = 0L;
	GValue _tmp8_ = {0};
	GValue* _tmp9_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gchar* sql = NULL;
	RygelMediaExportSQLFactory* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* sort_order = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GValue* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp21_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_value_init (&_tmp4_, G_TYPE_STRING);
	g_value_set_string (&_tmp4_, _tmp3_);
	_tmp5_ = offset;
	g_value_init (&_tmp6_, G_TYPE_LONG);
	g_value_set_long (&_tmp6_, _tmp5_);
	_tmp7_ = max_count;
	g_value_init (&_tmp8_, G_TYPE_LONG);
	g_value_set_long (&_tmp8_, _tmp7_);
	_tmp9_ = g_new0 (GValue, 3);
	_tmp9_[0] = _tmp4_;
	_tmp9_[1] = _tmp6_;
	_tmp9_[2] = _tmp8_;
	values = _tmp9_;
	values_length1 = 3;
	_values_size_ = values_length1;
	_tmp10_ = self->priv->sql;
	_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
	_tmp12_ = g_strdup (_tmp11_);
	sql = _tmp12_;
	_tmp13_ = sort_criteria;
	_tmp14_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp13_);
	sort_order = _tmp14_;
	_tmp15_ = self->priv->db;
	_tmp16_ = sql;
	_tmp17_ = sort_order;
	_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = values;
	_tmp20__length1 = values_length1;
	_tmp21_ = rygel_media_export_database_exec_cursor (_tmp15_, _tmp19_, _tmp20_, _tmp20__length1, &_inner_error_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp19_);
	cursor = _tmp22_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sort_order);
		_g_free0 (sql);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp23_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp24_ = NULL;
		_tmp23_ = cursor;
		_tmp24_ = rygel_media_export_database_cursor_iterator (_tmp23_);
		_statement_it = _tmp24_;
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp28_ = NULL;
			sqlite3_stmt* _tmp29_ = NULL;
			RygelMediaObjects* _tmp30_ = NULL;
			RygelMediaContainer* _tmp31_ = NULL;
			sqlite3_stmt* _tmp32_ = NULL;
			RygelMediaObject* _tmp33_ = NULL;
			RygelMediaObject* _tmp34_ = NULL;
			RygelMediaObjects* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			RygelMediaObject* _tmp37_ = NULL;
			RygelMediaContainer* _tmp38_ = NULL;
			_tmp26_ = _statement_it;
			_tmp27_ = rygel_media_export_database_cursor_iterator_next (_tmp26_, &_inner_error_);
			_tmp25_ = _tmp27_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp25_) {
				break;
			}
			_tmp28_ = _statement_it;
			_tmp29_ = rygel_media_export_database_cursor_iterator_get (_tmp28_, &_inner_error_);
			statement = _tmp29_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp30_ = children;
			_tmp31_ = container;
			_tmp32_ = statement;
			_tmp33_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp31_, _tmp32_);
			_tmp34_ = _tmp33_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp34_);
			_g_object_unref0 (_tmp34_);
			_tmp35_ = children;
			_tmp36_ = gee_list_last ((GeeList*) _tmp35_);
			_tmp37_ = (RygelMediaObject*) _tmp36_;
			_tmp38_ = container;
			rygel_media_object_set_parent_ref (_tmp37_, _tmp38_);
			_g_object_unref0 (_tmp37_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_free0 (sql);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	guint max_objects = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	glong _tmp11_ = 0L;
	const gchar* _tmp12_ = NULL;
	GValueArray* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	glong _tmp15_ = 0L;
	RygelMediaObjects* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GValueArray* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	guint _tmp22_ = 0U;
	RygelMediaObjects* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
	filter = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp4_ = expression;
	if (_tmp4_ != NULL) {
		RygelSearchExpression* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp5_ = expression;
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		g_debug ("rygel-media-export-media-cache.vala:282: Original search: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:283: Parsed search expression: %s", _tmp8_);
	}
	_tmp9_ = max_count;
	_tmp10_ = rygel_media_export_media_cache_modify_limit (self, _tmp9_);
	max_objects = _tmp10_;
	_tmp12_ = filter;
	_tmp13_ = args;
	_tmp14_ = container_id;
	_tmp15_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
	_tmp11_ = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_vala_total_matches = (guint) _tmp11_;
	_tmp17_ = filter;
	_tmp18_ = args;
	_tmp19_ = container_id;
	_tmp20_ = sort_criteria;
	_tmp21_ = offset;
	_tmp22_ = max_objects;
	_tmp23_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, (glong) _tmp21_, (glong) _tmp22_, &_inner_error_);
	_tmp16_ = _tmp23_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp16_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	if (total_matches) {
		*total_matches = _vala_total_matches;
	}
	return result;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	glong _tmp29_ = 0L;
	const gchar* _tmp30_ = NULL;
	GValueArray* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	glong _tmp33_ = 0L;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
	filter = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return 0L;
	}
	_tmp4_ = expression;
	if (_tmp4_ != NULL) {
		RygelSearchExpression* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp5_ = expression;
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		g_debug ("rygel-media-export-media-cache.vala:307: Original search: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:308: Parsed search expression: %s", _tmp8_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_ = FALSE;
				gint _tmp12_ = 0;
				GValueArray* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				GValue* arg = NULL;
				GValueArray* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				GValue* _tmp17_ = NULL;
				GValue* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				GValue* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_ = 0;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = args;
				_tmp14_ = _tmp13_->n_values;
				if (!(((guint) _tmp12_) < _tmp14_)) {
					break;
				}
				_tmp15_ = args;
				_tmp16_ = i;
				_tmp17_ = g_value_array_get_nth (_tmp15_, (guint) _tmp16_);
				_tmp18_ = __g_value_dup0 (_tmp17_);
				arg = _tmp18_;
				_tmp20_ = arg;
				_tmp21_ = G_VALUE_HOLDS (_tmp20_, G_TYPE_STRING);
				if (_tmp21_) {
					GValue* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					_tmp22_ = arg;
					_tmp23_ = g_value_get_string (_tmp22_);
					_tmp24_ = g_strdup (_tmp23_);
					_g_free0 (_tmp19_);
					_tmp19_ = _tmp24_;
				} else {
					GValue* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp25_ = arg;
					_tmp26_ = g_strdup_value_contents (_tmp25_);
					_g_free0 (_tmp19_);
					_tmp19_ = _tmp26_;
				}
				_tmp27_ = i;
				_tmp28_ = _tmp19_;
				g_debug ("rygel-media-export-media-cache.vala:313: Arg %d: %s", _tmp27_, _tmp28_);
				_g_free0 (_tmp19_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	_tmp30_ = filter;
	_tmp31_ = args;
	_tmp32_ = container_id;
	_tmp33_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp30_, _tmp31_, _tmp32_, &_inner_error_);
	_tmp29_ = _tmp33_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return 0L;
	}
	result = _tmp29_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	const gchar* _tmp0_ = NULL;
	GValueArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	const gchar* _tmp7_ = NULL;
	RygelMediaExportSQLFactory* _tmp8_ = NULL;
	RygelMediaExportSQLString _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	RygelMediaExportDatabase* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GValueArray* _tmp16_ = NULL;
	GValue* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (filter != NULL, 0L);
	g_return_val_if_fail (args != NULL, 0L);
	_tmp0_ = container_id;
	if (_tmp0_ != NULL) {
		GValue v = {0};
		const gchar* _tmp1_ = NULL;
		GValue _tmp2_ = {0};
		GValueArray* _tmp3_ = NULL;
		GValue _tmp4_ = {0};
		_tmp1_ = container_id;
		g_value_init (&_tmp2_, G_TYPE_STRING);
		g_value_set_string (&_tmp2_, _tmp1_);
		v = _tmp2_;
		_tmp3_ = args;
		_tmp4_ = v;
		g_value_array_prepend (_tmp3_, &_tmp4_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp5_ = args;
	_tmp6_ = _tmp5_->n_values;
	g_debug ("rygel-media-export-media-cache.vala:333: Parameters to bind: %u", _tmp6_);
	_tmp7_ = container_id;
	if (_tmp7_ != NULL) {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
	} else {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
	}
	_tmp8_ = self->priv->sql;
	_tmp9_ = string_id;
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp8_, _tmp9_);
	pattern = _tmp10_;
	_tmp12_ = self->priv->db;
	_tmp13_ = filter;
	_tmp14_ = g_strdup_printf (pattern, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = args;
	_tmp17_ = _tmp16_->values;
	_tmp17__length1 = (gint) _tmp16_->n_values;
	_tmp18_ = rygel_media_export_database_query_value (_tmp12_, _tmp15_, _tmp17_, _tmp17__length1, &_inner_error_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp15_);
	_tmp11_ = _tmp19_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0L;
	}
	result = (glong) _tmp11_;
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue v = {0};
	glong _tmp1_ = 0L;
	GValue _tmp2_ = {0};
	GValueArray* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	glong _tmp5_ = 0L;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	RygelMediaContainer* parent = NULL;
	GValueArray* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	const gchar* sql = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* sort_order = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	GValueArray* _tmp44_ = NULL;
	GValue* _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp46_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = offset;
	g_value_init (&_tmp2_, G_TYPE_LONG);
	g_value_set_long (&_tmp2_, _tmp1_);
	v = _tmp2_;
	_tmp3_ = args;
	_tmp4_ = v;
	g_value_array_append (_tmp3_, &_tmp4_);
	_tmp5_ = max_count;
	g_value_init (&_tmp6_, G_TYPE_LONG);
	g_value_set_long (&_tmp6_, _tmp5_);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp6_;
	_tmp7_ = args;
	_tmp8_ = v;
	g_value_array_append (_tmp7_, &_tmp8_);
	parent = NULL;
	_tmp9_ = args;
	_tmp10_ = _tmp9_->n_values;
	g_debug ("rygel-media-export-media-cache.vala:360: Parameters to bind: %u", _tmp10_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				gint _tmp14_ = 0;
				GValueArray* _tmp15_ = NULL;
				guint _tmp16_ = 0U;
				GValue* arg = NULL;
				GValueArray* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GValue* _tmp19_ = NULL;
				GValue* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GValue* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				gint _tmp29_ = 0;
				const gchar* _tmp30_ = NULL;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = args;
				_tmp16_ = _tmp15_->n_values;
				if (!(((guint) _tmp14_) < _tmp16_)) {
					break;
				}
				_tmp17_ = args;
				_tmp18_ = i;
				_tmp19_ = g_value_array_get_nth (_tmp17_, (guint) _tmp18_);
				_tmp20_ = __g_value_dup0 (_tmp19_);
				arg = _tmp20_;
				_tmp22_ = arg;
				_tmp23_ = G_VALUE_HOLDS (_tmp22_, G_TYPE_STRING);
				if (_tmp23_) {
					GValue* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp24_ = arg;
					_tmp25_ = g_value_get_string (_tmp24_);
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (_tmp21_);
					_tmp21_ = _tmp26_;
				} else {
					GValue* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					_tmp27_ = arg;
					_tmp28_ = g_strdup_value_contents (_tmp27_);
					_g_free0 (_tmp21_);
					_tmp21_ = _tmp28_;
				}
				_tmp29_ = i;
				_tmp30_ = _tmp21_;
				g_debug ("rygel-media-export-media-cache.vala:363: Arg %d: %s", _tmp29_, _tmp30_);
				_g_free0 (_tmp21_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	_tmp31_ = container_id;
	if (_tmp31_ != NULL) {
		RygelMediaExportSQLFactory* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		_tmp32_ = self->priv->sql;
		_tmp33_ = rygel_media_export_sql_factory_make (_tmp32_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
		sql = _tmp33_;
	} else {
		RygelMediaExportSQLFactory* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp34_ = self->priv->sql;
		_tmp35_ = rygel_media_export_sql_factory_make (_tmp34_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
		sql = _tmp35_;
	}
	_tmp36_ = sort_criteria;
	_tmp37_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp36_);
	sort_order = _tmp37_;
	_tmp38_ = self->priv->db;
	_tmp39_ = sql;
	_tmp40_ = filter;
	_tmp41_ = sort_order;
	_tmp42_ = g_strdup_printf (_tmp39_, _tmp40_, _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = args;
	_tmp45_ = _tmp44_->values;
	_tmp45__length1 = (gint) _tmp44_->n_values;
	_tmp46_ = rygel_media_export_database_exec_cursor (_tmp38_, _tmp43_, _tmp45_, _tmp45__length1, &_inner_error_);
	_tmp47_ = _tmp46_;
	_g_free0 (_tmp43_);
	cursor = _tmp47_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sort_order);
		_g_object_unref0 (parent);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp48_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp49_ = NULL;
		_tmp48_ = cursor;
		_tmp49_ = rygel_media_export_database_cursor_iterator (_tmp48_);
		_statement_it = _tmp49_;
		while (TRUE) {
			gboolean _tmp50_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp51_ = NULL;
			gboolean _tmp52_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp53_ = NULL;
			sqlite3_stmt* _tmp54_ = NULL;
			const gchar* parent_id = NULL;
			sqlite3_stmt* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			gboolean _tmp57_ = FALSE;
			RygelMediaContainer* _tmp58_ = NULL;
			gboolean _tmp63_ = FALSE;
			RygelMediaContainer* _tmp68_ = NULL;
			_tmp51_ = _statement_it;
			_tmp52_ = rygel_media_export_database_cursor_iterator_next (_tmp51_, &_inner_error_);
			_tmp50_ = _tmp52_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp50_) {
				break;
			}
			_tmp53_ = _statement_it;
			_tmp54_ = rygel_media_export_database_cursor_iterator_get (_tmp53_, &_inner_error_);
			statement = _tmp54_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp55_ = statement;
			_tmp56_ = sqlite3_column_text (_tmp55_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
			parent_id = _tmp56_;
			_tmp58_ = parent;
			if (_tmp58_ == NULL) {
				_tmp57_ = TRUE;
			} else {
				const gchar* _tmp59_ = NULL;
				RygelMediaContainer* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				_tmp59_ = parent_id;
				_tmp60_ = parent;
				_tmp61_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp57_ = g_strcmp0 (_tmp59_, _tmp62_) != 0;
			}
			_tmp63_ = _tmp57_;
			if (_tmp63_) {
				const gchar* _tmp64_ = NULL;
				_tmp64_ = parent_id;
				if (_tmp64_ == NULL) {
					RygelNullContainer* _tmp65_ = NULL;
					_tmp65_ = rygel_null_container_new_root ();
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp65_;
				} else {
					const gchar* _tmp66_ = NULL;
					RygelNullContainer* _tmp67_ = NULL;
					_tmp66_ = parent_id;
					_tmp67_ = rygel_null_container_new (_tmp66_, NULL, "MediaExport");
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp67_;
				}
			}
			_tmp68_ = parent;
			if (_tmp68_ != NULL) {
				RygelMediaObjects* _tmp69_ = NULL;
				RygelMediaContainer* _tmp70_ = NULL;
				sqlite3_stmt* _tmp71_ = NULL;
				RygelMediaObject* _tmp72_ = NULL;
				RygelMediaObject* _tmp73_ = NULL;
				RygelMediaObjects* _tmp74_ = NULL;
				gpointer _tmp75_ = NULL;
				RygelMediaObject* _tmp76_ = NULL;
				RygelMediaContainer* _tmp77_ = NULL;
				_tmp69_ = children;
				_tmp70_ = parent;
				_tmp71_ = statement;
				_tmp72_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp70_, _tmp71_);
				_tmp73_ = _tmp72_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, _tmp73_);
				_g_object_unref0 (_tmp73_);
				_tmp74_ = children;
				_tmp75_ = gee_list_last ((GeeList*) _tmp74_);
				_tmp76_ = (RygelMediaObject*) _tmp75_;
				_tmp77_ = parent;
				rygel_media_object_set_parent_ref (_tmp76_, _tmp77_);
				_g_object_unref0 (_tmp76_);
			} else {
				sqlite3_stmt* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				_tmp78_ = statement;
				_tmp79_ = sqlite3_column_text (_tmp78_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
				_tmp80_ = parent_id;
				g_warning ("Inconsistent database: item %s " "has no parent %s", _tmp79_, _tmp80_);
			}
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_object_unref0 (parent);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		g_debug ("rygel-media-export-media-cache.vala:406: Database statistics:");
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
		cursor = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		{
			RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
			RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp2_ = NULL;
			_tmp1_ = cursor;
			_tmp2_ = rygel_media_export_database_cursor_iterator (_tmp1_);
			_statement_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				sqlite3_stmt* statement = NULL;
				RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
				sqlite3_stmt* _tmp7_ = NULL;
				sqlite3_stmt* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				sqlite3_stmt* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				_tmp4_ = _statement_it;
				_tmp5_ = rygel_media_export_database_cursor_iterator_next (_tmp4_, &_inner_error_);
				_tmp3_ = _tmp5_;
				if (_inner_error_ != NULL) {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch10_g_error;
				}
				if (!_tmp3_) {
					break;
				}
				_tmp6_ = _statement_it;
				_tmp7_ = rygel_media_export_database_cursor_iterator_get (_tmp6_, &_inner_error_);
				statement = _tmp7_;
				if (_inner_error_ != NULL) {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch10_g_error;
				}
				_tmp8_ = statement;
				_tmp9_ = sqlite3_column_text (_tmp8_, 0);
				_tmp10_ = statement;
				_tmp11_ = sqlite3_column_int (_tmp10_, 1);
				g_debug ("rygel-media-export-media-cache.vala:409: %s: %d", _tmp9_, _tmp11_);
			}
			_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* children = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GValue* values = NULL;
	const gchar* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	children = _tmp0_;
	_tmp1_ = container_id;
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue, 1);
	_tmp3_[0] = _tmp2_;
	values = _tmp3_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp4_ = values;
	_tmp4__length1 = values_length1;
	_tmp5_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp4_, _tmp4__length1, &_inner_error_);
	cursor = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
		_tmp6_ = cursor;
		_tmp7_ = rygel_media_export_database_cursor_iterator (_tmp6_);
		_statement_it = _tmp7_;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp11_ = NULL;
			sqlite3_stmt* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			sqlite3_stmt* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp9_ = _statement_it;
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_, &_inner_error_);
			_tmp8_ = _tmp10_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp8_) {
				break;
			}
			_tmp11_ = _statement_it;
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
			statement = _tmp12_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp13_ = children;
			_tmp14_ = statement;
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
	GeeList* result = NULL;
	GValue v = {0};
	glong _tmp0_ = 0L;
	GValue _tmp1_ = {0};
	GValueArray* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	glong _tmp4_ = 0L;
	GValue _tmp5_ = {0};
	GValueArray* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	GeeArrayList* data = NULL;
	GeeArrayList* _tmp8_ = NULL;
	const gchar* sql = NULL;
	RygelMediaExportSQLFactory* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GValueArray* _tmp17_ = NULL;
	GValue* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp19_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = offset;
	g_value_init (&_tmp1_, G_TYPE_LONG);
	g_value_set_long (&_tmp1_, _tmp0_);
	v = _tmp1_;
	_tmp2_ = args;
	_tmp3_ = v;
	g_value_array_append (_tmp2_, &_tmp3_);
	_tmp4_ = max_count;
	g_value_init (&_tmp5_, G_TYPE_LONG);
	g_value_set_long (&_tmp5_, _tmp4_);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp5_;
	_tmp6_ = args;
	_tmp7_ = v;
	g_value_array_append (_tmp6_, &_tmp7_);
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	data = _tmp8_;
	_tmp9_ = self->priv->sql;
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
	sql = _tmp10_;
	_tmp11_ = self->priv->db;
	_tmp12_ = sql;
	_tmp13_ = column;
	_tmp14_ = filter;
	_tmp15_ = g_strdup_printf (_tmp12_, _tmp13_, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = args;
	_tmp18_ = _tmp17_->values;
	_tmp18__length1 = (gint) _tmp17_->n_values;
	_tmp19_ = rygel_media_export_database_exec_cursor (_tmp11_, _tmp16_, _tmp18_, _tmp18__length1, &_inner_error_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp16_);
	cursor = _tmp20_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return NULL;
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp21_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp22_ = NULL;
		_tmp21_ = cursor;
		_tmp22_ = rygel_media_export_database_cursor_iterator (_tmp21_);
		_statement_it = _tmp22_;
		while (TRUE) {
			gboolean _tmp23_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp26_ = NULL;
			sqlite3_stmt* _tmp27_ = NULL;
			GeeArrayList* _tmp28_ = NULL;
			sqlite3_stmt* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			_tmp24_ = _statement_it;
			_tmp25_ = rygel_media_export_database_cursor_iterator_next (_tmp24_, &_inner_error_);
			_tmp23_ = _tmp25_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_object_unref0 (data);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			if (!_tmp23_) {
				break;
			}
			_tmp26_ = _statement_it;
			_tmp27_ = rygel_media_export_database_cursor_iterator_get (_tmp26_, &_inner_error_);
			statement = _tmp27_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_object_unref0 (data);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			_tmp28_ = data;
			_tmp29_ = statement;
			_tmp30_ = sqlite3_column_text (_tmp29_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp30_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = (GeeList*) data;
	_g_object_unref0 (cursor);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


/**
     * TODO
     */
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error) {
	GeeList* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* column = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	guint max_objects = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	GeeList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GValueArray* _tmp12_ = NULL;
	glong _tmp13_ = 0L;
	guint _tmp14_ = 0U;
	GeeList* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "AND", &_inner_error_);
	filter = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp4_ = filter;
	g_debug ("rygel-media-export-media-cache.vala:467: Parsed filter: %s", _tmp4_);
	_tmp5_ = attribute;
	_tmp6_ = rygel_media_export_media_cache_map_operand_to_column (_tmp5_, NULL, FALSE, &_inner_error_);
	column = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp7_ = max_count;
	_tmp8_ = rygel_media_export_media_cache_modify_limit (self, _tmp7_);
	max_objects = _tmp8_;
	_tmp10_ = column;
	_tmp11_ = filter;
	_tmp12_ = args;
	_tmp13_ = offset;
	_tmp14_ = max_objects;
	_tmp15_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp10_, _tmp11_, _tmp12_, _tmp13_, (glong) _tmp14_, &_inner_error_);
	_tmp9_ = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (column);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp9_;
	_g_free0 (column);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	_tmp0_ = g_new0 (guchar, 16);
	id = _tmp0_;
	id_length1 = 16;
	_id_size_ = id_length1;
	_tmp1_ = g_new0 (guchar, 51);
	unparsed = _tmp1_;
	unparsed_length1 = 51;
	_unparsed_size_ = unparsed_length1;
	_tmp2_ = id;
	_tmp2__length1 = id_length1;
	uuid_generate (_tmp2_);
	_tmp3_ = id;
	_tmp3__length1 = id_length1;
	_tmp4_ = unparsed;
	_tmp4__length1 = unparsed_length1;
	uuid_unparse (_tmp3_, _tmp4_);
	_tmp5_ = unparsed;
	_tmp5__length1 = unparsed_length1;
	_tmp5_[50] = (guchar) '\0';
	_tmp6_ = _tmp5_[50];
	_tmp7_ = unparsed;
	_tmp7__length1 = unparsed_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	unparsed = (g_free (unparsed), NULL);
	id = (g_free (id), NULL);
	return result;
}


gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		sqlite3_stmt* statement = NULL;
		RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
		sqlite3_stmt* _tmp2_ = NULL;
		sqlite3_stmt* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN, NULL, 0, &_inner_error_);
		cursor = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch11_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp1_ = cursor;
		_tmp2_ = rygel_media_export_database_cursor_next (_tmp1_, &_inner_error_);
		statement = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cursor);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch11_rygel_media_export_database_error;
			}
			_g_object_unref0 (cursor);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = statement;
		_tmp4_ = sqlite3_column_text (_tmp3_, 0);
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (cursor);
		return result;
	}
	goto __finally11;
	__catch11_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp6_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-media-export-media-cache.vala:486: Failed to get reset token");
		_tmp6_ = uuid_get ();
		result = _tmp6_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally11:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	{
		GValue* args = NULL;
		const gchar* _tmp0_ = NULL;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		_tmp0_ = token;
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_set_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_new0 (GValue, 1);
		_tmp2_[0] = _tmp1_;
		args = _tmp2_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp3_ = self->priv->db;
		rygel_media_export_database_exec (_tmp3_, "UPDATE schema_info SET reset_token = ?", args, args_length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch12_rygel_media_export_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally12;
	__catch12_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("rygel-media-export-media-cache.vala:498: Failed to persist ServiceRese" \
"tToken: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_exec (_tmp0_, "DELETE FROM object WHERE " "upnp_id LIKE 'virtual-parent:%'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch13_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally13;
	__catch13_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("rygel-media-export-media-cache.vala:507: Failed to drop virtual folder" \
"s: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint guarded_val = 0;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp1_ = guarded;
	if (_tmp1_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp2_ = _tmp0_;
	guarded_val = _tmp2_;
	{
		GValue* values = NULL;
		GValue _tmp3_ = {0};
		RygelMediaObject* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GValue _tmp7_ = {0};
		GValue* _tmp8_ = NULL;
		gint values_length1 = 0;
		gint _values_size_ = 0;
		RygelMediaExportDatabase* _tmp9_ = NULL;
		RygelMediaExportSQLFactory* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		g_value_init (&_tmp3_, G_TYPE_INT);
		g_value_set_int (&_tmp3_, guarded_val);
		_tmp4_ = object;
		_tmp5_ = rygel_media_object_get_id (_tmp4_);
		_tmp6_ = _tmp5_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		_tmp8_ = g_new0 (GValue, 2);
		_tmp8_[0] = _tmp3_;
		_tmp8_[1] = _tmp7_;
		values = _tmp8_;
		values_length1 = 2;
		_values_size_ = values_length1;
		_tmp9_ = self->priv->db;
		_tmp10_ = self->priv->sql;
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED);
		rygel_media_export_database_exec (_tmp9_, _tmp11_, values, values_length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		values = (_vala_GValue_array_free (values, values_length1), NULL);
	}
	goto __finally14;
	__catch14_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaObject* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = object;
		_tmp13_ = rygel_media_object_get_id (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning ("rygel-media-export-media-cache.vala:521: Failed to mark item %s as gua" \
"rded (%d): %s", _tmp14_, guarded_val, _tmp16_);
		_g_error_free0 (_error_);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp5_ = NULL;
	RygelMediaContainer* _tmp6_ = NULL;
	RygelMediaObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	RygelMediaObject* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	RygelMediaObject* _tmp17_ = NULL;
	RygelMediaObject* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		gchar* msg = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp1_ = _ ("Cannot create references to containers");
		_tmp2_ = g_strdup (_tmp1_);
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return NULL;
	}
	_tmp5_ = object;
	_tmp6_ = parent;
	rygel_media_object_set_parent (_tmp5_, _tmp6_);
	_tmp7_ = object;
	_tmp8_ = rygel_media_object_get_ref_id (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		RygelMediaObject* _tmp10_ = NULL;
		RygelMediaObject* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp10_ = object;
		_tmp11_ = object;
		_tmp12_ = rygel_media_object_get_id (_tmp11_);
		_tmp13_ = _tmp12_;
		rygel_media_object_set_ref_id (_tmp10_, _tmp13_);
	}
	_tmp14_ = object;
	_tmp15_ = uuid_get ();
	_tmp16_ = _tmp15_;
	rygel_media_object_set_id (_tmp14_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = object;
	rygel_media_export_media_cache_save_item (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp17_) : NULL, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp18_ = object;
	_tmp19_ = rygel_media_object_get_id (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup (_tmp20_);
	result = _tmp21_;
	return result;
}


static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	{
		GValue* id_value = NULL;
		const gchar* _tmp0_ = NULL;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		gint id_value_length1 = 0;
		gint _id_value_size_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp0_ = id;
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_set_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_new0 (GValue, 1);
		_tmp2_[0] = _tmp1_;
		id_value = _tmp2_;
		id_value_length1 = 1;
		_id_value_size_ = id_value_length1;
		_tmp4_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED, id_value, id_value_length1, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (_inner_error_ != NULL) {
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = _tmp3_ == 1;
		id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
		return result;
	}
	goto __finally15;
	__catch15_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = id;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("rygel-media-export-media-cache.vala:558: Failed to get whether item %s" \
" is guarded: %s", _tmp5_, _tmp7_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally15:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exists_cache);
	self->priv->exists_cache = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
	cursor = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp2_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp3_ = NULL;
		_tmp2_ = cursor;
		_tmp3_ = rygel_media_export_database_cursor_iterator (_tmp2_);
		_statement_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
			sqlite3_stmt* _tmp8_ = NULL;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			sqlite3_stmt* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			GeeHashMap* _tmp13_ = NULL;
			sqlite3_stmt* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaExportExistsCacheEntry _tmp16_ = {0};
			_tmp5_ = _statement_it;
			_tmp6_ = rygel_media_export_database_cursor_iterator_next (_tmp5_, &_inner_error_);
			_tmp4_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (!_tmp4_) {
				break;
			}
			_tmp7_ = _statement_it;
			_tmp8_ = rygel_media_export_database_cursor_iterator_get (_tmp7_, &_inner_error_);
			statement = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
			_tmp9_ = statement;
			_tmp10_ = sqlite3_column_int64 (_tmp9_, 1);
			entry.mtime = _tmp10_;
			_tmp11_ = statement;
			_tmp12_ = sqlite3_column_int64 (_tmp11_, 0);
			entry.size = _tmp12_;
			_tmp13_ = self->priv->exists_cache;
			_tmp14_ = statement;
			_tmp15_ = sqlite3_column_text (_tmp14_, 2);
			_tmp16_ = entry;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, &_tmp16_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	_g_object_unref0 (cursor);
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = max_count;
	if (_tmp0_ == ((guint) 0)) {
		result = (guint) (-1);
		return result;
	} else {
		guint _tmp1_ = 0U;
		_tmp1_ = max_count;
		result = _tmp1_;
		return result;
	}
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	RygelMediaExportDatabase* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMediaExportDatabase* _tmp2_ = NULL;
	gint old_version = 0;
	gint current_version = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = name;
	_tmp2_ = rygel_media_export_database_new (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp0_;
	old_version = -1;
	_tmp3_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	current_version = _tmp3_;
	{
		RygelMediaExportMediaCacheUpgrader* upgrader = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportSQLFactory* _tmp5_ = NULL;
		RygelMediaExportMediaCacheUpgrader* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp19_ = NULL;
		_tmp4_ = self->priv->db;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_media_cache_upgrader_new (_tmp4_, _tmp5_);
		upgrader = _tmp6_;
		_tmp8_ = upgrader;
		_tmp10_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp8_, &_tmp9_, &_inner_error_);
		old_version = _tmp9_;
		_tmp7_ = _tmp10_;
		if (_inner_error_ != NULL) {
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			goto __finally16;
		}
		if (_tmp7_) {
			RygelMediaExportMediaCacheUpgrader* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp11_ = upgrader;
			_tmp12_ = old_version;
			rygel_media_export_media_cache_upgrader_upgrade (_tmp11_, _tmp12_);
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp13_ = old_version;
			_tmp14_ = current_version;
			if (_tmp13_ == _tmp14_) {
				RygelMediaExportMediaCacheUpgrader* _tmp15_ = NULL;
				_tmp15_ = upgrader;
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp15_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch16_rygel_media_export_database_error;
					}
					goto __finally16;
				}
			} else {
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				GError* _tmp18_ = NULL;
				_tmp16_ = old_version;
				_tmp17_ = current_version;
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _tmp16_, _tmp17_);
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
				_inner_error_ = _tmp18_;
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch16_rygel_media_export_database_error;
				}
				goto __finally16;
			}
		}
		_tmp19_ = upgrader;
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp19_);
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	}
	goto __finally16;
	__catch16_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("rygel-media-export-media-cache.vala:608: %s", "Could not find schema version;" " checking for empty database...");
		{
			gint rows = 0;
			RygelMediaExportDatabase* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			_tmp20_ = self->priv->db;
			_tmp21_ = rygel_media_export_database_query_value (_tmp20_, "SELECT count(type) FROM " "sqlite_master WHERE rowid=1", NULL, 0, &_inner_error_);
			rows = _tmp21_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch17_rygel_media_export_database_error;
				}
				_g_error_free0 (_error_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp22_ = rows;
			if (_tmp22_ == 0) {
				gboolean _tmp23_ = FALSE;
				g_debug ("rygel-media-export-media-cache.vala:614: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
				_tmp23_ = rygel_media_export_media_cache_create_schema (self);
				if (!_tmp23_) {
					_g_object_unref0 (self->priv->db);
					self->priv->db = NULL;
					_g_error_free0 (_error_);
					return;
				}
			} else {
				g_warning ("rygel-media-export-media-cache.vala:622: Incompatible schema... cannot" \
" proceed");
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_g_error_free0 (_error_);
				return;
			}
		}
		goto __finally17;
		__catch17_rygel_media_export_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = _error_;
			_tmp25_ = _tmp24_->message;
			g_warning ("rygel-media-export-media-cache.vala:628: Something weird going on: %s", _tmp25_);
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			_tmp26_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
			_inner_error_ = _tmp26_;
			_g_error_free0 (_error_);
			goto __finally17;
		}
		__finally17:
		if (_inner_error_ != NULL) {
			_g_error_free0 (_error_);
			goto __finally16;
		}
		_g_error_free0 (_error_);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	GValue* values = NULL;
	RygelMediaItem* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	GValue _tmp3_ = {0};
	RygelMediaItem* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	RygelMediaItem* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	RygelMediaItem* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue _tmp26_ = {0};
	RygelMediaItem* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GValue _tmp30_ = {0};
	RygelMediaItem* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	GValue _tmp35_ = {0};
	GValue _tmp36_ = {0};
	RygelMediaItem* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GValue _tmp40_ = {0};
	GValue* _tmp41_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaItem* _tmp42_ = NULL;
	RygelMediaItem* _tmp107_ = NULL;
	RygelMediaItem* _tmp137_ = NULL;
	RygelMediaExportDatabase* _tmp146_ = NULL;
	RygelMediaExportSQLFactory* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GValue* _tmp149_ = NULL;
	gint _tmp149__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = rygel_media_item_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	g_value_init (&_tmp3_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp3_, _tmp2_);
	_tmp4_ = item;
	_tmp5_ = rygel_media_item_get_mime_type (_tmp4_);
	_tmp6_ = _tmp5_;
	g_value_init (&_tmp7_, G_TYPE_STRING);
	g_value_set_string (&_tmp7_, _tmp6_);
	g_value_init (&_tmp8_, G_TYPE_INT);
	g_value_set_int (&_tmp8_, -1);
	g_value_init (&_tmp9_, G_TYPE_INT);
	g_value_set_int (&_tmp9_, -1);
	_tmp10_ = item;
	_tmp11_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_value_init (&_tmp13_, G_TYPE_STRING);
	g_value_set_string (&_tmp13_, _tmp12_);
	rygel_media_export_database_null (&_tmp14_);
	rygel_media_export_database_null (&_tmp15_);
	_tmp16_ = item;
	_tmp17_ = rygel_media_item_get_date (_tmp16_);
	_tmp18_ = _tmp17_;
	g_value_init (&_tmp19_, G_TYPE_STRING);
	g_value_set_string (&_tmp19_, _tmp18_);
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, -1);
	g_value_init (&_tmp21_, G_TYPE_INT);
	g_value_set_int (&_tmp21_, -1);
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, -1);
	g_value_init (&_tmp23_, G_TYPE_INT);
	g_value_set_int (&_tmp23_, -1);
	g_value_init (&_tmp24_, G_TYPE_INT);
	g_value_set_int (&_tmp24_, -1);
	g_value_init (&_tmp25_, G_TYPE_INT);
	g_value_set_int (&_tmp25_, -1);
	g_value_init (&_tmp26_, G_TYPE_INT);
	g_value_set_int (&_tmp26_, -1);
	_tmp27_ = item;
	_tmp28_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp27_);
	_tmp29_ = _tmp28_;
	g_value_init (&_tmp30_, G_TYPE_STRING);
	g_value_set_string (&_tmp30_, _tmp29_);
	_tmp31_ = item;
	_tmp32_ = rygel_media_item_get_dlna_profile (_tmp31_);
	_tmp33_ = _tmp32_;
	g_value_init (&_tmp34_, G_TYPE_STRING);
	g_value_set_string (&_tmp34_, _tmp33_);
	rygel_media_export_database_null (&_tmp35_);
	g_value_init (&_tmp36_, G_TYPE_INT);
	g_value_set_int (&_tmp36_, -1);
	_tmp37_ = item;
	_tmp38_ = rygel_media_item_get_creator (_tmp37_);
	_tmp39_ = _tmp38_;
	g_value_init (&_tmp40_, G_TYPE_STRING);
	g_value_set_string (&_tmp40_, _tmp39_);
	_tmp41_ = g_new0 (GValue, 20);
	_tmp41_[0] = _tmp3_;
	_tmp41_[1] = _tmp7_;
	_tmp41_[2] = _tmp8_;
	_tmp41_[3] = _tmp9_;
	_tmp41_[4] = _tmp13_;
	_tmp41_[5] = _tmp14_;
	_tmp41_[6] = _tmp15_;
	_tmp41_[7] = _tmp19_;
	_tmp41_[8] = _tmp20_;
	_tmp41_[9] = _tmp21_;
	_tmp41_[10] = _tmp22_;
	_tmp41_[11] = _tmp23_;
	_tmp41_[12] = _tmp24_;
	_tmp41_[13] = _tmp25_;
	_tmp41_[14] = _tmp26_;
	_tmp41_[15] = _tmp30_;
	_tmp41_[16] = _tmp34_;
	_tmp41_[17] = _tmp35_;
	_tmp41_[18] = _tmp36_;
	_tmp41_[19] = _tmp40_;
	values = _tmp41_;
	values_length1 = 20;
	_values_size_ = values_length1;
	_tmp42_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaItem* _tmp43_ = NULL;
		RygelAudioItem* _tmp44_ = NULL;
		GValue* _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		RygelAudioItem* _tmp46_ = NULL;
		glong _tmp47_ = 0L;
		glong _tmp48_ = 0L;
		GValue _tmp49_ = {0};
		GValue _tmp50_ = {0};
		GValue* _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		RygelAudioItem* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		GValue _tmp55_ = {0};
		GValue _tmp56_ = {0};
		GValue* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		RygelAudioItem* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		GValue _tmp61_ = {0};
		GValue _tmp62_ = {0};
		GValue* _tmp63_ = NULL;
		gint _tmp63__length1 = 0;
		RygelAudioItem* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GValue _tmp67_ = {0};
		GValue _tmp68_ = {0};
		GValue* _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		RygelAudioItem* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		GValue _tmp73_ = {0};
		GValue _tmp74_ = {0};
		RygelMediaItem* _tmp75_ = NULL;
		_tmp43_ = item;
		_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp43_) : NULL);
		audio_item = _tmp44_;
		_tmp45_ = values;
		_tmp45__length1 = values_length1;
		_tmp46_ = audio_item;
		_tmp47_ = rygel_audio_item_get_duration (_tmp46_);
		_tmp48_ = _tmp47_;
		g_value_init (&_tmp49_, G_TYPE_LONG);
		g_value_set_long (&_tmp49_, _tmp48_);
		G_IS_VALUE (&_tmp45_[14]) ? (g_value_unset (&_tmp45_[14]), NULL) : NULL;
		_tmp45_[14] = _tmp49_;
		_tmp50_ = _tmp45_[14];
		_tmp51_ = values;
		_tmp51__length1 = values_length1;
		_tmp52_ = audio_item;
		_tmp53_ = rygel_audio_item_get_bitrate (_tmp52_);
		_tmp54_ = _tmp53_;
		g_value_init (&_tmp55_, G_TYPE_INT);
		g_value_set_int (&_tmp55_, _tmp54_);
		G_IS_VALUE (&_tmp51_[8]) ? (g_value_unset (&_tmp51_[8]), NULL) : NULL;
		_tmp51_[8] = _tmp55_;
		_tmp56_ = _tmp51_[8];
		_tmp57_ = values;
		_tmp57__length1 = values_length1;
		_tmp58_ = audio_item;
		_tmp59_ = rygel_audio_item_get_sample_freq (_tmp58_);
		_tmp60_ = _tmp59_;
		g_value_init (&_tmp61_, G_TYPE_INT);
		g_value_set_int (&_tmp61_, _tmp60_);
		G_IS_VALUE (&_tmp57_[9]) ? (g_value_unset (&_tmp57_[9]), NULL) : NULL;
		_tmp57_[9] = _tmp61_;
		_tmp62_ = _tmp57_[9];
		_tmp63_ = values;
		_tmp63__length1 = values_length1;
		_tmp64_ = audio_item;
		_tmp65_ = rygel_audio_item_get_bits_per_sample (_tmp64_);
		_tmp66_ = _tmp65_;
		g_value_init (&_tmp67_, G_TYPE_INT);
		g_value_set_int (&_tmp67_, _tmp66_);
		G_IS_VALUE (&_tmp63_[10]) ? (g_value_unset (&_tmp63_[10]), NULL) : NULL;
		_tmp63_[10] = _tmp67_;
		_tmp68_ = _tmp63_[10];
		_tmp69_ = values;
		_tmp69__length1 = values_length1;
		_tmp70_ = audio_item;
		_tmp71_ = rygel_audio_item_get_channels (_tmp70_);
		_tmp72_ = _tmp71_;
		g_value_init (&_tmp73_, G_TYPE_INT);
		g_value_set_int (&_tmp73_, _tmp72_);
		G_IS_VALUE (&_tmp69_[11]) ? (g_value_unset (&_tmp69_[11]), NULL) : NULL;
		_tmp69_[11] = _tmp73_;
		_tmp74_ = _tmp69_[11];
		_tmp75_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaItem* _tmp76_ = NULL;
			RygelMediaExportMusicItem* _tmp77_ = NULL;
			GValue* _tmp78_ = NULL;
			gint _tmp78__length1 = 0;
			RygelMediaExportMusicItem* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			GValue _tmp82_ = {0};
			GValue _tmp83_ = {0};
			GValue* _tmp84_ = NULL;
			gint _tmp84__length1 = 0;
			RygelMediaExportMusicItem* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
			const gchar* _tmp87_ = NULL;
			GValue _tmp88_ = {0};
			GValue _tmp89_ = {0};
			GValue* _tmp90_ = NULL;
			gint _tmp90__length1 = 0;
			RygelMediaExportMusicItem* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			const gchar* _tmp93_ = NULL;
			GValue _tmp94_ = {0};
			GValue _tmp95_ = {0};
			GValue* _tmp96_ = NULL;
			gint _tmp96__length1 = 0;
			RygelMediaExportMusicItem* _tmp97_ = NULL;
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			GValue _tmp100_ = {0};
			GValue _tmp101_ = {0};
			GValue* _tmp102_ = NULL;
			gint _tmp102__length1 = 0;
			RygelMediaExportMusicItem* _tmp103_ = NULL;
			gint _tmp104_ = 0;
			GValue _tmp105_ = {0};
			GValue _tmp106_ = {0};
			_tmp76_ = item;
			_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp76_) : NULL);
			music_item = _tmp77_;
			_tmp78_ = values;
			_tmp78__length1 = values_length1;
			_tmp79_ = music_item;
			_tmp80_ = rygel_music_item_get_artist ((RygelMusicItem*) _tmp79_);
			_tmp81_ = _tmp80_;
			g_value_init (&_tmp82_, G_TYPE_STRING);
			g_value_set_string (&_tmp82_, _tmp81_);
			G_IS_VALUE (&_tmp78_[5]) ? (g_value_unset (&_tmp78_[5]), NULL) : NULL;
			_tmp78_[5] = _tmp82_;
			_tmp83_ = _tmp78_[5];
			_tmp84_ = values;
			_tmp84__length1 = values_length1;
			_tmp85_ = music_item;
			_tmp86_ = rygel_music_item_get_album ((RygelMusicItem*) _tmp85_);
			_tmp87_ = _tmp86_;
			g_value_init (&_tmp88_, G_TYPE_STRING);
			g_value_set_string (&_tmp88_, _tmp87_);
			G_IS_VALUE (&_tmp84_[6]) ? (g_value_unset (&_tmp84_[6]), NULL) : NULL;
			_tmp84_[6] = _tmp88_;
			_tmp89_ = _tmp84_[6];
			_tmp90_ = values;
			_tmp90__length1 = values_length1;
			_tmp91_ = music_item;
			_tmp92_ = rygel_music_item_get_genre ((RygelMusicItem*) _tmp91_);
			_tmp93_ = _tmp92_;
			g_value_init (&_tmp94_, G_TYPE_STRING);
			g_value_set_string (&_tmp94_, _tmp93_);
			G_IS_VALUE (&_tmp90_[17]) ? (g_value_unset (&_tmp90_[17]), NULL) : NULL;
			_tmp90_[17] = _tmp94_;
			_tmp95_ = _tmp90_[17];
			_tmp96_ = values;
			_tmp96__length1 = values_length1;
			_tmp97_ = music_item;
			_tmp98_ = rygel_music_item_get_track_number ((RygelMusicItem*) _tmp97_);
			_tmp99_ = _tmp98_;
			g_value_init (&_tmp100_, G_TYPE_INT);
			g_value_set_int (&_tmp100_, _tmp99_);
			G_IS_VALUE (&_tmp96_[12]) ? (g_value_unset (&_tmp96_[12]), NULL) : NULL;
			_tmp96_[12] = _tmp100_;
			_tmp101_ = _tmp96_[12];
			_tmp102_ = values;
			_tmp102__length1 = values_length1;
			_tmp103_ = music_item;
			_tmp104_ = _tmp103_->disc;
			g_value_init (&_tmp105_, G_TYPE_INT);
			g_value_set_int (&_tmp105_, _tmp104_);
			G_IS_VALUE (&_tmp102_[18]) ? (g_value_unset (&_tmp102_[18]), NULL) : NULL;
			_tmp102_[18] = _tmp105_;
			_tmp106_ = _tmp102_[18];
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp107_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelMediaItem* _tmp108_ = NULL;
		RygelVisualItem* _tmp109_ = NULL;
		GValue* _tmp110_ = NULL;
		gint _tmp110__length1 = 0;
		RygelVisualItem* _tmp111_ = NULL;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		GValue _tmp114_ = {0};
		GValue _tmp115_ = {0};
		GValue* _tmp116_ = NULL;
		gint _tmp116__length1 = 0;
		RygelVisualItem* _tmp117_ = NULL;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		GValue _tmp120_ = {0};
		GValue _tmp121_ = {0};
		GValue* _tmp122_ = NULL;
		gint _tmp122__length1 = 0;
		RygelVisualItem* _tmp123_ = NULL;
		gint _tmp124_ = 0;
		gint _tmp125_ = 0;
		GValue _tmp126_ = {0};
		GValue _tmp127_ = {0};
		RygelMediaItem* _tmp128_ = NULL;
		_tmp108_ = item;
		_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp108_) : NULL);
		visual_item = _tmp109_;
		_tmp110_ = values;
		_tmp110__length1 = values_length1;
		_tmp111_ = visual_item;
		_tmp112_ = rygel_visual_item_get_width (_tmp111_);
		_tmp113_ = _tmp112_;
		g_value_init (&_tmp114_, G_TYPE_INT);
		g_value_set_int (&_tmp114_, _tmp113_);
		G_IS_VALUE (&_tmp110_[2]) ? (g_value_unset (&_tmp110_[2]), NULL) : NULL;
		_tmp110_[2] = _tmp114_;
		_tmp115_ = _tmp110_[2];
		_tmp116_ = values;
		_tmp116__length1 = values_length1;
		_tmp117_ = visual_item;
		_tmp118_ = rygel_visual_item_get_height (_tmp117_);
		_tmp119_ = _tmp118_;
		g_value_init (&_tmp120_, G_TYPE_INT);
		g_value_set_int (&_tmp120_, _tmp119_);
		G_IS_VALUE (&_tmp116_[3]) ? (g_value_unset (&_tmp116_[3]), NULL) : NULL;
		_tmp116_[3] = _tmp120_;
		_tmp121_ = _tmp116_[3];
		_tmp122_ = values;
		_tmp122__length1 = values_length1;
		_tmp123_ = visual_item;
		_tmp124_ = rygel_visual_item_get_color_depth (_tmp123_);
		_tmp125_ = _tmp124_;
		g_value_init (&_tmp126_, G_TYPE_INT);
		g_value_set_int (&_tmp126_, _tmp125_);
		G_IS_VALUE (&_tmp122_[13]) ? (g_value_unset (&_tmp122_[13]), NULL) : NULL;
		_tmp122_[13] = _tmp126_;
		_tmp127_ = _tmp122_[13];
		_tmp128_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM)) {
			RygelMediaExportVideoItem* video_item = NULL;
			RygelMediaItem* _tmp129_ = NULL;
			RygelMediaExportVideoItem* _tmp130_ = NULL;
			GValue* _tmp131_ = NULL;
			gint _tmp131__length1 = 0;
			RygelMediaExportVideoItem* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			const gchar* _tmp134_ = NULL;
			GValue _tmp135_ = {0};
			GValue _tmp136_ = {0};
			_tmp129_ = item;
			_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp129_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp129_) : NULL);
			video_item = _tmp130_;
			_tmp131_ = values;
			_tmp131__length1 = values_length1;
			_tmp132_ = video_item;
			_tmp133_ = rygel_video_item_get_author ((RygelVideoItem*) _tmp132_);
			_tmp134_ = _tmp133_;
			g_value_init (&_tmp135_, G_TYPE_STRING);
			g_value_set_string (&_tmp135_, _tmp134_);
			G_IS_VALUE (&_tmp131_[5]) ? (g_value_unset (&_tmp131_[5]), NULL) : NULL;
			_tmp131_[5] = _tmp135_;
			_tmp136_ = _tmp131_[5];
			_g_object_unref0 (video_item);
		}
		_g_object_unref0 (visual_item);
	}
	_tmp137_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM)) {
		RygelMediaExportPlaylistItem* playlist_item = NULL;
		RygelMediaItem* _tmp138_ = NULL;
		RygelMediaExportPlaylistItem* _tmp139_ = NULL;
		GValue* _tmp140_ = NULL;
		gint _tmp140__length1 = 0;
		RygelMediaExportPlaylistItem* _tmp141_ = NULL;
		const gchar* _tmp142_ = NULL;
		const gchar* _tmp143_ = NULL;
		GValue _tmp144_ = {0};
		GValue _tmp145_ = {0};
		_tmp138_ = item;
		_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM) ? ((RygelMediaExportPlaylistItem*) _tmp138_) : NULL);
		playlist_item = _tmp139_;
		_tmp140_ = values;
		_tmp140__length1 = values_length1;
		_tmp141_ = playlist_item;
		_tmp142_ = rygel_media_item_get_creator ((RygelMediaItem*) _tmp141_);
		_tmp143_ = _tmp142_;
		g_value_init (&_tmp144_, G_TYPE_STRING);
		g_value_set_string (&_tmp144_, _tmp143_);
		G_IS_VALUE (&_tmp140_[5]) ? (g_value_unset (&_tmp140_[5]), NULL) : NULL;
		_tmp140_[5] = _tmp144_;
		_tmp145_ = _tmp140_[5];
		_g_object_unref0 (playlist_item);
	}
	_tmp146_ = self->priv->db;
	_tmp147_ = self->priv->sql;
	_tmp148_ = rygel_media_export_sql_factory_make (_tmp147_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	_tmp149_ = values;
	_tmp149__length1 = values_length1;
	rygel_media_export_database_exec (_tmp146_, _tmp148_, _tmp149_, _tmp149__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	gint type = 0;
	GValue parent = {0};
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelMediaObject* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GValue* values = NULL;
	gint _tmp19_ = 0;
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	RygelMediaObject* _tmp23_ = NULL;
	guint64 _tmp24_ = 0ULL;
	guint64 _tmp25_ = 0ULL;
	GValue _tmp26_ = {0};
	const gchar* _tmp27_ = NULL;
	GValue _tmp28_ = {0};
	RygelMediaObject* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	GValue _tmp32_ = {0};
	GValue _tmp33_ = {0};
	GValue _tmp34_ = {0};
	RygelMediaObject* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GValue _tmp38_ = {0};
	GValue* _tmp39_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* _tmp40_ = NULL;
	RygelMediaExportDatabase* _tmp53_ = NULL;
	RygelMediaExportSQLFactory* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	GValue* _tmp56_ = NULL;
	gint _tmp56__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp1_ = object;
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		GValue _tmp4_ = {0};
		rygel_media_export_database_null (&_tmp4_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp4_;
	} else {
		RygelMediaObject* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
		_tmp5_ = object;
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		g_value_init (&_tmp10_, G_TYPE_STRING);
		g_value_set_string (&_tmp10_, _tmp9_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp10_;
	}
	_tmp12_ = object;
	_tmp13_ = _tmp12_->uris;
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_g_free0 (_tmp11_);
		_tmp11_ = NULL;
	} else {
		RygelMediaObject* _tmp16_ = NULL;
		GeeArrayList* _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		_tmp16_ = object;
		_tmp17_ = _tmp16_->uris;
		_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
		_g_free0 (_tmp11_);
		_tmp11_ = (gchar*) _tmp18_;
	}
	_tmp19_ = type;
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, _tmp19_);
	_tmp21_ = parent;
	if (G_IS_VALUE (&_tmp21_)) {
		g_value_init (&_tmp22_, G_VALUE_TYPE (&_tmp21_));
		g_value_copy (&_tmp21_, &_tmp22_);
	} else {
		_tmp22_ = _tmp21_;
	}
	_tmp23_ = object;
	_tmp24_ = rygel_media_object_get_modified (_tmp23_);
	_tmp25_ = _tmp24_;
	g_value_init (&_tmp26_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp26_, _tmp25_);
	_tmp27_ = _tmp11_;
	g_value_init (&_tmp28_, G_TYPE_STRING);
	g_value_set_string (&_tmp28_, _tmp27_);
	_tmp29_ = object;
	_tmp30_ = rygel_media_object_get_object_update_id (_tmp29_);
	_tmp31_ = _tmp30_;
	g_value_init (&_tmp32_, G_TYPE_UINT);
	g_value_set_uint (&_tmp32_, _tmp31_);
	g_value_init (&_tmp33_, G_TYPE_INT);
	g_value_set_int (&_tmp33_, -1);
	g_value_init (&_tmp34_, G_TYPE_INT);
	g_value_set_int (&_tmp34_, -1);
	_tmp35_ = object;
	_tmp36_ = rygel_media_object_get_id (_tmp35_);
	_tmp37_ = _tmp36_;
	g_value_init (&_tmp38_, G_TYPE_STRING);
	g_value_set_string (&_tmp38_, _tmp37_);
	_tmp39_ = g_new0 (GValue, 8);
	_tmp39_[0] = _tmp20_;
	_tmp39_[1] = _tmp22_;
	_tmp39_[2] = _tmp26_;
	_tmp39_[3] = _tmp28_;
	_tmp39_[4] = _tmp32_;
	_tmp39_[5] = _tmp33_;
	_tmp39_[6] = _tmp34_;
	_tmp39_[7] = _tmp38_;
	values = _tmp39_;
	values_length1 = 8;
	_values_size_ = values_length1;
	_tmp40_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp41_ = NULL;
		RygelMediaContainer* _tmp42_ = NULL;
		GValue* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		RygelMediaContainer* _tmp44_ = NULL;
		gint64 _tmp45_ = 0LL;
		GValue _tmp46_ = {0};
		GValue _tmp47_ = {0};
		GValue* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		RygelMediaContainer* _tmp49_ = NULL;
		guint32 _tmp50_ = 0U;
		GValue _tmp51_ = {0};
		GValue _tmp52_ = {0};
		_tmp41_ = object;
		_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp41_) : NULL);
		container = _tmp42_;
		_tmp43_ = values;
		_tmp43__length1 = values_length1;
		_tmp44_ = container;
		_tmp45_ = _tmp44_->total_deleted_child_count;
		g_value_init (&_tmp46_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp46_, _tmp45_);
		G_IS_VALUE (&_tmp43_[6]) ? (g_value_unset (&_tmp43_[6]), NULL) : NULL;
		_tmp43_[6] = _tmp46_;
		_tmp47_ = _tmp43_[6];
		_tmp48_ = values;
		_tmp48__length1 = values_length1;
		_tmp49_ = container;
		_tmp50_ = _tmp49_->update_id;
		g_value_init (&_tmp51_, G_TYPE_UINT);
		g_value_set_uint (&_tmp51_, _tmp50_);
		G_IS_VALUE (&_tmp48_[7]) ? (g_value_unset (&_tmp48_[7]), NULL) : NULL;
		_tmp48_[7] = _tmp51_;
		_tmp52_ = _tmp48_[7];
		_g_object_unref0 (container);
	}
	_tmp53_ = self->priv->db;
	_tmp54_ = self->priv->sql;
	_tmp55_ = rygel_media_export_sql_factory_make (_tmp54_, RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT);
	_tmp56_ = values;
	_tmp56__length1 = values_length1;
	rygel_media_export_database_exec (_tmp53_, _tmp55_, _tmp56_, _tmp56__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (_tmp11_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (_tmp11_);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error) {
	gint type = 0;
	GValue parent = {0};
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelMediaObject* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gchar* _tmp21_ = NULL;
	RygelMediaObject* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GValue* values = NULL;
	RygelMediaObject* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GValue _tmp30_ = {0};
	RygelMediaObject* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	gint _tmp35_ = 0;
	GValue _tmp36_ = {0};
	GValue _tmp37_ = {0};
	GValue _tmp38_ = {0};
	RygelMediaObject* _tmp39_ = NULL;
	guint64 _tmp40_ = 0ULL;
	guint64 _tmp41_ = 0ULL;
	GValue _tmp42_ = {0};
	const gchar* _tmp43_ = NULL;
	GValue _tmp44_ = {0};
	RygelMediaObject* _tmp45_ = NULL;
	guint _tmp46_ = 0U;
	guint _tmp47_ = 0U;
	GValue _tmp48_ = {0};
	GValue _tmp49_ = {0};
	GValue _tmp50_ = {0};
	gint _tmp51_ = 0;
	GValue _tmp52_ = {0};
	const gchar* _tmp53_ = NULL;
	GValue _tmp54_ = {0};
	GValue* _tmp55_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* _tmp56_ = NULL;
	RygelMediaExportDatabase* _tmp69_ = NULL;
	RygelMediaExportSQLFactory* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	GValue* _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp1_ = object;
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		GValue _tmp4_ = {0};
		rygel_media_export_database_null (&_tmp4_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp4_;
	} else {
		RygelMediaObject* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
		_tmp5_ = object;
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		g_value_init (&_tmp10_, G_TYPE_STRING);
		g_value_set_string (&_tmp10_, _tmp9_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp10_;
	}
	_tmp12_ = object;
	_tmp13_ = _tmp12_->uris;
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_g_free0 (_tmp11_);
		_tmp11_ = NULL;
	} else {
		RygelMediaObject* _tmp16_ = NULL;
		GeeArrayList* _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		_tmp16_ = object;
		_tmp17_ = _tmp16_->uris;
		_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
		_g_free0 (_tmp11_);
		_tmp11_ = (gchar*) _tmp18_;
	}
	_tmp20_ = is_guarded;
	if (_tmp20_) {
		_tmp19_ = 1;
	} else {
		_tmp19_ = 0;
	}
	_tmp22_ = object;
	_tmp23_ = rygel_media_object_get_ref_id (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup (_tmp24_);
	_tmp21_ = _tmp25_;
	_tmp26_ = _tmp21_;
	if (_tmp26_ == NULL) {
		_g_free0 (_tmp21_);
		_tmp21_ = NULL;
	}
	_tmp27_ = object;
	_tmp28_ = rygel_media_object_get_id (_tmp27_);
	_tmp29_ = _tmp28_;
	g_value_init (&_tmp30_, G_TYPE_STRING);
	g_value_set_string (&_tmp30_, _tmp29_);
	_tmp31_ = object;
	_tmp32_ = rygel_media_object_get_title (_tmp31_);
	_tmp33_ = _tmp32_;
	g_value_init (&_tmp34_, G_TYPE_STRING);
	g_value_set_string (&_tmp34_, _tmp33_);
	_tmp35_ = type;
	g_value_init (&_tmp36_, G_TYPE_INT);
	g_value_set_int (&_tmp36_, _tmp35_);
	_tmp37_ = parent;
	if (G_IS_VALUE (&_tmp37_)) {
		g_value_init (&_tmp38_, G_VALUE_TYPE (&_tmp37_));
		g_value_copy (&_tmp37_, &_tmp38_);
	} else {
		_tmp38_ = _tmp37_;
	}
	_tmp39_ = object;
	_tmp40_ = rygel_media_object_get_modified (_tmp39_);
	_tmp41_ = _tmp40_;
	g_value_init (&_tmp42_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp42_, _tmp41_);
	_tmp43_ = _tmp11_;
	g_value_init (&_tmp44_, G_TYPE_STRING);
	g_value_set_string (&_tmp44_, _tmp43_);
	_tmp45_ = object;
	_tmp46_ = rygel_media_object_get_object_update_id (_tmp45_);
	_tmp47_ = _tmp46_;
	g_value_init (&_tmp48_, G_TYPE_UINT);
	g_value_set_uint (&_tmp48_, _tmp47_);
	g_value_init (&_tmp49_, G_TYPE_INT);
	g_value_set_int (&_tmp49_, -1);
	g_value_init (&_tmp50_, G_TYPE_INT);
	g_value_set_int (&_tmp50_, -1);
	_tmp51_ = _tmp19_;
	g_value_init (&_tmp52_, G_TYPE_INT);
	g_value_set_int (&_tmp52_, _tmp51_);
	_tmp53_ = _tmp21_;
	g_value_init (&_tmp54_, G_TYPE_STRING);
	g_value_set_string (&_tmp54_, _tmp53_);
	_tmp55_ = g_new0 (GValue, 11);
	_tmp55_[0] = _tmp30_;
	_tmp55_[1] = _tmp34_;
	_tmp55_[2] = _tmp36_;
	_tmp55_[3] = _tmp38_;
	_tmp55_[4] = _tmp42_;
	_tmp55_[5] = _tmp44_;
	_tmp55_[6] = _tmp48_;
	_tmp55_[7] = _tmp49_;
	_tmp55_[8] = _tmp50_;
	_tmp55_[9] = _tmp52_;
	_tmp55_[10] = _tmp54_;
	values = _tmp55_;
	values_length1 = 11;
	_values_size_ = values_length1;
	_tmp56_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp57_ = NULL;
		RygelMediaContainer* _tmp58_ = NULL;
		GValue* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		RygelMediaContainer* _tmp60_ = NULL;
		gint64 _tmp61_ = 0LL;
		GValue _tmp62_ = {0};
		GValue _tmp63_ = {0};
		GValue* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		RygelMediaContainer* _tmp65_ = NULL;
		guint32 _tmp66_ = 0U;
		GValue _tmp67_ = {0};
		GValue _tmp68_ = {0};
		_tmp57_ = object;
		_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp57_) : NULL);
		container = _tmp58_;
		_tmp59_ = values;
		_tmp59__length1 = values_length1;
		_tmp60_ = container;
		_tmp61_ = _tmp60_->total_deleted_child_count;
		g_value_init (&_tmp62_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp62_, _tmp61_);
		G_IS_VALUE (&_tmp59_[7]) ? (g_value_unset (&_tmp59_[7]), NULL) : NULL;
		_tmp59_[7] = _tmp62_;
		_tmp63_ = _tmp59_[7];
		_tmp64_ = values;
		_tmp64__length1 = values_length1;
		_tmp65_ = container;
		_tmp66_ = _tmp65_->update_id;
		g_value_init (&_tmp67_, G_TYPE_UINT);
		g_value_set_uint (&_tmp67_, _tmp66_);
		G_IS_VALUE (&_tmp64_[8]) ? (g_value_unset (&_tmp64_[8]), NULL) : NULL;
		_tmp64_[8] = _tmp67_;
		_tmp68_ = _tmp64_[8];
		_g_object_unref0 (container);
	}
	_tmp69_ = self->priv->db;
	_tmp70_ = self->priv->sql;
	_tmp71_ = rygel_media_export_sql_factory_make (_tmp70_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
	_tmp72_ = values;
	_tmp72__length1 = values_length1;
	rygel_media_export_database_exec (_tmp69_, _tmp71_, _tmp72_, _tmp72__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp11_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp11_);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


/**
     * Add the container or item to the cache.
     */
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error) {
	gboolean is_guarded = FALSE;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = rygel_media_export_media_cache_is_object_guarded (self, _tmp2_);
	is_guarded = _tmp3_;
	_tmp5_ = override_guarded;
	if (!_tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = is_guarded;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		RygelMediaObject* _tmp8_ = NULL;
		_tmp8_ = object;
		rygel_media_export_media_cache_update_guarded_object (self, _tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		RygelMediaObject* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = is_guarded;
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			gboolean _tmp11_ = FALSE;
			_tmp11_ = override_guarded;
			_tmp9_ = _tmp11_;
		}
		_tmp12_ = object;
		_tmp13_ = _tmp9_;
		rygel_media_export_media_cache_create_normal_object (self, _tmp12_, _tmp13_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaExportDatabase* _tmp1_ = NULL;
		RygelMediaExportSQLFactory* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportSQLFactory* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_ = NULL;
		RygelMediaExportSQLFactory* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelMediaExportDatabase* _tmp10_ = NULL;
		RygelMediaExportSQLFactory* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportDatabase* _tmp13_ = NULL;
		RygelMediaExportSQLFactory* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		RygelMediaExportDatabase* _tmp16_ = NULL;
		RygelMediaExportSQLFactory* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		RygelMediaExportDatabase* _tmp19_ = NULL;
		RygelMediaExportDatabase* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp1_ = self->priv->db;
		_tmp2_ = self->priv->sql;
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
		rygel_media_export_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp4_ = self->priv->db;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp7_ = self->priv->db;
		_tmp8_ = self->priv->sql;
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_media_export_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp10_ = self->priv->db;
		_tmp11_ = self->priv->sql;
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_media_export_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp13_ = self->priv->db;
		_tmp14_ = self->priv->sql;
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp16_ = self->priv->db;
		_tmp17_ = self->priv->sql;
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
		rygel_media_export_database_exec (_tmp16_, _tmp18_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp19_ = self->priv->db;
		rygel_media_export_database_commit (_tmp19_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp20_ = self->priv->db;
		rygel_media_export_database_analyze (_tmp20_);
		_tmp21_ = uuid_get ();
		_tmp22_ = _tmp21_;
		rygel_media_export_media_cache_save_reset_token (self, _tmp22_);
		_g_free0 (_tmp22_);
		result = TRUE;
		return result;
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		RygelMediaExportDatabase* _tmp25_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning ("rygel-media-export-media-cache.vala:801: Failed to create schema: %s", _tmp24_);
		_tmp25_ = self->priv->db;
		rygel_media_export_database_rollback (_tmp25_);
		_g_error_free0 (err);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


/**
     * Create a new container or item based on a SQL result.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     *
     * @param parent The object's parent container.
     * @param statement a SQLite result indicating the container's details.
     */
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* title = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* object_id = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* uri = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	sqlite3_stmt* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	RygelMediaObject* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	object = NULL;
	_tmp0_ = statement;
	_tmp1_ = sqlite3_column_text (_tmp0_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
	title = _tmp1_;
	_tmp2_ = statement;
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	object_id = _tmp3_;
	_tmp4_ = statement;
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
	uri = _tmp5_;
	_tmp6_ = statement;
	_tmp7_ = sqlite3_column_int (_tmp6_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
	switch (_tmp7_) {
		case 0:
		{
			RygelMediaExportObjectFactory* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			RygelMediaExportDBContainer* _tmp12_ = NULL;
			RygelMediaContainer* container = NULL;
			RygelMediaObject* _tmp13_ = NULL;
			RygelMediaContainer* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			RygelMediaContainer* _tmp22_ = NULL;
			sqlite3_stmt* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
			_tmp8_ = self->priv->factory;
			_tmp9_ = object_id;
			_tmp10_ = title;
			_tmp11_ = uri;
			_tmp12_ = rygel_media_export_object_factory_get_container (_tmp8_, _tmp9_, _tmp10_, (guint) 0, _tmp11_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp12_;
			_tmp13_ = object;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp13_) : NULL);
			container = _tmp14_;
			_tmp15_ = uri;
			if (_tmp15_ != NULL) {
				RygelMediaContainer* _tmp16_ = NULL;
				GeeArrayList* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				_tmp16_ = container;
				_tmp17_ = ((RygelMediaObject*) _tmp16_)->uris;
				_tmp18_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
			}
			_tmp19_ = container;
			_tmp20_ = statement;
			_tmp21_ = sqlite3_column_int64 (_tmp20_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT);
			_tmp19_->total_deleted_child_count = (gint64) ((guint32) _tmp21_);
			_tmp22_ = container;
			_tmp23_ = statement;
			_tmp24_ = sqlite3_column_int64 (_tmp23_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID);
			_tmp22_->update_id = (guint32) ((guint) _tmp24_);
			_g_object_unref0 (container);
			break;
		}
		case 1:
		{
			const gchar* upnp_class = NULL;
			sqlite3_stmt* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			RygelMediaExportObjectFactory* _tmp27_ = NULL;
			RygelMediaContainer* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			RygelMediaItem* _tmp32_ = NULL;
			sqlite3_stmt* _tmp33_ = NULL;
			RygelMediaObject* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			_tmp25_ = statement;
			_tmp26_ = sqlite3_column_text (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
			upnp_class = _tmp26_;
			_tmp27_ = self->priv->factory;
			_tmp28_ = parent;
			_tmp29_ = object_id;
			_tmp30_ = title;
			_tmp31_ = upnp_class;
			_tmp32_ = rygel_media_export_object_factory_get_item (_tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp32_;
			_tmp33_ = statement;
			_tmp34_ = object;
			rygel_media_export_media_cache_fill_item (self, _tmp33_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp34_) : NULL);
			_tmp35_ = uri;
			if (_tmp35_ != NULL) {
				RygelMediaObject* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				_tmp36_ = object;
				_tmp37_ = uri;
				rygel_media_item_add_uri (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp36_) : NULL, _tmp37_);
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp38_ = object;
	if (_tmp38_ != NULL) {
		RygelMediaObject* _tmp39_ = NULL;
		sqlite3_stmt* _tmp40_ = NULL;
		gint64 _tmp41_ = 0LL;
		gboolean _tmp42_ = FALSE;
		RygelMediaObject* _tmp43_ = NULL;
		guint64 _tmp44_ = 0ULL;
		guint64 _tmp45_ = 0ULL;
		gint64 _tmp46_ = 0LL;
		gboolean _tmp48_ = FALSE;
		RygelMediaObject* _tmp51_ = NULL;
		sqlite3_stmt* _tmp52_ = NULL;
		gint64 _tmp53_ = 0LL;
		RygelMediaObject* _tmp54_ = NULL;
		sqlite3_stmt* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		_tmp39_ = object;
		_tmp40_ = statement;
		_tmp41_ = sqlite3_column_int64 (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
		rygel_media_object_set_modified (_tmp39_, (guint64) _tmp41_);
		_tmp43_ = object;
		_tmp44_ = rygel_media_object_get_modified (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = G_MAXINT64;
		if (_tmp45_ == ((guint64) _tmp46_)) {
			RygelMediaObject* _tmp47_ = NULL;
			_tmp47_ = object;
			_tmp42_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, RYGEL_TYPE_MEDIA_ITEM);
		} else {
			_tmp42_ = FALSE;
		}
		_tmp48_ = _tmp42_;
		if (_tmp48_) {
			RygelMediaObject* _tmp49_ = NULL;
			RygelMediaObject* _tmp50_ = NULL;
			_tmp49_ = object;
			rygel_media_object_set_modified (_tmp49_, (guint64) 0);
			_tmp50_ = object;
			rygel_media_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp50_) : NULL, TRUE);
		}
		_tmp51_ = object;
		_tmp52_ = statement;
		_tmp53_ = sqlite3_column_int64 (_tmp52_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID);
		rygel_media_object_set_object_update_id (_tmp51_, (guint) _tmp53_);
		_tmp54_ = object;
		_tmp55_ = statement;
		_tmp56_ = sqlite3_column_text (_tmp55_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID);
		rygel_media_object_set_ref_id (_tmp54_, _tmp56_);
	}
	result = object;
	return result;
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	RygelMediaItem* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaItem* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaItem* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelMediaItem* _tmp9_ = NULL;
	sqlite3_stmt* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	RygelMediaItem* _tmp12_ = NULL;
	sqlite3_stmt* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelMediaItem* _tmp15_ = NULL;
	RygelMediaItem* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = statement;
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
	rygel_media_item_set_date (_tmp0_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = statement;
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
	rygel_media_item_set_mime_type (_tmp3_, _tmp5_);
	_tmp6_ = item;
	_tmp7_ = statement;
	_tmp8_ = sqlite3_column_text (_tmp7_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
	rygel_media_item_set_dlna_profile (_tmp6_, _tmp8_);
	_tmp9_ = item;
	_tmp10_ = statement;
	_tmp11_ = sqlite3_column_int64 (_tmp10_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
	rygel_media_item_set_size (_tmp9_, _tmp11_);
	_tmp12_ = item;
	_tmp13_ = statement;
	_tmp14_ = sqlite3_column_text (_tmp13_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR);
	rygel_media_item_set_creator (_tmp12_, _tmp14_);
	_tmp15_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaItem* _tmp16_ = NULL;
		RygelAudioItem* _tmp17_ = NULL;
		RygelAudioItem* _tmp18_ = NULL;
		sqlite3_stmt* _tmp19_ = NULL;
		gint64 _tmp20_ = 0LL;
		RygelAudioItem* _tmp21_ = NULL;
		sqlite3_stmt* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		RygelAudioItem* _tmp24_ = NULL;
		sqlite3_stmt* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		RygelAudioItem* _tmp27_ = NULL;
		sqlite3_stmt* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		RygelAudioItem* _tmp30_ = NULL;
		sqlite3_stmt* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		RygelMediaItem* _tmp33_ = NULL;
		_tmp16_ = item;
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp16_) : NULL);
		audio_item = _tmp17_;
		_tmp18_ = audio_item;
		_tmp19_ = statement;
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
		rygel_audio_item_set_duration (_tmp18_, (glong) _tmp20_);
		_tmp21_ = audio_item;
		_tmp22_ = statement;
		_tmp23_ = sqlite3_column_int (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
		rygel_audio_item_set_bitrate (_tmp21_, _tmp23_);
		_tmp24_ = audio_item;
		_tmp25_ = statement;
		_tmp26_ = sqlite3_column_int (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
		rygel_audio_item_set_sample_freq (_tmp24_, _tmp26_);
		_tmp27_ = audio_item;
		_tmp28_ = statement;
		_tmp29_ = sqlite3_column_int (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
		rygel_audio_item_set_bits_per_sample (_tmp27_, _tmp29_);
		_tmp30_ = audio_item;
		_tmp31_ = statement;
		_tmp32_ = sqlite3_column_int (_tmp31_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
		rygel_audio_item_set_channels (_tmp30_, _tmp32_);
		_tmp33_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaItem* _tmp34_ = NULL;
			RygelMediaExportMusicItem* _tmp35_ = NULL;
			RygelMediaExportMusicItem* _tmp36_ = NULL;
			sqlite3_stmt* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			RygelMediaExportMusicItem* _tmp39_ = NULL;
			sqlite3_stmt* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			RygelMediaExportMusicItem* _tmp42_ = NULL;
			sqlite3_stmt* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			RygelMediaExportMusicItem* _tmp45_ = NULL;
			sqlite3_stmt* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			RygelMediaExportMusicItem* _tmp48_ = NULL;
			_tmp34_ = item;
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp34_) : NULL);
			music_item = _tmp35_;
			_tmp36_ = music_item;
			_tmp37_ = statement;
			_tmp38_ = sqlite3_column_text (_tmp37_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
			rygel_music_item_set_artist ((RygelMusicItem*) _tmp36_, _tmp38_);
			_tmp39_ = music_item;
			_tmp40_ = statement;
			_tmp41_ = sqlite3_column_text (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
			rygel_music_item_set_album ((RygelMusicItem*) _tmp39_, _tmp41_);
			_tmp42_ = music_item;
			_tmp43_ = statement;
			_tmp44_ = sqlite3_column_text (_tmp43_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
			rygel_music_item_set_genre ((RygelMusicItem*) _tmp42_, _tmp44_);
			_tmp45_ = music_item;
			_tmp46_ = statement;
			_tmp47_ = sqlite3_column_int (_tmp46_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp45_, _tmp47_);
			_tmp48_ = music_item;
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp48_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp49_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelMediaItem* _tmp50_ = NULL;
		RygelVisualItem* _tmp51_ = NULL;
		RygelVisualItem* _tmp52_ = NULL;
		sqlite3_stmt* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		RygelVisualItem* _tmp55_ = NULL;
		sqlite3_stmt* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		RygelVisualItem* _tmp58_ = NULL;
		sqlite3_stmt* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		_tmp50_ = item;
		_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp50_) : NULL);
		visual_item = _tmp51_;
		_tmp52_ = visual_item;
		_tmp53_ = statement;
		_tmp54_ = sqlite3_column_int (_tmp53_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
		rygel_visual_item_set_width (_tmp52_, _tmp54_);
		_tmp55_ = visual_item;
		_tmp56_ = statement;
		_tmp57_ = sqlite3_column_int (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
		rygel_visual_item_set_height (_tmp55_, _tmp57_);
		_tmp58_ = visual_item;
		_tmp59_ = statement;
		_tmp60_ = sqlite3_column_int (_tmp59_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
		rygel_visual_item_set_color_depth (_tmp58_, _tmp60_);
		_g_object_unref0 (visual_item);
	}
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GValueArray* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = expression;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = expression;
	_tmp3_ = args;
	_tmp4_ = rygel_media_export_media_cache_search_expression_to_sql (_tmp2_, _tmp3_, &_inner_error_);
	filter = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = prefix;
	_tmp6_ = filter;
	_tmp7_ = g_strdup_printf (" %s %s", _tmp5_, _tmp6_);
	result = _tmp7_;
	_g_free0 (filter);
	return result;
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = expression;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = expression;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		gchar* _tmp3_ = NULL;
		RygelSearchExpression* _tmp4_ = NULL;
		GValueArray* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = expression;
		_tmp5_ = args;
		_tmp6_ = rygel_media_export_media_cache_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp4_) : NULL, _tmp5_, &_inner_error_);
		_tmp3_ = _tmp6_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp7_ = NULL;
		RygelSearchExpression* _tmp8_ = NULL;
		GValueArray* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = expression;
		_tmp9_ = args;
		_tmp10_ = rygel_media_export_media_cache_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp8_) : NULL, _tmp9_, &_inner_error_);
		_tmp7_ = _tmp10_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp7_;
		return result;
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	gchar* left_sql_string = NULL;
	RygelLogicalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* right_sql_string = NULL;
	RygelLogicalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValueArray* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* operator_sql_string = NULL;
	RygelLogicalExpression* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = expression;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
	left_sql_string = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = expression;
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
	_tmp6_ = args;
	_tmp7_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
	right_sql_string = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	operator_sql_string = "OR";
	_tmp8_ = expression;
	_tmp9_ = ((RygelSearchExpression*) _tmp8_)->op;
	if (((RygelLogicalOperator) ((gintptr) _tmp9_)) == RYGEL_LOGICAL_OPERATOR_AND) {
		operator_sql_string = "AND";
	}
	_tmp10_ = left_sql_string;
	_tmp11_ = operator_sql_string;
	_tmp12_ = right_sql_string;
	_tmp13_ = g_strdup_printf ("(%s %s %s)", _tmp10_, _tmp11_, _tmp12_);
	result = _tmp13_;
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	static GQuark _tmp2_label17 = 0;
	gboolean _tmp26_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("res")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = g_strdup ("o.uri");
				_g_free0 (column);
				column = _tmp4_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("res@duration")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup ("m.duration");
				_g_free0 (column);
				column = _tmp5_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@refID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_strdup ("o.reference_id");
				_g_free0 (column);
				column = _tmp6_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_ = NULL;
				_tmp7_ = g_strdup ("o.upnp_id");
				_g_free0 (column);
				column = _tmp7_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_ = NULL;
				_tmp8_ = g_strdup ("o.parent");
				_g_free0 (column);
				column = _tmp8_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_ = NULL;
				_tmp9_ = g_strdup ("m.class");
				_g_free0 (column);
				column = _tmp9_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_ = NULL;
				_tmp10_ = g_strdup ("o.title");
				_g_free0 (column);
				column = _tmp10_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:artist")))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("upnp:author"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_ = NULL;
				_tmp11_ = g_strdup ("m.author");
				_g_free0 (column);
				column = _tmp11_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				gchar* _tmp12_ = NULL;
				_tmp12_ = g_strdup ("m.creator");
				_g_free0 (column);
				column = _tmp12_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = for_sort;
				if (_tmp13_) {
					gchar* _tmp14_ = NULL;
					_tmp14_ = g_strdup ("m.date");
					_g_free0 (column);
					column = _tmp14_;
				} else {
					gchar* _tmp15_ = NULL;
					_tmp15_ = g_strdup ("strftime(\"%Y\", m.date)");
					_g_free0 (column);
					column = _tmp15_;
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_ = NULL;
				_tmp16_ = g_strdup ("m.album");
				_g_free0 (column);
				column = _tmp16_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("upnp:genre")))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("dc:genre"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_ = NULL;
				_tmp17_ = g_strdup ("m.genre");
				_g_free0 (column);
				column = _tmp17_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_ = NULL;
				_tmp18_ = g_strdup ("m.track");
				_g_free0 (column);
				column = _tmp18_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_ = NULL;
				_tmp19_ = g_strdup ("m.disc");
				_g_free0 (column);
				column = _tmp19_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp20_ = NULL;
				_tmp20_ = g_strdup ("o.object_update_id");
				_g_free0 (column);
				column = _tmp20_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label17) ? _tmp2_label17 : (_tmp2_label17 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp21_ = NULL;
				_tmp21_ = g_strdup ("o.container_update_id");
				_g_free0 (column);
				column = _tmp21_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* message = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				GError* _tmp25_ = NULL;
				_tmp22_ = operand;
				_tmp23_ = g_strdup_printf ("Unsupported column %s", _tmp22_);
				message = _tmp23_;
				_tmp24_ = message;
				_tmp25_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp24_);
				_inner_error_ = _tmp25_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	_tmp26_ = use_collation;
	if (_tmp26_) {
		gchar* _tmp27_ = NULL;
		_tmp27_ = g_strdup ("COLLATE CASEFOLD");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp27_;
	} else {
		gchar* _tmp28_ = NULL;
		_tmp28_ = g_strdup ("");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp28_;
	}
	result = column;
	if (collate) {
		*collate = _vala_collate;
	} else {
		_g_free0 (_vala_collate);
	}
	return result;
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelMediaExportSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValue* _tmp59_ = NULL;
	RygelMediaExportSqlOperator* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp0_ = exp;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	_tmp3_ = rygel_media_export_media_cache_map_operand_to_column ((const gchar*) _tmp1_, &_tmp2_, FALSE, &_inner_error_);
	_g_free0 (collate);
	collate = _tmp2_;
	column = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	_tmp4_ = exp;
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp6_ = exp;
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
				gchar* _tmp8_ = NULL;
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp8_;
			} else {
				gchar* _tmp9_ = NULL;
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp9_;
			}
			_tmp10_ = sql_function;
			_tmp11_ = column;
			_tmp12_ = column;
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
			result = _tmp13_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_ = NULL;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp22_ = FALSE;
			_tmp16_ = column;
			if (g_strcmp0 (_tmp16_, "m.class") == 0) {
				RygelRelationalExpression* _tmp17_ = NULL;
				gconstpointer _tmp18_ = NULL;
				_tmp17_ = exp;
				_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
				_tmp15_ = ((GUPnPSearchCriteriaOp) ((gintptr) _tmp18_)) == GUPNP_SEARCH_CRITERIA_OP_EQ;
			} else {
				_tmp15_ = FALSE;
			}
			_tmp19_ = _tmp15_;
			if (_tmp19_) {
				RygelRelationalExpression* _tmp20_ = NULL;
				gconstpointer _tmp21_ = NULL;
				_tmp20_ = exp;
				_tmp21_ = ((RygelSearchExpression*) _tmp20_)->operand2;
				_tmp14_ = g_strcmp0 ((const gchar*) _tmp21_, "object.container") == 0;
			} else {
				_tmp14_ = FALSE;
			}
			_tmp22_ = _tmp14_;
			if (_tmp22_) {
				RygelMediaExportSqlOperator* _tmp23_ = NULL;
				GValue* _tmp24_ = NULL;
				_tmp23_ = rygel_media_export_sql_operator_new ("=", "o.type_fk", "");
				_g_object_unref0 (operator);
				operator = _tmp23_;
				_tmp24_ = g_new0 (GValue, 1);
				g_value_init (_tmp24_, G_TYPE_INT);
				g_value_set_int (_tmp24_, (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER);
				__vala_GValue_free0 (v);
				v = _tmp24_;
			} else {
				RygelRelationalExpression* _tmp25_ = NULL;
				gconstpointer _tmp26_ = NULL;
				GValue* _tmp27_ = NULL;
				RygelRelationalExpression* _tmp28_ = NULL;
				gconstpointer _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				RygelMediaExportSqlOperator* _tmp32_ = NULL;
				_tmp25_ = exp;
				_tmp26_ = ((RygelSearchExpression*) _tmp25_)->operand2;
				_tmp27_ = g_new0 (GValue, 1);
				g_value_init (_tmp27_, G_TYPE_STRING);
				g_value_set_string (_tmp27_, (const gchar*) _tmp26_);
				__vala_GValue_free0 (v);
				v = _tmp27_;
				_tmp28_ = exp;
				_tmp29_ = ((RygelSearchExpression*) _tmp28_)->op;
				_tmp30_ = column;
				_tmp31_ = collate;
				_tmp32_ = rygel_media_export_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp29_), _tmp30_, _tmp31_);
				_g_object_unref0 (operator);
				operator = _tmp32_;
			}
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp33_ = NULL;
			RygelMediaExportSqlFunction* _tmp34_ = NULL;
			RygelRelationalExpression* _tmp35_ = NULL;
			gconstpointer _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
			_tmp33_ = column;
			_tmp34_ = rygel_media_export_sql_function_new ("contains", _tmp33_);
			_g_object_unref0 (operator);
			operator = (RygelMediaExportSqlOperator*) _tmp34_;
			_tmp35_ = exp;
			_tmp36_ = ((RygelSearchExpression*) _tmp35_)->operand2;
			_tmp37_ = g_new0 (GValue, 1);
			g_value_init (_tmp37_, G_TYPE_STRING);
			g_value_set_string (_tmp37_, (const gchar*) _tmp36_);
			__vala_GValue_free0 (v);
			v = _tmp37_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			const gchar* _tmp38_ = NULL;
			RygelMediaExportSqlFunction* _tmp39_ = NULL;
			RygelRelationalExpression* _tmp40_ = NULL;
			gconstpointer _tmp41_ = NULL;
			GValue* _tmp42_ = NULL;
			_tmp38_ = column;
			_tmp39_ = rygel_media_export_sql_function_new ("NOT contains", _tmp38_);
			_g_object_unref0 (operator);
			operator = (RygelMediaExportSqlOperator*) _tmp39_;
			_tmp40_ = exp;
			_tmp41_ = ((RygelSearchExpression*) _tmp40_)->operand2;
			_tmp42_ = g_new0 (GValue, 1);
			g_value_init (_tmp42_, G_TYPE_STRING);
			g_value_set_string (_tmp42_, (const gchar*) _tmp41_);
			__vala_GValue_free0 (v);
			v = _tmp42_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			gboolean _tmp43_ = FALSE;
			const gchar* _tmp44_ = NULL;
			gboolean _tmp48_ = FALSE;
			_tmp44_ = column;
			if (g_strcmp0 (_tmp44_, "m.class") == 0) {
				RygelRelationalExpression* _tmp45_ = NULL;
				gconstpointer _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				_tmp45_ = exp;
				_tmp46_ = ((RygelSearchExpression*) _tmp45_)->operand2;
				_tmp47_ = g_str_has_prefix ((const gchar*) _tmp46_, "object.container");
				_tmp43_ = _tmp47_;
			} else {
				_tmp43_ = FALSE;
			}
			_tmp48_ = _tmp43_;
			if (_tmp48_) {
				RygelMediaExportSqlOperator* _tmp49_ = NULL;
				GValue* _tmp50_ = NULL;
				_tmp49_ = rygel_media_export_sql_operator_new ("=", "o.type_fk", "");
				_g_object_unref0 (operator);
				operator = _tmp49_;
				_tmp50_ = g_new0 (GValue, 1);
				g_value_init (_tmp50_, G_TYPE_INT);
				g_value_set_int (_tmp50_, (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER);
				__vala_GValue_free0 (v);
				v = _tmp50_;
			} else {
				const gchar* _tmp51_ = NULL;
				RygelMediaExportSqlOperator* _tmp52_ = NULL;
				RygelRelationalExpression* _tmp53_ = NULL;
				gconstpointer _tmp54_ = NULL;
				gchar* _tmp55_ = NULL;
				GValue* _tmp56_ = NULL;
				_tmp51_ = column;
				_tmp52_ = rygel_media_export_sql_operator_new ("LIKE", _tmp51_, "");
				_g_object_unref0 (operator);
				operator = _tmp52_;
				_tmp53_ = exp;
				_tmp54_ = ((RygelSearchExpression*) _tmp53_)->operand2;
				_tmp55_ = g_strdup_printf ("%s%%", (const gchar*) _tmp54_);
				_tmp56_ = g_new0 (GValue, 1);
				g_value_init (_tmp56_, G_TYPE_STRING);
				g_value_take_string (_tmp56_, _tmp55_);
				__vala_GValue_free0 (v);
				v = _tmp56_;
			}
			break;
		}
		default:
		{
			RygelRelationalExpression* _tmp57_ = NULL;
			gconstpointer _tmp58_ = NULL;
			_tmp57_ = exp;
			_tmp58_ = ((RygelSearchExpression*) _tmp57_)->op;
			g_warning ("rygel-media-export-media-cache.vala:1101: Unsupported op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp58_)));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	_tmp59_ = v;
	if (_tmp59_ != NULL) {
		GValueArray* _tmp60_ = NULL;
		GValue* _tmp61_ = NULL;
		GValue _tmp62_ = {0};
		_tmp60_ = args;
		_tmp61_ = v;
		_tmp62_ = *_tmp61_;
		g_value_array_append (_tmp60_, &_tmp62_);
	}
	_tmp63_ = operator;
	_tmp64_ = rygel_media_export_sql_operator_to_string (_tmp63_);
	result = _tmp64_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}


static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
	RygelMediaExportDatabase* _tmp1_ = NULL;
	RygelMediaExportSQLFactory* _tmp2_ = NULL;
	RygelMediaExportSQLString _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->db;
	_tmp2_ = self->priv->sql;
	_tmp3_ = id;
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp2_, _tmp3_);
	_tmp5_ = values;
	_tmp5__length1 = values_length1;
	_tmp6_ = rygel_media_export_database_exec_cursor (_tmp1_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
	_tmp0_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp0_;
	return result;
}


static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	gint result = 0;
	gint _tmp0_ = 0;
	RygelMediaExportDatabase* _tmp1_ = NULL;
	RygelMediaExportSQLFactory* _tmp2_ = NULL;
	RygelMediaExportSQLString _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->db;
	_tmp2_ = self->priv->sql;
	_tmp3_ = id;
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp2_, _tmp3_);
	_tmp5_ = values;
	_tmp5__length1 = values_length1;
	_tmp6_ = rygel_media_export_database_query_value (_tmp1_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
	_tmp0_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria) {
	gchar* result = NULL;
	gchar* collate = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GString* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_string_new ("ORDER BY ");
	builder = _tmp0_;
	_tmp1_ = sort_criteria;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
	fields = _tmp3_;
	fields_length1 = _vala_array_length (_tmp2_);
	_fields_size_ = fields_length1;
	_tmp4_ = fields;
	_tmp4__length1 = fields_length1;
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp4_;
		field_collection_length1 = _tmp4__length1;
		for (field_it = 0; field_it < _tmp4__length1; field_it = field_it + 1) {
			const gchar* field = NULL;
			field = field_collection[field_it];
			{
				{
					gchar* column = NULL;
					const gchar* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gchar _tmp20_ = '\0';
					GString* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					_tmp5_ = field;
					_tmp6_ = field;
					_tmp7_ = strlen (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = string_slice (_tmp5_, (glong) 1, (glong) _tmp8_);
					_tmp10_ = _tmp9_;
					_tmp12_ = rygel_media_export_media_cache_map_operand_to_column (_tmp10_, &_tmp11_, TRUE, &_inner_error_);
					_g_free0 (collate);
					collate = _tmp11_;
					_tmp13_ = _tmp12_;
					_g_free0 (_tmp10_);
					column = _tmp13_;
					if (_inner_error_ != NULL) {
						goto __catch19_g_error;
					}
					_tmp14_ = field;
					_tmp15_ = fields;
					_tmp15__length1 = fields_length1;
					_tmp16_ = _tmp15_[0];
					if (g_strcmp0 (_tmp14_, _tmp16_) != 0) {
						GString* _tmp17_ = NULL;
						_tmp17_ = builder;
						g_string_append (_tmp17_, ",");
					}
					_tmp19_ = field;
					_tmp20_ = string_get (_tmp19_, (glong) 0);
					if (_tmp20_ == '-') {
						_tmp18_ = "DESC";
					} else {
						_tmp18_ = "ASC";
					}
					_tmp21_ = builder;
					_tmp22_ = column;
					_tmp23_ = collate;
					_tmp24_ = _tmp18_;
					g_string_append_printf (_tmp21_, "%s %s %s ", _tmp22_, _tmp23_, _tmp24_);
					_g_free0 (column);
				}
				goto __finally19;
				__catch19_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp25_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp25_ = field;
					g_warning ("rygel-media-export-media-cache.vala:1142: Skipping unsupported field: " \
"%s", _tmp25_);
					_g_error_free0 (_error_);
				}
				__finally19:
				if (_inner_error_ != NULL) {
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (builder);
					_g_free0 (collate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp26_ = builder;
	_tmp27_ = _tmp26_->str;
	_tmp28_ = g_strdup (_tmp27_);
	result = _tmp28_;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (builder);
	_g_free0 (collate);
	return result;
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->sql);
	_g_object_unref0 (self->priv->exists_cache);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


/**
 * Persistent storage of media objects.
 *
 * MediaExportDB is a sqlite3 backed persistent storage of media objects.
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



