/* rygel-media-export-item-factory.c generated by valac 0.20.1.64-fa28c, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <gst/gst.h>
#include <gst/tag/gsttagdemux.h>
#include <gst/tag/gsttagmux.h>
#include <gst/tag/tag.h>
#include <gst/tag/xmpwriter.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define __vala_GstSample_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstSample_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define __vala_GstStructure_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstStructure_free (var), NULL)))
#define __vala_GstDateTime_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstDateTime_free (var), NULL)))
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
static void _vala_GstSample_free (GstSample* self);
static GstStructure* _vala_GstStructure_copy (GstStructure* self);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);
static void _vala_GstStructure_free (GstStructure* self);
static void _vala_GstDateTime_free (GstDateTime* self);
static void _vala_SoupDate_free (SoupDate* self);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	gchar* title = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelMediaItem* item = NULL;
	gchar* mime = NULL;
	GFileInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	RygelMediaItem* _tmp41_ = NULL;
	GFileInfo* _tmp42_ = NULL;
	gint64 _tmp43_ = 0LL;
	RygelMediaItem* _tmp44_ = NULL;
	GFileInfo* _tmp45_ = NULL;
	guint64 _tmp46_ = 0ULL;
	RygelMediaItem* _tmp47_ = NULL;
	GFile* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportVideoItem* _tmp13_ = NULL;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelMediaExportPhotoItem* _tmp21_ = NULL;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp23_ = mime;
			_tmp24_ = g_str_has_prefix (_tmp23_, "audio/");
			if (_tmp24_) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp25_ = NULL;
				_tmp25_ = mime;
				_tmp22_ = g_strcmp0 (_tmp25_, "application/ogg") == 0;
			}
			_tmp26_ = _tmp22_;
			if (_tmp26_) {
				GFile* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				RygelMediaContainer* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				RygelMediaExportMusicItem* _tmp32_ = NULL;
				_tmp27_ = file;
				_tmp28_ = rygel_media_export_media_cache_get_id (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = parent;
				_tmp31_ = title;
				_tmp32_ = rygel_media_export_music_item_new (_tmp29_, _tmp30_, _tmp31_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp32_;
				_g_free0 (_tmp29_);
			} else {
				GFile* _tmp33_ = NULL;
				RygelMediaContainer* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				RygelMediaItem* _tmp36_ = NULL;
				RygelMediaItem* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				_tmp33_ = file;
				_tmp34_ = parent;
				_tmp35_ = title;
				_tmp36_ = rygel_media_export_item_factory_create_playlist_item (_tmp33_, _tmp34_, _tmp35_);
				_g_object_unref0 (item);
				item = _tmp36_;
				_tmp37_ = item;
				if (_tmp37_ == NULL) {
					result = NULL;
					_g_free0 (mime);
					_g_object_unref0 (item);
					_g_free0 (title);
					return result;
				}
				_tmp38_ = g_strdup ("text/xml");
				_g_free0 (mime);
				mime = _tmp38_;
			}
		}
	}
	_tmp39_ = item;
	_tmp40_ = mime;
	rygel_media_item_set_mime_type (_tmp39_, _tmp40_);
	_tmp41_ = item;
	_tmp42_ = info;
	_tmp43_ = g_file_info_get_size (_tmp42_);
	rygel_media_item_set_size (_tmp41_, (gint64) _tmp43_);
	_tmp44_ = item;
	_tmp45_ = info;
	_tmp46_ = g_file_info_get_attribute_uint64 (_tmp45_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp44_, _tmp46_);
	_tmp47_ = item;
	_tmp48_ = file;
	_tmp49_ = g_file_get_uri (_tmp48_);
	_tmp50_ = _tmp49_;
	rygel_media_item_add_uri (_tmp47_, _tmp50_);
	_g_free0 (_tmp50_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		guint8* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gint _tmp15_ = 0;
		guint8 _tmp16_ = 0U;
		GUPnPMediaCollection* didl_s = NULL;
		guint8* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		GUPnPMediaCollection* _tmp18_ = NULL;
		gchar* author = NULL;
		GUPnPMediaCollection* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* title = NULL;
		GUPnPMediaCollection* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_ = NULL;
		RygelMediaExportPlaylistItem* item = NULL;
		GFile* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		RygelMediaContainer* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportPlaylistItem* _tmp44_ = NULL;
		RygelMediaExportPlaylistItem* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		RygelMediaExportPlaylistItem* _tmp49_ = NULL;
		_tmp1_ = file;
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp2_;
		contents_length1 = _tmp3_;
		_contents_size_ = contents_length1;
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			contents = (g_free (contents), NULL);
			goto __catch66_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp7_ = 0;
			guint8 _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gint _tmp13_ = 0;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_ = 0;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp12_ = _tmp5_;
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
		}
		_tmp14_ = contents;
		_tmp14__length1 = contents_length1;
		_tmp15_ = i;
		_tmp16_ = _tmp14_[_tmp15_];
		if (_tmp16_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp17_ = contents;
		_tmp17__length1 = contents_length1;
		_tmp18_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp17_);
		didl_s = _tmp18_;
		_tmp19_ = didl_s;
		_tmp20_ = gupnp_media_collection_get_author (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup (_tmp21_);
		author = _tmp22_;
		_tmp23_ = didl_s;
		_tmp24_ = gupnp_media_collection_get_title (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup (_tmp25_);
		title = _tmp26_;
		_tmp29_ = author;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_ = NULL;
			_tmp30_ = title;
			_tmp28_ = _tmp30_ == NULL;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp31_ = _tmp28_;
		if (_tmp31_) {
			GUPnPMediaCollection* _tmp32_ = NULL;
			GList* _tmp33_ = NULL;
			GList* _tmp34_ = NULL;
			_tmp32_ = didl_s;
			_tmp33_ = gupnp_media_collection_get_items (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp27_ = _tmp34_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp34_);
		} else {
			_tmp27_ = FALSE;
		}
		_tmp35_ = _tmp27_;
		if (_tmp35_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp36_ = title;
		if (_tmp36_ == NULL) {
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			_tmp37_ = fallback_title;
			_tmp38_ = g_strdup (_tmp37_);
			_g_free0 (title);
			title = _tmp38_;
		}
		_tmp39_ = file;
		_tmp40_ = rygel_media_export_media_cache_get_id (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = parent;
		_tmp43_ = title;
		_tmp44_ = rygel_media_export_playlist_item_new (_tmp41_, _tmp42_, _tmp43_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp41_);
		item = _tmp45_;
		_tmp46_ = author;
		if (_tmp46_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			_tmp47_ = item;
			_tmp48_ = author;
			rygel_media_item_set_creator ((RygelMediaItem*) _tmp47_, _tmp48_);
		}
		_tmp49_ = item;
		rygel_media_item_set_dlna_profile ((RygelMediaItem*) _tmp49_, "DIDL_S");
		result = (RygelMediaItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally66:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	gchar* id = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GstDiscovererInfo* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GList* _tmp7_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GList* _tmp14_ = NULL;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = gst_discoverer_info_get_audio_streams (_tmp2_);
	__g_list_free__g_object_unref0_0 (audio_streams);
	audio_streams = (GList*) _tmp3_;
	_tmp4_ = info;
	_tmp5_ = gst_discoverer_info_get_video_streams (_tmp4_);
	__g_list_free__g_object_unref0_0 (video_streams);
	video_streams = (GList*) _tmp5_;
	_tmp7_ = audio_streams;
	if (_tmp7_ == NULL) {
		GList* _tmp8_ = NULL;
		_tmp8_ = video_streams;
		_tmp6_ = _tmp8_ == NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp10_ = file;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp12_);
		_g_free0 (_tmp12_);
		result = NULL;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp14_ = audio_streams;
	if (_tmp14_ == NULL) {
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp15_ = video_streams;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp16_);
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp18_ = _tmp13_;
	if (_tmp18_) {
		const gchar* _tmp19_ = NULL;
		RygelMediaContainer* _tmp20_ = NULL;
		RygelMediaExportPhotoItem* _tmp21_ = NULL;
		RygelMediaItem* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		GstDiscovererInfo* _tmp24_ = NULL;
		GUPnPDLNAProfile* _tmp25_ = NULL;
		GList* _tmp26_ = NULL;
		gconstpointer _tmp27_ = NULL;
		GFileInfo* _tmp28_ = NULL;
		RygelMediaItem* _tmp29_ = NULL;
		_tmp19_ = id;
		_tmp20_ = parent;
		_tmp21_ = rygel_media_export_photo_item_new (_tmp19_, _tmp20_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp21_;
		_tmp22_ = item;
		_tmp23_ = file;
		_tmp24_ = info;
		_tmp25_ = profile;
		_tmp26_ = video_streams;
		_tmp27_ = _tmp26_->data;
		_tmp28_ = file_info;
		_tmp29_ = rygel_media_export_item_factory_fill_photo_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM) ? ((RygelMediaExportPhotoItem*) _tmp22_) : NULL, _tmp23_, _tmp24_, _tmp25_, (GstDiscovererVideoInfo*) _tmp27_, _tmp28_);
		result = _tmp29_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp30_ = NULL;
		_tmp30_ = video_streams;
		if (_tmp30_ != NULL) {
			const gchar* _tmp31_ = NULL;
			RygelMediaContainer* _tmp32_ = NULL;
			RygelMediaExportVideoItem* _tmp33_ = NULL;
			GstDiscovererAudioInfo* audio_info = NULL;
			gpointer _tmp34_ = NULL;
			GstDiscovererAudioInfo* _tmp35_ = NULL;
			GList* _tmp36_ = NULL;
			RygelMediaItem* _tmp40_ = NULL;
			GFile* _tmp41_ = NULL;
			GstDiscovererInfo* _tmp42_ = NULL;
			GUPnPDLNAProfile* _tmp43_ = NULL;
			GList* _tmp44_ = NULL;
			gconstpointer _tmp45_ = NULL;
			GstDiscovererAudioInfo* _tmp46_ = NULL;
			GFileInfo* _tmp47_ = NULL;
			RygelMediaItem* _tmp48_ = NULL;
			_tmp31_ = id;
			_tmp32_ = parent;
			_tmp33_ = rygel_media_export_video_item_new (_tmp31_, _tmp32_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp33_;
			_tmp34_ = NULL;
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, gst_discoverer_audio_info_get_type ()) ? ((GstDiscovererAudioInfo*) _tmp34_) : NULL);
			audio_info = _tmp35_;
			_tmp36_ = audio_streams;
			if (_tmp36_ != NULL) {
				GList* _tmp37_ = NULL;
				gconstpointer _tmp38_ = NULL;
				GstDiscovererAudioInfo* _tmp39_ = NULL;
				_tmp37_ = audio_streams;
				_tmp38_ = _tmp37_->data;
				_tmp39_ = _g_object_ref0 ((GstDiscovererAudioInfo*) _tmp38_);
				_g_object_unref0 (audio_info);
				audio_info = _tmp39_;
			}
			_tmp40_ = item;
			_tmp41_ = file;
			_tmp42_ = info;
			_tmp43_ = profile;
			_tmp44_ = video_streams;
			_tmp45_ = _tmp44_->data;
			_tmp46_ = audio_info;
			_tmp47_ = file_info;
			_tmp48_ = rygel_media_export_item_factory_fill_video_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp40_) : NULL, _tmp41_, _tmp42_, _tmp43_, (GstDiscovererVideoInfo*) _tmp45_, _tmp46_, _tmp47_);
			result = _tmp48_;
			_g_object_unref0 (audio_info);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp49_ = NULL;
			_tmp49_ = audio_streams;
			if (_tmp49_ != NULL) {
				const gchar* _tmp50_ = NULL;
				RygelMediaContainer* _tmp51_ = NULL;
				RygelMediaExportMusicItem* _tmp52_ = NULL;
				RygelMediaItem* _tmp53_ = NULL;
				GFile* _tmp54_ = NULL;
				GstDiscovererInfo* _tmp55_ = NULL;
				GUPnPDLNAProfile* _tmp56_ = NULL;
				GList* _tmp57_ = NULL;
				gconstpointer _tmp58_ = NULL;
				GFileInfo* _tmp59_ = NULL;
				RygelMediaItem* _tmp60_ = NULL;
				_tmp50_ = id;
				_tmp51_ = parent;
				_tmp52_ = rygel_media_export_music_item_new (_tmp50_, _tmp51_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp52_;
				_tmp53_ = item;
				_tmp54_ = file;
				_tmp55_ = info;
				_tmp56_ = profile;
				_tmp57_ = audio_streams;
				_tmp58_ = _tmp57_->data;
				_tmp59_ = file_info;
				_tmp60_ = rygel_media_export_item_factory_fill_music_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp53_) : NULL, _tmp54_, _tmp55_, _tmp56_, (GstDiscovererAudioInfo*) _tmp58_, _tmp59_);
				result = _tmp60_;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__g_object_unref0_0 (video_streams);
	__g_list_free__g_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


static gpointer _gst_mini_object_ref0 (gpointer self) {
	return self ? gst_mini_object_ref (self) : NULL;
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info) {
	GstDiscovererInfo* _tmp0_ = NULL;
	GstClockTime _tmp1_ = 0ULL;
	GstDiscovererAudioInfo* _tmp6_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp7_ = NULL;
	GstTagList* _tmp8_ = NULL;
	GstTagList* _tmp9_ = NULL;
	GstTagList* _tmp10_ = NULL;
	RygelAudioItem* _tmp15_ = NULL;
	GstDiscovererAudioInfo* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	RygelAudioItem* _tmp18_ = NULL;
	GstDiscovererAudioInfo* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	g_return_if_fail (item != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp2_ = NULL;
		GstDiscovererInfo* _tmp3_ = NULL;
		GstClockTime _tmp4_ = 0ULL;
		_tmp2_ = item;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_duration (_tmp3_);
		rygel_audio_item_set_duration (_tmp2_, (glong) (_tmp4_ / GST_SECOND));
	} else {
		RygelAudioItem* _tmp5_ = NULL;
		_tmp5_ = item;
		rygel_audio_item_set_duration (_tmp5_, (glong) (-1));
	}
	_tmp6_ = audio_info;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = audio_info;
	_tmp8_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp7_);
	_tmp9_ = _gst_mini_object_ref0 (_tmp8_);
	tags = _tmp9_;
	_tmp10_ = tags;
	if (_tmp10_ != NULL) {
		guint tmp = 0U;
		GstTagList* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		RygelAudioItem* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		_tmp11_ = tags;
		gst_tag_list_get_uint (_tmp11_, GST_TAG_BITRATE, &_tmp12_);
		tmp = _tmp12_;
		_tmp13_ = item;
		_tmp14_ = tmp;
		rygel_audio_item_set_bitrate (_tmp13_, ((gint) _tmp14_) / 8);
	}
	_tmp15_ = item;
	_tmp16_ = audio_info;
	_tmp17_ = gst_discoverer_audio_info_get_channels (_tmp16_);
	rygel_audio_item_set_channels (_tmp15_, (gint) _tmp17_);
	_tmp18_ = item;
	_tmp19_ = audio_info;
	_tmp20_ = gst_discoverer_audio_info_get_sample_rate (_tmp19_);
	rygel_audio_item_set_sample_freq (_tmp18_, (gint) _tmp20_);
	_gst_mini_object_unref0 (tags);
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportVideoItem* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstDiscovererAudioInfo* _tmp2_ = NULL;
	RygelMediaExportVideoItem* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GstDiscovererInfo* _tmp5_ = NULL;
	GUPnPDLNAProfile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	RygelMediaExportVideoItem* _tmp8_ = NULL;
	GstDiscovererVideoInfo* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	RygelMediaExportVideoItem* _tmp11_ = NULL;
	GstDiscovererVideoInfo* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gint color_depth = 0;
	GstDiscovererVideoInfo* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	RygelMediaExportVideoItem* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	RygelMediaExportVideoItem* _tmp21_ = NULL;
	RygelMediaItem* _tmp22_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_width (_tmp9_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = item;
	_tmp12_ = video_info;
	_tmp13_ = gst_discoverer_video_info_get_height (_tmp12_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp11_, (gint) _tmp13_);
	_tmp14_ = video_info;
	_tmp15_ = gst_discoverer_video_info_get_depth (_tmp14_);
	color_depth = (gint) _tmp15_;
	_tmp17_ = color_depth;
	if (_tmp17_ == 0) {
		_tmp16_ = -1;
	} else {
		gint _tmp18_ = 0;
		_tmp18_ = color_depth;
		_tmp16_ = _tmp18_;
	}
	_tmp19_ = item;
	_tmp20_ = _tmp16_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp19_, _tmp20_);
	_tmp21_ = item;
	_tmp22_ = _g_object_ref0 ((RygelMediaItem*) _tmp21_);
	result = _tmp22_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportPhotoItem* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GUPnPDLNAProfile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	RygelMediaExportPhotoItem* _tmp5_ = NULL;
	GstDiscovererVideoInfo* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	RygelMediaExportPhotoItem* _tmp8_ = NULL;
	GstDiscovererVideoInfo* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gint color_depth = 0;
	GstDiscovererVideoInfo* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	RygelMediaExportPhotoItem* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	RygelMediaExportPhotoItem* _tmp18_ = NULL;
	RygelMediaItem* _tmp19_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = info;
	_tmp3_ = profile;
	_tmp4_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = item;
	_tmp6_ = video_info;
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp5_, (gint) _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_height (_tmp9_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_depth (_tmp11_);
	color_depth = (gint) _tmp12_;
	_tmp14_ = color_depth;
	if (_tmp14_ == 0) {
		_tmp13_ = -1;
	} else {
		gint _tmp15_ = 0;
		_tmp15_ = color_depth;
		_tmp13_ = _tmp15_;
	}
	_tmp16_ = item;
	_tmp17_ = _tmp13_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp16_, _tmp17_);
	_tmp18_ = item;
	_tmp19_ = _g_object_ref0 ((RygelMediaItem*) _tmp18_);
	result = _tmp19_;
	return result;
}


static void _vala_GstSample_free (GstSample* self) {
	g_boxed_free (gst_sample_get_type (), self);
}


static GstStructure* _vala_GstStructure_copy (GstStructure* self) {
	return g_boxed_copy (gst_structure_get_type (), self);
}


static gpointer __vala_GstStructure_copy0 (gpointer self) {
	return self ? _vala_GstStructure_copy (self) : NULL;
}


static void _vala_GstStructure_free (GstStructure* self) {
	g_boxed_free (gst_structure_get_type (), self);
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportMusicItem* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstDiscovererAudioInfo* _tmp2_ = NULL;
	RygelMediaExportMusicItem* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GstDiscovererInfo* _tmp5_ = NULL;
	GUPnPDLNAProfile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	GstDiscovererAudioInfo* _tmp8_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp11_ = NULL;
	GstTagList* _tmp12_ = NULL;
	GstTagList* _tmp13_ = NULL;
	GstTagList* _tmp14_ = NULL;
	gchar* artist = NULL;
	GstTagList* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	RygelMediaExportMusicItem* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* album = NULL;
	GstTagList* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	RygelMediaExportMusicItem* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* genre = NULL;
	GstTagList* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RygelMediaExportMusicItem* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	guint tmp = 0U;
	GstTagList* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	RygelMediaExportMusicItem* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	GstTagList* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	RygelMediaExportMusicItem* _tmp35_ = NULL;
	guint _tmp36_ = 0U;
	GstSample* sample = NULL;
	GstTagList* _tmp37_ = NULL;
	GstSample* _tmp38_ = NULL;
	GstSample* _tmp39_ = NULL;
	GstStructure* structure = NULL;
	GstSample* _tmp42_ = NULL;
	GstCaps* _tmp43_ = NULL;
	GstStructure* _tmp44_ = NULL;
	GstStructure* _tmp45_ = NULL;
	gint image_type = 0;
	GstStructure* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	RygelMediaExportMusicItem* _tmp58_ = NULL;
	RygelMediaItem* _tmp59_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = audio_info;
	if (_tmp8_ == NULL) {
		RygelMediaExportMusicItem* _tmp9_ = NULL;
		RygelMediaItem* _tmp10_ = NULL;
		_tmp9_ = item;
		_tmp10_ = _g_object_ref0 ((RygelMediaItem*) _tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = audio_info;
	_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
	_tmp13_ = _gst_mini_object_ref0 (_tmp12_);
	tags = _tmp13_;
	_tmp14_ = tags;
	if (_tmp14_ == NULL) {
		RygelMediaExportMusicItem* _tmp15_ = NULL;
		RygelMediaItem* _tmp16_ = NULL;
		_tmp15_ = item;
		_tmp16_ = _g_object_ref0 ((RygelMediaItem*) _tmp15_);
		result = _tmp16_;
		_gst_mini_object_unref0 (tags);
		return result;
	}
	_tmp17_ = tags;
	gst_tag_list_get_string (_tmp17_, GST_TAG_ARTIST, &_tmp18_);
	_g_free0 (artist);
	artist = _tmp18_;
	_tmp19_ = item;
	_tmp20_ = artist;
	rygel_music_item_set_artist ((RygelMusicItem*) _tmp19_, _tmp20_);
	_tmp21_ = tags;
	gst_tag_list_get_string (_tmp21_, GST_TAG_ALBUM, &_tmp22_);
	_g_free0 (album);
	album = _tmp22_;
	_tmp23_ = item;
	_tmp24_ = album;
	rygel_music_item_set_album ((RygelMusicItem*) _tmp23_, _tmp24_);
	_tmp25_ = tags;
	gst_tag_list_get_string (_tmp25_, GST_TAG_GENRE, &_tmp26_);
	_g_free0 (genre);
	genre = _tmp26_;
	_tmp27_ = item;
	_tmp28_ = genre;
	rygel_music_item_set_genre ((RygelMusicItem*) _tmp27_, _tmp28_);
	_tmp29_ = tags;
	gst_tag_list_get_uint (_tmp29_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp30_);
	tmp = _tmp30_;
	_tmp31_ = item;
	_tmp32_ = tmp;
	_tmp31_->disc = (gint) _tmp32_;
	_tmp33_ = tags;
	gst_tag_list_get_uint (_tmp33_, GST_TAG_TRACK_NUMBER, &_tmp34_);
	tmp = _tmp34_;
	_tmp35_ = item;
	_tmp36_ = tmp;
	rygel_music_item_set_track_number ((RygelMusicItem*) _tmp35_, (gint) _tmp36_);
	_tmp37_ = tags;
	gst_tag_list_get_sample (_tmp37_, GST_TAG_IMAGE, &_tmp38_);
	__vala_GstSample_free0 (sample);
	sample = _tmp38_;
	_tmp39_ = sample;
	if (_tmp39_ == NULL) {
		RygelMediaExportMusicItem* _tmp40_ = NULL;
		RygelMediaItem* _tmp41_ = NULL;
		_tmp40_ = item;
		_tmp41_ = _g_object_ref0 ((RygelMediaItem*) _tmp40_);
		result = _tmp41_;
		__vala_GstSample_free0 (sample);
		_g_free0 (genre);
		_g_free0 (album);
		_g_free0 (artist);
		_gst_mini_object_unref0 (tags);
		return result;
	}
	_tmp42_ = sample;
	_tmp43_ = gst_sample_get_caps (_tmp42_);
	_tmp44_ = gst_caps_get_structure (_tmp43_, (guint) 0);
	_tmp45_ = __vala_GstStructure_copy0 (_tmp44_);
	structure = _tmp45_;
	_tmp46_ = structure;
	gst_structure_get_enum (_tmp46_, "image-type", gst_tag_image_type_get_type (), &_tmp47_);
	image_type = _tmp47_;
	_tmp48_ = image_type;
	switch (_tmp48_) {
		case GST_TAG_IMAGE_TYPE_UNDEFINED:
		case GST_TAG_IMAGE_TYPE_FRONT_COVER:
		{
			RygelMediaArtStore* store = NULL;
			RygelMediaArtStore* _tmp49_ = NULL;
			GFile* thumb = NULL;
			RygelMediaArtStore* _tmp50_ = NULL;
			RygelMediaExportMusicItem* _tmp51_ = NULL;
			GFile* _tmp52_ = NULL;
			_tmp49_ = rygel_media_art_store_get_default ();
			store = _tmp49_;
			_tmp50_ = store;
			_tmp51_ = item;
			_tmp52_ = rygel_media_art_store_get_media_art_file (_tmp50_, "album", (RygelMusicItem*) _tmp51_, TRUE);
			thumb = _tmp52_;
			{
				RygelMediaExportJPEGWriter* writer = NULL;
				RygelMediaExportJPEGWriter* _tmp53_ = NULL;
				RygelMediaExportJPEGWriter* _tmp54_ = NULL;
				GstSample* _tmp55_ = NULL;
				GstBuffer* _tmp56_ = NULL;
				GFile* _tmp57_ = NULL;
				_tmp53_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
				writer = _tmp53_;
				if (_inner_error_ != NULL) {
					goto __catch67_g_error;
				}
				_tmp54_ = writer;
				_tmp55_ = sample;
				_tmp56_ = gst_sample_get_buffer (_tmp55_);
				_tmp57_ = thumb;
				rygel_media_export_jpeg_writer_write (_tmp54_, _tmp56_, _tmp57_);
				_g_object_unref0 (writer);
			}
			goto __finally67;
			__catch67_g_error:
			{
				GError* _error_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (_error_);
			}
			__finally67:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (thumb);
				_g_object_unref0 (store);
				__vala_GstStructure_free0 (structure);
				__vala_GstSample_free0 (sample);
				_g_free0 (genre);
				_g_free0 (album);
				_g_free0 (artist);
				_gst_mini_object_unref0 (tags);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (thumb);
			_g_object_unref0 (store);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp58_ = item;
	_tmp59_ = _g_object_ref0 ((RygelMediaItem*) _tmp58_);
	result = _tmp59_;
	__vala_GstStructure_free0 (structure);
	__vala_GstSample_free0 (sample);
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	_gst_mini_object_unref0 (tags);
	return result;
}


static void _vala_GstDateTime_free (GstDateTime* self) {
	g_boxed_free (gst_date_time_get_type (), self);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	gchar* title = NULL;
	GstTagList* tags = NULL;
	GstDiscovererInfo* _tmp0_ = NULL;
	GstTagList* _tmp1_ = NULL;
	GstTagList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GstTagList* _tmp4_ = NULL;
	gboolean _tmp8_ = FALSE;
	GstDateTime* dt = NULL;
	gboolean _tmp12_ = FALSE;
	GstTagList* _tmp13_ = NULL;
	gboolean _tmp17_ = FALSE;
	RygelMediaItem* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	guint64 mtime = 0ULL;
	GFileInfo* _tmp47_ = NULL;
	guint64 _tmp48_ = 0ULL;
	RygelMediaItem* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	RygelMediaItem* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	RygelMediaItem* _tmp69_ = NULL;
	GFileInfo* _tmp70_ = NULL;
	gint64 _tmp71_ = 0LL;
	RygelMediaItem* _tmp72_ = NULL;
	guint64 _tmp73_ = 0ULL;
	gboolean _tmp74_ = FALSE;
	GUPnPDLNAProfile* _tmp75_ = NULL;
	gboolean _tmp79_ = FALSE;
	RygelMediaItem* _tmp93_ = NULL;
	GFile* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (file_info != NULL);
	title = NULL;
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_tags (_tmp0_);
	_tmp2_ = _gst_mini_object_ref0 (_tmp1_);
	tags = _tmp2_;
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GstTagList* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = tags;
		_tmp7_ = gst_tag_list_get_string (_tmp5_, GST_TAG_TITLE, &_tmp6_);
		_g_free0 (title);
		title = _tmp6_;
		_tmp3_ = !_tmp7_;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		GFileInfo* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = file_info;
		_tmp10_ = g_file_info_get_display_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (title);
		title = _tmp11_;
	}
	dt = NULL;
	_tmp13_ = tags;
	if (_tmp13_ != NULL) {
		GstTagList* _tmp14_ = NULL;
		GstDateTime* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = tags;
		_tmp16_ = gst_tag_list_get_date_time (_tmp14_, GST_TAG_DATE_TIME, &_tmp15_);
		__vala_GstDateTime_free0 (dt);
		dt = _tmp15_;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp17_ = _tmp12_;
	if (_tmp17_) {
		gboolean _tmp18_ = FALSE;
		GstDateTime* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp19_ = dt;
		_tmp20_ = gst_date_time_has_day (_tmp19_);
		if (!_tmp20_) {
			_tmp18_ = TRUE;
		} else {
			GstDateTime* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = dt;
			_tmp22_ = gst_date_time_has_month (_tmp21_);
			_tmp18_ = !_tmp22_;
		}
		_tmp23_ = _tmp18_;
		if (_tmp23_) {
			gint _tmp24_ = 0;
			GstDateTime* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gint _tmp29_ = 0;
			GstDateTime* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
			RygelMediaItem* _tmp34_ = NULL;
			GstDateTime* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			_tmp25_ = dt;
			_tmp26_ = gst_date_time_has_month (_tmp25_);
			if (_tmp26_) {
				GstDateTime* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				_tmp27_ = dt;
				_tmp28_ = gst_date_time_get_month (_tmp27_);
				_tmp24_ = _tmp28_;
			} else {
				_tmp24_ = 1;
			}
			_tmp30_ = dt;
			_tmp31_ = gst_date_time_has_day (_tmp30_);
			if (_tmp31_) {
				GstDateTime* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				_tmp32_ = dt;
				_tmp33_ = gst_date_time_get_day (_tmp32_);
				_tmp29_ = _tmp33_;
			} else {
				_tmp29_ = 1;
			}
			_tmp34_ = item;
			_tmp35_ = dt;
			_tmp36_ = gst_date_time_get_year (_tmp35_);
			_tmp37_ = _tmp24_;
			_tmp38_ = _tmp29_;
			_tmp39_ = g_strdup_printf ("%d-%02d-%02d", _tmp36_, _tmp37_, _tmp38_);
			_tmp40_ = _tmp39_;
			rygel_media_item_set_date (_tmp34_, _tmp40_);
			_g_free0 (_tmp40_);
		} else {
			RygelMediaItem* _tmp41_ = NULL;
			GstDateTime* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			_tmp41_ = item;
			_tmp42_ = dt;
			_tmp43_ = gst_date_time_to_iso8601_string (_tmp42_);
			_tmp44_ = _tmp43_;
			rygel_media_item_set_date (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		}
	}
	_tmp45_ = item;
	_tmp46_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp45_, _tmp46_);
	_tmp47_ = file_info;
	_tmp48_ = g_file_info_get_attribute_uint64 (_tmp47_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp48_;
	_tmp49_ = item;
	_tmp50_ = rygel_media_item_get_date (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ == NULL) {
		GTimeVal tv = {0};
		guint64 _tmp52_ = 0ULL;
		GTimeVal _tmp53_ = {0};
		RygelMediaItem* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		_tmp52_ = mtime;
		_tmp53_.tv_sec = (glong) _tmp52_;
		_tmp53_.tv_usec = (glong) 0;
		tv = _tmp53_;
		_tmp54_ = item;
		_tmp55_ = g_time_val_to_iso8601 (&tv);
		_tmp56_ = _tmp55_;
		rygel_media_item_set_date (_tmp54_, _tmp56_);
		_g_free0 (_tmp56_);
	}
	_tmp57_ = item;
	_tmp58_ = rygel_media_item_get_date (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = string_contains (_tmp59_, "T");
	if (_tmp60_) {
		SoupDate* date = NULL;
		RygelMediaItem* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		SoupDate* _tmp64_ = NULL;
		RygelMediaItem* _tmp65_ = NULL;
		SoupDate* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		_tmp61_ = item;
		_tmp62_ = rygel_media_item_get_date (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = soup_date_new_from_string (_tmp63_);
		date = _tmp64_;
		_tmp65_ = item;
		_tmp66_ = date;
		_tmp67_ = soup_date_to_string (_tmp66_, SOUP_DATE_ISO8601_FULL);
		_tmp68_ = _tmp67_;
		rygel_media_item_set_date (_tmp65_, _tmp68_);
		_g_free0 (_tmp68_);
		__vala_SoupDate_free0 (date);
	}
	_tmp69_ = item;
	_tmp70_ = file_info;
	_tmp71_ = g_file_info_get_size (_tmp70_);
	rygel_media_item_set_size (_tmp69_, (gint64) _tmp71_);
	_tmp72_ = item;
	_tmp73_ = mtime;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp72_, (guint64) ((gint64) _tmp73_));
	_tmp75_ = profile;
	if (_tmp75_ != NULL) {
		GUPnPDLNAProfile* _tmp76_ = NULL;
		const gchar* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		_tmp76_ = profile;
		_tmp77_ = gupnp_dlna_profile_get_name (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp74_ = _tmp78_ != NULL;
	} else {
		_tmp74_ = FALSE;
	}
	_tmp79_ = _tmp74_;
	if (_tmp79_) {
		RygelMediaItem* _tmp80_ = NULL;
		GUPnPDLNAProfile* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		RygelMediaItem* _tmp84_ = NULL;
		GUPnPDLNAProfile* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		_tmp80_ = item;
		_tmp81_ = profile;
		_tmp82_ = gupnp_dlna_profile_get_name (_tmp81_);
		_tmp83_ = _tmp82_;
		rygel_media_item_set_dlna_profile (_tmp80_, _tmp83_);
		_tmp84_ = item;
		_tmp85_ = profile;
		_tmp86_ = gupnp_dlna_profile_get_mime (_tmp85_);
		_tmp87_ = _tmp86_;
		rygel_media_item_set_mime_type (_tmp84_, _tmp87_);
	} else {
		RygelMediaItem* _tmp88_ = NULL;
		GFileInfo* _tmp89_ = NULL;
		const gchar* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_ = NULL;
		_tmp88_ = item;
		_tmp89_ = file_info;
		_tmp90_ = g_file_info_get_content_type (_tmp89_);
		_tmp91_ = g_content_type_get_mime_type (_tmp90_);
		_tmp92_ = _tmp91_;
		rygel_media_item_set_mime_type (_tmp88_, _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp93_ = item;
	_tmp94_ = file;
	_tmp95_ = g_file_get_uri (_tmp94_);
	_tmp96_ = _tmp95_;
	rygel_media_item_add_uri (_tmp93_, _tmp96_);
	_g_free0 (_tmp96_);
	__vala_GstDateTime_free0 (dt);
	_gst_mini_object_unref0 (tags);
	_g_free0 (title);
}



