/* game-view.c generated by valac 0.20.0, the Vala compiler
 * generated from game-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PLAYER (player_get_type ())

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	Game* _game;
	gchar* _theme;
	gboolean _show_grid;
	gboolean _flip_final_result;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME,
	GAME_VIEW_SHOW_GRID,
	GAME_VIEW_FLIP_FINAL_RESULT
};
#define GAME_VIEW_GRID_WIDTH 1
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
Game* game_view_get_game (GameView* self);
static gint game_view_get_tile_size (GameView* self);
static GdkPixbuf* game_view_load_theme (GameView* self);
static gint game_view_get_x_offset (GameView* self);
static gint game_view_get_y_offset (GameView* self);
gboolean game_view_get_show_grid (GameView* self);
static gint game_view_get_board_size (GameView* self);
const gchar* game_view_get_theme (GameView* self);
void game_view_redraw (GameView* self);
static void game_view_square_changed_cb (GameView* self, gint x, gint y);
GType player_get_type (void) G_GNUC_CONST;
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_get_is_complete (Game* self);
gboolean game_view_get_flip_final_result (GameView* self);
gint game_get_width (Game* self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
gint game_get_height (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	gint* _tmp0_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
	_tmp0_ = g_new0 (gint, 8 * 8);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	self->priv->pixmaps = _tmp0_;
	self->priv->pixmaps_length1 = 8;
	self->priv->pixmaps_length2 = 8;
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	self = (GameView*) base;
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	self = (GameView*) base;
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	self = (GameView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		guint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->render_size;
		_tmp5_ = game_view_get_tile_size (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ != ((guint) _tmp6_);
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		cairo_t* _tmp10_;
		cairo_surface_t* _tmp11_ = NULL;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		cairo_surface_t* _tmp16_;
		cairo_surface_t* surface;
		cairo_surface_t* _tmp17_;
		cairo_t* _tmp18_;
		cairo_t* c;
		GdkPixbuf* _tmp19_ = NULL;
		GdkPixbuf* pixbuf;
		cairo_t* _tmp20_;
		GdkPixbuf* _tmp21_;
		cairo_t* _tmp22_;
		cairo_surface_t* _tmp23_;
		cairo_pattern_t* _tmp24_;
		_tmp8_ = game_view_get_tile_size (self);
		_tmp9_ = _tmp8_;
		self->priv->render_size = (guint) _tmp9_;
		_tmp10_ = cr;
		_tmp11_ = cairo_get_target (_tmp10_);
		_tmp12_ = game_view_get_tile_size (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = game_view_get_tile_size (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = cairo_surface_create_similar (_tmp11_, CAIRO_CONTENT_COLOR_ALPHA, _tmp13_ * 8, _tmp15_ * 4);
		surface = _tmp16_;
		_tmp17_ = surface;
		_tmp18_ = cairo_create (_tmp17_);
		c = _tmp18_;
		_tmp19_ = game_view_load_theme (self);
		pixbuf = _tmp19_;
		_tmp20_ = c;
		_tmp21_ = pixbuf;
		gdk_cairo_set_source_pixbuf (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
		_tmp22_ = c;
		cairo_paint (_tmp22_);
		_tmp23_ = surface;
		_tmp24_ = cairo_pattern_create_for_surface (_tmp23_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp24_;
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	{
		gint x;
		x = 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_;
				gint _tmp28_;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = x;
					x = _tmp27_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp28_ = x;
				if (!(_tmp28_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp29_;
						_tmp29_ = TRUE;
						while (TRUE) {
							gboolean _tmp30_;
							gint _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							gint tile_x;
							gint _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							gint tile_y;
							gint* _tmp43_;
							gint _tmp43__length1;
							gint _tmp43__length2;
							gint _tmp44_;
							gint _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							gint texture_x;
							gint* _tmp49_;
							gint _tmp49__length1;
							gint _tmp49__length2;
							gint _tmp50_;
							gint _tmp51_;
							gint _tmp52_;
							gint _tmp53_;
							gint _tmp54_;
							gint texture_y;
							cairo_matrix_t matrix = {0};
							gint _tmp55_;
							gint _tmp56_;
							gint _tmp57_;
							gint _tmp58_;
							cairo_pattern_t* _tmp59_;
							cairo_matrix_t _tmp60_;
							cairo_t* _tmp61_;
							cairo_pattern_t* _tmp62_;
							cairo_t* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							gint _tmp66_;
							gint _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
							cairo_t* _tmp70_;
							_tmp30_ = _tmp29_;
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = y;
								y = _tmp31_ + 1;
							}
							_tmp29_ = FALSE;
							_tmp32_ = y;
							if (!(_tmp32_ < 8)) {
								break;
							}
							_tmp33_ = game_view_get_x_offset (self);
							_tmp34_ = _tmp33_;
							_tmp35_ = x;
							_tmp36_ = game_view_get_tile_size (self);
							_tmp37_ = _tmp36_;
							tile_x = _tmp34_ + (_tmp35_ * (_tmp37_ + GAME_VIEW_GRID_WIDTH));
							_tmp38_ = game_view_get_y_offset (self);
							_tmp39_ = _tmp38_;
							_tmp40_ = y;
							_tmp41_ = game_view_get_tile_size (self);
							_tmp42_ = _tmp41_;
							tile_y = _tmp39_ + (_tmp40_ * (_tmp42_ + GAME_VIEW_GRID_WIDTH));
							_tmp43_ = self->priv->pixmaps;
							_tmp43__length1 = self->priv->pixmaps_length1;
							_tmp43__length2 = self->priv->pixmaps_length2;
							_tmp44_ = x;
							_tmp45_ = y;
							_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
							_tmp47_ = game_view_get_tile_size (self);
							_tmp48_ = _tmp47_;
							texture_x = (_tmp46_ % 8) * _tmp48_;
							_tmp49_ = self->priv->pixmaps;
							_tmp49__length1 = self->priv->pixmaps_length1;
							_tmp49__length2 = self->priv->pixmaps_length2;
							_tmp50_ = x;
							_tmp51_ = y;
							_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
							_tmp53_ = game_view_get_tile_size (self);
							_tmp54_ = _tmp53_;
							texture_y = (_tmp52_ / 8) * _tmp54_;
							cairo_matrix_init_identity (&matrix);
							_tmp55_ = texture_x;
							_tmp56_ = tile_x;
							_tmp57_ = texture_y;
							_tmp58_ = tile_y;
							cairo_matrix_translate (&matrix, (gdouble) (_tmp55_ - _tmp56_), (gdouble) (_tmp57_ - _tmp58_));
							_tmp59_ = self->priv->tiles_pattern;
							_tmp60_ = matrix;
							cairo_pattern_set_matrix (_tmp59_, &_tmp60_);
							_tmp61_ = cr;
							_tmp62_ = self->priv->tiles_pattern;
							cairo_set_source (_tmp61_, _tmp62_);
							_tmp63_ = cr;
							_tmp64_ = tile_x;
							_tmp65_ = tile_y;
							_tmp66_ = game_view_get_tile_size (self);
							_tmp67_ = _tmp66_;
							_tmp68_ = game_view_get_tile_size (self);
							_tmp69_ = _tmp68_;
							cairo_rectangle (_tmp63_, (gdouble) _tmp64_, (gdouble) _tmp65_, (gdouble) _tmp67_, (gdouble) _tmp69_);
							_tmp70_ = cr;
							cairo_fill (_tmp70_);
						}
					}
				}
			}
		}
	}
	_tmp71_ = game_view_get_show_grid (self);
	_tmp72_ = _tmp71_;
	if (_tmp72_) {
		gint _tmp73_;
		gint _tmp74_;
		gint dash_count;
		gint _tmp75_;
		gdouble dash[1] = {0};
		gint _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gdouble _tmp80_;
		cairo_t* _tmp81_;
		cairo_t* _tmp82_;
		cairo_t* _tmp83_;
		cairo_t* _tmp84_;
		cairo_t* _tmp111_;
		_tmp73_ = game_view_get_tile_size (self);
		_tmp74_ = _tmp73_;
		dash_count = (_tmp74_ + GAME_VIEW_GRID_WIDTH) / 4;
		_tmp75_ = dash_count;
		if ((_tmp75_ % 2) != 0) {
			gint _tmp76_;
			_tmp76_ = dash_count;
			dash_count = _tmp76_ - 1;
		}
		_tmp77_ = game_view_get_tile_size (self);
		_tmp78_ = _tmp77_;
		_tmp79_ = dash_count;
		dash[0] = ((gdouble) (_tmp78_ + GAME_VIEW_GRID_WIDTH)) / _tmp79_;
		_tmp80_ = dash[0];
		_tmp81_ = cr;
		cairo_set_dash (_tmp81_, dash, 1, 2.5);
		_tmp82_ = cr;
		cairo_set_source_rgb (_tmp82_, 1.0, 1.0, 1.0);
		_tmp83_ = cr;
		cairo_set_operator (_tmp83_, CAIRO_OPERATOR_DIFFERENCE);
		_tmp84_ = cr;
		cairo_set_line_width (_tmp84_, (gdouble) GAME_VIEW_GRID_WIDTH);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp85_;
				_tmp85_ = TRUE;
				while (TRUE) {
					gboolean _tmp86_;
					gint _tmp88_;
					cairo_t* _tmp89_;
					gint _tmp90_;
					gint _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					gint _tmp94_;
					gint _tmp95_;
					gint _tmp96_;
					cairo_t* _tmp97_;
					gint _tmp98_;
					gint _tmp99_;
					cairo_t* _tmp100_;
					gint _tmp101_;
					gint _tmp102_;
					gint _tmp103_;
					gint _tmp104_;
					gint _tmp105_;
					gint _tmp106_;
					gint _tmp107_;
					cairo_t* _tmp108_;
					gint _tmp109_;
					gint _tmp110_;
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						gint _tmp87_;
						_tmp87_ = i;
						i = _tmp87_ + 1;
					}
					_tmp85_ = FALSE;
					_tmp88_ = i;
					if (!(_tmp88_ < 8)) {
						break;
					}
					_tmp89_ = cr;
					_tmp90_ = game_view_get_x_offset (self);
					_tmp91_ = _tmp90_;
					_tmp92_ = i;
					_tmp93_ = game_view_get_board_size (self);
					_tmp94_ = _tmp93_;
					_tmp95_ = game_view_get_y_offset (self);
					_tmp96_ = _tmp95_;
					cairo_move_to (_tmp89_, (_tmp91_ + ((_tmp92_ * _tmp94_) / 8)) - 0.5, (gdouble) _tmp96_);
					_tmp97_ = cr;
					_tmp98_ = game_view_get_board_size (self);
					_tmp99_ = _tmp98_;
					cairo_rel_line_to (_tmp97_, (gdouble) 0, (gdouble) _tmp99_);
					_tmp100_ = cr;
					_tmp101_ = game_view_get_x_offset (self);
					_tmp102_ = _tmp101_;
					_tmp103_ = game_view_get_y_offset (self);
					_tmp104_ = _tmp103_;
					_tmp105_ = i;
					_tmp106_ = game_view_get_board_size (self);
					_tmp107_ = _tmp106_;
					cairo_move_to (_tmp100_, (gdouble) _tmp102_, (_tmp104_ + ((_tmp105_ * _tmp107_) / 8)) - 0.5);
					_tmp108_ = cr;
					_tmp109_ = game_view_get_board_size (self);
					_tmp110_ = _tmp109_;
					cairo_rel_line_to (_tmp108_, (gdouble) _tmp110_, (gdouble) 0);
				}
			}
		}
		_tmp111_ = cr;
		cairo_stroke (_tmp111_);
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* game_view_load_theme (GameView* self) {
	GdkPixbuf* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint width;
	gint _tmp2_;
	gint _tmp3_;
	gint height;
	gint _tmp17_;
	gint _tmp18_;
	GdkPixbuf* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	width = _tmp1_ * 8;
	_tmp2_ = game_view_get_tile_size (self);
	_tmp3_ = _tmp2_;
	height = _tmp3_ * 4;
	{
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp4_ = game_view_get_theme (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = width;
		_tmp7_ = height;
		_tmp8_ = rsvg_pixbuf_from_file_at_size (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp10_ = _g_object_ref0 (_tmp9_);
		result = _tmp10_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		_tmp11_ = game_view_get_theme (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = width;
		_tmp14_ = height;
		_tmp15_ = gdk_pixbuf_new_from_file_at_scale (_tmp12_, _tmp13_, _tmp14_, FALSE, &_inner_error_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		result = _tmp16_;
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp17_ = width;
	_tmp18_ = height;
	_tmp19_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, _tmp17_, _tmp18_);
	result = _tmp19_;
	return result;
}


void game_view_redraw (GameView* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y) {
	Game* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Player _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint pixmap;
	gboolean _tmp6_ = FALSE;
	Game* _tmp7_;
	Game* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = game_get_owner (_tmp1_, _tmp2_, _tmp3_);
	_tmp5_ = game_view_get_pixmap (self, _tmp4_);
	pixmap = _tmp5_;
	_tmp7_ = game_view_get_game (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = game_get_is_complete (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = game_view_get_flip_final_result (self);
		_tmp12_ = _tmp11_;
		_tmp6_ = _tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp13_ = _tmp6_;
	if (_tmp13_) {
		gint _tmp14_;
		Game* _tmp15_;
		Game* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint n;
		Player winning_color;
		Player losing_color;
		Game* _tmp20_;
		Game* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint n_winning_tiles;
		Game* _tmp24_;
		Game* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint n_losing_tiles;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp14_ = y;
		_tmp15_ = game_view_get_game (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = game_get_width (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = x;
		n = (_tmp14_ * _tmp18_) + _tmp19_;
		winning_color = PLAYER_LIGHT;
		losing_color = PLAYER_DARK;
		_tmp20_ = game_view_get_game (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = game_get_n_light_tiles (_tmp21_);
		_tmp23_ = _tmp22_;
		n_winning_tiles = _tmp23_;
		_tmp24_ = game_view_get_game (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_get_n_dark_tiles (_tmp25_);
		_tmp27_ = _tmp26_;
		n_losing_tiles = _tmp27_;
		_tmp28_ = n_losing_tiles;
		_tmp29_ = n_winning_tiles;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			gint t;
			gint _tmp31_;
			gint _tmp32_;
			winning_color = PLAYER_DARK;
			losing_color = PLAYER_LIGHT;
			_tmp30_ = n_winning_tiles;
			t = _tmp30_;
			_tmp31_ = n_losing_tiles;
			n_winning_tiles = _tmp31_;
			_tmp32_ = t;
			n_losing_tiles = _tmp32_;
		}
		_tmp33_ = n;
		_tmp34_ = n_winning_tiles;
		if (_tmp33_ < _tmp34_) {
			Player _tmp35_;
			gint _tmp36_ = 0;
			_tmp35_ = winning_color;
			_tmp36_ = game_view_get_pixmap (self, _tmp35_);
			pixmap = _tmp36_;
		} else {
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_tmp37_ = n;
			_tmp38_ = n_winning_tiles;
			_tmp39_ = n_losing_tiles;
			if (_tmp37_ < (_tmp38_ + _tmp39_)) {
				Player _tmp40_;
				gint _tmp41_ = 0;
				_tmp40_ = losing_color;
				_tmp41_ = game_view_get_pixmap (self, _tmp40_);
				pixmap = _tmp41_;
			} else {
				gint _tmp42_ = 0;
				_tmp42_ = game_view_get_pixmap (self, PLAYER_NONE);
				pixmap = _tmp42_;
			}
		}
	}
	_tmp43_ = x;
	_tmp44_ = y;
	_tmp45_ = pixmap;
	game_view_set_square (self, _tmp43_, _tmp44_, _tmp45_);
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb (self);
	return result;
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp11_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pixmaps;
	_tmp0__length1 = self->priv->pixmaps_length1;
	_tmp0__length2 = self->priv->pixmaps_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = pixmap;
	if (_tmp3_ == _tmp4_) {
		return;
	}
	_tmp6_ = pixmap;
	if (_tmp6_ == 0) {
		_tmp5_ = TRUE;
	} else {
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->pixmaps;
		_tmp7__length1 = self->priv->pixmaps_length1;
		_tmp7__length2 = self->priv->pixmaps_length2;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp5_ = _tmp10_ == 0;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		gint* _tmp12_;
		gint _tmp12__length1;
		gint _tmp12__length2;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp12_ = self->priv->pixmaps;
		_tmp12__length1 = self->priv->pixmaps_length1;
		_tmp12__length2 = self->priv->pixmaps_length2;
		_tmp13_ = x;
		_tmp14_ = y;
		_tmp15_ = pixmap;
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = _tmp15_;
		_tmp16_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
	} else {
		gint _tmp17_;
		gint* _tmp18_;
		gint _tmp18__length1;
		gint _tmp18__length2;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		guint _tmp30_;
		_tmp17_ = pixmap;
		_tmp18_ = self->priv->pixmaps;
		_tmp18__length1 = self->priv->pixmaps_length1;
		_tmp18__length2 = self->priv->pixmaps_length2;
		_tmp19_ = x;
		_tmp20_ = y;
		_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
		if (_tmp17_ > _tmp21_) {
			gint* _tmp22_;
			gint _tmp22__length1;
			gint _tmp22__length2;
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp22_ = self->priv->pixmaps;
			_tmp22__length1 = self->priv->pixmaps_length1;
			_tmp22__length2 = self->priv->pixmaps_length2;
			_tmp23_ = x;
			_tmp24_ = y;
			_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
			_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = _tmp25_ + 1;
		} else {
			gint* _tmp26_;
			gint _tmp26__length1;
			gint _tmp26__length2;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			_tmp26_ = self->priv->pixmaps;
			_tmp26__length1 = self->priv->pixmaps_length1;
			_tmp26__length2 = self->priv->pixmaps_length2;
			_tmp27_ = x;
			_tmp28_ = y;
			_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
			_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = _tmp29_ - 1;
		}
		_tmp30_ = self->priv->animate_timeout;
		if (_tmp30_ == ((guint) 0)) {
			guint _tmp31_ = 0U;
			_tmp31_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->animate_timeout = _tmp31_;
		}
	}
	_tmp32_ = game_view_get_x_offset (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = x;
	_tmp35_ = game_view_get_tile_size (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = game_view_get_y_offset (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = y;
	_tmp40_ = game_view_get_tile_size (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = game_view_get_tile_size (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = game_view_get_tile_size (self);
	_tmp45_ = _tmp44_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp33_ + (_tmp34_ * ((gint) (_tmp36_ + GAME_VIEW_GRID_WIDTH))), _tmp38_ + (_tmp39_ * ((gint) (_tmp41_ + GAME_VIEW_GRID_WIDTH))), _tmp43_, _tmp45_);
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating;
	gboolean _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	animating = FALSE;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							gint* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint old;
							gint _tmp12_;
							gint _tmp13_;
							gint* _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = self->priv->pixmaps;
							_tmp8__length1 = self->priv->pixmaps_length1;
							_tmp8__length2 = self->priv->pixmaps_length2;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							old = _tmp11_;
							_tmp12_ = x;
							_tmp13_ = y;
							game_view_square_changed_cb (self, _tmp12_, _tmp13_);
							_tmp14_ = self->priv->pixmaps;
							_tmp14__length1 = self->priv->pixmaps_length1;
							_tmp14__length2 = self->priv->pixmaps_length2;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							_tmp18_ = old;
							if (_tmp17_ != _tmp18_) {
								animating = TRUE;
							}
						}
					}
				}
			}
		}
	}
	_tmp19_ = animating;
	if (!_tmp19_) {
		self->priv->animate_timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = color;
	switch (_tmp0_) {
		default:
		case PLAYER_NONE:
		{
			result = 0;
			return result;
		}
		case PLAYER_DARK:
		{
			result = 1;
			return result;
		}
		case PLAYER_LIGHT:
		{
			result = 31;
			return result;
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	guint _tmp1_;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 1)) {
		GdkEventButton _tmp2_;
		gdouble _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint x;
		GdkEventButton _tmp8_;
		gdouble _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint y;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_;
		gboolean _tmp19_;
		gboolean _tmp21_;
		gboolean _tmp23_;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.x;
		_tmp4_ = game_view_get_x_offset (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_view_get_tile_size (self);
		_tmp7_ = _tmp6_;
		x = ((gint) (_tmp3_ - _tmp5_)) / (_tmp7_ + GAME_VIEW_GRID_WIDTH);
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.y;
		_tmp10_ = game_view_get_y_offset (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = game_view_get_tile_size (self);
		_tmp13_ = _tmp12_;
		y = ((gint) (_tmp9_ - _tmp11_)) / (_tmp13_ + GAME_VIEW_GRID_WIDTH);
		_tmp17_ = x;
		if (_tmp17_ >= 0) {
			gint _tmp18_;
			_tmp18_ = x;
			_tmp16_ = _tmp18_ < 8;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp19_ = _tmp16_;
		if (_tmp19_) {
			gint _tmp20_;
			_tmp20_ = y;
			_tmp15_ = _tmp20_ >= 0;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp21_ = _tmp15_;
		if (_tmp21_) {
			gint _tmp22_;
			_tmp22_ = y;
			_tmp14_ = _tmp22_ < 8;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp23_ = _tmp14_;
		if (_tmp23_) {
			gint _tmp24_;
			gint _tmp25_;
			_tmp24_ = x;
			_tmp25_ = y;
			g_signal_emit_by_name (self, "move", _tmp24_, _tmp25_);
		}
	}
	result = TRUE;
	return result;
}


static gint game_view_get_tile_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_ / 8, _tmp1_ / ((gint) 8));
	result = _tmp2_ - GAME_VIEW_GRID_WIDTH;
	return result;
}


static gint game_view_get_x_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = game_view_get_tile_size (self);
	_tmp2_ = _tmp1_;
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
	return result;
}


static gint game_view_get_y_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = game_view_get_tile_size (self);
	_tmp2_ = _tmp1_;
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
	return result;
}


static gint game_view_get_board_size (GameView* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	result = (_tmp1_ + GAME_VIEW_GRID_WIDTH) * 8;
	return result;
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer _game_ref0 (gpointer self) {
	return self ? game_ref (self) : NULL;
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self) {
	game_view_square_changed_cb (self, x, y);
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _game_ref0 (_tmp2_);
	_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = self->priv->_game;
	if (_tmp4_ != NULL) {
		Game* _tmp5_;
		_tmp5_ = self->priv->_game;
		g_signal_connect_object (_tmp5_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
		{
			gint x;
			x = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_;
					gint _tmp9_;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = x;
						x = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp9_ = x;
					if (!(_tmp9_ < 8)) {
						break;
					}
					{
						gint y;
						y = 0;
						{
							gboolean _tmp10_;
							_tmp10_ = TRUE;
							while (TRUE) {
								gboolean _tmp11_;
								gint _tmp13_;
								gint* _tmp14_;
								gint _tmp14__length1;
								gint _tmp14__length2;
								gint _tmp15_;
								gint _tmp16_;
								Game* _tmp17_;
								gint _tmp18_;
								gint _tmp19_;
								Player _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_;
								_tmp11_ = _tmp10_;
								if (!_tmp11_) {
									gint _tmp12_;
									_tmp12_ = y;
									y = _tmp12_ + 1;
								}
								_tmp10_ = FALSE;
								_tmp13_ = y;
								if (!(_tmp13_ < 8)) {
									break;
								}
								_tmp14_ = self->priv->pixmaps;
								_tmp14__length1 = self->priv->pixmaps_length1;
								_tmp14__length2 = self->priv->pixmaps_length2;
								_tmp15_ = x;
								_tmp16_ = y;
								_tmp17_ = self->priv->_game;
								_tmp18_ = x;
								_tmp19_ = y;
								_tmp20_ = game_get_owner (_tmp17_, _tmp18_, _tmp19_);
								_tmp21_ = game_view_get_pixmap (self, _tmp20_);
								_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_] = _tmp21_;
								_tmp22_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							}
						}
					}
				}
			}
		}
	}
	game_view_redraw (self);
	g_object_notify ((GObject *) self, "game");
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "theme");
}


gboolean game_view_get_show_grid (GameView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_grid;
	result = _tmp0_;
	return result;
}


void game_view_set_show_grid (GameView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_grid = _tmp0_;
	game_view_redraw (self);
	g_object_notify ((GObject *) self, "show-grid");
}


gboolean game_view_get_flip_final_result (GameView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_flip_final_result;
	result = _tmp0_;
	return result;
}


void game_view_set_flip_final_result (GameView* self, gboolean value) {
	gboolean _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_flip_final_result = _tmp0_;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	{
		gint x;
		x = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				Game* _tmp7_;
				Game* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = x;
				_tmp7_ = game_view_get_game (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = game_get_width (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp6_ < _tmp10_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp11_;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp12_;
							gint _tmp14_;
							Game* _tmp15_;
							Game* _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							_tmp12_ = _tmp11_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = y;
								y = _tmp13_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp14_ = y;
							_tmp15_ = game_view_get_game (self);
							_tmp16_ = _tmp15_;
							_tmp17_ = game_get_height (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(_tmp14_ < _tmp18_)) {
								break;
							}
							_tmp19_ = x;
							_tmp20_ = y;
							game_view_square_changed_cb (self, _tmp19_, _tmp20_);
						}
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "flip-final-result");
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = game_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = game_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = game_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = game_view_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, param_spec_game ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_GRID, g_param_spec_boolean ("show-grid", "show-grid", "show-grid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_FLIP_FINAL_RESULT, g_param_spec_boolean ("flip-final-result", "flip-final-result", "flip-final-result", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->render_size = (guint) 0;
	self->priv->tiles_pattern = NULL;
	self->priv->animate_timeout = (guint) 0;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	_game_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME:
		value_set_game (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		case GAME_VIEW_SHOW_GRID:
		g_value_set_boolean (value, game_view_get_show_grid (self));
		break;
		case GAME_VIEW_FLIP_FINAL_RESULT:
		g_value_set_boolean (value, game_view_get_flip_final_result (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME:
		game_view_set_game (self, value_get_game (value));
		break;
		case GAME_VIEW_THEME:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SHOW_GRID:
		game_view_set_show_grid (self, g_value_get_boolean (value));
		break;
		case GAME_VIEW_FLIP_FINAL_RESULT:
		game_view_set_flip_final_result (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



