/* chess-view-2d.c generated by valac 0.18.1, the Vala compiler
 * generated from chess-view-2d.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <stdio.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessView2DPrivate ChessView2DPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView2D {
	ChessView parent_instance;
	ChessView2DPrivate * priv;
};

struct _ChessView2DClass {
	ChessViewClass parent_class;
};

struct _ChessView2DPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};


static gpointer chess_view2_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view2_d_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW2_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW2_D, ChessView2DPrivate))
enum  {
	CHESS_VIEW2_D_DUMMY_PROPERTY
};
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view2_d_load_theme (ChessView2D* self, cairo_t* c);
static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view2_d_get_border_size (ChessView2D* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
const gchar* chess_scene_get_board_side (ChessScene* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view2_d_finalize (GObject* obj);
static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView2D* chess_view2_d_construct (GType object_type) {
	ChessView2D * self = NULL;
	self = (ChessView2D*) chess_view_construct (object_type);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	return self;
}


ChessView2D* chess_view2_d_new (void) {
	return chess_view2_d_construct (TYPE_CHESS_VIEW2_D);
}


static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint short_edge;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_;
	gdouble extra;
	gdouble _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	self = (ChessView2D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = short_edge;
	_tmp4_ = self->priv->border;
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
	self->priv->square_size = (gint) _tmp5_;
	_tmp6_ = self->priv->square_size;
	extra = _tmp6_ * 0.1;
	_tmp7_ = extra;
	if (_tmp7_ < ((gdouble) 3)) {
		extra = (gdouble) 3;
	}
	_tmp8_ = self->priv->square_size;
	_tmp9_ = extra;
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
	result = TRUE;
	return result;
}


static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	cairo_t* _tmp19_;
	gint _tmp20_;
	RsvgHandle* _tmp21_;
	gint _tmp22_ = 0;
	gint _tmp23_;
	gint _tmp24_;
	RsvgHandle* _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_;
	RsvgHandle* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	cairo_t* _tmp35_;
	gint _tmp36_;
	RsvgHandle* _tmp37_;
	gint _tmp38_ = 0;
	gint _tmp39_;
	gint _tmp40_;
	RsvgHandle* _tmp41_;
	gint _tmp42_ = 0;
	gint _tmp43_;
	RsvgHandle* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c1 != NULL);
	g_return_if_fail (c2 != NULL);
	g_return_if_fail (name != NULL);
	{
		ChessScene* _tmp0_;
		ChessScene* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		RsvgHandle* _tmp9_;
		RsvgHandle* _tmp10_;
		RsvgHandle* _tmp11_;
		_tmp0_ = chess_view_get_scene ((ChessView*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = chess_scene_get_theme_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = name;
		_tmp5_ = g_strconcat (_tmp4_, ".svg", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_build_filename (PKGDATADIR, "pieces", _tmp3_, _tmp6_, NULL, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = rsvg_handle_new_from_file (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_g_object_unref0 (handle);
		handle = _tmp11_;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Failed to load piece svg: %s", _tmp14_);
		_g_error_free0 (e);
		_g_object_unref0 (handle);
		return;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = c1;
	cairo_save (_tmp15_);
	_tmp16_ = c1;
	_tmp17_ = self->priv->square_size;
	_tmp18_ = offset;
	cairo_translate (_tmp16_, (gdouble) (_tmp17_ * _tmp18_), (gdouble) 0);
	_tmp19_ = c1;
	_tmp20_ = self->priv->square_size;
	_tmp21_ = handle;
	g_object_get (_tmp21_, "width", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->square_size;
	_tmp25_ = handle;
	g_object_get (_tmp25_, "height", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	cairo_scale (_tmp19_, ((gdouble) _tmp20_) / _tmp23_, ((gdouble) _tmp24_) / _tmp27_);
	_tmp28_ = handle;
	_tmp29_ = c1;
	rsvg_handle_render_cairo (_tmp28_, _tmp29_);
	_tmp30_ = c1;
	cairo_restore (_tmp30_);
	_tmp31_ = c2;
	cairo_save (_tmp31_);
	_tmp32_ = c2;
	_tmp33_ = self->priv->selected_square_size;
	_tmp34_ = offset;
	cairo_translate (_tmp32_, (gdouble) (_tmp33_ * _tmp34_), (gdouble) 0);
	_tmp35_ = c2;
	_tmp36_ = self->priv->selected_square_size;
	_tmp37_ = handle;
	g_object_get (_tmp37_, "width", &_tmp38_, NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->selected_square_size;
	_tmp41_ = handle;
	g_object_get (_tmp41_, "height", &_tmp42_, NULL);
	_tmp43_ = _tmp42_;
	cairo_scale (_tmp35_, ((gdouble) _tmp36_) / _tmp39_, ((gdouble) _tmp40_) / _tmp43_);
	_tmp44_ = handle;
	_tmp45_ = c2;
	rsvg_handle_render_cairo (_tmp44_, _tmp45_);
	_tmp46_ = c2;
	cairo_restore (_tmp46_);
	_g_object_unref0 (handle);
}


static void chess_view2_d_load_theme (ChessView2D* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_surface_t* _tmp17_ = NULL;
	gint _tmp18_;
	gint _tmp19_;
	cairo_surface_t* _tmp20_;
	cairo_surface_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* c1;
	cairo_surface_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* c2;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	cairo_t* _tmp47_;
	cairo_t* _tmp48_;
	ChessScene* _tmp49_;
	ChessScene* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->loaded_theme_name;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		cairo_surface_t* _tmp7_;
		_tmp7_ = self->priv->model_surface;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		gint _tmp9_;
		cairo_surface_t* _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = self->priv->square_size;
		_tmp10_ = self->priv->model_surface;
		_tmp11_ = cairo_image_surface_get_height (_tmp10_);
		_tmp0_ = _tmp9_ == _tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp13_ = self->priv->square_size;
	_tmp14_ = self->priv->square_size;
	_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp13_, _tmp14_);
	_cairo_surface_destroy0 (self->priv->model_surface);
	self->priv->model_surface = _tmp15_;
	_tmp16_ = c;
	_tmp17_ = cairo_get_target (_tmp16_);
	_tmp18_ = self->priv->selected_square_size;
	_tmp19_ = self->priv->selected_square_size;
	_tmp20_ = cairo_surface_create_similar (_tmp17_, CAIRO_CONTENT_COLOR_ALPHA, 12 * _tmp18_, _tmp19_);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	self->priv->selected_model_surface = _tmp20_;
	_tmp21_ = self->priv->model_surface;
	_tmp22_ = cairo_create (_tmp21_);
	c1 = _tmp22_;
	_tmp23_ = self->priv->selected_model_surface;
	_tmp24_ = cairo_create (_tmp23_);
	c2 = _tmp24_;
	_tmp25_ = c1;
	_tmp26_ = c2;
	chess_view2_d_render_piece (self, _tmp25_, _tmp26_, "whitePawn", 0);
	_tmp27_ = c1;
	_tmp28_ = c2;
	chess_view2_d_render_piece (self, _tmp27_, _tmp28_, "whiteRook", 1);
	_tmp29_ = c1;
	_tmp30_ = c2;
	chess_view2_d_render_piece (self, _tmp29_, _tmp30_, "whiteKnight", 2);
	_tmp31_ = c1;
	_tmp32_ = c2;
	chess_view2_d_render_piece (self, _tmp31_, _tmp32_, "whiteBishop", 3);
	_tmp33_ = c1;
	_tmp34_ = c2;
	chess_view2_d_render_piece (self, _tmp33_, _tmp34_, "whiteQueen", 4);
	_tmp35_ = c1;
	_tmp36_ = c2;
	chess_view2_d_render_piece (self, _tmp35_, _tmp36_, "whiteKing", 5);
	_tmp37_ = c1;
	_tmp38_ = c2;
	chess_view2_d_render_piece (self, _tmp37_, _tmp38_, "blackPawn", 6);
	_tmp39_ = c1;
	_tmp40_ = c2;
	chess_view2_d_render_piece (self, _tmp39_, _tmp40_, "blackRook", 7);
	_tmp41_ = c1;
	_tmp42_ = c2;
	chess_view2_d_render_piece (self, _tmp41_, _tmp42_, "blackKnight", 8);
	_tmp43_ = c1;
	_tmp44_ = c2;
	chess_view2_d_render_piece (self, _tmp43_, _tmp44_, "blackBishop", 9);
	_tmp45_ = c1;
	_tmp46_ = c2;
	chess_view2_d_render_piece (self, _tmp45_, _tmp46_, "blackQueen", 10);
	_tmp47_ = c1;
	_tmp48_ = c2;
	chess_view2_d_render_piece (self, _tmp47_, _tmp48_, "blackKing", 11);
	_tmp49_ = chess_view_get_scene ((ChessView*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = chess_scene_get_theme_name (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strdup (_tmp52_);
	_g_free0 (self->priv->loaded_theme_name);
	self->priv->loaded_theme_name = _tmp53_;
	_cairo_destroy0 (c2);
	_cairo_destroy0 (c1);
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView2D * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_t* _tmp4_;
	ChessScene* _tmp5_;
	ChessScene* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_ = 0.0;
	gint board_size;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	cairo_t* _tmp19_;
	ChessScene* _tmp42_;
	ChessScene* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	ChessScene* _tmp160_;
	ChessScene* _tmp161_;
	GList* _tmp162_;
	self = (ChessView2D*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	chess_view2_d_load_theme (self, _tmp0_);
	_tmp1_ = c;
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_translate (_tmp1_, (gdouble) (_tmp2_ / 2), (gdouble) (_tmp3_ / 2));
	_tmp4_ = c;
	_tmp5_ = chess_view_get_scene ((ChessView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_scene_get_board_angle (_tmp6_);
	_tmp8_ = _tmp7_;
	cairo_rotate (_tmp4_, (G_PI * _tmp8_) / 180.0);
	_tmp9_ = self->priv->square_size;
	_tmp10_ = chess_view2_d_get_border_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = ceil ((_tmp9_ * 4) + _tmp11_);
	board_size = (gint) _tmp12_;
	_tmp13_ = c;
	cairo_set_source_rgb (_tmp13_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
	_tmp14_ = c;
	_tmp15_ = board_size;
	_tmp16_ = board_size;
	_tmp17_ = board_size;
	_tmp18_ = board_size;
	cairo_rectangle (_tmp14_, (gdouble) (-_tmp15_), (gdouble) (-_tmp16_), (gdouble) (_tmp17_ * 2), (gdouble) (_tmp18_ * 2));
	_tmp19_ = c;
	cairo_fill (_tmp19_);
	{
		gint file;
		file = 0;
		{
			gboolean _tmp20_;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_;
				gint _tmp23_;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = file;
					file = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = file;
				if (!(_tmp23_ < 8)) {
					break;
				}
				{
					gint rank;
					rank = 0;
					{
						gboolean _tmp24_;
						_tmp24_ = TRUE;
						while (TRUE) {
							gboolean _tmp25_;
							gint _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gint x;
							gint _tmp30_;
							gint _tmp31_;
							gint y;
							cairo_t* _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							cairo_t* _tmp41_;
							_tmp25_ = _tmp24_;
							if (!_tmp25_) {
								gint _tmp26_;
								_tmp26_ = rank;
								rank = _tmp26_ + 1;
							}
							_tmp24_ = FALSE;
							_tmp27_ = rank;
							if (!(_tmp27_ < 8)) {
								break;
							}
							_tmp28_ = file;
							_tmp29_ = self->priv->square_size;
							x = (gint) ((_tmp28_ - 4) * _tmp29_);
							_tmp30_ = rank;
							_tmp31_ = self->priv->square_size;
							y = (gint) ((3 - _tmp30_) * _tmp31_);
							_tmp32_ = c;
							_tmp33_ = x;
							_tmp34_ = y;
							_tmp35_ = self->priv->square_size;
							_tmp36_ = self->priv->square_size;
							cairo_rectangle (_tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_, (gdouble) _tmp35_, (gdouble) _tmp36_);
							_tmp37_ = file;
							_tmp38_ = rank;
							if (((_tmp37_ + _tmp38_) % 2) == 0) {
								cairo_t* _tmp39_;
								_tmp39_ = c;
								cairo_set_source_rgb (_tmp39_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
							} else {
								cairo_t* _tmp40_;
								_tmp40_ = c;
								cairo_set_source_rgb (_tmp40_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
							}
							_tmp41_ = c;
							cairo_fill (_tmp41_);
						}
					}
				}
			}
		}
	}
	_tmp42_ = chess_view_get_scene ((ChessView*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = chess_scene_get_show_numbering (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_) {
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar** _tmp54_ = NULL;
		gchar** files;
		gint files_length1;
		gint _files_size_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar** _tmp63_ = NULL;
		gchar** ranks;
		gint ranks_length1;
		gint _ranks_size_;
		cairo_t* _tmp64_;
		cairo_t* _tmp65_;
		gdouble _tmp66_;
		gdouble _tmp67_;
		cairo_t* _tmp68_;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp69_;
		cairo_text_extents_t _tmp70_ = {0};
		gint _tmp71_;
		cairo_text_extents_t _tmp72_;
		gdouble _tmp73_;
		cairo_text_extents_t _tmp74_;
		gdouble _tmp75_;
		cairo_text_extents_t _tmp76_;
		gdouble _tmp77_;
		gdouble y_offset;
		gint _tmp78_;
		gdouble _tmp79_;
		gdouble top;
		gint _tmp80_;
		gdouble _tmp81_;
		gdouble _tmp82_;
		gdouble _tmp83_;
		gdouble bottom;
		gint _tmp84_;
		gdouble file_offset;
		gint _tmp85_;
		gdouble rank_offset;
		_tmp46_ = g_strdup ("a");
		_tmp47_ = g_strdup ("b");
		_tmp48_ = g_strdup ("c");
		_tmp49_ = g_strdup ("d");
		_tmp50_ = g_strdup ("e");
		_tmp51_ = g_strdup ("f");
		_tmp52_ = g_strdup ("g");
		_tmp53_ = g_strdup ("h");
		_tmp54_ = g_new0 (gchar*, 8 + 1);
		_tmp54_[0] = _tmp46_;
		_tmp54_[1] = _tmp47_;
		_tmp54_[2] = _tmp48_;
		_tmp54_[3] = _tmp49_;
		_tmp54_[4] = _tmp50_;
		_tmp54_[5] = _tmp51_;
		_tmp54_[6] = _tmp52_;
		_tmp54_[7] = _tmp53_;
		files = _tmp54_;
		files_length1 = 8;
		_files_size_ = files_length1;
		_tmp55_ = g_strdup ("8");
		_tmp56_ = g_strdup ("7");
		_tmp57_ = g_strdup ("6");
		_tmp58_ = g_strdup ("5");
		_tmp59_ = g_strdup ("4");
		_tmp60_ = g_strdup ("3");
		_tmp61_ = g_strdup ("2");
		_tmp62_ = g_strdup ("1");
		_tmp63_ = g_new0 (gchar*, 8 + 1);
		_tmp63_[0] = _tmp55_;
		_tmp63_[1] = _tmp56_;
		_tmp63_[2] = _tmp57_;
		_tmp63_[3] = _tmp58_;
		_tmp63_[4] = _tmp59_;
		_tmp63_[5] = _tmp60_;
		_tmp63_[6] = _tmp61_;
		_tmp63_[7] = _tmp62_;
		ranks = _tmp63_;
		ranks_length1 = 8;
		_ranks_size_ = ranks_length1;
		_tmp64_ = c;
		cairo_set_source_rgb (_tmp64_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
		_tmp65_ = c;
		_tmp66_ = chess_view2_d_get_border_size (self);
		_tmp67_ = _tmp66_;
		cairo_set_font_size (_tmp65_, _tmp67_ * 0.6);
		_tmp68_ = c;
		cairo_select_font_face (_tmp68_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp69_ = c;
		cairo_text_extents (_tmp69_, "abcdefgh", &_tmp70_);
		extents = _tmp70_;
		_tmp71_ = self->priv->square_size;
		_tmp72_ = extents;
		_tmp73_ = _tmp72_.height;
		_tmp74_ = extents;
		_tmp75_ = _tmp74_.height;
		_tmp76_ = extents;
		_tmp77_ = _tmp76_.y_bearing;
		y_offset = ((((_tmp71_ / 2) - _tmp73_) / 2) + _tmp75_) + _tmp77_;
		_tmp78_ = self->priv->square_size;
		_tmp79_ = y_offset;
		top = -((_tmp78_ * 4) + _tmp79_);
		_tmp80_ = self->priv->square_size;
		_tmp81_ = chess_view2_d_get_border_size (self);
		_tmp82_ = _tmp81_;
		_tmp83_ = y_offset;
		bottom = ((_tmp80_ * 4) + _tmp82_) - _tmp83_;
		_tmp84_ = self->priv->square_size;
		file_offset = -(_tmp84_ * 3.5);
		_tmp85_ = self->priv->square_size;
		rank_offset = -(_tmp85_ * 3.5);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp86_;
				_tmp86_ = TRUE;
				while (TRUE) {
					gboolean _tmp87_;
					gint _tmp89_;
					cairo_t* _tmp90_;
					gchar** _tmp91_;
					gint _tmp91__length1;
					gint _tmp92_;
					const gchar* _tmp93_;
					cairo_text_extents_t _tmp94_ = {0};
					cairo_t* _tmp95_;
					cairo_t* _tmp96_;
					gdouble _tmp97_;
					cairo_text_extents_t _tmp98_;
					gdouble _tmp99_;
					gdouble _tmp100_;
					cairo_t* _tmp101_;
					gchar** _tmp102_;
					gint _tmp102__length1;
					gint _tmp103_;
					const gchar* _tmp104_;
					cairo_t* _tmp105_;
					cairo_t* _tmp106_;
					cairo_t* _tmp107_;
					gdouble _tmp108_;
					cairo_text_extents_t _tmp109_;
					gdouble _tmp110_;
					gdouble _tmp111_;
					cairo_t* _tmp112_;
					gchar** _tmp113_;
					gint _tmp113__length1;
					gint _tmp114_;
					const gchar* _tmp115_;
					cairo_t* _tmp116_;
					cairo_t* _tmp117_;
					gchar** _tmp118_;
					gint _tmp118__length1;
					gint _tmp119_;
					const gchar* _tmp120_;
					cairo_text_extents_t _tmp121_ = {0};
					cairo_text_extents_t _tmp122_;
					gdouble _tmp123_;
					cairo_text_extents_t _tmp124_;
					gdouble _tmp125_;
					cairo_t* _tmp126_;
					cairo_t* _tmp127_;
					gint _tmp128_;
					gdouble _tmp129_;
					gdouble _tmp130_;
					gdouble _tmp131_;
					gdouble _tmp132_;
					cairo_text_extents_t _tmp133_;
					gdouble _tmp134_;
					gdouble _tmp135_;
					gdouble _tmp136_;
					cairo_t* _tmp137_;
					gchar** _tmp138_;
					gint _tmp138__length1;
					gint _tmp139_;
					const gchar* _tmp140_;
					cairo_t* _tmp141_;
					cairo_t* _tmp142_;
					cairo_t* _tmp143_;
					gint _tmp144_;
					gdouble _tmp145_;
					gdouble _tmp146_;
					cairo_text_extents_t _tmp147_;
					gdouble _tmp148_;
					gdouble _tmp149_;
					gdouble _tmp150_;
					cairo_t* _tmp151_;
					gchar** _tmp152_;
					gint _tmp152__length1;
					gint _tmp153_;
					const gchar* _tmp154_;
					cairo_t* _tmp155_;
					gdouble _tmp156_;
					gint _tmp157_;
					gdouble _tmp158_;
					gint _tmp159_;
					_tmp87_ = _tmp86_;
					if (!_tmp87_) {
						gint _tmp88_;
						_tmp88_ = i;
						i = _tmp88_ + 1;
					}
					_tmp86_ = FALSE;
					_tmp89_ = i;
					if (!(_tmp89_ < 8)) {
						break;
					}
					_tmp90_ = c;
					_tmp91_ = ranks;
					_tmp91__length1 = ranks_length1;
					_tmp92_ = i;
					_tmp93_ = _tmp91_[_tmp92_];
					cairo_text_extents (_tmp90_, _tmp93_, &_tmp94_);
					extents = _tmp94_;
					_tmp95_ = c;
					cairo_save (_tmp95_);
					_tmp96_ = c;
					_tmp97_ = file_offset;
					_tmp98_ = extents;
					_tmp99_ = _tmp98_.width;
					_tmp100_ = top;
					cairo_move_to (_tmp96_, _tmp97_ - (_tmp99_ / 2), _tmp100_);
					_tmp101_ = c;
					_tmp102_ = files;
					_tmp102__length1 = files_length1;
					_tmp103_ = i;
					_tmp104_ = _tmp102_[_tmp103_];
					cairo_show_text (_tmp101_, _tmp104_);
					_tmp105_ = c;
					cairo_restore (_tmp105_);
					_tmp106_ = c;
					cairo_save (_tmp106_);
					_tmp107_ = c;
					_tmp108_ = file_offset;
					_tmp109_ = extents;
					_tmp110_ = _tmp109_.width;
					_tmp111_ = bottom;
					cairo_move_to (_tmp107_, _tmp108_ - (_tmp110_ / 2), _tmp111_);
					_tmp112_ = c;
					_tmp113_ = files;
					_tmp113__length1 = files_length1;
					_tmp114_ = i;
					_tmp115_ = _tmp113_[_tmp114_];
					cairo_show_text (_tmp112_, _tmp115_);
					_tmp116_ = c;
					cairo_restore (_tmp116_);
					_tmp117_ = c;
					_tmp118_ = ranks;
					_tmp118__length1 = ranks_length1;
					_tmp119_ = i;
					_tmp120_ = _tmp118_[_tmp119_];
					cairo_text_extents (_tmp117_, _tmp120_, &_tmp121_);
					extents = _tmp121_;
					_tmp122_ = extents;
					_tmp123_ = _tmp122_.y_bearing;
					_tmp124_ = extents;
					_tmp125_ = _tmp124_.height;
					y_offset = -(_tmp123_ + (_tmp125_ / 2));
					_tmp126_ = c;
					cairo_save (_tmp126_);
					_tmp127_ = c;
					_tmp128_ = self->priv->square_size;
					_tmp129_ = chess_view2_d_get_border_size (self);
					_tmp130_ = _tmp129_;
					_tmp131_ = chess_view2_d_get_border_size (self);
					_tmp132_ = _tmp131_;
					_tmp133_ = extents;
					_tmp134_ = _tmp133_.width;
					_tmp135_ = rank_offset;
					_tmp136_ = y_offset;
					cairo_move_to (_tmp127_, -(((((gdouble) _tmp128_) * 4) + _tmp130_) - ((_tmp132_ - _tmp134_) / 2)), _tmp135_ + _tmp136_);
					_tmp137_ = c;
					_tmp138_ = ranks;
					_tmp138__length1 = ranks_length1;
					_tmp139_ = i;
					_tmp140_ = _tmp138_[_tmp139_];
					cairo_show_text (_tmp137_, _tmp140_);
					_tmp141_ = c;
					cairo_restore (_tmp141_);
					_tmp142_ = c;
					cairo_save (_tmp142_);
					_tmp143_ = c;
					_tmp144_ = self->priv->square_size;
					_tmp145_ = chess_view2_d_get_border_size (self);
					_tmp146_ = _tmp145_;
					_tmp147_ = extents;
					_tmp148_ = _tmp147_.width;
					_tmp149_ = rank_offset;
					_tmp150_ = y_offset;
					cairo_move_to (_tmp143_, (((gdouble) _tmp144_) * 4) + ((_tmp146_ - _tmp148_) / 2), _tmp149_ + _tmp150_);
					_tmp151_ = c;
					_tmp152_ = ranks;
					_tmp152__length1 = ranks_length1;
					_tmp153_ = i;
					_tmp154_ = _tmp152_[_tmp153_];
					cairo_show_text (_tmp151_, _tmp154_);
					_tmp155_ = c;
					cairo_restore (_tmp155_);
					_tmp156_ = file_offset;
					_tmp157_ = self->priv->square_size;
					file_offset = _tmp156_ + _tmp157_;
					_tmp158_ = rank_offset;
					_tmp159_ = self->priv->square_size;
					rank_offset = _tmp158_ + _tmp159_;
				}
			}
		}
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp160_ = chess_view_get_scene ((ChessView*) self);
	_tmp161_ = _tmp160_;
	_tmp162_ = _tmp161_->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp162_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp163_;
			ChessModel* model = NULL;
			_tmp163_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp163_;
			{
				cairo_t* _tmp164_;
				cairo_t* _tmp165_;
				ChessModel* _tmp166_;
				gdouble _tmp167_;
				gint _tmp168_;
				ChessModel* _tmp169_;
				gdouble _tmp170_;
				gint _tmp171_;
				cairo_t* _tmp172_;
				gint _tmp173_;
				gint _tmp174_;
				cairo_t* _tmp175_;
				ChessScene* _tmp176_;
				ChessScene* _tmp177_;
				gdouble _tmp178_;
				gdouble _tmp179_;
				cairo_surface_t* _tmp180_ = NULL;
				ChessModel* _tmp181_;
				gboolean _tmp182_;
				gint _tmp185_ = 0;
				ChessModel* _tmp186_;
				gboolean _tmp187_;
				gdouble _tmp190_ = 0.0;
				gboolean _tmp191_ = FALSE;
				ChessModel* _tmp192_;
				gboolean _tmp193_;
				gboolean _tmp198_;
				cairo_t* _tmp199_;
				cairo_surface_t* _tmp200_;
				gint _tmp201_;
				ChessModel* _tmp202_;
				ChessPiece* _tmp203_;
				gdouble _tmp204_;
				cairo_t* _tmp205_;
				_tmp164_ = c;
				cairo_save (_tmp164_);
				_tmp165_ = c;
				_tmp166_ = model;
				_tmp167_ = _tmp166_->x;
				_tmp168_ = self->priv->square_size;
				_tmp169_ = model;
				_tmp170_ = _tmp169_->y;
				_tmp171_ = self->priv->square_size;
				cairo_translate (_tmp165_, (_tmp167_ - 4) * _tmp168_, (3 - _tmp170_) * _tmp171_);
				_tmp172_ = c;
				_tmp173_ = self->priv->square_size;
				_tmp174_ = self->priv->square_size;
				cairo_translate (_tmp172_, (gdouble) (_tmp173_ / 2), (gdouble) (_tmp174_ / 2));
				_tmp175_ = c;
				_tmp176_ = chess_view_get_scene ((ChessView*) self);
				_tmp177_ = _tmp176_;
				_tmp178_ = chess_scene_get_board_angle (_tmp177_);
				_tmp179_ = _tmp178_;
				cairo_rotate (_tmp175_, ((-G_PI) * _tmp179_) / 180.0);
				_tmp181_ = model;
				_tmp182_ = _tmp181_->is_selected;
				if (_tmp182_) {
					cairo_surface_t* _tmp183_;
					_tmp183_ = self->priv->selected_model_surface;
					_tmp180_ = _tmp183_;
				} else {
					cairo_surface_t* _tmp184_;
					_tmp184_ = self->priv->model_surface;
					_tmp180_ = _tmp184_;
				}
				_tmp186_ = model;
				_tmp187_ = _tmp186_->is_selected;
				if (_tmp187_) {
					gint _tmp188_;
					_tmp188_ = self->priv->selected_square_size;
					_tmp185_ = _tmp188_;
				} else {
					gint _tmp189_;
					_tmp189_ = self->priv->square_size;
					_tmp185_ = _tmp189_;
				}
				_tmp192_ = model;
				_tmp193_ = _tmp192_->under_threat;
				if (_tmp193_) {
					ChessScene* _tmp194_;
					ChessScene* _tmp195_;
					gboolean _tmp196_;
					gboolean _tmp197_;
					_tmp194_ = chess_view_get_scene ((ChessView*) self);
					_tmp195_ = _tmp194_;
					_tmp196_ = chess_scene_get_show_move_hints (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp191_ = _tmp197_;
				} else {
					_tmp191_ = FALSE;
				}
				_tmp198_ = _tmp191_;
				if (_tmp198_) {
					_tmp190_ = 0.8;
				} else {
					_tmp190_ = 1.0;
				}
				_tmp199_ = c;
				_tmp200_ = _tmp180_;
				_tmp201_ = _tmp185_;
				_tmp202_ = model;
				_tmp203_ = _tmp202_->piece;
				_tmp204_ = _tmp190_;
				chess_view2_d_draw_piece (self, _tmp199_, _tmp200_, _tmp201_, _tmp203_, _tmp204_);
				_tmp205_ = c;
				cairo_restore (_tmp205_);
				_chess_model_unref0 (model);
			}
		}
	}
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp206_;
			_tmp206_ = TRUE;
			while (TRUE) {
				gboolean _tmp207_;
				gint _tmp209_;
				_tmp207_ = _tmp206_;
				if (!_tmp207_) {
					gint _tmp208_;
					_tmp208_ = rank;
					rank = _tmp208_ + 1;
				}
				_tmp206_ = FALSE;
				_tmp209_ = rank;
				if (!(_tmp209_ < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp210_;
						_tmp210_ = TRUE;
						while (TRUE) {
							gboolean _tmp211_;
							gint _tmp213_;
							gboolean _tmp214_ = FALSE;
							ChessScene* _tmp215_;
							ChessScene* _tmp216_;
							gboolean _tmp217_;
							gboolean _tmp218_;
							gboolean _tmp224_;
							_tmp211_ = _tmp210_;
							if (!_tmp211_) {
								gint _tmp212_;
								_tmp212_ = file;
								file = _tmp212_ + 1;
							}
							_tmp210_ = FALSE;
							_tmp213_ = file;
							if (!(_tmp213_ < 8)) {
								break;
							}
							_tmp215_ = chess_view_get_scene ((ChessView*) self);
							_tmp216_ = _tmp215_;
							_tmp217_ = chess_scene_get_show_move_hints (_tmp216_);
							_tmp218_ = _tmp217_;
							if (_tmp218_) {
								ChessScene* _tmp219_;
								ChessScene* _tmp220_;
								gint _tmp221_;
								gint _tmp222_;
								gboolean _tmp223_ = FALSE;
								_tmp219_ = chess_view_get_scene ((ChessView*) self);
								_tmp220_ = _tmp219_;
								_tmp221_ = rank;
								_tmp222_ = file;
								_tmp223_ = chess_scene_can_move (_tmp220_, _tmp221_, _tmp222_);
								_tmp214_ = _tmp223_;
							} else {
								_tmp214_ = FALSE;
							}
							_tmp224_ = _tmp214_;
							if (_tmp224_) {
								cairo_t* _tmp225_;
								cairo_t* _tmp226_;
								gint _tmp227_;
								gint _tmp228_;
								gint _tmp229_;
								gint _tmp230_;
								cairo_t* _tmp231_;
								gint _tmp232_;
								gint _tmp233_;
								cairo_t* _tmp234_;
								ChessScene* _tmp235_;
								ChessScene* _tmp236_;
								gdouble _tmp237_;
								gdouble _tmp238_;
								cairo_t* _tmp239_;
								cairo_surface_t* _tmp240_;
								gint _tmp241_;
								ChessScene* _tmp242_;
								ChessScene* _tmp243_;
								ChessPiece* _tmp244_ = NULL;
								ChessPiece* _tmp245_;
								cairo_t* _tmp246_;
								_tmp225_ = c;
								cairo_save (_tmp225_);
								_tmp226_ = c;
								_tmp227_ = file;
								_tmp228_ = self->priv->square_size;
								_tmp229_ = rank;
								_tmp230_ = self->priv->square_size;
								cairo_translate (_tmp226_, (gdouble) ((_tmp227_ - 4) * _tmp228_), (gdouble) ((3 - _tmp229_) * _tmp230_));
								_tmp231_ = c;
								_tmp232_ = self->priv->square_size;
								_tmp233_ = self->priv->square_size;
								cairo_translate (_tmp231_, (gdouble) (_tmp232_ / 2), (gdouble) (_tmp233_ / 2));
								_tmp234_ = c;
								_tmp235_ = chess_view_get_scene ((ChessView*) self);
								_tmp236_ = _tmp235_;
								_tmp237_ = chess_scene_get_board_angle (_tmp236_);
								_tmp238_ = _tmp237_;
								cairo_rotate (_tmp234_, ((-G_PI) * _tmp238_) / 180.0);
								_tmp239_ = c;
								_tmp240_ = self->priv->model_surface;
								_tmp241_ = self->priv->square_size;
								_tmp242_ = chess_view_get_scene ((ChessView*) self);
								_tmp243_ = _tmp242_;
								_tmp244_ = chess_scene_get_selected_piece (_tmp243_);
								_tmp245_ = _tmp244_;
								chess_view2_d_draw_piece (self, _tmp239_, _tmp240_, _tmp241_, _tmp245_, 0.1);
								_chess_piece_unref0 (_tmp245_);
								_tmp246_ = c;
								cairo_restore (_tmp246_);
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha) {
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp8_;
	cairo_t* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	ChessPiece* _tmp13_;
	PieceType _tmp14_;
	gint offset;
	ChessPiece* _tmp15_;
	Color _tmp16_;
	Color _tmp17_;
	cairo_t* _tmp19_;
	cairo_surface_t* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	cairo_t* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	gdouble _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (piece != NULL);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_board_side (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "facetoface") == 0) {
		ChessPiece* _tmp5_;
		Color _tmp6_;
		Color _tmp7_;
		_tmp5_ = piece;
		_tmp6_ = chess_piece_get_color (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == COLOR_BLACK;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		cairo_t* _tmp9_;
		_tmp9_ = c;
		cairo_rotate (_tmp9_, G_PI);
	}
	_tmp10_ = c;
	_tmp11_ = size;
	_tmp12_ = size;
	cairo_translate (_tmp10_, (gdouble) ((-_tmp11_) / 2), (gdouble) ((-_tmp12_) / 2));
	_tmp13_ = piece;
	_tmp14_ = _tmp13_->type;
	offset = (gint) _tmp14_;
	_tmp15_ = piece;
	_tmp16_ = chess_piece_get_color (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == COLOR_BLACK) {
		gint _tmp18_;
		_tmp18_ = offset;
		offset = _tmp18_ + 6;
	}
	_tmp19_ = c;
	_tmp20_ = surface;
	_tmp21_ = offset;
	_tmp22_ = size;
	cairo_set_source_surface (_tmp19_, _tmp20_, (gdouble) ((-_tmp21_) * _tmp22_), (gdouble) 0);
	_tmp23_ = c;
	_tmp24_ = size;
	_tmp25_ = size;
	cairo_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp24_, (gdouble) _tmp25_);
	_tmp26_ = c;
	cairo_clip (_tmp26_);
	_tmp27_ = c;
	_tmp28_ = alpha;
	cairo_paint_with_alpha (_tmp27_, _tmp28_);
}


static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	ChessGame* _tmp3_;
	ChessGame* _tmp4_;
	gboolean _tmp7_;
	GdkEventButton _tmp8_;
	gdouble _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	gint _tmp12_;
	gdouble _tmp13_ = 0.0;
	gint file;
	GdkEventButton _tmp14_;
	gdouble _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_ = 0.0;
	gint rank;
	ChessScene* _tmp20_;
	ChessScene* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_;
	gboolean _tmp31_;
	gboolean _tmp33_;
	gboolean _tmp35_;
	ChessScene* _tmp36_;
	ChessScene* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	self = (ChessView2D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_game (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp5_;
		guint _tmp6_;
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.button;
		_tmp0_ = _tmp6_ != ((guint) 1);
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = *event;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp11_ = self->priv->square_size;
	_tmp12_ = self->priv->square_size;
	_tmp13_ = floor (((_tmp9_ - (0.5 * _tmp10_)) + (_tmp11_ * 4)) / _tmp12_);
	file = (gint) _tmp13_;
	_tmp14_ = *event;
	_tmp15_ = _tmp14_.y;
	_tmp16_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp17_ = self->priv->square_size;
	_tmp18_ = self->priv->square_size;
	_tmp19_ = floor (((_tmp15_ - (0.5 * _tmp16_)) + (_tmp17_ * 4)) / _tmp18_);
	rank = 7 - ((gint) _tmp19_);
	_tmp20_ = chess_view_get_scene ((ChessView*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = chess_scene_get_board_angle (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == 180.0) {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = rank;
		rank = 7 - _tmp24_;
		_tmp25_ = file;
		file = 7 - _tmp25_;
	}
	_tmp29_ = file;
	if (_tmp29_ < 0) {
		_tmp28_ = TRUE;
	} else {
		gint _tmp30_;
		_tmp30_ = file;
		_tmp28_ = _tmp30_ >= 8;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		_tmp27_ = TRUE;
	} else {
		gint _tmp32_;
		_tmp32_ = rank;
		_tmp27_ = _tmp32_ < 0;
	}
	_tmp33_ = _tmp27_;
	if (_tmp33_) {
		_tmp26_ = TRUE;
	} else {
		gint _tmp34_;
		_tmp34_ = rank;
		_tmp26_ = _tmp34_ >= 8;
	}
	_tmp35_ = _tmp26_;
	if (_tmp35_) {
		result = FALSE;
		return result;
	}
	_tmp36_ = chess_view_get_scene ((ChessView*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = file;
	_tmp39_ = rank;
	chess_scene_select_square (_tmp37_, _tmp38_, _tmp39_);
	result = TRUE;
	return result;
}


static gdouble chess_view2_d_get_border_size (ChessView2D* self) {
	gdouble result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->square_size;
	result = (gdouble) (_tmp0_ / 2);
	return result;
}


static void chess_view2_d_class_init (ChessView2DClass * klass) {
	chess_view2_d_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessView2DPrivate));
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view2_d_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = chess_view2_d_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view2_d_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view2_d_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view2_d_finalize;
}


static void chess_view2_d_instance_init (ChessView2D * self) {
	gchar* _tmp0_;
	self->priv = CHESS_VIEW2_D_GET_PRIVATE (self);
	self->priv->border = 6;
	_tmp0_ = g_strdup ("");
	self->priv->loaded_theme_name = _tmp0_;
}


static void chess_view2_d_finalize (GObject* obj) {
	ChessView2D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW2_D, ChessView2D);
	_cairo_surface_destroy0 (self->priv->model_surface);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	_g_free0 (self->priv->loaded_theme_name);
	G_OBJECT_CLASS (chess_view2_d_parent_class)->finalize (obj);
}


GType chess_view2_d_get_type (void) {
	static volatile gsize chess_view2_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view2_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView2DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view2_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView2D), 0, (GInstanceInitFunc) chess_view2_d_instance_init, NULL };
		GType chess_view2_d_type_id;
		chess_view2_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView2D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view2_d_type_id__volatile, chess_view2_d_type_id);
	}
	return chess_view2_d_type_id__volatile;
}


static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView2D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW2_D, ChessView2D);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



