/* rygel-media-server-plugin.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-media-server-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SOURCE_CONNECTION_MANAGER (rygel_source_connection_manager_get_type ())
#define RYGEL_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManager))
#define RYGEL_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_SOURCE_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))

typedef struct _RygelSourceConnectionManager RygelSourceConnectionManager;
typedef struct _RygelSourceConnectionManagerClass RygelSourceConnectionManagerClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR (rygel_media_receiver_registrar_get_type ())
#define RYGEL_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrar))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))

typedef struct _RygelMediaReceiverRegistrar RygelMediaReceiverRegistrar;
typedef struct _RygelMediaReceiverRegistrarClass RygelMediaReceiverRegistrarClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_V1_HACKS (rygel_v1_hacks_get_type ())
#define RYGEL_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_V1_HACKS, RygelV1Hacks))
#define RYGEL_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))
#define RYGEL_IS_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_V1_HACKS))
#define RYGEL_IS_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_V1_HACKS))
#define RYGEL_V1_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))

typedef struct _RygelV1Hacks RygelV1Hacks;
typedef struct _RygelV1HacksClass RygelV1HacksClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelV1HacksPrivate RygelV1HacksPrivate;

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
};

struct _RygelMediaServerPluginPrivate {
	RygelMediaContainer* _root_container;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaItem* item);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelV1Hacks {
	RygelClientHacks parent_instance;
	RygelV1HacksPrivate * priv;
	gchar* description_path;
};

struct _RygelV1HacksClass {
	RygelClientHacksClass parent_class;
};


static gpointer rygel_media_server_plugin_parent_class = NULL;

GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginPrivate))
enum  {
	RYGEL_MEDIA_SERVER_PLUGIN_DUMMY_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER
};
#define RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH DATA_DIR "/xml/MediaServer3.xml"
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self, RygelMediaContainer* value);
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_source_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID "urn:microsoft-com:serviceId:X_MS_MediaReceiverRegistrar"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH "xml/X_MS_MediaReceiverRegistrar1.xml"
GType rygel_media_receiver_registrar_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
GQuark rygel_client_hacks_error_quark (void);
RygelV1Hacks* rygel_v1_hacks_new (GError** error);
RygelV1Hacks* rygel_v1_hacks_construct (GType object_type, GError** error);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_v1_hacks_get_type (void) G_GNUC_CONST;
void rygel_v1_hacks_apply_on_device (RygelV1Hacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
static void rygel_media_server_plugin_finalize (GObject* obj);
static void _vala_rygel_media_server_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_server_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create an instance of the plugin.
     * The plugin's service will have the same title as its root container.
     *
     * @param root_container The container that should be served by this plugin's service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	rygel_media_server_plugin_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
}


RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaServerPlugin * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelPluginCapabilities _tmp5_;
	RygelMediaContainer* _tmp6_;
	gchar* _tmp7_;
	gchar* path;
	RygelPluginCapabilities _tmp8_;
	RygelPluginCapabilities _tmp9_;
	const gchar* _tmp11_;
	RygelResourceInfo* _tmp12_;
	RygelResourceInfo* info;
	RygelResourceInfo* _tmp13_;
	RygelResourceInfo* _tmp14_;
	RygelResourceInfo* _tmp15_;
	RygelResourceInfo* _tmp16_;
	RygelResourceInfo* _tmp17_;
	RygelMediaContainer* _tmp18_;
	gint _tmp19_;
	g_return_val_if_fail (root_container != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = root_container;
	_tmp2_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = description;
	_tmp5_ = capabilities;
	self = (RygelMediaServerPlugin*) rygel_plugin_construct (object_type, RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH, _tmp0_, _tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = root_container;
	rygel_media_server_plugin_set_root_container (self, _tmp6_);
	_tmp7_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK);
	path = _tmp7_;
	_tmp8_ = rygel_plugin_get_capabilities ((RygelPlugin*) self);
	_tmp9_ = _tmp8_;
	if ((_tmp9_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH);
		_g_free0 (path);
		path = _tmp10_;
	}
	_tmp11_ = path;
	_tmp12_ = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, _tmp11_, RYGEL_TYPE_CONTENT_DIRECTORY);
	info = _tmp12_;
	_tmp13_ = info;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp13_);
	_tmp14_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SOURCE_CONNECTION_MANAGER);
	_rygel_resource_info_unref0 (info);
	info = _tmp14_;
	_tmp15_ = info;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp15_);
	_tmp16_ = rygel_resource_info_new (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR);
	_rygel_resource_info_unref0 (info);
	info = _tmp16_;
	_tmp17_ = info;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp17_);
	_tmp18_ = root_container;
	_tmp19_ = _tmp18_->child_count;
	if (_tmp19_ == 0) {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		RygelMediaContainer* _tmp22_;
		_tmp20_ = rygel_plugin_get_name ((RygelPlugin*) self);
		_tmp21_ = _tmp20_;
		g_debug ("rygel-media-server-plugin.vala:83: Deactivating plugin '%s' until it p" \
"rovides content.", _tmp21_);
		rygel_plugin_set_active ((RygelPlugin*) self, FALSE);
		_tmp22_ = root_container;
		g_signal_connect_object (_tmp22_, "container-updated", (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self, 0);
	}
	_rygel_resource_info_unref0 (info);
	_g_free0 (path);
	return self;
}


static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaServerPlugin * self;
	RygelV1Hacks* _tmp0_;
	RygelV1Hacks* v1_hacks;
	RygelV1Hacks* _tmp1_;
	RygelRootDevice* _tmp2_;
	const gchar* _tmp3_;
	RygelXBoxHacks* _tmp4_;
	RygelXBoxHacks* xbox_hacks;
	RygelXBoxHacks* _tmp5_;
	RygelRootDevice* _tmp6_;
	RygelV1Hacks* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaServerPlugin*) base;
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
	_tmp0_ = rygel_v1_hacks_new (&_inner_error_);
	v1_hacks = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v1_hacks;
	_tmp2_ = device;
	_tmp3_ = description_path;
	rygel_v1_hacks_apply_on_device (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (v1_hacks);
		return;
	}
	_tmp4_ = rygel_xbox_hacks_new (NULL, &_inner_error_);
	xbox_hacks = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (v1_hacks);
		return;
	}
	_tmp5_ = xbox_hacks;
	_tmp6_ = device;
	_tmp7_ = v1_hacks;
	_tmp8_ = _tmp7_->description_path;
	rygel_xbox_hacks_apply_on_device (_tmp5_, _tmp6_, _tmp8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (xbox_hacks);
		_g_object_unref0 (v1_hacks);
		return;
	}
	_g_object_unref0 (xbox_hacks);
	_g_object_unref0 (v1_hacks);
}


static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	gboolean _tmp5_;
	RygelMediaContainer* _tmp6_;
	guint _tmp7_ = 0U;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_container != NULL);
	g_return_if_fail (updated != NULL);
	g_return_if_fail (object != NULL);
	_tmp1_ = updated;
	_tmp2_ = root_container;
	if (_tmp1_ != _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		RygelMediaContainer* _tmp3_;
		gint _tmp4_;
		_tmp3_ = updated;
		_tmp4_ = _tmp3_->child_count;
		_tmp0_ = _tmp4_ == 0;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = root_container;
	g_signal_parse_name ("container-updated", RYGEL_TYPE_MEDIA_CONTAINER, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self);
	_tmp8_ = rygel_plugin_get_name ((RygelPlugin*) self);
	_tmp9_ = _tmp8_;
	g_debug ("rygel-media-server-plugin.vala:117: Activating plugin '%s' since it no" \
"w provides content.", _tmp9_);
	rygel_plugin_set_active ((RygelPlugin*) self, TRUE);
}


RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root_container;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_root_container);
	self->priv->_root_container = _tmp1_;
	g_object_notify ((GObject *) self, "root-container");
}


static void rygel_media_server_plugin_class_init (RygelMediaServerPluginClass * klass) {
	rygel_media_server_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaServerPluginPrivate));
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_media_server_plugin_real_apply_hacks;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_server_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_server_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_server_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER, g_param_spec_object ("root-container", "root-container", "root-container", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_media_server_plugin_instance_init (RygelMediaServerPlugin * self) {
	self->priv = RYGEL_MEDIA_SERVER_PLUGIN_GET_PRIVATE (self);
}


static void rygel_media_server_plugin_finalize (GObject* obj) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
	_g_object_unref0 (self->priv->_root_container);
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->finalize (obj);
}


/**
 * This is the base class for every Rygel implementation of a UPnP media
 * server. It should be used either for a real plug-in for the Rygel process or used
 * in-process via the librygel-server API.
 */
GType rygel_media_server_plugin_get_type (void) {
	static volatile gsize rygel_media_server_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_server_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaServerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_server_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaServerPlugin), 0, (GInstanceInitFunc) rygel_media_server_plugin_instance_init, NULL };
		GType rygel_media_server_plugin_type_id;
		rygel_media_server_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaServerPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_server_plugin_type_id__volatile, rygel_media_server_plugin_type_id);
	}
	return rygel_media_server_plugin_type_id__volatile;
}


static void _vala_rygel_media_server_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
	switch (property_id) {
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER:
		g_value_set_object (value, rygel_media_server_plugin_get_root_container (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_server_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
	switch (property_id) {
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER:
		rygel_media_server_plugin_set_root_container (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



