/* rygel-content-directory.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-content-directory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <uuid/uuid.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;

#define RYGEL_TYPE_LAST_CHANGE (rygel_last_change_get_type ())
#define RYGEL_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChange))
#define RYGEL_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))
#define RYGEL_IS_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_IS_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_LAST_CHANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))

typedef struct _RygelLastChange RygelLastChange;
typedef struct _RygelLastChangeClass RygelLastChangeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;

#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_LAST_CHANGE_ENTRY (rygel_last_change_entry_get_type ())
#define RYGEL_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntry))
#define RYGEL_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))
#define RYGEL_IS_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_IS_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_LAST_CHANGE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))

typedef struct _RygelLastChangeEntry RygelLastChangeEntry;
typedef struct _RygelLastChangeEntryClass RygelLastChangeEntryClass;

#define RYGEL_TYPE_LAST_CHANGE_ST_DONE (rygel_last_change_st_done_get_type ())
#define RYGEL_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDone))
#define RYGEL_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))
#define RYGEL_IS_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_IS_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_LAST_CHANGE_ST_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))

typedef struct _RygelLastChangeStDone RygelLastChangeStDone;
typedef struct _RygelLastChangeStDoneClass RygelLastChangeStDoneClass;
typedef struct _Block4Data Block4Data;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_ADD (rygel_last_change_obj_add_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAdd))
#define RYGEL_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_LAST_CHANGE_OBJ_ADD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))

typedef struct _RygelLastChangeObjAdd RygelLastChangeObjAdd;
typedef struct _RygelLastChangeObjAddClass RygelLastChangeObjAddClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_MOD (rygel_last_change_obj_mod_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjMod))
#define RYGEL_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_LAST_CHANGE_OBJ_MOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))

typedef struct _RygelLastChangeObjMod RygelLastChangeObjMod;
typedef struct _RygelLastChangeObjModClass RygelLastChangeObjModClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_DEL (rygel_last_change_obj_del_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDel))
#define RYGEL_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_LAST_CHANGE_OBJ_DEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))

typedef struct _RygelLastChangeObjDel RygelLastChangeObjDel;
typedef struct _RygelLastChangeObjDelClass RygelLastChangeObjDelClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelContentDirectoryServiceResetData RygelContentDirectoryServiceResetData;

/**
 * Errors used by ContentDirectory and deriving classes.
 */
typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelContentDirectoryPrivate {
	GeeArrayList* updated_containers;
	GeeArrayList* active_imports;
	GeeArrayList* finished_imports;
	gboolean clear_updated_containers;
	guint update_notify_id;
	RygelLastChange* last_change;
	gchar* service_reset_token;
	gchar* search_caps;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _Block4Data {
	int _ref_count_;
	RygelContentDirectory * self;
	RygelImportResource* import;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
};

struct _RygelContentDirectoryServiceResetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelContentDirectory* self;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaServerPlugin* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* plugin;
	RygelMediaServerPlugin* _tmp7_;
	gchar* _tmp8_;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	RygelRelationalExpression* _tmp12_;
	gchar* _tmp13_;
	RygelRelationalExpression* _tmp14_;
	RygelMediaContainer* _tmp15_;
	RygelSearchableContainer* _tmp16_;
	RygelSearchableContainer* root;
	RygelSearchableContainer* _tmp17_;
	guint32 matches;
	RygelSearchableContainer* _tmp18_;
	RygelRelationalExpression* _tmp19_;
	guint _tmp20_;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* objects;
	RygelMediaObjects* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	guint32 count;
	RygelMediaObjects* _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _object_size;
	gint _object_index;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	RygelMediaObjects* _tmp33_;
	gint _tmp34_;
	gpointer _tmp35_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp36_;
	guint32 _tmp37_;
	RygelMediaObject* _tmp38_;
	RygelMediaObject* _tmp39_;
	RygelMediaContainer* _tmp40_;
	RygelMediaContainer* container;
	RygelMediaContainer* _tmp41_;
	RygelMediaContainer* _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	RygelMediaContainer* _tmp45_;
	guint32 _tmp46_;
	guint32 _tmp47_;
	RygelMediaServerPlugin* _tmp48_;
	const gchar* _tmp49_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_content_directory_parent_class = NULL;

GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_last_change_get_type (void) G_GNUC_CONST;
#define RYGEL_CONTENT_DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryPrivate))
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
static void rygel_content_directory_real_constructed (GObject* base);
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root);
static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
RygelLastChange* rygel_last_change_new (void);
RygelLastChange* rygel_last_change_construct (GType object_type);
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelBrowse* rygel_browse_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_search_get_type (void) G_GNUC_CONST;
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_updater_get_type (void) G_GNUC_CONST;
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine);
static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self);
static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_);
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self);
RygelLastChangeStDone* rygel_last_change_st_done_new (const gchar* id, guint update_id);
RygelLastChangeStDone* rygel_last_change_st_done_construct (GType object_type, const gchar* id, guint update_id);
GType rygel_last_change_entry_get_type (void) G_GNUC_CONST;
GType rygel_last_change_st_done_get_type (void) G_GNUC_CONST;
void rygel_last_change_add_event (RygelLastChange* self, RygelLastChangeEntry* entry);
static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self);
gchar* rygel_last_change_get_log (RygelLastChange* self);
void rygel_last_change_clear_on_new_event (RygelLastChange* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block4Data* _data4_);
static gboolean ___lambda8__gsource_func (gpointer self);
static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
RygelLastChangeObjAdd* rygel_last_change_obj_add_new (const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
RygelLastChangeObjAdd* rygel_last_change_obj_add_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
GType rygel_last_change_obj_add_get_type (void) G_GNUC_CONST;
RygelLastChangeObjMod* rygel_last_change_obj_mod_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjMod* rygel_last_change_obj_mod_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_mod_get_type (void) G_GNUC_CONST;
RygelLastChangeObjDel* rygel_last_change_obj_del_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjDel* rygel_last_change_obj_del_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_del_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_service_reset_data_free (gpointer _data);
static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
RygelContentDirectory* rygel_content_directory_new (void);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
static void rygel_content_directory_finalize (GObject* obj);


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	rygel_content_directory_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
}


static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
	rygel_content_directory_on_sub_tree_updates_finished (self, _sender, sub_tree_root);
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp1_ = NULL;
	guchar* unparsed;
	gint unparsed_length1;
	gint _unparsed_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar _tmp6_;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	_tmp0_ = g_new0 (guchar, 16);
	id = _tmp0_;
	id_length1 = 16;
	_id_size_ = id_length1;
	_tmp1_ = g_new0 (guchar, 51);
	unparsed = _tmp1_;
	unparsed_length1 = 51;
	_unparsed_size_ = unparsed_length1;
	_tmp2_ = id;
	_tmp2__length1 = id_length1;
	uuid_generate (_tmp2_);
	_tmp3_ = id;
	_tmp3__length1 = id_length1;
	_tmp4_ = unparsed;
	_tmp4__length1 = unparsed_length1;
	uuid_unparse (_tmp3_, _tmp4_);
	_tmp5_ = unparsed;
	_tmp5__length1 = unparsed_length1;
	_tmp5_[50] = (guchar) '\0';
	_tmp6_ = _tmp5_[50];
	_tmp7_ = unparsed;
	_tmp7__length1 = unparsed_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	unparsed = (g_free (unparsed), NULL);
	id = (g_free (id), NULL);
	return result;
}


static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_browse_cb (self, _sender, action);
}


static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_search_cb (self, _sender, action);
}


static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_create_object_cb (self, _sender, action);
}


static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_destroy_object_cb (self, _sender, action);
}


static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_update_object_cb (self, _sender, action);
}


static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_import_resource_cb (self, _sender, action);
}


static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_transfer_progress_cb (self, _sender, action);
}


static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_stop_transfer_resource_cb (self, _sender, action);
}


static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_transfer_ids (self, _sender, variable, value);
}


static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_system_update_id_cb (self, _sender, action);
}


static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_system_update_id (self, _sender, variable, value);
}


static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_container_update_ids (self, _sender, variable, value);
}


static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_search_capabilities_cb (self, _sender, action);
}


static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_search_capabilities (self, _sender, variable, value);
}


static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_sort_capabilities_cb (self, _sender, action);
}


static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_sort_capabilities (self, _sender, variable, value);
}


static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_feature_list_cb (self, _sender, action);
}


static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_feature_list (self, _sender, variable, value);
}


static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_last_change (self, _sender, variable, value);
}


static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_service_reset_token (self, _sender, variable, value);
}


static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_service_reset_token_cb (self, _sender, action);
}


static void rygel_content_directory_real_constructed (GObject* base) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_;
	GUPnPRootDevice* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	GUPnPResourceFactory* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* _tmp7_;
	RygelMediaServerPlugin* plugin;
	RygelMediaServerPlugin* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	RygelMediaContainer* _tmp11_;
	RygelMediaServerPlugin* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	RygelHTTPServer* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	RygelMediaContainer* _tmp19_;
	RygelMediaContainer* _tmp20_;
	RygelLastChange* _tmp21_;
	gchar* _tmp22_;
	RygelMediaServerPlugin* _tmp23_;
	RygelPluginCapabilities _tmp24_;
	RygelPluginCapabilities _tmp25_;
	gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	RygelHTTPServer* _tmp30_;
	self = (RygelContentDirectory*) base;
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp0_;
	g_object_get ((GUPnPService*) self, "root-device", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	plugin = _tmp7_;
	_tmp8_ = plugin;
	_tmp9_ = rygel_media_server_plugin_get_root_container (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp11_;
	_tmp12_ = plugin;
	_tmp13_ = rygel_plugin_get_name ((RygelPlugin*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = rygel_http_server_new (self, _tmp14_);
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp15_;
	_tmp16_ = gee_array_list_new (RYGEL_TYPE_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->updated_containers);
	self->priv->updated_containers = _tmp16_;
	_tmp17_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_imports);
	self->priv->active_imports = _tmp17_;
	_tmp18_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->finished_imports);
	self->priv->finished_imports = _tmp18_;
	_tmp19_ = self->root_container;
	g_signal_connect_object (_tmp19_, "container-updated", (GCallback) _rygel_content_directory_on_container_updated_rygel_media_container_container_updated, self, 0);
	_tmp20_ = self->root_container;
	g_signal_connect_object (_tmp20_, "sub-tree-updates-finished", (GCallback) _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
	_tmp21_ = rygel_last_change_new ();
	_g_object_unref0 (self->priv->last_change);
	self->priv->last_change = _tmp21_;
	_tmp22_ = g_strdup (RYGEL_RELATIONAL_EXPRESSION_CAPS);
	_g_free0 (self->priv->search_caps);
	self->priv->search_caps = _tmp22_;
	_tmp23_ = plugin;
	_tmp24_ = rygel_plugin_get_capabilities ((RygelPlugin*) _tmp23_);
	_tmp25_ = _tmp24_;
	if ((_tmp25_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp26_ = self->priv->search_caps;
		_tmp27_ = g_strconcat (_tmp26_, ",upnp:objectUpdateID,upnp:containerUpdateID", NULL);
		_g_free0 (self->priv->search_caps);
		self->priv->search_caps = _tmp27_;
	}
	_tmp28_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<Features xmlns=\"urn:schemas-upnp-org:av:avs\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:av:avs" "http://www.upnp.org/schemas/av/avs-v1-20060531.xsd\">" "</Features>");
	_g_free0 (self->feature_list);
	self->feature_list = _tmp28_;
	_tmp29_ = uuid_get ();
	_g_free0 (self->priv->service_reset_token);
	self->priv->service_reset_token = _tmp29_;
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Browse", (GCallback) _rygel_content_directory_browse_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Search", (GCallback) _rygel_content_directory_search_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateObject", (GCallback) _rygel_content_directory_create_object_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::DestroyObject", (GCallback) _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::UpdateObject", (GCallback) _rygel_content_directory_update_object_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ImportResource", (GCallback) _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransferProgress", (GCallback) _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::StopTransferResource", (GCallback) _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TransferIDs", (GCallback) _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSystemUpdateID", (GCallback) _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SystemUpdateID", (GCallback) _rygel_content_directory_query_system_update_id_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ContainerUpdateIDs", (GCallback) _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSearchCapabilities", (GCallback) _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SearchCapabilities", (GCallback) _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSortCapabilities", (GCallback) _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SortCapabilities", (GCallback) _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetFeatureList", (GCallback) _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::FeatureList", (GCallback) _rygel_content_directory_query_feature_list_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_content_directory_query_last_change_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ServiceResetToken", (GCallback) _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetServiceResetToken", (GCallback) _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked, self, 0);
	_tmp30_ = self->http_server;
	rygel_state_machine_run ((RygelStateMachine*) _tmp30_, NULL, NULL);
	_g_object_unref0 (plugin);
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}


static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelBrowse* _tmp2_;
	RygelBrowse* browse;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_browse_new (self, _tmp1_);
	browse = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) browse, NULL, NULL);
	_g_object_unref0 (browse);
}


static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelSearch* _tmp2_;
	RygelSearch* search;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_search_new (self, _tmp1_);
	search = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) search, NULL, NULL);
	_g_object_unref0 (search);
}


static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelItemCreator* _tmp2_;
	RygelItemCreator* creator;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_item_creator_new (self, _tmp1_);
	creator = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
	_g_object_unref0 (creator);
}


static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelItemDestroyer* _tmp2_;
	RygelItemDestroyer* destroyer;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_item_destroyer_new (self, _tmp1_);
	destroyer = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) destroyer, NULL, NULL);
	_g_object_unref0 (destroyer);
}


static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelItemUpdater* _tmp2_;
	RygelItemUpdater* updater;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_item_updater_new (self, _tmp1_);
	updater = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) updater, NULL, NULL);
	_g_object_unref0 (updater);
}


static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_content_directory_on_import_completed (self, _sender);
}


static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelImportResource* _tmp2_;
	RygelImportResource* import;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_import_resource_new (self, _tmp1_);
	import = _tmp2_;
	g_signal_connect_object ((RygelStateMachine*) import, "completed", (GCallback) _rygel_content_directory_on_import_completed_rygel_state_machine_completed, self, 0);
	_tmp3_ = self->priv->active_imports;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, import);
	rygel_state_machine_run ((RygelStateMachine*) import, NULL, NULL);
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
	_tmp5_ = _tmp4_;
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_g_object_unref0 (import);
}


static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = rygel_content_directory_create_transfer_ids (self);
	_tmp1_ = _tmp0_;
	g_value_set_string (value, _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	RygelImportResource* _tmp5_ = NULL;
	RygelImportResource* import;
	RygelImportResource* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_);
	import = _tmp5_;
	_tmp6_ = import;
	if (_tmp6_ != NULL) {
		GUPnPServiceAction* _tmp7_;
		RygelImportResource* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		RygelImportResource* _tmp11_;
		gint64 _tmp12_;
		RygelImportResource* _tmp13_;
		gint64 _tmp14_;
		GUPnPServiceAction* _tmp15_;
		_tmp7_ = action;
		_tmp8_ = import;
		_tmp9_ = rygel_import_resource_get_status_as_string (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = import;
		_tmp12_ = _tmp11_->bytes_copied;
		_tmp13_ = import;
		_tmp14_ = _tmp13_->bytes_total;
		gupnp_service_action_set (_tmp7_, "TransferStatus", G_TYPE_STRING, _tmp10_, "TransferLength", G_TYPE_INT64, _tmp12_, "TransferTotal", G_TYPE_INT64, _tmp14_, NULL);
		_tmp15_ = action;
		gupnp_service_action_return (_tmp15_);
	} else {
		GUPnPServiceAction* _tmp16_;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = action;
		_tmp17_ = _ ("No such file transfer");
		gupnp_service_action_return_error (_tmp16_, (guint) 717, _tmp17_);
	}
	_g_object_unref0 (import);
}


static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	RygelImportResource* _tmp5_ = NULL;
	RygelImportResource* import;
	RygelImportResource* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_);
	import = _tmp5_;
	_tmp6_ = import;
	if (_tmp6_ != NULL) {
		RygelImportResource* _tmp7_;
		GCancellable* _tmp8_;
		GCancellable* _tmp9_;
		GUPnPServiceAction* _tmp10_;
		_tmp7_ = import;
		_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp7_);
		_tmp9_ = _tmp8_;
		g_cancellable_cancel (_tmp9_);
		_tmp10_ = action;
		gupnp_service_action_return (_tmp10_);
	} else {
		GUPnPServiceAction* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = action;
		_tmp12_ = _ ("No such file transfer");
		gupnp_service_action_return_error (_tmp11_, (guint) 717, _tmp12_);
	}
	_g_object_unref0 (import);
}


static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	guint32 _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = self->system_update_id;
	gupnp_service_action_set (_tmp4_, "Id", G_TYPE_UINT, _tmp5_, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_UINT);
	_tmp0_ = self->system_update_id;
	g_value_set_uint (value, (guint) _tmp0_);
}


static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* update_ids;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
	update_ids = _tmp0_;
	g_value_init (value, G_TYPE_STRING);
	g_value_set_string (value, update_ids);
	_g_free0 (update_ids);
}


static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	gupnp_service_action_set (_tmp4_, "SearchCaps", G_TYPE_STRING, RYGEL_RELATIONAL_EXPRESSION_CAPS, NULL);
	_tmp5_ = action;
	gupnp_service_action_return (_tmp5_);
}


static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	g_value_set_string (value, RYGEL_RELATIONAL_EXPRESSION_CAPS);
}


static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	gupnp_service_action_set (_tmp4_, "SortCaps", G_TYPE_STRING, RYGEL_MEDIA_OBJECTS_SORT_CAPS, NULL);
	_tmp5_ = action;
	gupnp_service_action_return (_tmp5_);
}


static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	g_value_set_string (value, RYGEL_MEDIA_OBJECTS_SORT_CAPS);
}


static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = self->feature_list;
	gupnp_service_action_set (_tmp4_, "FeatureList", G_TYPE_STRING, _tmp5_, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = self->feature_list;
	g_value_set_string (value, _tmp0_);
}


static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* update_ids;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	update_ids = _tmp0_;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _container_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _container_size;
		gint _container_index;
		_tmp1_ = self->priv->updated_containers;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_container_list = _tmp2_;
		_tmp3_ = _container_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_container_size = _tmp5_;
		_container_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelMediaContainer* container;
			const gchar* _tmp12_;
			const gchar* _tmp15_;
			RygelMediaContainer* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			RygelMediaContainer* _tmp21_;
			guint32 _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp6_ = _container_index;
			_container_index = _tmp6_ + 1;
			_tmp7_ = _container_index;
			_tmp8_ = _container_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _container_list;
			_tmp10_ = _container_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			container = (RygelMediaContainer*) _tmp11_;
			_tmp12_ = update_ids;
			if (g_strcmp0 (_tmp12_, "") != 0) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = update_ids;
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
				_g_free0 (update_ids);
				update_ids = _tmp14_;
			}
			_tmp15_ = update_ids;
			_tmp16_ = container;
			_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = container;
			_tmp22_ = _tmp21_->update_id;
			_tmp23_ = g_strdup_printf ("%u", _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp20_, _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp15_, _tmp26_, NULL);
			_g_free0 (update_ids);
			update_ids = _tmp27_;
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp20_);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_list);
	}
	result = update_ids;
	return result;
}


/**
     * handler for container_updated signal on root_container. We don't
     * immediately send the notification for changes but schedule the
     * notification after 0.2 seconds. Also we don't clear the updated
     * container list immediately after notification but rather in this
     * function. Please refer to ContentDirectory version 2 specs for details
     * on why we do all this the way we do.
     *
     * @param root_container the root_container
     * @param updated_container the container that just got updated
     */
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	guint32 _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelObjectEventType _tmp2_;
	gboolean _tmp3_;
	GUPnPRootDevice* _tmp4_ = NULL;
	GUPnPRootDevice* _tmp5_;
	GUPnPRootDevice* _tmp6_;
	GUPnPResourceFactory* _tmp7_;
	GUPnPResourceFactory* _tmp8_;
	RygelMediaServerPlugin* _tmp9_;
	RygelMediaServerPlugin* _tmp10_;
	RygelMediaServerPlugin* plugin;
	gboolean _tmp11_ = FALSE;
	guint32 _tmp12_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	RygelObjectEventType _tmp18_;
	gboolean _tmp20_;
	gboolean _tmp27_;
	GeeArrayList* _tmp29_;
	RygelMediaContainer* _tmp30_;
	GeeArrayList* _tmp31_;
	RygelMediaContainer* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_container != NULL);
	g_return_if_fail (updated_container != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = self->system_update_id;
	self->system_update_id = _tmp0_ + 1;
	_tmp1_ = object;
	_tmp2_ = event_type;
	_tmp3_ = sub_tree_update;
	rygel_content_directory_add_last_change_entry (self, _tmp1_, _tmp2_, _tmp3_);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp8_) : NULL);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp6_);
	plugin = _tmp10_;
	_tmp12_ = self->system_update_id;
	if (_tmp12_ == ((guint32) 0)) {
		RygelMediaServerPlugin* _tmp13_;
		RygelPluginCapabilities _tmp14_;
		RygelPluginCapabilities _tmp15_;
		_tmp13_ = plugin;
		_tmp14_ = rygel_plugin_get_capabilities ((RygelPlugin*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = (_tmp15_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = _tmp11_;
	if (_tmp16_) {
		rygel_content_directory_service_reset (self, NULL, NULL);
		_g_object_unref0 (plugin);
		return;
	}
	_tmp18_ = event_type;
	if (_tmp18_ == RYGEL_OBJECT_EVENT_TYPE_ADDED) {
		_tmp17_ = TRUE;
	} else {
		RygelObjectEventType _tmp19_;
		_tmp19_ = event_type;
		_tmp17_ = _tmp19_ == RYGEL_OBJECT_EVENT_TYPE_DELETED;
	}
	_tmp20_ = _tmp17_;
	if (_tmp20_) {
		RygelMediaContainer* _tmp21_;
		guint32 _tmp22_;
		RygelMediaObject* _tmp23_;
		guint32 _tmp24_;
		_tmp21_ = updated_container;
		_tmp22_ = self->system_update_id;
		_tmp21_->update_id = _tmp22_;
		_tmp23_ = object;
		_tmp24_ = self->system_update_id;
		rygel_media_object_set_object_update_id (_tmp23_, (guint) _tmp24_);
	} else {
		RygelMediaObject* _tmp25_;
		guint32 _tmp26_;
		_tmp25_ = object;
		_tmp26_ = self->system_update_id;
		rygel_media_object_set_object_update_id (_tmp25_, (guint) _tmp26_);
	}
	_tmp27_ = self->priv->clear_updated_containers;
	if (_tmp27_) {
		GeeArrayList* _tmp28_;
		_tmp28_ = self->priv->updated_containers;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp28_);
		self->priv->clear_updated_containers = FALSE;
	}
	_tmp29_ = self->priv->updated_containers;
	_tmp30_ = updated_container;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp29_, _tmp30_);
	_tmp31_ = self->priv->updated_containers;
	_tmp32_ = updated_container;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
	rygel_content_directory_ensure_timeout (self);
	_g_object_unref0 (plugin);
}


static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root) {
	RygelMediaObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint32 _tmp3_;
	RygelLastChangeStDone* _tmp4_;
	RygelLastChangeStDone* entry;
	RygelLastChange* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_container != NULL);
	g_return_if_fail (sub_tree_root != NULL);
	_tmp0_ = sub_tree_root;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->system_update_id;
	_tmp4_ = rygel_last_change_st_done_new (_tmp2_, (guint) _tmp3_);
	entry = _tmp4_;
	_tmp5_ = self->priv->last_change;
	rygel_last_change_add_event (_tmp5_, (RygelLastChangeEntry*) entry);
	rygel_content_directory_ensure_timeout (self);
	_g_object_unref0 (entry);
}


static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* update_ids;
	guint32 _tmp1_;
	RygelLastChange* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelLastChange* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
	update_ids = _tmp0_;
	gupnp_service_notify ((GUPnPService*) self, "ContainerUpdateIDs", G_TYPE_STRING, update_ids, NULL);
	_tmp1_ = self->system_update_id;
	gupnp_service_notify ((GUPnPService*) self, "SystemUpdateID", G_TYPE_UINT, _tmp1_, NULL);
	_tmp2_ = self->priv->last_change;
	_tmp3_ = rygel_last_change_get_log (_tmp2_);
	_tmp4_ = _tmp3_;
	gupnp_service_notify ((GUPnPService*) self, "LastChange", G_TYPE_STRING, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	self->priv->clear_updated_containers = TRUE;
	self->priv->update_notify_id = (guint) 0;
	_tmp5_ = self->priv->last_change;
	rygel_last_change_clear_on_new_event (_tmp5_);
	result = FALSE;
	_g_free0 (update_ids);
	return result;
}


static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ids;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ids = _tmp0_;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _import_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _import_size;
		gint _import_index;
		_tmp1_ = self->priv->active_imports;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_import_list = _tmp2_;
		_tmp3_ = _import_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_import_size = _tmp5_;
		_import_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelImportResource* import;
			const gchar* _tmp12_;
			const gchar* _tmp15_;
			RygelImportResource* _tmp16_;
			guint32 _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp6_ = _import_index;
			_import_index = _tmp6_ + 1;
			_tmp7_ = _import_index;
			_tmp8_ = _import_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _import_list;
			_tmp10_ = _import_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			import = (RygelImportResource*) _tmp11_;
			_tmp12_ = ids;
			if (g_strcmp0 (_tmp12_, "") != 0) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = ids;
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
				_g_free0 (ids);
				ids = _tmp14_;
			}
			_tmp15_ = ids;
			_tmp16_ = import;
			_tmp17_ = _tmp16_->transfer_id;
			_tmp18_ = g_strdup_printf ("%u", _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
			_g_free0 (ids);
			ids = _tmp20_;
			_g_free0 (_tmp19_);
			_g_object_unref0 (import);
		}
		_g_object_unref0 (_import_list);
	}
	result = ids;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		RygelContentDirectory * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->import);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda8_ (Block4Data* _data4_) {
	RygelContentDirectory * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	self = _data4_->self;
	_tmp0_ = self->priv->finished_imports;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data4_->import);
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine) {
	Block4Data* _data4_;
	RygelStateMachine* _tmp0_;
	RygelImportResource* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = machine;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_IMPORT_RESOURCE) ? ((RygelImportResource*) _tmp0_) : NULL);
	_data4_->import = _tmp1_;
	_tmp2_ = self->priv->finished_imports;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _data4_->import);
	_tmp3_ = self->priv->active_imports;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _data4_->import);
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
	_tmp5_ = _tmp4_;
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda8__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action) {
	RygelImportResource* result = NULL;
	RygelImportResource* ret;
	guint32 transfer_id = 0U;
	GUPnPServiceAction* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	ret = NULL;
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "TransferID", G_TYPE_UINT, &transfer_id, NULL);
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _import_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _import_size;
		gint _import_index;
		_tmp1_ = self->priv->active_imports;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_import_list = _tmp2_;
		_tmp3_ = _import_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_import_size = _tmp5_;
		_import_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelImportResource* import;
			RygelImportResource* _tmp12_;
			guint32 _tmp13_;
			guint32 _tmp14_;
			_tmp6_ = _import_index;
			_import_index = _tmp6_ + 1;
			_tmp7_ = _import_index;
			_tmp8_ = _import_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _import_list;
			_tmp10_ = _import_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			import = (RygelImportResource*) _tmp11_;
			_tmp12_ = import;
			_tmp13_ = _tmp12_->transfer_id;
			_tmp14_ = transfer_id;
			if (_tmp13_ == _tmp14_) {
				RygelImportResource* _tmp15_;
				RygelImportResource* _tmp16_;
				_tmp15_ = import;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (ret);
				ret = _tmp16_;
				_g_object_unref0 (import);
				break;
			}
			_g_object_unref0 (import);
		}
		_g_object_unref0 (_import_list);
	}
	{
		GeeArrayList* _tmp17_;
		GeeArrayList* _tmp18_;
		GeeArrayList* _import_list;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _import_size;
		gint _import_index;
		_tmp17_ = self->priv->finished_imports;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_import_list = _tmp18_;
		_tmp19_ = _import_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_import_size = _tmp21_;
		_import_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_ = NULL;
			RygelImportResource* import;
			RygelImportResource* _tmp28_;
			guint32 _tmp29_;
			guint32 _tmp30_;
			_tmp22_ = _import_index;
			_import_index = _tmp22_ + 1;
			_tmp23_ = _import_index;
			_tmp24_ = _import_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _import_list;
			_tmp26_ = _import_index;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
			import = (RygelImportResource*) _tmp27_;
			_tmp28_ = import;
			_tmp29_ = _tmp28_->transfer_id;
			_tmp30_ = transfer_id;
			if (_tmp29_ == _tmp30_) {
				RygelImportResource* _tmp31_;
				RygelImportResource* _tmp32_;
				_tmp31_ = import;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				_g_object_unref0 (ret);
				ret = _tmp32_;
				_g_object_unref0 (import);
				break;
			}
			_g_object_unref0 (import);
		}
		_g_object_unref0 (_import_list);
	}
	result = ret;
	return result;
}


static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	RygelLastChange* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = self->priv->last_change;
	_tmp1_ = rygel_last_change_get_log (_tmp0_);
	_tmp2_ = _tmp1_;
	g_value_set_string (value, _tmp2_);
	_g_free0 (_tmp2_);
}


static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_content_directory_update_notify (self);
	return result;
}


static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->update_notify_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_content_directory_update_notify_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->update_notify_id = _tmp1_;
	}
}


static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelLastChangeEntry* entry = NULL;
	RygelObjectEventType _tmp0_;
	RygelLastChange* _tmp26_;
	RygelLastChangeEntry* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = event_type;
	switch (_tmp0_) {
		case RYGEL_OBJECT_EVENT_TYPE_ADDED:
		{
			RygelMediaObject* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			guint32 _tmp4_;
			gboolean _tmp5_;
			RygelMediaObject* _tmp6_;
			RygelMediaContainer* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			RygelMediaObject* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			RygelLastChangeObjAdd* _tmp13_;
			_tmp1_ = object;
			_tmp2_ = rygel_media_object_get_id (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = self->system_update_id;
			_tmp5_ = sub_tree_update;
			_tmp6_ = object;
			_tmp7_ = _tmp6_->parent;
			_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = object;
			_tmp11_ = rygel_media_object_get_upnp_class (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = rygel_last_change_obj_add_new (_tmp3_, (guint) _tmp4_, _tmp5_, _tmp9_, _tmp12_);
			_g_object_unref0 (entry);
			entry = (RygelLastChangeEntry*) _tmp13_;
			break;
		}
		case RYGEL_OBJECT_EVENT_TYPE_MODIFIED:
		{
			RygelMediaObject* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			guint32 _tmp17_;
			gboolean _tmp18_;
			RygelLastChangeObjMod* _tmp19_;
			_tmp14_ = object;
			_tmp15_ = rygel_media_object_get_id (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = self->system_update_id;
			_tmp18_ = sub_tree_update;
			_tmp19_ = rygel_last_change_obj_mod_new (_tmp16_, (guint) _tmp17_, _tmp18_);
			_g_object_unref0 (entry);
			entry = (RygelLastChangeEntry*) _tmp19_;
			break;
		}
		case RYGEL_OBJECT_EVENT_TYPE_DELETED:
		{
			RygelMediaObject* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			guint32 _tmp23_;
			gboolean _tmp24_;
			RygelLastChangeObjDel* _tmp25_;
			_tmp20_ = object;
			_tmp21_ = rygel_media_object_get_id (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->system_update_id;
			_tmp24_ = sub_tree_update;
			_tmp25_ = rygel_last_change_obj_del_new (_tmp22_, (guint) _tmp23_, _tmp24_);
			_g_object_unref0 (entry);
			entry = (RygelLastChangeEntry*) _tmp25_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp26_ = self->priv->last_change;
	_tmp27_ = entry;
	rygel_last_change_add_event (_tmp26_, _tmp27_);
	_g_object_unref0 (entry);
}


static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = self->priv->service_reset_token;
	gupnp_service_action_set (_tmp0_, "ResetToken", G_TYPE_STRING, _tmp1_, NULL);
	_tmp2_ = action;
	gupnp_service_action_return (_tmp2_);
}


static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = self->priv->service_reset_token;
	g_value_set_string (value, _tmp0_);
}


static void rygel_content_directory_service_reset_data_free (gpointer _data) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelContentDirectoryServiceResetData, _data_);
}


static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
	RygelContentDirectory* _tmp0_;
	_data_ = g_slice_new0 (RygelContentDirectoryServiceResetData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_content_directory_service_reset);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_content_directory_service_reset_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_content_directory_service_reset_co (_data_);
}


static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_content_directory_service_reset_co (_data_);
}


static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("rygel-content-directory.vala:607: SystemUpdateID overflow, initiating " \
"service reset procedure");
	_data_->_tmp0_ = NULL;
	g_object_get ((GUPnPService*) _data_->self, "root-device", &_data_->_tmp0_, NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _data_->_tmp4_) : NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->plugin = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->plugin;
	rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp7_, FALSE);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = uuid_get ();
	_g_free0 (_data_->self->priv->service_reset_token);
	_data_->self->priv->service_reset_token = _data_->_tmp8_;
	_data_->_tmp9_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->expression;
	_data_->_tmp11_ = g_strdup ("upnp:objectUpdateID");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->expression;
	_data_->_tmp13_ = g_strdup ("true");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp12_)->operand2);
	((RygelSearchExpression*) _data_->_tmp12_)->operand2 = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp14_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
	{
		_data_->_tmp15_ = _data_->self->root_container;
		_data_->_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp15_) : NULL);
		_data_->root = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->root;
		if (_data_->_tmp17_ == NULL) {
			_g_object_unref0 (_data_->root);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_object_unref0 (_data_->plugin);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->matches = (guint32) 0;
		_data_->_tmp18_ = _data_->root;
		_data_->_tmp19_ = _data_->expression;
		_data_->_tmp20_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_search (_data_->_tmp18_, (RygelSearchExpression*) _data_->_tmp19_, (guint) 0, (guint) 0, "", NULL, rygel_content_directory_service_reset_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp18_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
		_data_->matches = (guint32) _data_->_tmp20_;
		_data_->objects = _data_->_tmp21_;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->root);
			goto __catch20_g_error;
		}
		_data_->_tmp22_ = _data_->objects;
		_data_->_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		if (_data_->_tmp24_ > 0) {
			_data_->count = (guint32) 1;
			{
				_data_->_tmp25_ = _data_->objects;
				_data_->_tmp26_ = _g_object_ref0 (_data_->_tmp25_);
				_data_->_object_list = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->_object_list;
				_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_object_size = _data_->_tmp29_;
				_data_->_object_index = -1;
				while (TRUE) {
					_data_->_tmp30_ = _data_->_object_index;
					_data_->_object_index = _data_->_tmp30_ + 1;
					_data_->_tmp31_ = _data_->_object_index;
					_data_->_tmp32_ = _data_->_object_size;
					if (!(_data_->_tmp31_ < _data_->_tmp32_)) {
						break;
					}
					_data_->_tmp33_ = _data_->_object_list;
					_data_->_tmp34_ = _data_->_object_index;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp33_, _data_->_tmp34_);
					_data_->object = (RygelMediaObject*) _data_->_tmp35_;
					_data_->_tmp36_ = _data_->object;
					_data_->_tmp37_ = _data_->count;
					_data_->count = _data_->_tmp37_ + 1;
					rygel_media_object_set_object_update_id (_data_->_tmp36_, (guint) _data_->_tmp37_);
					_data_->_tmp38_ = _data_->object;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp38_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
						_data_->_tmp39_ = _data_->object;
						_data_->_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp39_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp39_) : NULL);
						_data_->container = _data_->_tmp40_;
						_data_->_tmp41_ = _data_->container;
						_data_->_tmp42_ = _data_->container;
						_data_->_tmp43_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) _data_->_tmp42_);
						_data_->_tmp44_ = _data_->_tmp43_;
						_data_->_tmp41_->update_id = (guint32) _data_->_tmp44_;
						_data_->_tmp45_ = _data_->container;
						_data_->_tmp45_->total_deleted_child_count = (gint64) 0;
						_g_object_unref0 (_data_->container);
					}
					_g_object_unref0 (_data_->object);
				}
				_g_object_unref0 (_data_->_object_list);
			}
			_data_->_tmp46_ = _data_->count;
			_data_->self->system_update_id = _data_->_tmp46_ - 1;
			_data_->_tmp47_ = _data_->self->system_update_id;
			g_debug ("rygel-content-directory.vala:645: New SystemUpdateID is %u", (guint) _data_->_tmp47_);
		}
		g_debug ("rygel-content-directory.vala:648: Service reset procedure done, device" \
" coming up again");
		_data_->_tmp48_ = _data_->plugin;
		rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp48_, TRUE);
		_data_->_tmp49_ = _data_->self->priv->service_reset_token;
		g_debug ("rygel-content-directory.vala:650: New service reset token is %s", _data_->_tmp49_);
		_g_object_unref0 (_data_->objects);
		_g_object_unref0 (_data_->root);
	}
	goto __finally20;
	__catch20_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		g_warning ("rygel-content-directory.vala:651: Failed to search for objects...");
		_g_error_free0 (_data_->_error_);
	}
	__finally20:
	if (_data_->_inner_error_ != NULL) {
		_rygel_search_expression_unref0 (_data_->expression);
		_g_object_unref0 (_data_->plugin);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->plugin);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self = NULL;
	self = (RygelContentDirectory*) g_object_new (object_type, NULL);
	return self;
}


RygelContentDirectory* rygel_content_directory_new (void) {
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelContentDirectoryPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_content_directory_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
	self->priv = RYGEL_CONTENT_DIRECTORY_GET_PRIVATE (self);
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory);
	_tmp0_ = self->cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_free0 (self->feature_list);
	_g_object_unref0 (self->http_server);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->priv->updated_containers);
	_g_object_unref0 (self->priv->active_imports);
	_g_object_unref0 (self->priv->finished_imports);
	_g_object_unref0 (self->cancellable);
	_g_object_unref0 (self->priv->last_change);
	_g_free0 (self->priv->service_reset_token);
	_g_free0 (self->priv->search_caps);
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
}


/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override create_root_container method.
 */
GType rygel_content_directory_get_type (void) {
	static volatile gsize rygel_content_directory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_content_directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		GType rygel_content_directory_type_id;
		rygel_content_directory_type_id = g_type_register_static (gupnp_service_get_type (), "RygelContentDirectory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_content_directory_type_id__volatile, rygel_content_directory_type_id);
	}
	return rygel_content_directory_type_id__volatile;
}



