/**
 * SECTION:rygel-data-source
 * @short_description: Interface for all data streams from a media engine. The data source is responsible for providing the streamable byte-stream via its data_available signal. End-of-stream is signalled through the done signal, while errors are signalled by using the error signal.
 * 
 * <para># The only required URI scheme is file:/""/ # A DataSource should be able to stream any kind of binary data, regardless of the format</para>
 */
/**
 * RygelDataSourceError
 */
/**
 * rygel_data_source_start
 * @self: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance
 * @offsets: (in) (allow-none): optional limits of the stream for partial streaming 
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Start producing the data.
 */
/**
 * rygel_data_source_freeze
 * @self: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance
 * 
 * Temporarily stop data generation.
 * 
 * <para>May be called multiple times. If the source is already frozen, the following calles to freeze are ignored. After callging freeze(), so data_available() signal should be emitted.</para>
 */
/**
 * rygel_data_source_thaw
 * @self: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance
 * 
 * Resume data generation from a previous freeze call.
 * 
 * <para>May be called multiple times, will be ignored if the source is not frozen.</para>
 */
/**
 * rygel_data_source_stop
 * @self: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance
 * 
 * Stop producing data. After calling stop(), calling start() should produce data from the beginning and not resume streaming.
 */
/**
 * RygelDataSource::data-available
 * @data_source: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance that received the signal
 * @data_length1: length of the @data array
 * @data: 
 * 
 * Emitted when the source has produced some data.
 */
/**
 * RygelDataSource::done
 * @data_source: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance that received the signal
 * 
 * Emitted when the source does not have data anymore.
 */
/**
 * RygelDataSource::error
 * @data_source: the <link linkend="RygelDataSource"><type>RygelDataSource</type></link> instance that received the signal
 * @error: 
 * 
 * Emitted when the source encounters a problem during data generation.
 */
/**
 * RygelDataSource
 * 
 * Interface for all data streams from a media engine. The data source is responsible for providing the streamable byte-stream via its data_available signal. End-of-stream is signalled through the done signal, while errors are signalled by using the error signal.
 * 
 * <para># The only required URI scheme is file:/""/ # A DataSource should be able to stream any kind of binary data, regardless of the format</para>
 */
