/**
 * SECTION:rygel-media-engine
 * @short_description: Data class representing a DLNA profile. It contains the name and the corresponding DLNA mime type.
 * 
 * <note><para>The mime type can deviate from mime types typically used elsewhere. </para></note>
 */
/**
 * RYGEL_TYPE_DLNA_PROFILE
 * 
 * The type for <link linkend="RygelDLNAProfile"><type>RygelDLNAProfile</type></link>.
 */
/**
 * rygel_dlna_profile_new
 */
/**
 * rygel_dlna_profile_compare_by_name
 * 
 * Compare two DLNA profiles by name
 */
/**
 * RygelDLNAProfile
 * 
 * Data class representing a DLNA profile. It contains the name and the corresponding DLNA mime type.
 * 
 * <note><para>The mime type can deviate from mime types typically used elsewhere. </para></note>
 */
/**
 * rygel_dlna_profile_ref
 * @instance: a <link linkend="RygelDLNAProfile"><type>RygelDLNAProfile</type></link>.
 * 
 * Increases the reference count of @object.
 * 
 * Returns: the same @object
 */
/**
 * rygel_dlna_profile_unref
 * @instance: a <link linkend="RygelDLNAProfile"><type>RygelDLNAProfile</type></link>.
 * 
 * Decreases the reference count of @object. When its reference count drops to 0, the object is finalized (i.e. its memory is freed).
 */
/**
 * rygel_param_spec_dlna_profile
 * @name: canonical name of the property specified
 * @nick: nick name for the property specified
 * @blurb: description of the property specified
 * @object_type: <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived type of this property
 * @flags: flags for the property specified
 * 
 * Creates a new <link linkend="GParamSpecBoxed"><type>GParamSpecBoxed</type></link> instance specifying a <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived property.
 * 
 * See <link linkend="g-param-spec-internal"><function>g_param_spec_internal()</function></link> for details on property names.
 */
/**
 * rygel_value_set_dlna_profile
 * @value: a valid <link linkend="GValue"><type>GValue</type></link> of <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived type
 * @v_object: object value to be set
 * 
 * Set the contents of a <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived <link linkend="GValue"><type>GValue</type></link> to @v_object.
 * 
 * <link linkend="rygel-value-set-dlna-profile"><function>rygel_value_set_dlna_profile()</function></link> increases the reference count of @v_object (the <link linkend="GValue"><type>GValue</type></link> holds a reference to @v_object). If you do not wish to increase the reference count of the object (i.e. you wish to pass your current reference to the <link linkend="GValue"><type>GValue</type></link> because you no longer need it), use <link linkend="rygel-value-take-dlna-profile"><function>rygel_value_take_dlna_profile()</function></link> instead.
 * 
 * It is important that your <link linkend="GValue"><type>GValue</type></link> holds a reference to @v_object (either its own, or one it has taken) to ensure that the object won't be destroyed while the <link linkend="GValue"><type>GValue</type></link> still exists).
 */
/**
 * rygel_value_get_dlna_profile
 * @value: a valid <link linkend="GValue"><type>GValue</type></link> of <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived type
 * 
 * Get the contents of a <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived <link linkend="GValue"><type>GValue</type></link>.
 * 
 * Returns: object contents of @value
 */
/**
 * rygel_value_take_dlna_profile
 * @value: a valid <link linkend="GValue"><type>GValue</type></link> of <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived type
 * @v_object: object value to be set
 * 
 * Sets the contents of a <link linkend="RYGEL-TYPE-DLNA-PROFILE:CAPS"><literal>RYGEL_TYPE_DLNA_PROFILE</literal></link> derived <link linkend="GValue"><type>GValue</type></link> to @v_object and takes over the ownership of the callers reference to @v_object; the caller doesn't have to unref it any more (i.e. the reference count of the object is not increased).
 * 
 * If you want the GValue to hold its own reference to @v_object, use <link linkend="rygel-value-set-dlna-profile"><function>rygel_value_set_dlna_profile()</function></link> instead.
 */
/**
 * RYGEL_TYPE_MEDIA_ENGINE
 * 
 * The type for <link linkend="RygelMediaEngine"><type>RygelMediaEngine</type></link>.
 */
/**
 * rygel_media_engine_get_dlna_profiles
 * @self: the <link linkend="RygelMediaEngine"><type>RygelMediaEngine</type></link> instance
 * 
 * Get a list of the DLNA profiles that are supported by this media engine.
 * 
 * Returns: (transfer none): A list of #DLNAProfile<!-- -->s 
 */
/**
 * rygel_media_engine_get_transcoders
 * @self: the <link linkend="RygelMediaEngine"><type>RygelMediaEngine</type></link> instance
 * 
 * Get a list of the Transcoders that are supported by this media engine.
 * 
 * Returns: (transfer none): A list of #Transcoder<!-- -->s or null if not supported. 
 */
/**
 * rygel_media_engine_create_data_source
 * @self: the <link linkend="RygelMediaEngine"><type>RygelMediaEngine</type></link> instance
 * @uri: (in): to create the data source for. 
 * 
 * Get a data source for the URI.
 * 
 * Returns: A data source representing the uri 
 */
/**
 * rygel_media_engine_init
 * @error: location to store the error occuring, or %NULL to ignore
 */
/**
 * rygel_media_engine_get_default
 * 
 * Get the singleton instance of the currently used media engine.
 * 
 * Returns: An instance of a concrete #MediaEngine implementation. 
 */
/**
 * RygelMediaEngine
 * 
 * Base class for the media engine that will contain knowledge about streaming and transcoding capabilites of the media library in use.
 */
/**
 * RygelMediaEngineError
 */
