/* os-database.c generated by valac 0.18.0.9-06717, the Vala compiler
 * generated from os-database.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <libcommon.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_OS_DATABASE (boxes_os_database_get_type ())
#define BOXES_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabase))
#define BOXES_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))
#define BOXES_IS_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_OS_DATABASE))
#define BOXES_IS_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_OS_DATABASE))
#define BOXES_OS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))

typedef struct _BoxesOSDatabase BoxesOSDatabase;
typedef struct _BoxesOSDatabaseClass BoxesOSDatabaseClass;
typedef struct _BoxesOSDatabasePrivate BoxesOSDatabasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _boxes_os_database_unref0(var) ((var == NULL) ? NULL : (var = (boxes_os_database_unref (var), NULL)))
typedef struct _BoxesOsDatabaseGuessOsFromInstallMediaData BoxesOsDatabaseGuessOsFromInstallMediaData;
typedef struct _BoxesParamSpecOSDatabase BoxesParamSpecOSDatabase;

typedef enum  {
	BOXES_OS_DATABASE_ERROR_NON_BOOTABLE,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID
} BoxesOSDatabaseError;
#define BOXES_OS_DATABASE_ERROR boxes_os_database_error_quark ()
struct _BoxesOSDatabase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesOSDatabasePrivate * priv;
};

struct _BoxesOSDatabaseClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesOSDatabase *self);
};

struct _BoxesOSDatabasePrivate {
	OsinfoDb* db;
};

struct _BoxesOsDatabaseGuessOsFromInstallMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesOSDatabase* self;
	gchar* media_path;
	OsinfoMedia* os_media;
	GCancellable* cancellable;
	OsinfoOs* result;
	OsinfoDb* _tmp0_;
	const gchar* _tmp1_;
	GCancellable* _tmp2_;
	OsinfoMedia* _tmp3_;
	OsinfoMedia* media;
	OsinfoDb* _tmp4_;
	OsinfoMedia* _tmp5_;
	OsinfoMedia* _tmp6_;
	OsinfoOs* _tmp7_;
	OsinfoMedia* _tmp8_;
	OsinfoOs* _tmp9_;
	GError * _inner_error_;
};

struct _BoxesParamSpecOSDatabase {
	GParamSpec parent_instance;
};


static gpointer boxes_os_database_parent_class = NULL;

GQuark boxes_os_database_error_quark (void);
gpointer boxes_os_database_ref (gpointer instance);
void boxes_os_database_unref (gpointer instance);
GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_os_database (GValue* value, gpointer v_object);
void boxes_value_take_os_database (GValue* value, gpointer v_object);
gpointer boxes_value_get_os_database (const GValue* value);
GType boxes_os_database_get_type (void) G_GNUC_CONST;
#define BOXES_OS_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_OS_DATABASE, BoxesOSDatabasePrivate))
enum  {
	BOXES_OS_DATABASE_DUMMY_PROPERTY
};
#define BOXES_OS_DATABASE_DEFAULT_VCPUS 1
#define BOXES_OS_DATABASE_DEFAULT_RAM (500 * ((gint64) OSINFO_MEBIBYTES))
#define BOXES_OS_DATABASE_DEFAULT_STORAGE (20 * ((gint64) OSINFO_GIBIBYTES))
static OsinfoResources* boxes_os_database_get_default_resources (void);
void boxes_os_database_load (BoxesOSDatabase* self, GError** error);
static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data);
void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self, const gchar* media_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
OsinfoOs* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self, GAsyncResult* _res_, OsinfoMedia** os_media, GError** error);
static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_);
static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error);
OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error);
OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os, const gchar* architecture);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup4 (gchar** self, int length);
static OsinfoResources* boxes_os_database_get_prefered_resources (BoxesOSDatabase* self, OsinfoResourcesList* list, gchar** prefs, int prefs_length1);
static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self, OsinfoResources* minimum, OsinfoResources* recommended);
BoxesOSDatabase* boxes_os_database_new (void);
BoxesOSDatabase* boxes_os_database_construct (GType object_type);
static void boxes_os_database_finalize (BoxesOSDatabase* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_os_database_error_quark (void) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	return g_quark_from_static_string ("boxes_os_database_error-quark");
#line 126 "os-database.c"
}


static OsinfoResources* boxes_os_database_get_default_resources (void) {
	OsinfoResources* result = NULL;
	OsinfoResources* _tmp0_;
	OsinfoResources* resources;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = osinfo_resources_new ("whatever", "x86_64");
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	resources = _tmp0_;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_resources_set_n_cpus (resources, BOXES_OS_DATABASE_DEFAULT_VCPUS);
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_resources_set_ram (resources, BOXES_OS_DATABASE_DEFAULT_RAM);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_resources_set_storage (resources, BOXES_OS_DATABASE_DEFAULT_STORAGE);
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = resources;
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 148 "os-database.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return self ? g_object_ref (self) : NULL;
#line 155 "os-database.c"
}


void boxes_os_database_load (BoxesOSDatabase* self, GError** error) {
	OsinfoLoader* _tmp0_;
	OsinfoLoader* loader;
	OsinfoDb* _tmp7_ = NULL;
	OsinfoDb* _tmp8_;
	GError * _inner_error_ = NULL;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_if_fail (self != NULL);
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = osinfo_loader_new ();
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	loader = _tmp0_;
#line 171 "os-database.c"
	{
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_loader_process_default_path (loader, &_inner_error_);
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_ != NULL) {
#line 177 "os-database.c"
			goto __catch47_g_error;
		}
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		e = _inner_error_;
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = NULL;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = e;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp2_ = _tmp1_->message;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_warning ("os-database.vala:36: Error loading default libosinfo database: %s", _tmp2_);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_error_free0 (e);
#line 199 "os-database.c"
	}
	__finally47:
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_inner_error_ != NULL) {
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_propagate_error (error, _inner_error_);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (loader);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return;
#line 210 "os-database.c"
	}
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp3_ = boxes_get_logos_db ();
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp4_ = _tmp3_;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_loader_process_path (loader, _tmp4_, &_inner_error_);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_free0 (_tmp4_);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_ != NULL) {
#line 225 "os-database.c"
			goto __catch48_g_error;
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		e = _inner_error_;
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = NULL;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp5_ = e;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp6_ = _tmp5_->message;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_warning ("os-database.vala:41: Error loading GNOME Boxes libosinfo database: %s", _tmp6_);
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_error_free0 (e);
#line 247 "os-database.c"
	}
	__finally48:
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_inner_error_ != NULL) {
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_propagate_error (error, _inner_error_);
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (loader);
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return;
#line 258 "os-database.c"
	}
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp7_ = osinfo_loader_get_db (loader);
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (self->priv->db);
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self->priv->db = _tmp8_;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (loader);
#line 270 "os-database.c"
}


static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = _data;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_free0 (_data_->media_path);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->cancellable);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->result);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_boxes_os_database_unref0 (_data_->self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_slice_free (BoxesOsDatabaseGuessOsFromInstallMediaData, _data_);
#line 287 "os-database.c"
}


static gpointer _boxes_os_database_ref0 (gpointer self) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return self ? boxes_os_database_ref (self) : NULL;
#line 294 "os-database.c"
}


void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self, const gchar* media_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	BoxesOSDatabase* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_ = g_slice_new0 (BoxesOsDatabaseGuessOsFromInstallMediaData);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, boxes_os_database_guess_os_from_install_media);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_os_database_guess_os_from_install_media_data_free);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = _boxes_os_database_ref0 (self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->self = _tmp0_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = media_path;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_free0 (_data_->media_path);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->media_path = _tmp2_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = cancellable;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->cancellable);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->cancellable = _tmp4_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	boxes_os_database_guess_os_from_install_media_co (_data_);
#line 333 "os-database.c"
}


OsinfoOs* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self, GAsyncResult* _res_, OsinfoMedia** os_media, GError** error) {
	OsinfoOs* result;
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return NULL;
#line 344 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (os_media) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*os_media = _data_->os_media;
#line 352 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (_data_->os_media);
#line 356 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->os_media = NULL;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = _data_->result;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->result = NULL;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 366 "os-database.c"
}


static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_ = _user_data_;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_source_object_ = source_object;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_res_ = _res_;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	boxes_os_database_guess_os_from_install_media_co (_data_);
#line 380 "os-database.c"
}


static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_) {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	switch (_data_->_state_) {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		case 0:
#line 389 "os-database.c"
		goto _state_0;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		case 1:
#line 393 "os-database.c"
		goto _state_1;
		default:
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_assert_not_reached ();
#line 398 "os-database.c"
	}
	_state_0:
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->os_media);
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->os_media = NULL;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp0_ = _data_->self->priv->db;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_tmp0_ == NULL) {
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_data_->result = NULL;
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_data_->_state_ == 0) {
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 415 "os-database.c"
		} else {
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 419 "os-database.c"
		}
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_object_unref (_data_->_async_result);
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return FALSE;
#line 425 "os-database.c"
	}
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp1_ = _data_->media_path;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp2_ = _data_->cancellable;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_state_ = 1;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_media_create_from_location_async (_data_->_tmp1_, G_PRIORITY_DEFAULT, _data_->_tmp2_, boxes_os_database_guess_os_from_install_media_ready, _data_);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return FALSE;
#line 437 "os-database.c"
	_state_1:
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp3_ = NULL;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp3_ = osinfo_media_create_from_location_finish (_data_->_res_, &_data_->_inner_error_);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->media = _data_->_tmp3_;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_inner_error_ != NULL) {
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_error_free (_data_->_inner_error_);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_data_->_state_ == 0) {
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 455 "os-database.c"
		} else {
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 459 "os-database.c"
		}
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_object_unref (_data_->_async_result);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return FALSE;
#line 465 "os-database.c"
	}
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp4_ = _data_->self->priv->db;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp5_ = _data_->media;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp6_ = NULL;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp7_ = NULL;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp7_ = osinfo_db_guess_os_from_media (_data_->_tmp4_, _data_->_tmp5_, &_data_->_tmp6_);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->os_media);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp6_);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->os_media = _data_->_tmp8_;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp7_);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->result = _data_->_tmp9_;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->media);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_state_ == 0) {
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 493 "os-database.c"
	} else {
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 497 "os-database.c"
	}
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_object_unref (_data_->_async_result);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return FALSE;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->media);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_state_ == 0) {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 509 "os-database.c"
	} else {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 513 "os-database.c"
	}
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_object_unref (_data_->_async_result);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return FALSE;
#line 519 "os-database.c"
}


OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error) {
	OsinfoOs* result = NULL;
	OsinfoDb* _tmp0_;
	OsinfoDb* _tmp3_;
	const gchar* _tmp4_;
	OsinfoOs* _tmp5_ = NULL;
	OsinfoOs* _tmp6_;
	OsinfoOs* os;
	OsinfoOs* _tmp7_;
	GError * _inner_error_ = NULL;
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = self->priv->db;
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp0_ == NULL) {
#line 541 "os-database.c"
		const gchar* _tmp1_;
		GError* _tmp2_;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = id;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp2_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID, "Unknown OS ID '%s'", _tmp1_);
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = _tmp2_;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_propagate_error (error, _inner_error_);
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 556 "os-database.c"
		} else {
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_clear_error (&_inner_error_);
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 564 "os-database.c"
		}
	}
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = self->priv->db;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = id;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = osinfo_db_get_os (_tmp3_, _tmp4_);
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	os = _tmp6_;
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp7_ = os;
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp7_ == NULL) {
#line 581 "os-database.c"
		const gchar* _tmp8_;
		GError* _tmp9_;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = id;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID, "Unknown OS ID '%s'", _tmp8_);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = _tmp9_;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_propagate_error (error, _inner_error_);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (os);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 598 "os-database.c"
		} else {
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (os);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_clear_error (&_inner_error_);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 608 "os-database.c"
		}
	}
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = os;
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 615 "os-database.c"
}


OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error) {
	OsinfoMedia* result = NULL;
	OsinfoOs* _tmp0_;
	OsinfoMediaList* _tmp1_ = NULL;
	OsinfoMediaList* medias;
	OsinfoMediaList* _tmp2_;
	const gchar* _tmp3_;
	OsinfoEntity* _tmp4_ = NULL;
	OsinfoMedia* _tmp5_;
	OsinfoMedia* media;
	OsinfoMedia* _tmp6_;
	GError * _inner_error_ = NULL;
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (os != NULL, NULL);
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = os;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = osinfo_os_get_media_list (_tmp0_);
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	medias = _tmp1_;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = medias;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = id;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = osinfo_list_find_by_id ((OsinfoList*) _tmp2_, _tmp3_);
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, osinfo_media_get_type ()) ? ((OsinfoMedia*) _tmp4_) : NULL);
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	media = _tmp5_;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = media;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp6_ == NULL) {
#line 657 "os-database.c"
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp7_ = id;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID, "Unknown media ID '%s'", _tmp7_);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = _tmp8_;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_propagate_error (error, _inner_error_);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (media);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (medias);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 676 "os-database.c"
		} else {
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (media);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (medias);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_clear_error (&_inner_error_);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 688 "os-database.c"
		}
	}
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = media;
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (medias);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 697 "os-database.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if ((*length) == (*size)) {
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 708 "os-database.c"
	}
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[(*length)++] = value;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[*length] = NULL;
#line 714 "os-database.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if ((*length) == (*size)) {
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 725 "os-database.c"
	}
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[(*length)++] = value;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[*length] = NULL;
#line 731 "os-database.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = g_new0 (gchar*, length + 1);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	for (i = 0; i < length; i++) {
#line 742 "os-database.c"
		gchar* _tmp0_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp0_ = g_strdup (self[i]);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result[i] = _tmp0_;
#line 748 "os-database.c"
	}
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 752 "os-database.c"
}


OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os, const gchar* architecture) {
	OsinfoResources* result = NULL;
	OsinfoOs* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** architectures;
	gint architectures_length1;
	gint _architectures_size_;
	gchar** prefs = NULL;
	gint prefs_length1 = 0;
	gint _prefs_size_ = 0;
	const gchar* _tmp7_;
	OsinfoOs* _tmp21_;
	OsinfoResourcesList* _tmp22_ = NULL;
	OsinfoResourcesList* list;
	OsinfoResourcesList* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	OsinfoResources* _tmp25_ = NULL;
	OsinfoResources* recommended;
	OsinfoOs* _tmp26_;
	OsinfoResourcesList* _tmp27_ = NULL;
	OsinfoResourcesList* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	OsinfoResources* _tmp30_ = NULL;
	OsinfoResources* minimum;
	OsinfoResources* _tmp31_;
	OsinfoResources* _tmp32_;
	OsinfoResources* _tmp33_ = NULL;
#line 80 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = os;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp0_ == NULL) {
#line 795 "os-database.c"
		OsinfoResources* _tmp1_ = NULL;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = boxes_os_database_get_default_resources ();
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = _tmp1_;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 803 "os-database.c"
	}
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = g_strdup ("x86_64");
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = g_strdup ("i686");
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = g_strdup ("i386");
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = g_strdup (OSINFO_ARCHITECTURE_ALL);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = g_new0 (gchar*, 4 + 1);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[0] = _tmp2_;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[1] = _tmp3_;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[2] = _tmp4_;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[3] = _tmp5_;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	architectures = _tmp6_;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	architectures_length1 = 4;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_architectures_size_ = architectures_length1;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp7_ = architecture;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp7_ != NULL) {
#line 833 "os-database.c"
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = g_new0 (gchar*, 0 + 1);
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = _tmp8_;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs_length1 = 0;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_prefs_size_ = prefs_length1;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9_ = prefs;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9__length1 = prefs_length1;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp10_ = architecture;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_vala_array_add6 (&prefs, &prefs_length1, &_prefs_size_, _tmp11_);
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12_ = architectures;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12__length1 = architectures_length1;
#line 865 "os-database.c"
		{
			gchar** arch_collection = NULL;
			gint arch_collection_length1 = 0;
			gint _arch_collection_size_ = 0;
			gint arch_it = 0;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			arch_collection = _tmp12_;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			arch_collection_length1 = _tmp12__length1;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			for (arch_it = 0; arch_it < _tmp12__length1; arch_it = arch_it + 1) {
#line 877 "os-database.c"
				gchar* _tmp13_;
				gchar* arch = NULL;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
				_tmp13_ = g_strdup (arch_collection[arch_it]);
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
				arch = _tmp13_;
#line 884 "os-database.c"
				{
					const gchar* _tmp14_;
					const gchar* _tmp15_;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					_tmp14_ = arch;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					_tmp15_ = architecture;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
#line 894 "os-database.c"
						gchar** _tmp16_;
						gint _tmp16__length1;
						const gchar* _tmp17_;
						gchar* _tmp18_;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp16_ = prefs;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp16__length1 = prefs_length1;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp17_ = arch;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp18_ = g_strdup (_tmp17_);
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_vala_array_add7 (&prefs, &prefs_length1, &_prefs_size_, _tmp18_);
#line 909 "os-database.c"
					}
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					_g_free0 (arch);
#line 913 "os-database.c"
				}
			}
		}
	} else {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp20_;
		gint _tmp20__length1;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp19_ = architectures;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp19__length1 = architectures_length1;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup4 (_tmp19_, _tmp19__length1) : ((gpointer) _tmp19_);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp20__length1 = _tmp19__length1;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = _tmp20_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs_length1 = _tmp20__length1;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_prefs_size_ = prefs_length1;
#line 938 "os-database.c"
	}
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp21_ = os;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp22_ = osinfo_os_get_recommended_resources (_tmp21_);
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	list = _tmp22_;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp23_ = list;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp24_ = prefs;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp24__length1 = prefs_length1;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp25_ = boxes_os_database_get_prefered_resources (self, _tmp23_, _tmp24_, _tmp24__length1);
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	recommended = _tmp25_;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp26_ = os;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp27_ = osinfo_os_get_minimum_resources (_tmp26_);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (list);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	list = _tmp27_;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp28_ = list;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp29_ = prefs;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp29__length1 = prefs_length1;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp30_ = boxes_os_database_get_prefered_resources (self, _tmp28_, _tmp29_, _tmp29__length1);
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	minimum = _tmp30_;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp31_ = minimum;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp32_ = recommended;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp33_ = boxes_os_database_get_resources_from_os_resources (self, _tmp31_, _tmp32_);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = _tmp33_;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (minimum);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (recommended);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (list);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	architectures = (_vala_array_free (architectures, architectures_length1, (GDestroyNotify) g_free), NULL);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 994 "os-database.c"
}


static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self, OsinfoResources* minimum, OsinfoResources* recommended) {
	OsinfoResources* result = NULL;
	OsinfoResources* _tmp0_ = NULL;
	OsinfoResources* resources;
	gboolean _tmp1_ = FALSE;
	OsinfoResources* _tmp2_;
	gboolean _tmp6_;
	gboolean _tmp25_ = FALSE;
	OsinfoResources* _tmp26_;
	gboolean _tmp30_;
	gboolean _tmp49_ = FALSE;
	OsinfoResources* _tmp50_;
	gboolean _tmp54_;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = boxes_os_database_get_default_resources ();
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	resources = _tmp0_;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = recommended;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp2_ != NULL) {
#line 1021 "os-database.c"
		OsinfoResources* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp3_ = recommended;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp4_ = osinfo_resources_get_n_cpus (_tmp3_);
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp5_ = _tmp4_;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = _tmp5_ > 0;
#line 1033 "os-database.c"
	} else {
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = FALSE;
#line 1037 "os-database.c"
	}
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = _tmp1_;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp6_) {
#line 1043 "os-database.c"
		OsinfoResources* _tmp7_;
		OsinfoResources* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp7_ = resources;
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = recommended;
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9_ = osinfo_resources_get_n_cpus (_tmp8_);
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp10_ = _tmp9_;
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_resources_set_n_cpus (_tmp7_, _tmp10_);
#line 1058 "os-database.c"
	} else {
		gboolean _tmp11_ = FALSE;
		OsinfoResources* _tmp12_;
		gboolean _tmp16_;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12_ = minimum;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp12_ != NULL) {
#line 1067 "os-database.c"
			OsinfoResources* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp13_ = minimum;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp14_ = osinfo_resources_get_n_cpus (_tmp13_);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp15_ = _tmp14_;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp11_ = _tmp15_ > 0;
#line 1079 "os-database.c"
		} else {
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp11_ = FALSE;
#line 1083 "os-database.c"
		}
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp16_ = _tmp11_;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp16_) {
#line 1089 "os-database.c"
			OsinfoResources* _tmp17_;
			OsinfoResources* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			OsinfoResources* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_ = 0;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp17_ = resources;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp18_ = minimum;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp19_ = osinfo_resources_get_n_cpus (_tmp18_);
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp20_ = _tmp19_;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp21_ = resources;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp22_ = osinfo_resources_get_n_cpus (_tmp21_);
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp23_ = _tmp22_;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp24_ = MAX (_tmp20_, _tmp23_);
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			osinfo_resources_set_n_cpus (_tmp17_, _tmp24_);
#line 1116 "os-database.c"
		}
	}
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp26_ = recommended;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp26_ != NULL) {
#line 1123 "os-database.c"
		OsinfoResources* _tmp27_;
		gint64 _tmp28_;
		gint64 _tmp29_;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp27_ = recommended;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp28_ = osinfo_resources_get_ram (_tmp27_);
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp29_ = _tmp28_;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp25_ = _tmp29_ > ((gint64) 0);
#line 1135 "os-database.c"
	} else {
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp25_ = FALSE;
#line 1139 "os-database.c"
	}
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp30_ = _tmp25_;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp30_) {
#line 1145 "os-database.c"
		OsinfoResources* _tmp31_;
		OsinfoResources* _tmp32_;
		gint64 _tmp33_;
		gint64 _tmp34_;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp31_ = resources;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp32_ = recommended;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp33_ = osinfo_resources_get_ram (_tmp32_);
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp34_ = _tmp33_;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_resources_set_ram (_tmp31_, _tmp34_);
#line 1160 "os-database.c"
	} else {
		gboolean _tmp35_ = FALSE;
		OsinfoResources* _tmp36_;
		gboolean _tmp40_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp36_ = minimum;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp36_ != NULL) {
#line 1169 "os-database.c"
			OsinfoResources* _tmp37_;
			gint64 _tmp38_;
			gint64 _tmp39_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp37_ = minimum;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp38_ = osinfo_resources_get_ram (_tmp37_);
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp39_ = _tmp38_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp35_ = _tmp39_ > ((gint64) 0);
#line 1181 "os-database.c"
		} else {
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp35_ = FALSE;
#line 1185 "os-database.c"
		}
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp40_ = _tmp35_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp40_) {
#line 1191 "os-database.c"
			OsinfoResources* _tmp41_;
			OsinfoResources* _tmp42_;
			gint64 _tmp43_;
			gint64 _tmp44_;
			OsinfoResources* _tmp45_;
			gint64 _tmp46_;
			gint64 _tmp47_;
			gint64 _tmp48_ = 0LL;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp41_ = resources;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp42_ = minimum;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp43_ = osinfo_resources_get_ram (_tmp42_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp44_ = _tmp43_;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp45_ = resources;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp46_ = osinfo_resources_get_ram (_tmp45_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp47_ = _tmp46_;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp48_ = MAX (_tmp44_, _tmp47_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			osinfo_resources_set_ram (_tmp41_, _tmp48_);
#line 1218 "os-database.c"
		}
	}
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp50_ = recommended;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp50_ != NULL) {
#line 1225 "os-database.c"
		OsinfoResources* _tmp51_;
		gint64 _tmp52_;
		gint64 _tmp53_;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp51_ = recommended;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp52_ = osinfo_resources_get_storage (_tmp51_);
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp53_ = _tmp52_;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp49_ = _tmp53_ > ((gint64) 0);
#line 1237 "os-database.c"
	} else {
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp49_ = FALSE;
#line 1241 "os-database.c"
	}
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp54_ = _tmp49_;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp54_) {
#line 1247 "os-database.c"
		OsinfoResources* _tmp55_;
		OsinfoResources* _tmp56_;
		gint64 _tmp57_;
		gint64 _tmp58_;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp55_ = resources;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp56_ = recommended;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp57_ = osinfo_resources_get_storage (_tmp56_);
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp58_ = _tmp57_;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_resources_set_storage (_tmp55_, _tmp58_);
#line 1262 "os-database.c"
	} else {
		gboolean _tmp59_ = FALSE;
		OsinfoResources* _tmp60_;
		gboolean _tmp64_;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp60_ = minimum;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp60_ != NULL) {
#line 1271 "os-database.c"
			OsinfoResources* _tmp61_;
			gint64 _tmp62_;
			gint64 _tmp63_;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp61_ = minimum;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp62_ = osinfo_resources_get_storage (_tmp61_);
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp63_ = _tmp62_;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp59_ = _tmp63_ > ((gint64) 0);
#line 1283 "os-database.c"
		} else {
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp59_ = FALSE;
#line 1287 "os-database.c"
		}
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp64_ = _tmp59_;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp64_) {
#line 1293 "os-database.c"
			OsinfoResources* _tmp65_;
			OsinfoResources* _tmp66_;
			gint64 _tmp67_;
			gint64 _tmp68_;
			OsinfoResources* _tmp69_;
			gint64 _tmp70_;
			gint64 _tmp71_;
			gint64 _tmp72_ = 0LL;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp65_ = resources;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp66_ = minimum;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp67_ = osinfo_resources_get_storage (_tmp66_);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp68_ = _tmp67_;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp69_ = resources;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp70_ = osinfo_resources_get_storage (_tmp69_);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp71_ = _tmp70_;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp72_ = MAX (_tmp68_ * 2, _tmp71_);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			osinfo_resources_set_storage (_tmp65_, _tmp72_);
#line 1320 "os-database.c"
		}
	}
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = resources;
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 1327 "os-database.c"
}


static OsinfoResources* boxes_os_database_get_prefered_resources (BoxesOSDatabase* self, OsinfoResourcesList* list, gchar** prefs, int prefs_length1) {
	OsinfoResources* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	OsinfoFilter* _tmp1_;
	OsinfoFilter* filter;
	OsinfoFilter* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	OsinfoResourcesList* _tmp5_;
	OsinfoFilter* _tmp6_;
	OsinfoResourcesList* _tmp7_ = NULL;
	OsinfoResourcesList* filtered;
	OsinfoResourcesList* _tmp8_;
	gint _tmp9_ = 0;
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = prefs;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0__length1 = prefs_length1;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp0__length1 <= 0) {
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = NULL;
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 1361 "os-database.c"
	}
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = osinfo_filter_new ();
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	filter = _tmp1_;
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = filter;
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = prefs;
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3__length1 = prefs_length1;
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = _tmp3_[0];
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_filter_add_constraint (_tmp2_, OSINFO_RESOURCES_PROP_ARCHITECTURE, _tmp4_);
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = list;
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = filter;
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp7_ = osinfo_resourceslist_new_filtered (_tmp5_, _tmp6_);
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	filtered = _tmp7_;
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp8_ = filtered;
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp9_ = osinfo_list_get_length ((OsinfoList*) _tmp8_);
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp9_ <= 0) {
#line 1391 "os-database.c"
		OsinfoResourcesList* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		OsinfoResources* _tmp13_ = NULL;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp10_ = list;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp11_ = prefs;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp11__length1 = prefs_length1;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12_ = prefs;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12__length1 = prefs_length1;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp13_ = boxes_os_database_get_prefered_resources (self, _tmp10_, _tmp11_ + 1, _tmp12__length1 - 1);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = _tmp13_;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filtered);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filter);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 1418 "os-database.c"
	} else {
		OsinfoResourcesList* _tmp14_;
		OsinfoEntity* _tmp15_ = NULL;
		OsinfoResources* _tmp16_;
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp14_ = filtered;
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp15_ = osinfo_list_get_nth ((OsinfoList*) _tmp14_, 0);
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, osinfo_resources_get_type ()) ? ((OsinfoResources*) _tmp15_) : NULL);
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = _tmp16_;
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filtered);
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filter);
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 1437 "os-database.c"
	}
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (filtered);
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (filter);
#line 1443 "os-database.c"
}


BoxesOSDatabase* boxes_os_database_construct (GType object_type) {
	BoxesOSDatabase* self = NULL;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self = (BoxesOSDatabase*) g_type_create_instance (object_type);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return self;
#line 1453 "os-database.c"
}


BoxesOSDatabase* boxes_os_database_new (void) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return boxes_os_database_construct (BOXES_TYPE_OS_DATABASE);
#line 1460 "os-database.c"
}


static void boxes_value_os_database_init (GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	value->data[0].v_pointer = NULL;
#line 1467 "os-database.c"
}


static void boxes_value_os_database_free_value (GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (value->data[0].v_pointer) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_unref (value->data[0].v_pointer);
#line 1476 "os-database.c"
	}
}


static void boxes_value_os_database_copy_value (const GValue* src_value, GValue* dest_value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (src_value->data[0].v_pointer) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		dest_value->data[0].v_pointer = boxes_os_database_ref (src_value->data[0].v_pointer);
#line 1486 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1490 "os-database.c"
	}
}


static gpointer boxes_value_os_database_peek_pointer (const GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return value->data[0].v_pointer;
#line 1498 "os-database.c"
}


static gchar* boxes_value_os_database_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (collect_values[0].v_pointer) {
#line 1505 "os-database.c"
		BoxesOSDatabase* object;
		object = collect_values[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (object->parent_instance.g_class == NULL) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1512 "os-database.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1516 "os-database.c"
		}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = boxes_os_database_ref (object);
#line 1520 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = NULL;
#line 1524 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return NULL;
#line 1528 "os-database.c"
}


static gchar* boxes_value_os_database_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesOSDatabase** object_p;
	object_p = collect_values[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (!object_p) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1539 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (!value->data[0].v_pointer) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*object_p = NULL;
#line 1545 "os-database.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*object_p = value->data[0].v_pointer;
#line 1549 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*object_p = boxes_os_database_ref (value->data[0].v_pointer);
#line 1553 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return NULL;
#line 1557 "os-database.c"
}


GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecOSDatabase* spec;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_OS_DATABASE), NULL);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return G_PARAM_SPEC (spec);
#line 1571 "os-database.c"
}


gpointer boxes_value_get_os_database (const GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE), NULL);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return value->data[0].v_pointer;
#line 1580 "os-database.c"
}


void boxes_value_set_os_database (GValue* value, gpointer v_object) {
	BoxesOSDatabase* old;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	old = value->data[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (v_object) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = v_object;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_ref (value->data[0].v_pointer);
#line 1600 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = NULL;
#line 1604 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (old) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_unref (old);
#line 1610 "os-database.c"
	}
}


void boxes_value_take_os_database (GValue* value, gpointer v_object) {
	BoxesOSDatabase* old;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	old = value->data[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (v_object) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = v_object;
#line 1629 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = NULL;
#line 1633 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (old) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_unref (old);
#line 1639 "os-database.c"
	}
}


static void boxes_os_database_class_init (BoxesOSDatabaseClass * klass) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	boxes_os_database_parent_class = g_type_class_peek_parent (klass);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	BOXES_OS_DATABASE_CLASS (klass)->finalize = boxes_os_database_finalize;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_type_class_add_private (klass, sizeof (BoxesOSDatabasePrivate));
#line 1651 "os-database.c"
}


static void boxes_os_database_instance_init (BoxesOSDatabase * self) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self->priv = BOXES_OS_DATABASE_GET_PRIVATE (self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self->ref_count = 1;
#line 1660 "os-database.c"
}


static void boxes_os_database_finalize (BoxesOSDatabase* obj) {
	BoxesOSDatabase * self;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_OS_DATABASE, BoxesOSDatabase);
#line 19 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (self->priv->db);
#line 1670 "os-database.c"
}


GType boxes_os_database_get_type (void) {
	static volatile gsize boxes_os_database_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_os_database_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_os_database_init, boxes_value_os_database_free_value, boxes_value_os_database_copy_value, boxes_value_os_database_peek_pointer, "p", boxes_value_os_database_collect_value, "p", boxes_value_os_database_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesOSDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_os_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesOSDatabase), 0, (GInstanceInitFunc) boxes_os_database_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_os_database_type_id;
		boxes_os_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesOSDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_os_database_type_id__volatile, boxes_os_database_type_id);
	}
	return boxes_os_database_type_id__volatile;
}


gpointer boxes_os_database_ref (gpointer instance) {
	BoxesOSDatabase* self;
	self = instance;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_atomic_int_inc (&self->ref_count);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return instance;
#line 1695 "os-database.c"
}


void boxes_os_database_unref (gpointer instance) {
	BoxesOSDatabase* self;
	self = instance;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		BOXES_OS_DATABASE_GET_CLASS (self)->finalize (self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1708 "os-database.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1716 "os-database.c"
		int i;
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1724 "os-database.c"
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 1736 "os-database.c"
}



