/* rygel-http-gst-sink.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-http-gst-sink.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/base/gstbasesink.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <rygel-core.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_GST_SINK (rygel_http_gst_sink_get_type ())
#define RYGEL_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSink))
#define RYGEL_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))
#define RYGEL_IS_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_IS_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_HTTP_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))

typedef struct _RygelHTTPGstSink RygelHTTPGstSink;
typedef struct _RygelHTTPGstSinkClass RygelHTTPGstSinkClass;
typedef struct _RygelHTTPGstSinkPrivate RygelHTTPGstSinkPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _Block5Data Block5Data;
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

struct _RygelHTTPGstSink {
	GstBaseSink parent_instance;
	RygelHTTPGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGstSinkClass {
	GstBaseSinkClass parent_class;
};

struct _RygelHTTPGstSinkPrivate {
	RygelHTTPResponse* response;
	gint priority;
	gint64 chunks_buffered;
	gint64 bytes_sent;
	gint64 max_bytes;
	GMutex buffer_mutex;
	GCond buffer_condition;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _Block5Data {
	int _ref_count_;
	RygelHTTPGstSink * self;
	GstBuffer* buffer;
};


static gpointer rygel_http_gst_sink_parent_class = NULL;

GType rygel_http_gst_sink_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GST_SINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkPrivate))
enum  {
	RYGEL_HTTP_GST_SINK_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GST_SINK_NAME "http-gst-sink"
#define RYGEL_HTTP_GST_SINK_PAD_NAME "sink"
#define RYGEL_HTTP_GST_SINK_MAX_BUFFERED_CHUNKS ((guint) 32)
#define RYGEL_HTTP_GST_SINK_MIN_BUFFERED_CHUNKS ((guint) 4)
RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response);
RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response);
gint rygel_http_response_get_priority (RygelHTTPResponse* self);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_gst_sink_on_cancelled (RygelHTTPGstSink* self);
static void _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_gst_sink_on_wrote_chunk (RygelHTTPGstSink* self, SoupMessage* msg);
static void _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
static GstFlowReturn rygel_http_gst_sink_real_render (GstBaseSink* base, GstBuffer* buffer);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda10_ (Block5Data* _data5_);
gboolean rygel_http_gst_sink_push_data (RygelHTTPGstSink* self, GstBuffer* buffer);
static gboolean ___lambda10__gsource_func (gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1);
static void rygel_http_gst_sink_finalize (GObject* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


static void _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_gst_sink_on_cancelled (self);
}


static void _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
	rygel_http_gst_sink_on_wrote_chunk (self, _sender);
}


RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response) {
	RygelHTTPGstSink * self = NULL;
	gint64 _tmp0_;
	GCancellable* _tmp1_;
	RygelHTTPResponse* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	RygelHTTPResponse* _tmp5_;
	RygelHTTPResponse* _tmp6_;
	RygelHTTPSeek* _tmp7_;
	GCancellable* _tmp14_;
	RygelHTTPResponse* _tmp15_;
	SoupMessage* _tmp16_;
	g_return_val_if_fail (response != NULL, NULL);
	self = (RygelHTTPGstSink*) g_object_new (object_type, NULL);
	self->priv->chunks_buffered = (gint64) 0;
	self->priv->bytes_sent = (gint64) 0;
	_tmp0_ = G_MAXINT64;
	self->priv->max_bytes = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp1_;
	_tmp2_ = response;
	_tmp3_ = rygel_http_response_get_priority (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->priority = _tmp4_;
	_tmp5_ = response;
	self->priv->response = _tmp5_;
	gst_base_sink_set_sync ((GstBaseSink*) self, FALSE);
	gst_object_set_name ((GstObject*) self, RYGEL_HTTP_GST_SINK_NAME);
	_tmp6_ = response;
	_tmp7_ = _tmp6_->seek;
	if (_tmp7_ != NULL) {
		RygelHTTPResponse* _tmp8_;
		RygelHTTPSeek* _tmp9_;
		_tmp8_ = response;
		_tmp9_ = _tmp8_->seek;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_HTTP_BYTE_SEEK)) {
			RygelHTTPResponse* _tmp10_;
			RygelHTTPSeek* _tmp11_;
			gint64 _tmp12_;
			gint64 _tmp13_;
			_tmp10_ = response;
			_tmp11_ = _tmp10_->seek;
			_tmp12_ = rygel_http_seek_get_length (_tmp11_);
			_tmp13_ = _tmp12_;
			self->priv->max_bytes = _tmp13_;
		}
	}
	_tmp14_ = self->cancellable;
	g_signal_connect_object (_tmp14_, "cancelled", (GCallback) _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled, self, 0);
	_tmp15_ = response;
	_tmp16_ = _tmp15_->msg;
	g_signal_connect_object (_tmp16_, "wrote-chunk", (GCallback) _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk, self, 0);
	return self;
}


RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response) {
	return rygel_http_gst_sink_construct (RYGEL_TYPE_HTTP_GST_SINK, response);
}


static gpointer _gst_buffer_ref0 (gpointer self) {
	return self ? gst_buffer_ref (self) : NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelHTTPGstSink * self;
		self = _data5_->self;
		_gst_buffer_unref0 (_data5_->buffer);
		_gst_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean __lambda10_ (Block5Data* _data5_) {
	RygelHTTPGstSink * self;
	gboolean result = FALSE;
	GstBuffer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data5_->self;
	_tmp0_ = _data5_->buffer;
	_tmp1_ = rygel_http_gst_sink_push_data (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ (self);
	return result;
}


static GstFlowReturn rygel_http_gst_sink_real_render (GstBaseSink* base, GstBuffer* buffer) {
	RygelHTTPGstSink * self;
	GstFlowReturn result = 0;
	Block5Data* _data5_;
	GstBuffer* _tmp0_;
	GstBuffer* _tmp1_;
	GCancellable* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	self = (RygelHTTPGstSink*) base;
	g_return_val_if_fail (buffer != NULL, 0);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = gst_object_ref (self);
	_tmp0_ = buffer;
	_tmp1_ = _gst_buffer_ref0 (_tmp0_);
	_data5_->buffer = _tmp1_;
	g_mutex_lock (&self->priv->buffer_mutex);
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GCancellable* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp6_;
		GMutex _tmp7_;
		_tmp3_ = self->cancellable;
		_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
		if (!_tmp4_) {
			gint64 _tmp5_;
			_tmp5_ = self->priv->chunks_buffered;
			_tmp2_ = _tmp5_ > ((gint64) RYGEL_HTTP_GST_SINK_MAX_BUFFERED_CHUNKS);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp6_ = _tmp2_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = self->priv->buffer_mutex;
		g_cond_wait (&self->priv->buffer_condition, &_tmp7_);
	}
	g_mutex_unlock (&self->priv->buffer_mutex);
	_tmp8_ = self->cancellable;
	_tmp9_ = g_cancellable_is_cancelled (_tmp8_);
	if (_tmp9_) {
		result = GST_FLOW_OK;
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	_tmp10_ = self->priv->priority;
	g_idle_add_full (_tmp10_, ___lambda10__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	result = GST_FLOW_OK;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


gboolean rygel_http_gst_sink_push_data (RygelHTTPGstSink* self, GstBuffer* buffer) {
	gboolean result = FALSE;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 left;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_;
	GstBuffer* _tmp7_;
	guint _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_ = 0LL;
	gint64 to_send;
	RygelHTTPResponse* _tmp11_;
	GstBuffer* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint64 _tmp14_;
	gint64 _tmp15_;
	gint64 _tmp16_;
	gint64 _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (buffer != NULL, FALSE);
	_tmp0_ = self->priv->max_bytes;
	_tmp1_ = self->priv->bytes_sent;
	left = _tmp0_ - _tmp1_;
	_tmp3_ = self->cancellable;
	_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gint64 _tmp5_;
		_tmp5_ = left;
		_tmp2_ = _tmp5_ <= ((gint64) 0);
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = buffer;
	_tmp8_ = _tmp7_->size;
	_tmp9_ = left;
	_tmp10_ = MIN ((gint64) _tmp8_, _tmp9_);
	to_send = _tmp10_;
	_tmp11_ = self->priv->response;
	_tmp12_ = buffer;
	_tmp13_ = _tmp12_->data;
	_tmp13__length1 = (gint) _tmp12_->size;
	_tmp14_ = to_send;
	rygel_http_response_push_data (_tmp11_, _tmp13_ + 0, _tmp14_ - 0);
	_tmp15_ = self->priv->chunks_buffered;
	self->priv->chunks_buffered = _tmp15_ + 1;
	_tmp16_ = self->priv->bytes_sent;
	_tmp17_ = to_send;
	self->priv->bytes_sent = _tmp16_ + _tmp17_;
	result = FALSE;
	return result;
}


static void rygel_http_gst_sink_on_wrote_chunk (RygelHTTPGstSink* self, SoupMessage* msg) {
	gint64 _tmp0_;
	gint64 _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_mutex_lock (&self->priv->buffer_mutex);
	_tmp0_ = self->priv->chunks_buffered;
	self->priv->chunks_buffered = _tmp0_ - 1;
	_tmp1_ = self->priv->chunks_buffered;
	if (_tmp1_ < ((gint64) RYGEL_HTTP_GST_SINK_MIN_BUFFERED_CHUNKS)) {
		g_cond_broadcast (&self->priv->buffer_condition);
	}
	g_mutex_unlock (&self->priv->buffer_mutex);
}


static void rygel_http_gst_sink_on_cancelled (RygelHTTPGstSink* self) {
	RygelHTTPResponse* _tmp0_;
	SoupMessage* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->buffer_mutex);
	g_cond_broadcast (&self->priv->buffer_condition);
	g_mutex_unlock (&self->priv->buffer_mutex);
	_tmp0_ = self->priv->response;
	_tmp1_ = _tmp0_->msg;
	g_signal_parse_name ("wrote-chunk", soup_message_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk, self);
}


static gpointer _gst_caps_ref0 (gpointer self) {
	return self ? gst_caps_ref (self) : NULL;
}


static void rygel_http_gst_sink_class_init (RygelHTTPGstSinkClass * klass) {
	GstCaps* _tmp0_;
	GstCaps* caps;
	GstCaps* _tmp1_;
	GstCaps* _tmp2_;
	GstPadTemplate* _tmp3_;
	GstPadTemplate* template;
	GstPadTemplate* _tmp4_;
	rygel_http_gst_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGstSinkPrivate));
	GST_BASE_SINK_CLASS (klass)->render = rygel_http_gst_sink_real_render;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_gst_sink_finalize;
	_tmp0_ = gst_caps_new_any ();
	caps = _tmp0_;
	_tmp1_ = caps;
	_tmp2_ = _gst_caps_ref0 (_tmp1_);
	_tmp3_ = gst_pad_template_new (RYGEL_HTTP_GST_SINK_PAD_NAME, GST_PAD_SINK, GST_PAD_ALWAYS, _tmp2_);
	gst_object_ref_sink (_tmp3_);
	template = _tmp3_;
	_tmp4_ = template;
	gst_element_class_add_pad_template (GST_ELEMENT_CLASS (klass), _tmp4_);
	_gst_object_unref0 (template);
	_gst_caps_unref0 (caps);
}


static void rygel_http_gst_sink_instance_init (RygelHTTPGstSink * self) {
	GMutex _tmp0_ = {0};
	GCond _tmp1_ = {0};
	self->priv = RYGEL_HTTP_GST_SINK_GET_PRIVATE (self);
	g_mutex_init (&_tmp0_);
	self->priv->buffer_mutex = _tmp0_;
	g_cond_init (&_tmp1_);
	self->priv->buffer_condition = _tmp1_;
}


static void rygel_http_gst_sink_finalize (GObject* obj) {
	RygelHTTPGstSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSink);
	_g_object_unref0 (self->cancellable);
	_vala_clear_GMutex (&self->priv->buffer_mutex);
	_vala_clear_GCond (&self->priv->buffer_condition);
	G_OBJECT_CLASS (rygel_http_gst_sink_parent_class)->finalize (obj);
}


GType rygel_http_gst_sink_get_type (void) {
	static volatile gsize rygel_http_gst_sink_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_gst_sink_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGstSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_gst_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGstSink), 0, (GInstanceInitFunc) rygel_http_gst_sink_instance_init, NULL };
		GType rygel_http_gst_sink_type_id;
		rygel_http_gst_sink_type_id = g_type_register_static (GST_TYPE_BASE_SINK, "RygelHTTPGstSink", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_gst_sink_type_id__volatile, rygel_http_gst_sink_type_id);
	}
	return rygel_http_gst_sink_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



