/* rygel-http-get-test.c generated by valac 0.17.2.19-5f50d, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelParamSpecClientHacks RygelParamSpecClientHacks;

#define RYGEL_TYPE_TEST_REQUEST_FACTORY (rygel_test_request_factory_get_type ())
#define RYGEL_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory))
#define RYGEL_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))
#define RYGEL_IS_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_IS_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_TEST_REQUEST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))

typedef struct _RygelTestRequestFactory RygelTestRequestFactory;
typedef struct _RygelTestRequestFactoryClass RygelTestRequestFactoryClass;
typedef struct _RygelTestRequestFactoryPrivate RygelTestRequestFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
typedef struct _RygelParamSpecTestRequestFactory RygelParamSpecTestRequestFactory;

#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_test_request_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_test_request_factory_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelClientHacks {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GTypeClass parent_class;
	void (*finalize) (RygelClientHacks *self);
};

struct _RygelParamSpecClientHacks {
	GParamSpec parent_instance;
};

struct _RygelTestRequestFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTestRequestFactoryPrivate * priv;
	SoupMessage* msg;
	SoupKnownStatusCode expected_code;
};

struct _RygelTestRequestFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTestRequestFactory *self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelParamSpecTestRequestFactory {
	GParamSpec parent_instance;
};

struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
	GeeArrayList* requests;
	RygelTestRequestFactory* current_request;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	SoupMessage* _tmp0_;
	RygelHTTPGet* _tmp1_;
	RygelHTTPGet* request;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* _tmp3_;
	RygelMediaItem* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	SoupMessage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	RygelTestRequestFactory* _tmp11_;
	SoupKnownStatusCode _tmp12_;
	gboolean _tmp13_;
	GMainLoop* _tmp14_;
	GError* _error_;
	GError* _tmp15_;
	GError* _tmp16_;
	GMainLoop* _tmp17_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	GUPnPContext* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelVideoItem* _tmp2_;
	const gchar* _tmp3_;
	RygelAudioItem* _tmp4_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* ts;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block3Data* _data3_;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};


static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_test_request_factory_parent_class = NULL;
static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_transcoder_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_client_hacks_error_quark (void);
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaItem* item);
static void rygel_client_hacks_finalize (RygelClientHacks* obj);
gpointer rygel_test_request_factory_ref (gpointer instance);
void rygel_test_request_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_test_request_factory (GValue* value, gpointer v_object);
void rygel_value_take_test_request_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_test_request_factory (const GValue* value);
GType rygel_test_request_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TEST_REQUEST_FACTORY_DUMMY_PROPERTY
};
RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupKnownStatusCode expected_code);
RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupKnownStatusCode expected_code);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
gint rygel_http_get_test_main (gchar** args, int args_length1);
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context);
static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id);
static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda5_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean __lambda2_ (Block2Data* _data2_);
static gboolean ___lambda2__gsource_func (gpointer self);
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
static void rygel_audio_item_finalize (RygelMediaObject* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self);
gboolean rygel_visual_item_streamable (RygelVisualItem* self);
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_video_item_finalize (RygelMediaObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean __lambda3_ (Block3Data* _data3_);
static gboolean ___lambda3__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_client_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_client_hacks_error-quark");
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return g_boxed_copy (soup_message_headers_get_type (), self);
#line 1048 "rygel-http-get-test.c"
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
#line 1055 "rygel-http-get-test.c"
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_boxed_free (soup_message_headers_get_type (), self);
#line 1062 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error) {
	RygelClientHacks* result = NULL;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	SoupMessageHeaders* headers;
	SoupMessageHeaders* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = message;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = __vala_SoupMessageHeaders_copy0 (_tmp1_);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	headers = _tmp2_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = headers;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = soup_message_headers_get_one (_tmp3_, "clienthacks.test.rygel");
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp4_ != NULL) {
#line 1089 "rygel-http-get-test.c"
		RygelClientHacks* _tmp5_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = rygel_client_hacks_new ();
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp5_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1099 "rygel-http-get-test.c"
	} else {
		GError* _tmp6_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp6_ = g_error_new_literal (RYGEL_CLIENT_HACKS_ERROR, RYGEL_CLIENT_HACKS_ERROR_NA, "");
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp6_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1112 "rygel-http-get-test.c"
	}
#line 37 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__vala_SoupMessageHeaders_free0 (headers);
#line 1116 "rygel-http-get-test.c"
}


void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaItem* item) {
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 1123 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks* self = NULL;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelClientHacks*) g_type_create_instance (object_type);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1133 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_new (void) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
#line 1140 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_init (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 1147 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_free_value (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (value->data[0].v_pointer);
#line 1156 "rygel-http-get-test.c"
	}
}


static void rygel_value_client_hacks_copy_value (const GValue* src_value, GValue* dest_value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_client_hacks_ref (src_value->data[0].v_pointer);
#line 1166 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1170 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_client_hacks_peek_pointer (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1178 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1185 "rygel-http-get-test.c"
		RygelClientHacks* object;
		object = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1192 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1196 "rygel-http-get-test.c"
		}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_client_hacks_ref (object);
#line 1200 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1204 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1208 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelClientHacks** object_p;
	object_p = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1219 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1225 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1229 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1233 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1237 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecClientHacks* spec;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1251 "rygel-http-get-test.c"
}


gpointer rygel_value_get_client_hacks (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1260 "rygel-http-get-test.c"
}


void rygel_value_set_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1280 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1284 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1290 "rygel-http-get-test.c"
	}
}


void rygel_value_take_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1309 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1313 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1319 "rygel-http-get-test.c"
	}
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->finalize = rygel_client_hacks_finalize;
#line 1329 "rygel-http-get-test.c"
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1336 "rygel-http-get-test.c"
}


static void rygel_client_hacks_finalize (RygelClientHacks* obj) {
	RygelClientHacks * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks);
#line 1344 "rygel-http-get-test.c"
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_client_hacks_init, rygel_value_client_hacks_free_value, rygel_value_client_hacks_copy_value, rygel_value_client_hacks_peek_pointer, "p", rygel_value_client_hacks_collect_value, "p", rygel_value_client_hacks_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelClientHacks", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


gpointer rygel_client_hacks_ref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1369 "rygel-http-get-test.c"
}


void rygel_client_hacks_unref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_CLIENT_HACKS_GET_CLASS (self)->finalize (self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1382 "rygel-http-get-test.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1390 "rygel-http-get-test.c"
}


RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupKnownStatusCode expected_code) {
	RygelTestRequestFactory* self = NULL;
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	SoupKnownStatusCode _tmp2_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTestRequestFactory*) g_type_create_instance (object_type);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->msg = _tmp1_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = expected_code;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->expected_code = _tmp2_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1417 "rygel-http-get-test.c"
}


RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupKnownStatusCode expected_code) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_test_request_factory_construct (RYGEL_TYPE_TEST_REQUEST_FACTORY, msg, expected_code);
#line 1424 "rygel-http-get-test.c"
}


RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet* result = NULL;
	RygelHTTPServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	RygelHTTPGet* _tmp3_;
	RygelHTTPGet* request;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = http_server;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = server;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = msg;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = rygel_http_get_new (_tmp0_, _tmp1_, _tmp2_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp3_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_http_get_handler_unref0 (request->handler);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request->handler = NULL;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = request;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1461 "rygel-http-get-test.c"
}


static void rygel_value_test_request_factory_init (GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 1468 "rygel-http-get-test.c"
}


static void rygel_value_test_request_factory_free_value (GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (value->data[0].v_pointer);
#line 1477 "rygel-http-get-test.c"
	}
}


static void rygel_value_test_request_factory_copy_value (const GValue* src_value, GValue* dest_value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_test_request_factory_ref (src_value->data[0].v_pointer);
#line 1487 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1491 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_test_request_factory_peek_pointer (const GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1499 "rygel-http-get-test.c"
}


static gchar* rygel_value_test_request_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1506 "rygel-http-get-test.c"
		RygelTestRequestFactory* object;
		object = collect_values[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1513 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1517 "rygel-http-get-test.c"
		}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_test_request_factory_ref (object);
#line 1521 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1525 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1529 "rygel-http-get-test.c"
}


static gchar* rygel_value_test_request_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTestRequestFactory** object_p;
	object_p = collect_values[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1540 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1546 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1550 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_test_request_factory_ref (value->data[0].v_pointer);
#line 1554 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1558 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTestRequestFactory* spec;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1572 "rygel-http-get-test.c"
}


gpointer rygel_value_get_test_request_factory (const GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1581 "rygel-http-get-test.c"
}


void rygel_value_set_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_ref (value->data[0].v_pointer);
#line 1601 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1605 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (old);
#line 1611 "rygel-http-get-test.c"
	}
}


void rygel_value_take_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1630 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1634 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (old);
#line 1640 "rygel-http-get-test.c"
	}
}


static void rygel_test_request_factory_class_init (RygelTestRequestFactoryClass * klass) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_test_request_factory_parent_class = g_type_class_peek_parent (klass);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_TEST_REQUEST_FACTORY_CLASS (klass)->finalize = rygel_test_request_factory_finalize;
#line 1650 "rygel-http-get-test.c"
}


static void rygel_test_request_factory_instance_init (RygelTestRequestFactory * self) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1657 "rygel-http-get-test.c"
}


static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj) {
	RygelTestRequestFactory * self;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 1667 "rygel-http-get-test.c"
}


GType rygel_test_request_factory_get_type (void) {
	static volatile gsize rygel_test_request_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_test_request_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_test_request_factory_init, rygel_value_test_request_factory_free_value, rygel_value_test_request_factory_copy_value, rygel_value_test_request_factory_peek_pointer, "p", rygel_value_test_request_factory_collect_value, "p", rygel_value_test_request_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestRequestFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_request_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestRequestFactory), 0, (GInstanceInitFunc) rygel_test_request_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_test_request_factory_type_id;
		rygel_test_request_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTestRequestFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_test_request_factory_type_id__volatile, rygel_test_request_factory_type_id);
	}
	return rygel_test_request_factory_type_id__volatile;
}


gpointer rygel_test_request_factory_ref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1692 "rygel-http-get-test.c"
}


void rygel_test_request_factory_unref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_TEST_REQUEST_FACTORY_GET_CLASS (self)->finalize (self);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1705 "rygel-http-get-test.c"
	}
}


gint rygel_http_get_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPGetTest* _tmp0_;
		RygelHTTPGetTest* test;
		RygelHTTPGetTest* _tmp1_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = rygel_http_get_test_new (&_inner_error_);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		test = _tmp0_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1725 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = test;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_run (_tmp1_, &_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (test);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1740 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (test);
#line 1747 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		gint _tmp3_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = _error_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = _tmp2_->code;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp3_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1769 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = _error_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _tmp4_->message;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("rygel-http-get-test.vala:92: %s", _tmp5_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = -1;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1793 "rygel-http-get-test.c"
	}
	__finally0:
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return 0;
#line 1804 "rygel-http-get-test.c"
	}
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = 0;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1810 "rygel-http-get-test.c"
}


int main (int argc, char ** argv) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_thread_init (NULL);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_init ();
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_main (argv, argc);
#line 1821 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
	RygelHTTPGetTest * self = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPContext* _tmp3_;
	RygelHTTPClient* _tmp4_;
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _tmp0_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1848 "rygel-http-get-test.c"
	}
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->server = _tmp1_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = rygel_http_client_new (_tmp3_);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->client = _tmp4_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = g_main_loop_new (NULL, FALSE);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->main_loop = _tmp5_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_create_test_messages (self);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1874 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
#line 1881 "rygel-http-get-test.c"
}


static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_get_test_on_timeout (self);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1890 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_message_received (self, _sender, message);
#line 1897 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_client_completed (self, _sender);
#line 1904 "rygel-http-get-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 1911 "rygel-http-get-test.c"
}


static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
	RygelHTTPServer* _tmp0_;
	RygelHTTPClient* _tmp1_;
	GMainLoop* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->server;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->client;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp1_, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_start_next_test_request (self);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->priv->main_loop;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_run (_tmp2_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->error;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp3_ != NULL) {
#line 1941 "rygel-http-get-test.c"
		GError* _tmp4_;
		GError* _tmp5_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = self->priv->error;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp5_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return;
#line 1954 "rygel-http-get-test.c"
	}
}


void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
#line 1964 "rygel-http-get-test.c"
}


static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_;
	RygelHTTPServer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* request;
	GeeArrayList* _tmp7_;
	SoupMessage* _tmp8_;
	RygelTestRequestFactory* _tmp9_;
	RygelTestRequestFactory* _tmp10_;
	RygelHTTPServer* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	SoupMessage* _tmp15_;
	GeeArrayList* _tmp16_;
	SoupMessage* _tmp17_;
	RygelTestRequestFactory* _tmp18_;
	RygelTestRequestFactory* _tmp19_;
	RygelHTTPServer* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	SoupMessage* _tmp24_;
	GeeArrayList* _tmp25_;
	SoupMessage* _tmp26_;
	RygelTestRequestFactory* _tmp27_;
	RygelTestRequestFactory* _tmp28_;
	RygelHTTPServer* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* uri;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	SoupMessage* _tmp34_;
	GeeArrayList* _tmp35_;
	SoupMessage* _tmp36_;
	RygelTestRequestFactory* _tmp37_;
	RygelTestRequestFactory* _tmp38_;
	RygelHTTPServer* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	SoupMessage* _tmp43_;
	SoupMessage* _tmp44_;
	SoupMessageHeaders* _tmp45_;
	GeeArrayList* _tmp46_;
	SoupMessage* _tmp47_;
	RygelTestRequestFactory* _tmp48_;
	RygelTestRequestFactory* _tmp49_;
	RygelHTTPServer* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	SoupMessage* _tmp54_;
	SoupMessage* _tmp55_;
	SoupMessageHeaders* _tmp56_;
	GeeArrayList* _tmp57_;
	SoupMessage* _tmp58_;
	RygelTestRequestFactory* _tmp59_;
	RygelTestRequestFactory* _tmp60_;
	RygelHTTPServer* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	SoupMessage* _tmp65_;
	SoupMessage* _tmp66_;
	SoupMessageHeaders* _tmp67_;
	GeeArrayList* _tmp68_;
	SoupMessage* _tmp69_;
	RygelTestRequestFactory* _tmp70_;
	RygelTestRequestFactory* _tmp71_;
	RygelHTTPServer* _tmp72_;
	gchar* _tmp73_ = NULL;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	SoupMessage* _tmp77_;
	GeeArrayList* _tmp78_;
	SoupMessage* _tmp79_;
	RygelTestRequestFactory* _tmp80_;
	RygelTestRequestFactory* _tmp81_;
	RygelHTTPServer* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	SoupMessage* _tmp86_;
	SoupMessage* _tmp87_;
	SoupMessageHeaders* _tmp88_;
	GeeArrayList* _tmp89_;
	SoupMessage* _tmp90_;
	RygelTestRequestFactory* _tmp91_;
	RygelTestRequestFactory* _tmp92_;
	RygelHTTPServer* _tmp93_;
	gchar* _tmp94_ = NULL;
	const gchar* _tmp95_;
	SoupMessage* _tmp96_;
	SoupMessage* _tmp97_;
	SoupMessageHeaders* _tmp98_;
	GeeArrayList* _tmp99_;
	SoupMessage* _tmp100_;
	RygelTestRequestFactory* _tmp101_;
	RygelTestRequestFactory* _tmp102_;
	RygelHTTPServer* _tmp103_;
	gchar* _tmp104_ = NULL;
	const gchar* _tmp105_;
	SoupMessage* _tmp106_;
	SoupMessage* _tmp107_;
	SoupMessageHeaders* _tmp108_;
	GeeArrayList* _tmp109_;
	SoupMessage* _tmp110_;
	RygelTestRequestFactory* _tmp111_;
	RygelTestRequestFactory* _tmp112_;
	RygelHTTPServer* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	SoupMessage* _tmp117_;
	SoupMessage* _tmp118_;
	SoupMessageHeaders* _tmp119_;
	GeeArrayList* _tmp120_;
	SoupMessage* _tmp121_;
	RygelTestRequestFactory* _tmp122_;
	RygelTestRequestFactory* _tmp123_;
	RygelHTTPServer* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	SoupMessage* _tmp128_;
	SoupMessage* _tmp129_;
	SoupMessageHeaders* _tmp130_;
	GeeArrayList* _tmp131_;
	SoupMessage* _tmp132_;
	RygelTestRequestFactory* _tmp133_;
	RygelTestRequestFactory* _tmp134_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TEST_REQUEST_FACTORY, (GBoxedCopyFunc) rygel_test_request_factory_ref, rygel_test_request_factory_unref, NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->requests);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->requests = _tmp0_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_http_server_get_uri (_tmp1_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = soup_message_new ("POST", _tmp4_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp4_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp6_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->priv->requests;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = request;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = rygel_test_request_factory_new (_tmp8_, SOUP_STATUS_BAD_REQUEST);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = _tmp9_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp10_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp10_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = self->server;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = rygel_http_server_get_uri (_tmp11_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = _tmp12_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp14_ = _tmp13_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp15_ = soup_message_new ("HEAD", _tmp14_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp15_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp14_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp16_ = self->priv->requests;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp17_ = request;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp18_ = rygel_test_request_factory_new (_tmp17_, SOUP_STATUS_OK);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp19_ = _tmp18_;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp19_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp20_ = self->server;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp21_ = rygel_http_server_get_uri (_tmp20_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp22_ = _tmp21_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp23_ = _tmp22_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp24_ = soup_message_new ("GET", _tmp23_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp24_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp23_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp25_ = self->priv->requests;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp26_ = request;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp27_ = rygel_test_request_factory_new (_tmp26_, SOUP_STATUS_OK);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp28_ = _tmp27_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp28_);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp29_ = self->server;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp30_ = rygel_http_server_create_uri (_tmp29_, "VideoItem");
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp30_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp31_ = uri;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp32_ = g_strconcat (_tmp31_, "/tr/MP3", NULL);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp32_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp33_ = uri;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp34_ = soup_message_new ("HEAD", _tmp33_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp34_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp35_ = self->priv->requests;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp36_ = request;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp37_ = rygel_test_request_factory_new (_tmp36_, SOUP_STATUS_OK);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp38_ = _tmp37_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp38_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp38_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp39_ = self->server;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp40_ = rygel_http_server_get_uri (_tmp39_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp41_ = _tmp40_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp42_ = _tmp41_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp43_ = soup_message_new ("GET", _tmp42_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp43_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp42_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp44_ = request;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp45_ = _tmp44_->request_headers;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp45_, "transferMode.dlna.org", "Streaming");
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp46_ = self->priv->requests;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp47_ = request;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp48_ = rygel_test_request_factory_new (_tmp47_, SOUP_STATUS_OK);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp49_ = _tmp48_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp49_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp49_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp50_ = self->server;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp51_ = rygel_http_server_get_uri (_tmp50_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp52_ = _tmp51_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp53_ = _tmp52_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp54_ = soup_message_new ("GET", _tmp53_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp54_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp53_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp55_ = request;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp56_ = _tmp55_->request_headers;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp56_, "transferMode.dlna.org", "Interactive");
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp57_ = self->priv->requests;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp58_ = request;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp59_ = rygel_test_request_factory_new (_tmp58_, SOUP_STATUS_NOT_ACCEPTABLE);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp60_ = _tmp59_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp60_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp60_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp61_ = self->server;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp62_ = rygel_http_server_get_uri (_tmp61_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp63_ = _tmp62_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp64_ = _tmp63_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp65_ = soup_message_new ("GET", _tmp64_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp65_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp64_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp66_ = request;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp67_ = _tmp66_->request_headers;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp67_, "Range", "bytes=1-2");
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp68_ = self->priv->requests;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp69_ = request;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp70_ = rygel_test_request_factory_new (_tmp69_, SOUP_STATUS_OK);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp71_ = _tmp70_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp71_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp71_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp72_ = self->server;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp73_ = rygel_http_server_create_uri (_tmp72_, "AudioItem");
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp73_;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp74_ = uri;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp75_ = g_strconcat (_tmp74_, "/th/0", NULL);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp75_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp76_ = uri;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp77_ = soup_message_new ("GET", _tmp76_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp77_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp78_ = self->priv->requests;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp79_ = request;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp80_ = rygel_test_request_factory_new (_tmp79_, SOUP_STATUS_NOT_FOUND);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp81_ = _tmp80_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp81_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp81_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp82_ = self->server;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp83_ = rygel_http_server_get_uri (_tmp82_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp84_ = _tmp83_;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp85_ = _tmp84_;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp86_ = soup_message_new ("GET", _tmp85_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp86_;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp85_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp87_ = request;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp88_ = _tmp87_->request_headers;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp88_, "TimeSeekRange.dlna.org", "0");
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp89_ = self->priv->requests;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp90_ = request;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp91_ = rygel_test_request_factory_new (_tmp90_, SOUP_STATUS_NOT_ACCEPTABLE);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp92_ = _tmp91_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, _tmp92_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp92_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp93_ = self->server;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp94_ = rygel_http_server_create_uri (_tmp93_, "AudioItem");
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp94_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp95_ = uri;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp96_ = soup_message_new ("GET", _tmp95_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp96_;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp97_ = request;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp98_ = _tmp97_->request_headers;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp98_, "TimeSeekRange.dlna.org", "0");
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp99_ = self->priv->requests;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp100_ = request;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp101_ = rygel_test_request_factory_new (_tmp100_, SOUP_STATUS_BAD_REQUEST);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp102_ = _tmp101_;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp99_, _tmp102_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp102_);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp103_ = self->server;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp104_ = rygel_http_server_create_uri (_tmp103_, "AudioItem");
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp104_;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp105_ = uri;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp106_ = soup_message_new ("GET", _tmp105_);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp106_;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp107_ = request;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp108_ = _tmp107_->request_headers;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp108_, "TimeSeekRange.dlna.org", "npt=1-2049");
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp109_ = self->priv->requests;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp110_ = request;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp111_ = rygel_test_request_factory_new (_tmp110_, SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp112_ = _tmp111_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp112_);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp112_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp113_ = self->server;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp114_ = rygel_http_server_get_uri (_tmp113_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp115_ = _tmp114_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp116_ = _tmp115_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp117_ = soup_message_new ("GET", _tmp116_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp117_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp116_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp118_ = request;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp119_ = _tmp118_->request_headers;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp119_, "clienthacks.test.rygel", "f");
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp120_ = self->priv->requests;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp121_ = request;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp122_ = rygel_test_request_factory_new (_tmp121_, SOUP_STATUS_OK);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp123_ = _tmp122_;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, _tmp123_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp123_);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp124_ = self->server;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp125_ = rygel_http_server_get_uri (_tmp124_);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp126_ = _tmp125_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp127_ = _tmp126_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp128_ = soup_message_new ("GET", _tmp127_);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp128_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp127_);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp129_ = request;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp130_ = _tmp129_->request_headers;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp130_, "clienthacks.test.rygel", "t");
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp131_ = self->priv->requests;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp132_ = request;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp133_ = rygel_test_request_factory_new (_tmp132_, SOUP_STATUS_OK);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp134_ = _tmp133_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp131_, _tmp134_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp134_);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 2544 "rygel-http-get-test.c"
}


static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPGet* result = NULL;
	RygelTestRequestFactory* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPContext* _tmp3_;
	SoupServer* _tmp4_;
	SoupServer* _tmp5_;
	SoupMessage* _tmp6_;
	RygelHTTPGet* _tmp7_ = NULL;
	RygelHTTPGet* request;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->current_request;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = gupnp_context_get_server (_tmp3_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = _tmp4_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = msg;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = rygel_test_request_factory_create_get (_tmp0_, _tmp1_, _tmp5_, _tmp6_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp7_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = request;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2585 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->requests;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp2_ > 0) {
#line 2605 "rygel-http-get-test.c"
		RygelHTTPClient* _tmp3_;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_start_next_test_request (self);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = self->client;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _tmp3_, NULL, NULL);
#line 2613 "rygel-http-get-test.c"
	} else {
		GMainLoop* _tmp4_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = self->priv->main_loop;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_tmp4_);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->priv->client_done = TRUE;
#line 2622 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	RygelHTTPClient* _tmp2_;
	RygelTestRequestFactory* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	RygelHTTPClient* _tmp6_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->requests;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp0_, 0);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (self->priv->current_request);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->current_request = (RygelTestRequestFactory*) _tmp1_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->client;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->current_request;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->msg;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_tmp2_->msg);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_->msg = _tmp5_;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = self->client;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp6_, NULL, NULL);
#line 2661 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	SoupMessage* _tmp0_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 212 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message (self, _tmp0_, NULL, NULL);
#line 2677 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = _data;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->msg);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpGetTestHandleClientMessageData, _data_);
#line 2690 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	RygelHTTPGetTest* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = msg;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->msg = _tmp2_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 2717 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2725 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = _user_data_;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_source_object_ = source_object;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_res_ = _res_;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 2739 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 2748 "rygel-http-get-test.c"
		goto _state_0;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 2752 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 2757 "rygel-http-get-test.c"
	}
	_state_0:
	{
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp0_ = _data_->msg;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = NULL;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = rygel_http_get_test_create_request (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->request = _data_->_tmp1_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 2771 "rygel-http-get-test.c"
			goto __catch1_g_error;
		}
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = _data_->request;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_state_ = 1;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp2_, rygel_http_get_test_handle_client_message_ready, _data_);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2782 "rygel-http-get-test.c"
		_state_1:
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp2_, _data_->_res_);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->request;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_HTTP_GET) ? ((RygelHTTPGet*) _data_->_tmp3_) : NULL))->item;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_vala_assert (_data_->_tmp4_ != NULL, "(request as HTTPGet).item != null");
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp5_ = _data_->msg;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp6_ = 0U;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_debug ("rygel-http-get-test.vala:223: status.code: %d", (gint) _data_->_tmp7_);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp8_ = _data_->msg;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp9_ = 0U;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_get (_data_->_tmp8_, "status-code", &_data_->_tmp9_, NULL);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp11_ = _data_->self->priv->current_request;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp12_ = _data_->_tmp11_->expected_code;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_vala_assert (_data_->_tmp10_ == ((guint) _data_->_tmp12_), "msg.status_code == this.current_request.expected_code");
#line 226 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp13_ = _data_->self->priv->client_done;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_tmp13_) {
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp14_ = _data_->self->priv->main_loop;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_main_loop_quit (_data_->_tmp14_);
#line 2824 "rygel-http-get-test.c"
		}
#line 230 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->server_done = TRUE;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (_data_->request);
#line 2830 "rygel-http-get-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_inner_error_ = NULL;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp15_ = _data_->_error_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->self->priv->error);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->error = _data_->_tmp16_;
#line 233 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp17_ = _data_->self->priv->main_loop;
#line 233 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_data_->_tmp17_);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->_error_);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2857 "rygel-http-get-test.c"
		} else {
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2861 "rygel-http-get-test.c"
		}
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2867 "rygel-http-get-test.c"
	}
	__finally1:
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2878 "rygel-http-get-test.c"
	}
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2884 "rygel-http-get-test.c"
	} else {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2888 "rygel-http-get-test.c"
	}
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2894 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_;
	GMainLoop* _tmp1_;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->error = _tmp0_;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_quit (_tmp1_);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2918 "rygel-http-get-test.c"
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_CLASS (klass)->run = rygel_http_get_test_real_run;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
#line 2931 "rygel-http-get-test.c"
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
#line 2938 "rygel-http-get-test.c"
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->requests);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (self->priv->current_request);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
#line 2960 "rygel-http-get-test.c"
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id) {
	gchar* result = NULL;
	RygelVideoItem* _tmp0_;
	RygelVideoItem* item;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	RygelHTTPItemURI* _tmp3_;
	RygelHTTPItemURI* item_uri;
	gchar* _tmp4_ = NULL;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_video_item_new ();
#line 265 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item = _tmp0_;
#line 266 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 266 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 266 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) item)->id);
#line 266 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) item)->id = _tmp2_;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = rygel_http_item_uri_new ((RygelMediaItem*) item, self, -1, -1, NULL);
#line 268 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item_uri = _tmp3_;
#line 270 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = rygel_http_item_uri_to_string (item_uri);
#line 270 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp4_;
#line 270 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (item_uri);
#line 270 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (item);
#line 270 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3015 "rygel-http-get-test.c"
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
#line 3022 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPContext* _tmp10_;
	SoupServer* _tmp11_;
	SoupServer* _tmp12_;
	RygelMediaContainer* _tmp13_;
	GError * _inner_error_ = NULL;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 3042 "rygel-http-get-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = _tmp0_;
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 3052 "rygel-http-get-test.c"
			goto __catch2_g_error;
		}
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self->context);
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->context = _tmp1_;
#line 3059 "rygel-http-get-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 279 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp2_;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 3076 "rygel-http-get-test.c"
		goto __finally2;
	}
	__finally2:
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_propagate_error (error, _inner_error_);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (self);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 3090 "rygel-http-get-test.c"
		} else {
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_clear_error (&_inner_error_);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 3098 "rygel-http-get-test.c"
		}
	}
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->context;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (_tmp3_ != NULL, "this.context != null");
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->context;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (_tmp6_ != NULL, "this.context.host_ip != null");
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->context;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = _tmp8_;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (_tmp9_ > ((guint) 0), "this.context.port > 0");
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = self->context;
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = _tmp11_;
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_add_handler (_tmp12_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = rygel_media_container_new ();
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->root_container = _tmp13_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3137 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 3144 "rygel-http-get-test.c"
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (path != NULL);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->context;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gupnp_context_get_server (_tmp0_);
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = msg;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_pause_message (_tmp2_, _tmp3_);
#line 297 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = msg;
#line 297 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp4_);
#line 3178 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_ = NULL;
#line 300 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 300 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 301 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = target;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
#line 3196 "rygel-http-get-test.c"
		RygelTranscoder* _tmp1_;
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = rygel_transcoder_new ("mp3");
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp1_;
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 3204 "rygel-http-get-test.c"
	}
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = target;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_inner_error_ = _tmp3_;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_propagate_error (error, _inner_error_);
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 3216 "rygel-http-get-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3228 "rygel-http-get-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_create_uri (self, "VideoItem");
#line 260 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3243 "rygel-http-get-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 3260 "rygel-http-get-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 256 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 3278 "rygel-http-get-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3311 "rygel-http-get-test.c"
		default:
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3317 "rygel-http-get-test.c"
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 317 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = context;
#line 317 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 317 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 317 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->context = _tmp1_;
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3340 "rygel-http-get-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context) {
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context);
#line 3347 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 3358 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 3380 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3388 "rygel-http-get-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data1_;
#line 3397 "rygel-http-get-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 3406 "rygel-http-get-test.c"
		RygelHTTPClient * self;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data1_->self;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 3422 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3432 "rygel-http-get-test.c"
}


static void __lambda5_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data1_->self;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (session != NULL);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 3446 "rygel-http-get-test.c"
}


static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__lambda5_ (self, session, msg);
#line 3453 "rygel-http-get-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 3462 "rygel-http-get-test.c"
		goto _state_0;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 3466 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 3471 "rygel-http-get-test.c"
	}
	_state_0:
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->context;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = gupnp_context_get_session (_data_->_tmp0_);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp3_ = _data_->self->msg;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda5__soup_session_callback, _data_->_data1_);
#line 327 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 327 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3504 "rygel-http-get-test.c"
	_state_1:
	;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block1_data_unref (_data_->_data1_);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3517 "rygel-http-get-test.c"
	} else {
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3521 "rygel-http-get-test.c"
	}
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3527 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3543 "rygel-http-get-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 3563 "rygel-http-get-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3580 "rygel-http-get-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 3595 "rygel-http-get-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 3602 "rygel-http-get-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 311 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 312 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 3618 "rygel-http-get-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3647 "rygel-http-get-test.c"
		default:
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3653 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3669 "rygel-http-get-test.c"
		default:
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3675 "rygel-http-get-test.c"
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_data_->item_id);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->result);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->self);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
#line 3693 "rygel-http-get-test.c"
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? rygel_media_object_ref (self) : NULL;
#line 3700 "rygel-http-get-test.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_media_container_find_object);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _rygel_media_object_ref0 (self);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->item_id = _tmp2_;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = cancellable;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->cancellable = _tmp4_;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_find_object_co (_data_);
#line 3735 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 3746 "rygel-http-get-test.c"
	}
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _data_->result;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->result = NULL;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3756 "rygel-http-get-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data2_;
#line 3765 "rygel-http-get-test.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3774 "rygel-http-get-test.c"
		RygelMediaContainer * self;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data2_->self;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue = NULL;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target = NULL;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target_destroy_notify = NULL;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_rygel_media_object_unref0 (self);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 3790 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3800 "rygel-http-get-test.c"
}


static gboolean __lambda2_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
#line 339 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data2_->self;
#line 340 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _data2_->find_object_continue;
#line 340 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0__target = _data2_->find_object_continue_target;
#line 340 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ (_tmp0__target);
#line 342 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 342 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3821 "rygel-http-get-test.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 339 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3830 "rygel-http-get-test.c"
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 3839 "rygel-http-get-test.c"
		goto _state_0;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 3843 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 3848 "rygel-http-get-test.c"
	}
	_state_0:
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->self = rygel_media_object_ref (_data_->self);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target = _data_;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target_destroy_notify = NULL;
#line 339 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 345 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 345 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3871 "rygel-http-get-test.c"
	_state_1:
	;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->item_id;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_debug ("rygel-http-get-test.vala:347: item id: %s", _data_->_tmp0_);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->item_id;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_data_->_tmp1_, "VideoItem") == 0) {
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = rygel_video_item_new ();
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp2_;
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		block2_data_unref (_data_->_data2_);
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_data2_ = NULL;
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3894 "rygel-http-get-test.c"
		} else {
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3898 "rygel-http-get-test.c"
		}
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 3904 "rygel-http-get-test.c"
	} else {
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->item_id;
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (g_strcmp0 (_data_->_tmp3_, "AudioItem") == 0) {
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp4_ = rygel_audio_item_new ();
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->result = (RygelMediaObject*) _data_->_tmp4_;
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			block2_data_unref (_data_->_data2_);
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_data2_ = NULL;
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (_data_->_state_ == 0) {
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3922 "rygel-http-get-test.c"
			} else {
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3926 "rygel-http-get-test.c"
			}
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_object_unref (_data_->_async_result);
#line 351 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return FALSE;
#line 3932 "rygel-http-get-test.c"
		} else {
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->result = NULL;
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			block2_data_unref (_data_->_data2_);
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_data2_ = NULL;
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (_data_->_state_ == 0) {
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3944 "rygel-http-get-test.c"
			} else {
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3948 "rygel-http-get-test.c"
			}
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_object_unref (_data_->_async_result);
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return FALSE;
#line 3954 "rygel-http-get-test.c"
		}
	}
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block2_data_unref (_data_->_data2_);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = NULL;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3965 "rygel-http-get-test.c"
	} else {
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3969 "rygel-http-get-test.c"
	}
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3975 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3985 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 3992 "rygel-http-get-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 333 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 3999 "rygel-http-get-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPGet* _tmp0_;
	RygelHTTPResponse* _tmp1_;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 360 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 360 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = rygel_http_response_new (_tmp0_);
#line 360 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp1_;
#line 360 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4035 "rygel-http-get-test.c"
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
#line 363 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 363 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (get_request != NULL);
#line 4044 "rygel-http-get-test.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler* self = NULL;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4054 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_init (GValue* value) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 4061 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (value->data[0].v_pointer);
#line 4070 "rygel-http-get-test.c"
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
#line 4080 "rygel-http-get-test.c"
	} else {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4084 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4092 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 4099 "rygel-http-get-test.c"
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4106 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4110 "rygel-http-get-test.c"
		}
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
#line 4114 "rygel-http-get-test.c"
	} else {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4118 "rygel-http-get-test.c"
	}
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4122 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4133 "rygel-http-get-test.c"
	}
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 4139 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 4143 "rygel-http-get-test.c"
	} else {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 4147 "rygel-http-get-test.c"
	}
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4151 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 4165 "rygel-http-get-test.c"
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4174 "rygel-http-get-test.c"
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 4194 "rygel-http-get-test.c"
	} else {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4198 "rygel-http-get-test.c"
	}
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 4204 "rygel-http-get-test.c"
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 4223 "rygel-http-get-test.c"
	} else {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4227 "rygel-http-get-test.c"
	}
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 4233 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 4243 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 4250 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
#line 4258 "rygel-http-get-test.c"
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 4283 "rygel-http-get-test.c"
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4296 "rygel-http-get-test.c"
	}
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
	RygelHTTPTranscodeHandler* self = NULL;
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (transcoder != NULL, NULL);
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4311 "rygel-http-get-test.c"
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
#line 4318 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
#line 4325 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler* self = NULL;
#line 372 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 372 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
#line 372 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4353 "rygel-http-get-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
#line 372 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
#line 4360 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 371 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 4367 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 383 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 384 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = ((RygelMediaObject*) self)->id;
#line 384 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_tmp0_, "VideoItem") == 0) {
#line 385 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = FALSE;
#line 385 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 4400 "rygel-http-get-test.c"
	} else {
#line 387 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = TRUE;
#line 387 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 4406 "rygel-http-get-test.c"
	}
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 390 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = TRUE;
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4419 "rygel-http-get-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
#line 375 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 375 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4429 "rygel-http-get-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 375 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 375 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 4438 "rygel-http-get-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->subtitles = _tmp0_;
#line 378 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
#line 378 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->thumbnails = _tmp1_;
#line 379 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 379 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->uris = _tmp2_;
#line 381 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->place_holder = FALSE;
#line 4462 "rygel-http-get-test.c"
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
#line 375 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 378 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->thumbnails);
#line 379 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->uris);
#line 375 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 4478 "rygel-http-get-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem* self = NULL;
	gchar* _tmp0_;
#line 398 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("AudioItem");
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) self)->id = _tmp0_;
#line 398 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4507 "rygel-http-get-test.c"
}


RygelAudioItem* rygel_audio_item_new (void) {
#line 398 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 4514 "rygel-http-get-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 395 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 395 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 4523 "rygel-http-get-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 396 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->duration = (gint64) 2048;
#line 4530 "rygel-http-get-test.c"
}


static void rygel_audio_item_finalize (RygelMediaObject* obj) {
	RygelAudioItem * self;
#line 395 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
#line 395 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 4540 "rygel-http-get-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self) {
	gboolean result = FALSE;
#line 413 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 413 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4562 "rygel-http-get-test.c"
}


gboolean rygel_visual_item_streamable (RygelVisualItem* self) {
	gboolean result = FALSE;
#line 417 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 417 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4572 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
#line 4581 "rygel-http-get-test.c"
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
#line 4590 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
#line 4599 "rygel-http-get-test.c"
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
#line 4608 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_pixel_width (RygelVisualItem* self) {
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_width (self);
#line 4617 "rygel-http-get-test.c"
}


void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value) {
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_width (self, value);
#line 4626 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_pixel_height (RygelVisualItem* self) {
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_height (self);
#line 4635 "rygel-http-get-test.c"
}


void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value) {
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_height (self, value);
#line 4644 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
#line 4653 "rygel-http-get-test.c"
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
#line 4662 "rygel-http-get-test.c"
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
#line 410 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 410 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
#line 4671 "rygel-http-get-test.c"
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
#line 410 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 410 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
#line 4680 "rygel-http-get-test.c"
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
#line 403 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	static gboolean initialized = FALSE;
#line 403 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!initialized) {
#line 403 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		initialized = TRUE;
#line 4691 "rygel-http-get-test.c"
	}
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem* self = NULL;
	gchar* _tmp0_;
#line 430 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type);
#line 431 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("VideoItem");
#line 431 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 431 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) self)->id = _tmp0_;
#line 430 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4722 "rygel-http-get-test.c"
}


RygelVideoItem* rygel_video_item_new (void) {
#line 430 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
#line 4729 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_width;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4745 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = _tmp0_;
#line 4758 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_height;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4774 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = _tmp0_;
#line 4787 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_pixel_width;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4803 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_width = _tmp0_;
#line 4816 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_pixel_height;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4832 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_height = _tmp0_;
#line 4845 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_color_depth;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4861 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = _tmp0_;
#line 4874 "rygel-http-get-test.c"
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	RygelThumbnail* _tmp2_;
	RygelThumbnail* _tmp3_;
	GeeArrayList* _tmp4_;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->ts);
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->ts = _tmp0_;
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->ts;
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_thumbnail_new ();
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_;
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (_tmp3_);
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->priv->ts;
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp4_;
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4910 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
#line 441 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 4918 "rygel-http-get-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
#line 4929 "rygel-http-get-test.c"
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_width = rygel_video_item_real_get_width;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_width = rygel_video_item_real_set_width;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_height = rygel_video_item_real_get_height;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_height = rygel_video_item_real_set_height;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
#line 4960 "rygel-http-get-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = -1;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = -1;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_width = -1;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_height = -1;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = -1;
#line 4977 "rygel-http-get-test.c"
}


static void rygel_video_item_finalize (RygelMediaObject* obj) {
	RygelVideoItem * self;
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 428 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->ts);
#line 444 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 421 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 4991 "rygel-http-get-test.c"
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem* self = NULL;
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type);
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5015 "rygel-http-get-test.c"
}


RygelMusicItem* rygel_music_item_new (void) {
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
#line 5022 "rygel-http-get-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 5031 "rygel-http-get-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (RygelMediaObject* obj) {
	RygelMusicItem * self;
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (self->album_art);
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 5047 "rygel-http-get-test.c"
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelThumbnail*) g_type_create_instance (object_type);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5069 "rygel-http-get-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 5076 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5083 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_free_value (GValue* value) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (value->data[0].v_pointer);
#line 5092 "rygel-http-get-test.c"
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
#line 5102 "rygel-http-get-test.c"
	} else {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5106 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5114 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5121 "rygel-http-get-test.c"
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5128 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5132 "rygel-http-get-test.c"
		}
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
#line 5136 "rygel-http-get-test.c"
	} else {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5140 "rygel-http-get-test.c"
	}
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5144 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5155 "rygel-http-get-test.c"
	}
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5161 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5165 "rygel-http-get-test.c"
	} else {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
#line 5169 "rygel-http-get-test.c"
	}
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5173 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5187 "rygel-http-get-test.c"
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5196 "rygel-http-get-test.c"
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_ref (value->data[0].v_pointer);
#line 5216 "rygel-http-get-test.c"
	} else {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5220 "rygel-http-get-test.c"
	}
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 5226 "rygel-http-get-test.c"
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5245 "rygel-http-get-test.c"
	} else {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5249 "rygel-http-get-test.c"
	}
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 5255 "rygel-http-get-test.c"
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 5265 "rygel-http-get-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5274 "rygel-http-get-test.c"
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
#line 453 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->file_extension);
#line 5284 "rygel-http-get-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5309 "rygel-http-get-test.c"
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5322 "rygel-http-get-test.c"
	}
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle* self = NULL;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelSubtitle*) g_type_create_instance (object_type);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5333 "rygel-http-get-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 5340 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_init (GValue* value) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5347 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_free_value (GValue* value) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (value->data[0].v_pointer);
#line 5356 "rygel-http-get-test.c"
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
#line 5366 "rygel-http-get-test.c"
	} else {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5370 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5378 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5385 "rygel-http-get-test.c"
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5392 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5396 "rygel-http-get-test.c"
		}
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_subtitle_ref (object);
#line 5400 "rygel-http-get-test.c"
	} else {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5404 "rygel-http-get-test.c"
	}
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5408 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5419 "rygel-http-get-test.c"
	}
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5425 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5429 "rygel-http-get-test.c"
	} else {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
#line 5433 "rygel-http-get-test.c"
	}
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5437 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5451 "rygel-http-get-test.c"
}


gpointer rygel_value_get_subtitle (const GValue* value) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5460 "rygel-http-get-test.c"
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_ref (value->data[0].v_pointer);
#line 5480 "rygel-http-get-test.c"
	} else {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5484 "rygel-http-get-test.c"
	}
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 5490 "rygel-http-get-test.c"
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5509 "rygel-http-get-test.c"
	} else {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5513 "rygel-http-get-test.c"
	}
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 5519 "rygel-http-get-test.c"
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_SUBTITLE_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 5529 "rygel-http-get-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5538 "rygel-http-get-test.c"
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
#line 458 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->caption_type);
#line 5548 "rygel-http-get-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5573 "rygel-http-get-test.c"
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
#line 456 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5586 "rygel-http-get-test.c"
	}
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessageHeaders* _tmp4_;
	RygelHTTPGet* _tmp5_;
	SoupServer* _tmp6_;
	SoupServer* _tmp7_;
#line 467 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 467 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->msg = _tmp2_;
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->msg;
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->response_headers;
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_set_encoding (_tmp4_, SOUP_ENCODING_CONTENT_LENGTH);
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = get_request;
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->server;
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->server = _tmp7_;
#line 467 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5633 "rygel-http-get-test.c"
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
#line 467 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 5640 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpResponseRunData, _data_);
#line 5651 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_real_run_co (_data_);
#line 5673 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 5681 "rygel-http-get-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data3_;
#line 5690 "rygel-http-get-test.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5699 "rygel-http-get-test.c"
		RygelHTTPResponse * self;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data3_->self;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue = NULL;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target = NULL;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target_destroy_notify = NULL;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 5715 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5725 "rygel-http-get-test.c"
}


static gboolean __lambda3_ (Block3Data* _data3_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
#line 476 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data3_->self;
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data3_->run_continue (_data3_->run_continue_target);
#line 479 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 479 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5740 "rygel-http-get-test.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 476 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5749 "rygel-http-get-test.c"
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 5758 "rygel-http-get-test.c"
		goto _state_0;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 5762 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 5767 "rygel-http-get-test.c"
	}
	_state_0:
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue = _rygel_http_response_real_run_co_gsource_func;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target = _data_;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target_destroy_notify = NULL;
#line 476 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda3__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 482 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 482 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 5790 "rygel-http-get-test.c"
	_state_1:
	;
#line 484 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->priv->msg;
#line 484 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_set_status (_data_->_tmp0_, (guint) SOUP_STATUS_OK);
#line 485 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->self->priv->server;
#line 485 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->self->priv->msg;
#line 485 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_unpause_message (_data_->_tmp1_, _data_->_tmp2_);
#line 487 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block3_data_unref (_data_->_data3_);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = NULL;
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5813 "rygel-http-get-test.c"
	} else {
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 5817 "rygel-http-get-test.c"
	}
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 473 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 5823 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5839 "rygel-http-get-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 5859 "rygel-http-get-test.c"
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5876 "rygel-http-get-test.c"
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_response_real_run_finish;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
#line 5891 "rygel-http-get-test.c"
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
#line 5898 "rygel-http-get-test.c"
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 464 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 465 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
#line 5914 "rygel-http-get-test.c"
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5943 "rygel-http-get-test.c"
		default:
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5949 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5965 "rygel-http-get-test.c"
		default:
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5971 "rygel-http-get-test.c"
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaObject*) g_type_create_instance (object_type);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5982 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 5989 "rygel-http-get-test.c"
}


static void rygel_value_media_object_init (GValue* value) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5996 "rygel-http-get-test.c"
}


static void rygel_value_media_object_free_value (GValue* value) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (value->data[0].v_pointer);
#line 6005 "rygel-http-get-test.c"
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
#line 6015 "rygel-http-get-test.c"
	} else {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6019 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 6027 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 6034 "rygel-http-get-test.c"
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6041 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6045 "rygel-http-get-test.c"
		}
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_media_object_ref (object);
#line 6049 "rygel-http-get-test.c"
	} else {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6053 "rygel-http-get-test.c"
	}
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 6057 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6068 "rygel-http-get-test.c"
	}
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 6074 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 6078 "rygel-http-get-test.c"
	} else {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
#line 6082 "rygel-http-get-test.c"
	}
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 6086 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 6100 "rygel-http-get-test.c"
}


gpointer rygel_value_get_media_object (const GValue* value) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 6109 "rygel-http-get-test.c"
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_ref (value->data[0].v_pointer);
#line 6129 "rygel-http-get-test.c"
	} else {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6133 "rygel-http-get-test.c"
	}
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 6139 "rygel-http-get-test.c"
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 6158 "rygel-http-get-test.c"
	} else {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6162 "rygel-http-get-test.c"
	}
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 6168 "rygel-http-get-test.c"
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 6178 "rygel-http-get-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	gchar* _tmp0_;
#line 493 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("");
#line 493 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->mime_type = _tmp0_;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 6190 "rygel-http-get-test.c"
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->id);
#line 493 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->mime_type);
#line 6202 "rygel-http-get-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 6227 "rygel-http-get-test.c"
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
#line 491 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6240 "rygel-http-get-test.c"
	}
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_;
#line 499 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 499 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
#line 500 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = extension;
#line 500 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_set_extension (self, _tmp0_);
#line 499 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 6258 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
#line 499 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
#line 6265 "rygel-http-get-test.c"
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_extension;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 6280 "rygel-http-get-test.c"
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->priv->_extension);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_extension = _tmp1_;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "extension");
#line 6299 "rygel-http-get-test.c"
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 6316 "rygel-http-get-test.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
#line 6323 "rygel-http-get-test.c"
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->priv->_extension);
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
#line 6335 "rygel-http-get-test.c"
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_transcoder_get_extension (self));
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6362 "rygel-http-get-test.c"
		default:
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6368 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_set_extension (self, g_value_get_string (value));
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6384 "rygel-http-get-test.c"
		default:
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 496 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6390 "rygel-http-get-test.c"
	}
}



