/* rygel-http-time-seek-test.c generated by valac 0.15.2, the Vala compiler
 * generated from rygel-http-time-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_TIME_SEEK_TEST (rygel_http_time_seek_test_get_type ())
#define RYGEL_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTest))
#define RYGEL_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))

typedef struct _RygelHTTPTimeSeekTest RygelHTTPTimeSeekTest;
typedef struct _RygelHTTPTimeSeekTestClass RygelHTTPTimeSeekTestClass;
typedef struct _RygelHTTPTimeSeekTestPrivate RygelHTTPTimeSeekTestPrivate;

#define RYGEL_HTTP_TIME_SEEK_TEST_TYPE_TEST_TYPE (rygel_http_time_seek_test_test_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPTranscodeHandler {
	GObject parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekTest {
	GObject parent_instance;
	RygelHTTPTimeSeekTestPrivate * priv;
};

struct _RygelHTTPTimeSeekTestClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING,
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING,
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING
} RygelHTTPTimeSeekTestTestType;

struct _RygelHTTPTimeSeekTestPrivate {
	GRegex* range_regex;
	RygelHTTPTimeSeekTestTestType test_type;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_time_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
static void rygel_audio_item_finalize (GObject* obj);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_strings (const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_strings (GType object_type, const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_string_headers (RygelHTTPGet* self, const gchar* start, const gchar* stop);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_time_seek_test_get_type (void) G_GNUC_CONST;
static GType rygel_http_time_seek_test_test_type_get_type (void) G_GNUC_UNUSED;
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestPrivate))
enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_time_seek_test_main (gchar** args, int args_length1);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error);
static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
static void rygel_http_time_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type) {
	RygelHTTPTranscodeHandler * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPTranscodeHandler*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 331 "rygel-http-time-seek-test.c"
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER);
#line 338 "rygel-http-time-seek-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
#line 345 "rygel-http-time-seek-test.c"
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	result = TRUE;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return result;
#line 373 "rygel-http-time-seek-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelMediaItem*) g_object_new (object_type, NULL);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 383 "rygel-http-time-seek-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 392 "rygel-http-time-seek-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 33 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->size = (gint64) (-1);
#line 399 "rygel-http-time-seek-test.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 409 "rygel-http-time-seek-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem * self = NULL;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 431 "rygel-http-time-seek-test.c"
}


RygelAudioItem* rygel_audio_item_new (void) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 438 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 447 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 41 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->duration = (gint64) 2048;
#line 454 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_finalize (GObject* obj) {
	RygelAudioItem * self;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = RYGEL_AUDIO_ITEM (obj);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 464 "rygel-http-time-seek-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 486 "rygel-http-time-seek-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 493 "rygel-http-time-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 500 "rygel-http-time-seek-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 526 "rygel-http-time-seek-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 533 "rygel-http-time-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 540 "rygel-http-time-seek-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 61 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 563 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	RygelAudioItem* _tmp1_;
	RygelHTTPTranscodeHandler* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelSubtitle* _tmp5_;
	RygelSubtitle* _tmp6_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->msg = _tmp0_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = rygel_audio_item_new ();
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->item);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->item = (RygelMediaItem*) _tmp1_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = rygel_http_transcode_handler_new ();
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->handler = _tmp2_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = thumbnail;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->thumbnail = _tmp4_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = subtitle;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->subtitle = _tmp6_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 614 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
#line 621 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = start;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 642 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
#line 649 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 78 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = stop;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 670 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
#line 677 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = start;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = stop;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 701 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 708 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_strings (GType object_type, const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (start != NULL, NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (stop != NULL, NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = start;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = stop;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_string_headers (self, _tmp2_, _tmp3_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 736 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_strings (const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_strings (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 743 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	gint64 _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* stop_str;
	gint64 _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* range;
	SoupMessage* _tmp17_;
	SoupMessageHeaders* _tmp18_;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = start;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (_tmp0_ >= ((gint64) 0));
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = stop;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_tmp2_ > ((gint64) 0)) {
#line 776 "rygel-http-time-seek-test.c"
		gint64 _tmp3_;
		gchar* _tmp4_ = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp3_ = stop;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_free0 (_tmp1_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = _tmp4_;
#line 787 "rygel-http-time-seek-test.c"
	} else {
		gchar* _tmp5_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp5_ = g_strdup ("");
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_free0 (_tmp1_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = _tmp5_;
#line 796 "rygel-http-time-seek-test.c"
	}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = _tmp1_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	stop_str = _tmp7_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = start;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = _tmp9_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp11_ = g_strconcat ("npt=", _tmp10_, NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp12_ = _tmp11_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp13_ = g_strconcat (_tmp12_, "-", NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp14_ = _tmp13_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp15_ = g_strconcat (_tmp14_, stop_str, NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp16_ = _tmp15_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp14_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp12_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp10_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	range = _tmp16_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp17_ = self->msg;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp18_ = _tmp17_->request_headers;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	soup_message_headers_append (_tmp18_, "TimeSeekRange.dlna.org", range);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (range);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (stop_str);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp1_);
#line 842 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_add_string_headers (RygelHTTPGet* self, const gchar* start, const gchar* stop) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* range;
	SoupMessage* _tmp8_;
	SoupMessageHeaders* _tmp9_;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (start != NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (stop != NULL);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = start;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = g_strconcat ("npt=", _tmp0_, NULL);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = _tmp1_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = g_strconcat (_tmp2_, "-", NULL);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = _tmp3_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = stop;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = _tmp6_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp4_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp2_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	range = _tmp7_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = self->msg;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = _tmp8_->request_headers;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	soup_message_headers_append (_tmp9_, "TimeSeekRange.dlna.org", range);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (range);
#line 894 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 903 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = RYGEL_HTTP_GET (obj);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->item);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 927 "rygel-http-time-seek-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


static GType rygel_http_time_seek_test_test_type_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_test_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_test_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING", "test-seconds-parsing"}, {RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING", "test-hhmmss-parsing"}, {RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING", "test-mixed-parsing"}, {0, NULL, NULL}};
		GType rygel_http_time_seek_test_test_type_type_id;
		rygel_http_time_seek_test_test_type_type_id = g_enum_register_static ("RygelHTTPTimeSeekTestTestType", values);
		g_once_init_leave (&rygel_http_time_seek_test_test_type_type_id__volatile, rygel_http_time_seek_test_test_type_type_id);
	}
	return rygel_http_time_seek_test_test_type_type_id__volatile;
}


gint rygel_http_time_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPTimeSeekTest* _tmp0_;
		RygelHTTPTimeSeekTest* test;
		RygelHTTPTimeSeekTest* _tmp1_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp0_ = rygel_http_time_seek_test_new ();
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		test = _tmp0_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = test;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		rygel_http_time_seek_test_run (_tmp1_, &_inner_error_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (test);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 976 "rygel-http-time-seek-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_object_unref0 (test);
#line 983 "rygel-http-time-seek-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_error_ = _inner_error_;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_inner_error_ = NULL;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		result = 77;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_error_free0 (_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return result;
#line 999 "rygel-http-time-seek-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_error_ = _inner_error_;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp2_ = _error_;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp3_ = _tmp2_->message;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_critical ("rygel-http-time-seek-test.vala:129: %s", _tmp3_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		result = -1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_error_free0 (_error_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return result;
#line 1023 "rygel-http-time-seek-test.c"
	}
	__finally0:
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return 0;
#line 1034 "rygel-http-time-seek-test.c"
	}
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	result = 0;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return result;
#line 1040 "rygel-http-time-seek-test.c"
}


int main (int argc, char ** argv) {
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_thread_init (NULL);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_type_init ();
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_time_seek_test_main (argv, argc);
#line 1051 "rygel-http-time-seek-test.c"
}


void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelThumbnail** _tmp1_ = NULL;
	RygelThumbnail** thumbnails;
	gint thumbnails_length1;
	gint _thumbnails_size_;
	RygelSubtitle* _tmp2_;
	RygelSubtitle** _tmp3_ = NULL;
	RygelSubtitle** subtitles;
	gint subtitles_length1;
	gint _subtitles_size_;
	RygelThumbnail** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_[0] = NULL;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_[1] = _tmp0_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	thumbnails = _tmp1_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	thumbnails_length1 = 2;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_thumbnails_size_ = thumbnails_length1;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = rygel_subtitle_new ();
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_[0] = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_[1] = _tmp2_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	subtitles = _tmp3_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	subtitles_length1 = 2;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_subtitles_size_ = subtitles_length1;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = thumbnails;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4__length1 = thumbnails_length1;
#line 1103 "rygel-http-time-seek-test.c"
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		thumbnail_collection = _tmp4_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		thumbnail_collection_length1 = _tmp4__length1;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
#line 1115 "rygel-http-time-seek-test.c"
			RygelThumbnail* _tmp5_;
			RygelThumbnail* thumbnail = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			thumbnail = _tmp5_;
#line 1122 "rygel-http-time-seek-test.c"
			{
				RygelSubtitle** _tmp6_;
				gint _tmp6__length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
				_tmp6_ = subtitles;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
				_tmp6__length1 = subtitles_length1;
#line 1130 "rygel-http-time-seek-test.c"
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
					subtitle_collection = _tmp6_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
					subtitle_collection_length1 = _tmp6__length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
#line 1142 "rygel-http-time-seek-test.c"
						RygelSubtitle* _tmp7_;
						RygelSubtitle* subtitle = NULL;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
						subtitle = _tmp7_;
#line 1149 "rygel-http-time-seek-test.c"
						{
							RygelThumbnail* _tmp8_;
							RygelSubtitle* _tmp9_;
							RygelThumbnail* _tmp10_;
							RygelSubtitle* _tmp11_;
							RygelThumbnail* _tmp12_;
							RygelSubtitle* _tmp13_;
							RygelThumbnail* _tmp14_;
							RygelSubtitle* _tmp15_;
							RygelThumbnail* _tmp16_;
							RygelSubtitle* _tmp17_;
							RygelThumbnail* _tmp18_;
							RygelSubtitle* _tmp19_;
							RygelThumbnail* _tmp20_;
							RygelSubtitle* _tmp21_;
							RygelThumbnail* _tmp22_;
							RygelSubtitle* _tmp23_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp8_ = thumbnail;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp9_ = subtitle;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1191 "rygel-http-time-seek-test.c"
								} else {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1207 "rygel-http-time-seek-test.c"
								}
							}
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp10_ = thumbnail;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp11_ = subtitle;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1232 "rygel-http-time-seek-test.c"
								} else {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1248 "rygel-http-time-seek-test.c"
								}
							}
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp12_ = thumbnail;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp13_ = subtitle;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1273 "rygel-http-time-seek-test.c"
								} else {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1289 "rygel-http-time-seek-test.c"
								}
							}
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp14_ = thumbnail;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp15_ = subtitle;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1314 "rygel-http-time-seek-test.c"
								} else {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1330 "rygel-http-time-seek-test.c"
								}
							}
#line 148 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp16_ = thumbnail;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp17_ = subtitle;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_only_seek (self, _tmp16_, _tmp17_, &_inner_error_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1357 "rygel-http-time-seek-test.c"
								} else {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1373 "rygel-http-time-seek-test.c"
								}
							}
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp18_ = thumbnail;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp19_ = subtitle;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_stop_only_seek (self, _tmp18_, _tmp19_, &_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1398 "rygel-http-time-seek-test.c"
								} else {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1414 "rygel-http-time-seek-test.c"
								}
							}
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp20_ = thumbnail;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp21_ = subtitle;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp20_, _tmp21_, &_inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1439 "rygel-http-time-seek-test.c"
								} else {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1455 "rygel-http-time-seek-test.c"
								}
							}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp22_ = thumbnail;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp23_ = subtitle;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp22_, _tmp23_, &_inner_error_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1482 "rygel-http-time-seek-test.c"
								} else {
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1498 "rygel-http-time-seek-test.c"
								}
							}
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_g_object_unref0 (subtitle);
#line 1503 "rygel-http-time-seek-test.c"
						}
					}
				}
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
				_g_object_unref0 (thumbnail);
#line 1509 "rygel-http-time-seek-test.c"
			}
		}
	}
#line 137 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1517 "rygel-http-time-seek-test.c"
}


static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type) {
	RygelHTTPTimeSeekTest * self = NULL;
	gchar* _tmp0_;
	gchar* expression;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	GError * _inner_error_ = NULL;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPTimeSeekTest*) g_object_new (object_type, NULL);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = g_strdup ("npt=[0-9]+\\.[0-9][0-9][0-9]-" "[0-9]+\\.[0-9][0-9][0-9]/" "[0-9]+\\.[0-9][0-9][0-9]");
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	expression = _tmp0_;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = g_regex_new (expression, G_REGEX_CASELESS, 0, &_inner_error_);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = _tmp1_;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_free0 (expression);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return NULL;
#line 1548 "rygel-http-time-seek-test.c"
	}
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->priv->range_regex = _tmp2_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (expression);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 1558 "rygel-http-time-seek-test.c"
}


static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void) {
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_time_seek_test_construct (RYGEL_TYPE_HTTP_TIME_SEEK_TEST);
#line 1565 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	RygelMediaItem* _tmp3_;
	RygelAudioItem* _tmp4_;
	RygelAudioItem* audio_item;
	gint64 _tmp5_;
	GError * _inner_error_ = NULL;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = _tmp2_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = request->item;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp3_) ? ((RygelAudioItem*) _tmp3_) : NULL);
#line 169 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	audio_item = _tmp4_;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = audio_item->duration;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 0, (_tmp5_ * GST_SECOND) - GST_MSECOND, &_inner_error_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1611 "rygel-http-time-seek-test.c"
		} else {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1623 "rygel-http-time-seek-test.c"
		}
	}
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (audio_item);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 1630 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request;
	RygelHTTPTimeSeekTestTestType _tmp0_;
	RygelHTTPGet* _tmp7_;
	RygelMediaItem* _tmp8_;
	RygelAudioItem* _tmp9_;
	RygelAudioItem* audio_item;
	RygelHTTPGet* _tmp10_;
	gint64 _tmp11_;
	GError * _inner_error_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 176 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = self->priv->test_type;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	switch (_tmp0_) {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
#line 1654 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp1_;
			RygelSubtitle* _tmp2_;
			RygelHTTPGet* _tmp3_;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp1_ = thumbnail;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp2_ = subtitle;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp3_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp1_, _tmp2_);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp3_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1671 "rygel-http-time-seek-test.c"
		}
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
#line 1675 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp4_;
			RygelSubtitle* _tmp5_;
			RygelHTTPGet* _tmp6_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp4_ = thumbnail;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = subtitle;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp6_ = rygel_http_get_new_seek_strings ("00:02:08.000", "", _tmp4_, _tmp5_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp6_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1692 "rygel-http-time-seek-test.c"
		}
		default:
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		break;
#line 1697 "rygel-http-time-seek-test.c"
	}
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = request;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = _tmp7_->item;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp8_) ? ((RygelAudioItem*) _tmp8_) : NULL);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	audio_item = _tmp9_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = request;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp11_ = audio_item->duration;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, _tmp10_, (gint64) (128 * GST_SECOND), (_tmp11_ * GST_SECOND) - GST_MSECOND, &_inner_error_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1725 "rygel-http-time-seek-test.c"
		} else {
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1737 "rygel-http-time-seek-test.c"
		}
	}
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (audio_item);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 1744 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request;
	RygelHTTPTimeSeekTestTestType _tmp0_;
	RygelHTTPGet* _tmp7_;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = self->priv->test_type;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	switch (_tmp0_) {
#line 201 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
#line 1763 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp1_;
			RygelSubtitle* _tmp2_;
			RygelHTTPGet* _tmp3_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp1_ = thumbnail;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp2_ = subtitle;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp3_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp1_, _tmp2_);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp3_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1780 "rygel-http-time-seek-test.c"
		}
#line 201 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
#line 1784 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp4_;
			RygelSubtitle* _tmp5_;
			RygelHTTPGet* _tmp6_;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp4_ = thumbnail;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = subtitle;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp6_ = rygel_http_get_new_seek_strings ("00:00:00.000", "00:02:08.000", _tmp4_, _tmp5_);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp6_;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1801 "rygel-http-time-seek-test.c"
		}
		default:
#line 201 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		break;
#line 1806 "rygel-http-time-seek-test.c"
	}
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = request;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, _tmp7_, (gint64) 0, (gint64) (128 * GST_SECOND), &_inner_error_);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1822 "rygel-http-time-seek-test.c"
		} else {
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1832 "rygel-http-time-seek-test.c"
		}
	}
#line 196 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 1837 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request;
	RygelHTTPTimeSeekTestTestType _tmp0_;
	RygelHTTPGet* _tmp10_;
	GError * _inner_error_ = NULL;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = NULL;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = self->priv->test_type;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	switch (_tmp0_) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
#line 1856 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp1_;
			RygelSubtitle* _tmp2_;
			RygelHTTPGet* _tmp3_;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp1_ = thumbnail;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp2_ = subtitle;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp3_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp1_, _tmp2_);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp3_;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1873 "rygel-http-time-seek-test.c"
		}
#line 224 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
#line 1877 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp4_;
			RygelSubtitle* _tmp5_;
			RygelHTTPGet* _tmp6_;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp4_ = thumbnail;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = subtitle;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp6_ = rygel_http_get_new_seek_strings ("00:02:08.000", "00:04:16.000", _tmp4_, _tmp5_);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp6_;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1894 "rygel-http-time-seek-test.c"
		}
#line 224 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING:
#line 1898 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp7_;
			RygelSubtitle* _tmp8_;
			RygelHTTPGet* _tmp9_;
#line 242 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp7_ = thumbnail;
#line 242 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp8_ = subtitle;
#line 242 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp9_ = rygel_http_get_new_seek_strings ("00:02:08.000", "256.000", _tmp7_, _tmp8_);
#line 242 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 242 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp9_;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1915 "rygel-http-time-seek-test.c"
		}
		default:
#line 224 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		break;
#line 1920 "rygel-http-time-seek-test.c"
	}
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = request;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, _tmp10_, (gint64) (128 * GST_SECOND), (gint64) (256 * GST_SECOND), &_inner_error_);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1936 "rygel-http-time-seek-test.c"
		} else {
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1946 "rygel-http-time-seek-test.c"
		}
	}
#line 219 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 1951 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelHTTPGet* _tmp2_;
	RygelHTTPTimeSeek* _tmp3_;
	RygelHTTPTimeSeek* seek;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	gint64 _tmp15_;
	RygelHTTPGet* _tmp16_;
	RygelMediaItem* _tmp17_;
	RygelAudioItem* _tmp18_;
	RygelAudioItem* audio_item;
	gint64 _tmp19_;
	gint64 _tmp20_;
	RygelAudioItem* _tmp21_;
	gint64 _tmp22_;
	RygelHTTPGet* _tmp23_;
	SoupMessage* _tmp24_;
	SoupMessageHeaders* _tmp25_;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* header;
	const gchar* _tmp28_;
	GRegex* _tmp29_;
	const gchar* _tmp30_;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
#line 254 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 257 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = request;
#line 257 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = rygel_http_time_seek_needed (_tmp0_);
#line 257 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp1_);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = request;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = rygel_http_time_seek_new (_tmp2_, &_inner_error_);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	seek = _tmp3_;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2016 "rygel-http-time-seek-test.c"
		} else {
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2024 "rygel-http-time-seek-test.c"
		}
	}
#line 260 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 262 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (seek != NULL);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = _tmp4_;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = start;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp5_ == _tmp6_);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = _tmp7_;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = stop;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp8_ == _tmp9_);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp11_ = _tmp10_;
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp12_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp13_ = _tmp12_;
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp14_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp15_ = _tmp14_;
#line 265 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp11_ == ((_tmp13_ + GST_MSECOND) - _tmp15_));
#line 267 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp16_ = request;
#line 267 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp17_ = _tmp16_->item;
#line 267 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp18_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp17_) ? ((RygelAudioItem*) _tmp17_) : NULL);
#line 267 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	audio_item = _tmp18_;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 268 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp20_ = _tmp19_;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp21_ = audio_item;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp22_ = _tmp21_->duration;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp20_ == (_tmp22_ * GST_SECOND));
#line 270 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp23_ = request;
#line 270 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp24_ = _tmp23_->msg;
#line 270 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp25_ = _tmp24_->response_headers;
#line 270 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp26_ = soup_message_headers_get_one (_tmp25_, "TimeSeekRange.dlna.org");
#line 270 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 270 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	header = _tmp27_;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp28_ = header;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp28_ != NULL);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp29_ = self->priv->range_regex;
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp30_ = header;
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp31_ = g_regex_match (_tmp29_, _tmp30_, 0, NULL);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_assert (_tmp31_);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (header);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (audio_item);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (seek);
#line 2109 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_class_init (RygelHTTPTimeSeekTestClass * klass) {
#line 111 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_parent_class = g_type_class_peek_parent (klass);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPTimeSeekTestPrivate));
#line 111 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_test_finalize;
#line 2120 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_instance_init (RygelHTTPTimeSeekTest * self) {
#line 111 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->priv = RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE (self);
#line 2127 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_finalize (GObject* obj) {
	RygelHTTPTimeSeekTest * self;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = RYGEL_HTTP_TIME_SEEK_TEST (obj);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_time_seek_test_parent_class)->finalize (obj);
#line 2139 "rygel-http-time-seek-test.c"
}


GType rygel_http_time_seek_test_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekTest), 0, (GInstanceInitFunc) rygel_http_time_seek_test_instance_init, NULL };
		GType rygel_http_time_seek_test_type_id;
		rygel_http_time_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTimeSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_test_type_id__volatile, rygel_http_time_seek_test_type_id);
	}
	return rygel_http_time_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



