/* rygel-http-get-test.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;
typedef struct _RygelParamSpecClientHacks RygelParamSpecClientHacks;

#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
typedef struct _RygelParamSpecTranscoder RygelParamSpecTranscoder;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelClientHacks {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GTypeClass parent_class;
	void (*finalize) (RygelClientHacks *self);
};

struct _RygelParamSpecClientHacks {
	GParamSpec parent_instance;
};

struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	SoupMessage* _tmp0_;
	RygelHTTPRequest* _tmp1_;
	RygelHTTPRequest* request;
	RygelHTTPRequest* _tmp2_;
	RygelHTTPRequest* _tmp3_;
	RygelMediaItem* _tmp4_;
	gboolean _tmp5_;
	GMainLoop* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	GError* _tmp8_;
	GMainLoop* _tmp9_;
	GError * _inner_error_;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	GUPnPContext* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	RygelVideoItem* _tmp1_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block3Data* _data3_;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

struct _RygelTranscoder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTranscoder *self);
};

struct _RygelParamSpecTranscoder {
	GParamSpec parent_instance;
};


static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_transcoder_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_client_hacks_error_quark (void);
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create_for_headers (SoupMessageHeaders* headers, GError** error);
gboolean rygel_client_hacks_is_album_art_request (RygelClientHacks* self, SoupMessage* message);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
static void rygel_client_hacks_finalize (RygelClientHacks* obj);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
gint rygel_http_get_test_main (gchar** args, int args_length1);
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
static RygelHTTPRequest* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
gpointer rygel_transcoder_ref (gpointer instance);
void rygel_transcoder_unref (gpointer instance);
GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_transcoder (GValue* value, gpointer v_object);
void rygel_value_take_transcoder (GValue* value, gpointer v_object);
gpointer rygel_value_get_transcoder (const GValue* value);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
RygelTranscoder* rygel_transcoder_new (void);
RygelTranscoder* rygel_transcoder_construct (GType object_type);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
#define RYGEL_MEDIA_CONTAINER_ITEM_ID "TestItem"
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda1_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean __lambda0_ (Block2Data* _data2_);
static gboolean ___lambda0__gsource_func (gpointer self);
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
static void rygel_audio_item_finalize (RygelMediaObject* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
static void rygel_video_item_finalize (RygelMediaObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean __lambda2_ (Block3Data* _data3_);
static gboolean ___lambda2__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY
};
static void rygel_transcoder_finalize (RygelTranscoder* obj);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_client_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_client_hacks_error-quark");
}


RygelClientHacks* rygel_client_hacks_create_for_headers (SoupMessageHeaders* headers, GError** error) {
	RygelClientHacks* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (headers != NULL, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_CLIENT_HACKS_ERROR, RYGEL_CLIENT_HACKS_ERROR_NA, "");
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_inner_error_ = _tmp0_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_propagate_error (error, _inner_error_);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 959 "rygel-http-get-test.c"
}


gboolean rygel_client_hacks_is_album_art_request (RygelClientHacks* self, SoupMessage* message) {
	gboolean result = FALSE;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 973 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks* self = NULL;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelClientHacks*) g_type_create_instance (object_type);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 983 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_new (void) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
#line 990 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_init (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 997 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_free_value (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (value->data[0].v_pointer);
#line 1006 "rygel-http-get-test.c"
	}
}


static void rygel_value_client_hacks_copy_value (const GValue* src_value, GValue* dest_value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_client_hacks_ref (src_value->data[0].v_pointer);
#line 1016 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1020 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_client_hacks_peek_pointer (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1028 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1035 "rygel-http-get-test.c"
		RygelClientHacks* object;
		object = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1042 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1046 "rygel-http-get-test.c"
		}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_client_hacks_ref (object);
#line 1050 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1054 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1058 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelClientHacks** object_p;
	object_p = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1069 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1075 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1079 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1083 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1087 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecClientHacks* spec;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1101 "rygel-http-get-test.c"
}


gpointer rygel_value_get_client_hacks (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1110 "rygel-http-get-test.c"
}


void rygel_value_set_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1130 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1134 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1140 "rygel-http-get-test.c"
	}
}


void rygel_value_take_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1159 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1163 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1169 "rygel-http-get-test.c"
	}
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->finalize = rygel_client_hacks_finalize;
#line 1179 "rygel-http-get-test.c"
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1186 "rygel-http-get-test.c"
}


static void rygel_client_hacks_finalize (RygelClientHacks* obj) {
	RygelClientHacks * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_CLIENT_HACKS (obj);
#line 1194 "rygel-http-get-test.c"
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_client_hacks_init, rygel_value_client_hacks_free_value, rygel_value_client_hacks_copy_value, rygel_value_client_hacks_peek_pointer, "p", rygel_value_client_hacks_collect_value, "p", rygel_value_client_hacks_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelClientHacks", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


gpointer rygel_client_hacks_ref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1219 "rygel-http-get-test.c"
}


void rygel_client_hacks_unref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_CLIENT_HACKS_GET_CLASS (self)->finalize (self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1232 "rygel-http-get-test.c"
	}
}


gint rygel_http_get_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPGetTest* _tmp0_;
		RygelHTTPGetTest* test;
		RygelHTTPGetTest* _tmp1_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = rygel_http_get_test_new (&_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		test = _tmp0_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1252 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = test;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_run (_tmp1_, &_inner_error_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (test);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1267 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (test);
#line 1274 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		gint _tmp3_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = _error_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = _tmp2_->code;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp3_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1296 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = _error_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _tmp4_->message;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("rygel-http-get-test.vala:65: %s", _tmp5_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = -1;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1320 "rygel-http-get-test.c"
	}
	__finally0:
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_inner_error_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return 0;
#line 1331 "rygel-http-get-test.c"
	}
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = 0;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1337 "rygel-http-get-test.c"
}


int main (int argc, char ** argv) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_thread_init (NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_init ();
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_main (argv, argc);
#line 1348 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
	RygelHTTPGetTest * self = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPContext* _tmp3_;
	RygelHTTPServer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RygelHTTPClient* _tmp8_;
	GMainLoop* _tmp9_;
	GError * _inner_error_ = NULL;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _tmp0_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1379 "rygel-http-get-test.c"
	}
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->server = _tmp1_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->server;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = rygel_http_server_get_uri (_tmp4_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = _tmp6_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = rygel_http_client_new (_tmp3_, _tmp7_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->client = _tmp8_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp7_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = g_main_loop_new (NULL, FALSE);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->main_loop = _tmp9_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1413 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
#line 73 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
#line 1420 "rygel-http-get-test.c"
}


static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_get_test_on_timeout (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1429 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_message_received (self, _sender, message);
#line 1436 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 83 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_client_completed (self, _sender);
#line 1443 "rygel-http-get-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 1450 "rygel-http-get-test.c"
}


static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
	RygelHTTPServer* _tmp0_;
	RygelHTTPClient* _tmp1_;
	RygelHTTPClient* _tmp2_;
	GMainLoop* _tmp3_;
	GError* _tmp4_;
	GError * _inner_error_ = NULL;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->server;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 83 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->client;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp1_, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->client;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp2_, NULL, NULL);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->main_loop;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_run (_tmp3_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->priv->error;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp4_ != NULL) {
#line 1483 "rygel-http-get-test.c"
		GError* _tmp5_;
		GError* _tmp6_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = self->priv->error;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp6_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return;
#line 1496 "rygel-http-get-test.c"
	}
}


void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
#line 80 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
#line 1506 "rygel-http-get-test.c"
}


static RygelHTTPRequest* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPRequest* result = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GUPnPContext* _tmp2_;
	SoupServer* _tmp3_;
	SoupServer* _tmp4_;
	SoupMessage* _tmp5_;
	RygelHTTPGet* _tmp6_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->server;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_->context;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = gupnp_context_get_server (_tmp2_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = msg;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = rygel_http_get_new (_tmp0_, _tmp4_, _tmp5_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = (RygelHTTPRequest*) _tmp6_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1541 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
	gboolean _tmp0_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->server_done;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp0_) {
#line 1555 "rygel-http-get-test.c"
		GMainLoop* _tmp1_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = self->priv->main_loop;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_tmp1_);
#line 1561 "rygel-http-get-test.c"
	}
#line 105 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->client_done = TRUE;
#line 1565 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	SoupMessage* _tmp0_;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message (self, _tmp0_, NULL, NULL);
#line 1581 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = _data;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->msg);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpGetTestHandleClientMessageData, _data_);
#line 1594 "rygel-http-get-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1601 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	RygelHTTPGetTest* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = msg;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->msg = _tmp2_;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 1628 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1636 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = _user_data_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_source_object_ = source_object;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_res_ = _res_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 1650 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 1659 "rygel-http-get-test.c"
		goto _state_0;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 1663 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 1668 "rygel-http-get-test.c"
	}
	_state_0:
	{
#line 115 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp0_ = _data_->msg;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = NULL;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = rygel_http_get_test_create_request (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->request = _data_->_tmp1_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1682 "rygel-http-get-test.c"
			goto __catch1_g_error;
		}
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = _data_->request;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_state_ = 1;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp2_, rygel_http_get_test_handle_client_message_ready, _data_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 1693 "rygel-http-get-test.c"
		_state_1:
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp2_, _data_->_res_);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->request;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) (RYGEL_IS_HTTP_GET (_data_->_tmp3_) ? ((RygelHTTPGet*) _data_->_tmp3_) : NULL))->item;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert (_data_->_tmp4_ != NULL);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp5_ = _data_->self->priv->client_done;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_tmp5_) {
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp6_ = _data_->self->priv->main_loop;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_main_loop_quit (_data_->_tmp6_);
#line 1711 "rygel-http-get-test.c"
		}
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->server_done = TRUE;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (_data_->request);
#line 1717 "rygel-http-get-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_inner_error_ = NULL;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp7_ = _data_->_error_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->self->priv->error);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->error = _data_->_tmp8_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp9_ = _data_->self->priv->main_loop;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_data_->_tmp9_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->_error_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1744 "rygel-http-get-test.c"
		} else {
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1748 "rygel-http-get-test.c"
		}
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 1754 "rygel-http-get-test.c"
	}
	__finally1:
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 1765 "rygel-http-get-test.c"
	}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1771 "rygel-http-get-test.c"
	} else {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1775 "rygel-http-get-test.c"
	}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 1781 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_;
	GMainLoop* _tmp1_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->error = _tmp0_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_quit (_tmp1_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1805 "rygel-http-get-test.c"
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_CLASS (klass)->run = rygel_http_get_test_real_run;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
#line 1818 "rygel-http-get-test.c"
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
#line 1825 "rygel-http-get-test.c"
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_GET_TEST (obj);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 48 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
#line 1843 "rygel-http-get-test.c"
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
#line 1862 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPContext* _tmp10_;
	SoupServer* _tmp11_;
	SoupServer* _tmp12_;
	RygelMediaContainer* _tmp13_;
	GError * _inner_error_ = NULL;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 1882 "rygel-http-get-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = _tmp0_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 1892 "rygel-http-get-test.c"
			goto __catch2_g_error;
		}
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self->context);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->context = _tmp1_;
#line 1899 "rygel-http-get-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp2_;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 1916 "rygel-http-get-test.c"
		goto __finally2;
	}
	__finally2:
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_propagate_error (error, _inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (self);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 1930 "rygel-http-get-test.c"
		} else {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_clear_error (&_inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 1938 "rygel-http-get-test.c"
		}
	}
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->context;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp3_ != NULL);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->context;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp6_ != NULL);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->context;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = _tmp8_;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp9_ > ((guint) 0));
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = self->context;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = _tmp11_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_add_handler (_tmp12_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = rygel_media_container_new ();
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->root_container = _tmp13_;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1977 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 164 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 1984 "rygel-http-get-test.c"
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (path != NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->context;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gupnp_context_get_server (_tmp0_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = msg;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_pause_message (_tmp2_, _tmp3_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = msg;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp4_);
#line 2018 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* _tmp0_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_transcoder_new ();
#line 190 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2035 "rygel-http-get-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2047 "rygel-http-get-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	RygelMediaContainer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	RygelHTTPItemURI* item_uri;
	gchar* _tmp2_ = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->root_container;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = rygel_http_item_uri_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self, -1, -1, NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item_uri = _tmp1_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_http_item_uri_to_string (item_uri);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp2_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (item_uri);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2073 "rygel-http-get-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 2090 "rygel-http-get-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 2108 "rygel-http-get-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 2141 "rygel-http-get-test.c"
		default:
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 2147 "rygel-http-get-test.c"
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = context;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->context = _tmp1_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = uri;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = soup_message_new ("GET", _tmp2_);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->msg = _tmp3_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->msg;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp4_ != NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 2187 "rygel-http-get-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri) {
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri);
#line 2194 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 2205 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 2227 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2235 "rygel-http-get-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data1_;
#line 2244 "rygel-http-get-test.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (_data1_->self);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue = NULL;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target = NULL;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 2263 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2273 "rygel-http-get-test.c"
}


static void __lambda1_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data1_->self;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (session != NULL);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 212 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 2287 "rygel-http-get-test.c"
}


static void ___lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__lambda1_ (self, session, msg);
#line 2294 "rygel-http-get-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 2303 "rygel-http-get-test.c"
		goto _state_0;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 2307 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 2312 "rygel-http-get-test.c"
	}
	_state_0:
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->context;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = gupnp_context_get_session (_data_->_tmp0_);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp3_ = _data_->self->msg;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda1__soup_session_callback, _data_->_data1_);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2345 "rygel-http-get-test.c"
	_state_1:
	;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block1_data_unref (_data_->_data1_);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = NULL;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2358 "rygel-http-get-test.c"
	} else {
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2362 "rygel-http-get-test.c"
	}
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2368 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2384 "rygel-http-get-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 2404 "rygel-http-get-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
#line 2421 "rygel-http-get-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 2436 "rygel-http-get-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 2443 "rygel-http-get-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_CLIENT (obj);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 2459 "rygel-http-get-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 2488 "rygel-http-get-test.c"
		default:
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 2494 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 2510 "rygel-http-get-test.c"
		default:
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 2516 "rygel-http-get-test.c"
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_data_->item_id);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->result);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->self);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
#line 2534 "rygel-http-get-test.c"
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? rygel_media_object_ref (self) : NULL;
#line 2541 "rygel-http-get-test.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_container_find_object);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _rygel_media_object_ref0 (self);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->item_id = _tmp2_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = cancellable;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->cancellable = _tmp4_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_find_object_co (_data_);
#line 2576 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 2587 "rygel-http-get-test.c"
	}
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _data_->result;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->result = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2597 "rygel-http-get-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data2_;
#line 2606 "rygel-http-get-test.c"
}


static void block2_data_unref (Block2Data* _data2_) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_rygel_media_object_unref0 (_data2_->self);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue = NULL;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target = NULL;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target_destroy_notify = NULL;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 2625 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2635 "rygel-http-get-test.c"
}


static gboolean __lambda0_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data2_->self;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _data2_->find_object_continue;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0__target = _data2_->find_object_continue_target;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ (_tmp0__target);
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2656 "rygel-http-get-test.c"
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2665 "rygel-http-get-test.c"
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 2674 "rygel-http-get-test.c"
		goto _state_0;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 2678 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 2683 "rygel-http-get-test.c"
	}
	_state_0:
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->self = rygel_media_object_ref (_data_->self);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target = _data_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target_destroy_notify = NULL;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda0__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2706 "rygel-http-get-test.c"
	_state_1:
	;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->item_id;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_data_->_tmp0_, RYGEL_MEDIA_CONTAINER_ITEM_ID) == 0) {
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = rygel_video_item_new ();
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp1_;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		block2_data_unref (_data_->_data2_);
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_data2_ = NULL;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2725 "rygel-http-get-test.c"
		} else {
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2729 "rygel-http-get-test.c"
		}
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 237 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2735 "rygel-http-get-test.c"
	} else {
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->result = NULL;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		block2_data_unref (_data_->_data2_);
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_data2_ = NULL;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2747 "rygel-http-get-test.c"
		} else {
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2751 "rygel-http-get-test.c"
		}
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2757 "rygel-http-get-test.c"
	}
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block2_data_unref (_data_->_data2_);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = NULL;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2767 "rygel-http-get-test.c"
	} else {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2771 "rygel-http-get-test.c"
	}
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2777 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 2787 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 2794 "rygel-http-get-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 2801 "rygel-http-get-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPGet* _tmp0_;
	RygelHTTPResponse* _tmp1_;
#line 245 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 245 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = rygel_http_response_new (_tmp0_);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp1_;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2837 "rygel-http-get-test.c"
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
#line 249 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (get_request != NULL);
#line 2846 "rygel-http-get-test.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler* self = NULL;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 2856 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_init (GValue* value) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 2863 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (value->data[0].v_pointer);
#line 2872 "rygel-http-get-test.c"
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
#line 2882 "rygel-http-get-test.c"
	} else {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2886 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 2894 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 2901 "rygel-http-get-test.c"
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2908 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2912 "rygel-http-get-test.c"
		}
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
#line 2916 "rygel-http-get-test.c"
	} else {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 2920 "rygel-http-get-test.c"
	}
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 2924 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2935 "rygel-http-get-test.c"
	}
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 2941 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 2945 "rygel-http-get-test.c"
	} else {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 2949 "rygel-http-get-test.c"
	}
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 2953 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 2967 "rygel-http-get-test.c"
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 2976 "rygel-http-get-test.c"
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 2996 "rygel-http-get-test.c"
	} else {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 3000 "rygel-http-get-test.c"
	}
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 3006 "rygel-http-get-test.c"
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 3025 "rygel-http-get-test.c"
	} else {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 3029 "rygel-http-get-test.c"
	}
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 3035 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 3045 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 3052 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_GET_HANDLER (obj);
#line 3060 "rygel-http-get-test.c"
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 3085 "rygel-http-get-test.c"
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3098 "rygel-http-get-test.c"
	}
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
	RygelHTTPTranscodeHandler* self = NULL;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (transcoder != NULL, NULL);
#line 253 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 253 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
#line 253 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3113 "rygel-http-get-test.c"
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
#line 253 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
#line 3120 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
#line 252 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
#line 3127 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler* self = NULL;
#line 258 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 258 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
#line 258 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3155 "rygel-http-get-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
#line 258 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
#line 3162 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 257 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 3169 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = TRUE;
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3197 "rygel-http-get-test.c"
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = TRUE;
#line 273 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3209 "rygel-http-get-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 261 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3219 "rygel-http-get-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 261 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 261 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 3228 "rygel-http-get-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 262 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->subtitles = _tmp0_;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->thumbnails = _tmp1_;
#line 266 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->place_holder = FALSE;
#line 3247 "rygel-http-get-test.c"
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->thumbnails);
#line 261 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 3261 "rygel-http-get-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem* self = NULL;
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3283 "rygel-http-get-test.c"
}


RygelAudioItem* rygel_audio_item_new (void) {
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 3290 "rygel-http-get-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 3299 "rygel-http-get-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->duration = (gint64) 2048;
#line 3306 "rygel-http-get-test.c"
}


static void rygel_audio_item_finalize (RygelMediaObject* obj) {
	RygelAudioItem * self;
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_AUDIO_ITEM (obj);
#line 277 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 3316 "rygel-http-get-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
#line 3337 "rygel-http-get-test.c"
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
#line 3346 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
#line 3355 "rygel-http-get-test.c"
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
#line 3364 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_pixel_width (RygelVisualItem* self) {
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_width (self);
#line 3373 "rygel-http-get-test.c"
}


void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value) {
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_width (self, value);
#line 3382 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_pixel_height (RygelVisualItem* self) {
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_height (self);
#line 3391 "rygel-http-get-test.c"
}


void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value) {
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_height (self, value);
#line 3400 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
#line 3409 "rygel-http-get-test.c"
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 286 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
#line 3418 "rygel-http-get-test.c"
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
#line 3427 "rygel-http-get-test.c"
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
#line 3436 "rygel-http-get-test.c"
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	static gboolean initialized = FALSE;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!initialized) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		initialized = TRUE;
#line 3447 "rygel-http-get-test.c"
	}
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem* self = NULL;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3471 "rygel-http-get-test.c"
}


RygelVideoItem* rygel_video_item_new (void) {
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
#line 3478 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_width;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3494 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = _tmp0_;
#line 3507 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_height;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3523 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = _tmp0_;
#line 3536 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_pixel_width;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3552 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_width = _tmp0_;
#line 3565 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_pixel_height;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3581 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_height = _tmp0_;
#line 3594 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_color_depth;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3610 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = _tmp0_;
#line 3623 "rygel-http-get-test.c"
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_thumbnails;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3639 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_thumbnails);
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_thumbnails = _tmp1_;
#line 3657 "rygel-http-get-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
#line 3668 "rygel-http-get-test.c"
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_width = rygel_video_item_real_get_width;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_width = rygel_video_item_real_set_width;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_height = rygel_video_item_real_get_height;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_height = rygel_video_item_real_set_height;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
#line 3699 "rygel-http-get-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = -1;
#line 293 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = -1;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_width = -1;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_height = -1;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = -1;
#line 3716 "rygel-http-get-test.c"
}


static void rygel_video_item_finalize (RygelMediaObject* obj) {
	RygelVideoItem * self;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_VIDEO_ITEM (obj);
#line 298 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_thumbnails);
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 3730 "rygel-http-get-test.c"
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem* self = NULL;
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type);
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3754 "rygel-http-get-test.c"
}


RygelMusicItem* rygel_music_item_new (void) {
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
#line 3761 "rygel-http-get-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 3770 "rygel-http-get-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (RygelMediaObject* obj) {
	RygelMusicItem * self;
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_MUSIC_ITEM (obj);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (self->album_art);
#line 302 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 3786 "rygel-http-get-test.c"
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelThumbnail*) g_type_create_instance (object_type);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3808 "rygel-http-get-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 3815 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 3822 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_free_value (GValue* value) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (value->data[0].v_pointer);
#line 3831 "rygel-http-get-test.c"
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
#line 3841 "rygel-http-get-test.c"
	} else {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3845 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 3853 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 3860 "rygel-http-get-test.c"
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3867 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3871 "rygel-http-get-test.c"
		}
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
#line 3875 "rygel-http-get-test.c"
	} else {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 3879 "rygel-http-get-test.c"
	}
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 3883 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3894 "rygel-http-get-test.c"
	}
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 3900 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 3904 "rygel-http-get-test.c"
	} else {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
#line 3908 "rygel-http-get-test.c"
	}
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 3912 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 3926 "rygel-http-get-test.c"
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 3935 "rygel-http-get-test.c"
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_ref (value->data[0].v_pointer);
#line 3955 "rygel-http-get-test.c"
	} else {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 3959 "rygel-http-get-test.c"
	}
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 3965 "rygel-http-get-test.c"
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 3984 "rygel-http-get-test.c"
	} else {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 3988 "rygel-http-get-test.c"
	}
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 3994 "rygel-http-get-test.c"
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 4004 "rygel-http-get-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 307 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 4013 "rygel-http-get-test.c"
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_THUMBNAIL (obj);
#line 4021 "rygel-http-get-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 4046 "rygel-http-get-test.c"
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4059 "rygel-http-get-test.c"
	}
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle* self = NULL;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelSubtitle*) g_type_create_instance (object_type);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4070 "rygel-http-get-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 4077 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_init (GValue* value) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 4084 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_free_value (GValue* value) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (value->data[0].v_pointer);
#line 4093 "rygel-http-get-test.c"
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
#line 4103 "rygel-http-get-test.c"
	} else {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4107 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4115 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 4122 "rygel-http-get-test.c"
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4129 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4133 "rygel-http-get-test.c"
		}
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_subtitle_ref (object);
#line 4137 "rygel-http-get-test.c"
	} else {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4141 "rygel-http-get-test.c"
	}
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4145 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4156 "rygel-http-get-test.c"
	}
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 4162 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 4166 "rygel-http-get-test.c"
	} else {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
#line 4170 "rygel-http-get-test.c"
	}
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4174 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 4188 "rygel-http-get-test.c"
}


gpointer rygel_value_get_subtitle (const GValue* value) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4197 "rygel-http-get-test.c"
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_ref (value->data[0].v_pointer);
#line 4217 "rygel-http-get-test.c"
	} else {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4221 "rygel-http-get-test.c"
	}
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 4227 "rygel-http-get-test.c"
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 4246 "rygel-http-get-test.c"
	} else {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4250 "rygel-http-get-test.c"
	}
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 4256 "rygel-http-get-test.c"
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_SUBTITLE_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 4266 "rygel-http-get-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 311 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 4275 "rygel-http-get-test.c"
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_SUBTITLE (obj);
#line 4283 "rygel-http-get-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 4308 "rygel-http-get-test.c"
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4321 "rygel-http-get-test.c"
	}
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessageHeaders* _tmp4_;
	RygelHTTPGet* _tmp5_;
	SoupServer* _tmp6_;
	SoupServer* _tmp7_;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->msg = _tmp2_;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->msg;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->response_headers;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_set_encoding (_tmp4_, SOUP_ENCODING_CONTENT_LENGTH);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = get_request;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->server;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->server = _tmp7_;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4368 "rygel-http-get-test.c"
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 4375 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpResponseRunData, _data_);
#line 4386 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_real_run_co (_data_);
#line 4408 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 4416 "rygel-http-get-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data3_;
#line 4425 "rygel-http-get-test.c"
}


static void block3_data_unref (Block3Data* _data3_) {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (_data3_->self);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue = NULL;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target = NULL;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target_destroy_notify = NULL;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 4444 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
#line 327 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4454 "rygel-http-get-test.c"
}


static gboolean __lambda2_ (Block3Data* _data3_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data3_->self;
#line 330 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data3_->run_continue (_data3_->run_continue_target);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4469 "rygel-http-get-test.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4478 "rygel-http-get-test.c"
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 4487 "rygel-http-get-test.c"
		goto _state_0;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 4491 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 4496 "rygel-http-get-test.c"
	}
	_state_0:
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 327 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue = _rygel_http_response_real_run_co_gsource_func;
#line 327 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target = _data_;
#line 327 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target_destroy_notify = NULL;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 4519 "rygel-http-get-test.c"
	_state_1:
	;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->priv->msg;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_set_status (_data_->_tmp0_, (guint) SOUP_STATUS_OK);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->self->priv->server;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->self->priv->msg;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_unpause_message (_data_->_tmp1_, _data_->_tmp2_);
#line 340 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block3_data_unref (_data_->_data3_);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = NULL;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4542 "rygel-http-get-test.c"
	} else {
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4546 "rygel-http-get-test.c"
	}
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 4552 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4568 "rygel-http-get-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 4588 "rygel-http-get-test.c"
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
#line 4605 "rygel-http-get-test.c"
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_response_real_run_finish;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
#line 4620 "rygel-http-get-test.c"
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
#line 4627 "rygel-http-get-test.c"
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_RESPONSE (obj);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 317 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
#line 4643 "rygel-http-get-test.c"
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 4672 "rygel-http-get-test.c"
		default:
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 4678 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 4694 "rygel-http-get-test.c"
		default:
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 4700 "rygel-http-get-test.c"
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaObject*) g_type_create_instance (object_type);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4711 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 4718 "rygel-http-get-test.c"
}


static void rygel_value_media_object_init (GValue* value) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 4725 "rygel-http-get-test.c"
}


static void rygel_value_media_object_free_value (GValue* value) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (value->data[0].v_pointer);
#line 4734 "rygel-http-get-test.c"
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
#line 4744 "rygel-http-get-test.c"
	} else {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4748 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4756 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 4763 "rygel-http-get-test.c"
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4770 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4774 "rygel-http-get-test.c"
		}
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_media_object_ref (object);
#line 4778 "rygel-http-get-test.c"
	} else {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4782 "rygel-http-get-test.c"
	}
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4786 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4797 "rygel-http-get-test.c"
	}
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 4803 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 4807 "rygel-http-get-test.c"
	} else {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
#line 4811 "rygel-http-get-test.c"
	}
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4815 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 4829 "rygel-http-get-test.c"
}


gpointer rygel_value_get_media_object (const GValue* value) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4838 "rygel-http-get-test.c"
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_ref (value->data[0].v_pointer);
#line 4858 "rygel-http-get-test.c"
	} else {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4862 "rygel-http-get-test.c"
	}
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 4868 "rygel-http-get-test.c"
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 4887 "rygel-http-get-test.c"
	} else {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4891 "rygel-http-get-test.c"
	}
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 4897 "rygel-http-get-test.c"
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 4907 "rygel-http-get-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 4914 "rygel-http-get-test.c"
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_MEDIA_OBJECT (obj);
#line 345 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->id);
#line 4924 "rygel-http-get-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 4949 "rygel-http-get-test.c"
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4962 "rygel-http-get-test.c"
	}
}


RygelTranscoder* rygel_transcoder_construct (GType object_type) {
	RygelTranscoder* self = NULL;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTranscoder*) g_type_create_instance (object_type);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4973 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_transcoder_new (void) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER);
#line 4980 "rygel-http-get-test.c"
}


static void rygel_value_transcoder_init (GValue* value) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 4987 "rygel-http-get-test.c"
}


static void rygel_value_transcoder_free_value (GValue* value) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_unref (value->data[0].v_pointer);
#line 4996 "rygel-http-get-test.c"
	}
}


static void rygel_value_transcoder_copy_value (const GValue* src_value, GValue* dest_value) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_transcoder_ref (src_value->data[0].v_pointer);
#line 5006 "rygel-http-get-test.c"
	} else {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5010 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_transcoder_peek_pointer (const GValue* value) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5018 "rygel-http-get-test.c"
}


static gchar* rygel_value_transcoder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5025 "rygel-http-get-test.c"
		RygelTranscoder* object;
		object = collect_values[0].v_pointer;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5032 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5036 "rygel-http-get-test.c"
		}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_transcoder_ref (object);
#line 5040 "rygel-http-get-test.c"
	} else {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5044 "rygel-http-get-test.c"
	}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5048 "rygel-http-get-test.c"
}


static gchar* rygel_value_transcoder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTranscoder** object_p;
	object_p = collect_values[0].v_pointer;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5059 "rygel-http-get-test.c"
	}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5065 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5069 "rygel-http-get-test.c"
	} else {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_transcoder_ref (value->data[0].v_pointer);
#line 5073 "rygel-http-get-test.c"
	}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5077 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTranscoder* spec;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TRANSCODER), NULL);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5091 "rygel-http-get-test.c"
}


gpointer rygel_value_get_transcoder (const GValue* value) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER), NULL);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5100 "rygel-http-get-test.c"
}


void rygel_value_set_transcoder (GValue* value, gpointer v_object) {
	RygelTranscoder* old;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER));
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TRANSCODER));
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_ref (value->data[0].v_pointer);
#line 5120 "rygel-http-get-test.c"
	} else {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5124 "rygel-http-get-test.c"
	}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_unref (old);
#line 5130 "rygel-http-get-test.c"
	}
}


void rygel_value_take_transcoder (GValue* value, gpointer v_object) {
	RygelTranscoder* old;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER));
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TRANSCODER));
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5149 "rygel-http-get-test.c"
	} else {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5153 "rygel-http-get-test.c"
	}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_unref (old);
#line 5159 "rygel-http-get-test.c"
	}
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_TRANSCODER_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 5169 "rygel-http-get-test.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5176 "rygel-http-get-test.c"
}


static void rygel_transcoder_finalize (RygelTranscoder* obj) {
	RygelTranscoder * self;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_TRANSCODER (obj);
#line 5184 "rygel-http-get-test.c"
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_transcoder_init, rygel_value_transcoder_free_value, rygel_value_transcoder_copy_value, rygel_value_transcoder_peek_pointer, "p", rygel_value_transcoder_collect_value, "p", rygel_value_transcoder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTranscoder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


gpointer rygel_transcoder_ref (gpointer instance) {
	RygelTranscoder* self;
	self = instance;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5209 "rygel-http-get-test.c"
}


void rygel_transcoder_unref (gpointer instance) {
	RygelTranscoder* self;
	self = instance;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_TRANSCODER_GET_CLASS (self)->finalize (self);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5222 "rygel-http-get-test.c"
	}
}



