/* rygel-xbox-hacks.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/gst.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaItem* item);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelXBoxHacks {
	RygelClientHacks parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelXBoxHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* results;
	gboolean _tmp7_;
	guint _tmp8_;
	RygelSearchExpression* _tmp9_;
	gboolean _tmp10_;
	RygelSearchExpression* _tmp11_;
	RygelRelationalExpression* _tmp12_;
	RygelRelationalExpression* rel_expression;
	gboolean _tmp13_;
	RygelRelationalExpression* _tmp14_;
	gconstpointer _tmp15_;
	gboolean _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gconstpointer _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GError * _inner_error_;
};


static gpointer rygel_xbox_hacks_parent_class = NULL;

GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY
};
#define RYGEL_XBOX_HACKS_AGENT ".*Xbox.*|.*Allegro-Software-WebClient.*|.*SEC_HHP_Galaxy S/1\\.0.*"
#define RYGEL_XBOX_HACKS_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_XBOX_HACKS_DMS_V1 RYGEL_XBOX_HACKS_DMS ":1"
#define RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX ":"
#define RYGEL_XBOX_HACKS_MODEL_NAME "Windows Media Player Sharing"
#define RYGEL_XBOX_HACKS_MODEL_VERSION "11"
#define RYGEL_XBOX_HACKS_CONTAINER_ID "ContainerID"
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, GError** error);
RygelClientHacks* rygel_client_hacks_construct (GType object_type, const gchar* agent_pattern, SoupMessageHeaders* headers, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_new_for_headers (SoupMessageHeaders* headers, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_headers (GType object_type, SoupMessageHeaders* headers, GError** error);
void rygel_client_hacks_set_object_id (RygelClientHacks* self, const gchar* value);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc);
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error);
static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base, RygelMediaQueryAction* action, gchar** container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_real_apply (RygelClientHacks* base, RygelMediaItem* item);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_real_search_data_free (gpointer _data);
static void rygel_xbox_hacks_real_search (RygelClientHacks* base, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_xbox_hacks_modify_service_list (RygelXBoxHacks* self, xmlNode* doc_node);
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE "urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1"


RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, GError** error) {
	RygelXBoxHacks * self = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelXBoxHacks*) rygel_client_hacks_construct (object_type, RYGEL_XBOX_HACKS_AGENT, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


RygelXBoxHacks* rygel_xbox_hacks_new (GError** error) {
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS, error);
}


RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error) {
	RygelXBoxHacks * self = NULL;
	GUPnPServiceAction* _tmp0_;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	SoupMessageHeaders* _tmp4_;
	SoupMessageHeaders* headers;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (action != NULL, NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_message (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->request_headers;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	headers = _tmp4_;
	self = (RygelXBoxHacks*) rygel_xbox_hacks_construct_for_headers (object_type, headers, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error) {
	return rygel_xbox_hacks_construct_for_action (RYGEL_TYPE_XBOX_HACKS, action, error);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


RygelXBoxHacks* rygel_xbox_hacks_construct_for_headers (GType object_type, SoupMessageHeaders* headers, GError** error) {
	RygelXBoxHacks * self = NULL;
	SoupMessageHeaders* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* agent;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (headers != NULL, NULL);
	_tmp0_ = headers;
	self = (RygelXBoxHacks*) rygel_client_hacks_construct (object_type, RYGEL_XBOX_HACKS_AGENT, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, "User-Agent");
	_tmp3_ = g_strdup (_tmp2_);
	agent = _tmp3_;
	_tmp4_ = agent;
	_tmp5_ = string_contains (_tmp4_, "Xbox");
	if (_tmp5_) {
		rygel_client_hacks_set_object_id ((RygelClientHacks*) self, RYGEL_XBOX_HACKS_CONTAINER_ID);
	}
	_g_free0 (agent);
	return self;
}


RygelXBoxHacks* rygel_xbox_hacks_new_for_headers (SoupMessageHeaders* headers, GError** error) {
	return rygel_xbox_hacks_construct_for_headers (RYGEL_TYPE_XBOX_HACKS, headers, error);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch70_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch70_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally70;
	__catch70_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally70:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	RygelRootDevice* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GUPnPXMLDoc* _tmp4_;
	GUPnPXMLDoc* doc;
	GUPnPXMLDoc* _tmp5_;
	xmlDoc* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* desc_path;
	GUPnPXMLDoc* _tmp9_;
	const gchar* _tmp10_;
	RygelRootDevice* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* server_path;
	RygelRootDevice* _tmp14_;
	GUPnPContext* _tmp15_;
	GUPnPContext* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GRegex* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (template_path != NULL);
	_tmp0_ = device;
	_tmp1_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _tmp0_);
	_tmp2_ = g_str_has_prefix (_tmp1_, RYGEL_XBOX_HACKS_DMS);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = template_path;
	_tmp4_ = gupnp_xml_doc_new_from_path (_tmp3_, &_inner_error_);
	doc = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = doc;
	_tmp6_ = _tmp5_->doc;
	rygel_xbox_hacks_modify_dms_desc (self, _tmp6_);
	_tmp7_ = template_path;
	_tmp8_ = string_replace (_tmp7_, ".xml", "-xbox.xml");
	desc_path = _tmp8_;
	_tmp9_ = doc;
	_tmp10_ = desc_path;
	rygel_xbox_hacks_save_modified_desc (self, _tmp9_, _tmp10_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_object_unref0 (doc);
		return;
	}
	_tmp11_ = device;
	_tmp12_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) _tmp11_);
	_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
	server_path = _tmp13_;
	_tmp14_ = device;
	_tmp15_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = desc_path;
	_tmp18_ = server_path;
	_tmp19_ = ((RygelClientHacks*) self)->agent_regex;
	gupnp_context_host_path_for_agent (_tmp16_, _tmp17_, _tmp18_, _tmp19_);
	_g_free0 (server_path);
	_g_free0 (desc_path);
	_g_object_unref0 (doc);
}


static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base, RygelMediaQueryAction* action, gchar** container_id) {
	RygelXBoxHacks * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelMediaQueryAction* _tmp2_;
	gboolean _tmp19_;
	gboolean _tmp30_;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (action != NULL);
	g_return_if_fail (container_id != NULL);
	_tmp2_ = action;
	if (RYGEL_IS_SEARCH (_tmp2_)) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gboolean _tmp10_;
		gboolean _tmp12_;
		gboolean _tmp14_;
		gboolean _tmp16_;
		gboolean _tmp18_;
		_tmp8_ = *container_id;
		if (g_strcmp0 (_tmp8_, "1") == 0) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = *container_id;
			_tmp7_ = g_strcmp0 (_tmp9_, "4") == 0;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = *container_id;
			_tmp6_ = g_strcmp0 (_tmp11_, "5") == 0;
		}
		_tmp12_ = _tmp6_;
		if (_tmp12_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = *container_id;
			_tmp5_ = g_strcmp0 (_tmp13_, "6") == 0;
		}
		_tmp14_ = _tmp5_;
		if (_tmp14_) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = *container_id;
			_tmp4_ = g_strcmp0 (_tmp15_, "7") == 0;
		}
		_tmp16_ = _tmp4_;
		if (_tmp16_) {
			_tmp3_ = TRUE;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = *container_id;
			_tmp3_ = g_strcmp0 (_tmp17_, "F") == 0;
		}
		_tmp18_ = _tmp3_;
		_tmp1_ = _tmp18_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp19_ = _tmp1_;
	if (_tmp19_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		RygelMediaQueryAction* _tmp23_;
		gboolean _tmp25_;
		gboolean _tmp27_;
		gboolean _tmp29_;
		_tmp23_ = action;
		if (RYGEL_IS_BROWSE (_tmp23_)) {
			const gchar* _tmp24_;
			_tmp24_ = *container_id;
			_tmp22_ = g_strcmp0 (_tmp24_, "15") == 0;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp25_ = _tmp22_;
		if (_tmp25_) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp26_;
			_tmp26_ = *container_id;
			_tmp21_ = g_strcmp0 (_tmp26_, "14") == 0;
		}
		_tmp27_ = _tmp21_;
		if (_tmp27_) {
			_tmp20_ = TRUE;
		} else {
			const gchar* _tmp28_;
			_tmp28_ = *container_id;
			_tmp20_ = g_strcmp0 (_tmp28_, "16") == 0;
		}
		_tmp29_ = _tmp20_;
		_tmp0_ = _tmp29_;
	}
	_tmp30_ = _tmp0_;
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("0");
		_g_free0 (*container_id);
		*container_id = _tmp31_;
	}
}


static void rygel_xbox_hacks_real_apply (RygelClientHacks* base, RygelMediaItem* item) {
	RygelXBoxHacks * self;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _tmp0_->mime_type;
	if (g_strcmp0 (_tmp1_, "video/x-msvideo") == 0) {
		RygelMediaItem* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = item;
		_tmp3_ = g_strdup ("video/avi");
		_g_free0 (_tmp2_->mime_type);
		_tmp2_->mime_type = _tmp3_;
	} else {
		RygelMediaItem* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = item;
		_tmp5_ = _tmp4_->mime_type;
		if (g_strcmp0 (_tmp5_, "video/mpeg") == 0) {
			RygelMediaItem* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = item;
			_tmp7_ = g_strdup ("invalid/content");
			_g_free0 (_tmp6_->mime_type);
			_tmp6_->mime_type = _tmp7_;
		}
	}
}


static void rygel_xbox_hacks_real_search_data_free (gpointer _data) {
	RygelXboxHacksSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelXboxHacksSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_xbox_hacks_real_search (RygelClientHacks* base, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelXBoxHacks * self;
	RygelXboxHacksSearchData* _data_;
	RygelXBoxHacks* _tmp0_;
	RygelSearchableContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchExpression* _tmp3_;
	RygelSearchExpression* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	self = (RygelXBoxHacks*) base;
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_xbox_hacks_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_xbox_hacks_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->container = _tmp2_;
	_tmp3_ = expression;
	_tmp4_ = _rygel_search_expression_ref0 (_tmp3_);
	_data_->expression = _tmp4_;
	_tmp5_ = offset;
	_data_->offset = _tmp5_;
	_tmp6_ = max_count;
	_data_->max_count = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data_->cancellable = _tmp8_;
	rygel_xbox_hacks_real_search_co (_data_);
}


static RygelMediaObjects* rygel_xbox_hacks_real_search_finish (RygelClientHacks* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_xbox_hacks_real_search_co (_data_);
}


static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->container;
	_data_->_tmp1_ = _data_->expression;
	_data_->_tmp2_ = _data_->offset;
	_data_->_tmp3_ = _data_->max_count;
	_data_->_tmp4_ = _data_->cancellable;
	_data_->_tmp5_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, rygel_xbox_hacks_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = rygel_searchable_container_search_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp5_;
	_data_->results = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->total_matches;
	if (_data_->_tmp8_ == ((guint) 0)) {
		_data_->_tmp9_ = _data_->expression;
		_data_->_tmp7_ = RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp9_);
	} else {
		_data_->_tmp7_ = FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp7_;
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = _data_->expression;
		_data_->_tmp12_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp11_) ? ((RygelRelationalExpression*) _data_->_tmp11_) : NULL);
		_data_->rel_expression = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->rel_expression;
		_data_->_tmp15_ = ((RygelSearchExpression*) _data_->_tmp14_)->operand1;
		_data_->_tmp16_ = FALSE;
		_data_->_tmp16_ = G_LIKELY (((const gchar*) _data_->_tmp15_) != NULL);
		if (_data_->_tmp16_) {
			_data_->_tmp17_ = _data_->rel_expression;
			_data_->_tmp18_ = ((RygelSearchExpression*) _data_->_tmp17_)->operand1;
			_data_->_tmp13_ = g_strcmp0 ((const gchar*) _data_->_tmp18_, "upnp:class") == 0;
		} else {
			_data_->_tmp13_ = FALSE;
		}
		_data_->_tmp19_ = _data_->_tmp13_;
		if (_data_->_tmp19_) {
			_data_->_tmp20_ = gee_collection_get_size ((GeeCollection*) _data_->results);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->total_matches = (guint) _data_->_tmp21_;
		}
		_rygel_search_expression_unref0 (_data_->rel_expression);
	}
	_data_->result = _data_->results;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->results);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc) {
	xmlDoc* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlDoc* _tmp4_;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_;
	xmlNode* _tmp7_;
	xmlDoc* _tmp8_;
	xmlNode* _tmp9_ = NULL;
	xmlNode* _tmp10_;
	xmlNode* _tmp11_;
	xmlDoc* _tmp12_;
	xmlNode* _tmp13_ = NULL;
	xmlNode* _tmp14_;
	xmlNode* _tmp15_;
	xmlDoc* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	_tmp1_ = rygel_xml_utils_get_element ((xmlNode*) _tmp0_, "root", "device", "deviceType", NULL);
	element = _tmp1_;
	_tmp2_ = element;
	g_assert (_tmp2_ != NULL);
	_tmp3_ = element;
	xmlNodeSetContent (_tmp3_, RYGEL_XBOX_HACKS_DMS_V1);
	_tmp4_ = doc;
	_tmp5_ = rygel_xml_utils_get_element ((xmlNode*) _tmp4_, "root", "device", "modelName", NULL);
	element = _tmp5_;
	_tmp6_ = element;
	g_assert (_tmp6_ != NULL);
	_tmp7_ = element;
	xmlNodeSetContent (_tmp7_, RYGEL_XBOX_HACKS_MODEL_NAME);
	_tmp8_ = doc;
	_tmp9_ = rygel_xml_utils_get_element ((xmlNode*) _tmp8_, "root", "device", "modelNumber", NULL);
	element = _tmp9_;
	_tmp10_ = element;
	g_assert (_tmp10_ != NULL);
	_tmp11_ = element;
	xmlNodeSetContent (_tmp11_, RYGEL_XBOX_HACKS_MODEL_VERSION);
	_tmp12_ = doc;
	_tmp13_ = rygel_xml_utils_get_element ((xmlNode*) _tmp12_, "root", "device", "friendlyName", NULL);
	element = _tmp13_;
	_tmp14_ = element;
	g_assert (_tmp14_ != NULL);
	_tmp15_ = element;
	xmlNodeAddContent (_tmp15_, RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX);
	_tmp16_ = doc;
	rygel_xbox_hacks_modify_service_list (self, _tmp16_);
}


static void rygel_xbox_hacks_modify_service_list (RygelXBoxHacks* self, xmlNode* doc_node) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	gboolean _tmp2_ = FALSE;
	xmlNode* _tmp3_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = doc_node;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "root", "device", "serviceList", NULL);
	element = _tmp1_;
	_tmp3_ = element;
	if (_tmp3_ != NULL) {
		xmlNode* _tmp4_;
		xmlNode* _tmp5_;
		_tmp4_ = element;
		_tmp5_ = _tmp4_->children;
		_tmp2_ = _tmp5_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	g_assert (_tmp6_);
	{
		xmlNode* _tmp7_;
		xmlNode* _tmp8_;
		xmlNode* service_node;
		_tmp7_ = element;
		_tmp8_ = _tmp7_->children;
		service_node = _tmp8_;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				xmlNode* _tmp13_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					xmlNode* _tmp11_;
					xmlNode* _tmp12_;
					_tmp11_ = service_node;
					_tmp12_ = _tmp11_->next;
					service_node = _tmp12_;
				}
				_tmp9_ = FALSE;
				_tmp13_ = service_node;
				if (!(_tmp13_ != NULL)) {
					break;
				}
				{
					xmlNode* _tmp14_;
					xmlNode* _tmp15_;
					xmlNode* type_node;
					_tmp14_ = service_node;
					_tmp15_ = _tmp14_->children;
					type_node = _tmp15_;
					{
						gboolean _tmp16_;
						_tmp16_ = TRUE;
						while (TRUE) {
							gboolean _tmp17_;
							xmlNode* _tmp20_;
							xmlNode* _tmp21_;
							const gchar* _tmp22_;
							_tmp17_ = _tmp16_;
							if (!_tmp17_) {
								xmlNode* _tmp18_;
								xmlNode* _tmp19_;
								_tmp18_ = type_node;
								_tmp19_ = _tmp18_->next;
								type_node = _tmp19_;
							}
							_tmp16_ = FALSE;
							_tmp20_ = type_node;
							if (!(_tmp20_ != NULL)) {
								break;
							}
							_tmp21_ = type_node;
							_tmp22_ = _tmp21_->name;
							if (g_strcmp0 (_tmp22_, "serviceType") == 0) {
								xmlNode* _tmp23_;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_;
								GQuark _tmp27_ = 0U;
								_tmp23_ = type_node;
								_tmp24_ = xmlNodeGetContent (_tmp23_);
								_tmp25_ = _tmp24_;
								_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
								g_free (_tmp25_);
								if (_tmp27_ == g_quark_from_string (RYGEL_CONTENT_DIRECTORY_UPNP_TYPE)) {
									switch (0) {
										default:
										{
											xmlNode* _tmp28_;
											_tmp28_ = type_node;
											xmlNodeSetContent (_tmp28_, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1);
											break;
										}
									}
								} else if (_tmp27_ == g_quark_from_string (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE)) {
									switch (0) {
										default:
										{
											xmlNode* _tmp29_;
											_tmp29_ = type_node;
											xmlNodeSetContent (_tmp29_, RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE);
											break;
										}
									}
								} else {
									switch (0) {
										default:
										{
											break;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* f;
	gint res;
	FILE* _tmp2_;
	gboolean _tmp7_ = FALSE;
	FILE* _tmp8_;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (desc_path != NULL);
	_tmp0_ = desc_path;
	_tmp1_ = fopen (_tmp0_, "w+");
	f = _tmp1_;
	res = -1;
	_tmp2_ = f;
	if (_tmp2_ != NULL) {
		GUPnPXMLDoc* _tmp3_;
		xmlDoc* _tmp4_;
		FILE* _tmp5_;
		gint _tmp6_ = 0;
		_tmp3_ = doc;
		_tmp4_ = _tmp3_->doc;
		_tmp5_ = f;
		_tmp6_ = xmlDocDump (_tmp5_, _tmp4_);
		res = _tmp6_;
	}
	_tmp8_ = f;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_;
		_tmp9_ = res;
		_tmp7_ = _tmp9_ == (-1);
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* message;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp11_ = _ ("Failed to write modified description to %s.");
		_tmp12_ = g_strdup (_tmp11_);
		message = _tmp12_;
		_tmp13_ = message;
		_tmp14_ = desc_path;
		_tmp15_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp13_, _tmp14_);
		_inner_error_ = _tmp15_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_fclose0 (f);
		return;
	}
	_fclose0 (f);
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
	RYGEL_CLIENT_HACKS_CLASS (klass)->translate_container_id = rygel_xbox_hacks_real_translate_container_id;
	RYGEL_CLIENT_HACKS_CLASS (klass)->apply = rygel_xbox_hacks_real_apply;
	RYGEL_CLIENT_HACKS_CLASS (klass)->search = rygel_xbox_hacks_real_search;
	RYGEL_CLIENT_HACKS_CLASS (klass)->search_finish = rygel_xbox_hacks_real_search_finish;
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}



