/* rygel-subtitle-manager.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-subtitle-manager.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>.
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
typedef struct _RygelSubtitleManagerPrivate RygelSubtitleManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

typedef enum  {
	SUBTITLE_MANAGER_ERROR_NO_SUBTITLE
} SubtitleManagerError;
#define SUBTITLE_MANAGER_ERROR subtitle_manager_error_quark ()
struct _RygelSubtitleManager {
	GObject parent_instance;
	RygelSubtitleManagerPrivate * priv;
};

struct _RygelSubtitleManagerClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_subtitle_manager_parent_class = NULL;
static RygelSubtitleManager* rygel_subtitle_manager_manager;
static RygelSubtitleManager* rygel_subtitle_manager_manager = NULL;

GQuark subtitle_manager_error_quark (void);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_MANAGER_DUMMY_PROPERTY
};
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitleManager* rygel_subtitle_manager_new (void);
RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const gchar* uri, GError** error);
RygelSubtitle* rygel_subtitle_new (const gchar* mime_type, const gchar* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type, const gchar* mime_type, const gchar* caption_type);
static void rygel_subtitle_manager_finalize (GObject* obj);


GQuark subtitle_manager_error_quark (void) {
	return g_quark_from_static_string ("subtitle_manager_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelSubtitleManager* rygel_subtitle_manager_get_default (void) {
	RygelSubtitleManager* result = NULL;
	RygelSubtitleManager* _tmp0_;
	RygelSubtitleManager* _tmp2_;
	RygelSubtitleManager* _tmp3_;
	_tmp0_ = rygel_subtitle_manager_manager;
	if (_tmp0_ == NULL) {
		RygelSubtitleManager* _tmp1_;
		_tmp1_ = rygel_subtitle_manager_new ();
		_g_object_unref0 (rygel_subtitle_manager_manager);
		rygel_subtitle_manager_manager = _tmp1_;
	}
	_tmp2_ = rygel_subtitle_manager_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const gchar* uri, GError** error) {
	RygelSubtitle* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* video_file;
	GFile* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* directory;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* filename;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint ext_index;
	gint _tmp8_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_ = NULL;
	GFile* srt_file;
	GFile* _tmp17_;
	GFileInfo* _tmp18_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp19_;
	gboolean _tmp20_ = FALSE;
	RygelSubtitle* _tmp23_;
	RygelSubtitle* subtitle;
	RygelSubtitle* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_ = NULL;
	RygelSubtitle* _tmp27_;
	GFileInfo* _tmp28_;
	guint64 _tmp29_ = 0ULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	video_file = _tmp1_;
	_tmp2_ = video_file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	directory = _tmp3_;
	_tmp4_ = video_file;
	_tmp5_ = g_file_get_basename (_tmp4_);
	filename = _tmp5_;
	_tmp6_ = filename;
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
	ext_index = _tmp7_;
	_tmp8_ = ext_index;
	if (_tmp8_ >= 0) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp9_ = filename;
		_tmp10_ = ext_index;
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
		_g_free0 (filename);
		filename = _tmp11_;
	}
	_tmp12_ = filename;
	_tmp13_ = g_strconcat (_tmp12_, ".srt", NULL);
	_g_free0 (filename);
	filename = _tmp13_;
	_tmp14_ = directory;
	_tmp15_ = filename;
	_tmp16_ = g_file_get_child (_tmp14_, _tmp15_);
	srt_file = _tmp16_;
	_tmp17_ = srt_file;
	_tmp18_ = g_file_query_info (_tmp17_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp18_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (srt_file);
		_g_free0 (filename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	_tmp19_ = info;
	_tmp20_ = g_file_info_get_attribute_boolean (_tmp19_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp20_) {
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_;
		_tmp21_ = _ ("No subtitle available");
		_tmp22_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _tmp21_);
		_inner_error_ = _tmp22_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (srt_file);
		_g_free0 (filename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	_tmp23_ = rygel_subtitle_new ("text/plain", "srt");
	subtitle = _tmp23_;
	_tmp24_ = subtitle;
	_tmp25_ = srt_file;
	_tmp26_ = g_file_get_uri (_tmp25_);
	_g_free0 (_tmp24_->uri);
	_tmp24_->uri = _tmp26_;
	_tmp27_ = subtitle;
	_tmp28_ = info;
	_tmp29_ = g_file_info_get_attribute_uint64 (_tmp28_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
	_tmp27_->size = (gint64) _tmp29_;
	result = subtitle;
	_g_object_unref0 (info);
	_g_object_unref0 (srt_file);
	_g_free0 (filename);
	_g_object_unref0 (directory);
	_g_object_unref0 (video_file);
	return result;
}


RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type) {
	RygelSubtitleManager * self = NULL;
	self = (RygelSubtitleManager*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitleManager* rygel_subtitle_manager_new (void) {
	return rygel_subtitle_manager_construct (RYGEL_TYPE_SUBTITLE_MANAGER);
}


static void rygel_subtitle_manager_class_init (RygelSubtitleManagerClass * klass) {
	rygel_subtitle_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_manager_finalize;
}


static void rygel_subtitle_manager_instance_init (RygelSubtitleManager * self) {
}


static void rygel_subtitle_manager_finalize (GObject* obj) {
	RygelSubtitleManager * self;
	self = RYGEL_SUBTITLE_MANAGER (obj);
	G_OBJECT_CLASS (rygel_subtitle_manager_parent_class)->finalize (obj);
}


/**
 * Provides subtitles for vidoes.
 */
GType rygel_subtitle_manager_get_type (void) {
	static volatile gsize rygel_subtitle_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitleManager), 0, (GInstanceInitFunc) rygel_subtitle_manager_instance_init, NULL };
		GType rygel_subtitle_manager_type_id;
		rygel_subtitle_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitleManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_manager_type_id__volatile, rygel_subtitle_manager_type_id);
	}
	return rygel_subtitle_manager_type_id__volatile;
}



