/* rygel-http-get.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetPrivate {
	gint thumbnail_index;
	gint subtitle_index;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* header;
	gboolean _tmp4_;
	gboolean _tmp5_;
	SoupMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	SoupMessage* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	RygelHTTPItemURI* _tmp23_;
	const gchar* _tmp24_;
	RygelHTTPServer* _tmp25_;
	RygelHTTPItemURI* _tmp26_;
	const gchar* _tmp27_;
	RygelTranscoder* _tmp28_;
	RygelTranscoder* transcoder;
	RygelTranscoder* _tmp29_;
	GCancellable* _tmp30_;
	GCancellable* _tmp31_;
	RygelHTTPTranscodeHandler* _tmp32_;
	RygelHTTPGetHandler* _tmp33_;
	GCancellable* _tmp34_;
	GCancellable* _tmp35_;
	RygelHTTPIdentityHandler* _tmp36_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	gchar* artist;
	gchar* album;
	gchar* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	gchar* author;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	RygelMediaItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelMediaItem* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	SoupMessage* _tmp7_;
	SoupMessageHeaders* _tmp8_;
	RygelClientHacks* _tmp9_;
	RygelClientHacks* hack;
	gboolean _tmp10_;
	RygelClientHacks* _tmp11_;
	SoupMessage* _tmp12_;
	gboolean _tmp13_;
	RygelMediaItem* _tmp14_;
	gboolean _tmp15_;
	RygelMediaItem* _tmp16_;
	RygelVisualItem* _tmp17_;
	RygelVisualItem* visual_item;
	RygelVisualItem* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	RygelVisualItem* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	RygelVisualItem* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	gpointer _tmp29_;
	GError* _error_;
	RygelHTTPItemURI* _tmp30_;
	gint _tmp31_;
	RygelMediaItem* _tmp32_;
	RygelMediaItem* _tmp33_;
	RygelMusicItem* _tmp34_;
	RygelMusicItem* music;
	RygelMusicItem* _tmp35_;
	RygelThumbnail* _tmp36_;
	RygelThumbnail* _tmp37_;
	RygelMediaItem* _tmp38_;
	RygelMediaItem* _tmp39_;
	RygelVisualItem* _tmp40_;
	RygelVisualItem* visual;
	RygelVisualItem* _tmp41_;
	GeeArrayList* _tmp42_;
	GeeArrayList* _tmp43_;
	RygelHTTPItemURI* _tmp44_;
	gint _tmp45_;
	gpointer _tmp46_;
	RygelMediaItem* _tmp47_;
	const gchar* _tmp48_;
	GError* _tmp49_;
	RygelHTTPItemURI* _tmp50_;
	gint _tmp51_;
	RygelMediaItem* _tmp52_;
	RygelMediaItem* _tmp53_;
	const gchar* _tmp54_;
	GError* _tmp55_;
	RygelMediaItem* _tmp56_;
	GeeArrayList* _tmp57_;
	RygelHTTPItemURI* _tmp58_;
	gint _tmp59_;
	gpointer _tmp60_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean _tmp0_;
	gboolean need_time_seek;
	gboolean _tmp1_;
	gboolean need_byte_seek;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError* _tmp12_;
	gboolean _tmp13_;
	RygelHTTPTimeSeek* _tmp14_;
	RygelHTTPTimeSeek* _tmp15_;
	gboolean _tmp16_;
	RygelHTTPByteSeek* _tmp17_;
	RygelHTTPByteSeek* _tmp18_;
	GError* _error_;
	SoupServer* _tmp19_;
	SoupMessage* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	RygelHTTPGetHandler* _tmp25_;
	SoupMessage* _tmp26_;
	SoupMessageHeaders* _tmp27_;
	const gchar* _tmp28_;
	SoupMessage* _tmp29_;
	SoupMessage* _tmp30_;
	gboolean _tmp31_;
	RygelHTTPSeek* _tmp32_;
	RygelHTTPSeek* _tmp33_;
	gboolean _tmp34_;
	SoupMessage* _tmp35_;
	SoupMessageHeaders* _tmp36_;
	SoupMessage* _tmp37_;
	SoupMessageHeaders* _tmp38_;
	SoupMessage* _tmp39_;
	SoupMessageHeaders* _tmp40_;
	SoupMessage* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gboolean _tmp45_;
	SoupServer* _tmp46_;
	SoupMessage* _tmp47_;
	RygelHTTPGetHandler* _tmp48_;
	RygelHTTPResponse* _tmp49_;
	RygelHTTPResponse* response;
	RygelHTTPResponse* _tmp50_;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET, RygelHTTPGetPrivate))
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_);
GQuark rygel_http_request_error_quark (void);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create_for_headers (SoupMessageHeaders* headers, GError** error);
gboolean rygel_client_hacks_is_album_art_request (RygelClientHacks* self, SoupMessage* message);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static void __lambda4_ (RygelHTTPGet* self, const gchar* name, const gchar* value);
static void ___lambda4__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
static void rygel_http_get_finalize (GObject* obj);


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet * self = NULL;
	RygelHTTPServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = http_server;
	_tmp1_ = server;
	_tmp2_ = msg;
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	self->priv->thumbnail_index = -1;
	self->priv->subtitle_index = -1;
	return self;
}


RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
}


static void rygel_http_get_real_handle_data_free (gpointer _data) {
	RygelHttpGetHandleData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetHandleData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	RygelHTTPGet* _tmp0_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_handle);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_real_handle_co (_data_);
}


static void rygel_http_get_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_real_handle_co (_data_);
}


static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp1_ = _data_->_tmp0_->request_headers;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = soup_message_headers_get_one (_data_->_tmp1_, "getcontentFeatures.dlna.org");
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->header = _data_->_tmp3_;
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp7_ = NULL;
	g_object_get (_data_->_tmp6_, "method", &_data_->_tmp7_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = g_strcmp0 (_data_->_tmp9_, "HEAD") != 0;
	_g_free0 (_data_->_tmp9_);
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp12_ = NULL;
		g_object_get (_data_->_tmp11_, "method", &_data_->_tmp12_, NULL);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp14_, "GET") != 0;
		_g_free0 (_data_->_tmp14_);
	} else {
		_data_->_tmp5_ = FALSE;
	}
	_data_->_tmp15_ = _data_->_tmp5_;
	if (_data_->_tmp15_) {
		_data_->_tmp4_ = TRUE;
	} else {
		_data_->_tmp17_ = _data_->header;
		if (_data_->_tmp17_ != NULL) {
			_data_->_tmp18_ = _data_->header;
			_data_->_tmp16_ = g_strcmp0 (_data_->_tmp18_, "1") != 0;
		} else {
			_data_->_tmp16_ = FALSE;
		}
		_data_->_tmp19_ = _data_->_tmp16_;
		_data_->_tmp4_ = _data_->_tmp19_;
	}
	_data_->_tmp20_ = _data_->_tmp4_;
	if (_data_->_tmp20_) {
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _ ("Invalid Request");
		_data_->_tmp22_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp21_);
		_data_->_inner_error_ = _data_->_tmp22_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->header);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = ((RygelHTTPRequest*) _data_->self)->uri;
	_data_->_tmp24_ = _data_->_tmp23_->transcode_target;
	if (_data_->_tmp24_ != NULL) {
		_data_->_tmp25_ = ((RygelHTTPRequest*) _data_->self)->http_server;
		_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->uri;
		_data_->_tmp27_ = _data_->_tmp26_->transcode_target;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = rygel_transcode_manager_get_transcoder ((RygelTranscodeManager*) _data_->_tmp25_, _data_->_tmp27_, &_data_->_inner_error_);
		_data_->transcoder = _data_->_tmp28_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->header);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp29_ = _data_->transcoder;
		_data_->_tmp30_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = rygel_http_transcode_handler_new (_data_->_tmp29_, _data_->_tmp31_);
		_g_object_unref0 (_data_->self->handler);
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp32_;
		_g_object_unref0 (_data_->transcoder);
	}
	_data_->_tmp33_ = _data_->self->handler;
	if (_data_->_tmp33_ == NULL) {
		_data_->_tmp34_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = rygel_http_identity_handler_new (_data_->_tmp35_);
		_g_object_unref0 (_data_->self->handler);
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp36_;
	}
	rygel_http_get_ensure_correct_mode (_data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->header);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	rygel_http_get_handle_item_request (_data_->self, rygel_http_get_handle_ready, _data_);
	return FALSE;
	_state_1:
	rygel_http_get_handle_item_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->header);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->header);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_get_real_find_item_data_free (gpointer _data) {
	RygelHttpGetFindItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetFindItemData, _data_);
}


static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	RygelHTTPGet* _tmp0_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_find_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_real_find_item_co (_data_);
}


static void rygel_http_get_real_find_item_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetFindItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetFindItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_real_find_item_co (_data_);
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
	return self ? rygel_icon_info_ref (self) : NULL;
}


static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (RYGEL_HTTP_REQUEST (_data_->self), rygel_http_get_find_item_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (RYGEL_HTTP_REQUEST (_data_->self), _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->item;
	_data_->_tmp1_ = rygel_media_item_get_place_holder (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = G_UNLIKELY (_data_->_tmp2_);
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->item;
		_data_->_tmp5_ = ((RygelMediaObject*) _data_->_tmp4_)->id;
		_data_->_tmp6_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Item '%s' is empty", _data_->_tmp5_);
		_data_->_inner_error_ = _data_->_tmp6_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp8_ = _data_->_tmp7_->request_headers;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = rygel_client_hacks_create_for_headers (_data_->_tmp8_, &_data_->_inner_error_);
		_data_->hack = _data_->_tmp9_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
				goto __catch37_rygel_client_hacks_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->hack;
		_data_->_tmp12_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = rygel_client_hacks_is_album_art_request (_data_->_tmp11_, _data_->_tmp12_);
		if (_data_->_tmp13_) {
			_data_->_tmp14_ = ((RygelHTTPRequest*) _data_->self)->item;
			_data_->_tmp10_ = RYGEL_IS_VISUAL_ITEM (_data_->_tmp14_);
		} else {
			_data_->_tmp10_ = FALSE;
		}
		_data_->_tmp15_ = _data_->_tmp10_;
		if (_data_->_tmp15_) {
			_data_->_tmp16_ = ((RygelHTTPRequest*) _data_->self)->item;
			_data_->_tmp17_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_data_->_tmp16_) ? ((RygelVisualItem*) _data_->_tmp16_) : NULL);
			_data_->visual_item = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->visual_item;
			_data_->_tmp19_ = rygel_visual_item_get_thumbnails (_data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp20_);
			_data_->_tmp22_ = _data_->_tmp21_;
			if (_data_->_tmp22_ <= 0) {
				_data_->_tmp23_ = _data_->visual_item;
				_data_->_tmp24_ = ((RygelMediaObject*) _data_->_tmp23_)->id;
				_data_->_tmp25_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No Thumbnail " "available for " "item '%s'", _data_->_tmp24_);
				_data_->_inner_error_ = _data_->_tmp25_;
				_g_object_unref0 (_data_->visual_item);
				_g_object_unref0 (_data_->hack);
				if (_data_->_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
					goto __catch37_rygel_client_hacks_error;
				}
				goto __finally37;
			}
			_data_->_tmp26_ = _data_->visual_item;
			_data_->_tmp27_ = rygel_visual_item_get_thumbnails (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp28_, 0);
			_rygel_icon_info_unref0 (_data_->self->thumbnail);
			_data_->self->thumbnail = (RygelThumbnail*) _data_->_tmp29_;
			_g_object_unref0 (_data_->visual_item);
			_g_object_unref0 (_data_->hack);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->hack);
	}
	goto __finally37;
	__catch37_rygel_client_hacks_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->_error_);
	}
	__finally37:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = ((RygelHTTPRequest*) _data_->self)->uri;
	_data_->_tmp31_ = _data_->_tmp30_->thumbnail_index;
	if (_data_->_tmp31_ >= 0) {
		_data_->_tmp32_ = ((RygelHTTPRequest*) _data_->self)->item;
		if (RYGEL_IS_MUSIC_ITEM (_data_->_tmp32_)) {
			_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->item;
			_data_->_tmp34_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_data_->_tmp33_) ? ((RygelMusicItem*) _data_->_tmp33_) : NULL);
			_data_->music = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->music;
			_data_->_tmp36_ = _data_->_tmp35_->album_art;
			_data_->_tmp37_ = _rygel_icon_info_ref0 (_data_->_tmp36_);
			_rygel_icon_info_unref0 (_data_->self->thumbnail);
			_data_->self->thumbnail = _data_->_tmp37_;
			_g_object_unref0 (_data_->music);
		} else {
			_data_->_tmp38_ = ((RygelHTTPRequest*) _data_->self)->item;
			if (RYGEL_IS_VISUAL_ITEM (_data_->_tmp38_)) {
				_data_->_tmp39_ = ((RygelHTTPRequest*) _data_->self)->item;
				_data_->_tmp40_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_data_->_tmp39_) ? ((RygelVisualItem*) _data_->_tmp39_) : NULL);
				_data_->visual = _data_->_tmp40_;
				_data_->_tmp41_ = _data_->visual;
				_data_->_tmp42_ = rygel_visual_item_get_thumbnails (_data_->_tmp41_);
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp45_ = _data_->_tmp44_->thumbnail_index;
				_data_->_tmp46_ = NULL;
				_data_->_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp43_, _data_->_tmp45_);
				_rygel_icon_info_unref0 (_data_->self->thumbnail);
				_data_->self->thumbnail = (RygelThumbnail*) _data_->_tmp46_;
				_g_object_unref0 (_data_->visual);
			} else {
				_data_->_tmp47_ = ((RygelHTTPRequest*) _data_->self)->item;
				_data_->_tmp48_ = ((RygelMediaObject*) _data_->_tmp47_)->id;
				_data_->_tmp49_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No Thumbnail available for item '%s", _data_->_tmp48_);
				_data_->_inner_error_ = _data_->_tmp49_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp50_ = ((RygelHTTPRequest*) _data_->self)->uri;
		_data_->_tmp51_ = _data_->_tmp50_->subtitle_index;
		if (_data_->_tmp51_ >= 0) {
			_data_->_tmp52_ = ((RygelHTTPRequest*) _data_->self)->item;
			if (!RYGEL_IS_VIDEO_ITEM (_data_->_tmp52_)) {
				_data_->_tmp53_ = ((RygelHTTPRequest*) _data_->self)->item;
				_data_->_tmp54_ = ((RygelMediaObject*) _data_->_tmp53_)->id;
				_data_->_tmp55_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No subtitles available for item '%s", _data_->_tmp54_);
				_data_->_inner_error_ = _data_->_tmp55_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp56_ = ((RygelHTTPRequest*) _data_->self)->item;
			_data_->_tmp57_ = (RYGEL_IS_VIDEO_ITEM (_data_->_tmp56_) ? ((RygelVideoItem*) _data_->_tmp56_) : NULL)->subtitles;
			_data_->_tmp58_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp59_ = _data_->_tmp58_->subtitle_index;
			_data_->_tmp60_ = NULL;
			_data_->_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp57_, _data_->_tmp59_);
			_rygel_subtitle_unref0 (_data_->self->subtitle);
			_data_->self->subtitle = (RygelSubtitle*) _data_->_tmp60_;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_get_handle_item_request_data_free (gpointer _data) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetHandleItemRequestData, _data_);
}


static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	RygelHTTPGet* _tmp0_;
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_handle_item_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_handle_item_request_co (_data_);
}


static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleItemRequestData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda4_ (RygelHTTPGet* self, const gchar* name, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = name;
	_tmp1_ = value;
	g_debug ("rygel-http-get.vala:180: %s : %s", _tmp0_, _tmp1_);
}


static void ___lambda4__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
	__lambda4_ (self, name, value);
}


static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_handle_item_request_co (_data_);
}


static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = rygel_http_time_seek_needed (_data_->self);
	_data_->need_time_seek = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = rygel_http_byte_seek_needed (_data_->self);
	_data_->need_byte_seek = _data_->_tmp1_;
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = rygel_http_time_seek_requested (_data_->self);
	if (_data_->_tmp4_) {
		_data_->_tmp5_ = _data_->need_time_seek;
		_data_->_tmp3_ = !_data_->_tmp5_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	_data_->_tmp6_ = _data_->_tmp3_;
	if (_data_->_tmp6_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = rygel_http_byte_seek_requested (_data_->self);
		if (_data_->_tmp8_) {
			_data_->_tmp9_ = _data_->need_byte_seek;
			_data_->_tmp7_ = !_data_->_tmp9_;
		} else {
			_data_->_tmp7_ = FALSE;
		}
		_data_->_tmp10_ = _data_->_tmp7_;
		_data_->_tmp2_ = _data_->_tmp10_;
	}
	_data_->_tmp11_ = _data_->_tmp2_;
	if (_data_->_tmp11_) {
		_data_->_tmp12_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "Invalid seek request");
		_data_->_inner_error_ = _data_->_tmp12_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp13_ = _data_->need_time_seek;
		if (_data_->_tmp13_) {
			_data_->_tmp14_ = rygel_http_time_seek_new (_data_->self, &_data_->_inner_error_);
			_data_->_tmp15_ = _data_->_tmp14_;
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
					goto __catch38_rygel_http_seek_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (_data_->self->seek);
			_data_->self->seek = (RygelHTTPSeek*) _data_->_tmp15_;
		} else {
			_data_->_tmp16_ = _data_->need_byte_seek;
			if (_data_->_tmp16_) {
				_data_->_tmp17_ = rygel_http_byte_seek_new (_data_->self, &_data_->_inner_error_);
				_data_->_tmp18_ = _data_->_tmp17_;
				if (_data_->_inner_error_ != NULL) {
					if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
						goto __catch38_rygel_http_seek_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (_data_->self->seek);
				_data_->self->seek = (RygelHTTPSeek*) _data_->_tmp18_;
			}
		}
	}
	goto __finally38;
	__catch38_rygel_http_seek_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp20_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp19_, _data_->_tmp20_);
		_data_->_tmp21_ = _data_->_error_;
		if (g_error_matches (_data_->_tmp21_, RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE)) {
			rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_BAD_REQUEST);
		} else {
			_data_->_tmp22_ = _data_->_error_;
			if (g_error_matches (_data_->_tmp22_, RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE)) {
				rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
			} else {
				_data_->_tmp23_ = _data_->_error_;
				_data_->_tmp24_ = _g_error_copy0 (_data_->_tmp23_);
				_data_->_inner_error_ = _data_->_tmp24_;
				_g_error_free0 (_data_->_error_);
				goto __finally38;
			}
		}
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally38:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->self->handler;
	rygel_http_get_handler_add_response_headers (_data_->_tmp25_, _data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp27_ = _data_->_tmp26_->request_headers;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = soup_message_headers_get_one (_data_->_tmp27_, "Range");
	if (_data_->_tmp28_ != NULL) {
		_data_->_tmp29_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_message_set_status (_data_->_tmp29_, (guint) SOUP_STATUS_PARTIAL_CONTENT);
	} else {
		_data_->_tmp30_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_message_set_status (_data_->_tmp30_, (guint) SOUP_STATUS_OK);
	}
	_data_->_tmp32_ = _data_->self->seek;
	if (_data_->_tmp32_ != NULL) {
		_data_->_tmp33_ = _data_->self->seek;
		_data_->_tmp31_ = RYGEL_IS_HTTP_BYTE_SEEK (_data_->_tmp33_);
	} else {
		_data_->_tmp31_ = FALSE;
	}
	_data_->_tmp34_ = _data_->_tmp31_;
	if (_data_->_tmp34_) {
		_data_->_tmp35_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp36_ = _data_->_tmp35_->response_headers;
		soup_message_headers_set_encoding (_data_->_tmp36_, SOUP_ENCODING_CONTENT_LENGTH);
	} else {
		_data_->_tmp37_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp38_ = _data_->_tmp37_->response_headers;
		soup_message_headers_set_encoding (_data_->_tmp38_, SOUP_ENCODING_EOF);
	}
	g_debug ("rygel-http-get.vala:178: Following HTTP headers appended to response:");
	_data_->_tmp39_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp40_ = _data_->_tmp39_->response_headers;
	soup_message_headers_foreach (_data_->_tmp40_, ___lambda4__soup_message_headers_foreach_func, _data_->self);
	_data_->_tmp41_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp42_ = NULL;
	g_object_get (_data_->_tmp41_, "method", &_data_->_tmp42_, NULL);
	_data_->_tmp43_ = _data_->_tmp42_;
	_data_->_tmp44_ = _data_->_tmp43_;
	_data_->_tmp45_ = g_strcmp0 (_data_->_tmp44_, "HEAD") == 0;
	_g_free0 (_data_->_tmp44_);
	if (_data_->_tmp45_) {
		_data_->_tmp46_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp47_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp46_, _data_->_tmp47_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp48_ = _data_->self->handler;
	_data_->_tmp49_ = NULL;
	_data_->_tmp49_ = rygel_http_get_handler_render_body (_data_->_tmp48_, _data_->self, &_data_->_inner_error_);
	_data_->response = _data_->_tmp49_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp50_ = _data_->response;
	_data_->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp50_, rygel_http_get_handle_item_request_ready, _data_);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp50_, _data_->_res_);
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NONE);
	_g_object_unref0 (_data_->response);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error) {
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* mode;
	gboolean correct;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	gboolean _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER);
	_tmp3_ = g_strdup (_tmp2_);
	mode = _tmp3_;
	correct = TRUE;
	_tmp4_ = mode;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Streaming")))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_ = FALSE;
				RygelHTTPGetHandler* _tmp9_;
				gboolean _tmp18_;
				_tmp9_ = self->handler;
				if (RYGEL_IS_HTTP_TRANSCODE_HANDLER (_tmp9_)) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					RygelMediaItem* _tmp12_;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp15_;
					gboolean _tmp17_;
					_tmp12_ = ((RygelHTTPRequest*) self)->item;
					_tmp13_ = rygel_media_item_streamable (_tmp12_);
					if (_tmp13_) {
						RygelSubtitle* _tmp14_;
						_tmp14_ = self->subtitle;
						_tmp11_ = _tmp14_ == NULL;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp15_ = _tmp11_;
					if (_tmp15_) {
						RygelThumbnail* _tmp16_;
						_tmp16_ = self->thumbnail;
						_tmp10_ = _tmp16_ == NULL;
					} else {
						_tmp10_ = FALSE;
					}
					_tmp17_ = _tmp10_;
					_tmp8_ = _tmp17_;
				}
				_tmp18_ = _tmp8_;
				correct = _tmp18_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Interactive")))) {
		switch (0) {
			default:
			{
				gboolean _tmp19_ = FALSE;
				RygelHTTPGetHandler* _tmp20_;
				gboolean _tmp33_;
				_tmp20_ = self->handler;
				if (RYGEL_IS_HTTP_IDENTITY_HANDLER (_tmp20_)) {
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					RygelMediaItem* _tmp23_;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp27_;
					gboolean _tmp32_;
					_tmp23_ = ((RygelHTTPRequest*) self)->item;
					_tmp24_ = rygel_media_item_is_live_stream (_tmp23_);
					if (!_tmp24_) {
						RygelMediaItem* _tmp25_;
						gboolean _tmp26_ = FALSE;
						_tmp25_ = ((RygelHTTPRequest*) self)->item;
						_tmp26_ = rygel_media_item_streamable (_tmp25_);
						_tmp22_ = !_tmp26_;
					} else {
						_tmp22_ = FALSE;
					}
					_tmp27_ = _tmp22_;
					if (_tmp27_) {
						_tmp21_ = TRUE;
					} else {
						gboolean _tmp28_ = FALSE;
						RygelSubtitle* _tmp29_;
						gboolean _tmp31_;
						_tmp29_ = self->subtitle;
						if (_tmp29_ != NULL) {
							_tmp28_ = TRUE;
						} else {
							RygelThumbnail* _tmp30_;
							_tmp30_ = self->thumbnail;
							_tmp28_ = _tmp30_ != NULL;
						}
						_tmp31_ = _tmp28_;
						_tmp21_ = _tmp31_;
					}
					_tmp32_ = _tmp21_;
					_tmp19_ = _tmp32_;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp33_ = _tmp19_;
				correct = _tmp33_;
				break;
			}
		}
	}
	_tmp34_ = correct;
	if (!_tmp34_) {
		const gchar* _tmp35_;
		RygelMediaItem* _tmp36_;
		const gchar* _tmp37_;
		GError* _tmp38_;
		_tmp35_ = mode;
		_tmp36_ = ((RygelHTTPRequest*) self)->item;
		_tmp37_ = ((RygelMediaObject*) _tmp36_)->id;
		_tmp38_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "%s mode not supported for '%s'", _tmp35_, _tmp37_);
		_inner_error_ = _tmp38_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (mode);
			return;
		} else {
			_g_free0 (mode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (mode);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetPrivate));
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_get_real_handle;
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_get_real_handle_finish;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_get_real_find_item;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_get_real_find_item_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
	self->priv = RYGEL_HTTP_GET_GET_PRIVATE (self);
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = RYGEL_HTTP_GET (obj);
	_rygel_icon_info_unref0 (self->thumbnail);
	_rygel_subtitle_unref0 (self->subtitle);
	_g_object_unref0 (self->seek);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}



