/* sudoku-game.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from sudoku-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <string.h>


#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define SUDOKU_GAME_TYPE_UNDO_ITEM (sudoku_game_undo_item_get_type ())
typedef struct _SudokuGameUndoItem SudokuGameUndoItem;
enum  {
	SUDOKU_GAME_DUMMY_PROPERTY,
	SUDOKU_GAME_PAUSED,
	SUDOKU_GAME_LAST_PROPERTY
};
static GParamSpec* sudoku_game_properties[SUDOKU_GAME_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _sudoku_game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (sudoku_game_undo_item_free (var), NULL)))
enum  {
	SUDOKU_GAME_TICK_SIGNAL,
	SUDOKU_GAME_PAUSED_CHANGED_SIGNAL,
	SUDOKU_GAME_CELL_CHANGED_SIGNAL,
	SUDOKU_GAME_LAST_SIGNAL
};
static guint sudoku_game_signals[SUDOKU_GAME_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GameMode mode;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuGameUndoItem {
	gint row;
	gint col;
	gint val;
};

struct _SudokuGamePrivate {
	guint clock_timeout;
	gboolean _paused;
	GeeList* undostack;
	GeeList* redostack;
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_game_parent_class = NULL;

GType sudoku_game_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType game_mode_get_type (void) G_GNUC_CONST;
static GType sudoku_game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self);
static void sudoku_game_undo_item_free (SudokuGameUndoItem* self);
#define SUDOKU_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_GAME, SudokuGamePrivate))
gboolean sudoku_game_is_undostack_null (SudokuGame* self);
gboolean sudoku_game_is_redostack_null (SudokuGame* self);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
void sudoku_game_remove (SudokuGame* self, gint row, gint col);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
gboolean sudoku_game_is_empty (SudokuGame* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gboolean sudoku_board_is_empty (SudokuBoard* self);
void sudoku_game_undo (SudokuGame* self);
static void sudoku_game_apply_stack (SudokuGame* self, GeeList* from, GeeList* to);
void sudoku_game_redo (SudokuGame* self);
void sudoku_game_reset (SudokuGame* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
static void sudoku_game_add_to_stack (SudokuGame* self, GeeList* stack, gint r, gint c, gint v);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
static gboolean sudoku_game_timeout_cb (SudokuGame* self);
static gboolean _sudoku_game_timeout_cb_gsource_func (gpointer self);
void sudoku_game_start_clock (SudokuGame* self);
void sudoku_game_stop_clock (SudokuGame* self);
static void sudoku_game_set_paused (SudokuGame* self, gboolean value);
void sudoku_game_resume_clock (SudokuGame* self);
gboolean sudoku_game_get_paused (SudokuGame* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sudoku_game_finalize (GObject * obj);
static void _vala_sudoku_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gboolean sudoku_game_is_undostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->undostack;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}


gboolean sudoku_game_is_redostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->redostack;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board) {
	SudokuGame * self = NULL;
	SudokuBoard* _tmp0_;
	SudokuBoard* _tmp1_;
	GTimer* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_val_if_fail (board != NULL, NULL);
	self = (SudokuGame*) g_object_new (object_type, NULL);
	_tmp0_ = board;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->board);
	self->board = _tmp1_;
	self->mode = GAME_MODE_PLAY;
	_tmp2_ = g_timer_new ();
	_g_timer_destroy0 (self->timer);
	self->timer = _tmp2_;
	_tmp3_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, (GDestroyNotify) sudoku_game_undo_item_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->undostack);
	self->priv->undostack = (GeeList*) _tmp3_;
	_tmp4_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, (GDestroyNotify) sudoku_game_undo_item_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->redostack);
	self->priv->redostack = (GeeList*) _tmp4_;
	return self;
}


SudokuGame* sudoku_game_new (SudokuBoard* board) {
	return sudoku_game_construct (TYPE_SUDOKU_GAME, board);
}


void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val) {
	gint old_val = 0;
	SudokuBoard* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GameMode _tmp8_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->board;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
	old_val = _tmp3_;
	_tmp4_ = row;
	_tmp5_ = col;
	_tmp6_ = old_val;
	_tmp7_ = val;
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = self->mode;
	if (_tmp8_ == GAME_MODE_CREATE) {
		SudokuBoard* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		SudokuBoard* _tmp13_;
		gboolean* _tmp14_;
		gint _tmp14__length1;
		gint _tmp14__length2;
		gint _tmp15_;
		gint _tmp16_;
		gboolean _tmp17_;
		_tmp9_ = self->board;
		_tmp10_ = row;
		_tmp11_ = col;
		_tmp12_ = val;
		sudoku_board_insert (_tmp9_, _tmp10_, _tmp11_, _tmp12_, TRUE);
		_tmp13_ = self->board;
		_tmp14_ = _tmp13_->is_fixed;
		_tmp14__length1 = _tmp13_->is_fixed_length1;
		_tmp14__length2 = _tmp13_->is_fixed_length2;
		_tmp15_ = row;
		_tmp16_ = col;
		_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_] = TRUE;
		_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
	} else {
		SudokuBoard* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp18_ = self->board;
		_tmp19_ = row;
		_tmp20_ = col;
		_tmp21_ = val;
		sudoku_board_insert (_tmp18_, _tmp19_, _tmp20_, _tmp21_, FALSE);
	}
	_tmp22_ = row;
	_tmp23_ = col;
	_tmp24_ = old_val;
	_tmp25_ = val;
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_CELL_CHANGED_SIGNAL], 0, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
}


void sudoku_game_remove (SudokuGame* self, gint row, gint col) {
	gint old_val = 0;
	SudokuBoard* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GameMode _tmp7_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->board;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
	old_val = _tmp3_;
	_tmp4_ = row;
	_tmp5_ = col;
	_tmp6_ = old_val;
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, _tmp6_, 0);
	_tmp7_ = self->mode;
	if (_tmp7_ == GAME_MODE_CREATE) {
		SudokuBoard* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		SudokuBoard* _tmp11_;
		gboolean* _tmp12_;
		gint _tmp12__length1;
		gint _tmp12__length2;
		gint _tmp13_;
		gint _tmp14_;
		gboolean _tmp15_;
		_tmp8_ = self->board;
		_tmp9_ = row;
		_tmp10_ = col;
		sudoku_board_remove (_tmp8_, _tmp9_, _tmp10_, TRUE);
		_tmp11_ = self->board;
		_tmp12_ = _tmp11_->is_fixed;
		_tmp12__length1 = _tmp11_->is_fixed_length1;
		_tmp12__length2 = _tmp11_->is_fixed_length2;
		_tmp13_ = row;
		_tmp14_ = col;
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = FALSE;
		_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
	} else {
		SudokuBoard* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp16_ = self->board;
		_tmp17_ = row;
		_tmp18_ = col;
		sudoku_board_remove (_tmp16_, _tmp17_, _tmp18_, FALSE);
	}
	_tmp19_ = row;
	_tmp20_ = col;
	_tmp21_ = old_val;
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_CELL_CHANGED_SIGNAL], 0, _tmp19_, _tmp20_, _tmp21_, 0);
}


gboolean sudoku_game_is_empty (SudokuGame* self) {
	gboolean result = FALSE;
	GameMode _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->mode;
	if (_tmp0_ == GAME_MODE_CREATE) {
		SudokuBoard* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->board;
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
		_tmp3_ = _tmp2_;
		result = _tmp3_ == 0;
		return result;
	} else {
		SudokuBoard* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = self->board;
		_tmp5_ = sudoku_board_is_empty (_tmp4_);
		result = _tmp5_;
		return result;
	}
}


void sudoku_game_undo (SudokuGame* self) {
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undostack;
	_tmp1_ = self->priv->redostack;
	sudoku_game_apply_stack (self, _tmp0_, _tmp1_);
}


void sudoku_game_redo (SudokuGame* self) {
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->redostack;
	_tmp1_ = self->priv->undostack;
	sudoku_game_apply_stack (self, _tmp0_, _tmp1_);
}


void sudoku_game_reset (SudokuGame* self) {
	SudokuBoard* _tmp0_;
	GTimer* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	SudokuBoard* _tmp42_;
	GeeSet* _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->board;
	sudoku_board_set_previous_played_time (_tmp0_, (gdouble) 0);
	_tmp1_ = self->timer;
	g_timer_start (_tmp1_);
	_tmp2_ = self->priv->undostack;
	gee_collection_clear ((GeeCollection*) _tmp2_);
	_tmp3_ = self->priv->redostack;
	gee_collection_clear ((GeeCollection*) _tmp3_);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				SudokuBoard* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = l1;
					l1 = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = l1;
				_tmp7_ = self->board;
				_tmp8_ = sudoku_board_get_rows (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_;
							SudokuBoard* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gboolean _tmp16_ = FALSE;
							GameMode _tmp17_;
							SudokuBoard* _tmp23_;
							gint _tmp24_;
							gint _tmp25_;
							SudokuBoard* _tmp26_;
							gboolean* _tmp27_;
							gint _tmp27__length1;
							gint _tmp27__length2;
							gint _tmp28_;
							gint _tmp29_;
							gboolean _tmp30_;
							SudokuBoard* _tmp31_;
							gboolean* _tmp32_;
							gint _tmp32__length1;
							gint _tmp32__length2;
							gint _tmp33_;
							gint _tmp34_;
							gboolean _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							SudokuBoard* _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = l2;
								l2 = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = l2;
							_tmp13_ = self->board;
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
							_tmp15_ = _tmp14_;
							if (!(_tmp12_ < _tmp15_)) {
								break;
							}
							_tmp17_ = self->mode;
							if (_tmp17_ == GAME_MODE_PLAY) {
								SudokuBoard* _tmp18_;
								gboolean* _tmp19_;
								gint _tmp19__length1;
								gint _tmp19__length2;
								gint _tmp20_;
								gint _tmp21_;
								gboolean _tmp22_;
								_tmp18_ = self->board;
								_tmp19_ = _tmp18_->is_fixed;
								_tmp19__length1 = _tmp18_->is_fixed_length1;
								_tmp19__length2 = _tmp18_->is_fixed_length2;
								_tmp20_ = l1;
								_tmp21_ = l2;
								_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
								_tmp16_ = _tmp22_;
							} else {
								_tmp16_ = FALSE;
							}
							if (_tmp16_) {
								continue;
							}
							_tmp23_ = self->board;
							_tmp24_ = l1;
							_tmp25_ = l2;
							_tmp26_ = self->board;
							_tmp27_ = _tmp26_->is_fixed;
							_tmp27__length1 = _tmp26_->is_fixed_length1;
							_tmp27__length2 = _tmp26_->is_fixed_length2;
							_tmp28_ = l1;
							_tmp29_ = l2;
							_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
							sudoku_board_remove (_tmp23_, _tmp24_, _tmp25_, _tmp30_);
							_tmp31_ = self->board;
							_tmp32_ = _tmp31_->is_fixed;
							_tmp32__length1 = _tmp31_->is_fixed_length1;
							_tmp32__length2 = _tmp31_->is_fixed_length2;
							_tmp33_ = l1;
							_tmp34_ = l2;
							_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = FALSE;
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
							_tmp36_ = l1;
							_tmp37_ = l2;
							_tmp38_ = self->board;
							_tmp39_ = l1;
							_tmp40_ = l2;
							_tmp41_ = sudoku_board_get (_tmp38_, _tmp39_, _tmp40_);
							g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_CELL_CHANGED_SIGNAL], 0, _tmp36_, _tmp37_, _tmp41_, 0);
						}
					}
				}
			}
		}
	}
	_tmp42_ = self->board;
	_tmp43_ = _tmp42_->broken_coords;
	gee_collection_clear ((GeeCollection*) _tmp43_);
}


void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = row;
	_tmp1_ = col;
	_tmp2_ = old_val;
	_tmp3_ = new_val;
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_CELL_CHANGED_SIGNAL], 0, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undostack;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = old_val;
	sudoku_game_add_to_stack (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = self->priv->redostack;
	gee_collection_clear ((GeeCollection*) _tmp4_);
}


static void sudoku_game_add_to_stack (SudokuGame* self, GeeList* stack, gint r, gint c, gint v) {
	SudokuGameUndoItem step = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	SudokuGameUndoItem _tmp3_ = {0};
	GeeList* _tmp4_;
	SudokuGameUndoItem _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stack != NULL);
	_tmp0_ = r;
	_tmp1_ = c;
	_tmp2_ = v;
	_tmp3_.row = _tmp0_;
	_tmp3_.col = _tmp1_;
	_tmp3_.val = _tmp2_;
	step = _tmp3_;
	_tmp4_ = stack;
	_tmp5_ = step;
	gee_collection_add ((GeeCollection*) _tmp4_, &_tmp5_);
}


static void sudoku_game_apply_stack (SudokuGame* self, GeeList* from, GeeList* to) {
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	SudokuGameUndoItem* top = NULL;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	gint old_val = 0;
	SudokuBoard* _tmp8_;
	SudokuGameUndoItem* _tmp9_;
	gint _tmp10_;
	SudokuGameUndoItem* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeList* _tmp14_;
	SudokuGameUndoItem* _tmp15_;
	gint _tmp16_;
	SudokuGameUndoItem* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GameMode _tmp20_;
	SudokuGameUndoItem* _tmp45_;
	gint _tmp46_;
	SudokuGameUndoItem* _tmp76_;
	gint _tmp77_;
	SudokuGameUndoItem* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	SudokuGameUndoItem* _tmp81_;
	gint _tmp82_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = from;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = from;
	_tmp4_ = from;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_list_remove_at (_tmp3_, _tmp6_ - 1);
	top = (SudokuGameUndoItem*) _tmp7_;
	_tmp8_ = self->board;
	_tmp9_ = top;
	_tmp10_ = (*_tmp9_).row;
	_tmp11_ = top;
	_tmp12_ = (*_tmp11_).col;
	_tmp13_ = sudoku_board_get (_tmp8_, _tmp10_, _tmp12_);
	old_val = _tmp13_;
	_tmp14_ = to;
	_tmp15_ = top;
	_tmp16_ = (*_tmp15_).row;
	_tmp17_ = top;
	_tmp18_ = (*_tmp17_).col;
	_tmp19_ = old_val;
	sudoku_game_add_to_stack (self, _tmp14_, _tmp16_, _tmp18_, _tmp19_);
	_tmp20_ = self->mode;
	if (_tmp20_ == GAME_MODE_CREATE) {
		SudokuBoard* _tmp21_;
		SudokuGameUndoItem* _tmp22_;
		gint _tmp23_;
		SudokuGameUndoItem* _tmp24_;
		gint _tmp25_;
		SudokuBoard* _tmp26_;
		gboolean* _tmp27_;
		gint _tmp27__length1;
		gint _tmp27__length2;
		SudokuGameUndoItem* _tmp28_;
		gint _tmp29_;
		SudokuGameUndoItem* _tmp30_;
		gint _tmp31_;
		gboolean _tmp32_;
		SudokuBoard* _tmp33_;
		gboolean* _tmp34_;
		gint _tmp34__length1;
		gint _tmp34__length2;
		SudokuGameUndoItem* _tmp35_;
		gint _tmp36_;
		SudokuGameUndoItem* _tmp37_;
		gint _tmp38_;
		gboolean _tmp39_;
		_tmp21_ = self->board;
		_tmp22_ = top;
		_tmp23_ = (*_tmp22_).row;
		_tmp24_ = top;
		_tmp25_ = (*_tmp24_).col;
		_tmp26_ = self->board;
		_tmp27_ = _tmp26_->is_fixed;
		_tmp27__length1 = _tmp26_->is_fixed_length1;
		_tmp27__length2 = _tmp26_->is_fixed_length2;
		_tmp28_ = top;
		_tmp29_ = (*_tmp28_).row;
		_tmp30_ = top;
		_tmp31_ = (*_tmp30_).col;
		_tmp32_ = _tmp27_[(_tmp29_ * _tmp27__length2) + _tmp31_];
		sudoku_board_remove (_tmp21_, _tmp23_, _tmp25_, _tmp32_);
		_tmp33_ = self->board;
		_tmp34_ = _tmp33_->is_fixed;
		_tmp34__length1 = _tmp33_->is_fixed_length1;
		_tmp34__length2 = _tmp33_->is_fixed_length2;
		_tmp35_ = top;
		_tmp36_ = (*_tmp35_).row;
		_tmp37_ = top;
		_tmp38_ = (*_tmp37_).col;
		_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_] = FALSE;
		_tmp39_ = _tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_];
	} else {
		SudokuBoard* _tmp40_;
		SudokuGameUndoItem* _tmp41_;
		gint _tmp42_;
		SudokuGameUndoItem* _tmp43_;
		gint _tmp44_;
		_tmp40_ = self->board;
		_tmp41_ = top;
		_tmp42_ = (*_tmp41_).row;
		_tmp43_ = top;
		_tmp44_ = (*_tmp43_).col;
		sudoku_board_remove (_tmp40_, _tmp42_, _tmp44_, FALSE);
	}
	_tmp45_ = top;
	_tmp46_ = (*_tmp45_).val;
	if (_tmp46_ != 0) {
		GameMode _tmp47_;
		_tmp47_ = self->mode;
		if (_tmp47_ == GAME_MODE_CREATE) {
			SudokuBoard* _tmp48_;
			SudokuGameUndoItem* _tmp49_;
			gint _tmp50_;
			SudokuGameUndoItem* _tmp51_;
			gint _tmp52_;
			SudokuGameUndoItem* _tmp53_;
			gint _tmp54_;
			SudokuBoard* _tmp55_;
			gboolean* _tmp56_;
			gint _tmp56__length1;
			gint _tmp56__length2;
			SudokuGameUndoItem* _tmp57_;
			gint _tmp58_;
			SudokuGameUndoItem* _tmp59_;
			gint _tmp60_;
			gboolean _tmp61_;
			SudokuBoard* _tmp62_;
			gboolean* _tmp63_;
			gint _tmp63__length1;
			gint _tmp63__length2;
			SudokuGameUndoItem* _tmp64_;
			gint _tmp65_;
			SudokuGameUndoItem* _tmp66_;
			gint _tmp67_;
			gboolean _tmp68_;
			_tmp48_ = self->board;
			_tmp49_ = top;
			_tmp50_ = (*_tmp49_).row;
			_tmp51_ = top;
			_tmp52_ = (*_tmp51_).col;
			_tmp53_ = top;
			_tmp54_ = (*_tmp53_).val;
			_tmp55_ = self->board;
			_tmp56_ = _tmp55_->is_fixed;
			_tmp56__length1 = _tmp55_->is_fixed_length1;
			_tmp56__length2 = _tmp55_->is_fixed_length2;
			_tmp57_ = top;
			_tmp58_ = (*_tmp57_).row;
			_tmp59_ = top;
			_tmp60_ = (*_tmp59_).col;
			_tmp61_ = _tmp56_[(_tmp58_ * _tmp56__length2) + _tmp60_];
			sudoku_board_insert (_tmp48_, _tmp50_, _tmp52_, _tmp54_, _tmp61_);
			_tmp62_ = self->board;
			_tmp63_ = _tmp62_->is_fixed;
			_tmp63__length1 = _tmp62_->is_fixed_length1;
			_tmp63__length2 = _tmp62_->is_fixed_length2;
			_tmp64_ = top;
			_tmp65_ = (*_tmp64_).row;
			_tmp66_ = top;
			_tmp67_ = (*_tmp66_).col;
			_tmp63_[(_tmp65_ * _tmp63__length2) + _tmp67_] = TRUE;
			_tmp68_ = _tmp63_[(_tmp65_ * _tmp63__length2) + _tmp67_];
		} else {
			SudokuBoard* _tmp69_;
			SudokuGameUndoItem* _tmp70_;
			gint _tmp71_;
			SudokuGameUndoItem* _tmp72_;
			gint _tmp73_;
			SudokuGameUndoItem* _tmp74_;
			gint _tmp75_;
			_tmp69_ = self->board;
			_tmp70_ = top;
			_tmp71_ = (*_tmp70_).row;
			_tmp72_ = top;
			_tmp73_ = (*_tmp72_).col;
			_tmp74_ = top;
			_tmp75_ = (*_tmp74_).val;
			sudoku_board_insert (_tmp69_, _tmp71_, _tmp73_, _tmp75_, FALSE);
		}
	}
	_tmp76_ = top;
	_tmp77_ = (*_tmp76_).row;
	_tmp78_ = top;
	_tmp79_ = (*_tmp78_).col;
	_tmp80_ = old_val;
	_tmp81_ = top;
	_tmp82_ = (*_tmp81_).val;
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_CELL_CHANGED_SIGNAL], 0, _tmp77_, _tmp79_, _tmp80_, _tmp82_);
	_sudoku_game_undo_item_free0 (top);
}


gdouble sudoku_game_get_total_time_played (SudokuGame* self) {
	gdouble result = 0.0;
	SudokuBoard* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GTimer* _tmp3_;
	gdouble _tmp4_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->board;
	_tmp1_ = sudoku_board_get_previous_played_time (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->timer;
	_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
	result = _tmp2_ + _tmp4_;
	return result;
}


static gboolean _sudoku_game_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_game_timeout_cb ((SudokuGame*) self);
	return result;
}


static gboolean sudoku_game_timeout_cb (SudokuGame* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _sudoku_game_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->clock_timeout = _tmp0_;
	_tmp1_ = self->priv->clock_timeout;
	g_source_set_name_by_id (_tmp1_, "[gnome-sudoku] timeout_cb");
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_TICK_SIGNAL], 0);
	result = FALSE;
	return result;
}


void sudoku_game_start_clock (SudokuGame* self) {
	GTimer* _tmp0_;
	GTimer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->timer;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->timer);
		self->timer = _tmp1_;
	}
	_tmp2_ = self->timer;
	g_timer_start (_tmp2_);
	sudoku_game_timeout_cb (self);
}


void sudoku_game_stop_clock (SudokuGame* self) {
	GTimer* _tmp0_;
	guint _tmp1_;
	GTimer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->timer;
	_vala_return_if_fail (_tmp0_ != NULL, "timer != null");
	_tmp1_ = self->priv->clock_timeout;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->clock_timeout;
		g_source_remove (_tmp2_);
	}
	self->priv->clock_timeout = (guint) 0;
	sudoku_game_set_paused (self, TRUE);
	_tmp3_ = self->timer;
	g_timer_stop (_tmp3_);
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_TICK_SIGNAL], 0);
}


void sudoku_game_resume_clock (SudokuGame* self) {
	GTimer* _tmp0_;
	guint _tmp1_;
	GTimer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->timer;
	_tmp1_ = self->priv->clock_timeout;
	_vala_return_if_fail ((_tmp0_ != NULL) && (_tmp1_ == ((guint) 0)), "timer != null && clock_timeout == 0");
	_tmp2_ = self->timer;
	g_timer_continue (_tmp2_);
	sudoku_game_set_paused (self, FALSE);
	sudoku_game_timeout_cb (self);
}


gboolean sudoku_game_get_paused (SudokuGame* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


static void sudoku_game_set_paused (SudokuGame* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paused = _tmp0_;
	g_signal_emit (self, sudoku_game_signals[SUDOKU_GAME_PAUSED_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, sudoku_game_properties[SUDOKU_GAME_PAUSED]);
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self) {
	SudokuGameUndoItem* dup;
	dup = g_new0 (SudokuGameUndoItem, 1);
	memcpy (dup, self, sizeof (SudokuGameUndoItem));
	return dup;
}


static void sudoku_game_undo_item_free (SudokuGameUndoItem* self) {
	g_free (self);
}


static GType sudoku_game_undo_item_get_type (void) {
	static volatile gsize sudoku_game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_undo_item_type_id__volatile)) {
		GType sudoku_game_undo_item_type_id;
		sudoku_game_undo_item_type_id = g_boxed_type_register_static ("SudokuGameUndoItem", (GBoxedCopyFunc) sudoku_game_undo_item_dup, (GBoxedFreeFunc) sudoku_game_undo_item_free);
		g_once_init_leave (&sudoku_game_undo_item_type_id__volatile, sudoku_game_undo_item_type_id);
	}
	return sudoku_game_undo_item_type_id__volatile;
}


static void sudoku_game_class_init (SudokuGameClass * klass) {
	sudoku_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuGamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_GAME_PAUSED, sudoku_game_properties[SUDOKU_GAME_PAUSED] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	sudoku_game_signals[SUDOKU_GAME_TICK_SIGNAL] = g_signal_new ("tick", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sudoku_game_signals[SUDOKU_GAME_PAUSED_CHANGED_SIGNAL] = g_signal_new ("paused-changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sudoku_game_signals[SUDOKU_GAME_CELL_CHANGED_SIGNAL] = g_signal_new ("cell-changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
}


static void sudoku_game_instance_init (SudokuGame * self) {
	self->priv = SUDOKU_GAME_GET_PRIVATE (self);
	self->priv->_paused = FALSE;
}


static void sudoku_game_finalize (GObject * obj) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GAME, SudokuGame);
	_g_object_unref0 (self->board);
	_g_timer_destroy0 (self->timer);
	_g_object_unref0 (self->priv->undostack);
	_g_object_unref0 (self->priv->redostack);
	G_OBJECT_CLASS (sudoku_game_parent_class)->finalize (obj);
}


GType sudoku_game_get_type (void) {
	static volatile gsize sudoku_game_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGame), 0, (GInstanceInitFunc) sudoku_game_instance_init, NULL };
		GType sudoku_game_type_id;
		sudoku_game_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGame", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_game_type_id__volatile, sudoku_game_type_id);
	}
	return sudoku_game_type_id__volatile;
}


static void _vala_sudoku_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_GAME, SudokuGame);
	switch (property_id) {
		case SUDOKU_GAME_PAUSED:
		g_value_set_boolean (value, sudoku_game_get_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_GAME, SudokuGame);
	switch (property_id) {
		case SUDOKU_GAME_PAUSED:
		sudoku_game_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType game_mode_get_type (void) {
	static volatile gsize game_mode_type_id__volatile = 0;
	if (g_once_init_enter (&game_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_MODE_PLAY, "GAME_MODE_PLAY", "play"}, {GAME_MODE_CREATE, "GAME_MODE_CREATE", "create"}, {0, NULL, NULL}};
		GType game_mode_type_id;
		game_mode_type_id = g_enum_register_static ("GameMode", values);
		g_once_init_leave (&game_mode_type_id__volatile, game_mode_type_id);
	}
	return game_mode_type_id__volatile;
}



