/* gnome-mines.c generated by valac 0.36.4, the Vala compiler
 * generated from gnome-mines.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgnome-games-support.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_MINES (mines_get_type ())
#define MINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINES, Mines))
#define MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINES, MinesClass))
#define IS_MINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINES))
#define IS_MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINES))
#define MINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINES, MinesClass))

typedef struct _Mines Mines;
typedef struct _MinesClass MinesClass;
typedef struct _MinesPrivate MinesPrivate;

#define TYPE_THEME_SELECTOR_DIALOG (theme_selector_dialog_get_type ())
#define THEME_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialog))
#define THEME_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialogClass))
#define IS_THEME_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SELECTOR_DIALOG))
#define IS_THEME_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SELECTOR_DIALOG))
#define THEME_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialogClass))

typedef struct _ThemeSelectorDialog ThemeSelectorDialog;
typedef struct _ThemeSelectorDialogClass ThemeSelectorDialogClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef struct _Block1Data Block1Data;

struct _Mines {
	GtkApplication parent_instance;
	MinesPrivate * priv;
};

struct _MinesClass {
	GtkApplicationClass parent_class;
};

struct _MinesPrivate {
	GSettings* settings;
	GtkWidget* main_screen;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkButton* replay_button;
	GtkButton* high_scores_button;
	GtkButton* new_game_button;
	GtkAspectFrame* minefield_aspect;
	GtkOverlay* minefield_overlay;
	GtkBox* aspect_child;
	GtkBox* buttons_box;
	GtkBox* paused_box;
	GtkScrolledWindow* scrolled;
	GtkStack* stack;
	ThemeSelectorDialog* theme_dialog;
	GtkLabel* clock_label;
	GMenu* app_main_menu;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean is_tiled;
	gboolean pause_requested;
	gboolean window_skip_configure;
	GamesScoresContext* context;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkLabel* flag_label;
	GtkSpinButton* mines_spin;
	GSimpleAction* new_game_action;
	GSimpleAction* repeat_size_action;
	GSimpleAction* pause_action;
	GSimpleAction** size_actions;
	gint size_actions_length1;
	gint _size_actions_size_;
	GtkAspectFrame* new_game_screen;
	GtkAspectFrame* custom_game_screen;
	GtkCssProvider* theme_provider;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean exploded;
	gboolean placed_mines;
	gboolean _use_autoflag;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	Mines* self;
	gint x;
	gint y;
	guint width;
};


static gpointer mines_parent_class = NULL;
static gint mines_game_mode;
static gint mines_game_mode = -1;

GType mines_get_type (void) G_GNUC_CONST;
GType theme_selector_dialog_get_type (void) G_GNUC_CONST;
GType minefield_get_type (void) G_GNUC_CONST;
GType minefield_view_get_type (void) G_GNUC_CONST;
#define MINES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINES, MinesPrivate))
enum  {
	MINES_DUMMY_PROPERTY
};
#define MINES_KEY_XSIZE "xsize"
#define MINES_XSIZE_MIN 4
#define MINES_XSIZE_MAX 100
#define MINES_KEY_YSIZE "ysize"
#define MINES_YSIZE_MIN 4
#define MINES_YSIZE_MAX 100
#define MINES_KEY_NMINES "nmines"
#define MINES_KEY_MODE "mode"
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
#define MINES_KEY_THEME "theme"
#define MINES_KEY_USE_ANIMATIONS "use-animations"
static void mines_new_game_cb (Mines* self);
static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_silent_new_game_cb (Mines* self);
static void _mines_silent_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_repeat_size_cb (Mines* self);
static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_small_size_clicked_cb (Mines* self);
static void _mines_small_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_medium_size_clicked_cb (Mines* self);
static void _mines_medium_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_large_size_clicked_cb (Mines* self);
static void _mines_large_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_show_custom_game_screen (Mines* self);
static void _mines_show_custom_game_screen_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_toggle_pause_cb (Mines* self);
static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_scores_cb (Mines* self);
static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_preferences_cb (Mines* self);
static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_quit_cb (Mines* self);
static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_help_cb (Mines* self);
static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_about_cb (Mines* self);
static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mines* mines_new (void);
Mines* mines_construct (GType object_type);
static void mines_set_game_theme (Mines* self, const gchar* theme);
void minefield_view_refresh (MinefieldView* self);
static void mines_real_startup (GApplication* base);
static void __lambda20_ (Mines* self);
static void ___lambda20__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void mines_size_allocate_cb (Mines* self, GtkAllocation* allocation);
static void _mines_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event);
static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
MinefieldView* minefield_view_new (GSettings* settings);
MinefieldView* minefield_view_construct (GType object_type, GSettings* settings);
static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder);
static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder);
static GamesScoresCategory* mines_create_category_from_key (Mines* self, const gchar* key);
static GamesScoresCategory* _mines_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
static void mines_parse_old_score (Mines* self, const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category);
static void _mines_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category, gpointer self);
static void mines_start_game (Mines* self);
static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines);
static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_set_mines_limit (Mines* self);
static void mines_show_new_game_screen (Mines* self);
static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_custom_size_clicked_cb (Mines* self);
static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean minefield_is_clock_started (Minefield* self);
void minefield_set_paused (Minefield* self, gboolean value);
void mines_start (Mines* self);
static void mines_real_shutdown (GApplication* base);
static gint mines_real_handle_local_options (GApplication* base, GVariantDict* options);
static void mines_real_activate (GApplication* base);
gboolean minefield_get_paused (Minefield* self);
static void mines_update_flag_label (Mines* self);
guint minefield_get_n_flags (Minefield* self);
GType location_get_type (void) G_GNUC_CONST;
static gint mines_show_theme_selector (Mines* self);
ThemeSelectorDialog* theme_selector_dialog_new (GtkWindow* parent);
ThemeSelectorDialog* theme_selector_dialog_construct (GType object_type, GtkWindow* parent);
static void mines_show_scores (Mines* self);
static void mines_size_actions_toggle (Mines* self, gboolean enabled);
static gboolean mines_can_start_new_game (Mines* self);
guint minefield_get_n_cleared (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
static void mines_marks_changed_cb (Mines* self, Minefield* minefield);
static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self);
static void mines_explode_cb (Mines* self, Minefield* minefield);
static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void mines_cleared_cb (Mines* self, Minefield* minefield);
static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self);
static void mines_tick_cb (Mines* self);
static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self);
static void mines_paused_changed_cb (Mines* self);
static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self);
static void mines_clock_started_cb (Mines* self);
static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
guint minefield_view_get_mine_size (MinefieldView* self);
static void __lambda19_ (Block1Data* _data1_, GtkAllocation* allocation);
static void ___lambda19__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
gdouble minefield_get_elapsed (Minefield* self);
static void mines_game_ended (Mines* self);
static void __lambda18_ (Mines* self, GObject* object, GAsyncResult* _result_);
static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gfloat mines_percent_mines (Mines* self);
static void mines_set_mode (Mines* self, gint mode);
gint mines_main (gchar** args, int args_length1);
static void mines_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry MINES_option_entries[5] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {"small", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Small game"), NULL}, {"medium", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Medium game"), NULL}, {"big", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Big game"), NULL}, {NULL}};
static const GActionEntry MINES_action_entries[13] = {{"new-game", _mines_new_game_cb_gsimple_action_activate_callback}, {"silent-new-game", _mines_silent_new_game_cb_gsimple_action_activate_callback}, {"repeat-size", _mines_repeat_size_cb_gsimple_action_activate_callback}, {"small-size", _mines_small_size_clicked_cb_gsimple_action_activate_callback}, {"medium-size", _mines_medium_size_clicked_cb_gsimple_action_activate_callback}, {"large-size", _mines_large_size_clicked_cb_gsimple_action_activate_callback}, {"custom-size", _mines_show_custom_game_screen_gsimple_action_activate_callback}, {"pause", _mines_toggle_pause_cb_gsimple_action_activate_callback}, {"scores", _mines_scores_cb_gsimple_action_activate_callback}, {"preferences", _mines_preferences_cb_gsimple_action_activate_callback}, {"quit", _mines_quit_cb_gsimple_action_activate_callback}, {"help", _mines_help_cb_gsimple_action_activate_callback}, {"about", _mines_about_cb_gsimple_action_activate_callback}};

static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_new_game_cb ((Mines*) self);
}


static void _mines_silent_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_silent_new_game_cb ((Mines*) self);
}


static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_repeat_size_cb ((Mines*) self);
}


static void _mines_small_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_small_size_clicked_cb ((Mines*) self);
}


static void _mines_medium_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_medium_size_clicked_cb ((Mines*) self);
}


static void _mines_large_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_large_size_clicked_cb ((Mines*) self);
}


static void _mines_show_custom_game_screen_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_show_custom_game_screen ((Mines*) self);
}


static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_toggle_pause_cb ((Mines*) self);
}


static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_scores_cb ((Mines*) self);
}


static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_preferences_cb ((Mines*) self);
}


static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_quit_cb ((Mines*) self);
}


static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_help_cb ((Mines*) self);
}


static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_about_cb ((Mines*) self);
}


Mines* mines_construct (GType object_type) {
	Mines * self = NULL;
	self = (Mines*) g_object_new (object_type, "application-id", "org.gnome.mines", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, MINES_option_entries);
	return self;
}


Mines* mines_new (void) {
	return mines_construct (TYPE_MINES);
}


static void mines_set_game_theme (Mines* self, const gchar* theme) {
	gchar* theme_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean is_switch = FALSE;
	GtkCssProvider* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	gchar* theme_css_path = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GtkWindow* _tmp33_;
	GdkScreen* _tmp37_;
	ThemeSelectorDialog* _tmp38_;
	MinefieldView* _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = theme;
	_tmp1_ = g_strdup (_tmp0_);
	theme_path = _tmp1_;
	_tmp2_ = self->priv->theme_provider;
	is_switch = _tmp2_ != NULL;
	_tmp3_ = theme_path;
	_tmp4_ = g_path_is_absolute (_tmp3_);
	if (!_tmp4_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = theme;
		_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, DATA_DIRECTORY, "themes", _tmp5_, NULL);
		_g_free0 (theme_path);
		theme_path = _tmp6_;
	}
	_tmp7_ = is_switch;
	if (!_tmp7_) {
		GtkIconTheme* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = gtk_icon_theme_get_default ();
		_tmp9_ = theme_path;
		gtk_icon_theme_append_search_path (_tmp8_, _tmp9_);
	} else {
		gchar** icon_search_path = NULL;
		gint icon_search_path_length1 = 0;
		gint _icon_search_path_size_ = 0;
		GtkIconTheme* _tmp10_;
		gchar** _tmp11_ = NULL;
		gint _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GtkIconTheme* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp10_ = gtk_icon_theme_get_default ();
		gtk_icon_theme_get_search_path (_tmp10_, &_tmp11_, &_tmp12_);
		icon_search_path = (_vala_array_free (icon_search_path, icon_search_path_length1, (GDestroyNotify) g_free), NULL);
		icon_search_path = _tmp11_;
		icon_search_path_length1 = _tmp12_;
		_icon_search_path_size_ = icon_search_path_length1;
		_tmp13_ = icon_search_path;
		_tmp13__length1 = icon_search_path_length1;
		_tmp14_ = icon_search_path;
		_tmp14__length1 = icon_search_path_length1;
		_tmp15_ = theme_path;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_tmp13_[_tmp14__length1 - 1]);
		_tmp13_[_tmp14__length1 - 1] = _tmp16_;
		_tmp17_ = _tmp13_[_tmp14__length1 - 1];
		_tmp18_ = gtk_icon_theme_get_default ();
		_tmp19_ = icon_search_path;
		_tmp19__length1 = icon_search_path_length1;
		gtk_icon_theme_set_search_path (_tmp18_, _tmp19_, _tmp19__length1);
		icon_search_path = (_vala_array_free (icon_search_path, icon_search_path_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp20_ = theme_path;
	_tmp21_ = g_build_filename (_tmp20_, "theme.css", NULL);
	theme_css_path = _tmp21_;
	{
		gboolean _tmp22_;
		GtkCssProvider* _tmp25_;
		GtkCssProvider* _tmp26_;
		const gchar* _tmp27_;
		GdkScreen* _tmp28_;
		GtkCssProvider* _tmp29_;
		_tmp22_ = is_switch;
		if (_tmp22_) {
			GdkScreen* _tmp23_;
			GtkCssProvider* _tmp24_;
			_tmp23_ = gdk_screen_get_default ();
			_tmp24_ = self->priv->theme_provider;
			gtk_style_context_remove_provider_for_screen (_tmp23_, (GtkStyleProvider*) _tmp24_);
		}
		_tmp25_ = gtk_css_provider_new ();
		_g_object_unref0 (self->priv->theme_provider);
		self->priv->theme_provider = _tmp25_;
		_tmp26_ = self->priv->theme_provider;
		_tmp27_ = theme_css_path;
		gtk_css_provider_load_from_path (_tmp26_, _tmp27_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp28_ = gdk_screen_get_default ();
		_tmp29_ = self->priv->theme_provider;
		gtk_style_context_add_provider_for_screen (_tmp28_, (GtkStyleProvider*) _tmp29_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = theme_css_path;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("gnome-mines.vala:149: Error loading css styles from %s: %s", _tmp30_, _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (theme_css_path);
		_g_free0 (theme_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp33_ = self->priv->window;
	if (_tmp33_ != NULL) {
		GtkWindow* _tmp34_;
		GdkWindow* _tmp35_;
		GtkWindow* _tmp36_;
		_tmp34_ = self->priv->window;
		_tmp35_ = gtk_widget_get_window ((GtkWidget*) _tmp34_);
		gdk_window_invalidate_rect (_tmp35_, NULL, TRUE);
		_tmp36_ = self->priv->window;
		gtk_widget_queue_draw ((GtkWidget*) _tmp36_);
	}
	_tmp37_ = gdk_screen_get_default ();
	gtk_style_context_reset_widgets (_tmp37_);
	_tmp38_ = self->priv->theme_dialog;
	if (_tmp38_ != NULL) {
		ThemeSelectorDialog* _tmp39_;
		_tmp39_ = self->priv->theme_dialog;
		gtk_widget_queue_draw ((GtkWidget*) _tmp39_);
	}
	_tmp40_ = self->priv->minefield_view;
	if (_tmp40_ != NULL) {
		MinefieldView* _tmp41_;
		_tmp41_ = self->priv->minefield_view;
		minefield_view_refresh (_tmp41_);
	}
	_g_free0 (theme_css_path);
	_g_free0 (theme_path);
}


static void __lambda20_ (Mines* self) {
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, MINES_KEY_THEME);
	_tmp2_ = _tmp1_;
	mines_set_game_theme (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void ___lambda20__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda20_ ((Mines*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _mines_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	mines_size_allocate_cb ((Mines*) self, allocation);
}


static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mines_window_state_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_out_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_in_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mines_view_button_press_event ((Mines*) self, _sender, event);
	return result;
}


static GamesScoresCategory* _mines_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = mines_create_category_from_key ((Mines*) self, category_key);
	return result;
}


static void _mines_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category, gpointer self) {
	mines_parse_old_score ((Mines*) self, line, score, category);
}


static void mines_real_startup (GApplication* base) {
	Mines * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gint _tmp2_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp5_;
	GdkScreen* _tmp6_;
	GtkBuilder* ui_builder = NULL;
	GtkBuilder* _tmp7_;
	GSettings* _tmp10_;
	gchar* _tmp11_;
	GSettings* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GAction* _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GAction* _tmp21_;
	GSimpleAction* _tmp22_;
	GSimpleAction* _tmp23_;
	GSimpleAction** _tmp24_;
	gint _tmp24__length1;
	GAction* _tmp25_;
	GSimpleAction* _tmp26_;
	GSimpleAction* _tmp27_;
	GSimpleAction** _tmp28_;
	gint _tmp28__length1;
	GAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GSimpleAction* _tmp31_;
	GSimpleAction** _tmp32_;
	gint _tmp32__length1;
	GAction* _tmp33_;
	GSimpleAction* _tmp34_;
	GSimpleAction* _tmp35_;
	GSimpleAction** _tmp36_;
	gint _tmp36__length1;
	GAction* _tmp37_;
	GSimpleAction* _tmp38_;
	GSimpleAction* _tmp39_;
	GSettings* _tmp40_;
	GAction* _tmp41_;
	GAction* _tmp42_;
	GSettings* _tmp43_;
	GAction* _tmp44_;
	GAction* _tmp45_;
	GObject* _tmp46_;
	GtkWindow* _tmp47_;
	GtkWindow* _tmp48_;
	GtkWindow* _tmp49_;
	GtkWindow* _tmp50_;
	GtkWindow* _tmp51_;
	GtkWindow* _tmp52_;
	GSettings* _tmp53_;
	gint _tmp54_;
	GSettings* _tmp55_;
	gint _tmp56_;
	GtkSettings* _tmp57_;
	GSettings* _tmp58_;
	gboolean _tmp59_;
	GSettings* _tmp60_;
	gboolean _tmp61_;
	GtkWindow* _tmp63_;
	gchar* desktop = NULL;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp75_;
	gboolean _tmp76_;
	gchar* _tmp119_;
	gchar** _tmp120_;
	gchar** _tmp121_;
	gint _tmp121__length1;
	gchar* _tmp122_;
	gchar** _tmp123_;
	gchar** _tmp124_;
	gint _tmp124__length1;
	gchar* _tmp125_;
	gchar** _tmp126_;
	gchar** _tmp127_;
	gint _tmp127__length1;
	gchar* _tmp128_;
	gchar** _tmp129_;
	gchar** _tmp130_;
	gint _tmp130__length1;
	gchar* _tmp131_;
	gchar** _tmp132_;
	gchar** _tmp133_;
	gint _tmp133__length1;
	gchar* _tmp134_;
	gchar** _tmp135_;
	gchar** _tmp136_;
	gint _tmp136__length1;
	gchar* _tmp137_;
	gchar** _tmp138_;
	gchar** _tmp139_;
	gint _tmp139__length1;
	gchar* _tmp140_;
	gchar** _tmp141_;
	gchar** _tmp142_;
	gint _tmp142__length1;
	gchar* _tmp143_;
	gchar** _tmp144_;
	gchar** _tmp145_;
	gint _tmp145__length1;
	gchar* _tmp146_;
	gchar* _tmp147_;
	gchar** _tmp148_;
	gchar** _tmp149_;
	gint _tmp149__length1;
	GSettings* _tmp150_;
	MinefieldView* _tmp151_;
	MinefieldView* _tmp152_;
	GObject* _tmp153_;
	GtkStack* _tmp154_;
	GObject* _tmp155_;
	GtkScrolledWindow* _tmp156_;
	GtkScrolledWindow* _tmp157_;
	MinefieldView* _tmp158_;
	GtkScrolledWindow* _tmp159_;
	GObject* _tmp160_;
	GtkOverlay* _tmp161_;
	GtkOverlay* _tmp162_;
	GObject* _tmp163_;
	GtkAspectFrame* _tmp164_;
	GtkAspectFrame* _tmp165_;
	GObject* _tmp166_;
	GtkBox* _tmp167_;
	GObject* _tmp168_;
	GtkBox* _tmp169_;
	GObject* _tmp170_;
	GtkBox* _tmp171_;
	GObject* _tmp172_;
	GtkBox* _tmp173_;
	GtkBox* _tmp174_;
	GtkOverlay* _tmp175_;
	GtkBox* _tmp176_;
	GObject* _tmp177_;
	GtkWidget* _tmp178_;
	GtkWidget* _tmp179_;
	GtkWindow* _tmp180_;
	GamesScoresHistoryFileImporter* _tmp181_;
	GamesScoresHistoryFileImporter* _tmp182_;
	GamesScoresContext* _tmp183_;
	GObject* _tmp184_;
	GtkLabel* _tmp185_;
	GObject* _tmp186_;
	GtkLabel* _tmp187_;
	GObject* _tmp188_;
	GtkButton* _tmp189_;
	GObject* _tmp190_;
	GtkLabel* _tmp191_;
	GObject* _tmp192_;
	GtkButton* _tmp193_;
	GObject* _tmp194_;
	GtkButton* _tmp195_;
	GObject* _tmp196_;
	GtkButton* _tmp197_;
	gint _tmp198_;
	GError * _inner_error_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_set_application_name (_ ("Mines"));
	_tmp0_ = g_settings_new ("org.gnome.mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = mines_game_mode;
	if (_tmp2_ != -1) {
		GSettings* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->settings;
		_tmp4_ = mines_game_mode;
		g_settings_set_int (_tmp3_, MINES_KEY_MODE, _tmp4_);
	}
	gtk_window_set_default_icon_name ("gnome-mines");
	_tmp5_ = gtk_css_provider_new ();
	css_provider = _tmp5_;
	gtk_css_provider_load_from_resource (css_provider, "/org/gnome/Mines/gnome-mines.css");
	_tmp6_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp6_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp7_ = gtk_builder_new ();
	ui_builder = _tmp7_;
	{
		gtk_builder_add_from_resource (ui_builder, "/org/gnome/Mines/interface.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("gnome-mines.vala:189: Could not load game UI: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (ui_builder);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_strconcat ("changed::", MINES_KEY_THEME, NULL);
	g_signal_connect_object (_tmp10_, _tmp11_, (GCallback) ___lambda20__g_settings_changed, self, 0);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = g_settings_get_string (_tmp12_, MINES_KEY_THEME);
	_tmp14_ = _tmp13_;
	mines_set_game_theme (self, _tmp14_);
	_g_free0 (_tmp14_);
	g_action_map_add_action_entries ((GActionMap*) self, MINES_action_entries, G_N_ELEMENTS (MINES_action_entries), self);
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp16_;
	_tmp17_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp17_, TRUE);
	_tmp18_ = g_action_map_lookup_action ((GActionMap*) self, "repeat-size");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->repeat_size_action);
	self->priv->repeat_size_action = _tmp19_;
	_tmp20_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp20_, FALSE);
	_tmp21_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp22_;
	_tmp23_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp23_, FALSE);
	_tmp24_ = self->priv->size_actions;
	_tmp24__length1 = self->priv->size_actions_length1;
	_tmp25_ = g_action_map_lookup_action ((GActionMap*) self, "small-size");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp25_) : NULL);
	_g_object_unref0 (_tmp24_[0]);
	_tmp24_[0] = _tmp26_;
	_tmp27_ = _tmp24_[0];
	_tmp28_ = self->priv->size_actions;
	_tmp28__length1 = self->priv->size_actions_length1;
	_tmp29_ = g_action_map_lookup_action ((GActionMap*) self, "medium-size");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp29_) : NULL);
	_g_object_unref0 (_tmp28_[1]);
	_tmp28_[1] = _tmp30_;
	_tmp31_ = _tmp28_[1];
	_tmp32_ = self->priv->size_actions;
	_tmp32__length1 = self->priv->size_actions_length1;
	_tmp33_ = g_action_map_lookup_action ((GActionMap*) self, "large-size");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp33_) : NULL);
	_g_object_unref0 (_tmp32_[2]);
	_tmp32_[2] = _tmp34_;
	_tmp35_ = _tmp32_[2];
	_tmp36_ = self->priv->size_actions;
	_tmp36__length1 = self->priv->size_actions_length1;
	_tmp37_ = g_action_map_lookup_action ((GActionMap*) self, "custom-size");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp37_) : NULL);
	_g_object_unref0 (_tmp36_[3]);
	_tmp36_[3] = _tmp38_;
	_tmp39_ = _tmp36_[3];
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_create_action (_tmp40_, MINES_KEY_USE_OVERMINE_WARNING);
	_tmp42_ = _tmp41_;
	g_action_map_add_action ((GActionMap*) self, _tmp42_);
	_g_object_unref0 (_tmp42_);
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_create_action (_tmp43_, MINES_KEY_USE_QUESTION_MARKS);
	_tmp45_ = _tmp44_;
	g_action_map_add_action ((GActionMap*) self, _tmp45_);
	_g_object_unref0 (_tmp45_);
	_tmp46_ = gtk_builder_get_object (ui_builder, "main_window");
	_tmp47_ = _g_object_ref0 ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp47_;
	_tmp48_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp48_, "size-allocate", (GCallback) _mines_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp49_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp49_, "window-state-event", (GCallback) _mines_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp50_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "focus-out-event", (GCallback) _mines_window_focus_out_event_cb_gtk_widget_focus_out_event, self, 0);
	_tmp51_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp51_, "focus-in-event", (GCallback) _mines_window_focus_in_event_cb_gtk_widget_focus_in_event, self, 0);
	_tmp52_ = self->priv->window;
	_tmp53_ = self->priv->settings;
	_tmp54_ = g_settings_get_int (_tmp53_, "window-width");
	_tmp55_ = self->priv->settings;
	_tmp56_ = g_settings_get_int (_tmp55_, "window-height");
	gtk_window_set_default_size (_tmp52_, _tmp54_, _tmp56_);
	_tmp57_ = gtk_settings_get_default ();
	_tmp58_ = self->priv->settings;
	_tmp59_ = g_settings_get_boolean (_tmp58_, "use-animations");
	g_object_set (_tmp57_, "gtk-enable-animations", _tmp59_, NULL);
	_tmp60_ = self->priv->settings;
	_tmp61_ = g_settings_get_boolean (_tmp60_, "window-is-maximized");
	if (_tmp61_) {
		GtkWindow* _tmp62_;
		_tmp62_ = self->priv->window;
		gtk_window_maximize (_tmp62_);
	}
	_tmp63_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp63_);
	_tmp64_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp65_ = g_strdup (_tmp64_);
	desktop = _tmp65_;
	_tmp67_ = desktop;
	if (_tmp67_ == NULL) {
		_tmp66_ = TRUE;
	} else {
		const gchar* _tmp68_;
		_tmp68_ = desktop;
		_tmp66_ = g_strcmp0 (_tmp68_, "Unity") != 0;
	}
	if (_tmp66_) {
		GtkHeaderBar* headerbar = NULL;
		GtkHeaderBar* _tmp69_;
		GtkHeaderBar* _tmp70_;
		GtkHeaderBar* _tmp71_;
		GtkHeaderBar* _tmp72_;
		GtkWindow* _tmp73_;
		GtkHeaderBar* _tmp74_;
		_tmp69_ = (GtkHeaderBar*) gtk_header_bar_new ();
		g_object_ref_sink (_tmp69_);
		headerbar = _tmp69_;
		_tmp70_ = headerbar;
		gtk_header_bar_set_show_close_button (_tmp70_, TRUE);
		_tmp71_ = headerbar;
		gtk_header_bar_set_title (_tmp71_, _ ("Mines"));
		_tmp72_ = headerbar;
		gtk_widget_show ((GtkWidget*) _tmp72_);
		_tmp73_ = self->priv->window;
		_tmp74_ = headerbar;
		gtk_window_set_titlebar (_tmp73_, (GtkWidget*) _tmp74_);
		_g_object_unref0 (headerbar);
	}
	_tmp75_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp75_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
	_tmp76_ = shell_shows_menubar;
	if (!_tmp76_) {
		GMenu* menu = NULL;
		GMenu* _tmp77_;
		GMenu* _tmp78_;
		GMenu* _tmp79_;
		GMenu* _tmp80_;
		GMenu* _tmp81_;
		GMenu* _tmp82_;
		GMenu* section = NULL;
		GMenu* _tmp83_;
		GMenu* _tmp84_;
		GMenu* _tmp85_;
		GMenu* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		GMenu* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		GMenu* _tmp92_;
		GMenu* _tmp93_;
		GMenu* _tmp94_;
		GMenu* _tmp95_;
		GMenu* _tmp96_;
		GMenu* _tmp97_;
		GMenu* _tmp98_;
		_tmp77_ = g_menu_new ();
		menu = _tmp77_;
		_tmp78_ = g_menu_new ();
		_g_object_unref0 (self->priv->app_main_menu);
		self->priv->app_main_menu = _tmp78_;
		_tmp79_ = menu;
		_tmp80_ = self->priv->app_main_menu;
		g_menu_append_section (_tmp79_, NULL, (GMenuModel*) _tmp80_);
		_tmp81_ = self->priv->app_main_menu;
		g_menu_append (_tmp81_, _ ("_Scores"), "app.scores");
		_tmp82_ = self->priv->app_main_menu;
		g_menu_append (_tmp82_, _ ("A_ppearance"), "app.preferences");
		_tmp83_ = g_menu_new ();
		section = _tmp83_;
		_tmp84_ = menu;
		_tmp85_ = section;
		g_menu_append_section (_tmp84_, NULL, (GMenuModel*) _tmp85_);
		_tmp86_ = section;
		_tmp87_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp88_ = _tmp87_;
		g_menu_append (_tmp86_, _ ("_Show Warnings"), _tmp88_);
		_g_free0 (_tmp88_);
		_tmp89_ = section;
		_tmp90_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp91_ = _tmp90_;
		g_menu_append (_tmp89_, _ ("_Use Question Flags"), _tmp91_);
		_g_free0 (_tmp91_);
		_tmp92_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp92_;
		_tmp93_ = menu;
		_tmp94_ = section;
		g_menu_append_section (_tmp93_, NULL, (GMenuModel*) _tmp94_);
		_tmp95_ = section;
		g_menu_append (_tmp95_, _ ("_Help"), "app.help");
		_tmp96_ = section;
		g_menu_append (_tmp96_, _ ("_About"), "app.about");
		_tmp97_ = section;
		g_menu_append (_tmp97_, _ ("_Quit"), "app.quit");
		_tmp98_ = menu;
		gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) _tmp98_);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
	} else {
		GMenu* menu = NULL;
		GMenu* _tmp99_;
		GMenu* mines_menu = NULL;
		GMenu* _tmp100_;
		GMenu* _tmp101_;
		GMenu* _tmp102_;
		GMenu* _tmp103_;
		GMenu* _tmp104_;
		GMenu* _tmp105_;
		GMenu* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		GMenu* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		GMenu* _tmp112_;
		GMenu* help_menu = NULL;
		GMenu* _tmp113_;
		GMenu* _tmp114_;
		GMenu* _tmp115_;
		GMenu* _tmp116_;
		GMenu* _tmp117_;
		GMenu* _tmp118_;
		_tmp99_ = g_menu_new ();
		menu = _tmp99_;
		_tmp100_ = g_menu_new ();
		mines_menu = _tmp100_;
		_tmp101_ = menu;
		_tmp102_ = mines_menu;
		g_menu_append_submenu (_tmp101_, _ ("_Mines"), (GMenuModel*) _tmp102_);
		_tmp103_ = mines_menu;
		g_menu_append (_tmp103_, _ ("_New Game"), "app.new-game");
		_tmp104_ = mines_menu;
		g_menu_append (_tmp104_, _ ("_Scores"), "app.scores");
		_tmp105_ = mines_menu;
		g_menu_append (_tmp105_, _ ("A_ppearance"), "app.preferences");
		_tmp106_ = mines_menu;
		_tmp107_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp108_ = _tmp107_;
		g_menu_append (_tmp106_, _ ("_Show Warnings"), _tmp108_);
		_g_free0 (_tmp108_);
		_tmp109_ = mines_menu;
		_tmp110_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp111_ = _tmp110_;
		g_menu_append (_tmp109_, _ ("_Use Question Flags"), _tmp111_);
		_g_free0 (_tmp111_);
		_tmp112_ = mines_menu;
		g_menu_append (_tmp112_, _ ("_Quit"), "app.quit");
		_tmp113_ = g_menu_new ();
		help_menu = _tmp113_;
		_tmp114_ = menu;
		_tmp115_ = help_menu;
		g_menu_append_submenu (_tmp114_, _ ("_Help"), (GMenuModel*) _tmp115_);
		_tmp116_ = help_menu;
		g_menu_append (_tmp116_, _ ("_Contents"), "app.help");
		_tmp117_ = help_menu;
		g_menu_append (_tmp117_, _ ("_About"), "app.about");
		_tmp118_ = menu;
		gtk_application_set_menubar ((GtkApplication*) self, (GMenuModel*) _tmp118_);
		_g_object_unref0 (help_menu);
		_g_object_unref0 (mines_menu);
		_g_object_unref0 (menu);
	}
	_tmp119_ = g_strdup ("<Primary>n");
	_tmp120_ = g_new0 (gchar*, 1 + 1);
	_tmp120_[0] = _tmp119_;
	_tmp121_ = _tmp120_;
	_tmp121__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp121_);
	_tmp121_ = (_vala_array_free (_tmp121_, _tmp121__length1, (GDestroyNotify) g_free), NULL);
	_tmp122_ = g_strdup ("Escape");
	_tmp123_ = g_new0 (gchar*, 1 + 1);
	_tmp123_[0] = _tmp122_;
	_tmp124_ = _tmp123_;
	_tmp124__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.silent-new-game", _tmp124_);
	_tmp124_ = (_vala_array_free (_tmp124_, _tmp124__length1, (GDestroyNotify) g_free), NULL);
	_tmp125_ = g_strdup ("<Primary>r");
	_tmp126_ = g_new0 (gchar*, 1 + 1);
	_tmp126_[0] = _tmp125_;
	_tmp127_ = _tmp126_;
	_tmp127__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.repeat-size", _tmp127_);
	_tmp127_ = (_vala_array_free (_tmp127_, _tmp127__length1, (GDestroyNotify) g_free), NULL);
	_tmp128_ = g_strdup ("1");
	_tmp129_ = g_new0 (gchar*, 1 + 1);
	_tmp129_[0] = _tmp128_;
	_tmp130_ = _tmp129_;
	_tmp130__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.small-size", _tmp130_);
	_tmp130_ = (_vala_array_free (_tmp130_, _tmp130__length1, (GDestroyNotify) g_free), NULL);
	_tmp131_ = g_strdup ("2");
	_tmp132_ = g_new0 (gchar*, 1 + 1);
	_tmp132_[0] = _tmp131_;
	_tmp133_ = _tmp132_;
	_tmp133__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.medium-size", _tmp133_);
	_tmp133_ = (_vala_array_free (_tmp133_, _tmp133__length1, (GDestroyNotify) g_free), NULL);
	_tmp134_ = g_strdup ("3");
	_tmp135_ = g_new0 (gchar*, 1 + 1);
	_tmp135_[0] = _tmp134_;
	_tmp136_ = _tmp135_;
	_tmp136__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.large-size", _tmp136_);
	_tmp136_ = (_vala_array_free (_tmp136_, _tmp136__length1, (GDestroyNotify) g_free), NULL);
	_tmp137_ = g_strdup ("4");
	_tmp138_ = g_new0 (gchar*, 1 + 1);
	_tmp138_[0] = _tmp137_;
	_tmp139_ = _tmp138_;
	_tmp139__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.custom-size", _tmp139_);
	_tmp139_ = (_vala_array_free (_tmp139_, _tmp139__length1, (GDestroyNotify) g_free), NULL);
	_tmp140_ = g_strdup ("Pause");
	_tmp141_ = g_new0 (gchar*, 1 + 1);
	_tmp141_[0] = _tmp140_;
	_tmp142_ = _tmp141_;
	_tmp142__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp142_);
	_tmp142_ = (_vala_array_free (_tmp142_, _tmp142__length1, (GDestroyNotify) g_free), NULL);
	_tmp143_ = g_strdup ("F1");
	_tmp144_ = g_new0 (gchar*, 1 + 1);
	_tmp144_[0] = _tmp143_;
	_tmp145_ = _tmp144_;
	_tmp145__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp145_);
	_tmp145_ = (_vala_array_free (_tmp145_, _tmp145__length1, (GDestroyNotify) g_free), NULL);
	_tmp146_ = g_strdup ("<Primary>q");
	_tmp147_ = g_strdup ("<Primary>w");
	_tmp148_ = g_new0 (gchar*, 2 + 1);
	_tmp148_[0] = _tmp146_;
	_tmp148_[1] = _tmp147_;
	_tmp149_ = _tmp148_;
	_tmp149__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp149_);
	_tmp149_ = (_vala_array_free (_tmp149_, _tmp149__length1, (GDestroyNotify) g_free), NULL);
	_tmp150_ = self->priv->settings;
	_tmp151_ = minefield_view_new (_tmp150_);
	g_object_ref_sink (_tmp151_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp151_;
	_tmp152_ = self->priv->minefield_view;
	gtk_widget_show ((GtkWidget*) _tmp152_);
	_tmp153_ = gtk_builder_get_object (ui_builder, "stack");
	_tmp154_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp154_;
	_tmp155_ = gtk_builder_get_object (ui_builder, "scrolled");
	_tmp156_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp156_;
	_tmp157_ = self->priv->scrolled;
	_tmp158_ = self->priv->minefield_view;
	gtk_container_add ((GtkContainer*) _tmp157_, (GtkWidget*) _tmp158_);
	_tmp159_ = self->priv->scrolled;
	gtk_widget_show ((GtkWidget*) _tmp159_);
	_tmp160_ = gtk_builder_get_object (ui_builder, "minefield_overlay");
	_tmp161_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->minefield_overlay);
	self->priv->minefield_overlay = _tmp161_;
	_tmp162_ = self->priv->minefield_overlay;
	gtk_widget_show ((GtkWidget*) _tmp162_);
	_tmp163_ = gtk_builder_get_object (ui_builder, "minefield_aspect");
	_tmp164_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->minefield_aspect);
	self->priv->minefield_aspect = _tmp164_;
	_tmp165_ = self->priv->minefield_aspect;
	gtk_widget_show ((GtkWidget*) _tmp165_);
	_tmp166_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp167_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp167_;
	_tmp168_ = gtk_builder_get_object (ui_builder, "buttons_box");
	_tmp169_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->buttons_box);
	self->priv->buttons_box = _tmp169_;
	_tmp170_ = gtk_builder_get_object (ui_builder, "aspect_child");
	_tmp171_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->aspect_child);
	self->priv->aspect_child = _tmp171_;
	_tmp172_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp173_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp173_;
	_tmp174_ = self->priv->paused_box;
	g_signal_connect_object ((GtkWidget*) _tmp174_, "button-press-event", (GCallback) _mines_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp175_ = self->priv->minefield_overlay;
	_tmp176_ = self->priv->paused_box;
	gtk_overlay_add_overlay (_tmp175_, (GtkWidget*) _tmp176_);
	_tmp177_ = gtk_builder_get_object (ui_builder, "main_screen");
	_tmp178_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp177_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->main_screen);
	self->priv->main_screen = _tmp178_;
	_tmp179_ = self->priv->main_screen;
	gtk_widget_show_all (_tmp179_);
	mines_startup_new_game_screen (self, ui_builder);
	mines_startup_custom_game_screen (self, ui_builder);
	_tmp180_ = self->priv->window;
	_tmp181_ = games_scores_history_file_importer_new (_mines_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
	_tmp182_ = _tmp181_;
	_tmp183_ = games_scores_context_new_with_importer ("gnome-mines", _ ("Minefield:"), _tmp180_, _mines_create_category_from_key_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER, (GamesScoresImporter*) _tmp182_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp183_;
	_g_object_unref0 (_tmp182_);
	_tmp184_ = gtk_builder_get_object (ui_builder, "flag_label");
	_tmp185_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp184_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp185_;
	_tmp186_ = gtk_builder_get_object (ui_builder, "clock_label");
	_tmp187_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp187_;
	_tmp188_ = gtk_builder_get_object (ui_builder, "play_pause_button");
	_tmp189_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp189_;
	_tmp190_ = gtk_builder_get_object (ui_builder, "play_pause_label");
	_tmp191_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->play_pause_label);
	self->priv->play_pause_label = _tmp191_;
	_tmp192_ = gtk_builder_get_object (ui_builder, "high_scores_button");
	_tmp193_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->high_scores_button);
	self->priv->high_scores_button = _tmp193_;
	_tmp194_ = gtk_builder_get_object (ui_builder, "replay_button");
	_tmp195_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp194_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->replay_button);
	self->priv->replay_button = _tmp195_;
	_tmp196_ = gtk_builder_get_object (ui_builder, "new_game_button");
	_tmp197_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp196_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp197_;
	_tmp198_ = mines_game_mode;
	if (_tmp198_ != -1) {
		mines_start_game (self);
	}
	_g_free0 (desktop);
	_g_object_unref0 (ui_builder);
	_g_object_unref0 (css_provider);
}


static GamesScoresCategory* mines_create_category_from_key (Mines* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint width = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint height = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint num_mines = 0;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GamesScoresCategory* _tmp25_;
	GamesScoresCategory* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "-", 0);
	tokens = _tmp2_;
	tokens_length1 = _vala_array_length (_tmp1_);
	_tokens_size_ = tokens_length1;
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	if (_tmp3__length1 != 3) {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = tokens;
	_tmp4__length1 = tokens_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = atoi (_tmp5_);
	width = _tmp6_;
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	_tmp8_ = _tmp7_[1];
	_tmp9_ = atoi (_tmp8_);
	height = _tmp9_;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	_tmp11_ = _tmp10_[2];
	_tmp12_ = atoi (_tmp11_);
	num_mines = _tmp12_;
	_tmp15_ = width;
	if (_tmp15_ <= 0) {
		_tmp14_ = TRUE;
	} else {
		gint _tmp16_;
		_tmp16_ = height;
		_tmp14_ = _tmp16_ <= 0;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gint _tmp17_;
		_tmp17_ = num_mines;
		_tmp13_ = _tmp17_ <= 0;
	}
	if (_tmp13_) {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp18_ = key;
	_tmp19_ = num_mines;
	_tmp20_ = width;
	_tmp21_ = height;
	_tmp22_ = num_mines;
	_tmp23_ = g_strdup_printf (ngettext ("%d × %d, %d mine", "%d × %d, %d mines", (gulong) _tmp19_), _tmp20_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = games_scores_category_new (_tmp18_, _tmp24_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	result = _tmp26_;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void mines_parse_old_score (Mines* self, const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category) {
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint64 date = 0LL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint64 _tmp6_;
	gint width = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint height = 0;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint num_mines = 0;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint seconds = 0;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gint64 _tmp23_;
	gint _tmp28_;
	gint64 _tmp29_;
	GamesScoresScore* _tmp30_;
	gint _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gint _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gint _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GamesScoresCategory* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = NULL;
	_g_object_unref0 (_vala_category);
	_vala_category = NULL;
	_tmp0_ = line;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	tokens = _tmp2_;
	tokens_length1 = _vala_array_length (_tmp1_);
	_tokens_size_ = tokens_length1;
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	if (_tmp3__length1 != 5) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp4_ = tokens;
	_tmp4__length1 = tokens_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = games_scores_history_file_importer_parse_date (_tmp5_);
	date = _tmp6_;
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	_tmp8_ = _tmp7_[1];
	_tmp9_ = atoi (_tmp8_);
	width = _tmp9_;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	_tmp11_ = _tmp10_[2];
	_tmp12_ = atoi (_tmp11_);
	height = _tmp12_;
	_tmp13_ = tokens;
	_tmp13__length1 = tokens_length1;
	_tmp14_ = _tmp13_[3];
	_tmp15_ = atoi (_tmp14_);
	num_mines = _tmp15_;
	_tmp16_ = tokens;
	_tmp16__length1 = tokens_length1;
	_tmp17_ = _tmp16_[4];
	_tmp18_ = atoi (_tmp17_);
	seconds = _tmp18_;
	_tmp23_ = date;
	if (_tmp23_ <= ((gint64) 0)) {
		_tmp22_ = TRUE;
	} else {
		gint _tmp24_;
		_tmp24_ = width;
		_tmp22_ = _tmp24_ <= 0;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		gint _tmp25_;
		_tmp25_ = height;
		_tmp21_ = _tmp25_ <= 0;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gint _tmp26_;
		_tmp26_ = num_mines;
		_tmp20_ = _tmp26_ <= 0;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		gint _tmp27_;
		_tmp27_ = seconds;
		_tmp19_ = _tmp27_ < 0;
	}
	if (_tmp19_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp28_ = seconds;
	_tmp29_ = date;
	_tmp30_ = games_scores_score_new ((glong) _tmp28_, _tmp29_, NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp30_;
	_tmp31_ = width;
	_tmp32_ = g_strdup_printf ("%i", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = height;
	_tmp35_ = g_strdup_printf ("%i", _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = num_mines;
	_tmp38_ = g_strdup_printf ("%i", _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp33_, "-", _tmp36_, "-", _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = mines_create_category_from_key (self, _tmp41_);
	_g_object_unref0 (_vala_category);
	_vala_category = _tmp42_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp33_);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}


static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_small_size_clicked_cb ((Mines*) self);
}


static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_medium_size_clicked_cb ((Mines*) self);
}


static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_large_size_clicked_cb ((Mines*) self);
}


static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_custom_game_screen ((Mines*) self);
}


static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkAspectFrame* _tmp2_;
	GtkButton* button = NULL;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkButton* _tmp12_;
	GtkLabel* _tmp13_;
	GtkBuilder* _tmp14_;
	GObject* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkLabel* _tmp22_;
	GtkButton* _tmp23_;
	GtkLabel* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GtkLabel* _tmp33_;
	GtkButton* _tmp34_;
	GtkLabel* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_;
	GtkButton* _tmp38_;
	GtkButton* _tmp39_;
	GtkLabel* _tmp40_;
	GtkLabel* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkLabel* _tmp44_;
	GtkButton* _tmp45_;
	GtkLabel* _tmp46_;
	GtkAspectFrame* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "new_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "small_size_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	button = _tmp5_;
	_tmp6_ = button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _mines_small_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	_tmp8_ = label;
	_tmp9_ = mines_make_minefield_description (self, 8, 8, 10);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = label;
	gtk_label_set_justify (_tmp11_, GTK_JUSTIFY_CENTER);
	_tmp12_ = button;
	_tmp13_ = label;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "medium_size_btn");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp16_;
	_tmp17_ = button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) _mines_medium_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (label);
	label = _tmp18_;
	_tmp19_ = label;
	_tmp20_ = mines_make_minefield_description (self, 16, 16, 40);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = label;
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
	_tmp23_ = button;
	_tmp24_ = label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "large_size_btn");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp27_;
	_tmp28_ = button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _mines_large_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp29_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (label);
	label = _tmp29_;
	_tmp30_ = label;
	_tmp31_ = mines_make_minefield_description (self, 30, 16, 99);
	_tmp32_ = _tmp31_;
	gtk_label_set_markup (_tmp30_, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = label;
	gtk_label_set_justify (_tmp33_, GTK_JUSTIFY_CENTER);
	_tmp34_ = button;
	_tmp35_ = label;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "custom_size_btn");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp38_;
	_tmp39_ = button;
	g_signal_connect_object (_tmp39_, "clicked", (GCallback) _mines_show_custom_game_screen_gtk_button_clicked, self, 0);
	_tmp40_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (label);
	label = _tmp40_;
	_tmp41_ = label;
	_tmp42_ = g_strconcat ("<span size='xx-large' weight='heavy'>?</span>\n", g_dpgettext2 (NULL, "board size", _ ("Custom")), NULL);
	_tmp43_ = _tmp42_;
	gtk_label_set_markup_with_mnemonic (_tmp41_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = label;
	gtk_label_set_justify (_tmp44_, GTK_JUSTIFY_CENTER);
	_tmp45_ = button;
	_tmp46_ = label;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->new_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp47_);
	_g_object_unref0 (label);
	_g_object_unref0 (button);
}


static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_xsize_spin_cb ((Mines*) self, _sender);
}


static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_ysize_spin_cb ((Mines*) self, _sender);
}


static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_mines_spin_cb ((Mines*) self, _sender);
}


static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_new_game_screen ((Mines*) self);
}


static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_custom_size_clicked_cb ((Mines*) self);
}


static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkAspectFrame* _tmp2_;
	GtkSpinButton* field_width_entry = NULL;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GtkSpinButton* _tmp5_;
	GSettings* _tmp6_;
	gint _tmp7_;
	GtkSpinButton* field_height_entry = NULL;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_;
	GtkSpinButton* _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_;
	GtkSpinButton* _tmp15_;
	GtkSpinButton* _tmp16_;
	GtkSpinButton* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkButton* button = NULL;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkBuilder* _tmp23_;
	GObject* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkAspectFrame* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "custom_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->custom_game_screen);
	self->priv->custom_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "width_spin_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_spin_button_get_type (), GtkSpinButton));
	field_width_entry = _tmp5_;
	gtk_spin_button_set_range (field_width_entry, (gdouble) MINES_XSIZE_MIN, (gdouble) MINES_XSIZE_MAX);
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _mines_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_width_entry, (gdouble) 1, (gdouble) 1);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, MINES_KEY_XSIZE);
	gtk_spin_button_set_value (field_width_entry, (gdouble) _tmp7_);
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "height_spin_btn");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_spin_button_get_type (), GtkSpinButton));
	field_height_entry = _tmp10_;
	gtk_spin_button_set_range (field_height_entry, (gdouble) MINES_YSIZE_MIN, (gdouble) MINES_YSIZE_MAX);
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _mines_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_height_entry, (gdouble) 1, (gdouble) 1);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_int (_tmp11_, MINES_KEY_YSIZE);
	gtk_spin_button_set_value (field_height_entry, (gdouble) _tmp12_);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "mines_spin_btn");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_spin_button_get_type (), GtkSpinButton));
	_g_object_unref0 (self->priv->mines_spin);
	self->priv->mines_spin = _tmp15_;
	_tmp16_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp16_, (gdouble) 1, (gdouble) 100);
	_tmp17_ = self->priv->mines_spin;
	gtk_spin_button_set_increments (_tmp17_, (gdouble) 1, (gdouble) 1);
	_tmp18_ = self->priv->mines_spin;
	g_signal_connect_object (_tmp18_, "value-changed", (GCallback) _mines_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	mines_set_mines_limit (self);
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "cancel_btn");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_button_get_type (), GtkButton));
	button = _tmp21_;
	_tmp22_ = button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) _mines_show_new_game_screen_gtk_button_clicked, self, 0);
	_tmp23_ = builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "play_game_btn");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp25_;
	_tmp26_ = button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) _mines_custom_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp27_ = self->priv->custom_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp27_);
	_g_object_unref0 (button);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
}


static void mines_size_allocate_cb (Mines* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp2_ = self->priv->is_maximized;
	if (!_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->is_tiled;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->window_skip_configure;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWindow* _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp5_ = self->priv->window;
		gtk_window_get_size (_tmp5_, &_tmp6_, &_tmp7_);
		self->priv->window_width = _tmp6_;
		self->priv->window_height = _tmp7_;
	}
	self->priv->window_skip_configure = FALSE;
}


static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState* _tmp4_;
	GdkWindowState _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_;
		GdkWindowState _tmp7_;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		Minefield* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_is_clock_started (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp4_;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->minefield;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->pause_requested;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		ThemeSelectorDialog* _tmp5_;
		_tmp5_ = self->priv->theme_dialog;
		if (_tmp5_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			ThemeSelectorDialog* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->theme_dialog;
			_tmp7_ = gtk_widget_get_visible ((GtkWidget*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp4_ = _tmp8_ == FALSE;
		}
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp9_;
		_tmp9_ = self->priv->minefield;
		minefield_set_paused (_tmp9_, FALSE);
	}
	result = FALSE;
	return result;
}


static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines) {
	gchar* result = NULL;
	gchar* size_label = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* mines_label = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_strdup_printf ("%d × %d", _tmp0_, _tmp1_);
	size_label = _tmp2_;
	_tmp3_ = n_mines;
	_tmp4_ = n_mines;
	_tmp5_ = g_strdup_printf (ngettext ("<b>%d</b> mine", "<b>%d</b> mines", (gulong) _tmp3_), _tmp4_);
	mines_label = _tmp5_;
	_tmp6_ = g_strdup_printf ("<span size='x-large' weight='ultrabold'>%s</span>\n%s", size_label, mines_label);
	result = _tmp6_;
	_g_free0 (mines_label);
	_g_free0 (size_label);
	return result;
}


void mines_start (Mines* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	mines_show_new_game_screen (self);
}


static void mines_real_shutdown (GApplication* base) {
	Mines * self;
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	GtkSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSettings* _tmp8_;
	gboolean _tmp9_;
	GSettings* _tmp10_;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = gtk_settings_get_default ();
	g_object_get (_tmp5_, "gtk-enable-animations", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp4_, MINES_KEY_USE_ANIMATIONS, _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp8_, "window-is-maximized", _tmp9_);
	_tmp10_ = self->priv->settings;
	g_settings_apply (_tmp10_);
}


static gint mines_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Mines * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	GVariantDict* _tmp3_;
	gboolean _tmp4_;
	GVariantDict* _tmp5_;
	gboolean _tmp6_;
	GVariantDict* _tmp7_;
	gboolean _tmp8_;
	self = (Mines*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-mines", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp3_ = options;
	_tmp4_ = g_variant_dict_contains (_tmp3_, "small");
	if (_tmp4_) {
		mines_game_mode = 0;
	}
	_tmp5_ = options;
	_tmp6_ = g_variant_dict_contains (_tmp5_, "medium");
	if (_tmp6_) {
		mines_game_mode = 1;
	}
	_tmp7_ = options;
	_tmp8_ = g_variant_dict_contains (_tmp7_, "big");
	if (_tmp8_) {
		mines_game_mode = 2;
	}
	result = -1;
	return result;
}


static void mines_real_activate (GApplication* base) {
	Mines * self;
	GtkWindow* _tmp0_;
	self = (Mines*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Minefield* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Minefield* _tmp3_;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
		self->priv->pause_requested = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mines_quit_cb (Mines* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mines_update_flag_label (Mines* self) {
	GtkLabel* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Minefield* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_n_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->minefield;
	_tmp5_ = _tmp4_->n_mines;
	_tmp6_ = g_strdup_printf ("%u/%u", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_text (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
}


static gint mines_show_theme_selector (Mines* self) {
	gint result = 0;
	GtkWindow* _tmp0_;
	ThemeSelectorDialog* _tmp1_;
	gint _result_ = 0;
	ThemeSelectorDialog* _tmp2_;
	gint _tmp3_;
	ThemeSelectorDialog* _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->window;
	_tmp1_ = theme_selector_dialog_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->theme_dialog);
	self->priv->theme_dialog = _tmp1_;
	_tmp2_ = self->priv->theme_dialog;
	_tmp3_ = gtk_dialog_run ((GtkDialog*) _tmp2_);
	_result_ = _tmp3_;
	_tmp4_ = self->priv->theme_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	result = _result_;
	return result;
}


static void mines_show_scores (Mines* self) {
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	games_scores_context_run_dialog (_tmp0_);
}


static void mines_scores_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_scores (self);
}


static void mines_preferences_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_theme_selector (self);
}


static void mines_show_custom_game_screen (Mines* self) {
	Minefield* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		return;
	}
	mines_size_actions_toggle (self, FALSE);
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "custom_game");
}


static gboolean mines_can_start_new_game (Mines* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Minefield* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = self->priv->minefield;
		_tmp8_ = _tmp7_->exploded;
		_tmp1_ = !_tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Minefield* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_is_complete (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = !_tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean was_paused = FALSE;
		Minefield* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		Minefield* _tmp15_;
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp16_;
		GtkMessageDialog* _tmp17_;
		GtkMessageDialog* _tmp18_;
		GtkMessageDialog* _tmp19_;
		gint _result_ = 0;
		GtkMessageDialog* _tmp20_;
		gint _tmp21_;
		GtkMessageDialog* _tmp22_;
		gint _tmp23_;
		_tmp12_ = self->priv->minefield;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		was_paused = _tmp14_;
		_tmp15_ = self->priv->minefield;
		minefield_set_paused (_tmp15_, TRUE);
		_tmp16_ = self->priv->window;
		_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp16_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you want to start a new game?"));
		g_object_ref_sink (_tmp17_);
		dialog = _tmp17_;
		_tmp18_ = dialog;
		g_object_set (_tmp18_, "secondary-text", _ ("If you start a new game, your current progress will be lost."), NULL);
		_tmp19_ = dialog;
		gtk_dialog_add_buttons ((GtkDialog*) _tmp19_, _ ("Keep Current Game"), GTK_RESPONSE_DELETE_EVENT, _ ("Start New Game"), GTK_RESPONSE_ACCEPT, NULL, NULL);
		_tmp20_ = dialog;
		_tmp21_ = gtk_dialog_run ((GtkDialog*) _tmp20_);
		_result_ = _tmp21_;
		_tmp22_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp22_);
		_tmp23_ = _result_;
		if (_tmp23_ != ((gint) GTK_RESPONSE_ACCEPT)) {
			Minefield* _tmp24_;
			gboolean _tmp25_;
			_tmp24_ = self->priv->minefield;
			_tmp25_ = was_paused;
			minefield_set_paused (_tmp24_, _tmp25_);
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		_g_object_unref0 (dialog);
	}
	result = TRUE;
	return result;
}


static void mines_show_new_game_screen (Mines* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	Minefield* _tmp3_;
	GtkWindow* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "new_game") == 0) {
		return;
	}
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
		self->priv->pause_requested = FALSE;
		_tmp5_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp5_, NULL, self);
	}
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = NULL;
	_tmp6_ = self->priv->window;
	_tmp7_ = self->priv->window_width;
	_tmp8_ = self->priv->window_height;
	gtk_window_resize (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_tmp10_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	mines_size_actions_toggle (self, TRUE);
	_tmp11_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp11_, "new_game");
}


static void mines_size_actions_toggle (Mines* self, gboolean enabled) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GSimpleAction** _tmp3_;
				gint _tmp3__length1;
				GSimpleAction** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				GSimpleAction* _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->size_actions;
				_tmp3__length1 = self->priv->size_actions_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->priv->size_actions;
				_tmp4__length1 = self->priv->size_actions_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = enabled;
				g_simple_action_set_enabled (_tmp6_, _tmp7_);
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Mines* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self) {
	mines_marks_changed_cb ((Mines*) self, _sender);
}


static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	mines_explode_cb ((Mines*) self, _sender);
}


static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	mines_cleared_cb ((Mines*) self, _sender);
}


static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self) {
	mines_tick_cb ((Mines*) self);
}


static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self) {
	mines_paused_changed_cb ((Mines*) self);
}


static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self) {
	mines_clock_started_cb ((Mines*) self);
}


static void __lambda19_ (Block1Data* _data1_, GtkAllocation* allocation) {
	Mines* self;
	MinefieldView* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
	GtkBox* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guint _tmp8_;
	GtkBox* _tmp9_;
	gint _tmp10_;
	GtkAspectFrame* _tmp11_;
	guint _tmp12_;
	gint _tmp13_;
	MinefieldView* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	self = _data1_->self;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->minefield_view;
	_tmp1_ = minefield_view_get_mine_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data1_->x;
	_data1_->width = _tmp2_ * _tmp3_;
	_tmp4_ = _data1_->width;
	_tmp5_ = self->priv->aspect_child;
	_tmp6_ = gtk_box_get_spacing (_tmp5_);
	_tmp7_ = _tmp6_;
	_data1_->width = _tmp4_ + _tmp7_;
	_tmp8_ = _data1_->width;
	_tmp9_ = self->priv->buttons_box;
	_tmp10_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp9_);
	_data1_->width = _tmp8_ + _tmp10_;
	_tmp11_ = self->priv->minefield_aspect;
	_tmp12_ = _data1_->width;
	_tmp13_ = _data1_->y;
	_tmp14_ = self->priv->minefield_view;
	_tmp15_ = minefield_view_get_mine_size (_tmp14_);
	_tmp16_ = _tmp15_;
	g_object_set (_tmp11_, "ratio", ((gfloat) _tmp12_) / (_tmp13_ * _tmp16_), NULL);
}


static void ___lambda19__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda19_ (self, allocation);
}


static void mines_start_game (Mines* self) {
	Block1Data* _data1_;
	MinefieldView* _tmp0_;
	GSimpleAction* _tmp1_;
	GtkLabel* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	gint n = 0;
	GSettings* _tmp6_;
	gint _tmp7_;
	Minefield* _tmp19_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	Minefield* _tmp24_;
	Minefield* _tmp25_;
	Minefield* _tmp26_;
	Minefield* _tmp27_;
	Minefield* _tmp28_;
	Minefield* _tmp29_;
	Minefield* _tmp30_;
	MinefieldView* _tmp31_;
	Minefield* _tmp32_;
	gint mine_size = 0;
	MinefieldView* _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	gint _tmp36_;
	gint request_x = 0;
	gint request_y = 0;
	GtkWindow* _tmp37_;
	gint _tmp38_;
	GtkScrolledWindow* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GtkBox* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GtkBox* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GtkWindow* _tmp60_;
	gint _tmp61_;
	GtkScrolledWindow* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	GtkAspectFrame* _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	guint _tmp77_;
	GtkBox* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	guint _tmp81_;
	GtkBox* _tmp82_;
	gint _tmp83_;
	guint _tmp84_;
	GtkAspectFrame* _tmp85_;
	guint _tmp86_;
	gint _tmp87_;
	gint _tmp88_;
	GtkAspectFrame* _tmp89_;
	Minefield* _tmp90_;
	GtkStack* _tmp91_;
	GSimpleAction* _tmp92_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	self->priv->window_skip_configure = TRUE;
	_tmp0_ = self->priv->minefield_view;
	g_object_set ((GtkWidget*) _tmp0_, "has-focus", TRUE, NULL);
	_tmp1_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->play_pause_label;
	gtk_label_set_label (_tmp2_, _ ("_Pause"));
	_tmp3_ = self->priv->replay_button;
	gtk_button_set_label (_tmp3_, _ ("St_art Over"));
	_tmp4_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->high_scores_button;
	gtk_widget_hide ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, MINES_KEY_MODE);
	switch (_tmp7_) {
		case 0:
		{
			_data1_->x = 8;
			_data1_->y = 8;
			n = 10;
			break;
		}
		case 1:
		{
			_data1_->x = 16;
			_data1_->y = 16;
			n = 40;
			break;
		}
		case 2:
		{
			_data1_->x = 30;
			_data1_->y = 16;
			n = 99;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GSettings* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GSettings* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp8_ = self->priv->settings;
			_tmp9_ = g_settings_get_int (_tmp8_, MINES_KEY_XSIZE);
			_tmp10_ = CLAMP (_tmp9_, MINES_XSIZE_MIN, MINES_XSIZE_MAX);
			_data1_->x = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, MINES_KEY_YSIZE);
			_tmp13_ = CLAMP (_tmp12_, MINES_YSIZE_MIN, MINES_YSIZE_MAX);
			_data1_->y = _tmp13_;
			_tmp14_ = self->priv->settings;
			_tmp15_ = g_settings_get_int (_tmp14_, MINES_KEY_NMINES);
			_tmp16_ = _data1_->x;
			_tmp17_ = _data1_->y;
			_tmp18_ = CLAMP (_tmp15_, 1, (_tmp16_ * _tmp17_) - 10);
			n = _tmp18_;
			break;
		}
	}
	_tmp19_ = self->priv->minefield;
	if (_tmp19_ != NULL) {
		Minefield* _tmp20_;
		_tmp20_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp20_, NULL, self);
	}
	_tmp21_ = _data1_->x;
	_tmp22_ = _data1_->y;
	_tmp23_ = n;
	_tmp24_ = minefield_new ((guint) _tmp21_, (guint) _tmp22_, (guint) _tmp23_);
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp24_;
	_tmp25_ = self->priv->minefield;
	g_signal_connect_object (_tmp25_, "marks-changed", (GCallback) _mines_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp26_ = self->priv->minefield;
	g_signal_connect_object (_tmp26_, "explode", (GCallback) _mines_explode_cb_minefield_explode, self, 0);
	_tmp27_ = self->priv->minefield;
	g_signal_connect_object (_tmp27_, "cleared", (GCallback) _mines_cleared_cb_minefield_cleared, self, 0);
	_tmp28_ = self->priv->minefield;
	g_signal_connect_object (_tmp28_, "tick", (GCallback) _mines_tick_cb_minefield_tick, self, 0);
	_tmp29_ = self->priv->minefield;
	g_signal_connect_object (_tmp29_, "paused-changed", (GCallback) _mines_paused_changed_cb_minefield_paused_changed, self, 0);
	_tmp30_ = self->priv->minefield;
	g_signal_connect_object (_tmp30_, "clock-started", (GCallback) _mines_clock_started_cb_minefield_clock_started, self, 0);
	_tmp31_ = self->priv->minefield_view;
	_tmp32_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->minefield_view;
	_tmp34_ = minefield_view_get_mine_size (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = MAX ((gint) _tmp35_, 30);
	mine_size = _tmp36_;
	request_x = -1;
	request_y = -1;
	_tmp37_ = self->priv->window;
	_tmp38_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp37_);
	_tmp39_ = self->priv->scrolled;
	_tmp40_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp39_);
	_tmp41_ = _data1_->x;
	_tmp42_ = self->priv->aspect_child;
	_tmp43_ = gtk_box_get_spacing (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = self->priv->buttons_box;
	_tmp46_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp45_);
	_tmp47_ = gdk_screen_width ();
	if (((((_tmp38_ - _tmp40_) + (30 * _tmp41_)) + _tmp44_) + _tmp46_) < _tmp47_) {
		gint _tmp48_;
		GtkBox* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		_tmp48_ = _data1_->x;
		_tmp49_ = self->priv->aspect_child;
		_tmp50_ = gtk_box_get_spacing (_tmp49_);
		_tmp51_ = _tmp50_;
		request_x = ((_tmp48_ * 30) + _tmp51_) + 150;
	} else {
		gint _tmp52_;
		GtkWindow* _tmp53_;
		gint _tmp54_;
		GtkScrolledWindow* _tmp55_;
		gint _tmp56_;
		GtkBox* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		_tmp52_ = gdk_screen_width ();
		_tmp53_ = self->priv->window;
		_tmp54_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp53_);
		_tmp55_ = self->priv->scrolled;
		_tmp56_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp55_);
		_tmp57_ = self->priv->aspect_child;
		_tmp58_ = gtk_box_get_spacing (_tmp57_);
		_tmp59_ = _tmp58_;
		request_x = (((_tmp52_ - _tmp54_) + _tmp56_) + _tmp59_) + 150;
	}
	_tmp60_ = self->priv->window;
	_tmp61_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp60_);
	_tmp62_ = self->priv->scrolled;
	_tmp63_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp62_);
	_tmp64_ = _data1_->y;
	_tmp65_ = gdk_screen_height ();
	if (((_tmp61_ - _tmp63_) + (30 * _tmp64_)) < _tmp65_) {
		gint _tmp66_;
		_tmp66_ = _data1_->y;
		request_y = _tmp66_ * 30;
	} else {
		gint _tmp67_;
		GtkWindow* _tmp68_;
		gint _tmp69_;
		GtkScrolledWindow* _tmp70_;
		gint _tmp71_;
		_tmp67_ = gdk_screen_height ();
		_tmp68_ = self->priv->window;
		_tmp69_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp68_);
		_tmp70_ = self->priv->scrolled;
		_tmp71_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp70_);
		request_y = (_tmp67_ - _tmp69_) + _tmp71_;
	}
	_tmp72_ = self->priv->minefield_aspect;
	_tmp73_ = request_x;
	_tmp74_ = request_y;
	gtk_widget_set_size_request ((GtkWidget*) _tmp72_, _tmp73_, _tmp74_);
	_tmp75_ = _data1_->x;
	_tmp76_ = mine_size;
	_data1_->width = (guint) (_tmp75_ * _tmp76_);
	_tmp77_ = _data1_->width;
	_tmp78_ = self->priv->aspect_child;
	_tmp79_ = gtk_box_get_spacing (_tmp78_);
	_tmp80_ = _tmp79_;
	_data1_->width = _tmp77_ + _tmp80_;
	_tmp81_ = _data1_->width;
	_tmp82_ = self->priv->buttons_box;
	_tmp83_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp82_);
	_tmp84_ = MAX ((guint) _tmp83_, (guint) 150);
	_data1_->width = _tmp81_ + _tmp84_;
	_tmp85_ = self->priv->minefield_aspect;
	_tmp86_ = _data1_->width;
	_tmp87_ = _data1_->y;
	_tmp88_ = mine_size;
	g_object_set (_tmp85_, "ratio", ((gfloat) _tmp86_) / (_tmp87_ * _tmp88_), NULL);
	_tmp89_ = self->priv->minefield_aspect;
	g_signal_connect_data ((GtkWidget*) _tmp89_, "size-allocate", (GCallback) ___lambda19__gtk_widget_size_allocate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	mines_update_flag_label (self);
	_tmp90_ = self->priv->minefield;
	minefield_set_paused (_tmp90_, FALSE);
	self->priv->pause_requested = FALSE;
	_tmp91_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp91_, "game");
	_tmp92_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp92_, FALSE);
	mines_tick_cb (self);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void mines_new_game_cb (Mines* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_silent_new_game_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_get_n_cleared (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == ((guint) 0);
	}
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_repeat_size_cb (Mines* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_start_game (self);
	}
}


static void mines_toggle_pause_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->pause_requested;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->pause_requested = TRUE;
	} else {
		Minefield* _tmp5_;
		Minefield* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		Minefield* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp5_ = self->priv->minefield;
		_tmp6_ = self->priv->minefield;
		_tmp7_ = minefield_get_paused (_tmp6_);
		_tmp8_ = _tmp7_;
		minefield_set_paused (_tmp5_, !_tmp8_);
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->pause_requested = _tmp11_;
	}
}


static void mines_paused_changed_cb (Mines* self) {
	Minefield* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkBox* _tmp8_;
	Minefield* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkLabel* _tmp3_;
		_tmp3_ = self->priv->play_pause_label;
		gtk_label_set_label (_tmp3_, _ ("_Resume"));
	} else {
		Minefield* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_elapsed (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > ((gdouble) 0)) {
			GtkLabel* _tmp7_;
			_tmp7_ = self->priv->play_pause_label;
			gtk_label_set_label (_tmp7_, _ ("_Pause"));
		}
	}
	_tmp8_ = self->priv->paused_box;
	_tmp9_ = self->priv->minefield;
	_tmp10_ = minefield_get_paused (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, _tmp11_);
}


static void mines_marks_changed_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_update_flag_label (self);
}


static void mines_explode_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_game_ended (self);
}


static void mines_game_ended (Mines* self) {
	GtkButton* _tmp0_;
	GSimpleAction* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->replay_button;
	gtk_button_set_label (_tmp0_, _ ("Play _Again"));
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->high_scores_button;
	gtk_widget_show ((GtkWidget*) _tmp3_);
}


static void __lambda18_ (Mines* self, GObject* object, GAsyncResult* _result_) {
	GSimpleAction* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = self->priv->context;
		_tmp1_ = _result_;
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("gnome-mines.vala:800: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	mines_show_new_game_screen (self);
}


static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda18_ ((Mines*) self, source_object, res);
	g_object_unref (self);
}


static void mines_cleared_cb (Mines* self, Minefield* minefield) {
	guint duration = 0U;
	Minefield* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gchar* key = NULL;
	Minefield* _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Minefield* _tmp9_;
	guint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	Minefield* _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GSimpleAction* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GamesScoresContext* _tmp26_;
	GamesScoresCategory* _tmp27_;
	GamesScoresCategory* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = minefield;
	_tmp1_ = minefield_get_elapsed (_tmp0_);
	_tmp2_ = _tmp1_;
	duration = (guint) (_tmp2_ + 0.5);
	_tmp3_ = minefield;
	_tmp4_ = _tmp3_->width;
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, "-", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = minefield;
	_tmp10_ = _tmp9_->height;
	_tmp11_ = g_strdup_printf ("%u", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, "-", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = minefield;
	_tmp18_ = _tmp17_->n_mines;
	_tmp19_ = g_strdup_printf ("%u", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp16_, _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	key = _tmp22_;
	_tmp23_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp23_, FALSE);
	_tmp24_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp24_, FALSE);
	_tmp25_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp25_, FALSE);
	_tmp26_ = self->priv->context;
	_tmp27_ = mines_create_category_from_key (self, key);
	_tmp28_ = _tmp27_;
	games_scores_context_add_score (_tmp26_, (glong) duration, _tmp28_, NULL, ___lambda18__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp28_);
	_g_free0 (key);
}


static void mines_clock_started_cb (Mines* self) {
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_label;
	gtk_label_set_label (_tmp0_, _ ("_Pause"));
	_tmp1_ = self->priv->replay_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
	_tmp3_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
}


static void mines_tick_cb (Mines* self) {
	gint elapsed = 0;
	Minefield* _tmp0_;
	gint hours = 0;
	gint _tmp4_;
	gint minutes = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint seconds = 0;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = self->priv->minefield;
		_tmp2_ = minefield_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	_tmp6_ = hours;
	minutes = (_tmp5_ - (_tmp6_ * 3600)) / 60;
	_tmp7_ = elapsed;
	_tmp8_ = hours;
	_tmp9_ = minutes;
	seconds = (_tmp7_ - (_tmp8_ * 3600)) - (_tmp9_ * 60);
	_tmp10_ = hours;
	if (_tmp10_ > 0) {
		GtkLabel* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = hours;
		_tmp13_ = minutes;
		_tmp14_ = seconds;
		_tmp15_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_text (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkLabel* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = self->priv->clock_label;
		_tmp18_ = minutes;
		_tmp19_ = seconds;
		_tmp20_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
}


static void mines_about_cb (Mines* self) {
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint artists_length1;
	gint _artists_size_;
	gchar** documenters = NULL;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint documenters_length1;
	gint _documenters_size_;
	GtkWindow* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Main game:"));
	_tmp1_ = g_strdup ("Szekeres Istvan (Pista)");
	_tmp2_ = g_strdup ("Robert Ancell");
	_tmp3_ = g_strdup ("Robert Roth");
	_tmp4_ = g_strdup ("");
	_tmp5_ = g_strdup (_ ("Score:"));
	_tmp6_ = g_strdup ("Horacio J. Peña");
	_tmp7_ = g_strdup ("");
	_tmp8_ = g_strdup (_ ("Resizing and SVG support:"));
	_tmp9_ = g_strdup ("Steve Chaplin");
	_tmp10_ = g_strdup ("Callum McKenzie");
	_tmp11_ = g_new0 (gchar*, 12 + 1);
	_tmp11_[0] = _tmp0_;
	_tmp11_[1] = _tmp1_;
	_tmp11_[2] = _tmp2_;
	_tmp11_[3] = _tmp3_;
	_tmp11_[4] = _tmp4_;
	_tmp11_[5] = _tmp5_;
	_tmp11_[6] = _tmp6_;
	_tmp11_[7] = _tmp7_;
	_tmp11_[8] = _tmp8_;
	_tmp11_[9] = _tmp9_;
	_tmp11_[10] = _tmp10_;
	_tmp11_[11] = NULL;
	authors = _tmp11_;
	authors_length1 = 12;
	_authors_size_ = authors_length1;
	_tmp12_ = g_strdup ("Richard Hoelscher");
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp13_[1] = NULL;
	artists = _tmp13_;
	artists_length1 = 2;
	_artists_size_ = artists_length1;
	_tmp14_ = g_strdup ("Ekaterina Gerasimova");
	_tmp15_ = g_new0 (gchar*, 2 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp15_[1] = NULL;
	documenters = _tmp15_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp16_ = self->priv->window;
	gtk_show_about_dialog (_tmp16_, "name", _ ("Mines"), "version", VERSION, "comments", _ ("Clear explosive mines off the board"), "copyright", "Copyright © 1997–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _ ("translator-credits"), "logo-icon-name", "gnome-mines", "website", "https://wiki.gnome.org/Apps/Mines", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gfloat mines_percent_mines (Mines* self) {
	gfloat result = 0.0F;
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_NMINES);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_XSIZE);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, MINES_KEY_YSIZE);
	result = (100.0f * ((gfloat) _tmp1_)) / (_tmp3_ * _tmp5_);
	return result;
}


static void mines_set_mines_limit (Mines* self) {
	gint size = 0;
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	gint max_mines = 0;
	gdouble _tmp4_;
	gint min_mines = 0;
	gdouble _tmp5_;
	gint _tmp6_;
	GtkSpinButton* _tmp7_;
	GtkSpinButton* _tmp8_;
	gfloat _tmp9_;
	gdouble _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_YSIZE);
	size = _tmp1_ * _tmp3_;
	_tmp4_ = round ((gdouble) ((100.0f * ((gfloat) (size - 10))) / size));
	max_mines = (gint) _tmp4_;
	_tmp5_ = round ((gdouble) (100.0f / size));
	_tmp6_ = MAX (1, (gint) _tmp5_);
	min_mines = _tmp6_;
	_tmp7_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp7_, (gdouble) min_mines, (gdouble) max_mines);
	_tmp8_ = self->priv->mines_spin;
	_tmp9_ = mines_percent_mines (self);
	_tmp10_ = round ((gdouble) _tmp9_);
	gtk_spin_button_set_value (_tmp8_, (gdouble) ((gint) _tmp10_));
}


static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint xsize = 0;
	GtkSpinButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_;
	GSettings* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	xsize = _tmp1_;
	_tmp2_ = xsize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_XSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = xsize;
	g_settings_set_int (_tmp5_, MINES_KEY_XSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint ysize = 0;
	GtkSpinButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_;
	GSettings* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	ysize = _tmp1_;
	_tmp2_ = ysize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_YSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = ysize;
	g_settings_set_int (_tmp5_, MINES_KEY_YSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin) {
	gfloat _tmp0_;
	GtkSpinButton* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkSpinButton* _tmp5_;
	gdouble _tmp6_;
	GSettings* _tmp7_;
	gint _tmp8_;
	GSettings* _tmp9_;
	gint _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = mines_percent_mines (self);
	_tmp1_ = spin;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = fabs (_tmp0_ - _tmp2_);
	if (_tmp3_ <= ((gdouble) 0.5f)) {
		return;
	}
	_tmp4_ = self->priv->settings;
	_tmp5_ = spin;
	_tmp6_ = gtk_spin_button_get_value (_tmp5_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_int (_tmp7_, MINES_KEY_XSIZE);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, MINES_KEY_YSIZE);
	_tmp11_ = round ((_tmp6_ * (_tmp8_ * _tmp10_)) / 100.0f);
	g_settings_set_int (_tmp4_, MINES_KEY_NMINES, (gint) _tmp11_);
}


static void mines_set_mode (Mines* self, gint mode) {
	Minefield* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = mode;
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_MODE);
	if (_tmp1_ != _tmp3_) {
		GSettings* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->settings;
		_tmp5_ = mode;
		g_settings_set_int (_tmp4_, MINES_KEY_MODE, _tmp5_);
	}
	mines_size_actions_toggle (self, FALSE);
	mines_start_game (self);
}


static void mines_small_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 0);
}


static void mines_medium_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 1);
}


static void mines_large_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 2);
}


static void mines_custom_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 3);
}


static void mines_help_cb (Mines* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-mines", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-mines.vala:959: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gint mines_main (gchar** args, int args_length1) {
	gint result = 0;
	Mines* app = NULL;
	Mines* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = mines_new ();
	app = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) app, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return mines_main (argv, argc);
}


static void mines_class_init (MinesClass * klass) {
	mines_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinesPrivate));
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) mines_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) mines_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) mines_real_handle_local_options;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) mines_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mines_finalize;
}


static void mines_instance_init (Mines * self) {
	GSimpleAction** _tmp0_;
	self->priv = MINES_GET_PRIVATE (self);
	_tmp0_ = g_new0 (GSimpleAction*, 4 + 1);
	self->priv->size_actions = _tmp0_;
	self->priv->size_actions_length1 = 4;
	self->priv->_size_actions_size_ = self->priv->size_actions_length1;
}


static void mines_finalize (GObject * obj) {
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINES, Mines);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_screen);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->play_pause_label);
	_g_object_unref0 (self->priv->replay_button);
	_g_object_unref0 (self->priv->high_scores_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->minefield_aspect);
	_g_object_unref0 (self->priv->minefield_overlay);
	_g_object_unref0 (self->priv->aspect_child);
	_g_object_unref0 (self->priv->buttons_box);
	_g_object_unref0 (self->priv->paused_box);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->theme_dialog);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->app_main_menu);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->mines_spin);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->repeat_size_action);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->size_actions = (_vala_array_free (self->priv->size_actions, self->priv->size_actions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->custom_game_screen);
	_g_object_unref0 (self->priv->theme_provider);
	G_OBJECT_CLASS (mines_parent_class)->finalize (obj);
}


GType mines_get_type (void) {
	static volatile gsize mines_type_id__volatile = 0;
	if (g_once_init_enter (&mines_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mines_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mines), 0, (GInstanceInitFunc) mines_instance_init, NULL };
		GType mines_type_id;
		mines_type_id = g_type_register_static (gtk_application_get_type (), "Mines", &g_define_type_info, 0);
		g_once_init_leave (&mines_type_id__volatile, mines_type_id);
	}
	return mines_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



