/* sudoku-view.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE_PROPERTY,
	SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_CELL_VIEW_SELECTED_PROPERTY,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY,
	SUDOKU_CELL_VIEW_LAST_PROPERTY
};
static GParamSpec* sudoku_cell_view_properties[SUDOKU_CELL_VIEW_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_VIEW_HIGHLIGHTER_PROPERTY,
	SUDOKU_VIEW_LAST_PROPERTY
};
static GParamSpec* sudoku_view_properties[SUDOKU_VIEW_LAST_PROPERTY];
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
};

struct _Block5Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame* * game);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame* * game);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard* * board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard* * board, gboolean earmark);
static void __lambda7_ (SudokuCellView* self, gint number, gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static void __lambda10_ (SudokuCellView* self, NumberPicker* o, gint number);
static void ___lambda10__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
static void __lambda11_ (SudokuCellView* self);
static void sudoku_cell_view_destroy_popover (SudokuCellView* self, GtkPopover* * popover);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda12_ (SudokuCellView* self);
static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda8_ (SudokuCellView* self);
static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda9_ (SudokuCellView* self);
static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA * value);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA * result);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1, const GdkRGBA * s2);
static void sudoku_cell_view_finalize (GObject * obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ________lambda13_ (Block6Data* _data6_);
static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void ________lambda14_ (Block6Data* _data6_, GObject* s, GParamSpec* p);
static void _________lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
gboolean sudoku_view_get_highlighter (SudokuView* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void sudoku_view_finalize (GObject * obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GdkRGBA selected_bg_color = {0.7, 0.8, 0.9};
const GdkRGBA fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
const GdkRGBA free_cell_color = {1.0, 1.0, 1.0, 1.0};
const GdkRGBA highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};

static gpointer _g_object_ref0 (gpointer self) {
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 255 "sudoku-view.c"
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 264 "sudoku-view.c"
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
#line 271 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame* * game) {
	SudokuCellView * self = NULL;
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkStyle* _tmp4_;
	GtkStyle* _tmp5_;
	PangoFontDescription* _tmp6_;
	SudokuGame* _tmp7_;
	SudokuBoard* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp14_;
	SudokuGame* _tmp17_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (*game != NULL, NULL);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) g_object_new (object_type, NULL);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *game;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->game = _tmp1_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = row;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->row = _tmp2_;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = col;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->col = _tmp3_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp4_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_->font_desc;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	pango_font_description_set_size (_tmp6_, PANGO_SCALE * 13);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = *game;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_->board;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = row;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = col;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = sudoku_board_get (_tmp8_, _tmp9_, _tmp10_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp11_);
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK);
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = sudoku_cell_view_get_is_fixed (self);
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = _tmp13_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp14_) {
#line 343 "sudoku-view.c"
		SudokuGame* _tmp15_;
		GameMode _tmp16_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = *game;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = _tmp15_->mode;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp16_ == GAME_MODE_PLAY;
#line 352 "sudoku-view.c"
	} else {
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = FALSE;
#line 356 "sudoku-view.c"
	}
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_) {
#line 122 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return self;
#line 362 "sudoku-view.c"
	}
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = *game;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp17_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 372 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame* * game) {
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
#line 379 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_;
	guint _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_ = FALSE;
	SudokuGame* _tmp8_;
	GameMode _tmp9_;
	gboolean _tmp16_ = FALSE;
	GtkPopover* _tmp17_;
	GdkEventButton* _tmp19_;
	guint _tmp20_;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = event;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->button;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != ((guint) 1)) {
#line 408 "sudoku-view.c"
		GdkEventButton* _tmp3_;
		guint _tmp4_;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = event;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _tmp3_->button;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp4_ != ((guint) 3);
#line 417 "sudoku-view.c"
	} else {
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 421 "sudoku-view.c"
	}
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 429 "sudoku-view.c"
	}
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp6_) {
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) self);
#line 439 "sudoku-view.c"
	}
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = self->priv->game;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _tmp8_->mode;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp9_ == GAME_MODE_PLAY) {
#line 447 "sudoku-view.c"
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp12_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = sudoku_cell_view_get_is_fixed (self);
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp12_) {
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp10_ = TRUE;
#line 459 "sudoku-view.c"
		} else {
			SudokuGame* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp13_ = self->priv->game;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = sudoku_game_get_paused (_tmp13_);
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = _tmp14_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp10_ = _tmp15_;
#line 472 "sudoku-view.c"
		}
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp10_;
#line 476 "sudoku-view.c"
	} else {
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = FALSE;
#line 480 "sudoku-view.c"
	}
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_) {
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 488 "sudoku-view.c"
	}
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = self->priv->popover;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp17_ != NULL) {
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = TRUE;
#line 496 "sudoku-view.c"
	} else {
		GtkPopover* _tmp18_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->earmark_popover;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = _tmp18_ != NULL;
#line 503 "sudoku-view.c"
	}
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp16_) {
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 513 "sudoku-view.c"
	}
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = event;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _tmp19_->button;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp20_ == ((guint) 1)) {
#line 521 "sudoku-view.c"
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->_show_possibilities;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp23_) {
#line 529 "sudoku-view.c"
			GdkEventButton* _tmp24_;
			GdkModifierType _tmp25_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = event;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->state;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = (_tmp25_ & GDK_CONTROL_MASK) > 0;
#line 538 "sudoku-view.c"
		} else {
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = FALSE;
#line 542 "sudoku-view.c"
		}
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp22_) {
#line 546 "sudoku-view.c"
			SudokuGame* _tmp26_;
			GameMode _tmp27_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = self->priv->game;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = _tmp26_->mode;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp27_ == GAME_MODE_PLAY;
#line 555 "sudoku-view.c"
		} else {
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = FALSE;
#line 559 "sudoku-view.c"
		}
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp21_) {
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 565 "sudoku-view.c"
		} else {
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_number_picker (self);
#line 569 "sudoku-view.c"
		}
	} else {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = self->priv->_show_possibilities;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp30_) {
#line 579 "sudoku-view.c"
			GdkEventButton* _tmp31_;
			guint _tmp32_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = event;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp32_ = _tmp31_->button;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = _tmp32_ == ((guint) 3);
#line 588 "sudoku-view.c"
		} else {
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = FALSE;
#line 592 "sudoku-view.c"
		}
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp29_) {
#line 596 "sudoku-view.c"
			SudokuGame* _tmp33_;
			GameMode _tmp34_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp33_ = self->priv->game;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp34_ = _tmp33_->mode;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = _tmp34_ == GAME_MODE_PLAY;
#line 605 "sudoku-view.c"
		} else {
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = FALSE;
#line 609 "sudoku-view.c"
		}
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp28_) {
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 615 "sudoku-view.c"
		}
	}
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 622 "sudoku-view.c"
}


static void __lambda7_ (SudokuCellView* self, gint number, gboolean state) {
	gboolean _tmp0_;
	SudokuGame* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = state;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 639 "sudoku-view.c"
		SudokuGame* _tmp1_;
		SudokuBoard* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->game;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp1_->board;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = self->priv->row;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = number;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_enable_earmark (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 657 "sudoku-view.c"
	} else {
		SudokuGame* _tmp6_;
		SudokuBoard* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->board;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = number;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_disable_earmark (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 676 "sudoku-view.c"
	}
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->game;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->row;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->col;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_value (self);
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_emit_by_name (_tmp11_, "cell-changed", _tmp12_, _tmp13_, _tmp15_, _tmp17_);
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 696 "sudoku-view.c"
}


static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	__lambda7_ ((SudokuCellView*) self, number, active);
#line 703 "sudoku-view.c"
}


static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self) {
	SudokuGame* _tmp0_;
	NumberPicker* _tmp1_;
	NumberPicker* _tmp2_;
	NumberPicker* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number_picker_new (&_tmp0_->board, TRUE);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp1_);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_picker = _tmp1_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->earmark_picker;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp2_, "earmark-state-changed", (GCallback) ___lambda7__number_picker_earmark_state_changed, self, 0);
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_picker;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->row;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->col;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_earmarks (_tmp3_, _tmp4_, _tmp5_);
#line 738 "sudoku-view.c"
}


static void __lambda10_ (SudokuCellView* self, NumberPicker* o, gint number) {
	gint _tmp0_;
	gint _tmp1_;
	SudokuGame* _tmp2_;
	SudokuBoard* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkPopover* _tmp6_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (o != NULL);
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = number;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp0_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == 0) {
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 762 "sudoku-view.c"
	}
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->game;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp2_->board;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->row;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->col;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_board_disable_all_earmarks (_tmp3_, _tmp4_, _tmp5_);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->popover;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 778 "sudoku-view.c"
}


static void ___lambda10__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	__lambda10_ ((SudokuCellView*) self, _sender, number);
#line 785 "sudoku-view.c"
}


static void __lambda11_ (SudokuCellView* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp2_) {
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_destroy_popover (self, &self->priv->popover);
#line 803 "sudoku-view.c"
	}
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	__lambda11_ ((SudokuCellView*) self);
#line 811 "sudoku-view.c"
}


static gboolean __lambda12_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 826 "sudoku-view.c"
}


static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda12_ ((SudokuCellView*) self);
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 835 "sudoku-view.c"
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_;
	SudokuGame* _tmp2_;
	NumberPicker* _tmp3_;
	NumberPicker* _tmp4_;
	NumberPicker* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
	NumberPicker* _tmp10_;
	GtkPopover* _tmp11_;
	GtkPopover* _tmp12_;
	GtkPopover* _tmp13_;
	GtkPopover* _tmp14_;
	GtkPopover* _tmp15_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 861 "sudoku-view.c"
		GtkPopover* _tmp1_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->earmark_popover;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 867 "sudoku-view.c"
	}
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->game;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = number_picker_new (&_tmp2_->board, FALSE);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp3_);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->number_picker = _tmp3_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->number_picker;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp4_, "number-picked", (GCallback) ___lambda10__number_picker_number_picked, self, 0);
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->number_picker;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = sudoku_cell_view_get_value (self);
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp6_;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_clear_button_visibility (_tmp5_, _tmp7_ != 0);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp8_);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->popover = _tmp8_;
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = self->priv->popover;
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->number_picker;
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->popover;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp11_, FALSE);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->popover;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp12_, GTK_POS_BOTTOM);
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->popover;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GObject*) _tmp13_, "notify::visible", (GCallback) ___lambda11__g_object_notify, self, 0);
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->popover;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp14_, "focus-out-event", (GCallback) ___lambda12__gtk_widget_focus_out_event, self, 0);
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->popover;
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp15_);
#line 925 "sudoku-view.c"
}


static void __lambda8_ (SudokuCellView* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp2_) {
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_destroy_popover (self, &self->priv->earmark_popover);
#line 943 "sudoku-view.c"
	}
}


static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	__lambda8_ ((SudokuCellView*) self);
#line 951 "sudoku-view.c"
}


static gboolean __lambda9_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 966 "sudoku-view.c"
}


static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda9_ ((SudokuCellView*) self);
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 975 "sudoku-view.c"
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_;
	GtkPopover* _tmp2_;
	GtkPopover* _tmp3_;
	NumberPicker* _tmp4_;
	GtkPopover* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 995 "sudoku-view.c"
		GtkPopover* _tmp1_;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->popover;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1001 "sudoku-view.c"
	}
#line 208 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_create_earmark_picker (self);
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_popover = _tmp2_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_popover;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->earmark_picker;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->earmark_popover;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp5_, FALSE);
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->earmark_popover;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp6_, GTK_POS_BOTTOM);
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = self->priv->earmark_popover;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::visible", (GCallback) ___lambda8__g_object_notify, self, 0);
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = self->priv->earmark_popover;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp8_, "focus-out-event", (GCallback) ___lambda9__gtk_widget_focus_out_event, self, 0);
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = self->priv->earmark_popover;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 1039 "sudoku-view.c"
}


static void sudoku_cell_view_destroy_popover (SudokuCellView* self, GtkPopover* * popover) {
	GtkPopover* _tmp0_;
#line 226 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (*popover != NULL);
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *popover;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 1053 "sudoku-view.c"
		GtkPopover* _tmp1_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = *popover;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (*popover);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		*popover = NULL;
#line 1063 "sudoku-view.c"
	}
}


static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self) {
	GtkPopover* _tmp0_;
	GtkPopover* _tmp2_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 1077 "sudoku-view.c"
		GtkPopover* _tmp1_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->popover;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1083 "sudoku-view.c"
	}
#line 239 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->earmark_popover;
#line 239 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != NULL) {
#line 1089 "sudoku-view.c"
		GtkPopover* _tmp3_;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = self->priv->earmark_popover;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 1095 "sudoku-view.c"
	}
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_hide_both_popovers (self);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1114 "sudoku-view.c"
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (key_name != NULL, 0);
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = key_name;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 1141 "sudoku-view.c"
	} else {
		const gchar* _tmp2_;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = key_name;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
#line 1148 "sudoku-view.c"
	}
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 0;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1156 "sudoku-view.c"
	}
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = key_name;
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
#line 256 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 1;
#line 256 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1166 "sudoku-view.c"
	}
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = key_name;
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 2;
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1176 "sudoku-view.c"
	}
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = key_name;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
#line 260 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 3;
#line 260 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1186 "sudoku-view.c"
	}
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = key_name;
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 4;
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1196 "sudoku-view.c"
	}
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = key_name;
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 5;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1206 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = key_name;
#line 265 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 6;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1216 "sudoku-view.c"
	}
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = key_name;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 7;
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1226 "sudoku-view.c"
	}
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = key_name;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 8;
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1236 "sudoku-view.c"
	}
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = key_name;
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = 9;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1246 "sudoku-view.c"
	}
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = -1;
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1252 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	gchar* k_name = NULL;
	GdkEventKey* _tmp9_;
	guint _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gint k_no = 0;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	const gchar* _tmp67_;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->game;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->mode;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ == GAME_MODE_PLAY) {
#line 1290 "sudoku-view.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = sudoku_cell_view_get_is_fixed (self);
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _tmp4_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp5_) {
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp3_ = TRUE;
#line 1302 "sudoku-view.c"
		} else {
			SudokuGame* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp6_ = self->priv->game;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp7_ = sudoku_game_get_paused (_tmp6_);
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp8_ = _tmp7_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp3_ = _tmp8_;
#line 1315 "sudoku-view.c"
		}
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_;
#line 1319 "sudoku-view.c"
	} else {
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 1323 "sudoku-view.c"
	}
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1331 "sudoku-view.c"
	}
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = event;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _tmp9_->keyval;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = gdk_keyval_name (_tmp10_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	k_name = _tmp12_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = k_name;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = atoi (_tmp13_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	k_no = _tmp14_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = k_no;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp15_ == 0) {
#line 1353 "sudoku-view.c"
		const gchar* _tmp16_;
		gint _tmp17_;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = k_name;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = sudoku_cell_view_key_map_keypad (self, _tmp16_);
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		k_no = _tmp17_;
#line 1362 "sudoku-view.c"
	}
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = k_no;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp19_ >= 1) {
#line 1368 "sudoku-view.c"
		gint _tmp20_;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = k_no;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = _tmp20_ <= 9;
#line 1374 "sudoku-view.c"
	} else {
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = FALSE;
#line 1378 "sudoku-view.c"
	}
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp18_) {
#line 1382 "sudoku-view.c"
		gboolean _tmp21_ = FALSE;
		GdkEventKey* _tmp22_;
		GdkModifierType _tmp23_;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = event;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->state;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if ((_tmp23_ & GDK_CONTROL_MASK) > 0) {
#line 1392 "sudoku-view.c"
			SudokuGame* _tmp24_;
			GameMode _tmp25_;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = self->priv->game;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->mode;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp25_ == GAME_MODE_PLAY;
#line 1401 "sudoku-view.c"
		} else {
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = FALSE;
#line 1405 "sudoku-view.c"
		}
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp21_) {
#line 1409 "sudoku-view.c"
			gboolean new_state = FALSE;
			SudokuGame* _tmp26_;
			SudokuBoard* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gboolean _tmp31_;
			NumberPicker* _tmp32_;
			NumberPicker* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gboolean _tmp37_;
			gboolean _tmp38_;
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = self->priv->game;
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = _tmp26_->board;
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = self->priv->row;
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->col;
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp30_ = k_no;
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = sudoku_board_is_earmark_enabled (_tmp27_, _tmp28_, _tmp29_, _tmp30_);
#line 289 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			new_state = !_tmp31_;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp32_ = self->priv->earmark_picker;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp32_ == NULL) {
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_create_earmark_picker (self);
#line 1444 "sudoku-view.c"
			}
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp33_ = self->priv->earmark_picker;
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp34_ = self->priv->row;
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp35_ = self->priv->col;
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp36_ = k_no;
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp37_ = new_state;
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp38_ = number_picker_set_earmark (_tmp33_, _tmp34_, _tmp35_, _tmp36_ - 1, _tmp37_);
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp38_) {
#line 1460 "sudoku-view.c"
				gboolean _tmp39_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = new_state;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp39_) {
#line 1466 "sudoku-view.c"
					SudokuGame* _tmp40_;
					SudokuBoard* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp40_ = self->priv->game;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp41_ = _tmp40_->board;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp42_ = self->priv->row;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp43_ = self->priv->col;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp44_ = k_no;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_enable_earmark (_tmp41_, _tmp42_, _tmp43_, _tmp44_);
#line 1484 "sudoku-view.c"
				} else {
					SudokuGame* _tmp45_;
					SudokuBoard* _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp45_ = self->priv->game;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp46_ = _tmp45_->board;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp47_ = self->priv->row;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp48_ = self->priv->col;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp49_ = k_no;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_disable_earmark (_tmp46_, _tmp47_, _tmp48_, _tmp49_);
#line 1503 "sudoku-view.c"
				}
#line 298 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				gtk_widget_queue_draw ((GtkWidget*) self);
#line 1507 "sudoku-view.c"
			}
		} else {
			gint _tmp50_;
			SudokuGame* _tmp51_;
			SudokuBoard* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
#line 303 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = k_no;
#line 303 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_set_value (self, _tmp50_);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp51_ = self->priv->game;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp52_ = _tmp51_->board;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp53_ = self->priv->row;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp54_ = self->priv->col;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_board_disable_all_earmarks (_tmp52_, _tmp53_, _tmp54_);
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_hide_both_popovers (self);
#line 1531 "sudoku-view.c"
		}
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1539 "sudoku-view.c"
	}
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp57_ = k_no;
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp57_ == 0) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = TRUE;
#line 1547 "sudoku-view.c"
	} else {
		const gchar* _tmp58_;
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp58_ = k_name;
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = g_strcmp0 (_tmp58_, "BackSpace") == 0;
#line 1554 "sudoku-view.c"
	}
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp56_) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = TRUE;
#line 1560 "sudoku-view.c"
	} else {
		const gchar* _tmp59_;
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = k_name;
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = g_strcmp0 (_tmp59_, "Delete") == 0;
#line 1567 "sudoku-view.c"
	}
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp55_) {
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, 0);
#line 312 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1581 "sudoku-view.c"
	}
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = k_name;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp62_, "space") == 0) {
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = TRUE;
#line 1589 "sudoku-view.c"
	} else {
		const gchar* _tmp63_;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = k_name;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = g_strcmp0 (_tmp63_, "Return") == 0;
#line 1596 "sudoku-view.c"
	}
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp61_) {
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = TRUE;
#line 1602 "sudoku-view.c"
	} else {
		const gchar* _tmp64_;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = k_name;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = g_strcmp0 (_tmp64_, "KP_Enter") == 0;
#line 1609 "sudoku-view.c"
	}
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp60_) {
#line 1613 "sudoku-view.c"
		GtkPopover* _tmp65_;
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp65_ = self->priv->popover;
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp65_ != NULL) {
#line 1619 "sudoku-view.c"
			GtkPopover* _tmp66_;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = self->priv->popover;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			gtk_widget_hide ((GtkWidget*) _tmp66_);
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			result = FALSE;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (k_name);
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			return result;
#line 1631 "sudoku-view.c"
		}
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_show_number_picker (self);
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1641 "sudoku-view.c"
	}
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = k_name;
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp67_, "Escape") == 0) {
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 330 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 330 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 330 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1655 "sudoku-view.c"
	}
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_free0 (k_name);
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1663 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	SudokuGame* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp47_;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_;
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->layout;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	glyph_width = _tmp1_;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	glyph_height = _tmp2_;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->_show_warnings;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp4_) {
#line 1704 "sudoku-view.c"
		SudokuGame* _tmp5_;
		SudokuBoard* _tmp6_;
		GeeSet* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		Coord _tmp10_ = {0};
		gboolean _tmp11_;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->game;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->broken_coords;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp11_;
#line 1728 "sudoku-view.c"
	} else {
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = FALSE;
#line 1732 "sudoku-view.c"
	}
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 1736 "sudoku-view.c"
		cairo_t* _tmp12_;
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = c;
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp12_, 1.0, 0.0, 0.0);
#line 1742 "sudoku-view.c"
	} else {
		gboolean _tmp13_;
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->_selected;
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp13_) {
#line 1749 "sudoku-view.c"
			cairo_t* _tmp14_;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = c;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp14_, 0.2, 0.2, 0.2);
#line 1755 "sudoku-view.c"
		} else {
			cairo_t* _tmp15_;
#line 345 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = c;
#line 345 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp15_, 0.0, 0.0, 0.0);
#line 1762 "sudoku-view.c"
		}
	}
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = self->priv->game;
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = sudoku_game_get_paused (_tmp16_);
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = _tmp17_;
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp18_) {
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1777 "sudoku-view.c"
	}
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = sudoku_cell_view_get_value (self);
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _tmp19_;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp20_ != 0) {
#line 1785 "sudoku-view.c"
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp21_;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_;
		gdouble scale = 0.0;
		gint _tmp25_;
		gdouble _tmp26_;
		gint _tmp27_;
		cairo_t* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gdouble _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gdouble _tmp34_;
		cairo_t* _tmp35_;
		cairo_t* _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		cairo_t* _tmp39_;
		PangoLayout* _tmp40_;
		cairo_t* _tmp41_;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = self->priv->layout;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_get_size (_tmp21_, &_tmp22_, &_tmp23_);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		width = _tmp22_;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp23_;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = height;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp24_ / PANGO_SCALE;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = self->priv->size_ratio;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = height;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		scale = (((gdouble) _tmp25_) / _tmp26_) / _tmp27_;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = c;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp29_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = glyph_width;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp31_ = scale;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = glyph_height;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp34_ = scale;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp28_, (_tmp29_ - (_tmp30_ * _tmp31_)) / 2, (_tmp32_ - (_tmp33_ * _tmp34_)) / 2);
#line 358 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp35_ = c;
#line 358 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_save (_tmp35_);
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = c;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = scale;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = scale;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp36_, _tmp37_, _tmp38_);
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp39_ = c;
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = self->priv->layout;
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		pango_cairo_show_layout (_tmp39_, _tmp40_);
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = c;
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_restore (_tmp41_);
#line 1868 "sudoku-view.c"
	}
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp43_ = sudoku_cell_view_get_is_fixed (self);
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp44_ = _tmp43_;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp44_) {
#line 1876 "sudoku-view.c"
		SudokuGame* _tmp45_;
		GameMode _tmp46_;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = self->priv->game;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = _tmp45_->mode;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = _tmp46_ == GAME_MODE_PLAY;
#line 1885 "sudoku-view.c"
	} else {
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = FALSE;
#line 1889 "sudoku-view.c"
	}
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp42_) {
#line 365 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 365 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1897 "sudoku-view.c"
	}
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp47_ = self->priv->_show_possibilities;
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp47_) {
#line 1903 "sudoku-view.c"
		gdouble earmark_size = 0.0;
		gint _tmp48_;
		gdouble _tmp49_;
		cairo_t* _tmp50_;
		gdouble _tmp51_;
		cairo_t* _tmp52_;
		gdouble _tmp53_;
		cairo_t* _tmp54_;
		cairo_t* _tmp55_;
		SudokuGame* _tmp56_;
		SudokuBoard* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = self->priv->size_ratio;
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		earmark_size = _tmp48_ / (_tmp49_ * 2);
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = c;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp51_ = earmark_size;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp50_, _tmp51_);
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = c;
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = earmark_size;
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp52_, (gdouble) 0, _tmp53_);
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp54_ = c;
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp54_, 0.0, 0.0, 0.0);
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = c;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = self->priv->game;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp57_ = _tmp56_->board;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp58_ = self->priv->row;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = self->priv->col;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = sudoku_board_get_earmarks_string (_tmp57_, _tmp58_, _tmp59_);
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = _tmp60_;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp55_, _tmp61_);
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (_tmp61_);
#line 1959 "sudoku-view.c"
	} else {
		gint _tmp62_;
		gint _tmp63_;
#line 378 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = sudoku_cell_view_get_value (self);
#line 378 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = _tmp62_;
#line 378 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp63_ == 0) {
#line 1969 "sudoku-view.c"
			gdouble possibility_size = 0.0;
			gint _tmp64_;
			gdouble _tmp65_;
			cairo_t* _tmp66_;
			gdouble _tmp67_;
			cairo_t* _tmp68_;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp69_;
			SudokuBoard* _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			gboolean* _tmp74_;
			gint possibilities_length1;
			gint _possibilities_size_;
			gint height = 0;
			gint _tmp75_;
			SudokuGame* _tmp76_;
			SudokuBoard* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint width = 0;
			gint _tmp80_;
			SudokuGame* _tmp81_;
			SudokuBoard* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			gint num = 0;
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp64_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp65_ = self->priv->size_ratio;
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			possibility_size = _tmp64_ / (_tmp65_ * 2);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = c;
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp67_ = possibility_size;
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_font_size (_tmp66_, _tmp67_);
#line 382 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp68_ = c;
#line 382 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp68_, 0.0, 0.0, 0.0);
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = self->priv->game;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp70_ = _tmp69_->board;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp71_ = self->priv->row;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp72_ = self->priv->col;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp74_ = sudoku_board_get_possibilities_as_bool_array (_tmp70_, _tmp71_, _tmp72_, &_tmp73_);
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			possibilities = _tmp74_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			possibilities_length1 = _tmp73_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_possibilities_size_ = possibilities_length1;
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp75_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp76_ = self->priv->game;
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = _tmp76_->board;
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = sudoku_board_get_block_cols (_tmp77_);
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp79_ = _tmp78_;
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			height = _tmp75_ / _tmp79_;
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = self->priv->game;
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = _tmp81_->board;
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = sudoku_board_get_block_rows (_tmp82_);
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = _tmp83_;
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			width = _tmp80_ / _tmp84_;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			num = 0;
#line 2056 "sudoku-view.c"
			{
				gint row_tmp = 0;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				row_tmp = 0;
#line 2061 "sudoku-view.c"
				{
					gboolean _tmp85_ = FALSE;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp85_ = TRUE;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					while (TRUE) {
#line 2068 "sudoku-view.c"
						gint _tmp87_;
						SudokuGame* _tmp88_;
						SudokuBoard* _tmp89_;
						gint _tmp90_;
						gint _tmp91_;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						if (!_tmp85_) {
#line 2076 "sudoku-view.c"
							gint _tmp86_;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp86_ = row_tmp;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							row_tmp = _tmp86_ + 1;
#line 2082 "sudoku-view.c"
						}
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp85_ = FALSE;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp87_ = row_tmp;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp88_ = self->priv->game;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp89_ = _tmp88_->board;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp90_ = sudoku_board_get_block_rows (_tmp89_);
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp91_ = _tmp90_;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						if (!(_tmp87_ < _tmp91_)) {
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							break;
#line 2100 "sudoku-view.c"
						}
						{
							gint col_tmp = 0;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							col_tmp = 0;
#line 2106 "sudoku-view.c"
							{
								gboolean _tmp92_ = FALSE;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp92_ = TRUE;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								while (TRUE) {
#line 2113 "sudoku-view.c"
									gint _tmp94_;
									SudokuGame* _tmp95_;
									SudokuBoard* _tmp96_;
									gint _tmp97_;
									gint _tmp98_;
									gint _tmp99_;
									gboolean* _tmp100_;
									gint _tmp100__length1;
									gint _tmp101_;
									gboolean _tmp102_;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									if (!_tmp92_) {
#line 2126 "sudoku-view.c"
										gint _tmp93_;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp93_ = col_tmp;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										col_tmp = _tmp93_ + 1;
#line 2132 "sudoku-view.c"
									}
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp92_ = FALSE;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp94_ = col_tmp;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp95_ = self->priv->game;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp96_ = _tmp95_->board;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp97_ = sudoku_board_get_block_cols (_tmp96_);
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp98_ = _tmp97_;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									if (!(_tmp94_ < _tmp98_)) {
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										break;
#line 2150 "sudoku-view.c"
									}
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp99_ = num;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									num = _tmp99_ + 1;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp100_ = possibilities;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp100__length1 = possibilities_length1;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp101_ = num;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									_tmp102_ = _tmp100_[_tmp101_ - 1];
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
									if (_tmp102_) {
#line 2166 "sudoku-view.c"
										cairo_t* _tmp103_;
										gint _tmp104_;
										gint _tmp105_;
										gint _tmp106_;
										gint _tmp107_;
										gdouble _tmp108_;
										cairo_t* _tmp109_;
										gint _tmp110_;
										gchar* _tmp111_;
										gchar* _tmp112_;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp103_ = c;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp104_ = col_tmp;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp105_ = width;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp106_ = row_tmp;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp107_ = height;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp108_ = possibility_size;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										cairo_move_to (_tmp103_, (gdouble) (_tmp104_ * _tmp105_), (_tmp106_ * _tmp107_) + _tmp108_);
#line 399 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp109_ = c;
#line 399 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp110_ = num;
#line 399 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp111_ = g_strdup_printf ("%d", _tmp110_);
#line 399 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_tmp112_ = _tmp111_;
#line 399 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										cairo_show_text (_tmp109_, _tmp112_);
#line 399 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
										_g_free0 (_tmp112_);
#line 2203 "sudoku-view.c"
									}
								}
							}
						}
					}
				}
			}
#line 378 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			possibilities = (g_free (possibilities), NULL);
#line 2213 "sudoku-view.c"
		}
	}
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp114_ = self->priv->_show_warnings;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp114_) {
#line 2220 "sudoku-view.c"
		gboolean _tmp115_ = FALSE;
		gint _tmp116_;
		gint _tmp117_;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp116_ = sudoku_cell_view_get_value (self);
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp117_ = _tmp116_;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp117_ == 0) {
#line 2230 "sudoku-view.c"
			SudokuGame* _tmp118_;
			SudokuBoard* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			gint _tmp122_;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp118_ = self->priv->game;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp119_ = _tmp118_->board;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp120_ = self->priv->row;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp121_ = self->priv->col;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp122_ = sudoku_board_count_possibilities (_tmp119_, _tmp120_, _tmp121_);
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = _tmp122_ == 0;
#line 2248 "sudoku-view.c"
		} else {
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = FALSE;
#line 2252 "sudoku-view.c"
		}
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp113_ = _tmp115_;
#line 2256 "sudoku-view.c"
	} else {
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp113_ = FALSE;
#line 2260 "sudoku-view.c"
	}
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp113_) {
#line 2264 "sudoku-view.c"
		gchar* warning = NULL;
		gchar* _tmp123_;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp124_;
		gint _tmp125_;
		cairo_t* _tmp126_;
		const gchar* _tmp127_;
		cairo_text_extents_t _tmp128_ = {0};
		cairo_t* _tmp129_;
		gint _tmp130_;
		cairo_text_extents_t _tmp131_;
		gdouble _tmp132_;
		gint _tmp133_;
		cairo_text_extents_t _tmp134_;
		gdouble _tmp135_;
		cairo_t* _tmp136_;
		cairo_t* _tmp137_;
		const gchar* _tmp138_;
#line 407 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp123_ = g_strdup ("X");
#line 407 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		warning = _tmp123_;
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp124_ = c;
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp125_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp124_, (gdouble) (_tmp125_ / 2));
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp126_ = c;
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp127_ = warning;
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp126_, _tmp127_, &_tmp128_);
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp128_;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp129_ = c;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = extents;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = _tmp131_.width;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp133_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp134_ = extents;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp135_ = _tmp134_.height;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp129_, ((_tmp130_ - _tmp132_) / 2) - 1, ((_tmp133_ + _tmp135_) / 2) + 1);
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp136_ = c;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp136_, 1.0, 0.0, 0.0);
#line 413 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp137_ = c;
#line 413 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp138_ = warning;
#line 413 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp137_, _tmp138_);
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (warning);
#line 2329 "sudoku-view.c"
	}
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2335 "sudoku-view.c"
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = row;
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == _tmp2_) {
#line 2351 "sudoku-view.c"
		gint _tmp3_;
		gint _tmp4_;
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = col;
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2360 "sudoku-view.c"
	} else {
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 2364 "sudoku-view.c"
	}
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 2368 "sudoku-view.c"
		gint _tmp5_;
		SudokuGame* _tmp6_;
		GameMode _tmp7_;
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = new_val;
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, _tmp5_);
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->mode;
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp7_ == GAME_MODE_CREATE) {
#line 2382 "sudoku-view.c"
			gboolean _tmp8_;
#line 427 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp8_ = self->priv->_selected;
#line 427 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp8_) {
#line 428 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (self, &selected_bg_color);
#line 2390 "sudoku-view.c"
			} else {
				GdkRGBA _tmp9_ = {0};
				gboolean _tmp10_;
				gboolean _tmp11_;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp10_ = sudoku_cell_view_get_is_fixed (self);
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = _tmp10_;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp11_) {
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = fixed_cell_color;
#line 2403 "sudoku-view.c"
				} else {
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = free_cell_color;
#line 2407 "sudoku-view.c"
				}
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (self, &_tmp9_);
#line 2411 "sudoku-view.c"
			}
		}
#line 433 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 2416 "sudoku-view.c"
	}
}


void sudoku_cell_view_clear (SudokuCellView* self) {
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 437 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_board_disable_all_earmarks (_tmp1_, _tmp2_, _tmp3_);
#line 2438 "sudoku-view.c"
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp4_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2465 "sudoku-view.c"
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp16_;
	gint _tmp34_;
	SudokuGame* _tmp35_;
	SudokuBoard* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	PangoLayout* _tmp48_;
	SudokuGame* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 2492 "sudoku-view.c"
		gchar* text = NULL;
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		PangoLayout* _tmp9_;
		PangoLayout* _tmp10_;
		GtkStyle* _tmp11_;
		GtkStyle* _tmp12_;
		PangoFontDescription* _tmp13_;
		SudokuGame* _tmp14_;
		GameMode _tmp15_;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = self->priv->game;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp2_->board;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->row;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->col;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp7_;
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = text;
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp9_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = self->priv->layout;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_->font_desc;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp10_, _tmp13_);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = self->priv->game;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp14_->mode;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp15_ == GAME_MODE_PLAY) {
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (text);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			return;
#line 2550 "sudoku-view.c"
		}
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 2554 "sudoku-view.c"
	}
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = value;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp16_ == 0) {
#line 2560 "sudoku-view.c"
		gchar* text = NULL;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		PangoLayout* _tmp19_;
		PangoLayout* _tmp20_;
		GtkStyle* _tmp21_;
		GtkStyle* _tmp22_;
		PangoFontDescription* _tmp23_;
		SudokuGame* _tmp24_;
		SudokuBoard* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		SudokuGame* _tmp32_;
		GameMode _tmp33_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = g_strdup ("");
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp17_;
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = text;
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp18_);
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp19_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = self->priv->layout;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = gtk_widget_get_style ((GtkWidget*) self);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = _tmp21_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->font_desc;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp20_, _tmp23_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = self->priv->game;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = _tmp24_->board;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = self->priv->row;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = self->priv->col;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = sudoku_board_get (_tmp25_, _tmp26_, _tmp27_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp28_ != 0) {
#line 2610 "sudoku-view.c"
			SudokuGame* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->game;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp30_ = self->priv->row;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = self->priv->col;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_game_remove (_tmp29_, _tmp30_, _tmp31_);
#line 2622 "sudoku-view.c"
		}
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = self->priv->game;
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = _tmp32_->mode;
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp33_ == GAME_MODE_PLAY) {
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (text);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			return;
#line 2634 "sudoku-view.c"
		}
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 2638 "sudoku-view.c"
	}
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = value;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = self->priv->game;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp36_ = _tmp35_->board;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp37_ = self->priv->row;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp38_ = self->priv->col;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp39_ = sudoku_board_get (_tmp36_, _tmp37_, _tmp38_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp34_ == _tmp39_) {
#line 2654 "sudoku-view.c"
		gchar* text = NULL;
		gint _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		PangoLayout* _tmp43_;
		PangoLayout* _tmp44_;
		GtkStyle* _tmp45_;
		GtkStyle* _tmp46_;
		PangoFontDescription* _tmp47_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = value;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = g_strdup_printf ("%d", _tmp40_);
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp41_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = text;
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp42_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp43_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = self->priv->layout;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = gtk_widget_get_style ((GtkWidget*) self);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = _tmp45_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = _tmp46_->font_desc;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp44_, _tmp47_);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2692 "sudoku-view.c"
	}
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = self->priv->layout;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_vala_assert (_tmp48_ != NULL, "layout != null");
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = self->priv->game;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp50_ = self->priv->row;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp51_ = self->priv->col;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp52_ = value;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_game_insert (_tmp49_, _tmp50_, _tmp51_, _tmp52_);
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_VALUE_PROPERTY]);
#line 2710 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->is_fixed;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length1 = _tmp1_->is_fixed_length1;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length2 = _tmp1_->is_fixed_length2;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->row;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->col;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp5_;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2746 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2761 "sudoku-view.c"
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
#line 2777 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2792 "sudoku-view.c"
}


void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY]);
#line 2808 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_selected;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2823 "sudoku-view.c"
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (sudoku_cell_view_get_selected (self) != value) {
#line 2832 "sudoku-view.c"
		gboolean _tmp0_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = value;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self->priv->_selected = _tmp0_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SELECTED_PROPERTY]);
#line 2840 "sudoku-view.c"
	}
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA * result) {
	GdkRGBA _tmp0_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_background_color;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	*result = _tmp0_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return;
#line 2855 "sudoku-view.c"
}


static gboolean _gdk_rgba_equal (const GdkRGBA * s1, const GdkRGBA * s2) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s1 == s2) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return TRUE;
#line 2864 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s1 == NULL) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return FALSE;
#line 2870 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s2 == NULL) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return FALSE;
#line 2876 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s1->red != s2->red) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return FALSE;
#line 2882 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s1->green != s2->green) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return FALSE;
#line 2888 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s1->blue != s2->blue) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return FALSE;
#line 2894 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (s1->alpha != s2->alpha) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return FALSE;
#line 2900 "sudoku-view.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return TRUE;
#line 2904 "sudoku-view.c"
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA * value) {
	GdkRGBA old_value;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_gdk_rgba_equal (value, (sudoku_cell_view_get_background_color (self, &old_value), &old_value)) != TRUE) {
#line 2914 "sudoku-view.c"
		GdkRGBA _tmp0_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = *value;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self->priv->_background_color = _tmp0_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY]);
#line 2922 "sudoku-view.c"
	}
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) sudoku_cell_view_real_button_press_event;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) sudoku_cell_view_real_key_press_event;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) sudoku_cell_view_real_draw;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY] = g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY] = g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2956 "sudoku-view.c"
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->size_ratio = (gdouble) 2;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = TRUE;
#line 2967 "sudoku-view.c"
}


static void sudoku_cell_view_finalize (GObject * obj) {
	SudokuCellView * self;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->layout);
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
#line 2989 "sudoku-view.c"
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_int (value, sudoku_cell_view_get_value (self));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY:
#line 3042 "sudoku-view.c"
		{
			GdkRGBA boxed;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_get_background_color (self, &boxed);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			g_value_set_boxed (value, &boxed);
#line 3049 "sudoku-view.c"
		}
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 3053 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 3059 "sudoku-view.c"
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, g_value_get_int (value));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 3099 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 3105 "sudoku-view.c"
	}
}


static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col) {
	SudokuCellView** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	SudokuCellView* _tmp3_;
	SudokuCellView** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint _tmp6_;
	SudokuCellView* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	SudokuCellView** _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gint _tmp11_;
	gint _tmp12_;
	SudokuCellView* _tmp13_;
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->cells;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length1 = self->priv->cells_length1;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length2 = self->priv->cells_length2;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->selected_row;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->selected_col;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->cells;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length1 = self->priv->cells_length1;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length2 = self->priv->cells_length2;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->selected_row;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->selected_col;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = cell_row;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = _tmp8_;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = cell_col;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = _tmp9_;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->cells;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length1 = self->priv->cells_length1;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length2 = self->priv->cells_length2;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->selected_row;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->selected_col;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp13_, TRUE);
#line 3183 "sudoku-view.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return _data5_;
#line 3192 "sudoku-view.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 3201 "sudoku-view.c"
		SudokuView* self;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self = _data5_->self;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_data5_->game);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block5Data, _data5_);
#line 3211 "sudoku-view.c"
	}
}


static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3221 "sudoku-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return _data6_;
#line 3230 "sudoku-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3239 "sudoku-view.c"
		SudokuView* self;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self = _data6_->_data5_->self;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		block5_data_unref (_data6_->_data5_);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_data6_->_data5_ = NULL;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 3249 "sudoku-view.c"
	}
}


static gboolean ________lambda13_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean result = FALSE;
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	SudokuCellView** _tmp113_;
	gint _tmp113__length1;
	gint _tmp113__length2;
	gint _tmp114_;
	gint _tmp115_;
	SudokuCellView* _tmp116_;
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = _data6_->_data5_;
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = _data5_->game;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 3285 "sudoku-view.c"
	}
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _data6_->cell_row;
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data6_->cell_col;
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_set_selected (self, _tmp3_, _tmp4_);
#line 3293 "sudoku-view.c"
	{
		gint col_tmp = 0;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3298 "sudoku-view.c"
		{
			gboolean _tmp5_ = FALSE;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp5_ = TRUE;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3305 "sudoku-view.c"
				gint _tmp7_;
				SudokuGame* _tmp8_;
				SudokuBoard* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GdkRGBA _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				gint _tmp14_;
				gint _tmp15_;
				GdkRGBA color = {0};
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp5_) {
#line 3318 "sudoku-view.c"
					gint _tmp6_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp6_ = col_tmp;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp6_ + 1;
#line 3324 "sudoku-view.c"
				}
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = FALSE;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = col_tmp;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp8_ = _data5_->game;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp9_ = _tmp8_->board;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp10_ = sudoku_board_get_cols (_tmp9_);
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = _tmp10_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp7_ < _tmp11_)) {
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3342 "sudoku-view.c"
				}
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = col_tmp;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _data6_->cell_col;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp14_ == _tmp15_) {
#line 3350 "sudoku-view.c"
					gboolean _tmp16_;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp16_ = self->priv->_highlighter;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp13_ = _tmp16_;
#line 3356 "sudoku-view.c"
				} else {
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp13_ = FALSE;
#line 3360 "sudoku-view.c"
				}
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp13_) {
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = highlight_color;
#line 3366 "sudoku-view.c"
				} else {
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = free_cell_color;
#line 3370 "sudoku-view.c"
				}
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				color = _tmp12_;
#line 3374 "sudoku-view.c"
				{
					gint row_tmp = 0;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					row_tmp = 0;
#line 3379 "sudoku-view.c"
					{
						gboolean _tmp17_ = FALSE;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp17_ = TRUE;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3386 "sudoku-view.c"
							gint _tmp19_;
							SudokuGame* _tmp20_;
							SudokuBoard* _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							GdkRGBA _tmp24_ = {0};
							SudokuCellView** _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							gint _tmp26_;
							gint _tmp27_;
							SudokuCellView* _tmp28_;
							gboolean _tmp29_;
							gboolean _tmp30_;
							SudokuCellView** _tmp32_;
							gint _tmp32__length1;
							gint _tmp32__length2;
							gint _tmp33_;
							gint _tmp34_;
							SudokuCellView* _tmp35_;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp17_) {
#line 3409 "sudoku-view.c"
								gint _tmp18_;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp18_ = row_tmp;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								row_tmp = _tmp18_ + 1;
#line 3415 "sudoku-view.c"
							}
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = FALSE;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = row_tmp;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = _data5_->game;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = _tmp20_->board;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = sudoku_board_get_rows (_tmp21_);
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = _tmp22_;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp19_ < _tmp23_)) {
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3433 "sudoku-view.c"
							}
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = row_tmp;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = col_tmp;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp29_ = sudoku_cell_view_get_is_fixed (_tmp28_);
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp30_) {
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp24_ = fixed_cell_color;
#line 3455 "sudoku-view.c"
							} else {
								GdkRGBA _tmp31_;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp31_ = color;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp24_ = _tmp31_;
#line 3462 "sudoku-view.c"
							}
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = self->priv->cells;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp32__length1 = self->priv->cells_length1;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp32__length2 = self->priv->cells_length2;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = row_tmp;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col_tmp;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp35_, &_tmp24_);
#line 3478 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3489 "sudoku-view.c"
		{
			gboolean _tmp36_ = FALSE;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp36_ = TRUE;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3496 "sudoku-view.c"
				gint _tmp38_;
				SudokuGame* _tmp39_;
				SudokuBoard* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				SudokuCellView** _tmp43_;
				gint _tmp43__length1;
				gint _tmp43__length2;
				gint _tmp44_;
				gint _tmp45_;
				SudokuCellView* _tmp46_;
				gboolean _tmp47_;
				gboolean _tmp48_;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp36_) {
#line 3512 "sudoku-view.c"
					gint _tmp37_;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp37_ = col_tmp;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp37_ + 1;
#line 3518 "sudoku-view.c"
				}
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp36_ = FALSE;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp38_ = col_tmp;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = _data5_->game;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp40_ = _tmp39_->board;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp41_ = sudoku_board_get_cols (_tmp40_);
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp42_ = _tmp41_;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp38_ < _tmp42_)) {
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3536 "sudoku-view.c"
				}
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp43_ = self->priv->cells;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp43__length1 = self->priv->cells_length1;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp43__length2 = self->priv->cells_length2;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp44_ = _data6_->cell_row;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp45_ = col_tmp;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp47_ = sudoku_cell_view_get_is_fixed (_tmp46_);
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp48_ = _tmp47_;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp48_) {
#line 3556 "sudoku-view.c"
					SudokuCellView** _tmp49_;
					gint _tmp49__length1;
					gint _tmp49__length2;
					gint _tmp50_;
					gint _tmp51_;
					SudokuCellView* _tmp52_;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp49_ = self->priv->cells;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp49__length1 = self->priv->cells_length1;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp49__length2 = self->priv->cells_length2;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp50_ = _data6_->cell_row;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = col_tmp;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp52_, &fixed_cell_color);
#line 3577 "sudoku-view.c"
				} else {
					gboolean _tmp53_;
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp53_ = self->priv->_highlighter;
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					if (_tmp53_) {
#line 3584 "sudoku-view.c"
						SudokuCellView** _tmp54_;
						gint _tmp54__length1;
						gint _tmp54__length2;
						gint _tmp55_;
						gint _tmp56_;
						SudokuCellView* _tmp57_;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp54_ = self->priv->cells;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp54__length1 = self->priv->cells_length1;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp54__length2 = self->priv->cells_length2;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp55_ = _data6_->cell_row;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp56_ = col_tmp;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp57_, &highlight_color);
#line 3605 "sudoku-view.c"
					} else {
						SudokuCellView** _tmp58_;
						gint _tmp58__length1;
						gint _tmp58__length2;
						gint _tmp59_;
						gint _tmp60_;
						SudokuCellView* _tmp61_;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp58_ = self->priv->cells;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp58__length1 = self->priv->cells_length1;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp58__length2 = self->priv->cells_length2;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp59_ = _data6_->cell_row;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp60_ = col_tmp;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp61_, &free_cell_color);
#line 3627 "sudoku-view.c"
					}
				}
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp62_;
		SudokuBoard* _tmp63_;
		GeeMap* _tmp64_;
		gint _tmp65_;
		SudokuGame* _tmp66_;
		SudokuBoard* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		SudokuGame* _tmp71_;
		SudokuBoard* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		Coord _tmp75_ = {0};
		gpointer _tmp76_;
		gint _coord_size = 0;
		GeeList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _coord_index = 0;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = _data5_->game;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = _tmp62_->board;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = _tmp63_->coords_for_block;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp65_ = _data6_->cell_row;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp66_ = _data5_->game;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp67_ = _tmp66_->board;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp68_ = sudoku_board_get_block_rows (_tmp67_);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp69_ = _tmp68_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp70_ = _data6_->cell_col;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp71_ = _data5_->game;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp72_ = _tmp71_->board;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp73_ = sudoku_board_get_block_cols (_tmp72_);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp74_ = _tmp73_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp75_, _tmp65_ / _tmp69_, _tmp70_ / _tmp74_);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp76_ = gee_map_get (_tmp64_, &_tmp75_);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_coord_list = (GeeList*) _tmp76_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp77_ = _coord_list;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp79_ = _tmp78_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_coord_size = _tmp79_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_coord_index = -1;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		while (TRUE) {
#line 3699 "sudoku-view.c"
			gint _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			Coord* coord = NULL;
			GeeList* _tmp83_;
			gint _tmp84_;
			gpointer _tmp85_;
			SudokuCellView** _tmp86_;
			gint _tmp86__length1;
			gint _tmp86__length2;
			Coord* _tmp87_;
			gint _tmp88_;
			Coord* _tmp89_;
			gint _tmp90_;
			SudokuCellView* _tmp91_;
			gboolean _tmp92_;
			gboolean _tmp93_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = _coord_index;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_coord_index = _tmp80_ + 1;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = _coord_index;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = _coord_size;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			if (!(_tmp81_ < _tmp82_)) {
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				break;
#line 3729 "sudoku-view.c"
			}
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = _coord_list;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = _coord_index;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp85_ = gee_list_get (_tmp83_, _tmp84_);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			coord = (Coord*) _tmp85_;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp86_ = self->priv->cells;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp86__length1 = self->priv->cells_length1;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp86__length2 = self->priv->cells_length2;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp87_ = coord;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp88_ = (*_tmp87_).row;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp89_ = coord;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = (*_tmp89_).col;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp91_ = _tmp86_[(_tmp88_ * _tmp86__length2) + _tmp90_];
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp92_ = sudoku_cell_view_get_is_fixed (_tmp91_);
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp93_ = _tmp92_;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp93_) {
#line 3761 "sudoku-view.c"
				SudokuCellView** _tmp94_;
				gint _tmp94__length1;
				gint _tmp94__length2;
				Coord* _tmp95_;
				gint _tmp96_;
				Coord* _tmp97_;
				gint _tmp98_;
				SudokuCellView* _tmp99_;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp94_ = self->priv->cells;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp94__length1 = self->priv->cells_length1;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp94__length2 = self->priv->cells_length2;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp95_ = coord;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = (*_tmp95_).row;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = coord;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = (*_tmp97_).col;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = _tmp94_[(_tmp96_ * _tmp94__length2) + _tmp98_];
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (_tmp99_, &fixed_cell_color);
#line 3788 "sudoku-view.c"
			} else {
				gboolean _tmp100_;
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = self->priv->_highlighter;
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp100_) {
#line 3795 "sudoku-view.c"
					SudokuCellView** _tmp101_;
					gint _tmp101__length1;
					gint _tmp101__length2;
					Coord* _tmp102_;
					gint _tmp103_;
					Coord* _tmp104_;
					gint _tmp105_;
					SudokuCellView* _tmp106_;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp101_ = self->priv->cells;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp101__length1 = self->priv->cells_length1;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp101__length2 = self->priv->cells_length2;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp102_ = coord;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp103_ = (*_tmp102_).row;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp104_ = coord;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp105_ = (*_tmp104_).col;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp106_ = _tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_];
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp106_, &highlight_color);
#line 3822 "sudoku-view.c"
				} else {
					SudokuCellView** _tmp107_;
					gint _tmp107__length1;
					gint _tmp107__length2;
					Coord* _tmp108_;
					gint _tmp109_;
					Coord* _tmp110_;
					gint _tmp111_;
					SudokuCellView* _tmp112_;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp107_ = self->priv->cells;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp107__length1 = self->priv->cells_length1;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp107__length2 = self->priv->cells_length2;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp108_ = coord;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = (*_tmp108_).row;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = coord;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = (*_tmp110_).col;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = _tmp107_[(_tmp109_ * _tmp107__length2) + _tmp111_];
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp112_, &free_cell_color);
#line 3850 "sudoku-view.c"
				}
			}
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (coord);
#line 3855 "sudoku-view.c"
		}
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_coord_list);
#line 3859 "sudoku-view.c"
	}
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp113_ = self->priv->cells;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp113__length1 = self->priv->cells_length1;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp113__length2 = self->priv->cells_length2;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp114_ = _data6_->cell_row;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp115_ = _data6_->cell_col;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp116_ = _tmp113_[(_tmp114_ * _tmp113__length2) + _tmp115_];
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_background_color (_tmp116_, &selected_bg_color);
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3881 "sudoku-view.c"
}


static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = ________lambda13_ (self);
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3890 "sudoku-view.c"
}


static void ________lambda14_ (Block6Data* _data6_, GObject* s, GParamSpec* p) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = _data6_->_data5_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (s != NULL);
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (p != NULL);
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->_show_possibilities;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = TRUE;
#line 3915 "sudoku-view.c"
	} else {
		gboolean _tmp4_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->_show_warnings;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp4_;
#line 3922 "sudoku-view.c"
	}
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = TRUE;
#line 3928 "sudoku-view.c"
	} else {
		SudokuGame* _tmp5_;
		SudokuBoard* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _data5_->game;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _tmp7_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = _tmp8_;
#line 3944 "sudoku-view.c"
	}
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 3950 "sudoku-view.c"
	} else {
		gboolean _tmp9_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->previous_board_broken_state;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp9_;
#line 3957 "sudoku-view.c"
	}
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 3961 "sudoku-view.c"
		SudokuGame* _tmp10_;
		SudokuBoard* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = _data5_->game;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp10_->board;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = sudoku_board_get_broken (_tmp11_);
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		self->priv->previous_board_broken_state = _tmp13_;
#line 3976 "sudoku-view.c"
	}
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3980 "sudoku-view.c"
}


static void _________lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	________lambda14_ (self, _sender, pspec);
#line 3987 "sudoku-view.c"
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game) {
	SudokuView * self = NULL;
	Block5Data* _data5_;
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	GtkOverlay* _tmp2_;
	GtkOverlay* _tmp3_;
	GtkDrawingArea* _tmp4_;
	GtkDrawingArea* _tmp5_;
	GtkGrid* _tmp6_;
	SudokuGame* _tmp9_;
	SudokuGame* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	SudokuGame* _tmp16_;
	SudokuBoard* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	SudokuGame* _tmp20_;
	SudokuBoard* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	SudokuCellView** _tmp24_;
	GtkOverlay* _tmp61_;
	GtkDrawingArea* _tmp62_;
	GtkOverlay* _tmp63_;
	GtkGrid* _tmp64_;
	GtkDrawingArea* _tmp65_;
	GtkGrid* _tmp66_;
	GtkOverlay* _tmp67_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_->_ref_count_ = 1;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = game;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (_data5_->game);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_->game = _tmp1_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuView*) g_object_new (object_type, NULL);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_->self = g_object_ref (self);
#line 472 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
#line 474 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
#line 476 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
#line 476 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 476 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 476 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->overlay = _tmp2_;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->overlay;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp4_);
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->drawing = _tmp4_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->drawing;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->grid;
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp6_ != NULL) {
#line 4076 "sudoku-view.c"
		GtkOverlay* _tmp7_;
		GtkGrid* _tmp8_;
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = self->priv->overlay;
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->grid;
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 4085 "sudoku-view.c"
	}
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _data5_->game;
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->game = _tmp10_;
#line 487 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 487 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp11_);
#line 487 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 487 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->grid = _tmp11_;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->grid;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_spacing (_tmp12_, 1);
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->grid;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_spacing (_tmp13_, 1);
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->grid;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
#line 491 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->grid;
#line 491 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_homogeneous (_tmp15_, TRUE);
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = _data5_->game;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->board;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = sudoku_board_get_rows (_tmp17_);
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = _tmp18_;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _data5_->game;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = _tmp20_->board;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = sudoku_board_get_cols (_tmp21_);
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = _tmp22_;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = g_new0 (SudokuCellView*, (_tmp19_ * _tmp23_) + 1);
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = _tmp24_;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length1 = _tmp19_;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length2 = _tmp23_;
#line 4145 "sudoku-view.c"
	{
		gint row = 0;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		row = 0;
#line 4150 "sudoku-view.c"
		{
			gboolean _tmp25_ = FALSE;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = TRUE;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4157 "sudoku-view.c"
				gint _tmp27_;
				SudokuGame* _tmp28_;
				SudokuBoard* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp25_) {
#line 4165 "sudoku-view.c"
					gint _tmp26_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp26_ = row;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					row = _tmp26_ + 1;
#line 4171 "sudoku-view.c"
				}
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp25_ = FALSE;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp27_ = row;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = _data5_->game;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp29_ = _tmp28_->board;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp31_ = _tmp30_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp27_ < _tmp31_)) {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4189 "sudoku-view.c"
				}
				{
					gint col = 0;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					col = 0;
#line 4195 "sudoku-view.c"
					{
						gboolean _tmp32_ = FALSE;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp32_ = TRUE;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4202 "sudoku-view.c"
							Block6Data* _data6_;
							gint _tmp34_;
							SudokuGame* _tmp35_;
							SudokuBoard* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							SudokuCellView* cell = NULL;
							gint _tmp39_;
							gint _tmp40_;
							SudokuCellView* _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							GdkRGBA _tmp44_ = {0};
							SudokuCellView* _tmp45_;
							gboolean _tmp46_;
							gboolean _tmp47_;
							SudokuCellView* _tmp48_;
							SudokuCellView* _tmp49_;
							SudokuCellView* _tmp50_;
							SudokuCellView** _tmp51_;
							gint _tmp51__length1;
							gint _tmp51__length2;
							gint _tmp52_;
							gint _tmp53_;
							SudokuCellView* _tmp54_;
							SudokuCellView* _tmp55_;
							SudokuCellView* _tmp56_;
							GtkGrid* _tmp57_;
							SudokuCellView* _tmp58_;
							gint _tmp59_;
							gint _tmp60_;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_data6_ = g_slice_new0 (Block6Data);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_data6_->_ref_count_ = 1;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_data6_->_data5_ = block5_data_ref (_data5_);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp32_) {
#line 4242 "sudoku-view.c"
								gint _tmp33_;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp33_ = col;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								col = _tmp33_ + 1;
#line 4248 "sudoku-view.c"
							}
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = FALSE;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _data5_->game;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = _tmp35_->board;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = sudoku_board_get_cols (_tmp36_);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = _tmp37_;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp34_ < _tmp38_)) {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								block6_data_unref (_data6_);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_data6_ = NULL;
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4270 "sudoku-view.c"
							}
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = row;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = col;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = sudoku_cell_view_new (_tmp39_, _tmp40_, &self->game);
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							g_object_ref_sink (_tmp41_);
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							cell = _tmp41_;
#line 499 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = row;
#line 499 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_data6_->cell_row = _tmp42_;
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = col;
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_data6_->cell_col = _tmp43_;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = cell;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = _tmp46_;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp47_) {
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = fixed_cell_color;
#line 4300 "sudoku-view.c"
							} else {
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = free_cell_color;
#line 4304 "sudoku-view.c"
							}
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp48_ = cell;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp48_, &_tmp44_);
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp49_ = cell;
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) _________lambda13__gtk_widget_focus_in_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp50_ = cell;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) _________lambda14__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_ = self->priv->cells;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length1 = self->priv->cells_length1;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length2 = self->priv->cells_length2;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp52_ = row;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp53_ = col;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp54_ = cell;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp55_ = _g_object_ref0 (_tmp54_);
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp57_ = self->priv->grid;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp58_ = cell;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp59_ = col;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp60_ = row;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, _tmp59_, _tmp60_, 1, 1);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (cell);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							block6_data_unref (_data6_);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_data6_ = NULL;
#line 4354 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp61_ = self->priv->overlay;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = self->priv->drawing;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp63_ = self->priv->overlay;
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp64_ = self->priv->grid;
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp64_);
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp65_ = self->priv->drawing;
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp65_);
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp66_ = self->priv->grid;
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = self->priv->overlay;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	block5_data_unref (_data5_);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = NULL;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 4391 "sudoku-view.c"
}


SudokuView* sudoku_view_new (SudokuGame* game) {
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
#line 4398 "sudoku-view.c"
}


static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c) {
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_;
	gint _tmp1_;
	gdouble tile_length = 0.0;
	gint _tmp2_;
	SudokuGame* _tmp3_;
	SudokuBoard* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkTextDirection _tmp7_;
	cairo_t* _tmp48_;
	cairo_t* _tmp49_;
	cairo_t* _tmp88_;
	cairo_t* _tmp89_;
	cairo_t* _tmp90_;
	cairo_t* _tmp127_;
	SudokuGame* _tmp128_;
	gboolean _tmp129_;
	gboolean _tmp130_;
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->grid;
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	board_length = _tmp1_;
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = board_length;
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->game;
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _tmp3_->board;
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	tile_length = ((gdouble) (_tmp2_ - 1)) / _tmp6_;
#line 569 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = gtk_widget_get_default_direction ();
#line 569 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_ == GTK_TEXT_DIR_RTL) {
#line 4449 "sudoku-view.c"
		cairo_t* _tmp8_;
		gint _tmp9_;
		cairo_t* _tmp10_;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = c;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = board_length;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_translate (_tmp8_, (gdouble) _tmp9_, (gdouble) 0);
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = c;
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp10_, (gdouble) -1, (gdouble) 1);
#line 4463 "sudoku-view.c"
	}
	{
		gint i = 0;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4469 "sudoku-view.c"
		{
			gboolean _tmp11_ = FALSE;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp11_ = TRUE;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4476 "sudoku-view.c"
				gint _tmp13_;
				SudokuGame* _tmp14_;
				SudokuBoard* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp11_) {
#line 4484 "sudoku-view.c"
					gint _tmp12_;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = i;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp12_ + 1;
#line 4490 "sudoku-view.c"
				}
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = FALSE;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp13_ = i;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = self->game;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _tmp14_->board;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp16_ = sudoku_board_get_cols (_tmp15_);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp17_ = _tmp16_;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp13_ < _tmp17_)) {
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4508 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4514 "sudoku-view.c"
					{
						gboolean _tmp18_ = FALSE;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp18_ = TRUE;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4521 "sudoku-view.c"
							gint _tmp20_;
							SudokuGame* _tmp21_;
							SudokuBoard* _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							gint _tmp26_;
							gint _tmp27_;
							SudokuCellView* _tmp28_;
							GdkRGBA _tmp29_ = {0};
							GdkRGBA _tmp30_;
							cairo_t* _tmp31_;
							GdkRGBA _tmp32_;
							gdouble _tmp33_;
							GdkRGBA _tmp34_;
							gdouble _tmp35_;
							GdkRGBA _tmp36_;
							gdouble _tmp37_;
							cairo_t* _tmp38_;
							gint _tmp39_;
							gdouble _tmp40_;
							gint _tmp41_;
							gdouble _tmp42_;
							gint _tmp43_;
							gdouble _tmp44_;
							gint _tmp45_;
							gdouble _tmp46_;
							cairo_t* _tmp47_;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp18_) {
#line 4555 "sudoku-view.c"
								gint _tmp19_;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp19_ = j;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp19_ + 1;
#line 4561 "sudoku-view.c"
							}
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = FALSE;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = j;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = self->game;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = _tmp21_->board;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = sudoku_board_get_cols (_tmp22_);
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = _tmp23_;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp20_ < _tmp24_)) {
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4579 "sudoku-view.c"
							}
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = i;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = j;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_get_background_color (_tmp28_, &_tmp29_);
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							background_color = _tmp30_;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = c;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = background_color;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = _tmp32_.red;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = background_color;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp34_.green;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = background_color;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = _tmp36_.blue;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							cairo_set_source_rgb (_tmp31_, _tmp33_, _tmp35_, _tmp37_);
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = c;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = j;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = tile_length;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = i;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = tile_length;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = j;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp44_ = tile_length;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = i;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = tile_length;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							cairo_rectangle (_tmp38_, ((gint) (_tmp39_ * _tmp40_)) + 0.5, ((gint) (_tmp41_ * _tmp42_)) + 0.5, ((gint) ((_tmp43_ + 1) * _tmp44_)) + 0.5, ((gint) ((_tmp45_ + 1) * _tmp46_)) + 0.5);
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = c;
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							cairo_fill (_tmp47_);
#line 4639 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = c;
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_line_width (_tmp48_, (gdouble) 1);
#line 589 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = c;
#line 589 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp49_, 0.6, 0.6, 0.6);
#line 4654 "sudoku-view.c"
	{
		gint i = 0;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4659 "sudoku-view.c"
		{
			gboolean _tmp50_ = FALSE;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = TRUE;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4666 "sudoku-view.c"
				gint _tmp52_;
				SudokuGame* _tmp53_;
				SudokuBoard* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				SudokuGame* _tmp58_;
				SudokuBoard* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				cairo_t* _tmp62_;
				gint _tmp63_;
				gdouble _tmp64_;
				cairo_t* _tmp65_;
				gint _tmp66_;
				gdouble _tmp67_;
				gint _tmp68_;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp50_) {
#line 4686 "sudoku-view.c"
					gint _tmp51_;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = i;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp51_ + 1;
#line 4692 "sudoku-view.c"
				}
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp50_ = FALSE;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp52_ = i;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp53_ = self->game;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp54_ = _tmp53_->board;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp55_ = sudoku_board_get_cols (_tmp54_);
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp56_ = _tmp55_;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp52_ < _tmp56_)) {
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4710 "sudoku-view.c"
				}
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp57_ = i;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp58_ = self->game;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp59_ = _tmp58_->board;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp60_ = sudoku_board_get_block_cols (_tmp59_);
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp61_ = _tmp60_;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp57_ % _tmp61_) == 0) {
#line 593 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4726 "sudoku-view.c"
				}
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp62_ = c;
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp63_ = i;
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp64_ = tile_length;
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp62_, ((gint) (_tmp63_ * _tmp64_)) + 0.5, (gdouble) 1);
#line 596 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp65_ = c;
#line 596 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp66_ = i;
#line 596 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp67_ = tile_length;
#line 596 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp68_ = board_length;
#line 596 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp65_, ((gint) (_tmp66_ * _tmp67_)) + 0.5, (gdouble) _tmp68_);
#line 4746 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4754 "sudoku-view.c"
		{
			gboolean _tmp69_ = FALSE;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = TRUE;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4761 "sudoku-view.c"
				gint _tmp71_;
				SudokuGame* _tmp72_;
				SudokuBoard* _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				gint _tmp76_;
				SudokuGame* _tmp77_;
				SudokuBoard* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				cairo_t* _tmp81_;
				gint _tmp82_;
				gdouble _tmp83_;
				cairo_t* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gdouble _tmp87_;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp69_) {
#line 4781 "sudoku-view.c"
					gint _tmp70_;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp70_ = i;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp70_ + 1;
#line 4787 "sudoku-view.c"
				}
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp69_ = FALSE;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp71_ = i;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp72_ = self->game;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp73_ = _tmp72_->board;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp74_ = sudoku_board_get_cols (_tmp73_);
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp75_ = _tmp74_;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp71_ < _tmp75_)) {
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4805 "sudoku-view.c"
				}
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = i;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp77_ = self->game;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp78_ = _tmp77_->board;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp80_ = _tmp79_;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp76_ % _tmp80_) == 0) {
#line 601 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4821 "sudoku-view.c"
				}
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp81_ = c;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp82_ = i;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp83_ = tile_length;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp81_, (gdouble) 1, ((gint) (_tmp82_ * _tmp83_)) + 0.5);
#line 604 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp84_ = c;
#line 604 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp85_ = board_length;
#line 604 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp86_ = i;
#line 604 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp87_ = tile_length;
#line 604 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp84_, (gdouble) _tmp85_, ((gint) (_tmp86_ * _tmp87_)) + 0.5);
#line 4841 "sudoku-view.c"
			}
		}
	}
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp88_ = c;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp88_);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp89_ = c;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_line_width (_tmp89_, (gdouble) 2);
#line 609 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp90_ = c;
#line 609 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp90_, 0.0, 0.0, 0.0);
#line 4857 "sudoku-view.c"
	{
		gint i = 0;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4862 "sudoku-view.c"
		{
			gboolean _tmp91_ = FALSE;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp91_ = TRUE;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4869 "sudoku-view.c"
				gint _tmp97_;
				SudokuGame* _tmp98_;
				SudokuBoard* _tmp99_;
				gint _tmp100_;
				gint _tmp101_;
				cairo_t* _tmp102_;
				gint _tmp103_;
				gdouble _tmp104_;
				cairo_t* _tmp105_;
				gint _tmp106_;
				gdouble _tmp107_;
				gint _tmp108_;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp91_) {
#line 4884 "sudoku-view.c"
					gint _tmp92_;
					SudokuGame* _tmp93_;
					SudokuBoard* _tmp94_;
					gint _tmp95_;
					gint _tmp96_;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp92_ = i;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp93_ = self->game;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp94_ = _tmp93_->board;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp95_ = sudoku_board_get_block_cols (_tmp94_);
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp96_ = _tmp95_;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp92_ + _tmp96_;
#line 4902 "sudoku-view.c"
				}
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp91_ = FALSE;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = i;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = self->game;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = _tmp98_->board;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = sudoku_board_get_cols (_tmp99_);
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp101_ = _tmp100_;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp97_ <= _tmp101_)) {
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4920 "sudoku-view.c"
				}
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp102_ = c;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp103_ = i;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp104_ = tile_length;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp102_, ((gint) (_tmp103_ * _tmp104_)) + 0.5, (gdouble) 0);
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp105_ = c;
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp106_ = i;
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp107_ = tile_length;
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp108_ = board_length;
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp105_, ((gint) (_tmp106_ * _tmp107_)) + 0.5, (gdouble) _tmp108_);
#line 4940 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4948 "sudoku-view.c"
		{
			gboolean _tmp109_ = FALSE;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp109_ = TRUE;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4955 "sudoku-view.c"
				gint _tmp115_;
				SudokuGame* _tmp116_;
				SudokuBoard* _tmp117_;
				gint _tmp118_;
				gint _tmp119_;
				cairo_t* _tmp120_;
				gint _tmp121_;
				gdouble _tmp122_;
				cairo_t* _tmp123_;
				gint _tmp124_;
				gint _tmp125_;
				gdouble _tmp126_;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp109_) {
#line 4970 "sudoku-view.c"
					gint _tmp110_;
					SudokuGame* _tmp111_;
					SudokuBoard* _tmp112_;
					gint _tmp113_;
					gint _tmp114_;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = i;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = self->game;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = _tmp111_->board;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp113_ = sudoku_board_get_block_rows (_tmp112_);
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp114_ = _tmp113_;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp110_ + _tmp114_;
#line 4988 "sudoku-view.c"
				}
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp109_ = FALSE;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp115_ = i;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp116_ = self->game;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp117_ = _tmp116_->board;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp118_ = sudoku_board_get_cols (_tmp117_);
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp119_ = _tmp118_;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp115_ <= _tmp119_)) {
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5006 "sudoku-view.c"
				}
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp120_ = c;
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp121_ = i;
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp122_ = tile_length;
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp120_, (gdouble) 0, ((gint) (_tmp121_ * _tmp122_)) + 0.5);
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp123_ = c;
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp124_ = board_length;
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp125_ = i;
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp126_ = tile_length;
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp123_, (gdouble) _tmp124_, ((gint) (_tmp125_ * _tmp126_)) + 0.5);
#line 5026 "sudoku-view.c"
			}
		}
	}
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp127_ = c;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp127_);
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp128_ = self->game;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp129_ = sudoku_game_get_paused (_tmp128_);
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp130_ = _tmp129_;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp130_) {
#line 5042 "sudoku-view.c"
		cairo_t* _tmp131_;
		cairo_t* _tmp132_;
		cairo_t* _tmp133_;
		cairo_t* _tmp134_;
		gint _tmp135_;
		gchar* text = NULL;
		gchar* _tmp136_;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp137_;
		const gchar* _tmp138_;
		cairo_text_extents_t _tmp139_ = {0};
		cairo_t* _tmp140_;
		gint _tmp141_;
		cairo_text_extents_t _tmp142_;
		gdouble _tmp143_;
		gint _tmp144_;
		cairo_text_extents_t _tmp145_;
		gdouble _tmp146_;
		cairo_t* _tmp147_;
		cairo_t* _tmp148_;
		const gchar* _tmp149_;
#line 624 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = c;
#line 624 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgba (_tmp131_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = c;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_paint (_tmp132_);
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp133_ = c;
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_select_font_face (_tmp133_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp134_ = c;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp135_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp134_, _tmp135_ * 0.125);
#line 631 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp136_ = g_strdup (_ ("Paused"));
#line 631 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp136_;
#line 633 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp137_ = c;
#line 633 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp138_ = text;
#line 633 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp137_, _tmp138_, &_tmp139_);
#line 633 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp139_;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp140_ = c;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp141_ = board_length;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp142_ = extents;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp143_ = _tmp142_.width;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp144_ = board_length;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp145_ = extents;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp146_ = _tmp145_.height;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp140_, (_tmp141_ / 2.0) - (_tmp143_ / 2.0), (_tmp144_ / 2.0) + (_tmp146_ / 2.0));
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp147_ = c;
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp147_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 636 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp148_ = c;
#line 636 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_tmp149_ = text;
#line 636 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp148_, _tmp149_);
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 5122 "sudoku-view.c"
	}
#line 639 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 639 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5128 "sudoku-view.c"
}


void sudoku_view_clear (SudokuView* self) {
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 5135 "sudoku-view.c"
	{
		gint i = 0;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 5140 "sudoku-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp0_ = TRUE;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 5147 "sudoku-view.c"
				gint _tmp2_;
				SudokuGame* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp0_) {
#line 5155 "sudoku-view.c"
					gint _tmp1_;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = i;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp1_ + 1;
#line 5161 "sudoku-view.c"
				}
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp0_ = FALSE;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = i;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = self->game;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = _tmp3_->board;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5179 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5185 "sudoku-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp7_ = TRUE;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5192 "sudoku-view.c"
							gint _tmp9_;
							SudokuGame* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCellView** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							SudokuCellView* _tmp17_;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp7_) {
#line 5206 "sudoku-view.c"
								gint _tmp8_;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp8_ = j;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp8_ + 1;
#line 5212 "sudoku-view.c"
							}
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp7_ = FALSE;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp9_ = j;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = self->game;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = _tmp10_->board;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = _tmp12_;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5230 "sudoku-view.c"
							}
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = self->priv->cells;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length1 = self->priv->cells_length1;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length2 = self->priv->cells_length2;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = i;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = j;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_clear (_tmp17_);
#line 5246 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 652 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 652 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 652 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 652 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5267 "sudoku-view.c"
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_;
#line 653 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 5279 "sudoku-view.c"
	{
		gint i = 0;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 5284 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 5291 "sudoku-view.c"
				gint _tmp3_;
				SudokuGame* _tmp4_;
				SudokuBoard* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 5299 "sudoku-view.c"
					gint _tmp2_;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 5305 "sudoku-view.c"
				}
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5323 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5329 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5336 "sudoku-view.c"
							gint _tmp10_;
							SudokuGame* _tmp11_;
							SudokuBoard* _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							SudokuCellView** _tmp15_;
							gint _tmp15__length1;
							gint _tmp15__length2;
							gint _tmp16_;
							gint _tmp17_;
							SudokuCellView* _tmp18_;
							gboolean _tmp19_;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5351 "sudoku-view.c"
								gint _tmp9_;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5357 "sudoku-view.c"
							}
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5375 "sudoku-view.c"
							}
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = self->priv->_show_warnings;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_warnings (_tmp18_, _tmp19_);
#line 5393 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 653 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY]);
#line 5402 "sudoku-view.c"
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5417 "sudoku-view.c"
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_;
#line 665 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 5429 "sudoku-view.c"
	{
		gint i = 0;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 5434 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 5441 "sudoku-view.c"
				gint _tmp3_;
				SudokuGame* _tmp4_;
				SudokuBoard* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 5449 "sudoku-view.c"
					gint _tmp2_;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 5455 "sudoku-view.c"
				}
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5473 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5479 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5486 "sudoku-view.c"
							gint _tmp10_;
							SudokuGame* _tmp11_;
							SudokuBoard* _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							SudokuCellView** _tmp15_;
							gint _tmp15__length1;
							gint _tmp15__length2;
							gint _tmp16_;
							gint _tmp17_;
							SudokuCellView* _tmp18_;
							gboolean _tmp19_;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5501 "sudoku-view.c"
								gint _tmp9_;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5507 "sudoku-view.c"
							}
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5525 "sudoku-view.c"
							}
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = value;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
#line 5543 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 665 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
#line 5552 "sudoku-view.c"
}


gboolean sudoku_view_get_highlighter (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_highlighter;
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5567 "sudoku-view.c"
}


void sudoku_view_set_highlighter (SudokuView* self, gboolean value) {
	gboolean _tmp0_;
#line 677 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 678 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 678 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = _tmp0_;
#line 677 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY]);
#line 5581 "sudoku-view.c"
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY] = g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5602 "sudoku-view.c"
}


static void sudoku_view_instance_init (SudokuView * self) {
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->previous_board_broken_state = FALSE;
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = 0;
#line 460 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = 0;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = FALSE;
#line 661 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = FALSE;
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = FALSE;
#line 5621 "sudoku-view.c"
}


static void sudoku_view_finalize (GObject * obj) {
	SudokuView * self;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 451 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 455 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 457 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
#line 5641 "sudoku-view.c"
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5680 "sudoku-view.c"
		default:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5686 "sudoku-view.c"
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5714 "sudoku-view.c"
		default:
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5720 "sudoku-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



