/* chess-view.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from chess-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <stdio.h>
#include "libchess.h"
#include <glib/gi18n-lib.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
enum  {
	CHESS_VIEW_DUMMY_PROPERTY,
	CHESS_VIEW_SCENE,
	CHESS_VIEW_LAST_PROPERTY
};
static GParamSpec* chess_view_properties[CHESS_VIEW_LAST_PROPERTY];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessViewPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
	ChessScene* _scene;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GObject parent_instance;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GObjectClass parent_class;
};


static gpointer chess_view_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW, ChessViewPrivate))
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view_render_piece (ChessView* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view_load_theme (ChessView* self, cairo_t* c);
static gboolean chess_view_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view_get_border_size (ChessView* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view_draw_piece (ChessView* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
static gboolean chess_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view_scene_changed_cb (ChessView* self, ChessScene* scene);
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
static void chess_view_finalize (GObject * obj);
static void _vala_chess_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView* chess_view_construct (GType object_type) {
	ChessView * self = NULL;
	self = (ChessView*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK));
	return self;
}


ChessView* chess_view_new (void) {
	return chess_view_construct (TYPE_CHESS_VIEW);
}


static gboolean chess_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView * self;
	gboolean result = FALSE;
	gint short_edge = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gdouble extra = 0.0;
	gint _tmp6_;
	gdouble _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	self = (ChessView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = short_edge;
	_tmp4_ = self->priv->border;
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
	self->priv->square_size = (gint) _tmp5_;
	_tmp6_ = self->priv->square_size;
	extra = _tmp6_ * 0.1;
	_tmp7_ = extra;
	if (_tmp7_ < ((gdouble) 3)) {
		extra = (gdouble) 3;
	}
	_tmp8_ = self->priv->square_size;
	_tmp9_ = extra;
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
	result = TRUE;
	return result;
}


static void chess_view_render_piece (ChessView* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	cairo_t* _tmp20_;
	gint _tmp21_;
	RsvgHandle* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	RsvgHandle* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	RsvgHandle* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	cairo_t* _tmp36_;
	gint _tmp37_;
	RsvgHandle* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	RsvgHandle* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	RsvgHandle* _tmp45_;
	cairo_t* _tmp46_;
	cairo_t* _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c1 != NULL);
	g_return_if_fail (c2 != NULL);
	g_return_if_fail (name != NULL);
	{
		RsvgHandle* _tmp0_ = NULL;
		ChessScene* _tmp1_;
		ChessScene* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		RsvgHandle* _tmp10_;
		RsvgHandle* _tmp11_;
		RsvgHandle* _tmp12_;
		_tmp1_ = chess_view_get_scene (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = chess_scene_get_theme_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = name;
		_tmp6_ = g_strconcat (_tmp5_, ".svg", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename (PKGDATADIR, "pieces", _tmp4_, _tmp7_, NULL, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = rsvg_handle_new_from_file (_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_tmp0_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch14_g_error;
		}
		_tmp12_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (handle);
		handle = _tmp12_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stderr;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "Failed to load piece svg: %s", _tmp15_);
		_g_error_free0 (e);
		_g_object_unref0 (handle);
		return;
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = c1;
	cairo_save (_tmp16_);
	_tmp17_ = c1;
	_tmp18_ = self->priv->square_size;
	_tmp19_ = offset;
	cairo_translate (_tmp17_, (gdouble) (_tmp18_ * _tmp19_), (gdouble) 0);
	_tmp20_ = c1;
	_tmp21_ = self->priv->square_size;
	_tmp22_ = handle;
	g_object_get (_tmp22_, "width", &_tmp23_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->square_size;
	_tmp26_ = handle;
	g_object_get (_tmp26_, "height", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	cairo_scale (_tmp20_, ((gdouble) _tmp21_) / _tmp24_, ((gdouble) _tmp25_) / _tmp28_);
	_tmp29_ = handle;
	_tmp30_ = c1;
	rsvg_handle_render_cairo (_tmp29_, _tmp30_);
	_tmp31_ = c1;
	cairo_restore (_tmp31_);
	_tmp32_ = c2;
	cairo_save (_tmp32_);
	_tmp33_ = c2;
	_tmp34_ = self->priv->selected_square_size;
	_tmp35_ = offset;
	cairo_translate (_tmp33_, (gdouble) (_tmp34_ * _tmp35_), (gdouble) 0);
	_tmp36_ = c2;
	_tmp37_ = self->priv->selected_square_size;
	_tmp38_ = handle;
	g_object_get (_tmp38_, "width", &_tmp39_, NULL);
	_tmp40_ = _tmp39_;
	_tmp41_ = self->priv->selected_square_size;
	_tmp42_ = handle;
	g_object_get (_tmp42_, "height", &_tmp43_, NULL);
	_tmp44_ = _tmp43_;
	cairo_scale (_tmp36_, ((gdouble) _tmp37_) / _tmp40_, ((gdouble) _tmp41_) / _tmp44_);
	_tmp45_ = handle;
	_tmp46_ = c2;
	rsvg_handle_render_cairo (_tmp45_, _tmp46_);
	_tmp47_ = c2;
	cairo_restore (_tmp47_);
	_g_object_unref0 (handle);
}


static void chess_view_load_theme (ChessView* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp11_;
	gint _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_t* c1 = NULL;
	cairo_surface_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* c2 = NULL;
	cairo_surface_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	ChessScene* _tmp47_;
	ChessScene* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp2_ = chess_view_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->loaded_theme_name;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		cairo_surface_t* _tmp7_;
		_tmp7_ = self->priv->model_surface;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp8_;
		cairo_surface_t* _tmp9_;
		gint _tmp10_;
		_tmp8_ = self->priv->square_size;
		_tmp9_ = self->priv->model_surface;
		_tmp10_ = cairo_image_surface_get_height (_tmp9_);
		_tmp0_ = _tmp8_ == _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = self->priv->square_size;
	_tmp12_ = self->priv->square_size;
	_tmp13_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp11_, _tmp12_);
	_cairo_surface_destroy0 (self->priv->model_surface);
	self->priv->model_surface = _tmp13_;
	_tmp14_ = c;
	_tmp15_ = cairo_get_target (_tmp14_);
	_tmp16_ = self->priv->selected_square_size;
	_tmp17_ = self->priv->selected_square_size;
	_tmp18_ = cairo_surface_create_similar (_tmp15_, CAIRO_CONTENT_COLOR_ALPHA, 12 * _tmp16_, _tmp17_);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	self->priv->selected_model_surface = _tmp18_;
	_tmp19_ = self->priv->model_surface;
	_tmp20_ = cairo_create (_tmp19_);
	c1 = _tmp20_;
	_tmp21_ = self->priv->selected_model_surface;
	_tmp22_ = cairo_create (_tmp21_);
	c2 = _tmp22_;
	_tmp23_ = c1;
	_tmp24_ = c2;
	chess_view_render_piece (self, _tmp23_, _tmp24_, "whitePawn", 0);
	_tmp25_ = c1;
	_tmp26_ = c2;
	chess_view_render_piece (self, _tmp25_, _tmp26_, "whiteRook", 1);
	_tmp27_ = c1;
	_tmp28_ = c2;
	chess_view_render_piece (self, _tmp27_, _tmp28_, "whiteKnight", 2);
	_tmp29_ = c1;
	_tmp30_ = c2;
	chess_view_render_piece (self, _tmp29_, _tmp30_, "whiteBishop", 3);
	_tmp31_ = c1;
	_tmp32_ = c2;
	chess_view_render_piece (self, _tmp31_, _tmp32_, "whiteQueen", 4);
	_tmp33_ = c1;
	_tmp34_ = c2;
	chess_view_render_piece (self, _tmp33_, _tmp34_, "whiteKing", 5);
	_tmp35_ = c1;
	_tmp36_ = c2;
	chess_view_render_piece (self, _tmp35_, _tmp36_, "blackPawn", 6);
	_tmp37_ = c1;
	_tmp38_ = c2;
	chess_view_render_piece (self, _tmp37_, _tmp38_, "blackRook", 7);
	_tmp39_ = c1;
	_tmp40_ = c2;
	chess_view_render_piece (self, _tmp39_, _tmp40_, "blackKnight", 8);
	_tmp41_ = c1;
	_tmp42_ = c2;
	chess_view_render_piece (self, _tmp41_, _tmp42_, "blackBishop", 9);
	_tmp43_ = c1;
	_tmp44_ = c2;
	chess_view_render_piece (self, _tmp43_, _tmp44_, "blackQueen", 10);
	_tmp45_ = c1;
	_tmp46_ = c2;
	chess_view_render_piece (self, _tmp45_, _tmp46_, "blackKing", 11);
	_tmp47_ = chess_view_get_scene (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = chess_scene_get_theme_name (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup (_tmp50_);
	_g_free0 (self->priv->loaded_theme_name);
	self->priv->loaded_theme_name = _tmp51_;
	_cairo_destroy0 (c2);
	_cairo_destroy0 (c1);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean chess_view_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	cairo_t* _tmp4_;
	ChessScene* _tmp5_;
	ChessScene* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gint board_size = 0;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	cairo_t* _tmp19_;
	ChessScene* _tmp40_;
	ChessScene* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	ChessScene* _tmp185_;
	ChessScene* _tmp186_;
	ChessGame* _tmp187_;
	ChessGame* _tmp188_;
	gboolean _tmp189_;
	gboolean _tmp190_;
	ChessScene* _tmp197_;
	ChessScene* _tmp198_;
	GList* _tmp199_;
	self = (ChessView*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	chess_view_load_theme (self, _tmp0_);
	_tmp1_ = c;
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_translate (_tmp1_, (gdouble) (_tmp2_ / 2), (gdouble) (_tmp3_ / 2));
	_tmp4_ = c;
	_tmp5_ = chess_view_get_scene (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_scene_get_board_angle (_tmp6_);
	_tmp8_ = _tmp7_;
	cairo_rotate (_tmp4_, (G_PI * _tmp8_) / 180.0);
	_tmp9_ = self->priv->square_size;
	_tmp10_ = chess_view_get_border_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = ceil ((_tmp9_ * 4) + _tmp11_);
	board_size = (gint) _tmp12_;
	_tmp13_ = c;
	cairo_set_source_rgb (_tmp13_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
	_tmp14_ = c;
	_tmp15_ = board_size;
	_tmp16_ = board_size;
	_tmp17_ = board_size;
	_tmp18_ = board_size;
	cairo_rectangle (_tmp14_, (gdouble) (-_tmp15_), (gdouble) (-_tmp16_), (gdouble) (_tmp17_ * 2), (gdouble) (_tmp18_ * 2));
	_tmp19_ = c;
	cairo_fill (_tmp19_);
	{
		gint file = 0;
		file = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = file;
					file = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = file;
				if (!(_tmp22_ < 8)) {
					break;
				}
				{
					gint rank = 0;
					rank = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gint _tmp25_;
							gint x = 0;
							gint _tmp26_;
							gint _tmp27_;
							gint y = 0;
							gint _tmp28_;
							gint _tmp29_;
							cairo_t* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							cairo_t* _tmp39_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = rank;
								rank = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = rank;
							if (!(_tmp25_ < 8)) {
								break;
							}
							_tmp26_ = file;
							_tmp27_ = self->priv->square_size;
							x = (gint) ((_tmp26_ - 4) * _tmp27_);
							_tmp28_ = rank;
							_tmp29_ = self->priv->square_size;
							y = (gint) ((3 - _tmp28_) * _tmp29_);
							_tmp30_ = c;
							_tmp31_ = x;
							_tmp32_ = y;
							_tmp33_ = self->priv->square_size;
							_tmp34_ = self->priv->square_size;
							cairo_rectangle (_tmp30_, (gdouble) _tmp31_, (gdouble) _tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_);
							_tmp35_ = file;
							_tmp36_ = rank;
							if (((_tmp35_ + _tmp36_) % 2) == 0) {
								cairo_t* _tmp37_;
								_tmp37_ = c;
								cairo_set_source_rgb (_tmp37_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
							} else {
								cairo_t* _tmp38_;
								_tmp38_ = c;
								cairo_set_source_rgb (_tmp38_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
							}
							_tmp39_ = c;
							cairo_fill (_tmp39_);
						}
					}
				}
			}
		}
	}
	_tmp40_ = chess_view_get_scene (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = chess_scene_get_show_numbering (_tmp41_);
	_tmp43_ = _tmp42_;
	if (_tmp43_) {
		cairo_t* _tmp44_;
		cairo_t* _tmp45_;
		gdouble _tmp46_;
		gdouble _tmp47_;
		cairo_t* _tmp48_;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp49_;
		cairo_text_extents_t _tmp50_ = {0};
		gdouble y_offset = 0.0;
		gint _tmp51_;
		cairo_text_extents_t _tmp52_;
		gdouble _tmp53_;
		cairo_text_extents_t _tmp54_;
		gdouble _tmp55_;
		cairo_text_extents_t _tmp56_;
		gdouble _tmp57_;
		gdouble top = 0.0;
		gint _tmp58_;
		gdouble _tmp59_;
		gdouble bottom = 0.0;
		gint _tmp60_;
		gdouble _tmp61_;
		gdouble _tmp62_;
		gdouble _tmp63_;
		gdouble file_offset = 0.0;
		gint _tmp64_;
		gdouble rank_offset = 0.0;
		gint _tmp65_;
		gchar** files = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** ranks = NULL;
		gint ranks_length1 = 0;
		gint _ranks_size_ = 0;
		cairo_matrix_t matrix = {0};
		cairo_t* _tmp66_;
		cairo_matrix_t _tmp67_ = {0};
		ChessScene* _tmp68_;
		ChessScene* _tmp69_;
		gdouble _tmp70_;
		gdouble _tmp71_;
		cairo_t* _tmp108_;
		cairo_t* _tmp109_;
		cairo_matrix_t _tmp110_;
		cairo_t* _tmp184_;
		_tmp44_ = c;
		cairo_set_source_rgb (_tmp44_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
		_tmp45_ = c;
		_tmp46_ = chess_view_get_border_size (self);
		_tmp47_ = _tmp46_;
		cairo_set_font_size (_tmp45_, _tmp47_ * 0.6);
		_tmp48_ = c;
		cairo_select_font_face (_tmp48_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp49_ = c;
		cairo_text_extents (_tmp49_, "abcdefgh", &_tmp50_);
		extents = _tmp50_;
		_tmp51_ = self->priv->square_size;
		_tmp52_ = extents;
		_tmp53_ = _tmp52_.height;
		_tmp54_ = extents;
		_tmp55_ = _tmp54_.height;
		_tmp56_ = extents;
		_tmp57_ = _tmp56_.y_bearing;
		y_offset = ((((_tmp51_ / 2) - _tmp53_) / 2) + _tmp55_) + _tmp57_;
		_tmp58_ = self->priv->square_size;
		_tmp59_ = y_offset;
		top = -((_tmp58_ * 4) + _tmp59_);
		_tmp60_ = self->priv->square_size;
		_tmp61_ = chess_view_get_border_size (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = y_offset;
		bottom = ((_tmp60_ * 4) + _tmp62_) - _tmp63_;
		_tmp64_ = self->priv->square_size;
		file_offset = -(_tmp64_ * 3.5);
		_tmp65_ = self->priv->square_size;
		rank_offset = -(_tmp65_ * 3.5);
		_tmp66_ = c;
		cairo_get_matrix (_tmp66_, &_tmp67_);
		matrix = _tmp67_;
		_tmp68_ = chess_view_get_scene (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = chess_scene_get_board_angle (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ == 180.0) {
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar** _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar** _tmp89_;
			_tmp72_ = g_strdup ("h");
			_tmp73_ = g_strdup ("g");
			_tmp74_ = g_strdup ("f");
			_tmp75_ = g_strdup ("e");
			_tmp76_ = g_strdup ("d");
			_tmp77_ = g_strdup ("c");
			_tmp78_ = g_strdup ("b");
			_tmp79_ = g_strdup ("a");
			_tmp80_ = g_new0 (gchar*, 8 + 1);
			_tmp80_[0] = _tmp72_;
			_tmp80_[1] = _tmp73_;
			_tmp80_[2] = _tmp74_;
			_tmp80_[3] = _tmp75_;
			_tmp80_[4] = _tmp76_;
			_tmp80_[5] = _tmp77_;
			_tmp80_[6] = _tmp78_;
			_tmp80_[7] = _tmp79_;
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
			files = _tmp80_;
			files_length1 = 8;
			_files_size_ = files_length1;
			_tmp81_ = g_strdup ("1");
			_tmp82_ = g_strdup ("2");
			_tmp83_ = g_strdup ("3");
			_tmp84_ = g_strdup ("4");
			_tmp85_ = g_strdup ("5");
			_tmp86_ = g_strdup ("6");
			_tmp87_ = g_strdup ("7");
			_tmp88_ = g_strdup ("8");
			_tmp89_ = g_new0 (gchar*, 8 + 1);
			_tmp89_[0] = _tmp81_;
			_tmp89_[1] = _tmp82_;
			_tmp89_[2] = _tmp83_;
			_tmp89_[3] = _tmp84_;
			_tmp89_[4] = _tmp85_;
			_tmp89_[5] = _tmp86_;
			_tmp89_[6] = _tmp87_;
			_tmp89_[7] = _tmp88_;
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
			ranks = _tmp89_;
			ranks_length1 = 8;
			_ranks_size_ = ranks_length1;
			cairo_matrix_scale (&matrix, (gdouble) -1, (gdouble) -1);
		} else {
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar** _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar** _tmp107_;
			_tmp90_ = g_strdup ("a");
			_tmp91_ = g_strdup ("b");
			_tmp92_ = g_strdup ("c");
			_tmp93_ = g_strdup ("d");
			_tmp94_ = g_strdup ("e");
			_tmp95_ = g_strdup ("f");
			_tmp96_ = g_strdup ("g");
			_tmp97_ = g_strdup ("h");
			_tmp98_ = g_new0 (gchar*, 8 + 1);
			_tmp98_[0] = _tmp90_;
			_tmp98_[1] = _tmp91_;
			_tmp98_[2] = _tmp92_;
			_tmp98_[3] = _tmp93_;
			_tmp98_[4] = _tmp94_;
			_tmp98_[5] = _tmp95_;
			_tmp98_[6] = _tmp96_;
			_tmp98_[7] = _tmp97_;
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
			files = _tmp98_;
			files_length1 = 8;
			_files_size_ = files_length1;
			_tmp99_ = g_strdup ("8");
			_tmp100_ = g_strdup ("7");
			_tmp101_ = g_strdup ("6");
			_tmp102_ = g_strdup ("5");
			_tmp103_ = g_strdup ("4");
			_tmp104_ = g_strdup ("3");
			_tmp105_ = g_strdup ("2");
			_tmp106_ = g_strdup ("1");
			_tmp107_ = g_new0 (gchar*, 8 + 1);
			_tmp107_[0] = _tmp99_;
			_tmp107_[1] = _tmp100_;
			_tmp107_[2] = _tmp101_;
			_tmp107_[3] = _tmp102_;
			_tmp107_[4] = _tmp103_;
			_tmp107_[5] = _tmp104_;
			_tmp107_[6] = _tmp105_;
			_tmp107_[7] = _tmp106_;
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
			ranks = _tmp107_;
			ranks_length1 = 8;
			_ranks_size_ = ranks_length1;
		}
		_tmp108_ = c;
		cairo_save (_tmp108_);
		_tmp109_ = c;
		_tmp110_ = matrix;
		cairo_set_matrix (_tmp109_, &_tmp110_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp111_ = FALSE;
				_tmp111_ = TRUE;
				while (TRUE) {
					gint _tmp113_;
					cairo_t* _tmp114_;
					gchar** _tmp115_;
					gint _tmp115__length1;
					gint _tmp116_;
					const gchar* _tmp117_;
					cairo_text_extents_t _tmp118_ = {0};
					cairo_t* _tmp119_;
					cairo_t* _tmp120_;
					gdouble _tmp121_;
					cairo_text_extents_t _tmp122_;
					gdouble _tmp123_;
					gdouble _tmp124_;
					cairo_t* _tmp125_;
					gchar** _tmp126_;
					gint _tmp126__length1;
					gint _tmp127_;
					const gchar* _tmp128_;
					cairo_t* _tmp129_;
					cairo_t* _tmp130_;
					cairo_t* _tmp131_;
					gdouble _tmp132_;
					cairo_text_extents_t _tmp133_;
					gdouble _tmp134_;
					gdouble _tmp135_;
					cairo_t* _tmp136_;
					gchar** _tmp137_;
					gint _tmp137__length1;
					gint _tmp138_;
					const gchar* _tmp139_;
					cairo_t* _tmp140_;
					cairo_t* _tmp141_;
					gchar** _tmp142_;
					gint _tmp142__length1;
					gint _tmp143_;
					const gchar* _tmp144_;
					cairo_text_extents_t _tmp145_ = {0};
					cairo_text_extents_t _tmp146_;
					gdouble _tmp147_;
					cairo_text_extents_t _tmp148_;
					gdouble _tmp149_;
					cairo_t* _tmp150_;
					cairo_t* _tmp151_;
					gint _tmp152_;
					gdouble _tmp153_;
					gdouble _tmp154_;
					gdouble _tmp155_;
					gdouble _tmp156_;
					cairo_text_extents_t _tmp157_;
					gdouble _tmp158_;
					gdouble _tmp159_;
					gdouble _tmp160_;
					cairo_t* _tmp161_;
					gchar** _tmp162_;
					gint _tmp162__length1;
					gint _tmp163_;
					const gchar* _tmp164_;
					cairo_t* _tmp165_;
					cairo_t* _tmp166_;
					cairo_t* _tmp167_;
					gint _tmp168_;
					gdouble _tmp169_;
					gdouble _tmp170_;
					cairo_text_extents_t _tmp171_;
					gdouble _tmp172_;
					gdouble _tmp173_;
					gdouble _tmp174_;
					cairo_t* _tmp175_;
					gchar** _tmp176_;
					gint _tmp176__length1;
					gint _tmp177_;
					const gchar* _tmp178_;
					cairo_t* _tmp179_;
					gdouble _tmp180_;
					gint _tmp181_;
					gdouble _tmp182_;
					gint _tmp183_;
					if (!_tmp111_) {
						gint _tmp112_;
						_tmp112_ = i;
						i = _tmp112_ + 1;
					}
					_tmp111_ = FALSE;
					_tmp113_ = i;
					if (!(_tmp113_ < 8)) {
						break;
					}
					_tmp114_ = c;
					_tmp115_ = ranks;
					_tmp115__length1 = ranks_length1;
					_tmp116_ = i;
					_tmp117_ = _tmp115_[_tmp116_];
					cairo_text_extents (_tmp114_, _tmp117_, &_tmp118_);
					extents = _tmp118_;
					_tmp119_ = c;
					cairo_save (_tmp119_);
					_tmp120_ = c;
					_tmp121_ = file_offset;
					_tmp122_ = extents;
					_tmp123_ = _tmp122_.width;
					_tmp124_ = top;
					cairo_move_to (_tmp120_, _tmp121_ - (_tmp123_ / 2), _tmp124_);
					_tmp125_ = c;
					_tmp126_ = files;
					_tmp126__length1 = files_length1;
					_tmp127_ = i;
					_tmp128_ = _tmp126_[_tmp127_];
					cairo_show_text (_tmp125_, _tmp128_);
					_tmp129_ = c;
					cairo_restore (_tmp129_);
					_tmp130_ = c;
					cairo_save (_tmp130_);
					_tmp131_ = c;
					_tmp132_ = file_offset;
					_tmp133_ = extents;
					_tmp134_ = _tmp133_.width;
					_tmp135_ = bottom;
					cairo_move_to (_tmp131_, _tmp132_ - (_tmp134_ / 2), _tmp135_);
					_tmp136_ = c;
					_tmp137_ = files;
					_tmp137__length1 = files_length1;
					_tmp138_ = i;
					_tmp139_ = _tmp137_[_tmp138_];
					cairo_show_text (_tmp136_, _tmp139_);
					_tmp140_ = c;
					cairo_restore (_tmp140_);
					_tmp141_ = c;
					_tmp142_ = ranks;
					_tmp142__length1 = ranks_length1;
					_tmp143_ = i;
					_tmp144_ = _tmp142_[_tmp143_];
					cairo_text_extents (_tmp141_, _tmp144_, &_tmp145_);
					extents = _tmp145_;
					_tmp146_ = extents;
					_tmp147_ = _tmp146_.y_bearing;
					_tmp148_ = extents;
					_tmp149_ = _tmp148_.height;
					y_offset = -(_tmp147_ + (_tmp149_ / 2));
					_tmp150_ = c;
					cairo_save (_tmp150_);
					_tmp151_ = c;
					_tmp152_ = self->priv->square_size;
					_tmp153_ = chess_view_get_border_size (self);
					_tmp154_ = _tmp153_;
					_tmp155_ = chess_view_get_border_size (self);
					_tmp156_ = _tmp155_;
					_tmp157_ = extents;
					_tmp158_ = _tmp157_.width;
					_tmp159_ = rank_offset;
					_tmp160_ = y_offset;
					cairo_move_to (_tmp151_, -(((((gdouble) _tmp152_) * 4) + _tmp154_) - ((_tmp156_ - _tmp158_) / 2)), _tmp159_ + _tmp160_);
					_tmp161_ = c;
					_tmp162_ = ranks;
					_tmp162__length1 = ranks_length1;
					_tmp163_ = i;
					_tmp164_ = _tmp162_[_tmp163_];
					cairo_show_text (_tmp161_, _tmp164_);
					_tmp165_ = c;
					cairo_restore (_tmp165_);
					_tmp166_ = c;
					cairo_save (_tmp166_);
					_tmp167_ = c;
					_tmp168_ = self->priv->square_size;
					_tmp169_ = chess_view_get_border_size (self);
					_tmp170_ = _tmp169_;
					_tmp171_ = extents;
					_tmp172_ = _tmp171_.width;
					_tmp173_ = rank_offset;
					_tmp174_ = y_offset;
					cairo_move_to (_tmp167_, (((gdouble) _tmp168_) * 4) + ((_tmp170_ - _tmp172_) / 2), _tmp173_ + _tmp174_);
					_tmp175_ = c;
					_tmp176_ = ranks;
					_tmp176__length1 = ranks_length1;
					_tmp177_ = i;
					_tmp178_ = _tmp176_[_tmp177_];
					cairo_show_text (_tmp175_, _tmp178_);
					_tmp179_ = c;
					cairo_restore (_tmp179_);
					_tmp180_ = file_offset;
					_tmp181_ = self->priv->square_size;
					file_offset = _tmp180_ + _tmp181_;
					_tmp182_ = rank_offset;
					_tmp183_ = self->priv->square_size;
					rank_offset = _tmp182_ + _tmp183_;
				}
			}
		}
		_tmp184_ = c;
		cairo_restore (_tmp184_);
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp185_ = chess_view_get_scene (self);
	_tmp186_ = _tmp185_;
	_tmp187_ = chess_scene_get_game (_tmp186_);
	_tmp188_ = _tmp187_;
	_tmp189_ = chess_game_get_should_show_paused_overlay (_tmp188_);
	_tmp190_ = _tmp189_;
	if (_tmp190_) {
		cairo_t* _tmp191_;
		ChessScene* _tmp192_;
		ChessScene* _tmp193_;
		gdouble _tmp194_;
		gdouble _tmp195_;
		cairo_t* _tmp196_;
		_tmp191_ = c;
		_tmp192_ = chess_view_get_scene (self);
		_tmp193_ = _tmp192_;
		_tmp194_ = chess_scene_get_board_angle (_tmp193_);
		_tmp195_ = _tmp194_;
		cairo_rotate (_tmp191_, (G_PI * _tmp195_) / 180.0);
		_tmp196_ = c;
		chess_view_draw_paused_overlay (self, _tmp196_);
		result = TRUE;
		return result;
	}
	_tmp197_ = chess_view_get_scene (self);
	_tmp198_ = _tmp197_;
	_tmp199_ = _tmp198_->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp199_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp200_;
			ChessModel* model = NULL;
			_tmp200_ = _g_object_ref0 ((ChessModel*) model_it->data);
			model = _tmp200_;
			{
				cairo_t* _tmp201_;
				cairo_t* _tmp202_;
				ChessModel* _tmp203_;
				gdouble _tmp204_;
				gint _tmp205_;
				ChessModel* _tmp206_;
				gdouble _tmp207_;
				gint _tmp208_;
				cairo_t* _tmp209_;
				gint _tmp210_;
				gint _tmp211_;
				cairo_t* _tmp212_;
				ChessScene* _tmp213_;
				ChessScene* _tmp214_;
				gdouble _tmp215_;
				gdouble _tmp216_;
				cairo_surface_t* _tmp217_ = NULL;
				ChessModel* _tmp218_;
				gboolean _tmp219_;
				gint _tmp222_ = 0;
				ChessModel* _tmp223_;
				gboolean _tmp224_;
				gdouble _tmp227_ = 0.0;
				gboolean _tmp228_ = FALSE;
				ChessModel* _tmp229_;
				gboolean _tmp230_;
				cairo_t* _tmp235_;
				ChessModel* _tmp236_;
				ChessPiece* _tmp237_;
				cairo_t* _tmp238_;
				_tmp201_ = c;
				cairo_save (_tmp201_);
				_tmp202_ = c;
				_tmp203_ = model;
				_tmp204_ = _tmp203_->x;
				_tmp205_ = self->priv->square_size;
				_tmp206_ = model;
				_tmp207_ = _tmp206_->y;
				_tmp208_ = self->priv->square_size;
				cairo_translate (_tmp202_, (_tmp204_ - 4) * _tmp205_, (3 - _tmp207_) * _tmp208_);
				_tmp209_ = c;
				_tmp210_ = self->priv->square_size;
				_tmp211_ = self->priv->square_size;
				cairo_translate (_tmp209_, (gdouble) (_tmp210_ / 2), (gdouble) (_tmp211_ / 2));
				_tmp212_ = c;
				_tmp213_ = chess_view_get_scene (self);
				_tmp214_ = _tmp213_;
				_tmp215_ = chess_scene_get_board_angle (_tmp214_);
				_tmp216_ = _tmp215_;
				cairo_rotate (_tmp212_, ((-G_PI) * _tmp216_) / 180.0);
				_tmp218_ = model;
				_tmp219_ = _tmp218_->is_selected;
				if (_tmp219_) {
					cairo_surface_t* _tmp220_;
					_tmp220_ = self->priv->selected_model_surface;
					_tmp217_ = _tmp220_;
				} else {
					cairo_surface_t* _tmp221_;
					_tmp221_ = self->priv->model_surface;
					_tmp217_ = _tmp221_;
				}
				_tmp223_ = model;
				_tmp224_ = _tmp223_->is_selected;
				if (_tmp224_) {
					gint _tmp225_;
					_tmp225_ = self->priv->selected_square_size;
					_tmp222_ = _tmp225_;
				} else {
					gint _tmp226_;
					_tmp226_ = self->priv->square_size;
					_tmp222_ = _tmp226_;
				}
				_tmp229_ = model;
				_tmp230_ = _tmp229_->under_threat;
				if (_tmp230_) {
					ChessScene* _tmp231_;
					ChessScene* _tmp232_;
					gboolean _tmp233_;
					gboolean _tmp234_;
					_tmp231_ = chess_view_get_scene (self);
					_tmp232_ = _tmp231_;
					_tmp233_ = chess_scene_get_show_move_hints (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp228_ = _tmp234_;
				} else {
					_tmp228_ = FALSE;
				}
				if (_tmp228_) {
					_tmp227_ = 0.8;
				} else {
					_tmp227_ = 1.0;
				}
				_tmp235_ = c;
				_tmp236_ = model;
				_tmp237_ = _tmp236_->piece;
				chess_view_draw_piece (self, _tmp235_, _tmp217_, _tmp222_, _tmp237_, _tmp227_);
				_tmp238_ = c;
				cairo_restore (_tmp238_);
				_g_object_unref0 (model);
			}
		}
	}
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp239_ = FALSE;
			_tmp239_ = TRUE;
			while (TRUE) {
				gint _tmp241_;
				if (!_tmp239_) {
					gint _tmp240_;
					_tmp240_ = rank;
					rank = _tmp240_ + 1;
				}
				_tmp239_ = FALSE;
				_tmp241_ = rank;
				if (!(_tmp241_ < 8)) {
					break;
				}
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp242_ = FALSE;
						_tmp242_ = TRUE;
						while (TRUE) {
							gint _tmp244_;
							gboolean _tmp245_ = FALSE;
							ChessScene* _tmp246_;
							ChessScene* _tmp247_;
							gboolean _tmp248_;
							gboolean _tmp249_;
							if (!_tmp242_) {
								gint _tmp243_;
								_tmp243_ = file;
								file = _tmp243_ + 1;
							}
							_tmp242_ = FALSE;
							_tmp244_ = file;
							if (!(_tmp244_ < 8)) {
								break;
							}
							_tmp246_ = chess_view_get_scene (self);
							_tmp247_ = _tmp246_;
							_tmp248_ = chess_scene_get_show_move_hints (_tmp247_);
							_tmp249_ = _tmp248_;
							if (_tmp249_) {
								ChessScene* _tmp250_;
								ChessScene* _tmp251_;
								gint _tmp252_;
								gint _tmp253_;
								gboolean _tmp254_;
								_tmp250_ = chess_view_get_scene (self);
								_tmp251_ = _tmp250_;
								_tmp252_ = rank;
								_tmp253_ = file;
								_tmp254_ = chess_scene_can_move (_tmp251_, _tmp252_, _tmp253_);
								_tmp245_ = _tmp254_;
							} else {
								_tmp245_ = FALSE;
							}
							if (_tmp245_) {
								cairo_t* _tmp255_;
								cairo_t* _tmp256_;
								gint _tmp257_;
								gint _tmp258_;
								gint _tmp259_;
								gint _tmp260_;
								cairo_t* _tmp261_;
								gint _tmp262_;
								gint _tmp263_;
								cairo_t* _tmp264_;
								ChessScene* _tmp265_;
								ChessScene* _tmp266_;
								gdouble _tmp267_;
								gdouble _tmp268_;
								cairo_t* _tmp269_;
								cairo_surface_t* _tmp270_;
								gint _tmp271_;
								ChessScene* _tmp272_;
								ChessScene* _tmp273_;
								ChessPiece* _tmp274_;
								ChessPiece* _tmp275_;
								cairo_t* _tmp276_;
								_tmp255_ = c;
								cairo_save (_tmp255_);
								_tmp256_ = c;
								_tmp257_ = file;
								_tmp258_ = self->priv->square_size;
								_tmp259_ = rank;
								_tmp260_ = self->priv->square_size;
								cairo_translate (_tmp256_, (gdouble) ((_tmp257_ - 4) * _tmp258_), (gdouble) ((3 - _tmp259_) * _tmp260_));
								_tmp261_ = c;
								_tmp262_ = self->priv->square_size;
								_tmp263_ = self->priv->square_size;
								cairo_translate (_tmp261_, (gdouble) (_tmp262_ / 2), (gdouble) (_tmp263_ / 2));
								_tmp264_ = c;
								_tmp265_ = chess_view_get_scene (self);
								_tmp266_ = _tmp265_;
								_tmp267_ = chess_scene_get_board_angle (_tmp266_);
								_tmp268_ = _tmp267_;
								cairo_rotate (_tmp264_, ((-G_PI) * _tmp268_) / 180.0);
								_tmp269_ = c;
								_tmp270_ = self->priv->model_surface;
								_tmp271_ = self->priv->square_size;
								_tmp272_ = chess_view_get_scene (self);
								_tmp273_ = _tmp272_;
								_tmp274_ = chess_scene_get_selected_piece (_tmp273_);
								_tmp275_ = _tmp274_;
								chess_view_draw_piece (self, _tmp269_, _tmp270_, _tmp271_, _tmp275_, 0.1);
								_g_object_unref0 (_tmp275_);
								_tmp276_ = c;
								cairo_restore (_tmp276_);
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void chess_view_draw_piece (ChessView* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha) {
	cairo_t* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint offset = 0;
	ChessPiece* _tmp3_;
	PieceType _tmp4_;
	ChessPiece* _tmp5_;
	Color _tmp6_;
	Color _tmp7_;
	cairo_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	cairo_t* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gdouble _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (piece != NULL);
	_tmp0_ = c;
	_tmp1_ = size;
	_tmp2_ = size;
	cairo_translate (_tmp0_, (gdouble) ((-_tmp1_) / 2), (gdouble) ((-_tmp2_) / 2));
	_tmp3_ = piece;
	_tmp4_ = _tmp3_->type;
	offset = (gint) _tmp4_;
	_tmp5_ = piece;
	_tmp6_ = chess_piece_get_color (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == COLOR_BLACK) {
		gint _tmp8_;
		_tmp8_ = offset;
		offset = _tmp8_ + 6;
	}
	_tmp9_ = c;
	_tmp10_ = surface;
	_tmp11_ = offset;
	_tmp12_ = size;
	cairo_set_source_surface (_tmp9_, _tmp10_, (gdouble) ((-_tmp11_) * _tmp12_), (gdouble) 0);
	_tmp13_ = c;
	_tmp14_ = size;
	_tmp15_ = size;
	cairo_rectangle (_tmp13_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp14_, (gdouble) _tmp15_);
	_tmp16_ = c;
	cairo_clip (_tmp16_);
	_tmp17_ = c;
	_tmp18_ = alpha;
	cairo_paint_with_alpha (_tmp17_, _tmp18_);
}


static gboolean chess_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	ChessGame* _tmp4_;
	ChessGame* _tmp5_;
	ChessScene* _tmp14_;
	ChessScene* _tmp15_;
	ChessGame* _tmp16_;
	ChessGame* _tmp17_;
	ChessResult _tmp18_;
	gint file = 0;
	GdkEventButton* _tmp19_;
	gdouble _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	gint rank = 0;
	GdkEventButton* _tmp25_;
	gdouble _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gdouble _tmp30_;
	ChessScene* _tmp31_;
	ChessScene* _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gint _tmp40_;
	ChessScene* _tmp44_;
	ChessScene* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	self = (ChessView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = chess_view_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GdkEventButton* _tmp6_;
		guint _tmp7_;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->button;
		_tmp1_ = _tmp7_ != ((guint) 1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ChessScene* _tmp8_;
		ChessScene* _tmp9_;
		ChessGame* _tmp10_;
		ChessGame* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp8_ = chess_view_get_scene (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = chess_scene_get_game (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = chess_game_get_should_show_paused_overlay (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = _tmp13_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = chess_view_get_scene (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = chess_scene_get_game (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_->result;
	if (_tmp18_ != CHESS_RESULT_IN_PROGRESS) {
		result = FALSE;
		return result;
	}
	_tmp19_ = event;
	_tmp20_ = _tmp19_->x;
	_tmp21_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp22_ = self->priv->square_size;
	_tmp23_ = self->priv->square_size;
	_tmp24_ = floor (((_tmp20_ - (0.5 * _tmp21_)) + (_tmp22_ * 4)) / _tmp23_);
	file = (gint) _tmp24_;
	_tmp25_ = event;
	_tmp26_ = _tmp25_->y;
	_tmp27_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp28_ = self->priv->square_size;
	_tmp29_ = self->priv->square_size;
	_tmp30_ = floor (((_tmp26_ - (0.5 * _tmp27_)) + (_tmp28_ * 4)) / _tmp29_);
	rank = 7 - ((gint) _tmp30_);
	_tmp31_ = chess_view_get_scene (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = chess_scene_get_board_angle (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == 180.0) {
		gint _tmp35_;
		gint _tmp36_;
		_tmp35_ = rank;
		rank = 7 - _tmp35_;
		_tmp36_ = file;
		file = 7 - _tmp36_;
	}
	_tmp40_ = file;
	if (_tmp40_ < 0) {
		_tmp39_ = TRUE;
	} else {
		gint _tmp41_;
		_tmp41_ = file;
		_tmp39_ = _tmp41_ >= 8;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		gint _tmp42_;
		_tmp42_ = rank;
		_tmp38_ = _tmp42_ < 0;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		gint _tmp43_;
		_tmp43_ = rank;
		_tmp37_ = _tmp43_ >= 8;
	}
	if (_tmp37_) {
		result = FALSE;
		return result;
	}
	_tmp44_ = chess_view_get_scene (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = file;
	_tmp47_ = rank;
	chess_scene_select_square (_tmp45_, _tmp46_, _tmp47_);
	result = TRUE;
	return result;
}


static void chess_view_scene_changed_cb (ChessView* self, ChessScene* scene) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	gint _tmp5_;
	gchar* text = NULL;
	gchar* _tmp6_;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp7_;
	cairo_text_extents_t _tmp8_ = {0};
	cairo_t* _tmp9_;
	cairo_text_extents_t _tmp10_;
	gdouble _tmp11_;
	cairo_text_extents_t _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	cairo_save (_tmp0_);
	_tmp1_ = c;
	cairo_set_source_rgba (_tmp1_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
	_tmp2_ = c;
	cairo_paint (_tmp2_);
	_tmp3_ = c;
	cairo_select_font_face (_tmp3_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp4_ = c;
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	cairo_set_font_size (_tmp4_, _tmp5_ * 0.125);
	_tmp6_ = g_strdup (_ ("Paused"));
	text = _tmp6_;
	_tmp7_ = c;
	cairo_text_extents (_tmp7_, text, &_tmp8_);
	extents = _tmp8_;
	_tmp9_ = c;
	_tmp10_ = extents;
	_tmp11_ = _tmp10_.width;
	_tmp12_ = extents;
	_tmp13_ = _tmp12_.height;
	cairo_move_to (_tmp9_, (-_tmp11_) / 2.0, _tmp13_ / 2.0);
	_tmp14_ = c;
	cairo_set_source_rgb (_tmp14_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp15_ = c;
	cairo_show_text (_tmp15_, text);
	_tmp16_ = c;
	cairo_restore (_tmp16_);
	_g_free0 (text);
}


ChessScene* chess_view_get_scene (ChessView* self) {
	ChessScene* result;
	ChessScene* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scene;
	result = _tmp0_;
	return result;
}


static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
	chess_view_scene_changed_cb ((ChessView*) self, _sender);
}


void chess_view_set_scene (ChessView* self, ChessScene* value) {
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_scene);
	self->priv->_scene = _tmp1_;
	_tmp2_ = self->priv->_scene;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _chess_view_scene_changed_cb_chess_scene_changed, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, chess_view_properties[CHESS_VIEW_SCENE]);
}


static gdouble chess_view_get_border_size (ChessView* self) {
	gdouble result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->square_size;
	result = (gdouble) (_tmp0_ / 2);
	return result;
}


static void chess_view_class_init (ChessViewClass * klass) {
	chess_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessViewPrivate));
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget *, GdkEventConfigure*)) chess_view_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) chess_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) chess_view_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_VIEW_SCENE, chess_view_properties[CHESS_VIEW_SCENE] = g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void chess_view_instance_init (ChessView * self) {
	gchar* _tmp0_;
	self->priv = CHESS_VIEW_GET_PRIVATE (self);
	self->priv->border = 6;
	_tmp0_ = g_strdup ("");
	self->priv->loaded_theme_name = _tmp0_;
}


static void chess_view_finalize (GObject * obj) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW, ChessView);
	_cairo_surface_destroy0 (self->priv->model_surface);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	_g_free0 (self->priv->loaded_theme_name);
	_g_object_unref0 (self->priv->_scene);
	G_OBJECT_CLASS (chess_view_parent_class)->finalize (obj);
}


GType chess_view_get_type (void) {
	static volatile gsize chess_view_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView), 0, (GInstanceInitFunc) chess_view_instance_init, NULL };
		GType chess_view_type_id;
		chess_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "ChessView", &g_define_type_info, 0);
		g_once_init_leave (&chess_view_type_id__volatile, chess_view_type_id);
	}
	return chess_view_type_id__volatile;
}


static void _vala_chess_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
	switch (property_id) {
		case CHESS_VIEW_SCENE:
		g_value_set_object (value, chess_view_get_scene (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
	switch (property_id) {
		case CHESS_VIEW_SCENE:
		chess_view_set_scene (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



