/* chess-view.c generated by valac 0.36.0.2-c0ff, the Vala compiler
 * generated from chess-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <stdio.h>
#include "libchess.h"
#include <glib/gi18n-lib.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessViewPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
	ChessScene* _scene;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GObject parent_instance;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GObjectClass parent_class;
};


static gpointer chess_view_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW, ChessViewPrivate))
enum  {
	CHESS_VIEW_DUMMY_PROPERTY,
	CHESS_VIEW_SCENE
};
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view_render_piece (ChessView* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view_load_theme (ChessView* self, cairo_t* c);
static gboolean chess_view_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view_get_border_size (ChessView* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view_draw_piece (ChessView* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
static gboolean chess_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view_scene_changed_cb (ChessView* self, ChessScene* scene);
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
static void chess_view_finalize (GObject * obj);
static void _vala_chess_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView* chess_view_construct (GType object_type) {
	ChessView * self = NULL;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self = (ChessView*) g_object_new (object_type, NULL);
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return self;
#line 166 "chess-view.c"
}


ChessView* chess_view_new (void) {
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return chess_view_construct (TYPE_CHESS_VIEW);
#line 173 "chess-view.c"
}


static gboolean chess_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView * self;
	gboolean result = FALSE;
	gint short_edge;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gdouble extra;
	gint _tmp6_;
	gdouble _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self = (ChessView*) base;
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	short_edge = _tmp2_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp3_ = short_edge;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp4_ = self->priv->border;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->square_size = (gint) _tmp5_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp6_ = self->priv->square_size;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	extra = _tmp6_ * 0.1;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp7_ = extra;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp7_ < ((gdouble) 3)) {
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		extra = (gdouble) 3;
#line 222 "chess-view.c"
	}
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp8_ = self->priv->square_size;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp9_ = extra;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	result = TRUE;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return result;
#line 234 "chess-view.c"
}


static void chess_view_render_piece (ChessView* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	cairo_t* _tmp20_;
	gint _tmp21_;
	RsvgHandle* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	RsvgHandle* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	RsvgHandle* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	cairo_t* _tmp36_;
	gint _tmp37_;
	RsvgHandle* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	RsvgHandle* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	RsvgHandle* _tmp45_;
	cairo_t* _tmp46_;
	cairo_t* _tmp47_;
	GError * _inner_error_ = NULL;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c1 != NULL);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c2 != NULL);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (name != NULL);
#line 281 "chess-view.c"
	{
		RsvgHandle* _tmp0_;
		ChessScene* _tmp1_;
		ChessScene* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		RsvgHandle* _tmp10_;
		RsvgHandle* _tmp11_;
		RsvgHandle* _tmp12_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp1_ = chess_view_get_scene (self);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp2_ = _tmp1_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp3_ = chess_scene_get_theme_name (_tmp2_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp4_ = _tmp3_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp5_ = name;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp6_ = g_strconcat (_tmp5_, ".svg", NULL);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp7_ = _tmp6_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp8_ = g_build_filename (PKGDATADIR, "pieces", _tmp4_, _tmp7_, NULL, NULL);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp9_ = _tmp8_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp10_ = rsvg_handle_new_from_file (_tmp9_, &_inner_error_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp11_ = _tmp10_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_free0 (_tmp9_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_free0 (_tmp7_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp0_ = _tmp11_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 326 "chess-view.c"
			goto __catch14_g_error;
		}
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp12_ = _tmp0_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp0_ = NULL;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (handle);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		handle = _tmp12_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (_tmp0_);
#line 339 "chess-view.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		e = _inner_error_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_inner_error_ = NULL;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp13_ = stderr;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp14_ = e;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp15_ = _tmp14_->message;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		fprintf (_tmp13_, "Failed to load piece svg: %s", _tmp15_);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_error_free0 (e);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (handle);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return;
#line 366 "chess-view.c"
	}
	__finally14:
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (handle);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		g_clear_error (&_inner_error_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return;
#line 379 "chess-view.c"
	}
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp16_ = c1;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_save (_tmp16_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp17_ = c1;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp18_ = self->priv->square_size;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp19_ = offset;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp17_, (gdouble) (_tmp18_ * _tmp19_), (gdouble) 0);
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp20_ = c1;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp21_ = self->priv->square_size;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp22_ = handle;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp22_, "width", &_tmp23_, NULL);
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp24_ = _tmp23_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp25_ = self->priv->square_size;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp26_ = handle;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp26_, "height", &_tmp27_, NULL);
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp28_ = _tmp27_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_scale (_tmp20_, ((gdouble) _tmp21_) / _tmp24_, ((gdouble) _tmp25_) / _tmp28_);
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp29_ = handle;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp30_ = c1;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	rsvg_handle_render_cairo (_tmp29_, _tmp30_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp31_ = c1;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_restore (_tmp31_);
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp32_ = c2;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_save (_tmp32_);
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp33_ = c2;
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp34_ = self->priv->selected_square_size;
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp35_ = offset;
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp33_, (gdouble) (_tmp34_ * _tmp35_), (gdouble) 0);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp36_ = c2;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp37_ = self->priv->selected_square_size;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp38_ = handle;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp38_, "width", &_tmp39_, NULL);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp40_ = _tmp39_;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp41_ = self->priv->selected_square_size;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp42_ = handle;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp42_, "height", &_tmp43_, NULL);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp44_ = _tmp43_;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_scale (_tmp36_, ((gdouble) _tmp37_) / _tmp40_, ((gdouble) _tmp41_) / _tmp44_);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp45_ = handle;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp46_ = c2;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	rsvg_handle_render_cairo (_tmp45_, _tmp46_);
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp47_ = c2;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_restore (_tmp47_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_g_object_unref0 (handle);
#line 467 "chess-view.c"
}


static void chess_view_load_theme (ChessView* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp11_;
	gint _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_t* c1;
	cairo_surface_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* c2;
	cairo_surface_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	ChessScene* _tmp47_;
	ChessScene* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c != NULL);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = chess_view_get_scene (self);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp3_ = _tmp2_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp5_ = _tmp4_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp6_ = self->priv->loaded_theme_name;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
#line 538 "chess-view.c"
		cairo_surface_t* _tmp7_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp7_ = self->priv->model_surface;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp1_ = _tmp7_ != NULL;
#line 544 "chess-view.c"
	} else {
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp1_ = FALSE;
#line 548 "chess-view.c"
	}
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp1_) {
#line 552 "chess-view.c"
		gint _tmp8_;
		cairo_surface_t* _tmp9_;
		gint _tmp10_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp8_ = self->priv->square_size;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp9_ = self->priv->model_surface;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp10_ = cairo_image_surface_get_height (_tmp9_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp0_ = _tmp8_ == _tmp10_;
#line 564 "chess-view.c"
	} else {
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp0_ = FALSE;
#line 568 "chess-view.c"
	}
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp0_) {
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return;
#line 574 "chess-view.c"
	}
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp11_ = self->priv->square_size;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp12_ = self->priv->square_size;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp13_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp11_, _tmp12_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->model_surface);
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->model_surface = _tmp13_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp14_ = c;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp15_ = cairo_get_target (_tmp14_);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp16_ = self->priv->selected_square_size;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp17_ = self->priv->selected_square_size;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp18_ = cairo_surface_create_similar (_tmp15_, CAIRO_CONTENT_COLOR_ALPHA, 12 * _tmp16_, _tmp17_);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->selected_model_surface = _tmp18_;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp19_ = self->priv->model_surface;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp20_ = cairo_create (_tmp19_);
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	c1 = _tmp20_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp21_ = self->priv->selected_model_surface;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp22_ = cairo_create (_tmp21_);
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	c2 = _tmp22_;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp23_ = c1;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp24_ = c2;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp23_, _tmp24_, "whitePawn", 0);
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp25_ = c1;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp26_ = c2;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp25_, _tmp26_, "whiteRook", 1);
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp27_ = c1;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp28_ = c2;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp27_, _tmp28_, "whiteKnight", 2);
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp29_ = c1;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp30_ = c2;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp29_, _tmp30_, "whiteBishop", 3);
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp31_ = c1;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp32_ = c2;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp31_, _tmp32_, "whiteQueen", 4);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp33_ = c1;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp34_ = c2;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp33_, _tmp34_, "whiteKing", 5);
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp35_ = c1;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp36_ = c2;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp35_, _tmp36_, "blackPawn", 6);
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp37_ = c1;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp38_ = c2;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp37_, _tmp38_, "blackRook", 7);
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp39_ = c1;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp40_ = c2;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp39_, _tmp40_, "blackKnight", 8);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp41_ = c1;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp42_ = c2;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp41_, _tmp42_, "blackBishop", 9);
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp43_ = c1;
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp44_ = c2;
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp43_, _tmp44_, "blackQueen", 10);
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp45_ = c1;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp46_ = c2;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp45_, _tmp46_, "blackKing", 11);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp47_ = chess_view_get_scene (self);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp48_ = _tmp47_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp49_ = chess_scene_get_theme_name (_tmp48_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp50_ = _tmp49_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_g_free0 (self->priv->loaded_theme_name);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->loaded_theme_name = _tmp51_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_cairo_destroy0 (c2);
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_cairo_destroy0 (c1);
#line 702 "chess-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 709 "chess-view.c"
}


static gboolean chess_view_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	cairo_t* _tmp4_;
	ChessScene* _tmp5_;
	ChessScene* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gint board_size;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	cairo_t* _tmp19_;
	ChessScene* _tmp40_;
	ChessScene* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	ChessScene* _tmp185_;
	ChessScene* _tmp186_;
	ChessGame* _tmp187_;
	ChessGame* _tmp188_;
	gboolean _tmp189_;
	gboolean _tmp190_;
	ChessScene* _tmp197_;
	ChessScene* _tmp198_;
	GList* _tmp199_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self = (ChessView*) base;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = c;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_load_theme (self, _tmp0_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp1_ = c;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp1_, (gdouble) (_tmp2_ / 2), (gdouble) (_tmp3_ / 2));
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp4_ = c;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp5_ = chess_view_get_scene (self);
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp6_ = _tmp5_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp7_ = chess_scene_get_board_angle (_tmp6_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp8_ = _tmp7_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_rotate (_tmp4_, (G_PI * _tmp8_) / 180.0);
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp9_ = self->priv->square_size;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp10_ = chess_view_get_border_size (self);
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp11_ = _tmp10_;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp12_ = ceil ((_tmp9_ * 4) + _tmp11_);
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	board_size = (gint) _tmp12_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp13_ = c;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_set_source_rgb (_tmp13_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp14_ = c;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp15_ = board_size;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp16_ = board_size;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp17_ = board_size;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp18_ = board_size;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_rectangle (_tmp14_, (gdouble) (-_tmp15_), (gdouble) (-_tmp16_), (gdouble) (_tmp17_ * 2), (gdouble) (_tmp18_ * 2));
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp19_ = c;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_fill (_tmp19_);
#line 808 "chess-view.c"
	{
		gint file;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		file = 0;
#line 813 "chess-view.c"
		{
			gboolean _tmp20_;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp20_ = TRUE;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			while (TRUE) {
#line 820 "chess-view.c"
				gint _tmp22_;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (!_tmp20_) {
#line 824 "chess-view.c"
					gint _tmp21_;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp21_ = file;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					file = _tmp21_ + 1;
#line 830 "chess-view.c"
				}
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp20_ = FALSE;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp22_ = file;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (!(_tmp22_ < 8)) {
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					break;
#line 840 "chess-view.c"
				}
				{
					gint rank;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					rank = 0;
#line 846 "chess-view.c"
					{
						gboolean _tmp23_;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						_tmp23_ = TRUE;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						while (TRUE) {
#line 853 "chess-view.c"
							gint _tmp25_;
							gint x;
							gint _tmp26_;
							gint _tmp27_;
							gint y;
							gint _tmp28_;
							gint _tmp29_;
							cairo_t* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							cairo_t* _tmp39_;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (!_tmp23_) {
#line 871 "chess-view.c"
								gint _tmp24_;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp24_ = rank;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								rank = _tmp24_ + 1;
#line 877 "chess-view.c"
							}
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp23_ = FALSE;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp25_ = rank;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (!(_tmp25_ < 8)) {
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								break;
#line 887 "chess-view.c"
							}
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp26_ = file;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp27_ = self->priv->square_size;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							x = (gint) ((_tmp26_ - 4) * _tmp27_);
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp28_ = rank;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp29_ = self->priv->square_size;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							y = (gint) ((3 - _tmp28_) * _tmp29_);
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp30_ = c;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp31_ = x;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp32_ = y;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp33_ = self->priv->square_size;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp34_ = self->priv->square_size;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							cairo_rectangle (_tmp30_, (gdouble) _tmp31_, (gdouble) _tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_);
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp35_ = file;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp36_ = rank;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (((_tmp35_ + _tmp36_) % 2) == 0) {
#line 919 "chess-view.c"
								cairo_t* _tmp37_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp37_ = c;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_set_source_rgb (_tmp37_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
#line 925 "chess-view.c"
							} else {
								cairo_t* _tmp38_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp38_ = c;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_set_source_rgb (_tmp38_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
#line 932 "chess-view.c"
							}
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp39_ = c;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							cairo_fill (_tmp39_);
#line 938 "chess-view.c"
						}
					}
				}
			}
		}
	}
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp40_ = chess_view_get_scene (self);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp41_ = _tmp40_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp42_ = chess_scene_get_show_numbering (_tmp41_);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp43_ = _tmp42_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp43_) {
#line 955 "chess-view.c"
		cairo_t* _tmp44_;
		cairo_t* _tmp45_;
		gdouble _tmp46_;
		gdouble _tmp47_;
		cairo_t* _tmp48_;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp49_;
		cairo_text_extents_t _tmp50_ = {0};
		gdouble y_offset;
		gint _tmp51_;
		cairo_text_extents_t _tmp52_;
		gdouble _tmp53_;
		cairo_text_extents_t _tmp54_;
		gdouble _tmp55_;
		cairo_text_extents_t _tmp56_;
		gdouble _tmp57_;
		gdouble top;
		gint _tmp58_;
		gdouble _tmp59_;
		gdouble bottom;
		gint _tmp60_;
		gdouble _tmp61_;
		gdouble _tmp62_;
		gdouble _tmp63_;
		gdouble file_offset;
		gint _tmp64_;
		gdouble rank_offset;
		gint _tmp65_;
		gchar** files = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** ranks = NULL;
		gint ranks_length1 = 0;
		gint _ranks_size_ = 0;
		cairo_matrix_t matrix;
		cairo_t* _tmp66_;
		cairo_matrix_t _tmp67_ = {0};
		ChessScene* _tmp68_;
		ChessScene* _tmp69_;
		gdouble _tmp70_;
		gdouble _tmp71_;
		cairo_t* _tmp108_;
		cairo_t* _tmp109_;
		cairo_matrix_t _tmp110_;
		cairo_t* _tmp184_;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp44_ = c;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_set_source_rgb (_tmp44_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp45_ = c;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp46_ = chess_view_get_border_size (self);
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp47_ = _tmp46_;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_set_font_size (_tmp45_, _tmp47_ * 0.6);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp48_ = c;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_select_font_face (_tmp48_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp49_ = c;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_text_extents (_tmp49_, "abcdefgh", &_tmp50_);
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		extents = _tmp50_;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp51_ = self->priv->square_size;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp52_ = extents;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp53_ = _tmp52_.height;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp54_ = extents;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp55_ = _tmp54_.height;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp56_ = extents;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp57_ = _tmp56_.y_bearing;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		y_offset = ((((_tmp51_ / 2) - _tmp53_) / 2) + _tmp55_) + _tmp57_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp58_ = self->priv->square_size;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp59_ = y_offset;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		top = -((_tmp58_ * 4) + _tmp59_);
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp60_ = self->priv->square_size;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp61_ = chess_view_get_border_size (self);
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp62_ = _tmp61_;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp63_ = y_offset;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		bottom = ((_tmp60_ * 4) + _tmp62_) - _tmp63_;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp64_ = self->priv->square_size;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		file_offset = -(_tmp64_ * 3.5);
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp65_ = self->priv->square_size;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		rank_offset = -(_tmp65_ * 3.5);
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp66_ = c;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_get_matrix (_tmp66_, &_tmp67_);
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		matrix = _tmp67_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp68_ = chess_view_get_scene (self);
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp69_ = _tmp68_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp70_ = chess_scene_get_board_angle (_tmp69_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp71_ = _tmp70_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		if (_tmp71_ == 180.0) {
#line 1079 "chess-view.c"
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar** _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar** _tmp89_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp72_ = g_strdup ("h");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp73_ = g_strdup ("g");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp74_ = g_strdup ("f");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp75_ = g_strdup ("e");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp76_ = g_strdup ("d");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp77_ = g_strdup ("c");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp78_ = g_strdup ("b");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp79_ = g_strdup ("a");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_ = g_new0 (gchar*, 8 + 1);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[0] = _tmp72_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[1] = _tmp73_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[2] = _tmp74_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[3] = _tmp75_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[4] = _tmp76_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[5] = _tmp77_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[6] = _tmp78_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp80_[7] = _tmp79_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			files = _tmp80_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			files_length1 = 8;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_files_size_ = files_length1;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp81_ = g_strdup ("1");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp82_ = g_strdup ("2");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp83_ = g_strdup ("3");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp84_ = g_strdup ("4");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp85_ = g_strdup ("5");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp86_ = g_strdup ("6");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp87_ = g_strdup ("7");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp88_ = g_strdup ("8");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_ = g_new0 (gchar*, 8 + 1);
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[0] = _tmp81_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[1] = _tmp82_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[2] = _tmp83_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[3] = _tmp84_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[4] = _tmp85_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[5] = _tmp86_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[6] = _tmp87_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp89_[7] = _tmp88_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			ranks = _tmp89_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			ranks_length1 = 8;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_ranks_size_ = ranks_length1;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			cairo_matrix_scale (&matrix, (gdouble) -1, (gdouble) -1);
#line 1184 "chess-view.c"
		} else {
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar** _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar** _tmp107_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp90_ = g_strdup ("a");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp91_ = g_strdup ("b");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp92_ = g_strdup ("c");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp93_ = g_strdup ("d");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp94_ = g_strdup ("e");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp95_ = g_strdup ("f");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp96_ = g_strdup ("g");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp97_ = g_strdup ("h");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_ = g_new0 (gchar*, 8 + 1);
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[0] = _tmp90_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[1] = _tmp91_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[2] = _tmp92_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[3] = _tmp93_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[4] = _tmp94_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[5] = _tmp95_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[6] = _tmp96_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp98_[7] = _tmp97_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			files = _tmp98_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			files_length1 = 8;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_files_size_ = files_length1;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp99_ = g_strdup ("8");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp100_ = g_strdup ("7");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp101_ = g_strdup ("6");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp102_ = g_strdup ("5");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp103_ = g_strdup ("4");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp104_ = g_strdup ("3");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp105_ = g_strdup ("2");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp106_ = g_strdup ("1");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_ = g_new0 (gchar*, 8 + 1);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[0] = _tmp99_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[1] = _tmp100_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[2] = _tmp101_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[3] = _tmp102_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[4] = _tmp103_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[5] = _tmp104_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[6] = _tmp105_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp107_[7] = _tmp106_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			ranks = _tmp107_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			ranks_length1 = 8;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_ranks_size_ = ranks_length1;
#line 1288 "chess-view.c"
		}
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp108_ = c;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_save (_tmp108_);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp109_ = c;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp110_ = matrix;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_set_matrix (_tmp109_, &_tmp110_);
#line 1300 "chess-view.c"
		{
			gint i;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			i = 0;
#line 1305 "chess-view.c"
			{
				gboolean _tmp111_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp111_ = TRUE;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				while (TRUE) {
#line 1312 "chess-view.c"
					gint _tmp113_;
					cairo_t* _tmp114_;
					gchar** _tmp115_;
					gint _tmp115__length1;
					gint _tmp116_;
					const gchar* _tmp117_;
					cairo_text_extents_t _tmp118_ = {0};
					cairo_t* _tmp119_;
					cairo_t* _tmp120_;
					gdouble _tmp121_;
					cairo_text_extents_t _tmp122_;
					gdouble _tmp123_;
					gdouble _tmp124_;
					cairo_t* _tmp125_;
					gchar** _tmp126_;
					gint _tmp126__length1;
					gint _tmp127_;
					const gchar* _tmp128_;
					cairo_t* _tmp129_;
					cairo_t* _tmp130_;
					cairo_t* _tmp131_;
					gdouble _tmp132_;
					cairo_text_extents_t _tmp133_;
					gdouble _tmp134_;
					gdouble _tmp135_;
					cairo_t* _tmp136_;
					gchar** _tmp137_;
					gint _tmp137__length1;
					gint _tmp138_;
					const gchar* _tmp139_;
					cairo_t* _tmp140_;
					cairo_t* _tmp141_;
					gchar** _tmp142_;
					gint _tmp142__length1;
					gint _tmp143_;
					const gchar* _tmp144_;
					cairo_text_extents_t _tmp145_ = {0};
					cairo_text_extents_t _tmp146_;
					gdouble _tmp147_;
					cairo_text_extents_t _tmp148_;
					gdouble _tmp149_;
					cairo_t* _tmp150_;
					cairo_t* _tmp151_;
					gint _tmp152_;
					gdouble _tmp153_;
					gdouble _tmp154_;
					gdouble _tmp155_;
					gdouble _tmp156_;
					cairo_text_extents_t _tmp157_;
					gdouble _tmp158_;
					gdouble _tmp159_;
					gdouble _tmp160_;
					cairo_t* _tmp161_;
					gchar** _tmp162_;
					gint _tmp162__length1;
					gint _tmp163_;
					const gchar* _tmp164_;
					cairo_t* _tmp165_;
					cairo_t* _tmp166_;
					cairo_t* _tmp167_;
					gint _tmp168_;
					gdouble _tmp169_;
					gdouble _tmp170_;
					cairo_text_extents_t _tmp171_;
					gdouble _tmp172_;
					gdouble _tmp173_;
					gdouble _tmp174_;
					cairo_t* _tmp175_;
					gchar** _tmp176_;
					gint _tmp176__length1;
					gint _tmp177_;
					const gchar* _tmp178_;
					cairo_t* _tmp179_;
					gdouble _tmp180_;
					gint _tmp181_;
					gdouble _tmp182_;
					gint _tmp183_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					if (!_tmp111_) {
#line 1392 "chess-view.c"
						gint _tmp112_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						_tmp112_ = i;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						i = _tmp112_ + 1;
#line 1398 "chess-view.c"
					}
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp111_ = FALSE;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp113_ = i;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					if (!(_tmp113_ < 8)) {
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						break;
#line 1408 "chess-view.c"
					}
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp114_ = c;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp115_ = ranks;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp115__length1 = ranks_length1;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp116_ = i;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp117_ = _tmp115_[_tmp116_];
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_text_extents (_tmp114_, _tmp117_, &_tmp118_);
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					extents = _tmp118_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp119_ = c;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp119_);
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp120_ = c;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp121_ = file_offset;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp122_ = extents;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp123_ = _tmp122_.width;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp124_ = top;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp120_, _tmp121_ - (_tmp123_ / 2), _tmp124_);
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp125_ = c;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp126_ = files;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp126__length1 = files_length1;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp127_ = i;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp128_ = _tmp126_[_tmp127_];
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp125_, _tmp128_);
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp129_ = c;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp129_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp130_ = c;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp130_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp131_ = c;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp132_ = file_offset;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp133_ = extents;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp134_ = _tmp133_.width;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp135_ = bottom;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp131_, _tmp132_ - (_tmp134_ / 2), _tmp135_);
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp136_ = c;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp137_ = files;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp137__length1 = files_length1;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp138_ = i;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp139_ = _tmp137_[_tmp138_];
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp136_, _tmp139_);
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp140_ = c;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp140_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp141_ = c;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp142_ = ranks;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp142__length1 = ranks_length1;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp143_ = i;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp144_ = _tmp142_[_tmp143_];
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_text_extents (_tmp141_, _tmp144_, &_tmp145_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					extents = _tmp145_;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp146_ = extents;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp147_ = _tmp146_.y_bearing;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp148_ = extents;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp149_ = _tmp148_.height;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					y_offset = -(_tmp147_ + (_tmp149_ / 2));
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp150_ = c;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp150_);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp151_ = c;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp152_ = self->priv->square_size;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp153_ = chess_view_get_border_size (self);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp154_ = _tmp153_;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp155_ = chess_view_get_border_size (self);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp156_ = _tmp155_;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp157_ = extents;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp158_ = _tmp157_.width;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp159_ = rank_offset;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp160_ = y_offset;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp151_, -(((((gdouble) _tmp152_) * 4) + _tmp154_) - ((_tmp156_ - _tmp158_) / 2)), _tmp159_ + _tmp160_);
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp161_ = c;
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp162_ = ranks;
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp162__length1 = ranks_length1;
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp163_ = i;
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp164_ = _tmp162_[_tmp163_];
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp161_, _tmp164_);
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp165_ = c;
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp165_);
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp166_ = c;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp166_);
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp167_ = c;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp168_ = self->priv->square_size;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp169_ = chess_view_get_border_size (self);
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp170_ = _tmp169_;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp171_ = extents;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp172_ = _tmp171_.width;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp173_ = rank_offset;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp174_ = y_offset;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp167_, (((gdouble) _tmp168_) * 4) + ((_tmp170_ - _tmp172_) / 2), _tmp173_ + _tmp174_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp175_ = c;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp176_ = ranks;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp176__length1 = ranks_length1;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp177_ = i;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp178_ = _tmp176_[_tmp177_];
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp175_, _tmp178_);
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp179_ = c;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp179_);
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp180_ = file_offset;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp181_ = self->priv->square_size;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					file_offset = _tmp180_ + _tmp181_;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp182_ = rank_offset;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp183_ = self->priv->square_size;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					rank_offset = _tmp182_ + _tmp183_;
#line 1604 "chess-view.c"
				}
			}
		}
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp184_ = c;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_restore (_tmp184_);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 1616 "chess-view.c"
	}
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp185_ = chess_view_get_scene (self);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp186_ = _tmp185_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp187_ = chess_scene_get_game (_tmp186_);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp188_ = _tmp187_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp189_ = chess_game_get_should_show_paused_overlay (_tmp188_);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp190_ = _tmp189_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp190_) {
#line 1632 "chess-view.c"
		cairo_t* _tmp191_;
		ChessScene* _tmp192_;
		ChessScene* _tmp193_;
		gdouble _tmp194_;
		gdouble _tmp195_;
		cairo_t* _tmp196_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp191_ = c;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp192_ = chess_view_get_scene (self);
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp193_ = _tmp192_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp194_ = chess_scene_get_board_angle (_tmp193_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp195_ = _tmp194_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		cairo_rotate (_tmp191_, (G_PI * _tmp195_) / 180.0);
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp196_ = c;
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		chess_view_draw_paused_overlay (self, _tmp196_);
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		result = TRUE;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return result;
#line 1659 "chess-view.c"
	}
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp197_ = chess_view_get_scene (self);
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp198_ = _tmp197_;
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp199_ = _tmp198_->pieces;
#line 1667 "chess-view.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		model_collection = _tmp199_;
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1675 "chess-view.c"
			ChessModel* _tmp200_;
			ChessModel* model = NULL;
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp200_ = _g_object_ref0 ((ChessModel*) model_it->data);
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			model = _tmp200_;
#line 1682 "chess-view.c"
			{
				cairo_t* _tmp201_;
				cairo_t* _tmp202_;
				ChessModel* _tmp203_;
				gdouble _tmp204_;
				gint _tmp205_;
				ChessModel* _tmp206_;
				gdouble _tmp207_;
				gint _tmp208_;
				cairo_t* _tmp209_;
				gint _tmp210_;
				gint _tmp211_;
				cairo_t* _tmp212_;
				ChessScene* _tmp213_;
				ChessScene* _tmp214_;
				gdouble _tmp215_;
				gdouble _tmp216_;
				cairo_surface_t* _tmp217_ = NULL;
				ChessModel* _tmp218_;
				gboolean _tmp219_;
				gint _tmp222_ = 0;
				ChessModel* _tmp223_;
				gboolean _tmp224_;
				gdouble _tmp227_ = 0.0;
				gboolean _tmp228_ = FALSE;
				ChessModel* _tmp229_;
				gboolean _tmp230_;
				cairo_t* _tmp235_;
				ChessModel* _tmp236_;
				ChessPiece* _tmp237_;
				cairo_t* _tmp238_;
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp201_ = c;
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				cairo_save (_tmp201_);
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp202_ = c;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp203_ = model;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp204_ = _tmp203_->x;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp205_ = self->priv->square_size;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp206_ = model;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp207_ = _tmp206_->y;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp208_ = self->priv->square_size;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				cairo_translate (_tmp202_, (_tmp204_ - 4) * _tmp205_, (3 - _tmp207_) * _tmp208_);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp209_ = c;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp210_ = self->priv->square_size;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp211_ = self->priv->square_size;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				cairo_translate (_tmp209_, (gdouble) (_tmp210_ / 2), (gdouble) (_tmp211_ / 2));
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp212_ = c;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp213_ = chess_view_get_scene (self);
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp214_ = _tmp213_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp215_ = chess_scene_get_board_angle (_tmp214_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp216_ = _tmp215_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				cairo_rotate (_tmp212_, ((-G_PI) * _tmp216_) / 180.0);
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp218_ = model;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp219_ = _tmp218_->is_selected;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (_tmp219_) {
#line 1760 "chess-view.c"
					cairo_surface_t* _tmp220_;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp220_ = self->priv->selected_model_surface;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp217_ = _tmp220_;
#line 1766 "chess-view.c"
				} else {
					cairo_surface_t* _tmp221_;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp221_ = self->priv->model_surface;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp217_ = _tmp221_;
#line 1773 "chess-view.c"
				}
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp223_ = model;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp224_ = _tmp223_->is_selected;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (_tmp224_) {
#line 1781 "chess-view.c"
					gint _tmp225_;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp225_ = self->priv->selected_square_size;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp222_ = _tmp225_;
#line 1787 "chess-view.c"
				} else {
					gint _tmp226_;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp226_ = self->priv->square_size;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp222_ = _tmp226_;
#line 1794 "chess-view.c"
				}
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp229_ = model;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp230_ = _tmp229_->under_threat;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (_tmp230_) {
#line 1802 "chess-view.c"
					ChessScene* _tmp231_;
					ChessScene* _tmp232_;
					gboolean _tmp233_;
					gboolean _tmp234_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp231_ = chess_view_get_scene (self);
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp232_ = _tmp231_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp233_ = chess_scene_get_show_move_hints (_tmp232_);
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp234_ = _tmp233_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp228_ = _tmp234_;
#line 1817 "chess-view.c"
				} else {
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp228_ = FALSE;
#line 1821 "chess-view.c"
				}
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (_tmp228_) {
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp227_ = 0.8;
#line 1827 "chess-view.c"
				} else {
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp227_ = 1.0;
#line 1831 "chess-view.c"
				}
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp235_ = c;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp236_ = model;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp237_ = _tmp236_->piece;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				chess_view_draw_piece (self, _tmp235_, _tmp217_, _tmp222_, _tmp237_, _tmp227_);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp238_ = c;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				cairo_restore (_tmp238_);
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_g_object_unref0 (model);
#line 1847 "chess-view.c"
			}
		}
	}
	{
		gint rank;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		rank = 0;
#line 1855 "chess-view.c"
		{
			gboolean _tmp239_;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			_tmp239_ = TRUE;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
			while (TRUE) {
#line 1862 "chess-view.c"
				gint _tmp241_;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (!_tmp239_) {
#line 1866 "chess-view.c"
					gint _tmp240_;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					_tmp240_ = rank;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					rank = _tmp240_ + 1;
#line 1872 "chess-view.c"
				}
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp239_ = FALSE;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				_tmp241_ = rank;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
				if (!(_tmp241_ < 8)) {
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					break;
#line 1882 "chess-view.c"
				}
				{
					gint file;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
					file = 0;
#line 1888 "chess-view.c"
					{
						gboolean _tmp242_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						_tmp242_ = TRUE;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
						while (TRUE) {
#line 1895 "chess-view.c"
							gint _tmp244_;
							gboolean _tmp245_ = FALSE;
							ChessScene* _tmp246_;
							ChessScene* _tmp247_;
							gboolean _tmp248_;
							gboolean _tmp249_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (!_tmp242_) {
#line 1904 "chess-view.c"
								gint _tmp243_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp243_ = file;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								file = _tmp243_ + 1;
#line 1910 "chess-view.c"
							}
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp242_ = FALSE;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp244_ = file;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (!(_tmp244_ < 8)) {
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								break;
#line 1920 "chess-view.c"
							}
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp246_ = chess_view_get_scene (self);
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp247_ = _tmp246_;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp248_ = chess_scene_get_show_move_hints (_tmp247_);
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							_tmp249_ = _tmp248_;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (_tmp249_) {
#line 1932 "chess-view.c"
								ChessScene* _tmp250_;
								ChessScene* _tmp251_;
								gint _tmp252_;
								gint _tmp253_;
								gboolean _tmp254_;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp250_ = chess_view_get_scene (self);
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp251_ = _tmp250_;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp252_ = rank;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp253_ = file;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp254_ = chess_scene_can_move (_tmp251_, _tmp252_, _tmp253_);
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp245_ = _tmp254_;
#line 1950 "chess-view.c"
							} else {
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp245_ = FALSE;
#line 1954 "chess-view.c"
							}
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
							if (_tmp245_) {
#line 1958 "chess-view.c"
								cairo_t* _tmp255_;
								cairo_t* _tmp256_;
								gint _tmp257_;
								gint _tmp258_;
								gint _tmp259_;
								gint _tmp260_;
								cairo_t* _tmp261_;
								gint _tmp262_;
								gint _tmp263_;
								cairo_t* _tmp264_;
								ChessScene* _tmp265_;
								ChessScene* _tmp266_;
								gdouble _tmp267_;
								gdouble _tmp268_;
								cairo_t* _tmp269_;
								cairo_surface_t* _tmp270_;
								gint _tmp271_;
								ChessScene* _tmp272_;
								ChessScene* _tmp273_;
								ChessPiece* _tmp274_;
								ChessPiece* _tmp275_;
								cairo_t* _tmp276_;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp255_ = c;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_save (_tmp255_);
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp256_ = c;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp257_ = file;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp258_ = self->priv->square_size;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp259_ = rank;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp260_ = self->priv->square_size;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_translate (_tmp256_, (gdouble) ((_tmp257_ - 4) * _tmp258_), (gdouble) ((3 - _tmp259_) * _tmp260_));
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp261_ = c;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp262_ = self->priv->square_size;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp263_ = self->priv->square_size;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_translate (_tmp261_, (gdouble) (_tmp262_ / 2), (gdouble) (_tmp263_ / 2));
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp264_ = c;
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp265_ = chess_view_get_scene (self);
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp266_ = _tmp265_;
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp267_ = chess_scene_get_board_angle (_tmp266_);
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp268_ = _tmp267_;
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_rotate (_tmp264_, ((-G_PI) * _tmp268_) / 180.0);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp269_ = c;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp270_ = self->priv->model_surface;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp271_ = self->priv->square_size;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp272_ = chess_view_get_scene (self);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp273_ = _tmp272_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp274_ = chess_scene_get_selected_piece (_tmp273_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp275_ = _tmp274_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								chess_view_draw_piece (self, _tmp269_, _tmp270_, _tmp271_, _tmp275_, 0.1);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_g_object_unref0 (_tmp275_);
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								_tmp276_ = c;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
								cairo_restore (_tmp276_);
#line 2039 "chess-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	result = TRUE;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return result;
#line 2051 "chess-view.c"
}


static void chess_view_draw_piece (ChessView* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha) {
	cairo_t* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint offset;
	ChessPiece* _tmp3_;
	PieceType _tmp4_;
	ChessPiece* _tmp5_;
	Color _tmp6_;
	Color _tmp7_;
	cairo_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	cairo_t* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gdouble _tmp18_;
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c != NULL);
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (surface != NULL);
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (piece != NULL);
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = c;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp1_ = size;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = size;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp0_, (gdouble) ((-_tmp1_) / 2), (gdouble) ((-_tmp2_) / 2));
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp3_ = piece;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp4_ = _tmp3_->type;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	offset = (gint) _tmp4_;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp5_ = piece;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp6_ = chess_piece_get_color (_tmp5_);
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp7_ = _tmp6_;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp7_ == COLOR_BLACK) {
#line 2105 "chess-view.c"
		gint _tmp8_;
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp8_ = offset;
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		offset = _tmp8_ + 6;
#line 2111 "chess-view.c"
	}
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp9_ = c;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp10_ = surface;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp11_ = offset;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp12_ = size;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_set_source_surface (_tmp9_, _tmp10_, (gdouble) ((-_tmp11_) * _tmp12_), (gdouble) 0);
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp13_ = c;
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp14_ = size;
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp15_ = size;
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_rectangle (_tmp13_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp14_, (gdouble) _tmp15_);
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp16_ = c;
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_clip (_tmp16_);
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp17_ = c;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp18_ = alpha;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_paint_with_alpha (_tmp17_, _tmp18_);
#line 2141 "chess-view.c"
}


static gboolean chess_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	ChessGame* _tmp4_;
	ChessGame* _tmp5_;
	ChessScene* _tmp14_;
	ChessScene* _tmp15_;
	ChessGame* _tmp16_;
	ChessGame* _tmp17_;
	ChessResult _tmp18_;
	gint file;
	GdkEventButton* _tmp19_;
	gdouble _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	gint rank;
	GdkEventButton* _tmp25_;
	gdouble _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gdouble _tmp30_;
	ChessScene* _tmp31_;
	ChessScene* _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gint _tmp40_;
	ChessScene* _tmp44_;
	ChessScene* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self = (ChessView*) base;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = chess_view_get_scene (self);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp3_ = _tmp2_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp4_ = chess_scene_get_game (_tmp3_);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp5_ = _tmp4_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp5_ == NULL) {
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp1_ = TRUE;
#line 2201 "chess-view.c"
	} else {
		GdkEventButton* _tmp6_;
		guint _tmp7_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp6_ = event;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp7_ = _tmp6_->button;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp1_ = _tmp7_ != ((guint) 1);
#line 2211 "chess-view.c"
	}
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp1_) {
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp0_ = TRUE;
#line 2217 "chess-view.c"
	} else {
		ChessScene* _tmp8_;
		ChessScene* _tmp9_;
		ChessGame* _tmp10_;
		ChessGame* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp8_ = chess_view_get_scene (self);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp9_ = _tmp8_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp10_ = chess_scene_get_game (_tmp9_);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp11_ = _tmp10_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp12_ = chess_game_get_should_show_paused_overlay (_tmp11_);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp13_ = _tmp12_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp0_ = _tmp13_;
#line 2239 "chess-view.c"
	}
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp0_) {
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		result = FALSE;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return result;
#line 2247 "chess-view.c"
	}
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp14_ = chess_view_get_scene (self);
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp15_ = _tmp14_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp16_ = chess_scene_get_game (_tmp15_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp17_ = _tmp16_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp18_ = _tmp17_->result;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp18_ != CHESS_RESULT_IN_PROGRESS) {
#line 282 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		result = FALSE;
#line 282 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return result;
#line 2265 "chess-view.c"
	}
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp19_ = event;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp20_ = _tmp19_->x;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp21_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp22_ = self->priv->square_size;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp23_ = self->priv->square_size;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp24_ = floor (((_tmp20_ - (0.5 * _tmp21_)) + (_tmp22_ * 4)) / _tmp23_);
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	file = (gint) _tmp24_;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp25_ = event;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp26_ = _tmp25_->y;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp27_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp28_ = self->priv->square_size;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp29_ = self->priv->square_size;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp30_ = floor (((_tmp26_ - (0.5 * _tmp27_)) + (_tmp28_ * 4)) / _tmp29_);
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	rank = 7 - ((gint) _tmp30_);
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp31_ = chess_view_get_scene (self);
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp32_ = _tmp31_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp33_ = chess_scene_get_board_angle (_tmp32_);
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp34_ = _tmp33_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp34_ == 180.0) {
#line 2305 "chess-view.c"
		gint _tmp35_;
		gint _tmp36_;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp35_ = rank;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		rank = 7 - _tmp35_;
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp36_ = file;
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		file = 7 - _tmp36_;
#line 2316 "chess-view.c"
	}
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp40_ = file;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp40_ < 0) {
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp39_ = TRUE;
#line 2324 "chess-view.c"
	} else {
		gint _tmp41_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp41_ = file;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp39_ = _tmp41_ >= 8;
#line 2331 "chess-view.c"
	}
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp39_) {
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp38_ = TRUE;
#line 2337 "chess-view.c"
	} else {
		gint _tmp42_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp42_ = rank;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp38_ = _tmp42_ < 0;
#line 2344 "chess-view.c"
	}
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp38_) {
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp37_ = TRUE;
#line 2350 "chess-view.c"
	} else {
		gint _tmp43_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp43_ = rank;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		_tmp37_ = _tmp43_ >= 8;
#line 2357 "chess-view.c"
	}
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	if (_tmp37_) {
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		result = FALSE;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		return result;
#line 2365 "chess-view.c"
	}
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp44_ = chess_view_get_scene (self);
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp45_ = _tmp44_;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp46_ = file;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp47_ = rank;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_scene_select_square (_tmp45_, _tmp46_, _tmp47_);
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	result = TRUE;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return result;
#line 2381 "chess-view.c"
}


static void chess_view_scene_changed_cb (ChessView* self, ChessScene* scene) {
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (scene != NULL);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 2392 "chess-view.c"
}


void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	gint _tmp5_;
	gchar* text;
	gchar* _tmp6_;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp7_;
	cairo_text_extents_t _tmp8_ = {0};
	cairo_t* _tmp9_;
	cairo_text_extents_t _tmp10_;
	gdouble _tmp11_;
	cairo_text_extents_t _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c != NULL);
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = c;
#line 309 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_save (_tmp0_);
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp1_ = c;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_set_source_rgba (_tmp1_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 312 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = c;
#line 312 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_paint (_tmp2_);
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp3_ = c;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_select_font_face (_tmp3_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp4_ = c;
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_set_font_size (_tmp4_, _tmp5_ * 0.125);
#line 317 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp6_ = g_strdup (_ ("Paused"));
#line 317 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	text = _tmp6_;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp7_ = c;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_text_extents (_tmp7_, text, &_tmp8_);
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	extents = _tmp8_;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp9_ = c;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp10_ = extents;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp11_ = _tmp10_.width;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp12_ = extents;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp13_ = _tmp12_.height;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_move_to (_tmp9_, (-_tmp11_) / 2.0, _tmp13_ / 2.0);
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp14_ = c;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_set_source_rgb (_tmp14_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp15_ = c;
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_show_text (_tmp15_, text);
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp16_ = c;
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	cairo_restore (_tmp16_);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_g_free0 (text);
#line 2478 "chess-view.c"
}


ChessScene* chess_view_get_scene (ChessView* self) {
	ChessScene* result;
	ChessScene* _tmp0_;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = self->priv->_scene;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	result = _tmp0_;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return result;
#line 2493 "chess-view.c"
}


static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_scene_changed_cb ((ChessView*) self, _sender);
#line 2500 "chess-view.c"
}


void chess_view_set_scene (ChessView* self, ChessScene* value) {
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = value;
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_g_object_unref0 (self->priv->_scene);
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->_scene = _tmp1_;
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp2_ = self->priv->_scene;
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _chess_view_scene_changed_cb_chess_scene_changed, self, 0);
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_object_notify ((GObject *) self, "scene");
#line 2526 "chess-view.c"
}


static gdouble chess_view_get_border_size (ChessView* self) {
	gdouble result;
	gint _tmp0_;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = self->priv->square_size;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	result = (gdouble) (_tmp0_ / 2);
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	return result;
#line 2541 "chess-view.c"
}


static void chess_view_class_init (ChessViewClass * klass) {
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	chess_view_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_type_class_add_private (klass, sizeof (ChessViewPrivate));
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget *, GdkEventConfigure*)) chess_view_real_configure_event;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) chess_view_real_draw;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) chess_view_real_button_press_event;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view_get_property;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_view_set_property;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_view_finalize;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_VIEW_SCENE, g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2564 "chess-view.c"
}


static void chess_view_instance_init (ChessView * self) {
	gchar* _tmp0_;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv = CHESS_VIEW_GET_PRIVATE (self);
#line 15 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->border = 6;
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_tmp0_ = g_strdup ("");
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self->priv->loaded_theme_name = _tmp0_;
#line 2578 "chess-view.c"
}


static void chess_view_finalize (GObject * obj) {
	ChessView * self;
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW, ChessView);
#line 18 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->model_surface);
#line 19 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_g_free0 (self->priv->loaded_theme_name);
#line 22 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	_g_object_unref0 (self->priv->_scene);
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (chess_view_parent_class)->finalize (obj);
#line 2596 "chess-view.c"
}


GType chess_view_get_type (void) {
	static volatile gsize chess_view_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView), 0, (GInstanceInitFunc) chess_view_instance_init, NULL };
		GType chess_view_type_id;
		chess_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "ChessView", &g_define_type_info, 0);
		g_once_init_leave (&chess_view_type_id__volatile, chess_view_type_id);
	}
	return chess_view_type_id__volatile;
}


static void _vala_chess_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		case CHESS_VIEW_SCENE:
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		g_value_set_object (value, chess_view_get_scene (self));
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		break;
#line 2623 "chess-view.c"
		default:
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		break;
#line 2629 "chess-view.c"
	}
}


static void _vala_chess_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		case CHESS_VIEW_SCENE:
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		chess_view_set_scene (self, g_value_get_object (value));
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		break;
#line 2645 "chess-view.c"
		default:
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/chess-view.vala"
		break;
#line 2651 "chess-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



