/* rygel-gst-transcoder.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-gst-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE
} RygelGstTranscoderError;
#define RYGEL_GST_TRANSCODER_ERROR rygel_gst_transcoder_error_quark ()
struct _RygelGstTranscoder {
	GObject parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	GObjectClass parent_class;
	RygelMediaResource* (*get_resource_for_item) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	guint (*get_distance) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelGstTranscoderPrivate {
	gchar* _name;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _extension;
	gchar* _preset;
	GstElement* decoder;
	GstElement* encoder;
	gboolean link_failed;
};

struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};


static gpointer rygel_gst_transcoder_parent_class = NULL;

GQuark rygel_gst_transcoder_error_quark (void);
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderPrivate))
enum  {
	RYGEL_GST_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_GST_TRANSCODER_NAME,
	RYGEL_GST_TRANSCODER_MIME_TYPE,
	RYGEL_GST_TRANSCODER_DLNA_PROFILE,
	RYGEL_GST_TRANSCODER_EXTENSION,
	RYGEL_GST_TRANSCODER_PRESET
};
#define RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET "Rygel DLNA preset"
#define RYGEL_GST_TRANSCODER_DECODE_BIN "decodebin"
#define RYGEL_GST_TRANSCODER_ENCODE_BIN "encodebin"
#define RYGEL_GST_TRANSCODER_DESCRIPTION "Encoder and decoder are not " "compatible"
RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type, const gchar* name, const gchar* mime_type, const gchar* dlna_profile, const gchar* extension);
static void rygel_gst_transcoder_real_constructed (GObject* base);
RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item);
static RygelMediaResource* rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item);
const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_extension (RygelGstTranscoder* self);
guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item);
static guint rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
RygelGstDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self, RygelMediaFileItem* item, RygelDataSource* src, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self);
static inline void _dynamic_set_profile2 (GstElement* obj, GstEncodingProfile* value);
static inline GstElement* _dynamic_get_profile3 (GstElement* obj);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj);
static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad);
static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self, GstElement* decodebin);
static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self);
gboolean rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self, RygelMediaFileItem* item);
gboolean rygel_gst_transcoder_mime_type_is_a (RygelGstTranscoder* self, const gchar* mime_type1, const gchar* mime_type2);
static void rygel_gst_transcoder_set_name (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_set_extension (RygelGstTranscoder* self, const gchar* value);
const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_finalize (GObject* obj);
static void _vala_rygel_gst_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_gst_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_gst_transcoder_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_transcoder_error-quark");
}


RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type, const gchar* name, const gchar* mime_type, const gchar* dlna_profile, const gchar* extension) {
	RygelGstTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = mime_type;
	_tmp2_ = dlna_profile;
	_tmp3_ = extension;
	self = (RygelGstTranscoder*) g_object_new (object_type, "name", _tmp0_, "mime-type", _tmp1_, "dlna-profile", _tmp2_, "extension", _tmp3_, NULL);
	return self;
}


static void rygel_gst_transcoder_real_constructed (GObject* base) {
	RygelGstTranscoder * self;
	self = (RygelGstTranscoder*) base;
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	self->priv->link_failed = TRUE;
}


/**
     * Get the supported (transcoded) MediaResource for the given content item
     *
     * @return A MediaResources or null if the transcoder cannot
     * transcode this media item
     */
static RygelMediaResource* rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item) {
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaResource* _tmp1_ = NULL;
	RygelMediaResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelMediaResource* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaResource* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaResource* _tmp8_ = NULL;
	RygelMediaResource* _tmp9_ = NULL;
	RygelMediaResource* _tmp10_ = NULL;
	RygelMediaFileItem* _tmp11_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = rygel_media_resource_new (_tmp0_);
	res = _tmp1_;
	_tmp2_ = res;
	_tmp3_ = self->priv->_mime_type;
	rygel_media_resource_set_mime_type (_tmp2_, _tmp3_);
	_tmp4_ = res;
	_tmp5_ = self->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (_tmp4_, _tmp5_);
	_tmp6_ = res;
	_tmp7_ = self->priv->_extension;
	rygel_media_resource_set_extension (_tmp6_, _tmp7_);
	_tmp8_ = res;
	rygel_media_resource_set_dlna_conversion (_tmp8_, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp9_ = res;
	rygel_media_resource_set_dlna_flags (_tmp9_, ((GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	_tmp10_ = res;
	rygel_media_resource_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_TIMESEEK);
	_tmp11_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaResource* _tmp12_ = NULL;
		RygelMediaFileItem* _tmp13_ = NULL;
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp12_ = res;
		_tmp13_ = item;
		_tmp14_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp13_) : NULL);
		_tmp15_ = _tmp14_;
		rygel_media_resource_set_duration (_tmp12_, _tmp15_);
	}
	result = res;
	return result;
}


RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_resource_for_item (self, item);
}


/**
     * Gets a numeric value that gives an gives an estimate of how hard
     * it would be for this transcoder to trancode @item to the target profile of
     * this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item) {
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item) {
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_distance (self, item);
}


/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static inline void _dynamic_set_profile2 (GstElement* obj, GstEncodingProfile* value) {
	g_object_set (obj, "profile", value, NULL);
}


static inline GstElement* _dynamic_get_profile3 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "profile", &result, NULL);
	return result;
}


static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj) {
	GstEncodingProfile* result;
	g_object_get (obj, "profile", &result, NULL);
	return result;
}


static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_gst_transcoder_on_decoder_pad_added ((RygelGstTranscoder*) self, _sender, pad);
}


static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self) {
	rygel_gst_transcoder_on_no_more_pads ((RygelGstTranscoder*) self, _sender);
}


RygelGstDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self, RygelMediaFileItem* item, RygelDataSource* src, GError** error) {
	RygelGstDataSource* result = NULL;
	RygelDataSource* _tmp0_ = NULL;
	RygelGstDataSource* orig_source = NULL;
	RygelDataSource* _tmp1_ = NULL;
	RygelGstDataSource* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	GstEncodingProfile* _tmp10_ = NULL;
	GstEncodingProfile* _tmp11_ = NULL;
	GstElement* _tmp12_ = NULL;
	GstElement* _tmp13_ = NULL;
	GstElement* _tmp14_ = NULL;
	GObjectClass* _tmp19_ = NULL;
	GType _tmp20_ = 0UL;
	const gchar* _tmp21_ = NULL;
	GstElement* _tmp22_ = NULL;
	GstEncodingProfile* _tmp23_ = NULL;
	GstEncodingProfile* _tmp24_ = NULL;
	GstBin* bin = NULL;
	GstBin* _tmp25_ = NULL;
	GstBin* _tmp26_ = NULL;
	RygelGstDataSource* _tmp27_ = NULL;
	GstElement* _tmp28_ = NULL;
	GstElement* _tmp29_ = NULL;
	GstElement* _tmp30_ = NULL;
	RygelGstDataSource* _tmp31_ = NULL;
	GstElement* _tmp32_ = NULL;
	GstElement* _tmp33_ = NULL;
	GstElement* _tmp34_ = NULL;
	GstElement* _tmp35_ = NULL;
	GstPad* pad = NULL;
	GstElement* _tmp36_ = NULL;
	GstPad* _tmp37_ = NULL;
	GstGhostPad* ghost = NULL;
	GstPad* _tmp38_ = NULL;
	GstGhostPad* _tmp39_ = NULL;
	GstBin* _tmp40_ = NULL;
	GstGhostPad* _tmp41_ = NULL;
	RygelGstDataSource* new_source = NULL;
	GstBin* _tmp42_ = NULL;
	RygelGstDataSource* _tmp43_ = NULL;
	RygelGstDataSource* _tmp44_ = NULL;
	RygelGstDataSource* _tmp45_ = NULL;
	RygelMediaResource* _tmp46_ = NULL;
	RygelMediaResource* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	_tmp0_ = src;
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_GST_DATA_SOURCE), "src is GstDataSource");
	_tmp1_ = src;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_GST_DATA_SOURCE) ? ((RygelGstDataSource*) _tmp1_) : NULL);
	orig_source = _tmp2_;
	_tmp4_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_DECODE_BIN, RYGEL_GST_TRANSCODER_DECODE_BIN, &_inner_error_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (orig_source);
		return NULL;
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->priv->decoder);
	self->priv->decoder = _tmp5_;
	_tmp7_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_ENCODE_BIN, RYGEL_GST_TRANSCODER_ENCODE_BIN, &_inner_error_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (orig_source);
		return NULL;
	}
	_tmp8_ = _tmp6_;
	_tmp6_ = NULL;
	_g_object_unref0 (self->priv->encoder);
	self->priv->encoder = _tmp8_;
	_tmp9_ = self->priv->encoder;
	_tmp10_ = rygel_gst_transcoder_get_encoding_profile (self);
	_tmp11_ = _tmp10_;
	_dynamic_set_profile2 (_tmp9_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->encoder;
	_tmp13_ = _dynamic_get_profile3 (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == NULL) {
		gchar* message = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		_tmp15_ = _ ("Could not create a transcoder configuration. Your GStreamer installati" \
"on might be missing a plug-in");
		_tmp16_ = g_strdup (_tmp15_);
		message = _tmp16_;
		_tmp17_ = message;
		_tmp18_ = g_error_new_literal (RYGEL_GST_TRANSCODER_ERROR, RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE, _tmp17_);
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (orig_source);
		return NULL;
	}
	_tmp19_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp20_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp19_);
	_tmp21_ = g_type_name (_tmp20_);
	g_debug ("rygel-gst-transcoder.vala:143: %s using the following encoding profile" \
":", _tmp21_);
	_tmp22_ = self->priv->encoder;
	_tmp23_ = _dynamic_get_profile4 (_tmp22_);
	_tmp24_ = _tmp23_;
	rygel_gst_utils_dump_encoding_profile (_tmp24_, 2);
	_tmp25_ = (GstBin*) gst_bin_new ("transcoder-source");
	g_object_ref_sink (_tmp25_);
	bin = _tmp25_;
	_tmp26_ = bin;
	_tmp27_ = orig_source;
	_tmp28_ = _tmp27_->src;
	_tmp29_ = self->priv->decoder;
	_tmp30_ = self->priv->encoder;
	gst_bin_add_many (_tmp26_, _tmp28_, _tmp29_, _tmp30_, NULL);
	_tmp31_ = orig_source;
	_tmp32_ = _tmp31_->src;
	_tmp33_ = self->priv->decoder;
	gst_element_link (_tmp32_, _tmp33_);
	_tmp34_ = self->priv->decoder;
	g_signal_connect_object (_tmp34_, "pad-added", (GCallback) _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added, self, 0);
	_tmp35_ = self->priv->decoder;
	g_signal_connect_object (_tmp35_, "no-more-pads", (GCallback) _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads, self, 0);
	_tmp36_ = self->priv->encoder;
	_tmp37_ = gst_element_get_static_pad (_tmp36_, "src");
	pad = _tmp37_;
	_tmp38_ = pad;
	_tmp39_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp38_);
	g_object_ref_sink (_tmp39_);
	ghost = _tmp39_;
	_tmp40_ = bin;
	_tmp41_ = ghost;
	gst_element_add_pad ((GstElement*) _tmp40_, (GstPad*) _tmp41_);
	_tmp42_ = bin;
	_tmp43_ = rygel_gst_data_source_new_from_element ((GstElement*) _tmp42_);
	new_source = _tmp43_;
	_tmp44_ = new_source;
	_tmp45_ = orig_source;
	_tmp46_ = _tmp45_->res;
	_tmp47_ = _g_object_ref0 (_tmp46_);
	_g_object_unref0 (_tmp44_->res);
	_tmp44_->res = _tmp47_;
	result = new_source;
	_g_object_unref0 (ghost);
	_g_object_unref0 (pad);
	_g_object_unref0 (bin);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (orig_source);
	return result;
}


/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_encoding_profile (self);
}


static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad) {
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_ = NULL;
	GstPad* _tmp1_ = NULL;
	GstPad* _tmp2_ = NULL;
	GstPad* _tmp3_ = NULL;
	GstPad* _tmp8_ = NULL;
	gboolean pad_link_ok = FALSE;
	GstPad* _tmp13_ = NULL;
	GstPad* _tmp14_ = NULL;
	GstPadLinkReturn _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	g_return_if_fail (new_pad != NULL);
	_tmp0_ = self->priv->encoder;
	_tmp1_ = new_pad;
	_tmp2_ = gst_element_get_compatible_pad (_tmp0_, _tmp1_, NULL);
	_g_object_unref0 (sinkpad);
	sinkpad = _tmp2_;
	_tmp3_ = sinkpad;
	if (_tmp3_ == NULL) {
		GstCaps* caps = NULL;
		GstPad* _tmp4_ = NULL;
		GstCaps* _tmp5_ = NULL;
		GstElement* _tmp6_ = NULL;
		GstCaps* _tmp7_ = NULL;
		_tmp4_ = new_pad;
		_tmp5_ = gst_pad_query_caps (_tmp4_, NULL);
		caps = _tmp5_;
		_tmp6_ = self->priv->encoder;
		_tmp7_ = caps;
		g_signal_emit_by_name (_tmp6_, "request-pad", _tmp7_, &sinkpad, NULL);
		_gst_caps_unref0 (caps);
	}
	_tmp8_ = sinkpad;
	if (_tmp8_ == NULL) {
		GstPad* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = new_pad;
		g_object_get ((GstObject*) _tmp9_, "name", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		g_debug ("rygel-gst-transcoder.vala:184: No compatible encodebin pad found for p" \
"ad '%s', ignoring..", _tmp12_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (sinkpad);
		return;
	}
	_tmp13_ = new_pad;
	_tmp14_ = sinkpad;
	_tmp15_ = gst_pad_link_full (_tmp13_, _tmp14_, GST_PAD_LINK_CHECK_DEFAULT);
	pad_link_ok = _tmp15_ == GST_PAD_LINK_OK;
	_tmp16_ = pad_link_ok;
	if (!_tmp16_) {
		GstPad* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GstPad* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp17_ = new_pad;
		g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = sinkpad;
		g_object_get ((GstObject*) _tmp21_, "name", &_tmp22_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		g_warning ("rygel-gst-transcoder.vala:192: Failed to link pad '%s' to '%s'", _tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp20_);
	} else {
		self->priv->link_failed = FALSE;
	}
	_g_object_unref0 (sinkpad);
	return;
}


static gpointer _gst_message_ref0 (gpointer self) {
	return self ? gst_message_ref (self) : NULL;
}


static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self, GstElement* decodebin) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	_tmp0_ = self->priv->link_failed;
	if (_tmp0_) {
		GstBin* bin = NULL;
		GstElement* _tmp1_ = NULL;
		GstObject* _tmp2_ = NULL;
		GstBin* _tmp3_ = NULL;
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		GstMessage* message = NULL;
		GstBin* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		GstMessage* _tmp7_ = NULL;
		GstBus* bus = NULL;
		GstBin* _tmp8_ = NULL;
		GstBus* _tmp9_ = NULL;
		GstBus* _tmp10_ = NULL;
		GstMessage* _tmp11_ = NULL;
		GstMessage* _tmp12_ = NULL;
		_tmp1_ = self->priv->encoder;
		_tmp2_ = gst_object_get_parent ((GstObject*) _tmp1_);
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gst_bin_get_type ()) ? ((GstBin*) _tmp2_) : NULL;
		if (_tmp3_ == NULL) {
			_g_object_unref0 (_tmp2_);
		}
		bin = _tmp3_;
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not link");
		_error_ = _tmp4_;
		_tmp5_ = bin;
		_tmp6_ = _error_;
		_tmp7_ = gst_message_new_error ((GstObject*) _tmp5_, _tmp6_, RYGEL_GST_TRANSCODER_DESCRIPTION);
		message = _tmp7_;
		_tmp8_ = bin;
		_tmp9_ = gst_element_get_bus ((GstElement*) _tmp8_);
		bus = _tmp9_;
		_tmp10_ = bus;
		_tmp11_ = message;
		_tmp12_ = _gst_message_ref0 (_tmp11_);
		gst_bus_post (_tmp10_, _tmp12_);
		_g_object_unref0 (bus);
		_gst_message_unref0 (message);
		_g_error_free0 (_error_);
		_g_object_unref0 (bin);
	}
}


gboolean rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self, RygelMediaFileItem* item) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	RygelMediaFileItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = self->priv->_mime_type;
	_tmp2_ = item;
	_tmp3_ = rygel_media_file_item_get_mime_type (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_gst_transcoder_mime_type_is_a (self, _tmp1_, _tmp4_);
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		RygelMediaFileItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp6_ = self->priv->_dlna_profile;
		_tmp7_ = item;
		_tmp8_ = rygel_media_file_item_get_dlna_profile (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp9_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = !_tmp0_;
	return result;
}


gboolean rygel_gst_transcoder_mime_type_is_a (RygelGstTranscoder* self, const gchar* mime_type1, const gchar* mime_type2) {
	gboolean result = FALSE;
	gchar* content_type1 = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* content_type2 = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type1 != NULL, FALSE);
	g_return_val_if_fail (mime_type2 != NULL, FALSE);
	_tmp0_ = mime_type1;
	_tmp1_ = g_content_type_get_mime_type (_tmp0_);
	content_type1 = _tmp1_;
	_tmp2_ = mime_type2;
	_tmp3_ = g_content_type_get_mime_type (_tmp2_);
	content_type2 = _tmp3_;
	_tmp4_ = g_content_type_is_a (content_type1, content_type2);
	result = _tmp4_;
	_g_free0 (content_type2);
	_g_free0 (content_type1);
	return result;
}


const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void rygel_gst_transcoder_set_name (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}


static void rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}


static void rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dlna_profile);
	self->priv->_dlna_profile = _tmp1_;
	g_object_notify ((GObject *) self, "dlna-profile");
}


const gchar* rygel_gst_transcoder_get_extension (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


static void rygel_gst_transcoder_set_extension (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp1_;
	g_object_notify ((GObject *) self, "extension");
}


const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preset;
	result = _tmp0_;
	return result;
}


void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_preset);
	self->priv->_preset = _tmp1_;
	g_object_notify ((GObject *) self, "preset");
}


static void rygel_gst_transcoder_class_init (RygelGstTranscoderClass * klass) {
	rygel_gst_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstTranscoderPrivate));
	((GObjectClass *) klass)->constructed = rygel_gst_transcoder_real_constructed;
	((RygelGstTranscoderClass *) klass)->get_resource_for_item = rygel_gst_transcoder_real_get_resource_for_item;
	((RygelGstTranscoderClass *) klass)->get_distance = rygel_gst_transcoder_real_get_distance;
	((RygelGstTranscoderClass *) klass)->get_encoding_profile = rygel_gst_transcoder_real_get_encoding_profile;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_gst_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_gst_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_PRESET, g_param_spec_string ("preset", "preset", "preset", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_gst_transcoder_instance_init (RygelGstTranscoder * self) {
	gchar* _tmp0_ = NULL;
	self->priv = RYGEL_GST_TRANSCODER_GET_PRIVATE (self);
	_tmp0_ = g_strdup (RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET);
	self->priv->_preset = _tmp0_;
}


static void rygel_gst_transcoder_finalize (GObject* obj) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_preset);
	_g_object_unref0 (self->priv->decoder);
	_g_object_unref0 (self->priv->encoder);
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->finalize (obj);
}


/**
 * The base Transcoder class used by gstreamer media engine.
 * Each implementation derives from it and must
 * implement get_resources_for_item and get_encoding_profile methods.
 */
GType rygel_gst_transcoder_get_type (void) {
	static volatile gsize rygel_gst_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstTranscoder), 0, (GInstanceInitFunc) rygel_gst_transcoder_instance_init, NULL };
		GType rygel_gst_transcoder_type_id;
		rygel_gst_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_transcoder_type_id__volatile, rygel_gst_transcoder_type_id);
	}
	return rygel_gst_transcoder_type_id__volatile;
}


static void _vala_rygel_gst_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	switch (property_id) {
		case RYGEL_GST_TRANSCODER_NAME:
		g_value_set_string (value, rygel_gst_transcoder_get_name (self));
		break;
		case RYGEL_GST_TRANSCODER_MIME_TYPE:
		g_value_set_string (value, rygel_gst_transcoder_get_mime_type (self));
		break;
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE:
		g_value_set_string (value, rygel_gst_transcoder_get_dlna_profile (self));
		break;
		case RYGEL_GST_TRANSCODER_EXTENSION:
		g_value_set_string (value, rygel_gst_transcoder_get_extension (self));
		break;
		case RYGEL_GST_TRANSCODER_PRESET:
		g_value_set_string (value, rygel_gst_transcoder_get_preset (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_gst_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	switch (property_id) {
		case RYGEL_GST_TRANSCODER_NAME:
		rygel_gst_transcoder_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_MIME_TYPE:
		rygel_gst_transcoder_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE:
		rygel_gst_transcoder_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_EXTENSION:
		rygel_gst_transcoder_set_extension (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_PRESET:
		rygel_gst_transcoder_set_preset (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



