/* gitg-credentials-manager.c generated by valac 0.35.5.2-9e6c0, the Vala compiler
 * generated from gitg-credentials-manager.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <stdio.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_CREDENTIALS_MANAGER (gitg_credentials_manager_get_type ())
#define GITG_CREDENTIALS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager))
#define GITG_CREDENTIALS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerClass))
#define GITG_IS_CREDENTIALS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CREDENTIALS_MANAGER))
#define GITG_IS_CREDENTIALS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_CREDENTIALS_MANAGER))
#define GITG_CREDENTIALS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerClass))

typedef struct _GitgCredentialsManager GitgCredentialsManager;
typedef struct _GitgCredentialsManagerClass GitgCredentialsManagerClass;
typedef struct _GitgCredentialsManagerPrivate GitgCredentialsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GITG_TYPE_AUTHENTICATION_LIFE_TIME (gitg_authentication_life_time_get_type ())
typedef struct _Block5Data Block5Data;
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))

#define GITG_TYPE_AUTHENTICATION_DIALOG (gitg_authentication_dialog_get_type ())
#define GITG_AUTHENTICATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialog))
#define GITG_AUTHENTICATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialogClass))
#define GITG_IS_AUTHENTICATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHENTICATION_DIALOG))
#define GITG_IS_AUTHENTICATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHENTICATION_DIALOG))
#define GITG_AUTHENTICATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialogClass))

typedef struct _GitgAuthenticationDialog GitgAuthenticationDialog;
typedef struct _GitgAuthenticationDialogClass GitgAuthenticationDialogClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _GitgParamSpecCredentialsManager GitgParamSpecCredentialsManager;

typedef enum  {
	GITG_CREDENTIALS_ERROR_CANCELLED
} GitgCredentialsError;
#define GITG_CREDENTIALS_ERROR gitg_credentials_error_quark ()
struct _GitgCredentialsManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgCredentialsManagerPrivate * priv;
};

struct _GitgCredentialsManagerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgCredentialsManager *self);
};

struct _GitgCredentialsManagerPrivate {
	GgitConfig* d_config;
	GtkWindow* d_window;
	GeeHashMap* d_usermap;
	gboolean d_save_user_in_config;
	gchar* d_last_user;
	GeeHashMap* d_auth_tried;
};

typedef enum  {
	GITG_AUTHENTICATION_LIFE_TIME_FORGET,
	GITG_AUTHENTICATION_LIFE_TIME_SESSION,
	GITG_AUTHENTICATION_LIFE_TIME_FOREVER
} GitgAuthenticationLifeTime;

struct _Block5Data {
	int _ref_count_;
	GitgCredentialsManager* self;
	GMutex mutex;
	GCond cond;
	GtkResponseType response;
	gchar* password;
	gchar* newusername;
	GitgAuthenticationLifeTime lifetime;
	gchar* url;
	gchar* username;
};

struct _GitgParamSpecCredentialsManager {
	GParamSpec parent_instance;
};


static gpointer gitg_credentials_manager_parent_class = NULL;
static SecretSchema* gitg_credentials_manager_s_secret_schema;
static SecretSchema* gitg_credentials_manager_s_secret_schema = NULL;
static GRegex* gitg_credentials_manager_s_ssh_short_form;
static GRegex* gitg_credentials_manager_s_ssh_short_form = NULL;

GQuark gitg_credentials_error_quark (void);
gpointer gitg_credentials_manager_ref (gpointer instance);
void gitg_credentials_manager_unref (gpointer instance);
GParamSpec* gitg_param_spec_credentials_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_credentials_manager (GValue* value, gpointer v_object);
void gitg_value_take_credentials_manager (GValue* value, gpointer v_object);
gpointer gitg_value_get_credentials_manager (const GValue* value);
GType gitg_credentials_manager_get_type (void) G_GNUC_CONST;
#define GITG_CREDENTIALS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerPrivate))
enum  {
	GITG_CREDENTIALS_MANAGER_DUMMY_PROPERTY
};
GitgCredentialsManager* gitg_credentials_manager_new (GgitConfig* config, GtkWindow* window, gboolean save_user_in_config);
GitgCredentialsManager* gitg_credentials_manager_construct (GType object_type, GgitConfig* config, GtkWindow* window, gboolean save_user_in_config);
static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self, const gchar* host);
static gint _____lambda39_ (GitgCredentialsManager* self, GMatchInfo* info, const gchar* value);
static gint ______lambda39__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self);
static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self, const gchar* url, const gchar* scheme, const gchar* host, const gchar* username, GError** error);
GType gitg_authentication_life_time_get_type (void) G_GNUC_CONST;
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda40_ (Block5Data* _data5_);
GType gitg_authentication_dialog_get_type (void) G_GNUC_CONST;
GitgAuthenticationDialog* gitg_authentication_dialog_new (const gchar* url, const gchar* username, gboolean failed);
GitgAuthenticationDialog* gitg_authentication_dialog_construct (GType object_type, const gchar* url, const gchar* username, gboolean failed);
const gchar* gitg_authentication_dialog_get_username (GitgAuthenticationDialog* self);
const gchar* gitg_authentication_dialog_get_password (GitgAuthenticationDialog* self);
GitgAuthenticationLifeTime gitg_authentication_dialog_get_life_time (GitgAuthenticationDialog* self);
static gboolean ___lambda40__gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void ___lambda41_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res);
static void ____lambda41__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda42_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res);
static void ____lambda42__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self, const gchar* url, const gchar* username, GError** error);
static void _vala_SoupURI_free (SoupURI* self);
GgitCred* gitg_credentials_manager_credentials (GitgCredentialsManager* self, const gchar* url, const gchar* username, GgitCredtype allowed_types, GError** error);
static void gitg_credentials_manager_finalize (GitgCredentialsManager * obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


GQuark gitg_credentials_error_quark (void) {
	return g_quark_from_static_string ("gitg_credentials_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 178 "gitg-credentials-manager.c"
}


GitgCredentialsManager* gitg_credentials_manager_construct (GType object_type, GgitConfig* config, GtkWindow* window, gboolean save_user_in_config) {
	GitgCredentialsManager* self = NULL;
	GgitConfig* _tmp0_;
	GgitConfig* _tmp1_;
	gboolean _tmp2_;
	GeeHashMap* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self = (GitgCredentialsManager*) g_type_create_instance (object_type);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = config;
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_config);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_config = _tmp1_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = save_user_in_config;
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_save_user_in_config = _tmp2_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_credtype_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 58 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_auth_tried);
#line 58 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_auth_tried = _tmp3_;
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = window;
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_window);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_window = _tmp5_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return self;
#line 222 "gitg-credentials-manager.c"
}


GitgCredentialsManager* gitg_credentials_manager_new (GgitConfig* config, GtkWindow* window, gboolean save_user_in_config) {
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return gitg_credentials_manager_construct (GITG_TYPE_CREDENTIALS_MANAGER, config, window, save_user_in_config);
#line 229 "gitg-credentials-manager.c"
}


static gint _____lambda39_ (GitgCredentialsManager* self, GMatchInfo* info, const gchar* value) {
	gint result = 0;
	GeeHashMap* _tmp0_;
	GMatchInfo* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (info != NULL, 0);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (value != NULL, 0);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_usermap;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = info;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = g_match_info_fetch (_tmp1_, 1);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = value;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_tmp3_);
#line 76 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	result = 0;
#line 76 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 262 "gitg-credentials-manager.c"
}


static gint ______lambda39__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self) {
	gint result;
	result = _____lambda39_ ((GitgCredentialsManager*) self, match_info, value);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 271 "gitg-credentials-manager.c"
}


static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self, const gchar* host) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	gpointer _tmp15_;
	GError * _inner_error_ = NULL;
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 64 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_usermap;
#line 64 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp0_ == NULL) {
#line 290 "gitg-credentials-manager.c"
		GeeHashMap* _tmp1_;
		GgitConfig* _tmp2_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (self->priv->d_usermap);
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		self->priv->d_usermap = _tmp1_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = self->priv->d_config;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp2_ != NULL) {
#line 303 "gitg-credentials-manager.c"
			{
				GRegex* r;
				GRegex* _tmp3_;
				GgitConfig* _tmp4_;
				GgitConfig* _tmp5_;
				GgitConfig* _tmp6_;
				GgitConfig* _tmp7_;
				GgitConfig* _tmp8_;
				GRegex* _tmp9_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp3_ = g_regex_new ("credential\\.(.*)\\.username", 0, 0, &_inner_error_);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				r = _tmp3_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 319 "gitg-credentials-manager.c"
					goto __catch25_g_error;
				}
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp5_ = self->priv->d_config;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp6_ = ggit_config_snapshot (_tmp5_, &_inner_error_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp4_ = _tmp6_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_regex_unref0 (r);
#line 332 "gitg-credentials-manager.c"
					goto __catch25_g_error;
				}
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp7_ = _tmp4_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp4_ = NULL;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp8_ = _tmp7_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp9_ = r;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				ggit_config_match_foreach (_tmp8_, _tmp9_, ______lambda39__ggit_config_match_callback, self, &_inner_error_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp8_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_object_unref0 (_tmp4_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_regex_unref0 (r);
#line 353 "gitg-credentials-manager.c"
					goto __catch25_g_error;
				}
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp4_);
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_regex_unref0 (r);
#line 360 "gitg-credentials-manager.c"
			}
			goto __finally25;
			__catch25_g_error:
			{
				GError* e = NULL;
				FILE* _tmp10_;
				GError* _tmp11_;
				const gchar* _tmp12_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				e = _inner_error_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_inner_error_ = NULL;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp10_ = stderr;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp11_ = e;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp12_ = _tmp11_->message;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				fprintf (_tmp10_, "Could not get username from git config: %s\n", _tmp12_);
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_error_free0 (e);
#line 383 "gitg-credentials-manager.c"
			}
			__finally25:
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				g_clear_error (&_inner_error_);
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 394 "gitg-credentials-manager.c"
			}
		}
	}
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp13_ = self->priv->d_usermap;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp14_ = host;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	result = (gchar*) _tmp15_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 408 "gitg-credentials-manager.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return _data5_;
#line 417 "gitg-credentials-manager.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 426 "gitg-credentials-manager.c"
		GitgCredentialsManager* self;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		self = _data5_->self;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->newusername);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->password);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_vala_clear_GCond (&_data5_->cond);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_vala_clear_GMutex (&_data5_->mutex);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->url);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->username);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_gitg_credentials_manager_unref0 (self);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_slice_free (Block5Data, _data5_);
#line 446 "gitg-credentials-manager.c"
	}
}


static gboolean __lambda40_ (Block5Data* _data5_) {
	GitgCredentialsManager* self;
	gboolean result = FALSE;
	GgitCredtype tried;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GitgAuthenticationDialog* d;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GgitCredtype _tmp5_;
	GitgAuthenticationDialog* _tmp6_;
	GitgAuthenticationDialog* _tmp7_;
	GtkWindow* _tmp8_;
	GitgAuthenticationDialog* _tmp9_;
	gint _tmp10_;
	GtkResponseType _tmp11_;
	GitgAuthenticationDialog* _tmp23_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self = _data5_->self;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_auth_tried;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = _data5_->username;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	tried = ((GgitCredtype) ((gintptr) _tmp2_)) & (~GGIT_CREDTYPE_SSH_KEY);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = _data5_->url;
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = _data5_->username;
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = tried;
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = gitg_authentication_dialog_new (_tmp3_, _tmp4_, _tmp5_ != 0);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_object_ref_sink (_tmp6_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	d = _tmp6_;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp7_ = d;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = self->priv->d_window;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = d;
#line 110 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp10_ = gtk_dialog_run ((GtkDialog*) _tmp9_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->response = (GtkResponseType) _tmp10_;
#line 112 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp11_ = _data5_->response;
#line 112 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp11_ == GTK_RESPONSE_OK) {
#line 507 "gitg-credentials-manager.c"
		GitgAuthenticationDialog* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GitgAuthenticationDialog* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		GitgAuthenticationDialog* _tmp20_;
		GitgAuthenticationLifeTime _tmp21_;
		GitgAuthenticationLifeTime _tmp22_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = d;
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = gitg_authentication_dialog_get_username (_tmp12_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = _tmp13_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->newusername);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_->newusername = _tmp15_;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp16_ = d;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp17_ = gitg_authentication_dialog_get_password (_tmp16_);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = _tmp17_;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->password);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_->password = _tmp19_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp20_ = d;
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp21_ = gitg_authentication_dialog_get_life_time (_tmp20_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp22_ = _tmp21_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_->lifetime = _tmp22_;
#line 551 "gitg-credentials-manager.c"
	}
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp23_ = d;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp23_);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_lock (&_data5_->mutex);
#line 122 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_signal (&_data5_->cond);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_unlock (&_data5_->mutex);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	result = FALSE;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (d);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 569 "gitg-credentials-manager.c"
}


static gboolean ___lambda40__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda40_ (self);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 578 "gitg-credentials-manager.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1434 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1435 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	result = self;
#line 1435 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 590 "gitg-credentials-manager.c"
}


static void _g_free0_ (gpointer var) {
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	var = (g_free (var), NULL);
#line 597 "gitg-credentials-manager.c"
}


static void ___lambda41_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 180 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (res != NULL);
#line 605 "gitg-credentials-manager.c"
	{
		GAsyncResult* _tmp0_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = res;
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_store_finish (_tmp0_, &_inner_error_);
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 614 "gitg-credentials-manager.c"
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = stderr;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = e;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp2_->message;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp1_, "Failed to store secret in keyring: %s\n", _tmp3_);
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 639 "gitg-credentials-manager.c"
	}
	__finally27:
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return;
#line 650 "gitg-credentials-manager.c"
	}
}


static void ____lambda41__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	___lambda41_ ((GitgCredentialsManager*) self, source_object, res);
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_unref (self);
#line 660 "gitg-credentials-manager.c"
}


static void ___lambda42_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (res != NULL);
#line 668 "gitg-credentials-manager.c"
	{
		GAsyncResult* _tmp0_;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = res;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_clear_finish (_tmp0_, &_inner_error_);
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 677 "gitg-credentials-manager.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = stderr;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = e;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp2_->message;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp1_, "Failed to clear secret from keyring: %s\n", _tmp3_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 702 "gitg-credentials-manager.c"
	}
	__finally28:
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return;
#line 713 "gitg-credentials-manager.c"
	}
}


static void ____lambda42__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	___lambda42_ ((GitgCredentialsManager*) self, source_object, res);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_unref (self);
#line 723 "gitg-credentials-manager.c"
}


static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self, const gchar* url, const gchar* scheme, const gchar* host, const gchar* username, GError** error) {
	GgitCred* result = NULL;
	Block5Data* _data5_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkResponseType _tmp6_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	GHashTable* attributes;
	GHashFunc _tmp37_;
	GEqualFunc _tmp38_;
	GHashTable* _tmp39_;
	GHashTable* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GHashTable* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	GHashTable* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	GitgAuthenticationLifeTime _tmp52_;
	GeeHashMap* _tmp67_;
	const gchar* _tmp68_;
	GgitCredPlaintext* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	GgitCredPlaintext* _tmp72_;
	GgitCredPlaintext* _tmp73_;
	GError * _inner_error_ = NULL;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (scheme != NULL, NULL);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->_ref_count_ = 1;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->self = gitg_credentials_manager_ref (self);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = url;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_data5_->url);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->url = _tmp1_;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = username;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_data5_->username);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->username = _tmp3_;
#line 91 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_init (&_data5_->mutex);
#line 92 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_lock (&_data5_->mutex);
#line 94 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_init (&_data5_->cond);
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->response = GTK_RESPONSE_CANCEL;
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = g_strdup ("");
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->password = _tmp4_;
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = g_strdup ("");
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->newusername = _tmp5_;
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->lifetime = GITG_AUTHENTICATION_LIFE_TIME_FORGET;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda40__gsource_func, block5_data_ref (_data5_), block5_data_unref);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_wait (&_data5_->cond, &_data5_->mutex);
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_unlock (&_data5_->mutex);
#line 131 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = _data5_->response;
#line 131 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp6_ != GTK_RESPONSE_OK) {
#line 824 "gitg-credentials-manager.c"
		GError* _tmp7_;
#line 133 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = g_error_new_literal (GITG_CREDENTIALS_ERROR, GITG_CREDENTIALS_ERROR_CANCELLED, "cancelled by user");
#line 133 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = _tmp7_;
#line 133 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 133 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		block5_data_unref (_data5_);
#line 133 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_ = NULL;
#line 133 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 838 "gitg-credentials-manager.c"
	}
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = _data5_->newusername;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (self->priv->d_last_user);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_last_user = _tmp9_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp11_ = _data5_->username;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp11_ == NULL) {
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = TRUE;
#line 854 "gitg-credentials-manager.c"
	} else {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = _data5_->newusername;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = _data5_->username;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
#line 866 "gitg-credentials-manager.c"
			GgitConfig* _tmp16_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp16_ = self->priv->d_config;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp13_ = _tmp16_ != NULL;
#line 872 "gitg-credentials-manager.c"
		} else {
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp13_ = FALSE;
#line 876 "gitg-credentials-manager.c"
		}
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp13_) {
#line 880 "gitg-credentials-manager.c"
			gboolean _tmp17_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp17_ = self->priv->d_save_user_in_config;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp12_ = _tmp17_;
#line 886 "gitg-credentials-manager.c"
		} else {
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp12_ = FALSE;
#line 890 "gitg-credentials-manager.c"
		}
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = _tmp12_;
#line 894 "gitg-credentials-manager.c"
	}
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp10_) {
#line 898 "gitg-credentials-manager.c"
		GeeHashMap* _tmp18_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = self->priv->d_usermap;
#line 141 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp18_ == NULL) {
#line 904 "gitg-credentials-manager.c"
			GeeHashMap* _tmp19_;
#line 143 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp19_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 143 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (self->priv->d_usermap);
#line 143 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			self->priv->d_usermap = _tmp19_;
#line 912 "gitg-credentials-manager.c"
		}
		{
			gchar* hid;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			GgitConfig* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			GeeHashMap* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp20_ = scheme;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp21_ = string_to_string (_tmp20_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp22_ = host;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp23_ = string_to_string (_tmp22_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp24_ = g_strconcat (_tmp21_, "://", _tmp23_, NULL);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			hid = _tmp24_;
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp25_ = self->priv->d_config;
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp26_ = hid;
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp27_ = string_to_string (_tmp26_);
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp28_ = g_strconcat ("credential.", _tmp27_, ".username", NULL);
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp29_ = _tmp28_;
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp30_ = _data5_->newusername;
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			ggit_config_set_string (_tmp25_, _tmp29_, _tmp30_, &_inner_error_);
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (_tmp29_);
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 150 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (hid);
#line 962 "gitg-credentials-manager.c"
				goto __catch26_g_error;
			}
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp31_ = self->priv->d_usermap;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp32_ = hid;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp33_ = _data5_->newusername;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp32_, _tmp33_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (hid);
#line 975 "gitg-credentials-manager.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
			GError* e = NULL;
			FILE* _tmp34_;
			GError* _tmp35_;
			const gchar* _tmp36_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			e = _inner_error_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_inner_error_ = NULL;
#line 155 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp34_ = stderr;
#line 155 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp35_ = e;
#line 155 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp36_ = _tmp35_->message;
#line 155 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			fprintf (_tmp34_, "Failed to store username in config: %s\n", _tmp36_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_error_free0 (e);
#line 998 "gitg-credentials-manager.c"
		}
		__finally26:
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			block5_data_unref (_data5_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_data5_ = NULL;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1011 "gitg-credentials-manager.c"
		}
	}
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp37_ = g_str_hash;
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp38_ = g_str_equal;
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp39_ = g_hash_table_new_full (_tmp37_, _tmp38_, _g_free0_, _g_free0_);
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	attributes = _tmp39_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp40_ = attributes;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp41_ = g_strdup ("scheme");
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp42_ = scheme;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp43_ = g_strdup (_tmp42_);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp40_, _tmp41_, _tmp43_);
#line 161 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp44_ = attributes;
#line 161 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp45_ = g_strdup ("host");
#line 161 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp46_ = host;
#line 161 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp47_ = g_strdup (_tmp46_);
#line 161 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp44_, _tmp45_, _tmp47_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp48_ = attributes;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp49_ = g_strdup ("user");
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp50_ = _data5_->newusername;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp51_);
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp52_ = _data5_->lifetime;
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp52_ != GITG_AUTHENTICATION_LIFE_TIME_FORGET) {
#line 1056 "gitg-credentials-manager.c"
		gchar* collection;
		GitgAuthenticationLifeTime _tmp53_;
		SecretSchema* _tmp55_;
		GHashTable* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		const gchar* _tmp64_;
#line 167 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		collection = NULL;
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp53_ = _data5_->lifetime;
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp53_ == GITG_AUTHENTICATION_LIFE_TIME_SESSION) {
#line 1075 "gitg-credentials-manager.c"
			gchar* _tmp54_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp54_ = g_strdup (SECRET_COLLECTION_SESSION);
#line 171 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (collection);
#line 171 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			collection = _tmp54_;
#line 1083 "gitg-credentials-manager.c"
		}
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp55_ = gitg_credentials_manager_s_secret_schema;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp56_ = attributes;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp57_ = collection;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp58_ = scheme;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp59_ = string_to_string (_tmp58_);
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp60_ = host;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp61_ = string_to_string (_tmp60_);
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp62_ = g_strconcat (_tmp59_, "://", _tmp61_, NULL);
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp63_ = _tmp62_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp64_ = _data5_->password;
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_storev (_tmp55_, _tmp56_, _tmp57_, _tmp63_, _tmp64_, NULL, ____lambda41__gasync_ready_callback, gitg_credentials_manager_ref (self));
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp63_);
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (collection);
#line 1111 "gitg-credentials-manager.c"
	} else {
		SecretSchema* _tmp65_;
		GHashTable* _tmp66_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp65_ = gitg_credentials_manager_s_secret_schema;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp66_ = attributes;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_clearv (_tmp65_, _tmp66_, NULL, ____lambda42__gasync_ready_callback, gitg_credentials_manager_ref (self));
#line 1121 "gitg-credentials-manager.c"
	}
#line 205 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp67_ = self->priv->d_auth_tried;
#line 205 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp68_ = _data5_->newusername;
#line 205 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp67_, _tmp68_, (gpointer) ((gintptr) GGIT_CREDTYPE_USERPASS_PLAINTEXT));
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp70_ = _data5_->newusername;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp71_ = _data5_->password;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp72_ = ggit_cred_plaintext_new (_tmp70_, _tmp71_, &_inner_error_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp69_ = _tmp72_;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_hash_table_unref0 (attributes);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		block5_data_unref (_data5_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_ = NULL;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 1149 "gitg-credentials-manager.c"
	}
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp73_ = _tmp69_;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp69_ = NULL;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	result = (GgitCred*) _tmp73_;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (_tmp69_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_hash_table_unref0 (attributes);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	block5_data_unref (_data5_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_ = NULL;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 1167 "gitg-credentials-manager.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 1395 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1395 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1396 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1396 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1396 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1396 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1187 "gitg-credentials-manager.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 1194 "gitg-credentials-manager.c"
}


static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self, const gchar* url, const gchar* username, GError** error) {
	GgitCred* result = NULL;
	gchar* user = NULL;
	gchar* host;
	gchar* _tmp0_;
	gchar* scheme;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp29_;
	const gchar* _tmp39_;
	GError * _inner_error_ = NULL;
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 213 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = g_strdup ("local");
#line 213 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	host = _tmp0_;
#line 214 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = g_strdup ("file");
#line 214 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	scheme = _tmp1_;
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = url;
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = string_contains (_tmp2_, "://");
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (!_tmp3_) {
#line 1228 "gitg-credentials-manager.c"
		GMatchInfo* minfo = NULL;
		GRegex* _tmp4_;
		const gchar* _tmp5_;
		GMatchInfo* _tmp6_ = NULL;
		gboolean _tmp7_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp4_ = gitg_credentials_manager_s_ssh_short_form;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp5_ = url;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_match_info_unref0 (minfo);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		minfo = _tmp6_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp7_) {
#line 1246 "gitg-credentials-manager.c"
			gchar* _tmp8_;
			GMatchInfo* _tmp9_;
			gchar* _tmp10_;
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp8_ = g_strdup ("ssh");
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			scheme = _tmp8_;
#line 223 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp9_ = minfo;
#line 223 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp10_ = g_match_info_fetch_named (_tmp9_, "host");
#line 223 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 223 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			host = _tmp10_;
#line 1264 "gitg-credentials-manager.c"
		}
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_match_info_unref0 (minfo);
#line 1268 "gitg-credentials-manager.c"
	} else {
		SoupURI* uri;
		const gchar* _tmp11_;
		SoupURI* _tmp12_;
		SoupURI* _tmp13_;
#line 228 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = url;
#line 228 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = soup_uri_new (_tmp11_);
#line 228 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		uri = _tmp12_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = uri;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp13_ != NULL) {
#line 1284 "gitg-credentials-manager.c"
			SoupURI* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			SoupURI* _tmp17_;
			gboolean _tmp18_;
			SoupURI* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp14_ = uri;
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp15_ = soup_uri_get_host (_tmp14_);
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			host = _tmp16_;
#line 234 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp17_ = uri;
#line 234 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp18_ = soup_uri_uses_default_port (_tmp17_);
#line 234 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (!_tmp18_) {
#line 1309 "gitg-credentials-manager.c"
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				SoupURI* _tmp21_;
				guint _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp19_ = host;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp20_ = string_to_string (_tmp19_);
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp21_ = uri;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp22_ = soup_uri_get_port (_tmp21_);
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp23_ = g_strdup_printf ("%u", _tmp22_);
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp24_ = _tmp23_;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp25_ = g_strconcat (_tmp20_, ":", _tmp24_, NULL);
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				host = _tmp25_;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (_tmp24_);
#line 1337 "gitg-credentials-manager.c"
			}
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp26_ = uri;
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp27_ = soup_uri_get_scheme (_tmp26_);
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			scheme = _tmp28_;
#line 1349 "gitg-credentials-manager.c"
		}
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		__vala_SoupURI_free0 (uri);
#line 1353 "gitg-credentials-manager.c"
	}
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp29_ = username;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp29_ == NULL) {
#line 1359 "gitg-credentials-manager.c"
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp30_ = scheme;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp31_ = string_to_string (_tmp30_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp32_ = host;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp33_ = string_to_string (_tmp32_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp34_ = g_strconcat (_tmp31_, "://", _tmp33_, NULL);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp35_ = _tmp34_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp36_ = gitg_credentials_manager_lookup_user (self, _tmp35_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		user = _tmp36_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp35_);
#line 1387 "gitg-credentials-manager.c"
	} else {
		const gchar* _tmp37_;
		gchar* _tmp38_;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp37_ = username;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp38_ = g_strdup (_tmp37_);
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		user = _tmp38_;
#line 1399 "gitg-credentials-manager.c"
	}
#line 253 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp39_ = user;
#line 253 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp39_ != NULL) {
#line 1405 "gitg-credentials-manager.c"
		GgitCredtype tried;
		GeeHashMap* _tmp40_;
		const gchar* _tmp41_;
		gpointer _tmp42_;
		GgitCredtype _tmp43_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp40_ = self->priv->d_auth_tried;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp41_ = user;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp42_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, _tmp41_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		tried = (GgitCredtype) ((gintptr) _tmp42_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp43_ = tried;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if ((_tmp43_ & GGIT_CREDTYPE_USERPASS_PLAINTEXT) == 0) {
#line 1423 "gitg-credentials-manager.c"
			gchar* secret;
			const gchar* _tmp51_;
			GeeHashMap* _tmp59_;
			const gchar* _tmp60_;
#line 259 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			secret = NULL;
#line 1430 "gitg-credentials-manager.c"
			{
				gchar* _tmp44_;
				SecretSchema* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp45_ = gitg_credentials_manager_s_secret_schema;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp46_ = scheme;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp47_ = host;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp48_ = user;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp49_ = secret_password_lookup_sync (_tmp45_, NULL, &_inner_error_, "scheme", _tmp46_, "host", _tmp47_, "user", _tmp48_, NULL);
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp44_ = _tmp49_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1453 "gitg-credentials-manager.c"
					goto __catch29_g_error;
				}
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp50_ = _tmp44_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp44_ = NULL;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				secret = _tmp50_;
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (_tmp44_);
#line 1466 "gitg-credentials-manager.c"
			}
			goto __finally29;
			__catch29_g_error:
			{
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				g_clear_error (&_inner_error_);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_inner_error_ = NULL;
#line 1475 "gitg-credentials-manager.c"
			}
			__finally29:
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1492 "gitg-credentials-manager.c"
			}
#line 270 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp51_ = secret;
#line 270 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (_tmp51_ == NULL) {
#line 1498 "gitg-credentials-manager.c"
				GgitCred* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				GgitCred* _tmp57_;
				GgitCred* _tmp58_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp53_ = url;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp54_ = scheme;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp55_ = host;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp56_ = user;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp57_ = gitg_credentials_manager_user_pass_dialog (self, _tmp53_, _tmp54_, _tmp55_, _tmp56_, &_inner_error_);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp52_ = _tmp57_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					g_propagate_error (error, _inner_error_);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (secret);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (scheme);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (host);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (user);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					return NULL;
#line 1532 "gitg-credentials-manager.c"
				}
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp58_ = _tmp52_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp52_ = NULL;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				result = _tmp58_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp52_);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return result;
#line 1552 "gitg-credentials-manager.c"
			}
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp59_ = self->priv->d_auth_tried;
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp60_ = user;
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp59_, _tmp60_, (gpointer) ((gintptr) GGIT_CREDTYPE_USERPASS_PLAINTEXT));
#line 1560 "gitg-credentials-manager.c"
			{
				GgitCredPlaintext* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				GgitCredPlaintext* _tmp64_;
				GgitCredPlaintext* _tmp65_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp62_ = user;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp63_ = secret;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp64_ = ggit_cred_plaintext_new (_tmp62_, _tmp63_, &_inner_error_);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp61_ = _tmp64_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1577 "gitg-credentials-manager.c"
					goto __catch30_g_error;
				}
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp65_ = _tmp61_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp61_ = NULL;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				result = (GgitCred*) _tmp65_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp61_);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return result;
#line 1598 "gitg-credentials-manager.c"
			}
			goto __finally30;
			__catch30_g_error:
			{
				GError* e = NULL;
				GgitCred* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				GgitCred* _tmp71_;
				GgitCred* _tmp72_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				e = _inner_error_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_inner_error_ = NULL;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp67_ = url;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp68_ = scheme;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp69_ = host;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp70_ = user;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp71_ = gitg_credentials_manager_user_pass_dialog (self, _tmp67_, _tmp68_, _tmp69_, _tmp70_, &_inner_error_);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp66_ = _tmp71_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
					_g_error_free0 (e);
#line 1631 "gitg-credentials-manager.c"
					goto __finally30;
				}
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp72_ = _tmp66_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp66_ = NULL;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				result = _tmp72_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp66_);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_error_free0 (e);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return result;
#line 1654 "gitg-credentials-manager.c"
			}
			__finally30:
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1669 "gitg-credentials-manager.c"
		} else {
			GgitCred* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			GgitCred* _tmp78_;
			GgitCred* _tmp79_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp74_ = url;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp75_ = scheme;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp76_ = host;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp77_ = user;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp78_ = gitg_credentials_manager_user_pass_dialog (self, _tmp74_, _tmp75_, _tmp76_, _tmp77_, &_inner_error_);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp73_ = _tmp78_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1702 "gitg-credentials-manager.c"
			}
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp79_ = _tmp73_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp73_ = NULL;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp79_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp73_);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 288 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1720 "gitg-credentials-manager.c"
		}
	} else {
		GgitCred* _tmp80_;
		const gchar* _tmp81_;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		GgitCred* _tmp85_;
		GgitCred* _tmp86_;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp81_ = url;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp82_ = scheme;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp83_ = host;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp84_ = user;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp85_ = gitg_credentials_manager_user_pass_dialog (self, _tmp81_, _tmp82_, _tmp83_, _tmp84_, &_inner_error_);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp80_ = _tmp85_;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1754 "gitg-credentials-manager.c"
		}
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp86_ = _tmp80_;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp80_ = NULL;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		result = _tmp86_;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (_tmp80_);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (scheme);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (host);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return result;
#line 1772 "gitg-credentials-manager.c"
	}
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (scheme);
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (host);
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (user);
#line 1780 "gitg-credentials-manager.c"
}


GgitCred* gitg_credentials_manager_credentials (GitgCredentialsManager* self, const gchar* url, const gchar* username, GgitCredtype allowed_types, GError** error) {
	GgitCred* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* uslookup;
	gchar* _tmp3_;
	GgitCredtype tried;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	GgitCredtype untried_allowed_types;
	GgitCredtype _tmp7_;
	GgitCredtype _tmp8_;
	GgitCredtype _tmp9_;
	GError * _inner_error_ = NULL;
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = username;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp1_ != NULL) {
#line 1807 "gitg-credentials-manager.c"
		const gchar* _tmp2_;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = username;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = _tmp2_;
#line 1813 "gitg-credentials-manager.c"
	} else {
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = "";
#line 1817 "gitg-credentials-manager.c"
	}
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = g_strdup (_tmp0_);
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	uslookup = _tmp3_;
#line 302 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = self->priv->d_auth_tried;
#line 302 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = uslookup;
#line 302 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 302 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	tried = (GgitCredtype) ((gintptr) _tmp6_);
#line 304 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp7_ = allowed_types;
#line 304 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = tried;
#line 304 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	untried_allowed_types = _tmp7_ & (~_tmp8_);
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = untried_allowed_types;
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if ((_tmp9_ & GGIT_CREDTYPE_SSH_KEY) != 0) {
#line 1841 "gitg-credentials-manager.c"
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		GgitCredtype _tmp12_;
		GgitCredSshKeyFromAgent* _tmp13_;
		const gchar* _tmp14_;
		GgitCredSshKeyFromAgent* _tmp15_;
		GgitCredSshKeyFromAgent* _tmp16_;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = self->priv->d_auth_tried;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = uslookup;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = tried;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp11_, (gpointer) ((gintptr) (_tmp12_ | GGIT_CREDTYPE_SSH_KEY)));
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = username;
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = ggit_cred_ssh_key_from_agent_new (_tmp14_, &_inner_error_);
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = _tmp15_;
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (uslookup);
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1871 "gitg-credentials-manager.c"
		}
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp16_ = _tmp13_;
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = NULL;
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		result = (GgitCred*) _tmp16_;
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (_tmp13_);
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (uslookup);
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return result;
#line 1885 "gitg-credentials-manager.c"
	} else {
		GgitCredtype _tmp17_;
#line 311 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp17_ = allowed_types;
#line 311 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if ((_tmp17_ & GGIT_CREDTYPE_USERPASS_PLAINTEXT) != 0) {
#line 1892 "gitg-credentials-manager.c"
			GgitCred* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GgitCred* _tmp21_;
			GgitCred* _tmp22_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp19_ = url;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp20_ = username;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp21_ = gitg_credentials_manager_query_user_pass (self, _tmp19_, _tmp20_, &_inner_error_);
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp18_ = _tmp21_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (uslookup);
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1914 "gitg-credentials-manager.c"
			}
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp22_ = _tmp18_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp18_ = NULL;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp22_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp18_);
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (uslookup);
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1928 "gitg-credentials-manager.c"
		}
	}
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	result = NULL;
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (uslookup);
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 1937 "gitg-credentials-manager.c"
}


static void gitg_value_credentials_manager_init (GValue* value) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	value->data[0].v_pointer = NULL;
#line 1944 "gitg-credentials-manager.c"
}


static void gitg_value_credentials_manager_free_value (GValue* value) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (value->data[0].v_pointer) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (value->data[0].v_pointer);
#line 1953 "gitg-credentials-manager.c"
	}
}


static void gitg_value_credentials_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		dest_value->data[0].v_pointer = gitg_credentials_manager_ref (src_value->data[0].v_pointer);
#line 1963 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1967 "gitg-credentials-manager.c"
	}
}


static gpointer gitg_value_credentials_manager_peek_pointer (const GValue* value) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return value->data[0].v_pointer;
#line 1975 "gitg-credentials-manager.c"
}


static gchar* gitg_value_credentials_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (collect_values[0].v_pointer) {
#line 1982 "gitg-credentials-manager.c"
		GitgCredentialsManager * object;
		object = collect_values[0].v_pointer;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1989 "gitg-credentials-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1993 "gitg-credentials-manager.c"
		}
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = gitg_credentials_manager_ref (object);
#line 1997 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2001 "gitg-credentials-manager.c"
	}
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return NULL;
#line 2005 "gitg-credentials-manager.c"
}


static gchar* gitg_value_credentials_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgCredentialsManager ** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (!object_p) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2016 "gitg-credentials-manager.c"
	}
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (!value->data[0].v_pointer) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = NULL;
#line 2022 "gitg-credentials-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 2026 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = gitg_credentials_manager_ref (value->data[0].v_pointer);
#line 2030 "gitg-credentials-manager.c"
	}
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return NULL;
#line 2034 "gitg-credentials-manager.c"
}


GParamSpec* gitg_param_spec_credentials_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgParamSpecCredentialsManager* spec;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return G_PARAM_SPEC (spec);
#line 2048 "gitg-credentials-manager.c"
}


gpointer gitg_value_get_credentials_manager (const GValue* value) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return value->data[0].v_pointer;
#line 2057 "gitg-credentials-manager.c"
}


void gitg_value_set_credentials_manager (GValue* value, gpointer v_object) {
	GitgCredentialsManager * old;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (v_object) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = v_object;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_ref (value->data[0].v_pointer);
#line 2077 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2081 "gitg-credentials-manager.c"
	}
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (old) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (old);
#line 2087 "gitg-credentials-manager.c"
	}
}


void gitg_value_take_credentials_manager (GValue* value, gpointer v_object) {
	GitgCredentialsManager * old;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (v_object) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = v_object;
#line 2106 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2110 "gitg-credentials-manager.c"
	}
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (old) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (old);
#line 2116 "gitg-credentials-manager.c"
	}
}


static void gitg_credentials_manager_class_init (GitgCredentialsManagerClass * klass) {
	SecretSchema* _tmp0_;
	GError * _inner_error_ = NULL;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	((GitgCredentialsManagerClass *) klass)->finalize = gitg_credentials_manager_finalize;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_type_class_add_private (klass, sizeof (GitgCredentialsManagerPrivate));
#line 42 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = secret_schema_new ("org.gnome.Gitg.Credentials", SECRET_SCHEMA_NONE, "scheme", SECRET_SCHEMA_ATTRIBUTE_STRING, "host", SECRET_SCHEMA_ATTRIBUTE_STRING, "user", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
#line 42 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_secret_schema_unref0 (gitg_credentials_manager_s_secret_schema);
#line 42 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_s_secret_schema = _tmp0_;
#line 2136 "gitg-credentials-manager.c"
	{
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = g_regex_new ("^(?:[^: /@]+)@(?P<host>[^:]+)", 0, 0, &_inner_error_);
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = _tmp2_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2147 "gitg-credentials-manager.c"
			goto __catch31_g_error;
		}
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp1_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = NULL;
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_regex_unref0 (gitg_credentials_manager_s_ssh_short_form);
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_s_ssh_short_form = _tmp3_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_regex_unref0 (_tmp1_);
#line 2160 "gitg-credentials-manager.c"
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp4_ = stderr;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp5_ = e;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp6_ = _tmp5_->message;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp4_, "regex err: %s\n", _tmp6_);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 2183 "gitg-credentials-manager.c"
	}
	__finally31:
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 2192 "gitg-credentials-manager.c"
	}
}


static void gitg_credentials_manager_instance_init (GitgCredentialsManager * self) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv = GITG_CREDENTIALS_MANAGER_GET_PRIVATE (self);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self->ref_count = 1;
#line 2202 "gitg-credentials-manager.c"
}


static void gitg_credentials_manager_finalize (GitgCredentialsManager * obj) {
	GitgCredentialsManager * self;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_signal_handlers_destroy (self);
#line 30 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_config);
#line 31 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_window);
#line 32 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_usermap);
#line 34 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (self->priv->d_last_user);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_auth_tried);
#line 2222 "gitg-credentials-manager.c"
}


GType gitg_credentials_manager_get_type (void) {
	static volatile gsize gitg_credentials_manager_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_credentials_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_value_credentials_manager_init, gitg_value_credentials_manager_free_value, gitg_value_credentials_manager_copy_value, gitg_value_credentials_manager_peek_pointer, "p", gitg_value_credentials_manager_collect_value, "p", gitg_value_credentials_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgCredentialsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_credentials_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCredentialsManager), 0, (GInstanceInitFunc) gitg_credentials_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_credentials_manager_type_id;
		gitg_credentials_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgCredentialsManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_credentials_manager_type_id__volatile, gitg_credentials_manager_type_id);
	}
	return gitg_credentials_manager_type_id__volatile;
}


gpointer gitg_credentials_manager_ref (gpointer instance) {
	GitgCredentialsManager * self;
	self = instance;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	return instance;
#line 2247 "gitg-credentials-manager.c"
}


void gitg_credentials_manager_unref (gpointer instance) {
	GitgCredentialsManager * self;
	self = instance;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		GITG_CREDENTIALS_MANAGER_GET_CLASS (self)->finalize (self);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-credentials-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2260 "gitg-credentials-manager.c"
	}
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



