/* gitg-cell-renderer-lanes.c generated by valac 0.34.0.108-f56ac, the Vala compiler
 * generated from gitg-cell-renderer-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <pango/pango.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_CELL_RENDERER_LANES (gitg_cell_renderer_lanes_get_type ())
#define GITG_CELL_RENDERER_LANES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes))
#define GITG_CELL_RENDERER_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanesClass))
#define GITG_IS_CELL_RENDERER_LANES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CELL_RENDERER_LANES))
#define GITG_IS_CELL_RENDERER_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_CELL_RENDERER_LANES))
#define GITG_CELL_RENDERER_LANES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanesClass))

typedef struct _GitgCellRendererLanes GitgCellRendererLanes;
typedef struct _GitgCellRendererLanesClass GitgCellRendererLanesClass;
typedef struct _GitgCellRendererLanesPrivate GitgCellRendererLanesPrivate;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgCellRendererLanes {
	GtkCellRendererText parent_instance;
	GitgCellRendererLanesPrivate * priv;
};

struct _GitgCellRendererLanesClass {
	GtkCellRendererTextClass parent_class;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgCellRendererLanesPrivate {
	GitgCommit* _commit;
	GitgCommit* _next_commit;
	guint _lane_width;
	guint _dot_width;
	GSList* _labels;
	gint d_last_height;
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4,
	GITG_LANE_TAG_HIDDEN = 1 << 5
} GitgLaneTag;

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};

typedef gdouble (*GitgCellRendererLanesDirectionFunc) (gdouble i, void* user_data);

static gpointer gitg_cell_renderer_lanes_parent_class = NULL;

GType gitg_cell_renderer_lanes_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_repository_get_type (void) G_GNUC_CONST;
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
#define GITG_CELL_RENDERER_LANES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanesPrivate))
enum  {
	GITG_CELL_RENDERER_LANES_DUMMY_PROPERTY,
	GITG_CELL_RENDERER_LANES_COMMIT,
	GITG_CELL_RENDERER_LANES_NEXT_COMMIT,
	GITG_CELL_RENDERER_LANES_LANE_WIDTH,
	GITG_CELL_RENDERER_LANES_DOT_WIDTH,
	GITG_CELL_RENDERER_LANES_LABELS
};
static guint gitg_cell_renderer_lanes_total_width (GitgCellRendererLanes* self, GtkWidget* widget);
static guint gitg_cell_renderer_lanes_get_num_visible_lanes (GitgCellRendererLanes* self);
guint gitg_cell_renderer_lanes_get_lane_width (GitgCellRendererLanes* self);
gint gitg_label_renderer_width (GtkWidget* widget, PangoFontDescription* font, GSList* labels);
GSList* gitg_cell_renderer_lanes_get_labels (GitgCellRendererLanes* self);
static void gitg_cell_renderer_lanes_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_width, gint* natural_width);
static void gitg_cell_renderer_lanes_draw_arrow (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, guint laneidx, gboolean top);
static void gitg_cell_renderer_lanes_draw_arrows (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area);
GitgCommit* gitg_cell_renderer_lanes_get_commit (GitgCellRendererLanes* self);
GType gitg_lane_get_type (void) G_GNUC_CONST;
GSList* gitg_commit_get_lanes (GitgCommit* self);
GType gitg_color_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
gdouble gitg_color_get_r (GitgColor* self);
gdouble gitg_color_get_g (GitgColor* self);
gdouble gitg_color_get_b (GitgColor* self);
static void gitg_cell_renderer_lanes_draw_paths_real (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCommit* commit, GitgCellRendererLanesDirectionFunc f, void* f_target, gdouble yoffset);
static void gitg_cell_renderer_lanes_draw_top_paths (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target);
static void gitg_cell_renderer_lanes_draw_bottom_paths (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target);
GitgCommit* gitg_cell_renderer_lanes_get_next_commit (GitgCellRendererLanes* self);
static void gitg_cell_renderer_lanes_draw_paths (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target);
static void gitg_cell_renderer_lanes_draw_indicator (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target);
guint gitg_commit_get_mylane (GitgCommit* self);
guint gitg_cell_renderer_lanes_get_dot_width (GitgCellRendererLanes* self);
GitgLane* gitg_commit_get_lane (GitgCommit* self);
static void gitg_cell_renderer_lanes_draw_labels (GitgCellRendererLanes* self, cairo_t* context, GtkWidget* widget, GdkRectangle* area);
void gitg_label_renderer_draw (GtkWidget* widget, PangoFontDescription* font, cairo_t* context, GSList* labels, GdkRectangle* area);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void gitg_cell_renderer_lanes_draw_lane (GitgCellRendererLanes* self, cairo_t* context, GtkWidget* widget, GdkRectangle* area);
static gdouble ___lambda32_ (GitgCellRendererLanes* self, gdouble a);
static gdouble ____lambda32__gitg_cell_renderer_lanes_direction_func (gdouble i, gpointer self);
static gdouble ___lambda33_ (GitgCellRendererLanes* self, gdouble a);
static gdouble ____lambda33__gitg_cell_renderer_lanes_direction_func (gdouble i, gpointer self);
static void gitg_cell_renderer_lanes_real_render (GtkCellRenderer* base, cairo_t* context, GtkWidget* widget, GdkRectangle* area, GdkRectangle* cell_area, GtkCellRendererState flags);
GitgRef* gitg_cell_renderer_lanes_get_ref_at_pos (GitgCellRendererLanes* self, GtkWidget* widget, gint x, gint cell_w, gint* hot_x);
GitgRef* gitg_label_renderer_get_ref_at_pos (GtkWidget* widget, PangoFontDescription* font, GSList* labels, gint x, gint* hot_x);
GitgCellRendererLanes* gitg_cell_renderer_lanes_new (void);
GitgCellRendererLanes* gitg_cell_renderer_lanes_construct (GType object_type);
void gitg_cell_renderer_lanes_set_commit (GitgCellRendererLanes* self, GitgCommit* value);
void gitg_cell_renderer_lanes_set_next_commit (GitgCellRendererLanes* self, GitgCommit* value);
void gitg_cell_renderer_lanes_set_lane_width (GitgCellRendererLanes* self, guint value);
void gitg_cell_renderer_lanes_set_dot_width (GitgCellRendererLanes* self, guint value);
void gitg_cell_renderer_lanes_set_labels (GitgCellRendererLanes* self, GSList* value);
static void gitg_cell_renderer_lanes_finalize (GObject * obj);
static void _vala_gitg_cell_renderer_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_cell_renderer_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static guint gitg_cell_renderer_lanes_total_width (GitgCellRendererLanes* self, GtkWidget* widget) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GtkWidget* _tmp3_ = NULL;
	PangoFontDescription* _tmp4_ = NULL;
	PangoFontDescription* _tmp5_ = NULL;
	GSList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (widget != NULL, 0U);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = gitg_cell_renderer_lanes_get_num_visible_lanes (self);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = _tmp0_;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = self->priv->_lane_width;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = widget;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_get ((GtkCellRendererText*) self, "font-desc", &_tmp4_, NULL);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = _tmp4_;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = self->priv->_labels;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp7_ = gitg_label_renderer_width (_tmp3_, _tmp5_, _tmp6_);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = (_tmp1_ * _tmp2_) + _tmp7_;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 273 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_width, gint* natural_width) {
	GitgCellRendererLanes * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	GtkWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint w = 0;
	GtkWidget* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self = (GitgCellRendererLanes*) base;
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (widget != NULL);
#line 69 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = widget;
#line 69 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	GTK_CELL_RENDERER_CLASS (gitg_cell_renderer_lanes_parent_class)->get_preferred_width ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), _tmp0_, &_tmp1_, &_tmp2_);
#line 69 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_vala_minimum_width = _tmp1_;
#line 69 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_vala_natural_width = _tmp2_;
#line 71 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = widget;
#line 71 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = gitg_cell_renderer_lanes_total_width (self, _tmp3_);
#line 71 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	w = (gint) _tmp4_;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = w;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = _vala_minimum_width;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp5_ > _tmp6_) {
#line 313 "gitg-cell-renderer-lanes.c"
		gint _tmp7_ = 0;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp7_ = w;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_vala_minimum_width = _tmp7_;
#line 319 "gitg-cell-renderer-lanes.c"
	}
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (minimum_width) {
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		*minimum_width = _vala_minimum_width;
#line 325 "gitg-cell-renderer-lanes.c"
	}
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (natural_width) {
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		*natural_width = _vala_natural_width;
#line 331 "gitg-cell-renderer-lanes.c"
	}
}


static void gitg_cell_renderer_lanes_draw_arrow (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, guint laneidx, gboolean top) {
	gdouble cw = 0.0;
	guint _tmp0_ = 0U;
	gdouble xpos = 0.0;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gdouble df = 0.0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	gdouble ypos = 0.0;
	GdkRectangle _tmp10_ = {0};
	gint _tmp11_ = 0;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	gdouble _tmp14_ = 0.0;
	gdouble q = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gboolean _tmp17_ = FALSE;
	cairo_t* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	cairo_t* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gboolean _tmp28_ = FALSE;
	cairo_t* _tmp31_ = NULL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	cairo_t* _tmp39_ = NULL;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	cairo_t* _tmp43_ = NULL;
#line 79 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 79 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_lane_width;
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cw = (gdouble) _tmp0_;
#line 85 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = *area;
#line 85 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = _tmp1_.x;
#line 85 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = laneidx;
#line 85 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = cw;
#line 85 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = cw;
#line 85 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	xpos = (_tmp2_ + (_tmp3_ * _tmp4_)) + (_tmp5_ / 2.0);
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp7_ = top;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp7_) {
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp6_ = -1;
#line 410 "gitg-cell-renderer-lanes.c"
	} else {
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp6_ = 1;
#line 414 "gitg-cell-renderer-lanes.c"
	}
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8_ = *area;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp9_ = _tmp8_.height;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	df = (_tmp6_ * 0.25) * _tmp9_;
#line 87 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp10_ = *area;
#line 87 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11_ = _tmp10_.y;
#line 87 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp12_ = *area;
#line 87 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp13_ = _tmp12_.height;
#line 87 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp14_ = df;
#line 87 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	ypos = (_tmp11_ + (_tmp13_ / 2.0)) + _tmp14_;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp15_ = cw;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	q = _tmp15_ / 4.0;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp17_ = top;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp17_) {
#line 442 "gitg-cell-renderer-lanes.c"
		gdouble _tmp18_ = 0.0;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp18_ = q;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp16_ = _tmp18_;
#line 448 "gitg-cell-renderer-lanes.c"
	} else {
		gdouble _tmp19_ = 0.0;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp19_ = q;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp16_ = -_tmp19_;
#line 455 "gitg-cell-renderer-lanes.c"
	}
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp20_ = context;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp21_ = xpos;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp22_ = q;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp23_ = ypos;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_move_to (_tmp20_, _tmp21_ - _tmp22_, _tmp23_ + _tmp16_);
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp24_ = context;
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp25_ = xpos;
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp26_ = ypos;
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_line_to (_tmp24_, _tmp25_, _tmp26_);
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp28_ = top;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp28_) {
#line 479 "gitg-cell-renderer-lanes.c"
		gdouble _tmp29_ = 0.0;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp29_ = q;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp27_ = _tmp29_;
#line 485 "gitg-cell-renderer-lanes.c"
	} else {
		gdouble _tmp30_ = 0.0;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp30_ = q;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp27_ = -_tmp30_;
#line 492 "gitg-cell-renderer-lanes.c"
	}
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp31_ = context;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp32_ = xpos;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp33_ = q;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp34_ = ypos;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_line_to (_tmp31_, _tmp32_ + _tmp33_, _tmp34_ + _tmp27_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp35_ = context;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_stroke (_tmp35_);
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp36_ = context;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp37_ = xpos;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp38_ = ypos;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_move_to (_tmp36_, _tmp37_, _tmp38_);
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp39_ = context;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp40_ = xpos;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp41_ = ypos;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp42_ = df;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_line_to (_tmp39_, _tmp40_, _tmp41_ - _tmp42_);
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp43_ = context;
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_stroke (_tmp43_);
#line 530 "gitg-cell-renderer-lanes.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return self ? g_object_ref (self) : NULL;
#line 537 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_draw_arrows (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area) {
	guint to = 0U;
	GitgCommit* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 103 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	to = (guint) 0;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_commit;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
#line 557 "gitg-cell-renderer-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		lane_collection = _tmp1_;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 565 "gitg-cell-renderer-lanes.c"
			GitgLane* _tmp2_ = NULL;
			GitgLane* lane = NULL;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp2_ = _g_object_ref0 ((GitgLane*) lane_it->data);
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			lane = _tmp2_;
#line 572 "gitg-cell-renderer-lanes.c"
			{
				GitgColor* color = NULL;
				GitgLane* _tmp3_ = NULL;
				GitgColor* _tmp4_ = NULL;
				GitgColor* _tmp5_ = NULL;
				cairo_t* _tmp6_ = NULL;
				GitgColor* _tmp7_ = NULL;
				gdouble _tmp8_ = 0.0;
				gdouble _tmp9_ = 0.0;
				GitgColor* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gdouble _tmp12_ = 0.0;
				GitgColor* _tmp13_ = NULL;
				gdouble _tmp14_ = 0.0;
				gdouble _tmp15_ = 0.0;
				GitgLane* _tmp16_ = NULL;
				GitgLaneTag _tmp17_ = 0;
				guint _tmp26_ = 0U;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp3_ = lane;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp4_ = _tmp3_->color;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				color = _tmp5_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp6_ = context;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp7_ = color;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp8_ = gitg_color_get_r (_tmp7_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp9_ = _tmp8_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp10_ = color;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp11_ = gitg_color_get_g (_tmp10_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp12_ = _tmp11_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp13_ = color;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp14_ = gitg_color_get_b (_tmp13_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp15_ = _tmp14_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				cairo_set_source_rgb (_tmp6_, _tmp9_, _tmp12_, _tmp15_);
#line 110 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp16_ = lane;
#line 110 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp17_ = _tmp16_->tag;
#line 110 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				if (_tmp17_ == GITG_LANE_TAG_START) {
#line 627 "gitg-cell-renderer-lanes.c"
					cairo_t* _tmp18_ = NULL;
					GdkRectangle _tmp19_ = {0};
					guint _tmp20_ = 0U;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp18_ = context;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp19_ = *area;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp20_ = to;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					gitg_cell_renderer_lanes_draw_arrow (self, _tmp18_, &_tmp19_, _tmp20_, TRUE);
#line 639 "gitg-cell-renderer-lanes.c"
				} else {
					GitgLane* _tmp21_ = NULL;
					GitgLaneTag _tmp22_ = 0;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp21_ = lane;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp22_ = _tmp21_->tag;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					if (_tmp22_ == GITG_LANE_TAG_END) {
#line 649 "gitg-cell-renderer-lanes.c"
						cairo_t* _tmp23_ = NULL;
						GdkRectangle _tmp24_ = {0};
						guint _tmp25_ = 0U;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
						_tmp23_ = context;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
						_tmp24_ = *area;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
						_tmp25_ = to;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
						gitg_cell_renderer_lanes_draw_arrow (self, _tmp23_, &_tmp24_, _tmp25_, FALSE);
#line 661 "gitg-cell-renderer-lanes.c"
					}
				}
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp26_ = to;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				to = _tmp26_ + 1;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_g_object_unref0 (color);
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_g_object_unref0 (lane);
#line 672 "gitg-cell-renderer-lanes.c"
			}
		}
	}
}


static void gitg_cell_renderer_lanes_draw_paths_real (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCommit* commit, GitgCellRendererLanesDirectionFunc f, void* f_target, gdouble yoffset) {
	GitgCommit* _tmp0_ = NULL;
	gint to = 0;
	gdouble cw = 0.0;
	guint _tmp1_ = 0U;
	gdouble ch = 0.0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgCommit* _tmp4_ = NULL;
	GSList* _tmp5_ = NULL;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 129 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = commit;
#line 129 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp0_ == NULL) {
#line 131 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		return;
#line 701 "gitg-cell-renderer-lanes.c"
	}
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	to = 0;
#line 135 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = self->priv->_lane_width;
#line 135 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cw = (gdouble) _tmp1_;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = *area;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = _tmp2_.height;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	ch = _tmp3_ / 2.0;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = commit;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = gitg_commit_get_lanes (_tmp4_);
#line 719 "gitg-cell-renderer-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		lane_collection = _tmp5_;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 727 "gitg-cell-renderer-lanes.c"
			GitgLane* _tmp6_ = NULL;
			GitgLane* lane = NULL;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp6_ = _g_object_ref0 ((GitgLane*) lane_it->data);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			lane = _tmp6_;
#line 734 "gitg-cell-renderer-lanes.c"
			{
				GitgLane* _tmp7_ = NULL;
				GitgLaneTag _tmp8_ = 0;
				GitgColor* color = NULL;
				GitgLane* _tmp10_ = NULL;
				GitgColor* _tmp11_ = NULL;
				GitgColor* _tmp12_ = NULL;
				cairo_t* _tmp13_ = NULL;
				GitgColor* _tmp14_ = NULL;
				gdouble _tmp15_ = 0.0;
				gdouble _tmp16_ = 0.0;
				GitgColor* _tmp17_ = NULL;
				gdouble _tmp18_ = 0.0;
				gdouble _tmp19_ = 0.0;
				GitgColor* _tmp20_ = NULL;
				gdouble _tmp21_ = 0.0;
				gdouble _tmp22_ = 0.0;
				GitgLane* _tmp23_ = NULL;
				GSList* _tmp24_ = NULL;
				gint _tmp62_ = 0;
#line 140 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp7_ = lane;
#line 140 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp8_ = _tmp7_->tag;
#line 140 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				if ((_tmp8_ & GITG_LANE_TAG_HIDDEN) != 0) {
#line 761 "gitg-cell-renderer-lanes.c"
					gint _tmp9_ = 0;
#line 142 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp9_ = to;
#line 142 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					to = _tmp9_ + 1;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_g_object_unref0 (lane);
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					continue;
#line 771 "gitg-cell-renderer-lanes.c"
				}
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp10_ = lane;
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp11_ = _tmp10_->color;
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp12_ = _g_object_ref0 (_tmp11_);
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				color = _tmp12_;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp13_ = context;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp14_ = color;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp15_ = gitg_color_get_r (_tmp14_);
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp16_ = _tmp15_;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp17_ = color;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp18_ = gitg_color_get_g (_tmp17_);
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp19_ = _tmp18_;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp20_ = color;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp21_ = gitg_color_get_b (_tmp20_);
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp22_ = _tmp21_;
#line 147 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				cairo_set_source_rgb (_tmp13_, _tmp16_, _tmp19_, _tmp22_);
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp23_ = lane;
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp24_ = _tmp23_->from;
#line 807 "gitg-cell-renderer-lanes.c"
				{
					GSList* from_collection = NULL;
					GSList* from_it = NULL;
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					from_collection = _tmp24_;
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					for (from_it = from_collection; from_it != NULL; from_it = from_it->next) {
#line 815 "gitg-cell-renderer-lanes.c"
						gint from = 0;
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
						from = (gint) ((gintptr) from_it->data);
#line 819 "gitg-cell-renderer-lanes.c"
						{
							gdouble x1 = 0.0;
							GdkRectangle _tmp25_ = {0};
							gint _tmp26_ = 0;
							GitgCellRendererLanesDirectionFunc _tmp27_ = NULL;
							void* _tmp27__target = NULL;
							gint _tmp28_ = 0;
							gdouble _tmp29_ = 0.0;
							gdouble _tmp30_ = 0.0;
							gdouble _tmp31_ = 0.0;
							gdouble x2 = 0.0;
							GdkRectangle _tmp32_ = {0};
							gint _tmp33_ = 0;
							GitgCellRendererLanesDirectionFunc _tmp34_ = NULL;
							void* _tmp34__target = NULL;
							gint _tmp35_ = 0;
							gdouble _tmp36_ = 0.0;
							gdouble _tmp37_ = 0.0;
							gdouble _tmp38_ = 0.0;
							gdouble y1 = 0.0;
							GdkRectangle _tmp39_ = {0};
							gint _tmp40_ = 0;
							gdouble _tmp41_ = 0.0;
							gdouble _tmp42_ = 0.0;
							gdouble y2 = 0.0;
							GdkRectangle _tmp43_ = {0};
							gint _tmp44_ = 0;
							gdouble _tmp45_ = 0.0;
							gdouble _tmp46_ = 0.0;
							gdouble y3 = 0.0;
							GdkRectangle _tmp47_ = {0};
							gint _tmp48_ = 0;
							gdouble _tmp49_ = 0.0;
							gdouble _tmp50_ = 0.0;
							cairo_t* _tmp51_ = NULL;
							gdouble _tmp52_ = 0.0;
							gdouble _tmp53_ = 0.0;
							cairo_t* _tmp54_ = NULL;
							gdouble _tmp55_ = 0.0;
							gdouble _tmp56_ = 0.0;
							gdouble _tmp57_ = 0.0;
							gdouble _tmp58_ = 0.0;
							gdouble _tmp59_ = 0.0;
							gdouble _tmp60_ = 0.0;
							cairo_t* _tmp61_ = NULL;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp25_ = *area;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp26_ = _tmp25_.x;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp27_ = f;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp27__target = f_target;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp28_ = from;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp29_ = cw;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp30_ = cw;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp31_ = _tmp27_ ((_tmp28_ * _tmp29_) + (_tmp30_ / 2.0), _tmp27__target);
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							x1 = _tmp26_ + _tmp31_;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp32_ = *area;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp33_ = _tmp32_.x;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp34_ = f;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp34__target = f_target;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp35_ = to;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp36_ = cw;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp37_ = cw;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp38_ = _tmp34_ ((_tmp35_ * _tmp36_) + (_tmp37_ / 2.0), _tmp34__target);
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							x2 = _tmp33_ + _tmp38_;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp39_ = *area;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp40_ = _tmp39_.y;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp41_ = yoffset;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp42_ = ch;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							y1 = _tmp40_ + (_tmp41_ * _tmp42_);
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp43_ = *area;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp44_ = _tmp43_.y;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp45_ = yoffset;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp46_ = ch;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							y2 = _tmp44_ + ((_tmp45_ + 1) * _tmp46_);
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp47_ = *area;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp48_ = _tmp47_.y;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp49_ = yoffset;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp50_ = ch;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							y3 = _tmp48_ + ((_tmp49_ + 2) * _tmp50_);
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp51_ = context;
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp52_ = x1;
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp53_ = y1;
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							cairo_move_to (_tmp51_, _tmp52_, _tmp53_);
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp54_ = context;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp55_ = x1;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp56_ = y2;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp57_ = x2;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp58_ = y2;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp59_ = x2;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp60_ = y3;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							cairo_curve_to (_tmp54_, _tmp55_, _tmp56_, _tmp57_, _tmp58_, _tmp59_, _tmp60_);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							_tmp61_ = context;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
							cairo_stroke (_tmp61_);
#line 959 "gitg-cell-renderer-lanes.c"
						}
					}
				}
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp62_ = to;
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				to = _tmp62_ + 1;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_g_object_unref0 (color);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_g_object_unref0 (lane);
#line 971 "gitg-cell-renderer-lanes.c"
			}
		}
	}
}


static void gitg_cell_renderer_lanes_draw_top_paths (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target) {
	cairo_t* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	GitgCommit* _tmp2_ = NULL;
	GitgCellRendererLanesDirectionFunc _tmp3_ = NULL;
	void* _tmp3__target = NULL;
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = context;
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = *area;
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = self->priv->_commit;
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = f;
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3__target = f_target;
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_paths_real (self, _tmp0_, &_tmp1_, _tmp2_, _tmp3_, _tmp3__target, (gdouble) -1);
#line 1002 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_draw_bottom_paths (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target) {
	cairo_t* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	GitgCommit* _tmp2_ = NULL;
	GitgCellRendererLanesDirectionFunc _tmp3_ = NULL;
	void* _tmp3__target = NULL;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = context;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = *area;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = self->priv->_next_commit;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = f;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3__target = f_target;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_paths_real (self, _tmp0_, &_tmp1_, _tmp2_, _tmp3_, _tmp3__target, (gdouble) 1);
#line 1030 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_draw_paths (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	GdkRectangle _tmp4_ = {0};
	GitgCellRendererLanesDirectionFunc _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	cairo_t* _tmp6_ = NULL;
	GdkRectangle _tmp7_ = {0};
	GitgCellRendererLanesDirectionFunc _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	cairo_t* _tmp9_ = NULL;
	GdkRectangle _tmp10_ = {0};
	cairo_t* _tmp11_ = NULL;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = context;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_set_line_width (_tmp0_, 2.0);
#line 185 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = context;
#line 185 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_set_line_cap (_tmp1_, CAIRO_LINE_CAP_ROUND);
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = context;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_save (_tmp2_);
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = context;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = *area;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = f;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5__target = f_target;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_top_paths (self, _tmp3_, &_tmp4_, _tmp5_, _tmp5__target);
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = context;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp7_ = *area;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8_ = f;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8__target = f_target;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_bottom_paths (self, _tmp6_, &_tmp7_, _tmp8_, _tmp8__target);
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp9_ = context;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp10_ = *area;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_arrows (self, _tmp9_, &_tmp10_);
#line 193 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11_ = context;
#line 193 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_restore (_tmp11_);
#line 1097 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_draw_indicator (GitgCellRendererLanes* self, cairo_t* context, GdkRectangle* area, GitgCellRendererLanesDirectionFunc f, void* f_target) {
	gdouble offset = 0.0;
	gdouble radius = 0.0;
	GitgCommit* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	GitgCellRendererLanesDirectionFunc _tmp11_ = NULL;
	void* _tmp11__target = NULL;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	GdkRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
	gdouble _tmp19_ = 0.0;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	GitgCommit* _tmp22_ = NULL;
	GitgLane* _tmp23_ = NULL;
	GitgLane* _tmp24_ = NULL;
	cairo_t* _tmp40_ = NULL;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_commit;
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = gitg_commit_get_mylane (_tmp0_);
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = _tmp1_;
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = self->priv->_lane_width;
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = self->priv->_lane_width;
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = self->priv->_dot_width;
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	offset = (_tmp2_ * _tmp3_) + ((_tmp4_ - _tmp5_) / 2.0);
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = self->priv->_dot_width;
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	radius = _tmp6_ / 2.0;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp7_ = context;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_set_line_width (_tmp7_, 2.0);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8_ = context;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp9_ = *area;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp10_ = _tmp9_.x;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11_ = f;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11__target = f_target;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp12_ = offset;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp13_ = radius;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp14_ = _tmp11_ (_tmp12_ + _tmp13_, _tmp11__target);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp15_ = *area;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp16_ = _tmp15_.y;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp17_ = *area;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp18_ = _tmp17_.height;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp19_ = radius;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_arc (_tmp8_, _tmp10_ + _tmp14_, _tmp16_ + (_tmp18_ / 2.0), _tmp19_, (gdouble) 0, 2 * G_PI);
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp20_ = context;
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_set_source_rgb (_tmp20_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp21_ = context;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_stroke_preserve (_tmp21_);
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp22_ = self->priv->_commit;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp23_ = gitg_commit_get_lane (_tmp22_);
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp24_ = _tmp23_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp24_ != NULL) {
#line 1203 "gitg-cell-renderer-lanes.c"
		GitgColor* color = NULL;
		GitgCommit* _tmp25_ = NULL;
		GitgLane* _tmp26_ = NULL;
		GitgLane* _tmp27_ = NULL;
		GitgColor* _tmp28_ = NULL;
		GitgColor* _tmp29_ = NULL;
		cairo_t* _tmp30_ = NULL;
		GitgColor* _tmp31_ = NULL;
		gdouble _tmp32_ = 0.0;
		gdouble _tmp33_ = 0.0;
		GitgColor* _tmp34_ = NULL;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		GitgColor* _tmp37_ = NULL;
		gdouble _tmp38_ = 0.0;
		gdouble _tmp39_ = 0.0;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp25_ = self->priv->_commit;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp26_ = gitg_commit_get_lane (_tmp25_);
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp27_ = _tmp26_;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp28_ = _tmp27_->color;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		color = _tmp29_;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp30_ = context;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp31_ = color;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp32_ = gitg_color_get_r (_tmp31_);
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp33_ = _tmp32_;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp34_ = color;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp35_ = gitg_color_get_g (_tmp34_);
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp36_ = _tmp35_;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp37_ = color;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp38_ = gitg_color_get_b (_tmp37_);
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp39_ = _tmp38_;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		cairo_set_source_rgb (_tmp30_, _tmp33_, _tmp36_, _tmp39_);
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_g_object_unref0 (color);
#line 1256 "gitg-cell-renderer-lanes.c"
	}
#line 223 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp40_ = context;
#line 223 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_fill (_tmp40_);
#line 1262 "gitg-cell-renderer-lanes.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 1269 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_draw_labels (GitgCellRendererLanes* self, cairo_t* context, GtkWidget* widget, GdkRectangle* area) {
	gint offset = 0;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gboolean rtl = FALSE;
	GtkWidget* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStateFlags _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkWidget* _tmp11_ = NULL;
	PangoFontDescription* _tmp12_ = NULL;
	PangoFontDescription* _tmp13_ = NULL;
	PangoFontDescription* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	GSList* _tmp16_ = NULL;
	GdkRectangle _tmp17_ = {0};
	cairo_t* _tmp18_ = NULL;
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (widget != NULL);
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = gitg_cell_renderer_lanes_get_num_visible_lanes (self);
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = _tmp0_;
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = self->priv->_lane_width;
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	offset = (gint) (_tmp1_ * _tmp2_);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = widget;
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = gtk_widget_get_style_context (_tmp3_);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = gtk_style_context_get_state (_tmp4_);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	rtl = (_tmp5_ & GTK_STATE_FLAG_DIR_RTL) != 0;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = rtl;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp6_) {
#line 1322 "gitg-cell-renderer-lanes.c"
		gint _tmp7_ = 0;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp7_ = offset;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		offset = -_tmp7_;
#line 1328 "gitg-cell-renderer-lanes.c"
	}
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8_ = context;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_save (_tmp8_);
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp9_ = context;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp10_ = offset;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_translate (_tmp9_, (gdouble) _tmp10_, (gdouble) 0);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11_ = widget;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_get ((GtkCellRendererText*) self, "font-desc", &_tmp12_, NULL);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp13_ = _tmp12_;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp14_ = _tmp13_;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp15_ = context;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp16_ = self->priv->_labels;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp17_ = *area;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_label_renderer_draw (_tmp11_, _tmp14_, _tmp15_, _tmp16_, &_tmp17_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	__vala_PangoFontDescription_free0 (_tmp14_);
#line 244 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp18_ = context;
#line 244 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_restore (_tmp18_);
#line 1362 "gitg-cell-renderer-lanes.c"
}


static gdouble ___lambda32_ (GitgCellRendererLanes* self, gdouble a) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = a;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = -_tmp0_;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1375 "gitg-cell-renderer-lanes.c"
}


static gdouble ____lambda32__gitg_cell_renderer_lanes_direction_func (gdouble i, gpointer self) {
	gdouble result;
	result = ___lambda32_ ((GitgCellRendererLanes*) self, i);
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1384 "gitg-cell-renderer-lanes.c"
}


static gdouble ___lambda33_ (GitgCellRendererLanes* self, gdouble a) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = a;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp0_;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1397 "gitg-cell-renderer-lanes.c"
}


static gdouble ____lambda33__gitg_cell_renderer_lanes_direction_func (gdouble i, gpointer self) {
	gdouble result;
	result = ___lambda33_ ((GitgCellRendererLanes*) self, i);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1406 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_draw_lane (GitgCellRendererLanes* self, cairo_t* context, GtkWidget* widget, GdkRectangle* area) {
	GitgCellRendererLanesDirectionFunc f = NULL;
	void* f_target = NULL;
	GDestroyNotify f_target_destroy_notify = NULL;
	gboolean rtl = FALSE;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStateFlags _tmp2_ = 0;
	cairo_t* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	GdkRectangle _tmp9_ = {0};
	GitgCellRendererLanesDirectionFunc _tmp10_ = NULL;
	void* _tmp10__target = NULL;
	cairo_t* _tmp11_ = NULL;
	GdkRectangle _tmp12_ = {0};
	GitgCellRendererLanesDirectionFunc _tmp13_ = NULL;
	void* _tmp13__target = NULL;
	cairo_t* _tmp14_ = NULL;
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (widget != NULL);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = widget;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = gtk_style_context_get_state (_tmp1_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	rtl = (_tmp2_ & GTK_STATE_FLAG_DIR_RTL) != 0;
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = context;
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_save (_tmp3_);
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = rtl;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp4_) {
#line 1453 "gitg-cell-renderer-lanes.c"
		cairo_t* _tmp5_ = NULL;
		GdkRectangle _tmp6_ = {0};
		gint _tmp7_ = 0;
#line 259 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp5_ = context;
#line 259 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp6_ = *area;
#line 259 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp7_ = _tmp6_.width;
#line 259 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		cairo_translate (_tmp5_, (gdouble) _tmp7_, (gdouble) 0);
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f = NULL;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target = NULL;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target_destroy_notify = NULL;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f = ____lambda32__gitg_cell_renderer_lanes_direction_func;
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target = g_object_ref (self);
#line 260 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target_destroy_notify = g_object_unref;
#line 1479 "gitg-cell-renderer-lanes.c"
	} else {
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target_destroy_notify = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f = ____lambda33__gitg_cell_renderer_lanes_direction_func;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target = g_object_ref (self);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		f_target_destroy_notify = g_object_unref;
#line 1495 "gitg-cell-renderer-lanes.c"
	}
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8_ = context;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp9_ = *area;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp10_ = f;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp10__target = f_target;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_paths (self, _tmp8_, &_tmp9_, _tmp10_, _tmp10__target);
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11_ = context;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp12_ = *area;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp13_ = f;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp13__target = f_target;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_draw_indicator (self, _tmp11_, &_tmp12_, _tmp13_, _tmp13__target);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp14_ = context;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	cairo_restore (_tmp14_);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	f = NULL;
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	f_target = NULL;
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	f_target_destroy_notify = NULL;
#line 1529 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_real_render (GtkCellRenderer* base, cairo_t* context, GtkWidget* widget, GdkRectangle* area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	GitgCellRendererLanes * self;
	GdkRectangle ncell_area = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle narea = {0};
	GdkRectangle _tmp1_ = {0};
	gboolean rtl = FALSE;
	GtkWidget* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStateFlags _tmp4_ = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	GitgCommit* _tmp7_ = NULL;
	gboolean _tmp30_ = FALSE;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	PangoDirection _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
	cairo_t* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	GdkRectangle _tmp38_ = {0};
	GdkRectangle _tmp39_ = {0};
	GtkCellRendererState _tmp40_ = 0;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self = (GitgCellRendererLanes*) base;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (context != NULL);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (widget != NULL);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (area != NULL);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (cell_area != NULL);
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = *cell_area;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	ncell_area = _tmp0_;
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = *area;
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	narea = _tmp1_;
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = widget;
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = gtk_style_context_get_state (_tmp3_);
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	rtl = (_tmp4_ & GTK_STATE_FLAG_DIR_RTL) != 0;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = *area;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = _tmp5_.height;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self->priv->d_last_height = _tmp6_;
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp7_ = self->priv->_commit;
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp7_ != NULL) {
#line 1593 "gitg-cell-renderer-lanes.c"
		cairo_t* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		GdkRectangle _tmp10_ = {0};
		cairo_t* _tmp11_ = NULL;
		cairo_t* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		GdkRectangle _tmp14_ = {0};
		cairo_t* _tmp15_ = NULL;
		GtkWidget* _tmp16_ = NULL;
		GdkRectangle _tmp17_ = {0};
		guint tw = 0U;
		GtkWidget* _tmp18_ = NULL;
		guint _tmp19_ = 0U;
		gboolean _tmp20_ = FALSE;
		cairo_t* _tmp29_ = NULL;
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp8_ = context;
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		cairo_save (_tmp8_);
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp9_ = context;
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp10_ = *area;
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gdk_cairo_rectangle (_tmp9_, &_tmp10_);
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp11_ = context;
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		cairo_clip (_tmp11_);
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp12_ = context;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp13_ = widget;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp14_ = *area;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_draw_lane (self, _tmp12_, _tmp13_, &_tmp14_);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp15_ = context;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp16_ = widget;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp17_ = *area;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_draw_labels (self, _tmp15_, _tmp16_, &_tmp17_);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp18_ = widget;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp19_ = gitg_cell_renderer_lanes_total_width (self, _tmp18_);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		tw = _tmp19_;
#line 298 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp20_ = rtl;
#line 298 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		if (!_tmp20_) {
#line 1649 "gitg-cell-renderer-lanes.c"
			gint _tmp21_ = 0;
			guint _tmp22_ = 0U;
			gint _tmp23_ = 0;
			guint _tmp24_ = 0U;
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp21_ = narea.x;
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp22_ = tw;
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			narea.x = _tmp21_ + ((gint) _tmp22_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp23_ = ncell_area.x;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp24_ = tw;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			ncell_area.x = _tmp23_ + ((gint) _tmp24_);
#line 1666 "gitg-cell-renderer-lanes.c"
		} else {
			gint _tmp25_ = 0;
			guint _tmp26_ = 0U;
			gint _tmp27_ = 0;
			guint _tmp28_ = 0U;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp25_ = narea.width;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp26_ = tw;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			narea.width = _tmp25_ - ((gint) _tmp26_);
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp27_ = ncell_area.width;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp28_ = tw;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			ncell_area.width = _tmp27_ - ((gint) _tmp28_);
#line 1684 "gitg-cell-renderer-lanes.c"
		}
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp29_ = context;
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		cairo_restore (_tmp29_);
#line 1690 "gitg-cell-renderer-lanes.c"
	}
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp30_ = rtl;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_get ((GtkCellRendererText*) self, "text", &_tmp31_, NULL);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp32_ = _tmp31_;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp33_ = _tmp32_;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp34_ = pango_find_base_dir (_tmp33_, -1);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp35_ = _tmp30_ == (_tmp34_ != PANGO_DIRECTION_RTL);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_g_free0 (_tmp33_);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp35_) {
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_object_set ((GtkCellRenderer*) self, "xalign", 1.0f, NULL);
#line 1710 "gitg-cell-renderer-lanes.c"
	}
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp36_ = context;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp37_ = widget;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp38_ = narea;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp39_ = ncell_area;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp40_ = flags;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	GTK_CELL_RENDERER_CLASS (gitg_cell_renderer_lanes_parent_class)->render ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), _tmp36_, _tmp37_, &_tmp38_, &_tmp39_, _tmp40_);
#line 1724 "gitg-cell-renderer-lanes.c"
}


GitgRef* gitg_cell_renderer_lanes_get_ref_at_pos (GitgCellRendererLanes* self, GtkWidget* widget, gint x, gint cell_w, gint* hot_x) {
	gint _vala_hot_x = 0;
	GitgRef* result = NULL;
	gboolean rtl = FALSE;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStateFlags _tmp2_ = 0;
	gint offset = 0;
	GSList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	GtkWidget* _tmp9_ = NULL;
	PangoFontDescription* _tmp10_ = NULL;
	PangoFontDescription* _tmp11_ = NULL;
	PangoFontDescription* _tmp12_ = NULL;
	GSList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GitgRef* _tmp17_ = NULL;
	GitgRef* _tmp18_ = NULL;
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = widget;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp2_ = gtk_style_context_get_state (_tmp1_);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	rtl = (_tmp2_ & GTK_STATE_FLAG_DIR_RTL) != 0;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp3_ = self->priv->_labels;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp4_ = g_slist_length (_tmp3_);
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp5_ = self->priv->_lane_width;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	offset = (gint) (_tmp4_ * _tmp5_);
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp6_ = rtl;
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (_tmp6_) {
#line 1774 "gitg-cell-renderer-lanes.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp7_ = cell_w;
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp8_ = x;
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		x = _tmp7_ - _tmp8_;
#line 1783 "gitg-cell-renderer-lanes.c"
	}
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp9_ = widget;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_get ((GtkCellRendererText*) self, "font-desc", &_tmp10_, NULL);
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp11_ = _tmp10_;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp12_ = _tmp11_;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp13_ = self->priv->_labels;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp14_ = x;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp15_ = offset;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp17_ = gitg_label_renderer_get_ref_at_pos (_tmp9_, _tmp12_, _tmp13_, _tmp14_ - _tmp15_, &_tmp16_);
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_vala_hot_x = _tmp16_;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp18_ = _tmp17_;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	__vala_PangoFontDescription_free0 (_tmp12_);
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp18_;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (hot_x) {
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		*hot_x = _vala_hot_x;
#line 1813 "gitg-cell-renderer-lanes.c"
	}
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1817 "gitg-cell-renderer-lanes.c"
}


GitgCellRendererLanes* gitg_cell_renderer_lanes_construct (GType object_type) {
	GitgCellRendererLanes * self = NULL;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self = (GitgCellRendererLanes*) g_object_new (object_type, NULL);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return self;
#line 1827 "gitg-cell-renderer-lanes.c"
}


GitgCellRendererLanes* gitg_cell_renderer_lanes_new (void) {
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return gitg_cell_renderer_lanes_construct (GITG_TYPE_CELL_RENDERER_LANES);
#line 1834 "gitg-cell-renderer-lanes.c"
}


GitgCommit* gitg_cell_renderer_lanes_get_commit (GitgCellRendererLanes* self) {
	GitgCommit* result;
	GitgCommit* _tmp0_ = NULL;
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_commit;
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp0_;
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1849 "gitg-cell-renderer-lanes.c"
}


void gitg_cell_renderer_lanes_set_commit (GitgCellRendererLanes* self, GitgCommit* value) {
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (gitg_cell_renderer_lanes_get_commit (self) != value) {
#line 1858 "gitg-cell-renderer-lanes.c"
		GitgCommit* _tmp0_ = NULL;
		GitgCommit* _tmp1_ = NULL;
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp0_ = value;
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_g_object_unref0 (self->priv->_commit);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		self->priv->_commit = _tmp1_;
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_object_notify ((GObject *) self, "commit");
#line 1871 "gitg-cell-renderer-lanes.c"
	}
}


GitgCommit* gitg_cell_renderer_lanes_get_next_commit (GitgCellRendererLanes* self) {
	GitgCommit* result;
	GitgCommit* _tmp0_ = NULL;
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_next_commit;
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp0_;
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1887 "gitg-cell-renderer-lanes.c"
}


void gitg_cell_renderer_lanes_set_next_commit (GitgCellRendererLanes* self, GitgCommit* value) {
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (gitg_cell_renderer_lanes_get_next_commit (self) != value) {
#line 1896 "gitg-cell-renderer-lanes.c"
		GitgCommit* _tmp0_ = NULL;
		GitgCommit* _tmp1_ = NULL;
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp0_ = value;
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_g_object_unref0 (self->priv->_next_commit);
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		self->priv->_next_commit = _tmp1_;
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_object_notify ((GObject *) self, "next-commit");
#line 1909 "gitg-cell-renderer-lanes.c"
	}
}


guint gitg_cell_renderer_lanes_get_lane_width (GitgCellRendererLanes* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_lane_width;
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp0_;
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1925 "gitg-cell-renderer-lanes.c"
}


void gitg_cell_renderer_lanes_set_lane_width (GitgCellRendererLanes* self, guint value) {
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (gitg_cell_renderer_lanes_get_lane_width (self) != value) {
#line 1934 "gitg-cell-renderer-lanes.c"
		guint _tmp0_ = 0U;
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp0_ = value;
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		self->priv->_lane_width = _tmp0_;
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_object_notify ((GObject *) self, "lane-width");
#line 1942 "gitg-cell-renderer-lanes.c"
	}
}


guint gitg_cell_renderer_lanes_get_dot_width (GitgCellRendererLanes* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_dot_width;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp0_;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1958 "gitg-cell-renderer-lanes.c"
}


void gitg_cell_renderer_lanes_set_dot_width (GitgCellRendererLanes* self, guint value) {
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (gitg_cell_renderer_lanes_get_dot_width (self) != value) {
#line 1967 "gitg-cell-renderer-lanes.c"
		guint _tmp0_ = 0U;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp0_ = value;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		self->priv->_dot_width = _tmp0_;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_object_notify ((GObject *) self, "dot-width");
#line 1975 "gitg-cell-renderer-lanes.c"
	}
}


GSList* gitg_cell_renderer_lanes_get_labels (GitgCellRendererLanes* self) {
	GSList* result;
	GSList* _tmp0_ = NULL;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_labels;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = _tmp0_;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 1991 "gitg-cell-renderer-lanes.c"
}


void gitg_cell_renderer_lanes_set_labels (GitgCellRendererLanes* self, GSList* value) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	if (gitg_cell_renderer_lanes_get_labels (self) != value) {
#line 2000 "gitg-cell-renderer-lanes.c"
		GSList* _tmp0_ = NULL;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		_tmp0_ = value;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		self->priv->_labels = _tmp0_;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_object_notify ((GObject *) self, "labels");
#line 2008 "gitg-cell-renderer-lanes.c"
	}
}


static guint gitg_cell_renderer_lanes_get_num_visible_lanes (GitgCellRendererLanes* self) {
	guint result;
	gint ret = 0;
	gint trailing_hidden = 0;
	GitgCommit* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 38 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	ret = 0;
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	trailing_hidden = 0;
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp0_ = self->priv->_commit;
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
#line 2031 "gitg-cell-renderer-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		lane_collection = _tmp1_;
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 2039 "gitg-cell-renderer-lanes.c"
			GitgLane* _tmp2_ = NULL;
			GitgLane* lane = NULL;
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			_tmp2_ = _g_object_ref0 ((GitgLane*) lane_it->data);
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
			lane = _tmp2_;
#line 2046 "gitg-cell-renderer-lanes.c"
			{
				gint _tmp3_ = 0;
				GitgLane* _tmp4_ = NULL;
				GitgLaneTag _tmp5_ = 0;
#line 43 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp3_ = ret;
#line 43 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				ret = _tmp3_ + 1;
#line 45 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp4_ = lane;
#line 45 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_tmp5_ = _tmp4_->tag;
#line 45 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				if ((_tmp5_ & GITG_LANE_TAG_HIDDEN) != 0) {
#line 2061 "gitg-cell-renderer-lanes.c"
					gint _tmp6_ = 0;
#line 47 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					_tmp6_ = trailing_hidden;
#line 47 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					trailing_hidden = _tmp6_ + 1;
#line 2067 "gitg-cell-renderer-lanes.c"
				} else {
#line 51 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
					trailing_hidden = 0;
#line 2071 "gitg-cell-renderer-lanes.c"
				}
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
				_g_object_unref0 (lane);
#line 2075 "gitg-cell-renderer-lanes.c"
			}
		}
	}
#line 55 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp7_ = ret;
#line 55 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_tmp8_ = trailing_hidden;
#line 55 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	result = (guint) (_tmp7_ - _tmp8_);
#line 55 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	return result;
#line 2087 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_class_init (GitgCellRendererLanesClass * klass) {
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	gitg_cell_renderer_lanes_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_type_class_add_private (klass, sizeof (GitgCellRendererLanesPrivate));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	((GtkCellRendererClass *) klass)->get_preferred_width = gitg_cell_renderer_lanes_real_get_preferred_width;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	((GtkCellRendererClass *) klass)->render = gitg_cell_renderer_lanes_real_render;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_cell_renderer_lanes_get_property;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_cell_renderer_lanes_set_property;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_cell_renderer_lanes_finalize;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_COMMIT, g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_NEXT_COMMIT, g_param_spec_object ("next-commit", "next-commit", "next-commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_LANE_WIDTH, g_param_spec_uint ("lane-width", "lane-width", "lane-width", 0, G_MAXUINT, (guint) 16, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_DOT_WIDTH, g_param_spec_uint ("dot-width", "dot-width", "dot-width", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_LABELS, g_param_spec_pointer ("labels", "labels", "labels", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2116 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_instance_init (GitgCellRendererLanes * self) {
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self->priv = GITG_CELL_RENDERER_LANES_GET_PRIVATE (self);
#line 26 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self->priv->_lane_width = (guint) 16;
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self->priv->_dot_width = (guint) 10;
#line 2127 "gitg-cell-renderer-lanes.c"
}


static void gitg_cell_renderer_lanes_finalize (GObject * obj) {
	GitgCellRendererLanes * self;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_g_object_unref0 (self->priv->_commit);
#line 25 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	_g_object_unref0 (self->priv->_next_commit);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	G_OBJECT_CLASS (gitg_cell_renderer_lanes_parent_class)->finalize (obj);
#line 2141 "gitg-cell-renderer-lanes.c"
}


GType gitg_cell_renderer_lanes_get_type (void) {
	static volatile gsize gitg_cell_renderer_lanes_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_cell_renderer_lanes_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgCellRendererLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_cell_renderer_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCellRendererLanes), 0, (GInstanceInitFunc) gitg_cell_renderer_lanes_instance_init, NULL };
		GType gitg_cell_renderer_lanes_type_id;
		gitg_cell_renderer_lanes_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "GitgCellRendererLanes", &g_define_type_info, 0);
		g_once_init_leave (&gitg_cell_renderer_lanes_type_id__volatile, gitg_cell_renderer_lanes_type_id);
	}
	return gitg_cell_renderer_lanes_type_id__volatile;
}


static void _vala_gitg_cell_renderer_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgCellRendererLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	switch (property_id) {
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_COMMIT:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_value_set_object (value, gitg_cell_renderer_lanes_get_commit (self));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_NEXT_COMMIT:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_value_set_object (value, gitg_cell_renderer_lanes_get_next_commit (self));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_LANE_WIDTH:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_value_set_uint (value, gitg_cell_renderer_lanes_get_lane_width (self));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_DOT_WIDTH:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_value_set_uint (value, gitg_cell_renderer_lanes_get_dot_width (self));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_LABELS:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		g_value_set_pointer (value, gitg_cell_renderer_lanes_get_labels (self));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 2192 "gitg-cell-renderer-lanes.c"
		default:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 2198 "gitg-cell-renderer-lanes.c"
	}
}


static void _vala_gitg_cell_renderer_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgCellRendererLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
	switch (property_id) {
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_COMMIT:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_set_commit (self, g_value_get_object (value));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_NEXT_COMMIT:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_set_next_commit (self, g_value_get_object (value));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_LANE_WIDTH:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_set_lane_width (self, g_value_get_uint (value));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_DOT_WIDTH:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_set_dot_width (self, g_value_get_uint (value));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		case GITG_CELL_RENDERER_LANES_LABELS:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		gitg_cell_renderer_lanes_set_labels (self, g_value_get_pointer (value));
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 2238 "gitg-cell-renderer-lanes.c"
		default:
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/jesse/dev/gitg/libgitg/gitg-cell-renderer-lanes.vala"
		break;
#line 2244 "gitg-cell-renderer-lanes.c"
	}
}



