/* dconf-window.c generated by valac 0.34.0.42-30929, the Vala compiler
 * generated from dconf-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_BEHAVIOUR (behaviour_get_type ())

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;
typedef struct _DConfWindowPrivate DConfWindowPrivate;

#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;

#define TYPE_PATH_BAR (path_bar_get_type ())
#define PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_BAR, PathBar))
#define PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_BAR, PathBarClass))
#define IS_PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_BAR))
#define IS_PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_BAR))
#define PATH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_BAR, PathBarClass))

typedef struct _PathBar PathBar;
typedef struct _PathBarClass PathBarClass;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_CONFIGURATION_EDITOR (configuration_editor_get_type ())
#define CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditor))
#define CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))
#define IS_CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_EDITOR))
#define IS_CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_EDITOR))
#define CONFIGURATION_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))

typedef struct _ConfigurationEditor ConfigurationEditor;
typedef struct _ConfigurationEditorClass ConfigurationEditorClass;

#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _DConfWindow {
	GtkApplicationWindow parent_instance;
	DConfWindowPrivate * priv;
};

struct _DConfWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _DConfWindowPrivate {
	gchar* _current_path;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_tiled;
	GSettings* settings;
	Bookmarks* bookmarks_button;
	GtkMenuButton* info_button;
	PathBar* pathbar;
	RegistryView* registry_view;
	GtkRevealer* notification_revealer;
	GtkLabel* notification_label;
	gulong behaviour_changed_handler;
	gulong small_keys_list_rows_handler;
	gulong small_bookmarks_rows_handler;
};

struct _Block1Data {
	int _ref_count_;
	DConfWindow* self;
	GtkStyleContext* context;
};

struct _Block2Data {
	int _ref_count_;
	DConfWindow* self;
	GtkCheckButton* checkbutton;
};

struct _PathElementIface {
	GTypeInterface parent_iface;
};


static gpointer dconf_window_parent_class = NULL;

GType behaviour_get_type (void) G_GNUC_CONST;
GType dconf_window_get_type (void) G_GNUC_CONST;
GType bookmarks_get_type (void) G_GNUC_CONST;
GType path_bar_get_type (void) G_GNUC_CONST;
GType registry_view_get_type (void) G_GNUC_CONST;
#define DCONF_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DCONF_WINDOW, DConfWindowPrivate))
enum  {
	DCONF_WINDOW_DUMMY_PROPERTY,
	DCONF_WINDOW_CURRENT_PATH
};
static void dconf_window_open_path (DConfWindow* self, GSimpleAction* action, GVariant* path_variant);
static void _dconf_window_open_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_reset_recursively (DConfWindow* self);
static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_reset (DConfWindow* self);
static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_enter_delay_mode (DConfWindow* self);
static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
DConfWindow* dconf_window_new (void);
DConfWindow* dconf_window_construct (GType object_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void registry_view_invalidate_popovers (RegistryView* self);
static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda83_ (Block1Data* _data1_);
static void ___lambda83__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda84_ (Block1Data* _data1_);
static void ___lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view);
gchar* dconf_window_stripped_path (const gchar* path);
GtkWidget* _dconf_window_get_parent (GtkWidget* widget);
static void dconf_window_on_show (DConfWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda85_ (Block2Data* _data2_);
static void ___lambda85__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self);
static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event);
static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation);
static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void dconf_window_on_destroy (DConfWindow* self);
GType configuration_editor_get_type (void) G_GNUC_CONST;
void configuration_editor_clean_copy_notification (ConfigurationEditor* self);
static const gchar* dconf_window_get_current_path (DConfWindow* self);
static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void dconf_window_request_path (DConfWindow* self, const gchar* full_name);
void registry_view_set_search_mode (RegistryView* self, gboolean* mode);
void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected);
gchar* path_bar_get_selected_child (PathBar* self, const gchar* current_path);
GType path_element_get_type (void) G_GNUC_CONST;
static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self);
void dconf_window_update_path_elements (DConfWindow* self);
void bookmarks_set_path (Bookmarks* self, const gchar* path);
void path_bar_set_path (PathBar* self, const gchar* path);
void dconf_window_update_hamburger_menu (DConfWindow* self);
gboolean registry_view_get_current_delay_mode (RegistryView* self);
void registry_view_reset (RegistryView* self, gboolean recursively);
void registry_view_enter_delay_mode (RegistryView* self);
static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event);
void registry_view_discard_row_popover (RegistryView* self);
void bookmarks_set_bookmarked (Bookmarks* self, gboolean new_state);
gchar* registry_view_get_copy_text (RegistryView* self);
void configuration_editor_copy (ConfigurationEditor* self, const gchar* text);
void configuration_editor_about_cb (ConfigurationEditor* self);
gboolean path_bar_open_child (PathBar* self, const gchar* current_path);
gboolean registry_view_show_row_popover (RegistryView* self);
gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event);
static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void dconf_window_on_menu_button_clicked (DConfWindow* self);
static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_show_notification (DConfWindow* self, const gchar* notification);
static void dconf_window_hide_notification (DConfWindow* self);
static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_set_current_path (DConfWindow* self, const gchar* value);
static void dconf_window_finalize (GObject* obj);
static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry DCONF_WINDOW_action_entries[4] = {{"open-path", _dconf_window_open_path_gsimple_action_activate_callback, "s"}, {"reset-recursive", _dconf_window_reset_recursively_gsimple_action_activate_callback}, {"reset-visible", _dconf_window_reset_gsimple_action_activate_callback}, {"enter-delay-mode", _dconf_window_enter_delay_mode_gsimple_action_activate_callback}};

GType behaviour_get_type (void) {
	static volatile gsize behaviour_type_id__volatile = 0;
	if (g_once_init_enter (&behaviour_type_id__volatile)) {
		static const GEnumValue values[] = {{BEHAVIOUR_UNSAFE, "BEHAVIOUR_UNSAFE", "unsafe"}, {BEHAVIOUR_SAFE, "BEHAVIOUR_SAFE", "safe"}, {BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT", "always-confirm-implicit"}, {BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT", "always-confirm-explicit"}, {BEHAVIOUR_ALWAYS_DELAY, "BEHAVIOUR_ALWAYS_DELAY", "always-delay"}, {0, NULL, NULL}};
		GType behaviour_type_id;
		behaviour_type_id = g_enum_register_static ("Behaviour", values);
		g_once_init_leave (&behaviour_type_id__volatile, behaviour_type_id);
	}
	return behaviour_type_id__volatile;
}


static void _dconf_window_open_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_open_path ((DConfWindow*) self, action, parameter);
#line 252 "dconf-window.c"
}


static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_reset_recursively ((DConfWindow*) self);
#line 259 "dconf-window.c"
}


static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_reset ((DConfWindow*) self);
#line 266 "dconf-window.c"
}


static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_enter_delay_mode ((DConfWindow*) self);
#line 273 "dconf-window.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return _data1_;
#line 282 "dconf-window.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 291 "dconf-window.c"
		DConfWindow* self;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self = _data1_->self;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (_data1_->context);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (self);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_slice_free (Block1Data, _data1_);
#line 301 "dconf-window.c"
	}
}


static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_invalidate_popovers ((RegistryView*) self);
#line 309 "dconf-window.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 316 "dconf-window.c"
}


static void __lambda83_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-keys-list-rows");
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp1_) {
#line 332 "dconf-window.c"
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = _data1_->context;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-keys-list-rows");
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp3_) {
#line 341 "dconf-window.c"
			GtkStyleContext* _tmp4_ = NULL;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp4_ = _data1_->context;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp4_, "small-keys-list-rows");
#line 347 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = _data1_->context;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-keys-list-rows");
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp6_) {
#line 358 "dconf-window.c"
			GtkStyleContext* _tmp7_ = NULL;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp7_ = _data1_->context;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp7_, "small-keys-list-rows");
#line 364 "dconf-window.c"
		}
	}
}


static void ___lambda83__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda83_ (self);
#line 373 "dconf-window.c"
}


static void __lambda84_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-bookmarks-rows");
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp1_) {
#line 389 "dconf-window.c"
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = _data1_->context;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-bookmarks-rows");
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp3_) {
#line 398 "dconf-window.c"
			GtkStyleContext* _tmp4_ = NULL;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp4_ = _data1_->context;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp4_, "small-bookmarks-rows");
#line 404 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = _data1_->context;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-bookmarks-rows");
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp6_) {
#line 415 "dconf-window.c"
			GtkStyleContext* _tmp7_ = NULL;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp7_ = _data1_->context;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp7_, "small-bookmarks-rows");
#line 421 "dconf-window.c"
		}
	}
}


static void ___lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda84_ (self);
#line 430 "dconf-window.c"
}


DConfWindow* dconf_window_construct (GType object_type) {
	DConfWindow * self = NULL;
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkStyleContext* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	GSettings* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
	GSettings* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSettings* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	RegistryView* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	RegistryView* _tmp23_ = NULL;
	RegistryView* _tmp24_ = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->_ref_count_ = 1;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = (DConfWindow*) g_object_new (object_type, NULL);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->self = g_object_ref (self);
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, DCONF_WINDOW_action_entries, G_N_ELEMENTS (DCONF_WINDOW_action_entries), self);
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->registry_view;
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = g_signal_connect_object (_tmp0_, "changed::behaviour", (GCallback) _registry_view_invalidate_popovers_g_settings_changed, _tmp1_, 0);
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->behaviour_changed_handler = _tmp2_;
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->settings;
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_settings_get_int (_tmp3_, "window-width");
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = self->priv->settings;
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = g_settings_get_int (_tmp5_, "window-height");
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp4_, _tmp6_);
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = self->priv->settings;
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = g_settings_get_boolean (_tmp7_, "window-is-maximized");
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp8_) {
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 501 "dconf-window.c"
	}
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->context = _tmp10_;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = self->priv->settings;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = g_signal_connect_data (_tmp11_, "changed::small-keys-list-rows", (GCallback) ___lambda83__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_keys_list_rows_handler = _tmp12_;
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = self->priv->settings;
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = g_signal_connect_data (_tmp13_, "changed::small-bookmarks-rows", (GCallback) ___lambda84__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_bookmarks_rows_handler = _tmp14_;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = self->priv->settings;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = g_settings_get_boolean (_tmp15_, "small-keys-list-rows");
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp16_) {
#line 527 "dconf-window.c"
		GtkStyleContext* _tmp17_ = NULL;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp17_ = _data1_->context;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp17_, "small-keys-list-rows");
#line 533 "dconf-window.c"
	}
#line 99 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = self->priv->settings;
#line 99 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp19_ = g_settings_get_boolean (_tmp18_, "small-bookmarks-rows");
#line 99 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp19_) {
#line 541 "dconf-window.c"
		GtkStyleContext* _tmp20_ = NULL;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = _data1_->context;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp20_, "small-bookmarks-rows");
#line 547 "dconf-window.c"
	}
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = self->priv->registry_view;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "current-path", (GObject*) self, "current-path", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp22_ = self->priv->settings;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp23_ = self->priv->registry_view;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_bind (_tmp22_, "behaviour", (GObject*) _tmp23_, "behaviour", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp24_ = self->priv->registry_view;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp25_ = self->priv->settings;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp26_ = g_settings_get_string (_tmp25_, "saved-view");
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp27_ = _tmp26_;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp28_ = self->priv->settings;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp29_ = g_settings_get_boolean (_tmp28_, "restore-view");
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_init (_tmp24_, _tmp27_, _tmp29_);
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp27_);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	block1_data_unref (_data1_);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_ = NULL;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return self;
#line 581 "dconf-window.c"
}


DConfWindow* dconf_window_new (void) {
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return dconf_window_construct (TYPE_DCONF_WINDOW);
#line 588 "dconf-window.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1344 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1345 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1345 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1345 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1346 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1346 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 621 "dconf-window.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1347 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1347 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1347 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 630 "dconf-window.c"
	}
#line 1349 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1349 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 636 "dconf-window.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1350 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1350 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1350 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 645 "dconf-window.c"
	}
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 651 "dconf-window.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 660 "dconf-window.c"
	} else {
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 664 "dconf-window.c"
	}
#line 1352 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 672 "dconf-window.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 681 "dconf-window.c"
	} else {
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 685 "dconf-window.c"
	}
#line 1353 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1354 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1354 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1354 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1355 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1355 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1355 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1355 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1355 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1355 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 707 "dconf-window.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1033 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1034 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1034 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1034 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1034 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1036 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1036 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 732 "dconf-window.c"
		gchar* _tmp4_ = NULL;
#line 1037 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1037 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1037 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 740 "dconf-window.c"
	} else {
#line 1039 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		result = -1;
#line 1039 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 746 "dconf-window.c"
	}
}


gchar* dconf_window_stripped_path (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = path;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = strlen (_tmp0_);
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp2_ <= 1) {
#line 770 "dconf-window.c"
		gchar* _tmp3_ = NULL;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = g_strdup ("/");
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = _tmp3_;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 778 "dconf-window.c"
	}
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = path;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = path;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = string_last_index_of_char (_tmp5_, (gunichar) '/', 0);
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = string_slice (_tmp4_, (glong) 0, (glong) (_tmp6_ + 1));
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp7_;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 792 "dconf-window.c"
}


GtkWidget* _dconf_window_get_parent (GtkWidget* widget) {
	GtkWidget* result = NULL;
	GtkWidget* parent = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = widget;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = (GtkContainer*) gtk_widget_get_parent (_tmp0_);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	parent = _tmp2_;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (parent == NULL) {
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_assert_not_reached ();
#line 817 "dconf-window.c"
	}
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (parent, gtk_widget_get_type (), GtkWidget));
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp3_;
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (parent);
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 827 "dconf-window.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return _data2_;
#line 836 "dconf-window.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 845 "dconf-window.c"
		DConfWindow* self;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self = _data2_->self;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (_data2_->checkbutton);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (self);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_slice_free (Block2Data, _data2_);
#line 855 "dconf-window.c"
	}
}


static void __lambda85_ (Block2Data* _data2_) {
	DConfWindow* self;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data2_->self;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = _data2_->checkbutton;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp2_) {
#line 875 "dconf-window.c"
		GSettings* _tmp3_ = NULL;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = self->priv->settings;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_settings_set_boolean (_tmp3_, "show-warning", FALSE);
#line 881 "dconf-window.c"
	}
}


static void ___lambda85__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda85_ (self);
#line 889 "dconf-window.c"
}


static void dconf_window_on_show (DConfWindow* self) {
	Block2Data* _data2_;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkBox* box = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCheckButton* _tmp12_ = NULL;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkCheckButton* _tmp17_ = NULL;
	gulong dialog_response_handler = 0UL;
	GtkMessageDialog* _tmp18_ = NULL;
	gulong _tmp19_ = 0UL;
	GtkMessageDialog* _tmp20_ = NULL;
	GtkMessageDialog* _tmp21_ = NULL;
	gulong _tmp22_ = 0UL;
	GtkMessageDialog* _tmp23_ = NULL;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->_ref_count_ = 1;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->self = g_object_ref (self);
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "show-warning");
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp1_) {
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		block2_data_unref (_data2_);
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_data2_ = NULL;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return;
#line 942 "dconf-window.c"
	}
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _ ("Thanks for using Dconf Editor for editing your settings!");
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, _tmp2_);
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_ref_sink (_tmp3_);
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dialog = _tmp3_;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = dialog;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _ ("Don’t forget that some options may break applications, so be careful.");
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = dialog;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _ ("I’ll be careful.");
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_ACCEPT, NULL);
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = dialog;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = gtk_message_dialog_get_message_area (_tmp8_);
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_box_get_type (), GtkBox));
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	box = _tmp10_;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = _ ("Show this dialog next time.");
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp11_);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_ref_sink (_tmp12_);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->checkbutton = _tmp12_;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = _data2_->checkbutton;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = _data2_->checkbutton;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = _data2_->checkbutton;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 5);
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = box;
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp17_ = _data2_->checkbutton;
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = dialog;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp19_ = g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda85__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dialog_response_handler = _tmp19_;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = dialog;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_dialog_run ((GtkDialog*) _tmp20_);
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = dialog;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp22_ = dialog_response_handler;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp21_, _tmp22_);
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp23_ = dialog;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp23_);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (box);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (dialog);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	block2_data_unref (_data2_);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_ = NULL;
#line 1026 "dconf-window.c"
}


static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_show ((DConfWindow*) self);
#line 1033 "dconf-window.c"
}


static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = event;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1055 "dconf-window.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = event;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1064 "dconf-window.c"
	}
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = event;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1072 "dconf-window.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = event;
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self->priv->window_is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1081 "dconf-window.c"
	}
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = FALSE;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 1087 "dconf-window.c"
}


static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_window_state_event ((DConfWindow*) self, _sender, event);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 1096 "dconf-window.c"
}


static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation) {
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (allocation != NULL);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	context = _tmp1_;
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = *allocation;
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = _tmp2_.width;
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp3_ > 1200) {
#line 1126 "dconf-window.c"
		GtkStyleContext* _tmp4_ = NULL;
		GtkStyleContext* _tmp5_ = NULL;
		GtkStyleContext* _tmp6_ = NULL;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp4_ = context;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp4_, "xxl");
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = context;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp5_, "xl");
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = context;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp6_, "large-window");
#line 1142 "dconf-window.c"
	} else {
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = *allocation;
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp8_ = _tmp7_.width;
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp8_ > 1100) {
#line 1152 "dconf-window.c"
			GtkStyleContext* _tmp9_ = NULL;
			GtkStyleContext* _tmp10_ = NULL;
			GtkStyleContext* _tmp11_ = NULL;
#line 176 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp9_ = context;
#line 176 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp9_, "xxl");
#line 177 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp10_ = context;
#line 177 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp10_, "xl");
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp11_ = context;
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp11_, "large-window");
#line 1168 "dconf-window.c"
		} else {
			GtkAllocation _tmp12_ = {0};
			gint _tmp13_ = 0;
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp12_ = *allocation;
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp13_ = _tmp12_.width;
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (_tmp13_ > 1000) {
#line 1178 "dconf-window.c"
				GtkStyleContext* _tmp14_ = NULL;
				GtkStyleContext* _tmp15_ = NULL;
				GtkStyleContext* _tmp16_ = NULL;
#line 182 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp14_ = context;
#line 182 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp14_, "xxl");
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp15_ = context;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp15_, "xl");
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp16_ = context;
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_add_class (_tmp16_, "large-window");
#line 1194 "dconf-window.c"
			} else {
				GtkStyleContext* _tmp17_ = NULL;
				GtkStyleContext* _tmp18_ = NULL;
				GtkStyleContext* _tmp19_ = NULL;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp17_ = context;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp17_, "xxl");
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp18_ = context;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp18_, "xl");
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp19_ = context;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp19_, "large-window");
#line 1211 "dconf-window.c"
			}
		}
	}
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = self->priv->window_is_maximized;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp21_) {
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = TRUE;
#line 1221 "dconf-window.c"
	} else {
		gboolean _tmp22_ = FALSE;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp22_ = self->priv->window_is_tiled;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = _tmp22_;
#line 1228 "dconf-window.c"
	}
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp20_) {
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (context);
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return;
#line 1236 "dconf-window.c"
	}
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp23_, &_tmp24_);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_width = _tmp23_;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_height = _tmp24_;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (context);
#line 1246 "dconf-window.c"
}


static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_size_allocate ((DConfWindow*) self, allocation);
#line 1253 "dconf-window.c"
}


static void dconf_window_on_destroy (DConfWindow* self) {
	GtkApplication* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	GSettings* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GSettings* _tmp16_ = NULL;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	configuration_editor_clean_copy_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->settings;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->behaviour_changed_handler;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->settings;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = self->priv->small_keys_list_rows_handler;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp3_, _tmp4_);
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = self->priv->settings;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = self->priv->small_bookmarks_rows_handler;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp5_, _tmp6_);
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = self->priv->settings;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_delay (_tmp7_);
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = self->priv->settings;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = self->priv->_current_path;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_string (_tmp8_, "saved-view", _tmp9_);
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = self->priv->settings;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = self->priv->window_width;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_int (_tmp10_, "window-width", _tmp11_);
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = self->priv->settings;
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = self->priv->window_height;
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_int (_tmp12_, "window-height", _tmp13_);
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = self->priv->settings;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = self->priv->window_is_maximized;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_boolean (_tmp14_, "window-is-maximized", _tmp15_);
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = self->priv->settings;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_apply (_tmp16_);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	GTK_WIDGET_CLASS (dconf_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
#line 1333 "dconf-window.c"
}


static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_destroy ((DConfWindow*) self);
#line 1340 "dconf-window.c"
}


static void dconf_window_request_path (DConfWindow* self, const gchar* full_name) {
	RegistryView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RegistryView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	PathBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 225 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 225 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (full_name != NULL);
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = FALSE;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_set_search_mode (_tmp0_, &_tmp1_);
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->registry_view;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = full_name;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = self->priv->pathbar;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = full_name;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = path_bar_get_selected_child (_tmp4_, _tmp5_);
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _tmp6_;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_path_requested (_tmp2_, _tmp3_, _tmp7_);
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp7_);
#line 1379 "dconf-window.c"
}


static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_request_path ((DConfWindow*) self, path);
#line 1386 "dconf-window.c"
}


void dconf_window_update_path_elements (DConfWindow* self) {
	Bookmarks* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PathBar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->bookmarks_button;
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->_current_path;
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	bookmarks_set_path (_tmp0_, _tmp1_);
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->pathbar;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->_current_path;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	path_bar_set_path (_tmp2_, _tmp3_);
#line 1409 "dconf-window.c"
}


void dconf_window_update_hamburger_menu (DConfWindow* self) {
	GMenu* section = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	RegistryView* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GMenu* _tmp28_ = NULL;
	GtkMenuButton* _tmp29_ = NULL;
	GMenu* _tmp30_ = NULL;
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = g_menu_new ();
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	menu = _tmp0_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = menu;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _ ("Copy current path");
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->_current_path;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_strescape (_tmp3_, "");
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _tmp4_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = g_strconcat ("app.copy(\"", _tmp5_, NULL);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _tmp6_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = g_strconcat (_tmp7_, "\")", NULL);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = _tmp8_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_menu_append (_tmp1_, _tmp2_, _tmp9_);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp9_);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp7_);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp5_);
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = self->priv->_current_path;
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = g_str_has_suffix (_tmp10_, "/");
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp11_) {
#line 1471 "dconf-window.c"
		GMenu* _tmp12_ = NULL;
		GMenu* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GMenu* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GMenu* _tmp17_ = NULL;
		GMenu* _tmp18_ = NULL;
		GMenu* _tmp19_ = NULL;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp12_ = g_menu_new ();
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (section);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		section = _tmp12_;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp13_ = section;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp14_ = _ ("Reset visible keys");
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp13_, _tmp14_, "win.reset-visible");
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp15_ = section;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp16_ = _ ("Reset recursively");
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp15_, _tmp16_, "win.reset-recursive");
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp17_ = section;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_freeze (_tmp17_);
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp18_ = menu;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp19_ = section;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append_section (_tmp18_, NULL, (GMenuModel*) _tmp19_);
#line 1508 "dconf-window.c"
	}
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = self->priv->registry_view;
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = registry_view_get_current_delay_mode (_tmp20_);
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp21_) {
#line 1516 "dconf-window.c"
		GMenu* _tmp22_ = NULL;
		GMenu* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GMenu* _tmp25_ = NULL;
		GMenu* _tmp26_ = NULL;
		GMenu* _tmp27_ = NULL;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp22_ = g_menu_new ();
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (section);
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		section = _tmp22_;
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp23_ = section;
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp24_ = _ ("Enter delay mode");
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp23_, _tmp24_, "win.enter-delay-mode");
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp25_ = section;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_freeze (_tmp25_);
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp26_ = menu;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp27_ = section;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append_section (_tmp26_, NULL, (GMenuModel*) _tmp27_);
#line 1545 "dconf-window.c"
	}
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp28_ = menu;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_menu_freeze (_tmp28_);
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp29_ = self->priv->info_button;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp30_ = menu;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_menu_button_set_menu_model (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_menu_model_get_type (), GMenuModel));
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (menu);
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (section);
#line 1561 "dconf-window.c"
}


static void dconf_window_open_path (DConfWindow* self, GSimpleAction* action, GVariant* path_variant) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (action != NULL);
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = path_variant;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "path_variant != null");
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = path_variant;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = g_variant_get_string ((GVariant*) _tmp1_, NULL);
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_request_path (self, _tmp2_);
#line 1583 "dconf-window.c"
}


static void dconf_window_reset (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_reset (_tmp0_, FALSE);
#line 1595 "dconf-window.c"
}


static void dconf_window_reset_recursively (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_reset (_tmp0_, TRUE);
#line 1607 "dconf-window.c"
}


static void dconf_window_enter_delay_mode (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_enter_delay_mode (_tmp0_);
#line 1619 "dconf-window.c"
}


static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* name = NULL;
	gchar* _tmp4_ = NULL;
	GdkEventKey* _tmp5_ = NULL;
	GdkModifierType _tmp6_ = 0;
	GdkEventKey* _tmp56_ = NULL;
	GdkModifierType _tmp57_ = 0;
	const gchar* _tmp87_ = NULL;
	gboolean _tmp113_ = FALSE;
	Bookmarks* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_ = FALSE;
	RegistryView* _tmp120_ = NULL;
	GdkEventKey* _tmp121_ = NULL;
	gboolean _tmp122_ = FALSE;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = event;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_->keyval;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = gdk_keyval_name (_tmp2_);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = _tmp3_;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp0_ == NULL) {
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp0_ = "";
#line 1661 "dconf-window.c"
	}
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp0_);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	name = _tmp4_;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = event;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = _tmp5_->state;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp6_ & GDK_CONTROL_MASK) != 0) {
#line 1673 "dconf-window.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GQuark _tmp10_ = 0U;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label0 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label1 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label2 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label3 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label4 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label5 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label6 = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = name;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp8_ = _tmp7_;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("b")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1701 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					RegistryView* _tmp15_ = NULL;
					Bookmarks* _tmp16_ = NULL;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp11_ = self->priv->info_button;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp13_ = _tmp12_;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp13_) {
#line 1717 "dconf-window.c"
						GtkMenuButton* _tmp14_ = NULL;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp14_ = self->priv->info_button;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, FALSE);
#line 1723 "dconf-window.c"
					}
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp15_ = self->priv->registry_view;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp15_);
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp16_ = self->priv->bookmarks_button;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_button_clicked ((GtkButton*) _tmp16_);
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1739 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("d")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1745 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					RegistryView* _tmp21_ = NULL;
					Bookmarks* _tmp22_ = NULL;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp17_ = self->priv->info_button;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp18_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp17_);
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp19_ = _tmp18_;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp19_) {
#line 1761 "dconf-window.c"
						GtkMenuButton* _tmp20_ = NULL;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp20_ = self->priv->info_button;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, FALSE);
#line 1767 "dconf-window.c"
					}
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp21_ = self->priv->registry_view;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp21_);
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp22_ = self->priv->bookmarks_button;
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					bookmarks_set_bookmarked (_tmp22_, TRUE);
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1783 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("D")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1789 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					RegistryView* _tmp27_ = NULL;
					Bookmarks* _tmp28_ = NULL;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp23_ = self->priv->info_button;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp24_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp23_);
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp25_ = _tmp24_;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp25_) {
#line 1805 "dconf-window.c"
						GtkMenuButton* _tmp26_ = NULL;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp26_ = self->priv->info_button;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp26_, FALSE);
#line 1811 "dconf-window.c"
					}
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp27_ = self->priv->registry_view;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp27_);
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp28_ = self->priv->bookmarks_button;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					bookmarks_set_bookmarked (_tmp28_, FALSE);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1827 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("f")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1833 "dconf-window.c"
				default:
				{
					Bookmarks* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					GtkMenuButton* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					RegistryView* _tmp37_ = NULL;
					RegistryView* _tmp38_ = NULL;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp29_ = self->priv->bookmarks_button;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp30_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp29_);
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp31_ = _tmp30_;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp31_) {
#line 1852 "dconf-window.c"
						Bookmarks* _tmp32_ = NULL;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp32_ = self->priv->bookmarks_button;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp32_, FALSE);
#line 1858 "dconf-window.c"
					}
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp33_ = self->priv->info_button;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp35_ = _tmp34_;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp35_) {
#line 1868 "dconf-window.c"
						GtkMenuButton* _tmp36_ = NULL;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp36_ = self->priv->info_button;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp36_, FALSE);
#line 1874 "dconf-window.c"
					}
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp37_ = self->priv->registry_view;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp37_);
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp38_ = self->priv->registry_view;
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_set_search_mode (_tmp38_, NULL);
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1890 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("c")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1896 "dconf-window.c"
				default:
				{
					RegistryView* _tmp39_ = NULL;
					gchar* selected_row_text = NULL;
					RegistryView* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					ConfigurationEditor* application = NULL;
					GtkApplication* _tmp42_ = NULL;
					ConfigurationEditor* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					ConfigurationEditor* _tmp48_ = NULL;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp39_ = self->priv->registry_view;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp39_);
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp40_ = self->priv->registry_view;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp41_ = registry_view_get_copy_text (_tmp40_);
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					selected_row_text = _tmp41_;
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp42_ = gtk_window_get_application ((GtkWindow*) self);
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					application = _tmp43_;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp45_ = selected_row_text;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp45_ == NULL) {
#line 1929 "dconf-window.c"
						const gchar* _tmp46_ = NULL;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp46_ = self->priv->_current_path;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp44_ = _tmp46_;
#line 1935 "dconf-window.c"
					} else {
						const gchar* _tmp47_ = NULL;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp47_ = selected_row_text;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp44_ = (const gchar*) _tmp47_;
#line 1942 "dconf-window.c"
					}
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp48_ = application;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_copy (_tmp48_, _tmp44_);
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_object_unref0 (application);
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (selected_row_text);
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1958 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label5) ? _tmp9_label5 : (_tmp9_label5 = g_quark_from_static_string ("C")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1964 "dconf-window.c"
				default:
				{
					RegistryView* _tmp49_ = NULL;
					GtkApplication* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp49_ = self->priv->registry_view;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp49_);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp50_ = gtk_window_get_application ((GtkWindow*) self);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp51_ = self->priv->_current_path;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor), _tmp51_);
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1986 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label6) ? _tmp9_label6 : (_tmp9_label6 = g_quark_from_static_string ("F1")))) {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1992 "dconf-window.c"
				default:
				{
					RegistryView* _tmp52_ = NULL;
					GdkEventKey* _tmp53_ = NULL;
					GdkModifierType _tmp54_ = 0;
					GtkApplication* _tmp55_ = NULL;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp52_ = self->priv->registry_view;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp52_);
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp53_ = event;
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp54_ = _tmp53_->state;
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if ((_tmp54_ & GDK_SHIFT_MASK) == 0) {
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						result = FALSE;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_g_free0 (name);
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						return result;
#line 2015 "dconf-window.c"
					}
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp55_ = gtk_window_get_application ((GtkWindow*) self);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_about_cb (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2027 "dconf-window.c"
				}
			}
		} else {
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 2033 "dconf-window.c"
				default:
				{
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					break;
#line 2038 "dconf-window.c"
				}
			}
		}
	}
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp56_ = event;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp57_ = _tmp56_->state;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp57_ & GDK_MOD1_MASK) != 0) {
#line 2049 "dconf-window.c"
		const gchar* _tmp58_ = NULL;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp58_ = name;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (g_strcmp0 (_tmp58_, "Up") == 0) {
#line 2055 "dconf-window.c"
			const gchar* _tmp59_ = NULL;
			GdkEventKey* _tmp60_ = NULL;
			GdkModifierType _tmp61_ = 0;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp59_ = self->priv->_current_path;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (g_strcmp0 (_tmp59_, "/") == 0) {
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				result = TRUE;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_g_free0 (name);
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				return result;
#line 2069 "dconf-window.c"
			}
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp60_ = event;
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp61_ = _tmp60_->state;
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if ((_tmp61_ & GDK_SHIFT_MASK) != 0) {
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				dconf_window_request_path (self, "/");
#line 2079 "dconf-window.c"
			} else {
				const gchar* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp62_ = self->priv->_current_path;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp63_ = g_str_has_suffix (_tmp62_, "/");
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp63_) {
#line 2089 "dconf-window.c"
					const gchar* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp64_ = self->priv->_current_path;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp65_ = self->priv->_current_path;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp66_ = self->priv->_current_path;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp67_ = strlen (_tmp66_);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp68_ = _tmp67_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp69_ = string_slice (_tmp65_, (glong) 0, (glong) (_tmp68_ - 1));
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp70_ = _tmp69_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp71_ = string_last_index_of_char (_tmp70_, (gunichar) '/', 0);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp72_ = string_slice (_tmp64_, (glong) 0, (glong) (_tmp71_ + 1));
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp73_ = _tmp72_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					dconf_window_request_path (self, _tmp73_);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp73_);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp70_);
#line 2126 "dconf-window.c"
				} else {
					const gchar* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gint _tmp76_ = 0;
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp74_ = self->priv->_current_path;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp75_ = self->priv->_current_path;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp76_ = string_last_index_of_char (_tmp75_, (gunichar) '/', 0);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp77_ = string_slice (_tmp74_, (glong) 0, (glong) (_tmp76_ + 1));
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp78_ = _tmp77_;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					dconf_window_request_path (self, _tmp78_);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp78_);
#line 2147 "dconf-window.c"
				}
			}
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			result = TRUE;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_g_free0 (name);
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			return result;
#line 2156 "dconf-window.c"
		} else {
			const gchar* _tmp79_ = NULL;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp79_ = name;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (g_strcmp0 (_tmp79_, "Down") == 0) {
#line 2163 "dconf-window.c"
				GdkEventKey* _tmp80_ = NULL;
				GdkModifierType _tmp81_ = 0;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp80_ = event;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp81_ = _tmp80_->state;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if ((_tmp81_ & GDK_SHIFT_MASK) != 0) {
#line 2172 "dconf-window.c"
					PathBar* _tmp82_ = NULL;
					gboolean _tmp83_ = FALSE;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp82_ = self->priv->pathbar;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp83_ = path_bar_open_child (_tmp82_, NULL);
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = _tmp83_;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2185 "dconf-window.c"
				} else {
					PathBar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					gboolean _tmp86_ = FALSE;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp84_ = self->priv->pathbar;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp85_ = self->priv->_current_path;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp86_ = path_bar_open_child (_tmp84_, _tmp85_);
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = _tmp86_;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2202 "dconf-window.c"
				}
			}
		}
	}
#line 374 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp87_ = name;
#line 374 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_strcmp0 (_tmp87_, "F10") == 0) {
#line 2211 "dconf-window.c"
		RegistryView* _tmp88_ = NULL;
		Bookmarks* _tmp89_ = NULL;
		gboolean _tmp90_ = FALSE;
		gboolean _tmp91_ = FALSE;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp88_ = self->priv->registry_view;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		registry_view_discard_row_popover (_tmp88_);
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp89_ = self->priv->bookmarks_button;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp90_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp89_);
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp91_ = _tmp90_;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp91_) {
#line 2228 "dconf-window.c"
			Bookmarks* _tmp92_ = NULL;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp92_ = self->priv->bookmarks_button;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp92_, FALSE);
#line 2234 "dconf-window.c"
		}
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = FALSE;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_free0 (name);
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 2242 "dconf-window.c"
	} else {
		const gchar* _tmp93_ = NULL;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp93_ = name;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (g_strcmp0 (_tmp93_, "Menu") == 0) {
#line 2249 "dconf-window.c"
			RegistryView* _tmp94_ = NULL;
			gboolean _tmp95_ = FALSE;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp94_ = self->priv->registry_view;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp95_ = registry_view_show_row_popover (_tmp94_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (_tmp95_) {
#line 2258 "dconf-window.c"
				Bookmarks* _tmp96_ = NULL;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				GtkMenuButton* _tmp100_ = NULL;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp96_ = self->priv->bookmarks_button;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp97_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp96_);
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp98_ = _tmp97_;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp98_) {
#line 2273 "dconf-window.c"
					Bookmarks* _tmp99_ = NULL;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp99_ = self->priv->bookmarks_button;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp99_, FALSE);
#line 2279 "dconf-window.c"
				}
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp100_ = self->priv->info_button;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp101_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp100_);
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp102_ = _tmp101_;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp102_) {
#line 2289 "dconf-window.c"
					GtkMenuButton* _tmp103_ = NULL;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp103_ = self->priv->info_button;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp103_, FALSE);
#line 2295 "dconf-window.c"
				}
			} else {
				GtkMenuButton* _tmp104_ = NULL;
				gboolean _tmp105_ = FALSE;
				gboolean _tmp106_ = FALSE;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp104_ = self->priv->info_button;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp105_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp104_);
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp106_ = _tmp105_;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp106_ == FALSE) {
#line 2309 "dconf-window.c"
					Bookmarks* _tmp107_ = NULL;
					gboolean _tmp108_ = FALSE;
					gboolean _tmp109_ = FALSE;
					GtkMenuButton* _tmp111_ = NULL;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp107_ = self->priv->bookmarks_button;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp108_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp107_);
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp109_ = _tmp108_;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp109_) {
#line 2322 "dconf-window.c"
						Bookmarks* _tmp110_ = NULL;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp110_ = self->priv->bookmarks_button;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp110_, FALSE);
#line 2328 "dconf-window.c"
					}
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp111_ = self->priv->info_button;
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp111_, TRUE);
#line 2334 "dconf-window.c"
				} else {
					GtkMenuButton* _tmp112_ = NULL;
#line 397 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp112_ = self->priv->info_button;
#line 397 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp112_, FALSE);
#line 2341 "dconf-window.c"
				}
			}
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			result = TRUE;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_g_free0 (name);
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			return result;
#line 2350 "dconf-window.c"
		}
	}
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp114_ = self->priv->bookmarks_button;
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp115_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp114_);
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp116_ = _tmp115_;
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp116_) {
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp113_ = TRUE;
#line 2363 "dconf-window.c"
	} else {
		GtkMenuButton* _tmp117_ = NULL;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp117_ = self->priv->info_button;
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp118_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp117_);
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp119_ = _tmp118_;
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp113_ = _tmp119_;
#line 2376 "dconf-window.c"
	}
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp113_) {
#line 402 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = FALSE;
#line 402 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_free0 (name);
#line 402 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 2386 "dconf-window.c"
	}
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp120_ = self->priv->registry_view;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp121_ = event;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp122_ = registry_view_handle_search_event (_tmp120_, _tmp121_);
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp122_;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (name);
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2400 "dconf-window.c"
}


static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_key_press_event ((DConfWindow*) self, _sender, event);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2409 "dconf-window.c"
}


static void dconf_window_on_menu_button_clicked (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 408 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_discard_row_popover (_tmp0_);
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->registry_view;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = FALSE;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_set_search_mode (_tmp1_, &_tmp2_);
#line 2429 "dconf-window.c"
}


static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_menu_button_clicked ((DConfWindow*) self);
#line 2436 "dconf-window.c"
}


void dconf_window_show_notification (DConfWindow* self, const gchar* notification) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRevealer* _tmp2_ = NULL;
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (notification != NULL);
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->notification_label;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = notification;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_label_set_text (_tmp0_, _tmp1_);
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->notification_revealer;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_revealer_set_reveal_child (_tmp2_, TRUE);
#line 2458 "dconf-window.c"
}


static void dconf_window_hide_notification (DConfWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->notification_revealer;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 2470 "dconf-window.c"
}


static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_hide_notification ((DConfWindow*) self);
#line 2477 "dconf-window.c"
}


static const gchar* dconf_window_get_current_path (DConfWindow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->_current_path;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp0_;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2492 "dconf-window.c"
}


void dconf_window_set_current_path (DConfWindow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = value;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (self->priv->_current_path);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->_current_path = _tmp1_;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_notify ((GObject *) self, "current-path");
#line 2511 "dconf-window.c"
}


static void dconf_window_class_init (DConfWindowClass * klass) {
	gint DConfWindow_private_offset;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_parent_class = g_type_class_peek_parent (klass);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_class_add_private (klass, sizeof (DConfWindowPrivate));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_dconf_window_get_property;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_dconf_window_set_property;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->finalize = dconf_window_finalize;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_WINDOW_CURRENT_PATH, g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	DConfWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/dconf-editor.ui");
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, bookmarks_button));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, info_button));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, pathbar));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "registry_view", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, registry_view));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_revealer", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_revealer));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_label", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_label));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_show", G_CALLBACK(_dconf_window_on_show_gtk_widget_show));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_dconf_window_on_window_state_event_gtk_widget_window_state_event));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_dconf_window_on_size_allocate_gtk_widget_size_allocate));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_dconf_window_on_destroy_gtk_widget_destroy));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "request_path", G_CALLBACK(_dconf_window_request_path_path_element_request_path));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_press_event", G_CALLBACK(_dconf_window_on_key_press_event_gtk_widget_key_press_event));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_menu_button_clicked", G_CALLBACK(_dconf_window_on_menu_button_clicked_gtk_button_clicked));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "hide_notification", G_CALLBACK(_dconf_window_hide_notification_gtk_button_clicked));
#line 2561 "dconf-window.c"
}


static void dconf_window_instance_init (DConfWindow * self) {
	gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv = DCONF_WINDOW_GET_PRIVATE (self);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = g_strdup ("/");
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->_current_path = _tmp0_;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_width = 0;
#line 43 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_height = 0;
#line 44 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_is_maximized = FALSE;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_is_tiled = FALSE;
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->settings = _tmp1_;
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->behaviour_changed_handler = (gulong) 0;
#line 59 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_keys_list_rows_handler = (gulong) 0;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_bookmarks_rows_handler = (gulong) 0;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_BOOKMARKS);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_PATH_BAR);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_REGISTRY_VIEW);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 2600 "dconf-window.c"
}


static void dconf_window_finalize (GObject* obj) {
	DConfWindow * self;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_WINDOW, DConfWindow);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (self->priv->_current_path);
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->bookmarks_button);
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->info_button);
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->pathbar);
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->registry_view);
#line 54 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->notification_revealer);
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->notification_label);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (dconf_window_parent_class)->finalize (obj);
#line 2626 "dconf-window.c"
}


GType dconf_window_get_type (void) {
	static volatile gsize dconf_window_type_id__volatile = 0;
	if (g_once_init_enter (&dconf_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DConfWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfWindow), 0, (GInstanceInitFunc) dconf_window_instance_init, NULL };
		GType dconf_window_type_id;
		dconf_window_type_id = g_type_register_static (gtk_application_window_get_type (), "DConfWindow", &g_define_type_info, 0);
		g_once_init_leave (&dconf_window_type_id__volatile, dconf_window_type_id);
	}
	return dconf_window_type_id__volatile;
}


static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	switch (property_id) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		case DCONF_WINDOW_CURRENT_PATH:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_value_set_string (value, dconf_window_get_current_path (self));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2653 "dconf-window.c"
		default:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2659 "dconf-window.c"
	}
}


static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	switch (property_id) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		case DCONF_WINDOW_CURRENT_PATH:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		dconf_window_set_current_path (self, g_value_get_string (value));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2675 "dconf-window.c"
		default:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2681 "dconf-window.c"
	}
}


static void path_element_base_init (PathElementIface * iface) {
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	static gboolean initialized = FALSE;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!initialized) {
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		initialized = TRUE;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_signal_new ("request_path", TYPE_PATH_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 2695 "dconf-window.c"
	}
}


GType path_element_get_type (void) {
	static volatile gsize path_element_type_id__volatile = 0;
	if (g_once_init_enter (&path_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PathElementIface), (GBaseInitFunc) path_element_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType path_element_type_id;
		path_element_type_id = g_type_register_static (G_TYPE_INTERFACE, "PathElement", &g_define_type_info, 0);
		g_once_init_leave (&path_element_type_id__volatile, path_element_type_id);
	}
	return path_element_type_id__volatile;
}



