/* print-dialog.c generated by valac 0.34.0.4-5c9b2, the Vala compiler
 * generated from print-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libsudoku.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _PrintDialogPrivate PrintDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrintDialog {
	GtkDialog parent_instance;
	PrintDialogPrivate * priv;
};

struct _PrintDialogClass {
	GtkDialogClass parent_class;
};

struct _PrintDialogPrivate {
	SudokuSaver* saver;
	GSettings* settings;
	GtkButton* print_button;
	GtkBox* print_box;
	GtkSpinButton* n_sudokus_button;
	GtkRadioButton* easy_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* hard_radio_button;
	GtkRadioButton* very_hard_radio_button;
	GtkRevealer* revealer;
	GtkSpinner* spinner;
	GCancellable* cancellable;
};

struct _Block4Data {
	int _ref_count_;
	PrintDialog* self;
	gchar* key_name;
	GtkAdjustment* action;
};


static gpointer print_dialog_parent_class = NULL;

GType print_dialog_get_type (void) G_GNUC_CONST;
#define PRINT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_DIALOG, PrintDialogPrivate))
enum  {
	PRINT_DIALOG_DUMMY_PROPERTY
};
#define PRINT_DIALOG_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda23_ (PrintDialog* self, gint response_id);
static void ___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void print_dialog_wrap_adjustment (PrintDialog* self, const gchar* key_name, GtkAdjustment* action);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda24_ (Block4Data* _data4_);
static void ___lambda24__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
gboolean print_dialog_start_spinner_cb (PrintDialog* self);
static void print_dialog_real_response (GtkDialog* base, gint response);
static void __lambda22_ (PrintDialog* self, GObject* obj, GAsyncResult* res);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void print_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 126 "print-dialog.c"
}


static void __lambda23_ (PrintDialog* self, gint response_id) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = response_id;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp1_ == ((gint) GTK_RESPONSE_CANCEL)) {
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp0_ = TRUE;
#line 139 "print-dialog.c"
	} else {
		gint _tmp2_ = 0;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp2_ = response_id;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp0_ = _tmp2_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 146 "print-dialog.c"
	}
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp0_) {
#line 150 "print-dialog.c"
		GCancellable* _tmp3_ = NULL;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp3_ = self->priv->cancellable;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_cancellable_cancel (_tmp3_);
#line 156 "print-dialog.c"
	}
}


static void ___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	__lambda23_ ((PrintDialog*) self, response_id);
#line 164 "print-dialog.c"
}


PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window) {
	PrintDialog * self = NULL;
	SudokuSaver* _tmp0_ = NULL;
	SudokuSaver* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GtkSpinner* _tmp4_ = NULL;
	GtkRevealer* _tmp5_ = NULL;
	GtkRevealer* _tmp6_ = NULL;
	GtkSpinner* _tmp7_ = NULL;
	GtkRevealer* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkRevealer* _tmp10_ = NULL;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	DifficultyCategory _tmp13_ = 0;
	GtkSpinButton* _tmp21_ = NULL;
	GtkAdjustment* _tmp22_ = NULL;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_val_if_fail (saver != NULL, NULL);
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = (PrintDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = saver;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->saver);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->saver = _tmp1_;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = g_settings_new ("org.gnome.sudoku");
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->settings = _tmp2_;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda23__gtk_dialog_response, self, 0);
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = window;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp3_);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp4_ = (GtkSpinner*) gtk_spinner_new ();
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_ref_sink (_tmp4_);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->spinner);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->spinner = _tmp4_;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp5_ = (GtkRevealer*) gtk_revealer_new ();
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_ref_sink (_tmp5_);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->revealer);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->revealer = _tmp5_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp6_ = self->priv->revealer;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp7_ = self->priv->spinner;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp8_ = self->priv->revealer;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp9_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp10_ = self->priv->revealer;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_header_bar_pack_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_header_bar_get_type (), GtkHeaderBar), (GtkWidget*) _tmp10_);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp11_ = self->priv->settings;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp12_ = g_settings_get_enum (_tmp11_, PRINT_DIALOG_DIFFICULTY_KEY_NAME);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	saved_difficulty = (DifficultyCategory) _tmp12_;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp13_ = saved_difficulty;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp13_ == DIFFICULTY_CATEGORY_EASY) {
#line 255 "print-dialog.c"
		GtkRadioButton* _tmp14_ = NULL;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp14_ = self->priv->easy_radio_button;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
#line 261 "print-dialog.c"
	} else {
		DifficultyCategory _tmp15_ = 0;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp15_ = saved_difficulty;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (_tmp15_ == DIFFICULTY_CATEGORY_MEDIUM) {
#line 268 "print-dialog.c"
			GtkRadioButton* _tmp16_ = NULL;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp16_ = self->priv->medium_radio_button;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp16_, TRUE);
#line 274 "print-dialog.c"
		} else {
			DifficultyCategory _tmp17_ = 0;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp17_ = saved_difficulty;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_tmp17_ == DIFFICULTY_CATEGORY_HARD) {
#line 281 "print-dialog.c"
				GtkRadioButton* _tmp18_ = NULL;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp18_ = self->priv->hard_radio_button;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp18_, TRUE);
#line 287 "print-dialog.c"
			} else {
				DifficultyCategory _tmp19_ = 0;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp19_ = saved_difficulty;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				if (_tmp19_ == DIFFICULTY_CATEGORY_VERY_HARD) {
#line 294 "print-dialog.c"
					GtkRadioButton* _tmp20_ = NULL;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp20_ = self->priv->very_hard_radio_button;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, TRUE);
#line 300 "print-dialog.c"
				} else {
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					g_assert_not_reached ();
#line 304 "print-dialog.c"
				}
			}
		}
	}
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp21_ = self->priv->n_sudokus_button;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp22_ = gtk_spin_button_get_adjustment (_tmp21_);
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	print_dialog_wrap_adjustment (self, "print-multiple-sudokus-to-print", _tmp22_);
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return self;
#line 317 "print-dialog.c"
}


PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window) {
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return print_dialog_construct (TYPE_PRINT_DIALOG, saver, window);
#line 324 "print-dialog.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return _data4_;
#line 333 "print-dialog.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 342 "print-dialog.c"
		PrintDialog* self;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		self = _data4_->self;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_free0 (_data4_->key_name);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (_data4_->action);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (self);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_slice_free (Block4Data, _data4_);
#line 354 "print-dialog.c"
	}
}


static void __lambda24_ (Block4Data* _data4_) {
	PrintDialog* self;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = _data4_->self;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = self->priv->settings;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = _data4_->key_name;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = _data4_->action;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_settings_set_int (_tmp0_, _tmp1_, (gint) _tmp3_);
#line 377 "print-dialog.c"
}


static void ___lambda24__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	__lambda24_ (self);
#line 384 "print-dialog.c"
}


static void print_dialog_wrap_adjustment (PrintDialog* self, const gchar* key_name, GtkAdjustment* action) {
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkAdjustment* _tmp8_ = NULL;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (key_name != NULL);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (action != NULL);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data4_->_ref_count_ = 1;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data4_->self = g_object_ref (self);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = key_name;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_free0 (_data4_->key_name);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data4_->key_name = _tmp1_;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = action;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (_data4_->action);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data4_->action = _tmp3_;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp4_ = _data4_->action;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp5_ = self->priv->settings;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp6_ = _data4_->key_name;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_adjustment_set_value (_tmp4_, (gdouble) _tmp7_);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp8_ = _data4_->action;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_signal_connect_data (_tmp8_, "value-changed", (GCallback) ___lambda24__gtk_adjustment_value_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	block4_data_unref (_data4_);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data4_ = NULL;
#line 445 "print-dialog.c"
}


gboolean print_dialog_start_spinner_cb (PrintDialog* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
	GtkRevealer* _tmp1_ = NULL;
	GtkSpinner* _tmp2_ = NULL;
	GtkRevealer* _tmp3_ = NULL;
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = self->priv->revealer;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_revealer_set_transition_type (_tmp0_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = self->priv->revealer;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = self->priv->spinner;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_spinner_start (_tmp2_);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = self->priv->revealer;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_revealer_set_reveal_child (_tmp3_, TRUE);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	result = G_SOURCE_REMOVE;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return result;
#line 477 "print-dialog.c"
}


static void __lambda22_ (PrintDialog* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (res != NULL);
#line 485 "print-dialog.c"
	{
		GeeList* boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkSpinner* _tmp2_ = NULL;
		GtkRevealer* _tmp3_ = NULL;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp4_ = NULL;
		SudokuPrinter* _tmp5_ = NULL;
		GtkPrintOperationResult _tmp6_ = 0;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp0_ = res;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		boards = _tmp1_;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 506 "print-dialog.c"
				goto __catch4_g_thread_error;
			}
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 511 "print-dialog.c"
				goto __catch4_g_io_error;
			}
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			return;
#line 520 "print-dialog.c"
		}
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp2_ = self->priv->spinner;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_spinner_stop (_tmp2_);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp3_ = self->priv->revealer;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp4_ = sudoku_printer_new (boards, (GtkWindow*) self);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		printer = _tmp4_;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp5_ = printer;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp6_ = sudoku_printer_print_sudoku (_tmp5_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (_tmp6_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
#line 540 "print-dialog.c"
			{
				GeeList* _board_list = NULL;
				GeeList* _tmp7_ = NULL;
				gint _board_size = 0;
				GeeList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _board_index = 0;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp7_ = _g_object_ref0 (boards);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_board_list = _tmp7_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp8_ = _board_list;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp10_ = _tmp9_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_board_size = _tmp10_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_board_index = -1;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				while (TRUE) {
#line 565 "print-dialog.c"
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					SudokuBoard* board = NULL;
					GeeList* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gpointer _tmp16_ = NULL;
					SudokuSaver* _tmp17_ = NULL;
					SudokuBoard* _tmp18_ = NULL;
					SudokuGame* _tmp19_ = NULL;
					SudokuGame* _tmp20_ = NULL;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp11_ = _board_index;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_board_index = _tmp11_ + 1;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp12_ = _board_index;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp13_ = _board_size;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					if (!(_tmp12_ < _tmp13_)) {
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
						break;
#line 589 "print-dialog.c"
					}
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp14_ = _board_list;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp15_ = _board_index;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					board = (SudokuBoard*) _tmp16_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp17_ = self->priv->saver;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp18_ = board;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp19_ = sudoku_game_new (_tmp18_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp20_ = _tmp19_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					sudoku_saver_add_game_to_finished (_tmp17_, _tmp20_, FALSE);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_g_object_unref0 (_tmp20_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_g_object_unref0 (board);
#line 613 "print-dialog.c"
				}
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_g_object_unref0 (_board_list);
#line 617 "print-dialog.c"
			}
		}
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (printer);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (boards);
#line 624 "print-dialog.c"
	}
	goto __finally4;
	__catch4_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp21_ = NULL;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		e = _inner_error_;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_inner_error_ = NULL;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp21_ = e->message;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_error ("print-dialog.vala:147: Thread error: %s\n", _tmp21_);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_error_free0 (e);
#line 641 "print-dialog.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp22_ = NULL;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		e = _inner_error_;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_inner_error_ = NULL;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp22_ = e;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (!g_error_matches (_tmp22_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 656 "print-dialog.c"
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp23_ = e;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp24_ = _tmp23_->message;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			g_warning ("print-dialog.vala:152: Error: %s\n", _tmp24_);
#line 665 "print-dialog.c"
		}
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_error_free0 (e);
#line 669 "print-dialog.c"
	}
	__finally4:
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_clear_error (&_inner_error_);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		return;
#line 680 "print-dialog.c"
	}
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 684 "print-dialog.c"
}


static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	__lambda22_ ((PrintDialog*) self, source_object, res);
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_unref (self);
#line 693 "print-dialog.c"
}


static void print_dialog_real_response (GtkDialog* base, gint response) {
	PrintDialog * self;
	gint _tmp0_ = 0;
	gint nsudokus = 0;
	GtkSpinButton* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	DifficultyCategory level = 0;
	GtkRadioButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp12_ = NULL;
	DifficultyCategory _tmp13_ = 0;
	GtkButton* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GCancellable* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	DifficultyCategory _tmp18_ = 0;
	GCancellable* _tmp19_ = NULL;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = (PrintDialog*) base;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = response;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_widget_destroy ((GtkWidget*) self);
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		return;
#line 725 "print-dialog.c"
	}
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = self->priv->n_sudokus_button;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = gtk_spin_button_get_adjustment (_tmp1_);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	nsudokus = (gint) _tmp3_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp4_ = self->priv->easy_radio_button;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp5_) {
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		level = DIFFICULTY_CATEGORY_EASY;
#line 743 "print-dialog.c"
	} else {
		GtkRadioButton* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp6_ = self->priv->medium_radio_button;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (_tmp7_) {
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			level = DIFFICULTY_CATEGORY_MEDIUM;
#line 755 "print-dialog.c"
		} else {
			GtkRadioButton* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp8_ = self->priv->hard_radio_button;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp9_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_tmp9_) {
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				level = DIFFICULTY_CATEGORY_HARD;
#line 767 "print-dialog.c"
			} else {
				GtkRadioButton* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp10_ = self->priv->very_hard_radio_button;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp11_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp10_);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				if (_tmp11_) {
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					level = DIFFICULTY_CATEGORY_VERY_HARD;
#line 779 "print-dialog.c"
				} else {
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					g_assert_not_reached ();
#line 783 "print-dialog.c"
				}
			}
		}
	}
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp12_ = self->priv->settings;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp13_ = level;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_settings_set_enum (_tmp12_, PRINT_DIALOG_DIFFICULTY_KEY_NAME, (gint) _tmp13_);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, (GSourceFunc) print_dialog_start_spinner_cb, g_object_ref (self), NULL);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp14_ = self->priv->print_button;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp15_ = self->priv->print_box;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp16_ = g_cancellable_new ();
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->cancellable = _tmp16_;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp17_ = nsudokus;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp18_ = level;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp19_ = self->priv->cancellable;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	sudoku_generator_generate_boards_async (_tmp17_, _tmp18_, _tmp19_, ___lambda22__gasync_ready_callback, g_object_ref (self));
#line 818 "print-dialog.c"
}


static void print_dialog_class_init (PrintDialogClass * klass) {
	gint PrintDialog_private_offset;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	print_dialog_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_type_class_add_private (klass, sizeof (PrintDialogPrivate));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	((GtkDialogClass *) klass)->response = print_dialog_real_response;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = print_dialog_finalize;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	PrintDialog_private_offset = g_type_class_get_instance_private_offset (klass);
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/sudoku/ui/print-dialog.ui");
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_button));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_box", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_box));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_sudokus_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_sudokus_button));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "easy_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, easy_radio_button));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, medium_radio_button));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, hard_radio_button));
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "very_hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, very_hard_radio_button));
#line 850 "print-dialog.c"
}


static void print_dialog_instance_init (PrintDialog * self) {
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv = PRINT_DIALOG_GET_PRIVATE (self);
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 859 "print-dialog.c"
}


static void print_dialog_finalize (GObject* obj) {
	PrintDialog * self;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_DIALOG, PrintDialog);
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->saver);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->print_button);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->print_box);
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->n_sudokus_button);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->easy_radio_button);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->medium_radio_button);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->hard_radio_button);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->very_hard_radio_button);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->revealer);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->spinner);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	G_OBJECT_CLASS (print_dialog_parent_class)->finalize (obj);
#line 893 "print-dialog.c"
}


GType print_dialog_get_type (void) {
	static volatile gsize print_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&print_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrintDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintDialog), 0, (GInstanceInitFunc) print_dialog_instance_init, NULL };
		GType print_dialog_type_id;
		print_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PrintDialog", &g_define_type_info, 0);
		g_once_init_leave (&print_dialog_type_id__volatile, print_dialog_type_id);
	}
	return print_dialog_type_id__volatile;
}



