/* rygel-media-export-query-container-factory.c generated by valac 0.32.1, the Vala compiler
 * generated from rygel-media-export-query-container-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;
typedef struct _RygelMediaExportQueryContainerFactoryPrivate RygelMediaExportQueryContainerFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER (rygel_media_export_leaf_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainer))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))

typedef struct _RygelMediaExportLeafQueryContainer RygelMediaExportLeafQueryContainer;
typedef struct _RygelMediaExportLeafQueryContainerClass RygelMediaExportLeafQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER (rygel_media_export_node_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainer))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))

typedef struct _RygelMediaExportNodeQueryContainer RygelMediaExportNodeQueryContainer;
typedef struct _RygelMediaExportNodeQueryContainerClass RygelMediaExportNodeQueryContainerClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

struct _RygelMediaExportQueryContainerFactory {
	GObject parent_instance;
	RygelMediaExportQueryContainerFactoryPrivate * priv;
};

struct _RygelMediaExportQueryContainerFactoryClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportQueryContainerFactoryPrivate {
	GeeHashMap* virtual_container_map;
};


static gpointer rygel_media_export_query_container_factory_parent_class = NULL;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance = NULL;

GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_DUMMY_PROPERTY
};
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type);
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self, gchar** id);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self, const gchar* definition_id, const gchar* name);
static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (const gchar* description, gchar** pattern, gchar** attribute, gchar** upnp_class, gchar** name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_new (RygelSearchExpression* expression, const gchar* id, const gchar* name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_construct (GType object_type, RygelSearchExpression* expression, const gchar* id, const gchar* name);
GType rygel_media_export_leaf_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_new (RygelSearchExpression* expression, const gchar* id, const gchar* name, const gchar* template, const gchar* attribute);
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_construct (GType object_type, RygelSearchExpression* expression, const gchar* id, const gchar* name, const gchar* template, const gchar* attribute);
GType rygel_media_export_node_query_container_get_type (void) G_GNUC_CONST;
static gchar* rygel_media_export_query_container_factory_map_upnp_class (const gchar* attribute);
static void rygel_media_export_query_container_factory_update_search_expression (RygelSearchExpression** expression, const gchar* key, const gchar* value);
static void rygel_media_export_query_container_factory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void) {
	RygelMediaExportQueryContainerFactory* result = NULL;
	RygelMediaExportQueryContainerFactory* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelMediaExportQueryContainerFactory* _tmp3_ = NULL;
	RygelMediaExportQueryContainerFactory* _tmp4_ = NULL;
	_tmp0_ = rygel_media_export_query_container_factory_instance;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		RygelMediaExportQueryContainerFactory* _tmp2_ = NULL;
		_tmp2_ = rygel_media_export_query_container_factory_new ();
		_g_object_unref0 (rygel_media_export_query_container_factory_instance);
		rygel_media_export_query_container_factory_instance = _tmp2_;
	}
	_tmp3_ = rygel_media_export_query_container_factory_instance;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type) {
	RygelMediaExportQueryContainerFactory * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	self = (RygelMediaExportQueryContainerFactory*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->virtual_container_map);
	self->priv->virtual_container_map = _tmp0_;
	return self;
}


static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void) {
	return rygel_media_export_query_container_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY);
}


/**
     * Register a plaintext description for a query container. The passed
     * string will be modified to the checksum id of the container.
     *
     * @param id Originally contains the plaintext id which is replaced with
     *           the hashed id on return.
     */
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self, gchar** id) {
	gchar* md5 = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*id != NULL);
	_tmp0_ = *id;
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) -1);
	md5 = _tmp1_;
	_tmp2_ = self->priv->virtual_container_map;
	_tmp3_ = md5;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (!_tmp4_) {
		GeeHashMap* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp5_ = self->priv->virtual_container_map;
		_tmp6_ = md5;
		_tmp7_ = *id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, _tmp7_);
		_tmp8_ = md5;
		_tmp9_ = *id;
		g_debug ("rygel-media-export-query-container-factory.vala:61: Registering %s for" \
" %s", _tmp8_, _tmp9_);
	}
	_tmp10_ = md5;
	_tmp11_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp10_, NULL);
	_g_free0 (*id);
	*id = _tmp11_;
	_g_free0 (md5);
}


/**
     * Get the plaintext definition from a hashed id.
     *
     * Inverse function of register_id().
     *
     * @param hash A hashed id
     * @return the plaintext defintion of the virtual folder
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally45;
	__catch45_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally45:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash) {
	gchar* result = NULL;
	gchar* id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash != NULL, NULL);
	_tmp0_ = hash;
	_tmp1_ = string_replace (_tmp0_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	id = _tmp1_;
	_tmp2_ = self->priv->virtual_container_map;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, id);
	result = (gchar*) _tmp3_;
	_g_free0 (id);
	return result;
}


/**
     * Factory method.
     *
     * Create a QueryContainer directly from MD5 hashed id.
     *
     * @param id    The hashed id of the container
     * @param name  An the title of the container. If not supplied, it will
     *              be derived from the plain-text description of the
     *              container
     * @return A new instance of QueryContainer or null if id does not exist
     */
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self, const gchar* id, const gchar* name) {
	RygelMediaExportQueryContainer* result = NULL;
	gchar* definition_id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelMediaExportQueryContainer* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = rygel_media_export_query_container_factory_get_virtual_container_definition (self, _tmp0_);
	definition_id = _tmp1_;
	_tmp2_ = definition_id;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_free0 (definition_id);
		return result;
	}
	_tmp3_ = definition_id;
	_tmp4_ = name;
	_tmp5_ = rygel_media_export_query_container_factory_create_from_description_id (self, _tmp3_, _tmp4_);
	result = _tmp5_;
	_g_free0 (definition_id);
	return result;
}


/**
     * Factory method.
     *
     * Create a QueryContainer from a plain-text description string.
     *
     * @param definition Plain-text defintion of the query-container
     * @param name       The title of the container. If not supplied, it
     *                   will be derived from the plain-text description of
     *                   the container
     * @return A new instance of QueryContainer
     */
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self, const gchar* definition_id, const gchar* name) {
	RygelMediaExportQueryContainer* result = NULL;
	gchar* title = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* attribute = NULL;
	gchar* pattern = NULL;
	gchar* upnp_class = NULL;
	RygelMediaExportQueryContainer* container = NULL;
	gchar* id = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* expression = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	RygelSearchExpression* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (definition_id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	attribute = NULL;
	pattern = NULL;
	upnp_class = NULL;
	_tmp2_ = definition_id;
	_tmp3_ = g_strdup (_tmp2_);
	id = _tmp3_;
	rygel_media_export_query_container_factory_register_id (self, &id);
	_tmp4_ = definition_id;
	_tmp8_ = rygel_media_export_query_container_factory_parse_description (_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &title);
	_g_free0 (pattern);
	pattern = _tmp5_;
	_g_free0 (attribute);
	attribute = _tmp6_;
	_g_free0 (upnp_class);
	upnp_class = _tmp7_;
	expression = _tmp8_;
	_tmp10_ = pattern;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = pattern;
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
	}
	if (_tmp9_) {
		RygelSearchExpression* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		RygelMediaExportLeafQueryContainer* _tmp15_ = NULL;
		_tmp12_ = expression;
		_tmp13_ = id;
		_tmp14_ = title;
		_tmp15_ = rygel_media_export_leaf_query_container_new (_tmp12_, _tmp13_, _tmp14_);
		_g_object_unref0 (container);
		container = (RygelMediaExportQueryContainer*) _tmp15_;
	} else {
		RygelSearchExpression* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		RygelMediaExportNodeQueryContainer* _tmp21_ = NULL;
		_tmp16_ = expression;
		_tmp17_ = id;
		_tmp18_ = title;
		_tmp19_ = pattern;
		_tmp20_ = attribute;
		_tmp21_ = rygel_media_export_node_query_container_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
		_g_object_unref0 (container);
		container = (RygelMediaExportQueryContainer*) _tmp21_;
	}
	_tmp22_ = upnp_class;
	if (_tmp22_ != NULL) {
		RygelMediaExportQueryContainer* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp23_ = container;
		_tmp24_ = upnp_class;
		rygel_media_object_set_upnp_class ((RygelMediaObject*) _tmp23_, _tmp24_);
		_tmp25_ = upnp_class;
		if (g_strcmp0 (_tmp25_, RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM) == 0) {
			RygelMediaExportQueryContainer* _tmp26_ = NULL;
			_tmp26_ = container;
			rygel_media_container_set_sort_criteria ((RygelMediaContainer*) _tmp26_, RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA);
		}
	}
	result = container;
	_rygel_search_expression_unref0 (expression);
	_g_free0 (id);
	_g_free0 (upnp_class);
	_g_free0 (pattern);
	_g_free0 (attribute);
	_g_free0 (title);
	return result;
}


/**
     * Map a DIDL attribute to a UPnP container class.
     *
     * @return A matching UPnP class for the attribute or null if it can't be
     *         mapped.
     */
static gchar* rygel_media_export_query_container_factory_map_upnp_class (const gchar* attribute) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	g_return_val_if_fail (attribute != NULL, NULL);
	_tmp0_ = attribute;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM);
				result = _tmp4_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("dc:creator")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("upnp:artist"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST);
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("dc:genre")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_GENRE);
				result = _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


/**
     * Parse a plaintext container description into a search expression.
     *
     * Also generates a name for the container and other meta-data necessary
     * for node containers.
     *
     * @param description The plaintext container description
     * @param pattern     Contains the pattern used for child containers if
     *                    descrption is for a node container, null otherwise.
     * @param attribute   Contains the UPnP attribute the container describes.
     * @param name        If passed empty, name will be generated from the
     *                    description.
     * @return A SearchExpression corresponding to the non-variable part of
     *         the description.
     */
static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (const gchar* description, gchar** pattern, gchar** attribute, gchar** upnp_class, gchar** name) {
	gchar* _vala_pattern = NULL;
	gchar* _vala_attribute = NULL;
	gchar* _vala_upnp_class = NULL;
	RygelSearchExpression* result = NULL;
	gchar** args = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	RygelSearchExpression* expression = NULL;
	gpointer _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	gint i = 0;
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (*name != NULL, NULL);
	_tmp0_ = description;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
	args = _tmp2_;
	args_length1 = _vala_array_length (_tmp1_);
	_args_size_ = args_length1;
	_tmp3_ = NULL;
	_tmp4_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_SEARCH_EXPRESSION) ? ((RygelSearchExpression*) _tmp3_) : NULL);
	expression = _tmp4_;
	_g_free0 (_vala_pattern);
	_vala_pattern = NULL;
	_g_free0 (_vala_attribute);
	_vala_attribute = NULL;
	_g_free0 (_vala_upnp_class);
	_vala_upnp_class = NULL;
	i = 0;
	while (TRUE) {
		gint _tmp5_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* previous_attribute = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp16_ = 0;
		const gchar* _tmp17_ = NULL;
		gint _tmp43_ = 0;
		_tmp5_ = i;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		if (!(_tmp5_ < _tmp6__length1)) {
			break;
		}
		_tmp7_ = _vala_attribute;
		_tmp8_ = g_strdup (_tmp7_);
		previous_attribute = _tmp8_;
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = i;
		_tmp11_ = _tmp9_[_tmp10_];
		_tmp12_ = string_replace (_tmp11_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
		_g_free0 (_vala_attribute);
		_vala_attribute = _tmp12_;
		_tmp13_ = _vala_attribute;
		_tmp14_ = g_uri_unescape_string (_tmp13_, NULL);
		_g_free0 (_vala_attribute);
		_vala_attribute = _tmp14_;
		_tmp15_ = args;
		_tmp15__length1 = args_length1;
		_tmp16_ = i;
		_tmp17_ = _tmp15_[_tmp16_ + 1];
		if (g_strcmp0 (_tmp17_, "?") != 0) {
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint _tmp19_ = 0;
			const gchar* _tmp20_ = NULL;
			gchar** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp22_ = 0;
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gchar** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			_tmp18_ = args;
			_tmp18__length1 = args_length1;
			_tmp19_ = i;
			_tmp20_ = _tmp18_[_tmp19_];
			_tmp21_ = args;
			_tmp21__length1 = args_length1;
			_tmp22_ = i;
			_tmp23_ = _tmp21_[_tmp22_ + 1];
			rygel_media_export_query_container_factory_update_search_expression (&expression, _tmp20_, _tmp23_);
			_tmp24_ = i;
			_tmp25_ = args;
			_tmp25__length1 = args_length1;
			if ((_tmp24_ + 2) == _tmp25__length1) {
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				_tmp26_ = _vala_attribute;
				_tmp27_ = rygel_media_export_query_container_factory_map_upnp_class (_tmp26_);
				_g_free0 (_vala_upnp_class);
				_vala_upnp_class = _tmp27_;
			}
		} else {
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			gint _tmp29_ = 0;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp37_ = NULL;
			_tmp28_ = args;
			_tmp28__length1 = args_length1;
			_tmp29_ = i;
			_tmp30_ = g_strdup ("%s");
			_g_free0 (_tmp28_[_tmp29_ + 1]);
			_tmp28_[_tmp29_ + 1] = _tmp30_;
			_tmp31_ = _tmp28_[_tmp29_ + 1];
			_tmp32_ = args;
			_tmp32__length1 = args_length1;
			_tmp33_ = _vala_g_strjoinv (",", _tmp32_, _tmp32__length1);
			_g_free0 (_vala_pattern);
			_vala_pattern = _tmp33_;
			_tmp34_ = previous_attribute;
			_tmp35_ = rygel_media_export_query_container_factory_map_upnp_class (_tmp34_);
			_g_free0 (_vala_upnp_class);
			_vala_upnp_class = _tmp35_;
			_tmp37_ = *name;
			if (g_strcmp0 (_tmp37_, "") == 0) {
				gint _tmp38_ = 0;
				_tmp38_ = i;
				_tmp36_ = _tmp38_ > 0;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gint _tmp40_ = 0;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				_tmp39_ = args;
				_tmp39__length1 = args_length1;
				_tmp40_ = i;
				_tmp41_ = _tmp39_[_tmp40_ - 1];
				_tmp42_ = g_uri_unescape_string (_tmp41_, NULL);
				_g_free0 (*name);
				*name = _tmp42_;
			}
			_g_free0 (previous_attribute);
			break;
		}
		_tmp43_ = i;
		i = _tmp43_ + 2;
		_g_free0 (previous_attribute);
	}
	result = expression;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	if (pattern) {
		*pattern = _vala_pattern;
	} else {
		_g_free0 (_vala_pattern);
	}
	if (attribute) {
		*attribute = _vala_attribute;
	} else {
		_g_free0 (_vala_attribute);
	}
	if (upnp_class) {
		*upnp_class = _vala_upnp_class;
	} else {
		_g_free0 (_vala_upnp_class);
	}
	return result;
}


/**
     * Update a SearchExpression with a new key = value condition.
     *
     * Will modifiy the passed expression to (expression AND (key = value))
     *
     * @param expression The expression to update or null to create a new one
     * @param key        Key of the key/value condition
     * @param value      Value of the key/value condition
     */
static void rygel_media_export_query_container_factory_update_search_expression (RygelSearchExpression** expression, const gchar* key, const gchar* value) {
	RygelRelationalExpression* subexpression = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gchar* clean_key = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelRelationalExpression* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	RygelRelationalExpression* _tmp6_ = NULL;
	RygelRelationalExpression* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelSearchExpression* _tmp10_ = NULL;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_relational_expression_new ();
	subexpression = _tmp0_;
	_tmp1_ = key;
	_tmp2_ = string_replace (_tmp1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	clean_key = _tmp2_;
	_tmp3_ = subexpression;
	_tmp4_ = clean_key;
	_tmp5_ = g_uri_unescape_string (_tmp4_, NULL);
	_g_free0 (((RygelSearchExpression*) _tmp3_)->operand1);
	((RygelSearchExpression*) _tmp3_)->operand1 = _tmp5_;
	_tmp6_ = subexpression;
	((RygelSearchExpression*) _tmp6_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_tmp7_ = subexpression;
	_tmp8_ = value;
	_tmp9_ = g_uri_unescape_string (_tmp8_, NULL);
	_g_free0 (((RygelSearchExpression*) _tmp7_)->operand2);
	((RygelSearchExpression*) _tmp7_)->operand2 = _tmp9_;
	_tmp10_ = *expression;
	if (_tmp10_ != NULL) {
		RygelLogicalExpression* conjunction = NULL;
		RygelLogicalExpression* _tmp11_ = NULL;
		RygelLogicalExpression* _tmp12_ = NULL;
		RygelSearchExpression* _tmp13_ = NULL;
		RygelSearchExpression* _tmp14_ = NULL;
		RygelLogicalExpression* _tmp15_ = NULL;
		RygelRelationalExpression* _tmp16_ = NULL;
		RygelSearchExpression* _tmp17_ = NULL;
		RygelLogicalExpression* _tmp18_ = NULL;
		RygelLogicalExpression* _tmp19_ = NULL;
		RygelSearchExpression* _tmp20_ = NULL;
		_tmp11_ = rygel_logical_expression_new ();
		conjunction = _tmp11_;
		_tmp12_ = conjunction;
		_tmp13_ = *expression;
		_tmp14_ = _rygel_search_expression_ref0 (_tmp13_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp12_)->operand1);
		((RygelSearchExpression*) _tmp12_)->operand1 = _tmp14_;
		_tmp15_ = conjunction;
		_tmp16_ = subexpression;
		_tmp17_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp16_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp15_)->operand2);
		((RygelSearchExpression*) _tmp15_)->operand2 = _tmp17_;
		_tmp18_ = conjunction;
		((RygelSearchExpression*) _tmp18_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
		_tmp19_ = conjunction;
		_tmp20_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp19_);
		_rygel_search_expression_unref0 (*expression);
		*expression = _tmp20_;
		_rygel_search_expression_unref0 (conjunction);
	} else {
		RygelRelationalExpression* _tmp21_ = NULL;
		RygelSearchExpression* _tmp22_ = NULL;
		_tmp21_ = subexpression;
		_tmp22_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp21_);
		_rygel_search_expression_unref0 (*expression);
		*expression = _tmp22_;
	}
	_g_free0 (clean_key);
	_rygel_search_expression_unref0 (subexpression);
}


static void rygel_media_export_query_container_factory_class_init (RygelMediaExportQueryContainerFactoryClass * klass) {
	rygel_media_export_query_container_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_factory_finalize;
}


static void rygel_media_export_query_container_factory_instance_init (RygelMediaExportQueryContainerFactory * self) {
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE (self);
}


static void rygel_media_export_query_container_factory_finalize (GObject* obj) {
	RygelMediaExportQueryContainerFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory);
	_g_object_unref0 (self->priv->virtual_container_map);
	G_OBJECT_CLASS (rygel_media_export_query_container_factory_parent_class)->finalize (obj);
}


/**
 * A helper class to create QueryContainer instances based on IDs.
 */
GType rygel_media_export_query_container_factory_get_type (void) {
	static volatile gsize rygel_media_export_query_container_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainerFactory), 0, (GInstanceInitFunc) rygel_media_export_query_container_factory_instance_init, NULL };
		GType rygel_media_export_query_container_factory_type_id;
		rygel_media_export_query_container_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportQueryContainerFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_factory_type_id__volatile, rygel_media_export_query_container_factory_type_id);
	}
	return rygel_media_export_query_container_factory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



