/* rygel-v1-hacks.c generated by valac 0.32.1, the Vala compiler
 * generated from rygel-v1-hacks.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 * Copyright (C) 2012 Jens Georg.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_V1_HACKS (rygel_v1_hacks_get_type ())
#define RYGEL_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_V1_HACKS, RygelV1Hacks))
#define RYGEL_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))
#define RYGEL_IS_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_V1_HACKS))
#define RYGEL_IS_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_V1_HACKS))
#define RYGEL_V1_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))

typedef struct _RygelV1Hacks RygelV1Hacks;
typedef struct _RygelV1HacksClass RygelV1HacksClass;
typedef struct _RygelV1HacksPrivate RygelV1HacksPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;

struct _RygelV1Hacks {
	GObject parent_instance;
	RygelV1HacksPrivate * priv;
	gchar* description_path;
};

struct _RygelV1HacksClass {
	GObjectClass parent_class;
};

struct _RygelV1HacksPrivate {
	gchar* _device_type;
	gchar* device_type_v1;
	gchar** _service_types;
	gint _service_types_length1;
	gint __service_types_size_;
	GRegex* agent_regex;
	GRegex* service_type_regex;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};


static gpointer rygel_v1_hacks_parent_class = NULL;
static gchar* rygel_v1_hacks_agent_pattern;
static gchar* rygel_v1_hacks_agent_pattern = NULL;

GType rygel_v1_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_V1_HACKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_V1_HACKS, RygelV1HacksPrivate))
enum  {
	RYGEL_V1_HACKS_DUMMY_PROPERTY,
	RYGEL_V1_HACKS_DEVICE_TYPE,
	RYGEL_V1_HACKS_SERVICE_TYPES
};
#define RYGEL_V1_HACKS_MATCHING_PATTERN ".*%s.*"
#define RYGEL_V1_HACKS_SERVICE_TYPE_PATTERN ":[0-9]+$"
static gchar* rygel_v1_hacks_generate_agent_pattern (void);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static const gchar** _vala_array_dup2 (const gchar** self, int length);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_configuration_get_string_list (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value);
RygelV1Hacks* rygel_v1_hacks_new (const gchar* device_type, gchar** service_types, int service_types_length1);
RygelV1Hacks* rygel_v1_hacks_construct (GType object_type, const gchar* device_type, gchar** service_types, int service_types_length1);
static void rygel_v1_hacks_real_constructed (GObject* base);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
void rygel_v1_hacks_apply_on_device (RygelV1Hacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
const gchar* rygel_v1_hacks_get_device_type (RygelV1Hacks* self);
GType rygel_description_file_get_type (void) G_GNUC_CONST;
RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error);
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type);
gchar** rygel_v1_hacks_get_service_types (RygelV1Hacks* self, int* result_length1);
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
void rygel_v1_hacks_set_device_type (RygelV1Hacks* self, const gchar* value);
static void rygel_v1_hacks_set_service_types (RygelV1Hacks* self, gchar** value, int value_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void rygel_v1_hacks_finalize (GObject* obj);
static void _vala_rygel_v1_hacks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_v1_hacks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_V1_HACKS_AGENTS[9] = {"Allegro-Software-WebClient", "SEC HHP", "SEC_HHP", "Mediabolic-IMHTTP/1.", "TwoPlayer", "Reciva", "FDSSDP", "Portable SDK for UPnP devices", "Darwin"};

/**
     * Read the user-agent snippets from the config file and generate the
     * regular expression string for matching.
     *
     * Returns: A regular expression pattern matching any of the configured
     *          user-agents.
     */
static const gchar** _vala_array_dup2 (const gchar** self, int length) {
	return g_memdup (self, length * sizeof (const gchar*));
}


static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gchar* rygel_v1_hacks_generate_agent_pattern (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp3_ = NULL;
	const gchar** raw_agents = NULL;
	const gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint raw_agents_length1 = 0;
	gint _raw_agents_size_ = 0;
	gchar** agents = NULL;
	gchar** _tmp12_ = NULL;
	gint agents_length1 = 0;
	gint _agents_size_ = 0;
	const gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_v1_hacks_agent_pattern;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = rygel_v1_hacks_agent_pattern;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = rygel_meta_config_get_default ();
	config = _tmp3_;
	_tmp4_ = (RYGEL_V1_HACKS_AGENTS != NULL) ? _vala_array_dup2 (RYGEL_V1_HACKS_AGENTS, G_N_ELEMENTS (RYGEL_V1_HACKS_AGENTS)) : ((gpointer) RYGEL_V1_HACKS_AGENTS);
	_tmp4__length1 = G_N_ELEMENTS (RYGEL_V1_HACKS_AGENTS);
	raw_agents = _tmp4_;
	raw_agents_length1 = _tmp4__length1;
	_raw_agents_size_ = raw_agents_length1;
	{
		GeeArrayList* _tmp5_ = NULL;
		RygelMetaConfig* _tmp6_ = NULL;
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		GeeArrayList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gpointer* _tmp11_ = NULL;
		_tmp6_ = config;
		_tmp7_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp6_, "general", "force-downgrade-for", &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch52_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_tmp9_ = _tmp8_;
		_tmp11_ = gee_collection_to_array ((GeeCollection*) _tmp9_, &_tmp10_);
		raw_agents = (g_free (raw_agents), NULL);
		raw_agents = _tmp11_;
		raw_agents_length1 = _tmp10_;
		_raw_agents_size_ = raw_agents_length1;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally52:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		raw_agents = (g_free (raw_agents), NULL);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp12_ = g_new0 (gchar*, 0 + 1);
	agents = _tmp12_;
	agents_length1 = 0;
	_agents_size_ = agents_length1;
	_tmp13_ = raw_agents;
	_tmp13__length1 = raw_agents_length1;
	{
		const gchar** agent_collection = NULL;
		gint agent_collection_length1 = 0;
		gint _agent_collection_size_ = 0;
		gint agent_it = 0;
		agent_collection = _tmp13_;
		agent_collection_length1 = _tmp13__length1;
		for (agent_it = 0; agent_it < _tmp13__length1; agent_it = agent_it + 1) {
			const gchar* agent = NULL;
			agent = agent_collection[agent_it];
			{
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp14_ = agents;
				_tmp14__length1 = agents_length1;
				_tmp15_ = agent;
				_tmp16_ = g_regex_escape_string (_tmp15_, -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf (RYGEL_V1_HACKS_MATCHING_PATTERN, _tmp17_);
				_vala_array_add13 (&agents, &agents_length1, &_agents_size_, _tmp18_);
				_g_free0 (_tmp17_);
			}
		}
	}
	_tmp19_ = agents;
	_tmp19__length1 = agents_length1;
	if (_tmp19__length1 > 0) {
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gchar* _tmp21_ = NULL;
		_tmp20_ = agents;
		_tmp20__length1 = agents_length1;
		_tmp21_ = _vala_g_strjoinv ("|", _tmp20_, _tmp20__length1);
		_g_free0 (rygel_v1_hacks_agent_pattern);
		rygel_v1_hacks_agent_pattern = _tmp21_;
	} else {
		gchar* _tmp22_ = NULL;
		_tmp22_ = g_strdup ("");
		_g_free0 (rygel_v1_hacks_agent_pattern);
		rygel_v1_hacks_agent_pattern = _tmp22_;
	}
	_tmp23_ = rygel_v1_hacks_agent_pattern;
	g_debug ("rygel-v1-hacks.vala:99: V1 downgrade will be applied for devices match" \
"ing %s", _tmp23_);
	_tmp24_ = rygel_v1_hacks_agent_pattern;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	agents = (_vala_array_free (agents, agents_length1, (GDestroyNotify) g_free), NULL);
	raw_agents = (g_free (raw_agents), NULL);
	_g_object_unref0 (config);
	return result;
}


RygelV1Hacks* rygel_v1_hacks_construct (GType object_type, const gchar* device_type, gchar** service_types, int service_types_length1) {
	RygelV1Hacks * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (device_type != NULL, NULL);
	_tmp0_ = device_type;
	_tmp1_ = service_types;
	_tmp1__length1 = service_types_length1;
	self = (RygelV1Hacks*) g_object_new (object_type, "device-type", _tmp0_, "service-types", _tmp1_, NULL);
	return self;
}


RygelV1Hacks* rygel_v1_hacks_new (const gchar* device_type, gchar** service_types, int service_types_length1) {
	return rygel_v1_hacks_construct (RYGEL_TYPE_V1_HACKS, device_type, service_types, service_types_length1);
}


static void rygel_v1_hacks_real_constructed (GObject* base) {
	RygelV1Hacks * self;
	GError * _inner_error_ = NULL;
	self = (RygelV1Hacks*) base;
	G_OBJECT_CLASS (rygel_v1_hacks_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		_tmp1_ = rygel_v1_hacks_generate_agent_pattern ();
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch53_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->agent_regex);
		self->priv->agent_regex = _tmp5_;
		_tmp7_ = g_regex_new (RYGEL_V1_HACKS_SERVICE_TYPE_PATTERN, 0, 0, &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch53_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_regex_unref0 (self->priv->service_type_regex);
		self->priv->service_type_regex = _tmp8_;
		_g_regex_unref0 (_tmp6_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally53:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch54_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch54_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally54;
	__catch54_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally54:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_v1_hacks_apply_on_device (RygelV1Hacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	RygelRootDevice* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	RygelDescriptionFile* description_file = NULL;
	const gchar* _tmp6_ = NULL;
	RygelDescriptionFile* _tmp7_ = NULL;
	RygelDescriptionFile* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	RygelDescriptionFile* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* server_path = NULL;
	RygelRootDevice* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GRegex* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp1_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _tmp0_);
	_tmp2_ = rygel_v1_hacks_get_device_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (_tmp1_, _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = template_path;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = template_path;
	_tmp7_ = rygel_description_file_new (_tmp6_, &_inner_error_);
	description_file = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp8_ = description_file;
	_tmp9_ = self->priv->device_type_v1;
	rygel_description_file_set_device_type (_tmp8_, _tmp9_);
	_tmp10_ = rygel_v1_hacks_get_service_types (self, &_tmp10__length1);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	{
		gchar** service_type_collection = NULL;
		gint service_type_collection_length1 = 0;
		gint _service_type_collection_size_ = 0;
		gint service_type_it = 0;
		service_type_collection = _tmp11_;
		service_type_collection_length1 = _tmp11__length1;
		for (service_type_it = 0; service_type_it < _tmp11__length1; service_type_it = service_type_it + 1) {
			gchar* _tmp12_ = NULL;
			gchar* service_type = NULL;
			_tmp12_ = g_strdup (service_type_collection[service_type_it]);
			service_type = _tmp12_;
			{
				gchar* service_type_v1 = NULL;
				GRegex* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				RygelDescriptionFile* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				_tmp13_ = self->priv->service_type_regex;
				_tmp14_ = service_type;
				_tmp15_ = g_regex_replace_literal (_tmp13_, _tmp14_, (gssize) -1, 0, ":1", 0, &_inner_error_);
				service_type_v1 = _tmp15_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (service_type);
					_g_object_unref0 (description_file);
					return;
				}
				_tmp16_ = description_file;
				_tmp17_ = service_type;
				_tmp18_ = service_type_v1;
				rygel_description_file_modify_service_type (_tmp16_, _tmp17_, _tmp18_);
				_g_free0 (service_type_v1);
				_g_free0 (service_type);
			}
		}
	}
	_tmp19_ = template_path;
	_tmp20_ = string_replace (_tmp19_, ".xml", "-v1.xml");
	_g_free0 (self->description_path);
	self->description_path = _tmp20_;
	_tmp21_ = description_file;
	_tmp22_ = self->description_path;
	rygel_description_file_save (_tmp21_, _tmp22_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (description_file);
		return;
	}
	_tmp23_ = device;
	_tmp24_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) _tmp23_);
	_tmp25_ = g_strconcat ("/", _tmp24_, NULL);
	server_path = _tmp25_;
	_tmp26_ = self->priv->agent_regex;
	_tmp27_ = g_regex_get_pattern (_tmp26_);
	if (g_strcmp0 (_tmp27_, "") != 0) {
		RygelRootDevice* _tmp28_ = NULL;
		GUPnPContext* _tmp29_ = NULL;
		GUPnPContext* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GRegex* _tmp33_ = NULL;
		_tmp28_ = device;
		_tmp29_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->description_path;
		_tmp32_ = server_path;
		_tmp33_ = self->priv->agent_regex;
		gupnp_context_host_path_for_agent (_tmp30_, _tmp31_, _tmp32_, _tmp33_);
	}
	_g_free0 (server_path);
	_g_object_unref0 (description_file);
}


const gchar* rygel_v1_hacks_get_device_type (RygelV1Hacks* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device_type;
	result = _tmp0_;
	return result;
}


void rygel_v1_hacks_set_device_type (RygelV1Hacks* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_device_type);
	self->priv->_device_type = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = g_strconcat (_tmp2_, ":1", NULL);
	_g_free0 (self->priv->device_type_v1);
	self->priv->device_type_v1 = _tmp3_;
	g_object_notify ((GObject *) self, "device-type");
}


gchar** rygel_v1_hacks_get_service_types (RygelV1Hacks* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service_types;
	_tmp0__length1 = self->priv->_service_types_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void rygel_v1_hacks_set_service_types (RygelV1Hacks* self, gchar** value, int value_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_service_types = (_vala_array_free (self->priv->_service_types, self->priv->_service_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_service_types = _tmp1_;
	self->priv->_service_types_length1 = _tmp1__length1;
	self->priv->__service_types_size_ = self->priv->_service_types_length1;
	g_object_notify ((GObject *) self, "service-types");
}


static void rygel_v1_hacks_class_init (RygelV1HacksClass * klass) {
	rygel_v1_hacks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelV1HacksPrivate));
	((GObjectClass *) klass)->constructed = rygel_v1_hacks_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_v1_hacks_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_v1_hacks_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_v1_hacks_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_V1_HACKS_DEVICE_TYPE, g_param_spec_string ("device-type", "device-type", "device-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_V1_HACKS_SERVICE_TYPES, g_param_spec_boxed ("service-types", "service-types", "service-types", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_v1_hacks_instance_init (RygelV1Hacks * self) {
	self->priv = RYGEL_V1_HACKS_GET_PRIVATE (self);
}


static void rygel_v1_hacks_finalize (GObject* obj) {
	RygelV1Hacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_V1_HACKS, RygelV1Hacks);
	_g_free0 (self->priv->_device_type);
	_g_free0 (self->priv->device_type_v1);
	self->priv->_service_types = (_vala_array_free (self->priv->_service_types, self->priv->_service_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->description_path);
	_g_regex_unref0 (self->priv->agent_regex);
	_g_regex_unref0 (self->priv->service_type_regex);
	G_OBJECT_CLASS (rygel_v1_hacks_parent_class)->finalize (obj);
}


/**
 * Various devices that need a downgrade to MediaServer:1 and
 * ContentDirectory:1 because they ignore that higher versions are
 * required to be backwards-compatible.
 */
GType rygel_v1_hacks_get_type (void) {
	static volatile gsize rygel_v1_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_v1_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelV1HacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_v1_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelV1Hacks), 0, (GInstanceInitFunc) rygel_v1_hacks_instance_init, NULL };
		GType rygel_v1_hacks_type_id;
		rygel_v1_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelV1Hacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_v1_hacks_type_id__volatile, rygel_v1_hacks_type_id);
	}
	return rygel_v1_hacks_type_id__volatile;
}


static void _vala_rygel_v1_hacks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelV1Hacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_V1_HACKS, RygelV1Hacks);
	switch (property_id) {
		case RYGEL_V1_HACKS_DEVICE_TYPE:
		g_value_set_string (value, rygel_v1_hacks_get_device_type (self));
		break;
		case RYGEL_V1_HACKS_SERVICE_TYPES:
		{
			int length;
			g_value_set_boxed (value, rygel_v1_hacks_get_service_types (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_v1_hacks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelV1Hacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_V1_HACKS, RygelV1Hacks);
	switch (property_id) {
		case RYGEL_V1_HACKS_DEVICE_TYPE:
		rygel_v1_hacks_set_device_type (self, g_value_get_string (value));
		break;
		case RYGEL_V1_HACKS_SERVICE_TYPES:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			rygel_v1_hacks_set_service_types (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



