/* sudoku-view.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
};

struct _Block5Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE,
	SUDOKU_CELL_VIEW_IS_FIXED,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS,
	SUDOKU_CELL_VIEW_SELECTED,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR
};
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static void __lambda7_ (SudokuCellView* self, gint number, gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static void __lambda10_ (SudokuCellView* self, NumberPicker* o, gint number);
static void ___lambda10__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
static void __lambda11_ (SudokuCellView* self);
static void sudoku_cell_view_destroy_popover (SudokuCellView* self, GtkPopover** popover);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda12_ (SudokuCellView* self);
static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda8_ (SudokuCellView* self);
static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda9_ (SudokuCellView* self);
static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result);
static void sudoku_cell_view_finalize (GObject* obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS,
	SUDOKU_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_VIEW_HIGHLIGHTER
};
static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ________lambda13_ (Block6Data* _data6_);
static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void ________lambda14_ (Block6Data* _data6_, GObject* s, GParamSpec* p);
static void _________lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
gboolean sudoku_view_get_highlighter (SudokuView* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void sudoku_view_finalize (GObject* obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GdkRGBA selected_bg_color = {0.7, 0.8, 0.9};
const GdkRGBA fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
const GdkRGBA free_cell_color = {1.0, 1.0, 1.0, 1.0};
const GdkRGBA highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
	return result;
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game) {
	SudokuCellView * self = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkStyle* _tmp4_ = NULL;
	GtkStyle* _tmp5_ = NULL;
	PangoFontDescription* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	SudokuGame* _tmp17_ = NULL;
	g_return_val_if_fail (*game != NULL, NULL);
	self = (SudokuCellView*) g_object_new (object_type, NULL);
	_tmp0_ = *game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	_tmp2_ = row;
	self->priv->row = _tmp2_;
	_tmp3_ = col;
	self->priv->col = _tmp3_;
	_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->font_desc;
	pango_font_description_set_size (_tmp6_, PANGO_SCALE * 13);
	_tmp7_ = *game;
	_tmp8_ = _tmp7_->board;
	_tmp9_ = row;
	_tmp10_ = col;
	_tmp11_ = sudoku_board_get (_tmp8_, _tmp9_, _tmp10_);
	sudoku_cell_view_set_value (self, _tmp11_);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	gtk_widget_set_events ((GtkWidget*) self, ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK);
	_tmp13_ = sudoku_cell_view_get_is_fixed (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		SudokuGame* _tmp15_ = NULL;
		GameMode _tmp16_ = 0;
		_tmp15_ = *game;
		_tmp16_ = _tmp15_->mode;
		_tmp12_ = _tmp16_ == GAME_MODE_PLAY;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		return self;
	}
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp17_ = *game;
	g_signal_connect_object (_tmp17_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
	return self;
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game) {
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	SudokuGame* _tmp8_ = NULL;
	GameMode _tmp9_ = 0;
	gboolean _tmp16_ = FALSE;
	GtkPopover* _tmp17_ = NULL;
	GdkEventButton* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ != ((guint) 1)) {
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->button;
		_tmp0_ = _tmp4_ != ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = _tmp8_->mode;
	if (_tmp9_ == GAME_MODE_PLAY) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = sudoku_cell_view_get_is_fixed (self);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			_tmp10_ = TRUE;
		} else {
			SudokuGame* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			_tmp13_ = self->priv->game;
			_tmp14_ = sudoku_game_get_paused (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp15_;
		}
		_tmp7_ = _tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->popover;
	if (_tmp17_ != NULL) {
		_tmp16_ = TRUE;
	} else {
		GtkPopover* _tmp18_ = NULL;
		_tmp18_ = self->priv->earmark_popover;
		_tmp16_ = _tmp18_ != NULL;
	}
	if (_tmp16_) {
		sudoku_cell_view_hide_both_popovers (self);
		result = FALSE;
		return result;
	}
	_tmp19_ = event;
	_tmp20_ = _tmp19_->button;
	if (_tmp20_ == ((guint) 1)) {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp23_ = self->priv->_show_possibilities;
		if (!_tmp23_) {
			GdkEventButton* _tmp24_ = NULL;
			GdkModifierType _tmp25_ = 0;
			_tmp24_ = event;
			_tmp25_ = _tmp24_->state;
			_tmp22_ = (_tmp25_ & GDK_CONTROL_MASK) > 0;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			SudokuGame* _tmp26_ = NULL;
			GameMode _tmp27_ = 0;
			_tmp26_ = self->priv->game;
			_tmp27_ = _tmp26_->mode;
			_tmp21_ = _tmp27_ == GAME_MODE_PLAY;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			sudoku_cell_view_show_earmark_picker (self);
		} else {
			sudoku_cell_view_show_number_picker (self);
		}
	} else {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		_tmp30_ = self->priv->_show_possibilities;
		if (!_tmp30_) {
			GdkEventButton* _tmp31_ = NULL;
			guint _tmp32_ = 0U;
			_tmp31_ = event;
			_tmp32_ = _tmp31_->button;
			_tmp29_ = _tmp32_ == ((guint) 3);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			SudokuGame* _tmp33_ = NULL;
			GameMode _tmp34_ = 0;
			_tmp33_ = self->priv->game;
			_tmp34_ = _tmp33_->mode;
			_tmp28_ = _tmp34_ == GAME_MODE_PLAY;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			sudoku_cell_view_show_earmark_picker (self);
		}
	}
	result = FALSE;
	return result;
}


static void __lambda7_ (SudokuCellView* self, gint number, gboolean state) {
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	_tmp0_ = state;
	if (_tmp0_) {
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp1_ = self->priv->game;
		_tmp2_ = _tmp1_->board;
		_tmp3_ = self->priv->row;
		_tmp4_ = self->priv->col;
		_tmp5_ = number;
		sudoku_board_enable_earmark (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
	} else {
		SudokuGame* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp6_ = self->priv->game;
		_tmp7_ = _tmp6_->board;
		_tmp8_ = self->priv->row;
		_tmp9_ = self->priv->col;
		_tmp10_ = number;
		sudoku_board_disable_earmark (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
	}
	_tmp11_ = self->priv->game;
	_tmp12_ = self->priv->row;
	_tmp13_ = self->priv->col;
	_tmp14_ = sudoku_cell_view_get_value (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = sudoku_cell_view_get_value (self);
	_tmp17_ = _tmp16_;
	g_signal_emit_by_name (_tmp11_, "cell-changed", _tmp12_, _tmp13_, _tmp15_, _tmp17_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
	__lambda7_ ((SudokuCellView*) self, number, active);
}


static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self) {
	SudokuGame* _tmp0_ = NULL;
	NumberPicker* _tmp1_ = NULL;
	NumberPicker* _tmp2_ = NULL;
	NumberPicker* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = number_picker_new (&_tmp0_->board, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->earmark_picker);
	self->priv->earmark_picker = _tmp1_;
	_tmp2_ = self->priv->earmark_picker;
	g_signal_connect_object (_tmp2_, "earmark-state-changed", (GCallback) ___lambda7__number_picker_earmark_state_changed, self, 0);
	_tmp3_ = self->priv->earmark_picker;
	_tmp4_ = self->priv->row;
	_tmp5_ = self->priv->col;
	number_picker_set_earmarks (_tmp3_, _tmp4_, _tmp5_);
}


static void __lambda10_ (SudokuCellView* self, NumberPicker* o, gint number) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkPopover* _tmp6_ = NULL;
	g_return_if_fail (o != NULL);
	_tmp0_ = number;
	sudoku_cell_view_set_value (self, _tmp0_);
	_tmp1_ = number;
	if (_tmp1_ == 0) {
		g_object_notify ((GObject*) self, "value");
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = _tmp2_->board;
	_tmp4_ = self->priv->row;
	_tmp5_ = self->priv->col;
	sudoku_board_disable_all_earmarks (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp6_);
}


static void ___lambda10__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
	__lambda10_ ((SudokuCellView*) self, _sender, number);
}


static void __lambda11_ (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		sudoku_cell_view_destroy_popover (self, &self->priv->popover);
	}
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda11_ ((SudokuCellView*) self);
}


static gboolean __lambda12_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda12_ ((SudokuCellView*) self);
	return result;
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	NumberPicker* _tmp3_ = NULL;
	NumberPicker* _tmp4_ = NULL;
	NumberPicker* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkPopover* _tmp8_ = NULL;
	GtkPopover* _tmp9_ = NULL;
	NumberPicker* _tmp10_ = NULL;
	GtkPopover* _tmp11_ = NULL;
	GtkPopover* _tmp12_ = NULL;
	GtkPopover* _tmp13_ = NULL;
	GtkPopover* _tmp14_ = NULL;
	GtkPopover* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmark_popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_ = NULL;
		_tmp1_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = number_picker_new (&_tmp2_->board, FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->number_picker);
	self->priv->number_picker = _tmp3_;
	_tmp4_ = self->priv->number_picker;
	g_signal_connect_object (_tmp4_, "number-picked", (GCallback) ___lambda10__number_picker_number_picked, self, 0);
	_tmp5_ = self->priv->number_picker;
	_tmp6_ = sudoku_cell_view_get_value (self);
	_tmp7_ = _tmp6_;
	number_picker_set_clear_button_visibility (_tmp5_, _tmp7_ != 0);
	_tmp8_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp8_;
	_tmp9_ = self->priv->popover;
	_tmp10_ = self->priv->number_picker;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->popover;
	gtk_popover_set_modal (_tmp11_, FALSE);
	_tmp12_ = self->priv->popover;
	gtk_popover_set_position (_tmp12_, GTK_POS_BOTTOM);
	_tmp13_ = self->priv->popover;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::visible", (GCallback) ___lambda11__g_object_notify, self, 0);
	_tmp14_ = self->priv->popover;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "focus-out-event", (GCallback) ___lambda12__gtk_widget_focus_out_event, self, 0);
	_tmp15_ = self->priv->popover;
	gtk_widget_show ((GtkWidget*) _tmp15_);
}


static void __lambda8_ (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->earmark_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		sudoku_cell_view_destroy_popover (self, &self->priv->earmark_popover);
	}
}


static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda8_ ((SudokuCellView*) self);
}


static gboolean __lambda9_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->earmark_popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda9_ ((SudokuCellView*) self);
	return result;
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp2_ = NULL;
	GtkPopover* _tmp3_ = NULL;
	NumberPicker* _tmp4_ = NULL;
	GtkPopover* _tmp5_ = NULL;
	GtkPopover* _tmp6_ = NULL;
	GtkPopover* _tmp7_ = NULL;
	GtkPopover* _tmp8_ = NULL;
	GtkPopover* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_ = NULL;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	sudoku_cell_view_create_earmark_picker (self);
	_tmp2_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->earmark_popover);
	self->priv->earmark_popover = _tmp2_;
	_tmp3_ = self->priv->earmark_popover;
	_tmp4_ = self->priv->earmark_picker;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->earmark_popover;
	gtk_popover_set_modal (_tmp5_, FALSE);
	_tmp6_ = self->priv->earmark_popover;
	gtk_popover_set_position (_tmp6_, GTK_POS_BOTTOM);
	_tmp7_ = self->priv->earmark_popover;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::visible", (GCallback) ___lambda8__g_object_notify, self, 0);
	_tmp8_ = self->priv->earmark_popover;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "focus-out-event", (GCallback) ___lambda9__gtk_widget_focus_out_event, self, 0);
	_tmp9_ = self->priv->earmark_popover;
	gtk_widget_show ((GtkWidget*) _tmp9_);
}


static void sudoku_cell_view_destroy_popover (SudokuCellView* self, GtkPopover** popover) {
	GtkPopover* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*popover != NULL);
	_tmp0_ = *popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_ = NULL;
		_tmp1_ = *popover;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
		_g_object_unref0 (*popover);
		*popover = NULL;
	}
}


static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_ = NULL;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->earmark_popover;
	if (_tmp2_ != NULL) {
		GtkPopover* _tmp3_ = NULL;
		_tmp3_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	sudoku_cell_view_hide_both_popovers (self);
	result = FALSE;
	return result;
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (key_name != NULL, 0);
	_tmp1_ = key_name;
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key_name;
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp3_ = key_name;
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
		result = 1;
		return result;
	}
	_tmp4_ = key_name;
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
		result = 2;
		return result;
	}
	_tmp5_ = key_name;
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
		result = 3;
		return result;
	}
	_tmp6_ = key_name;
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
		result = 4;
		return result;
	}
	_tmp7_ = key_name;
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
		result = 5;
		return result;
	}
	_tmp8_ = key_name;
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
		result = 6;
		return result;
	}
	_tmp9_ = key_name;
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
		result = 7;
		return result;
	}
	_tmp10_ = key_name;
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
		result = 8;
		return result;
	}
	_tmp11_ = key_name;
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
		result = 9;
		return result;
	}
	result = -1;
	return result;
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_ = NULL;
	GameMode _tmp2_ = 0;
	gchar* k_name = NULL;
	GdkEventKey* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint k_no = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_ = 0;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp67_ = NULL;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->game;
	_tmp2_ = _tmp1_->mode;
	if (_tmp2_ == GAME_MODE_PLAY) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = sudoku_cell_view_get_is_fixed (self);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			_tmp3_ = TRUE;
		} else {
			SudokuGame* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			_tmp6_ = self->priv->game;
			_tmp7_ = sudoku_game_get_paused (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp3_ = _tmp8_;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = event;
	_tmp10_ = _tmp9_->keyval;
	_tmp11_ = gdk_keyval_name (_tmp10_);
	_tmp12_ = g_strdup (_tmp11_);
	k_name = _tmp12_;
	_tmp13_ = k_name;
	_tmp14_ = atoi (_tmp13_);
	k_no = _tmp14_;
	_tmp15_ = k_no;
	if (_tmp15_ == 0) {
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp16_ = k_name;
		_tmp17_ = sudoku_cell_view_key_map_keypad (self, _tmp16_);
		k_no = _tmp17_;
	}
	_tmp19_ = k_no;
	if (_tmp19_ >= 1) {
		gint _tmp20_ = 0;
		_tmp20_ = k_no;
		_tmp18_ = _tmp20_ <= 9;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		GdkEventKey* _tmp22_ = NULL;
		GdkModifierType _tmp23_ = 0;
		_tmp22_ = event;
		_tmp23_ = _tmp22_->state;
		if ((_tmp23_ & GDK_CONTROL_MASK) > 0) {
			SudokuGame* _tmp24_ = NULL;
			GameMode _tmp25_ = 0;
			_tmp24_ = self->priv->game;
			_tmp25_ = _tmp24_->mode;
			_tmp21_ = _tmp25_ == GAME_MODE_PLAY;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			gboolean new_state = FALSE;
			SudokuGame* _tmp26_ = NULL;
			SudokuBoard* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gboolean _tmp31_ = FALSE;
			NumberPicker* _tmp32_ = NULL;
			NumberPicker* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			_tmp26_ = self->priv->game;
			_tmp27_ = _tmp26_->board;
			_tmp28_ = self->priv->row;
			_tmp29_ = self->priv->col;
			_tmp30_ = k_no;
			_tmp31_ = sudoku_board_is_earmark_enabled (_tmp27_, _tmp28_, _tmp29_, _tmp30_);
			new_state = !_tmp31_;
			_tmp32_ = self->priv->earmark_picker;
			if (_tmp32_ == NULL) {
				sudoku_cell_view_create_earmark_picker (self);
			}
			_tmp33_ = self->priv->earmark_picker;
			_tmp34_ = self->priv->row;
			_tmp35_ = self->priv->col;
			_tmp36_ = k_no;
			_tmp37_ = new_state;
			_tmp38_ = number_picker_set_earmark (_tmp33_, _tmp34_, _tmp35_, _tmp36_ - 1, _tmp37_);
			if (_tmp38_) {
				gboolean _tmp39_ = FALSE;
				_tmp39_ = new_state;
				if (_tmp39_) {
					SudokuGame* _tmp40_ = NULL;
					SudokuBoard* _tmp41_ = NULL;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					_tmp40_ = self->priv->game;
					_tmp41_ = _tmp40_->board;
					_tmp42_ = self->priv->row;
					_tmp43_ = self->priv->col;
					_tmp44_ = k_no;
					sudoku_board_enable_earmark (_tmp41_, _tmp42_, _tmp43_, _tmp44_);
				} else {
					SudokuGame* _tmp45_ = NULL;
					SudokuBoard* _tmp46_ = NULL;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					_tmp45_ = self->priv->game;
					_tmp46_ = _tmp45_->board;
					_tmp47_ = self->priv->row;
					_tmp48_ = self->priv->col;
					_tmp49_ = k_no;
					sudoku_board_disable_earmark (_tmp46_, _tmp47_, _tmp48_, _tmp49_);
				}
				gtk_widget_queue_draw ((GtkWidget*) self);
			}
		} else {
			gint _tmp50_ = 0;
			SudokuGame* _tmp51_ = NULL;
			SudokuBoard* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			gint _tmp54_ = 0;
			_tmp50_ = k_no;
			sudoku_cell_view_set_value (self, _tmp50_);
			_tmp51_ = self->priv->game;
			_tmp52_ = _tmp51_->board;
			_tmp53_ = self->priv->row;
			_tmp54_ = self->priv->col;
			sudoku_board_disable_all_earmarks (_tmp52_, _tmp53_, _tmp54_);
			sudoku_cell_view_hide_both_popovers (self);
		}
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp57_ = k_no;
	if (_tmp57_ == 0) {
		_tmp56_ = TRUE;
	} else {
		const gchar* _tmp58_ = NULL;
		_tmp58_ = k_name;
		_tmp56_ = g_strcmp0 (_tmp58_, "BackSpace") == 0;
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		const gchar* _tmp59_ = NULL;
		_tmp59_ = k_name;
		_tmp55_ = g_strcmp0 (_tmp59_, "Delete") == 0;
	}
	if (_tmp55_) {
		sudoku_cell_view_set_value (self, 0);
		g_object_notify ((GObject*) self, "value");
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp62_ = k_name;
	if (g_strcmp0 (_tmp62_, "space") == 0) {
		_tmp61_ = TRUE;
	} else {
		const gchar* _tmp63_ = NULL;
		_tmp63_ = k_name;
		_tmp61_ = g_strcmp0 (_tmp63_, "Return") == 0;
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		const gchar* _tmp64_ = NULL;
		_tmp64_ = k_name;
		_tmp60_ = g_strcmp0 (_tmp64_, "KP_Enter") == 0;
	}
	if (_tmp60_) {
		GtkPopover* _tmp65_ = NULL;
		_tmp65_ = self->priv->popover;
		if (_tmp65_ != NULL) {
			GtkPopover* _tmp66_ = NULL;
			_tmp66_ = self->priv->popover;
			gtk_widget_hide ((GtkWidget*) _tmp66_);
			result = FALSE;
			_g_free0 (k_name);
			return result;
		}
		sudoku_cell_view_show_number_picker (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp67_ = k_name;
	if (g_strcmp0 (_tmp67_, "Escape") == 0) {
		sudoku_cell_view_hide_both_popovers (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	result = FALSE;
	_g_free0 (k_name);
	return result;
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	SudokuGame* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_ = FALSE;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->layout;
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
	glyph_width = _tmp1_;
	glyph_height = _tmp2_;
	_tmp4_ = self->priv->_show_warnings;
	if (_tmp4_) {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Coord _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
		_tmp5_ = self->priv->game;
		_tmp6_ = _tmp5_->board;
		_tmp7_ = _tmp6_->broken_coords;
		_tmp8_ = self->priv->row;
		_tmp9_ = self->priv->col;
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
		_tmp11_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
		_tmp3_ = _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		cairo_t* _tmp12_ = NULL;
		_tmp12_ = c;
		cairo_set_source_rgb (_tmp12_, 1.0, 0.0, 0.0);
	} else {
		gboolean _tmp13_ = FALSE;
		_tmp13_ = self->priv->_selected;
		if (_tmp13_) {
			cairo_t* _tmp14_ = NULL;
			_tmp14_ = c;
			cairo_set_source_rgb (_tmp14_, 0.2, 0.2, 0.2);
		} else {
			cairo_t* _tmp15_ = NULL;
			_tmp15_ = c;
			cairo_set_source_rgb (_tmp15_, 0.0, 0.0, 0.0);
		}
	}
	_tmp16_ = self->priv->game;
	_tmp17_ = sudoku_game_get_paused (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		result = FALSE;
		return result;
	}
	_tmp19_ = sudoku_cell_view_get_value (self);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != 0) {
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gdouble scale = 0.0;
		gint _tmp25_ = 0;
		gdouble _tmp26_ = 0.0;
		gint _tmp27_ = 0;
		cairo_t* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gdouble _tmp31_ = 0.0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gdouble _tmp34_ = 0.0;
		cairo_t* _tmp35_ = NULL;
		cairo_t* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		gdouble _tmp38_ = 0.0;
		cairo_t* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		cairo_t* _tmp41_ = NULL;
		_tmp21_ = self->priv->layout;
		pango_layout_get_size (_tmp21_, &_tmp22_, &_tmp23_);
		width = _tmp22_;
		height = _tmp23_;
		_tmp24_ = height;
		height = _tmp24_ / PANGO_SCALE;
		_tmp25_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp26_ = self->priv->size_ratio;
		_tmp27_ = height;
		scale = (((gdouble) _tmp25_) / _tmp26_) / _tmp27_;
		_tmp28_ = c;
		_tmp29_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp30_ = glyph_width;
		_tmp31_ = scale;
		_tmp32_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp33_ = glyph_height;
		_tmp34_ = scale;
		cairo_move_to (_tmp28_, (_tmp29_ - (_tmp30_ * _tmp31_)) / 2, (_tmp32_ - (_tmp33_ * _tmp34_)) / 2);
		_tmp35_ = c;
		cairo_save (_tmp35_);
		_tmp36_ = c;
		_tmp37_ = scale;
		_tmp38_ = scale;
		cairo_scale (_tmp36_, _tmp37_, _tmp38_);
		_tmp39_ = c;
		_tmp40_ = self->priv->layout;
		pango_cairo_show_layout (_tmp39_, _tmp40_);
		_tmp41_ = c;
		cairo_restore (_tmp41_);
	}
	_tmp43_ = sudoku_cell_view_get_is_fixed (self);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		SudokuGame* _tmp45_ = NULL;
		GameMode _tmp46_ = 0;
		_tmp45_ = self->priv->game;
		_tmp46_ = _tmp45_->mode;
		_tmp42_ = _tmp46_ == GAME_MODE_PLAY;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		result = FALSE;
		return result;
	}
	_tmp47_ = self->priv->_show_possibilities;
	if (!_tmp47_) {
		gdouble earmark_size = 0.0;
		gint _tmp48_ = 0;
		gdouble _tmp49_ = 0.0;
		cairo_t* _tmp50_ = NULL;
		gdouble _tmp51_ = 0.0;
		cairo_t* _tmp52_ = NULL;
		gdouble _tmp53_ = 0.0;
		cairo_t* _tmp54_ = NULL;
		cairo_t* _tmp55_ = NULL;
		SudokuGame* _tmp56_ = NULL;
		SudokuBoard* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		_tmp48_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp49_ = self->priv->size_ratio;
		earmark_size = _tmp48_ / (_tmp49_ * 2);
		_tmp50_ = c;
		_tmp51_ = earmark_size;
		cairo_set_font_size (_tmp50_, _tmp51_);
		_tmp52_ = c;
		_tmp53_ = earmark_size;
		cairo_move_to (_tmp52_, (gdouble) 0, _tmp53_);
		_tmp54_ = c;
		cairo_set_source_rgb (_tmp54_, 0.0, 0.0, 0.0);
		_tmp55_ = c;
		_tmp56_ = self->priv->game;
		_tmp57_ = _tmp56_->board;
		_tmp58_ = self->priv->row;
		_tmp59_ = self->priv->col;
		_tmp60_ = sudoku_board_get_earmarks_string (_tmp57_, _tmp58_, _tmp59_);
		_tmp61_ = _tmp60_;
		cairo_show_text (_tmp55_, _tmp61_);
		_g_free0 (_tmp61_);
	} else {
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		_tmp62_ = sudoku_cell_view_get_value (self);
		_tmp63_ = _tmp62_;
		if (_tmp63_ == 0) {
			gdouble possibility_size = 0.0;
			gint _tmp64_ = 0;
			gdouble _tmp65_ = 0.0;
			cairo_t* _tmp66_ = NULL;
			gdouble _tmp67_ = 0.0;
			cairo_t* _tmp68_ = NULL;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp69_ = NULL;
			SudokuBoard* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gboolean* _tmp74_ = NULL;
			gint possibilities_length1 = 0;
			gint _possibilities_size_ = 0;
			gint height = 0;
			gint _tmp75_ = 0;
			SudokuGame* _tmp76_ = NULL;
			SudokuBoard* _tmp77_ = NULL;
			gint _tmp78_ = 0;
			gint _tmp79_ = 0;
			gint width = 0;
			gint _tmp80_ = 0;
			SudokuGame* _tmp81_ = NULL;
			SudokuBoard* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gint num = 0;
			_tmp64_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
			_tmp65_ = self->priv->size_ratio;
			possibility_size = _tmp64_ / (_tmp65_ * 2);
			_tmp66_ = c;
			_tmp67_ = possibility_size;
			cairo_set_font_size (_tmp66_, _tmp67_);
			_tmp68_ = c;
			cairo_set_source_rgb (_tmp68_, 0.0, 0.0, 0.0);
			_tmp69_ = self->priv->game;
			_tmp70_ = _tmp69_->board;
			_tmp71_ = self->priv->row;
			_tmp72_ = self->priv->col;
			_tmp74_ = sudoku_board_get_possibilities_as_bool_array (_tmp70_, _tmp71_, _tmp72_, &_tmp73_);
			possibilities = _tmp74_;
			possibilities_length1 = _tmp73_;
			_possibilities_size_ = possibilities_length1;
			_tmp75_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
			_tmp76_ = self->priv->game;
			_tmp77_ = _tmp76_->board;
			_tmp78_ = sudoku_board_get_block_cols (_tmp77_);
			_tmp79_ = _tmp78_;
			height = _tmp75_ / _tmp79_;
			_tmp80_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
			_tmp81_ = self->priv->game;
			_tmp82_ = _tmp81_->board;
			_tmp83_ = sudoku_board_get_block_rows (_tmp82_);
			_tmp84_ = _tmp83_;
			width = _tmp80_ / _tmp84_;
			num = 0;
			{
				gint row_tmp = 0;
				row_tmp = 0;
				{
					gboolean _tmp85_ = FALSE;
					_tmp85_ = TRUE;
					while (TRUE) {
						gint _tmp87_ = 0;
						SudokuGame* _tmp88_ = NULL;
						SudokuBoard* _tmp89_ = NULL;
						gint _tmp90_ = 0;
						gint _tmp91_ = 0;
						if (!_tmp85_) {
							gint _tmp86_ = 0;
							_tmp86_ = row_tmp;
							row_tmp = _tmp86_ + 1;
						}
						_tmp85_ = FALSE;
						_tmp87_ = row_tmp;
						_tmp88_ = self->priv->game;
						_tmp89_ = _tmp88_->board;
						_tmp90_ = sudoku_board_get_block_rows (_tmp89_);
						_tmp91_ = _tmp90_;
						if (!(_tmp87_ < _tmp91_)) {
							break;
						}
						{
							gint col_tmp = 0;
							col_tmp = 0;
							{
								gboolean _tmp92_ = FALSE;
								_tmp92_ = TRUE;
								while (TRUE) {
									gint _tmp94_ = 0;
									SudokuGame* _tmp95_ = NULL;
									SudokuBoard* _tmp96_ = NULL;
									gint _tmp97_ = 0;
									gint _tmp98_ = 0;
									gint _tmp99_ = 0;
									gboolean* _tmp100_ = NULL;
									gint _tmp100__length1 = 0;
									gint _tmp101_ = 0;
									gboolean _tmp102_ = FALSE;
									if (!_tmp92_) {
										gint _tmp93_ = 0;
										_tmp93_ = col_tmp;
										col_tmp = _tmp93_ + 1;
									}
									_tmp92_ = FALSE;
									_tmp94_ = col_tmp;
									_tmp95_ = self->priv->game;
									_tmp96_ = _tmp95_->board;
									_tmp97_ = sudoku_board_get_block_cols (_tmp96_);
									_tmp98_ = _tmp97_;
									if (!(_tmp94_ < _tmp98_)) {
										break;
									}
									_tmp99_ = num;
									num = _tmp99_ + 1;
									_tmp100_ = possibilities;
									_tmp100__length1 = possibilities_length1;
									_tmp101_ = num;
									_tmp102_ = _tmp100_[_tmp101_ - 1];
									if (_tmp102_) {
										cairo_t* _tmp103_ = NULL;
										gint _tmp104_ = 0;
										gint _tmp105_ = 0;
										gint _tmp106_ = 0;
										gint _tmp107_ = 0;
										gdouble _tmp108_ = 0.0;
										cairo_t* _tmp109_ = NULL;
										gint _tmp110_ = 0;
										gchar* _tmp111_ = NULL;
										gchar* _tmp112_ = NULL;
										_tmp103_ = c;
										_tmp104_ = col_tmp;
										_tmp105_ = width;
										_tmp106_ = row_tmp;
										_tmp107_ = height;
										_tmp108_ = possibility_size;
										cairo_move_to (_tmp103_, (gdouble) (_tmp104_ * _tmp105_), (_tmp106_ * _tmp107_) + _tmp108_);
										_tmp109_ = c;
										_tmp110_ = num;
										_tmp111_ = g_strdup_printf ("%d", _tmp110_);
										_tmp112_ = _tmp111_;
										cairo_show_text (_tmp109_, _tmp112_);
										_g_free0 (_tmp112_);
									}
								}
							}
						}
					}
				}
			}
			possibilities = (g_free (possibilities), NULL);
		}
	}
	_tmp114_ = self->priv->_show_warnings;
	if (_tmp114_) {
		gboolean _tmp115_ = FALSE;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		_tmp116_ = sudoku_cell_view_get_value (self);
		_tmp117_ = _tmp116_;
		if (_tmp117_ == 0) {
			SudokuGame* _tmp118_ = NULL;
			SudokuBoard* _tmp119_ = NULL;
			gint _tmp120_ = 0;
			gint _tmp121_ = 0;
			gint _tmp122_ = 0;
			_tmp118_ = self->priv->game;
			_tmp119_ = _tmp118_->board;
			_tmp120_ = self->priv->row;
			_tmp121_ = self->priv->col;
			_tmp122_ = sudoku_board_count_possibilities (_tmp119_, _tmp120_, _tmp121_);
			_tmp115_ = _tmp122_ == 0;
		} else {
			_tmp115_ = FALSE;
		}
		_tmp113_ = _tmp115_;
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		gchar* warning = NULL;
		gchar* _tmp123_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp124_ = NULL;
		gint _tmp125_ = 0;
		cairo_t* _tmp126_ = NULL;
		const gchar* _tmp127_ = NULL;
		cairo_text_extents_t _tmp128_ = {0};
		cairo_t* _tmp129_ = NULL;
		gint _tmp130_ = 0;
		cairo_text_extents_t _tmp131_ = {0};
		gdouble _tmp132_ = 0.0;
		gint _tmp133_ = 0;
		cairo_text_extents_t _tmp134_ = {0};
		gdouble _tmp135_ = 0.0;
		cairo_t* _tmp136_ = NULL;
		cairo_t* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
		_tmp123_ = g_strdup ("X");
		warning = _tmp123_;
		_tmp124_ = c;
		_tmp125_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		cairo_set_font_size (_tmp124_, (gdouble) (_tmp125_ / 2));
		_tmp126_ = c;
		_tmp127_ = warning;
		cairo_text_extents (_tmp126_, _tmp127_, &_tmp128_);
		extents = _tmp128_;
		_tmp129_ = c;
		_tmp130_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp131_ = extents;
		_tmp132_ = _tmp131_.width;
		_tmp133_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp134_ = extents;
		_tmp135_ = _tmp134_.height;
		cairo_move_to (_tmp129_, ((_tmp130_ - _tmp132_) / 2) - 1, ((_tmp133_ + _tmp135_) / 2) + 1);
		_tmp136_ = c;
		cairo_set_source_rgb (_tmp136_, 1.0, 0.0, 0.0);
		_tmp137_ = c;
		_tmp138_ = warning;
		cairo_show_text (_tmp137_, _tmp138_);
		_g_free0 (warning);
	}
	result = FALSE;
	return result;
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = row;
	_tmp2_ = self->priv->row;
	if (_tmp1_ == _tmp2_) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp3_ = col;
		_tmp4_ = self->priv->col;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp5_ = 0;
		SudokuGame* _tmp6_ = NULL;
		GameMode _tmp7_ = 0;
		_tmp5_ = new_val;
		sudoku_cell_view_set_value (self, _tmp5_);
		_tmp6_ = self->priv->game;
		_tmp7_ = _tmp6_->mode;
		if (_tmp7_ == GAME_MODE_CREATE) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = self->priv->_selected;
			if (_tmp8_) {
				sudoku_cell_view_set_background_color (self, &selected_bg_color);
			} else {
				GdkRGBA _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				_tmp10_ = sudoku_cell_view_get_is_fixed (self);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					_tmp9_ = fixed_cell_color;
				} else {
					_tmp9_ = free_cell_color;
				}
				sudoku_cell_view_set_background_color (self, &_tmp9_);
			}
		}
		g_object_notify ((GObject*) self, "value");
	}
}


void sudoku_cell_view_clear (SudokuCellView* self) {
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = self->priv->row;
	_tmp3_ = self->priv->col;
	sudoku_board_disable_all_earmarks (_tmp1_, _tmp2_, _tmp3_);
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = self->priv->row;
	_tmp3_ = self->priv->col;
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp34_ = 0;
	SudokuGame* _tmp35_ = NULL;
	SudokuBoard* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	SudokuGame* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* text = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		PangoLayout* _tmp9_ = NULL;
		PangoLayout* _tmp10_ = NULL;
		GtkStyle* _tmp11_ = NULL;
		GtkStyle* _tmp12_ = NULL;
		PangoFontDescription* _tmp13_ = NULL;
		SudokuGame* _tmp14_ = NULL;
		GameMode _tmp15_ = 0;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		_tmp4_ = self->priv->row;
		_tmp5_ = self->priv->col;
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
		text = _tmp7_;
		_tmp8_ = text;
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp9_;
		_tmp10_ = self->priv->layout;
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_->font_desc;
		pango_layout_set_font_description (_tmp10_, _tmp13_);
		_tmp14_ = self->priv->game;
		_tmp15_ = _tmp14_->mode;
		if (_tmp15_ == GAME_MODE_PLAY) {
			_g_free0 (text);
			return;
		}
		_g_free0 (text);
	}
	_tmp16_ = value;
	if (_tmp16_ == 0) {
		gchar* text = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		PangoLayout* _tmp19_ = NULL;
		PangoLayout* _tmp20_ = NULL;
		GtkStyle* _tmp21_ = NULL;
		GtkStyle* _tmp22_ = NULL;
		PangoFontDescription* _tmp23_ = NULL;
		SudokuGame* _tmp24_ = NULL;
		SudokuBoard* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		SudokuGame* _tmp32_ = NULL;
		GameMode _tmp33_ = 0;
		_tmp17_ = g_strdup ("");
		text = _tmp17_;
		_tmp18_ = text;
		_tmp19_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp18_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp19_;
		_tmp20_ = self->priv->layout;
		_tmp21_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->font_desc;
		pango_layout_set_font_description (_tmp20_, _tmp23_);
		_tmp24_ = self->priv->game;
		_tmp25_ = _tmp24_->board;
		_tmp26_ = self->priv->row;
		_tmp27_ = self->priv->col;
		_tmp28_ = sudoku_board_get (_tmp25_, _tmp26_, _tmp27_);
		if (_tmp28_ != 0) {
			SudokuGame* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			_tmp29_ = self->priv->game;
			_tmp30_ = self->priv->row;
			_tmp31_ = self->priv->col;
			sudoku_game_remove (_tmp29_, _tmp30_, _tmp31_);
		}
		_tmp32_ = self->priv->game;
		_tmp33_ = _tmp32_->mode;
		if (_tmp33_ == GAME_MODE_PLAY) {
			_g_free0 (text);
			return;
		}
		_g_free0 (text);
	}
	_tmp34_ = value;
	_tmp35_ = self->priv->game;
	_tmp36_ = _tmp35_->board;
	_tmp37_ = self->priv->row;
	_tmp38_ = self->priv->col;
	_tmp39_ = sudoku_board_get (_tmp36_, _tmp37_, _tmp38_);
	if (_tmp34_ == _tmp39_) {
		gchar* text = NULL;
		gint _tmp40_ = 0;
		gchar* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		PangoLayout* _tmp43_ = NULL;
		PangoLayout* _tmp44_ = NULL;
		GtkStyle* _tmp45_ = NULL;
		GtkStyle* _tmp46_ = NULL;
		PangoFontDescription* _tmp47_ = NULL;
		_tmp40_ = value;
		_tmp41_ = g_strdup_printf ("%d", _tmp40_);
		text = _tmp41_;
		_tmp42_ = text;
		_tmp43_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp42_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp43_;
		_tmp44_ = self->priv->layout;
		_tmp45_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = _tmp46_->font_desc;
		pango_layout_set_font_description (_tmp44_, _tmp47_);
		_g_free0 (text);
		return;
	}
	_tmp48_ = self->priv->game;
	_tmp49_ = self->priv->row;
	_tmp50_ = self->priv->col;
	_tmp51_ = value;
	sudoku_game_insert (_tmp48_, _tmp49_, _tmp50_, _tmp51_);
	g_object_notify ((GObject *) self, "value");
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _tmp1_->is_fixed;
	_tmp2__length1 = _tmp1_->is_fixed_length1;
	_tmp2__length2 = _tmp1_->is_fixed_length2;
	_tmp3_ = self->priv->row;
	_tmp4_ = self->priv->col;
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
	result = _tmp5_;
	return result;
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_possibilities;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_possibilities = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "show-possibilities");
}


gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_warnings = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "show-warnings");
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_selected = _tmp0_;
	g_object_notify ((GObject *) self, "selected");
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background_color;
	*result = _tmp0_;
	return;
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_background_color = _tmp0_;
	g_object_notify ((GObject *) self, "background-color");
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
	((GtkWidgetClass *) klass)->button_press_event = sudoku_cell_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = sudoku_cell_view_real_key_press_event;
	((GtkWidgetClass *) klass)->draw = sudoku_cell_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED, g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
	self->priv->size_ratio = (gdouble) 2;
	self->priv->_show_warnings = TRUE;
}


static void sudoku_cell_view_finalize (GObject* obj) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->earmark_popover);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->number_picker);
	_g_object_unref0 (self->priv->earmark_picker);
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_VALUE:
		g_value_set_int (value, sudoku_cell_view_get_value (self));
		break;
		case SUDOKU_CELL_VIEW_IS_FIXED:
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
		break;
		case SUDOKU_CELL_VIEW_SELECTED:
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
		break;
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
		{
			GdkRGBA boxed;
			sudoku_cell_view_get_background_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_VALUE:
		sudoku_cell_view_set_value (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SELECTED:
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	SudokuCellView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuCellView* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SudokuCellView** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	SudokuCellView* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = self->priv->selected_row;
	_tmp2_ = self->priv->selected_col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
	_tmp4_ = self->priv->cells;
	_tmp4__length1 = self->priv->cells_length1;
	_tmp4__length2 = self->priv->cells_length2;
	_tmp5_ = self->priv->selected_row;
	_tmp6_ = self->priv->selected_col;
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
	_tmp8_ = cell_row;
	self->priv->selected_row = _tmp8_;
	_tmp9_ = cell_col;
	self->priv->selected_col = _tmp9_;
	_tmp10_ = self->priv->cells;
	_tmp10__length1 = self->priv->cells_length1;
	_tmp10__length2 = self->priv->cells_length2;
	_tmp11_ = self->priv->selected_row;
	_tmp12_ = self->priv->selected_col;
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
	sudoku_cell_view_set_selected (_tmp13_, TRUE);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SudokuView* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->game);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SudokuView* self;
		self = _data6_->_data5_->self;
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static gboolean ________lambda13_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean result = FALSE;
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	SudokuCellView** _tmp113_ = NULL;
	gint _tmp113__length1 = 0;
	gint _tmp113__length2 = 0;
	gint _tmp114_ = 0;
	gint _tmp115_ = 0;
	SudokuCellView* _tmp116_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data5_->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = _data6_->cell_row;
	_tmp4_ = _data6_->cell_col;
	sudoku_view_set_selected (self, _tmp3_, _tmp4_);
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				SudokuGame* _tmp8_ = NULL;
				SudokuBoard* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GdkRGBA _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				GdkRGBA color = {0};
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = col_tmp;
					col_tmp = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = col_tmp;
				_tmp8_ = _data5_->game;
				_tmp9_ = _tmp8_->board;
				_tmp10_ = sudoku_board_get_cols (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp7_ < _tmp11_)) {
					break;
				}
				_tmp14_ = col_tmp;
				_tmp15_ = _data6_->cell_col;
				if (_tmp14_ == _tmp15_) {
					gboolean _tmp16_ = FALSE;
					_tmp16_ = self->priv->_highlighter;
					_tmp13_ = _tmp16_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_tmp12_ = highlight_color;
				} else {
					_tmp12_ = free_cell_color;
				}
				color = _tmp12_;
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp19_ = 0;
							SudokuGame* _tmp20_ = NULL;
							SudokuBoard* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							GdkRGBA _tmp24_ = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
							SudokuCellView** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp32__length2 = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							SudokuCellView* _tmp35_ = NULL;
							if (!_tmp17_) {
								gint _tmp18_ = 0;
								_tmp18_ = row_tmp;
								row_tmp = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = row_tmp;
							_tmp20_ = _data5_->game;
							_tmp21_ = _tmp20_->board;
							_tmp22_ = sudoku_board_get_rows (_tmp21_);
							_tmp23_ = _tmp22_;
							if (!(_tmp19_ < _tmp23_)) {
								break;
							}
							_tmp25_ = self->priv->cells;
							_tmp25__length1 = self->priv->cells_length1;
							_tmp25__length2 = self->priv->cells_length2;
							_tmp26_ = row_tmp;
							_tmp27_ = col_tmp;
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
							_tmp29_ = sudoku_cell_view_get_is_fixed (_tmp28_);
							_tmp30_ = _tmp29_;
							if (_tmp30_) {
								_tmp24_ = fixed_cell_color;
							} else {
								GdkRGBA _tmp31_ = {0};
								_tmp31_ = color;
								_tmp24_ = _tmp31_;
							}
							_tmp32_ = self->priv->cells;
							_tmp32__length1 = self->priv->cells_length1;
							_tmp32__length2 = self->priv->cells_length2;
							_tmp33_ = row_tmp;
							_tmp34_ = col_tmp;
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
							sudoku_cell_view_set_background_color (_tmp35_, &_tmp24_);
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp36_ = FALSE;
			_tmp36_ = TRUE;
			while (TRUE) {
				gint _tmp38_ = 0;
				SudokuGame* _tmp39_ = NULL;
				SudokuBoard* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				SudokuCellView** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp43__length2 = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				SudokuCellView* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				if (!_tmp36_) {
					gint _tmp37_ = 0;
					_tmp37_ = col_tmp;
					col_tmp = _tmp37_ + 1;
				}
				_tmp36_ = FALSE;
				_tmp38_ = col_tmp;
				_tmp39_ = _data5_->game;
				_tmp40_ = _tmp39_->board;
				_tmp41_ = sudoku_board_get_cols (_tmp40_);
				_tmp42_ = _tmp41_;
				if (!(_tmp38_ < _tmp42_)) {
					break;
				}
				_tmp43_ = self->priv->cells;
				_tmp43__length1 = self->priv->cells_length1;
				_tmp43__length2 = self->priv->cells_length2;
				_tmp44_ = _data6_->cell_row;
				_tmp45_ = col_tmp;
				_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
				_tmp47_ = sudoku_cell_view_get_is_fixed (_tmp46_);
				_tmp48_ = _tmp47_;
				if (_tmp48_) {
					SudokuCellView** _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					gint _tmp49__length2 = 0;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					SudokuCellView* _tmp52_ = NULL;
					_tmp49_ = self->priv->cells;
					_tmp49__length1 = self->priv->cells_length1;
					_tmp49__length2 = self->priv->cells_length2;
					_tmp50_ = _data6_->cell_row;
					_tmp51_ = col_tmp;
					_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
					sudoku_cell_view_set_background_color (_tmp52_, &fixed_cell_color);
				} else {
					gboolean _tmp53_ = FALSE;
					_tmp53_ = self->priv->_highlighter;
					if (_tmp53_) {
						SudokuCellView** _tmp54_ = NULL;
						gint _tmp54__length1 = 0;
						gint _tmp54__length2 = 0;
						gint _tmp55_ = 0;
						gint _tmp56_ = 0;
						SudokuCellView* _tmp57_ = NULL;
						_tmp54_ = self->priv->cells;
						_tmp54__length1 = self->priv->cells_length1;
						_tmp54__length2 = self->priv->cells_length2;
						_tmp55_ = _data6_->cell_row;
						_tmp56_ = col_tmp;
						_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
						sudoku_cell_view_set_background_color (_tmp57_, &highlight_color);
					} else {
						SudokuCellView** _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp58__length2 = 0;
						gint _tmp59_ = 0;
						gint _tmp60_ = 0;
						SudokuCellView* _tmp61_ = NULL;
						_tmp58_ = self->priv->cells;
						_tmp58__length1 = self->priv->cells_length1;
						_tmp58__length2 = self->priv->cells_length2;
						_tmp59_ = _data6_->cell_row;
						_tmp60_ = col_tmp;
						_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
						sudoku_cell_view_set_background_color (_tmp61_, &free_cell_color);
					}
				}
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp62_ = NULL;
		SudokuBoard* _tmp63_ = NULL;
		GeeMap* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		SudokuGame* _tmp66_ = NULL;
		SudokuBoard* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		SudokuGame* _tmp71_ = NULL;
		SudokuBoard* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		Coord _tmp75_ = {0};
		gpointer _tmp76_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp77_ = NULL;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gint _coord_index = 0;
		_tmp62_ = _data5_->game;
		_tmp63_ = _tmp62_->board;
		_tmp64_ = _tmp63_->coords_for_block;
		_tmp65_ = _data6_->cell_row;
		_tmp66_ = _data5_->game;
		_tmp67_ = _tmp66_->board;
		_tmp68_ = sudoku_board_get_block_rows (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = _data6_->cell_col;
		_tmp71_ = _data5_->game;
		_tmp72_ = _tmp71_->board;
		_tmp73_ = sudoku_board_get_block_cols (_tmp72_);
		_tmp74_ = _tmp73_;
		coord_init (&_tmp75_, _tmp65_ / _tmp69_, _tmp70_ / _tmp74_);
		_tmp76_ = gee_map_get (_tmp64_, &_tmp75_);
		_coord_list = (GeeList*) _tmp76_;
		_tmp77_ = _coord_list;
		_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		_coord_size = _tmp79_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			gint _tmp82_ = 0;
			Coord* coord = NULL;
			GeeList* _tmp83_ = NULL;
			gint _tmp84_ = 0;
			gpointer _tmp85_ = NULL;
			SudokuCellView** _tmp86_ = NULL;
			gint _tmp86__length1 = 0;
			gint _tmp86__length2 = 0;
			Coord* _tmp87_ = NULL;
			gint _tmp88_ = 0;
			Coord* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			SudokuCellView* _tmp91_ = NULL;
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_ = FALSE;
			_tmp80_ = _coord_index;
			_coord_index = _tmp80_ + 1;
			_tmp81_ = _coord_index;
			_tmp82_ = _coord_size;
			if (!(_tmp81_ < _tmp82_)) {
				break;
			}
			_tmp83_ = _coord_list;
			_tmp84_ = _coord_index;
			_tmp85_ = gee_list_get (_tmp83_, _tmp84_);
			coord = (Coord*) _tmp85_;
			_tmp86_ = self->priv->cells;
			_tmp86__length1 = self->priv->cells_length1;
			_tmp86__length2 = self->priv->cells_length2;
			_tmp87_ = coord;
			_tmp88_ = (*_tmp87_).row;
			_tmp89_ = coord;
			_tmp90_ = (*_tmp89_).col;
			_tmp91_ = _tmp86_[(_tmp88_ * _tmp86__length2) + _tmp90_];
			_tmp92_ = sudoku_cell_view_get_is_fixed (_tmp91_);
			_tmp93_ = _tmp92_;
			if (_tmp93_) {
				SudokuCellView** _tmp94_ = NULL;
				gint _tmp94__length1 = 0;
				gint _tmp94__length2 = 0;
				Coord* _tmp95_ = NULL;
				gint _tmp96_ = 0;
				Coord* _tmp97_ = NULL;
				gint _tmp98_ = 0;
				SudokuCellView* _tmp99_ = NULL;
				_tmp94_ = self->priv->cells;
				_tmp94__length1 = self->priv->cells_length1;
				_tmp94__length2 = self->priv->cells_length2;
				_tmp95_ = coord;
				_tmp96_ = (*_tmp95_).row;
				_tmp97_ = coord;
				_tmp98_ = (*_tmp97_).col;
				_tmp99_ = _tmp94_[(_tmp96_ * _tmp94__length2) + _tmp98_];
				sudoku_cell_view_set_background_color (_tmp99_, &fixed_cell_color);
			} else {
				gboolean _tmp100_ = FALSE;
				_tmp100_ = self->priv->_highlighter;
				if (_tmp100_) {
					SudokuCellView** _tmp101_ = NULL;
					gint _tmp101__length1 = 0;
					gint _tmp101__length2 = 0;
					Coord* _tmp102_ = NULL;
					gint _tmp103_ = 0;
					Coord* _tmp104_ = NULL;
					gint _tmp105_ = 0;
					SudokuCellView* _tmp106_ = NULL;
					_tmp101_ = self->priv->cells;
					_tmp101__length1 = self->priv->cells_length1;
					_tmp101__length2 = self->priv->cells_length2;
					_tmp102_ = coord;
					_tmp103_ = (*_tmp102_).row;
					_tmp104_ = coord;
					_tmp105_ = (*_tmp104_).col;
					_tmp106_ = _tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_];
					sudoku_cell_view_set_background_color (_tmp106_, &highlight_color);
				} else {
					SudokuCellView** _tmp107_ = NULL;
					gint _tmp107__length1 = 0;
					gint _tmp107__length2 = 0;
					Coord* _tmp108_ = NULL;
					gint _tmp109_ = 0;
					Coord* _tmp110_ = NULL;
					gint _tmp111_ = 0;
					SudokuCellView* _tmp112_ = NULL;
					_tmp107_ = self->priv->cells;
					_tmp107__length1 = self->priv->cells_length1;
					_tmp107__length2 = self->priv->cells_length2;
					_tmp108_ = coord;
					_tmp109_ = (*_tmp108_).row;
					_tmp110_ = coord;
					_tmp111_ = (*_tmp110_).col;
					_tmp112_ = _tmp107_[(_tmp109_ * _tmp107__length2) + _tmp111_];
					sudoku_cell_view_set_background_color (_tmp112_, &free_cell_color);
				}
			}
			_g_free0 (coord);
		}
		_g_object_unref0 (_coord_list);
	}
	_tmp113_ = self->priv->cells;
	_tmp113__length1 = self->priv->cells_length1;
	_tmp113__length2 = self->priv->cells_length2;
	_tmp114_ = _data6_->cell_row;
	_tmp115_ = _data6_->cell_col;
	_tmp116_ = _tmp113_[(_tmp114_ * _tmp113__length2) + _tmp115_];
	sudoku_cell_view_set_background_color (_tmp116_, &selected_bg_color);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = ________lambda13_ (self);
	return result;
}


static void ________lambda14_ (Block6Data* _data6_, GObject* s, GParamSpec* p) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp3_ = self->priv->_show_possibilities;
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->_show_warnings;
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = _data5_->game;
		_tmp6_ = _tmp5_->board;
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = self->priv->previous_board_broken_state;
		_tmp0_ = _tmp9_;
	}
	if (_tmp0_) {
		SudokuGame* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = _data5_->game;
		_tmp11_ = _tmp10_->board;
		_tmp12_ = sudoku_board_get_broken (_tmp11_);
		_tmp13_ = _tmp12_;
		self->priv->previous_board_broken_state = _tmp13_;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void _________lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	________lambda14_ (self, _sender, pspec);
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game) {
	SudokuView * self = NULL;
	Block5Data* _data5_;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	GtkOverlay* _tmp2_ = NULL;
	GtkOverlay* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuBoard* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	SudokuGame* _tmp20_ = NULL;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuCellView** _tmp24_ = NULL;
	GtkOverlay* _tmp61_ = NULL;
	GtkDrawingArea* _tmp62_ = NULL;
	GtkOverlay* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkDrawingArea* _tmp65_ = NULL;
	GtkGrid* _tmp66_ = NULL;
	GtkOverlay* _tmp67_ = NULL;
	g_return_val_if_fail (game != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->game);
	_data5_->game = _tmp1_;
	self = (SudokuView*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp2_;
	_tmp3_ = self->priv->overlay;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->drawing);
	self->priv->drawing = _tmp4_;
	_tmp5_ = self->priv->drawing;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
	_tmp6_ = self->priv->grid;
	if (_tmp6_ != NULL) {
		GtkOverlay* _tmp7_ = NULL;
		GtkGrid* _tmp8_ = NULL;
		_tmp7_ = self->priv->overlay;
		_tmp8_ = self->priv->grid;
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	}
	_tmp9_ = _data5_->game;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->game);
	self->game = _tmp10_;
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp11_;
	_tmp12_ = self->priv->grid;
	gtk_grid_set_row_spacing (_tmp12_, 1);
	_tmp13_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp13_, 1);
	_tmp14_ = self->priv->grid;
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
	_tmp15_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp15_, TRUE);
	_tmp16_ = _data5_->game;
	_tmp17_ = _tmp16_->board;
	_tmp18_ = sudoku_board_get_rows (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _data5_->game;
	_tmp21_ = _tmp20_->board;
	_tmp22_ = sudoku_board_get_cols (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_new0 (SudokuCellView*, (_tmp19_ * _tmp23_) + 1);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->cells = _tmp24_;
	self->priv->cells_length1 = _tmp19_;
	self->priv->cells_length2 = _tmp23_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gint _tmp27_ = 0;
				SudokuGame* _tmp28_ = NULL;
				SudokuBoard* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				if (!_tmp25_) {
					gint _tmp26_ = 0;
					_tmp26_ = row;
					row = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = row;
				_tmp28_ = _data5_->game;
				_tmp29_ = _tmp28_->board;
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!(_tmp27_ < _tmp31_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							Block6Data* _data6_;
							gint _tmp34_ = 0;
							SudokuGame* _tmp35_ = NULL;
							SudokuBoard* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							SudokuCellView* cell = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							SudokuCellView* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							GdkRGBA _tmp44_ = {0};
							SudokuCellView* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuCellView* _tmp48_ = NULL;
							SudokuCellView* _tmp49_ = NULL;
							SudokuCellView* _tmp50_ = NULL;
							SudokuCellView** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp51__length2 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							SudokuCellView* _tmp54_ = NULL;
							SudokuCellView* _tmp55_ = NULL;
							SudokuCellView* _tmp56_ = NULL;
							GtkGrid* _tmp57_ = NULL;
							SudokuCellView* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							_data6_ = g_slice_new0 (Block6Data);
							_data6_->_ref_count_ = 1;
							_data6_->_data5_ = block5_data_ref (_data5_);
							if (!_tmp32_) {
								gint _tmp33_ = 0;
								_tmp33_ = col;
								col = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = col;
							_tmp35_ = _data5_->game;
							_tmp36_ = _tmp35_->board;
							_tmp37_ = sudoku_board_get_cols (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!(_tmp34_ < _tmp38_)) {
								block6_data_unref (_data6_);
								_data6_ = NULL;
								break;
							}
							_tmp39_ = row;
							_tmp40_ = col;
							_tmp41_ = sudoku_cell_view_new (_tmp39_, _tmp40_, &self->game);
							g_object_ref_sink (_tmp41_);
							cell = _tmp41_;
							_tmp42_ = row;
							_data6_->cell_row = _tmp42_;
							_tmp43_ = col;
							_data6_->cell_col = _tmp43_;
							_tmp45_ = cell;
							_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
							_tmp47_ = _tmp46_;
							if (_tmp47_) {
								_tmp44_ = fixed_cell_color;
							} else {
								_tmp44_ = free_cell_color;
							}
							_tmp48_ = cell;
							sudoku_cell_view_set_background_color (_tmp48_, &_tmp44_);
							_tmp49_ = cell;
							g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) _________lambda13__gtk_widget_focus_in_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							_tmp50_ = cell;
							g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) _________lambda14__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							_tmp51_ = self->priv->cells;
							_tmp51__length1 = self->priv->cells_length1;
							_tmp51__length2 = self->priv->cells_length2;
							_tmp52_ = row;
							_tmp53_ = col;
							_tmp54_ = cell;
							_tmp55_ = _g_object_ref0 (_tmp54_);
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
							_tmp57_ = self->priv->grid;
							_tmp58_ = cell;
							_tmp59_ = col;
							_tmp60_ = row;
							gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, _tmp59_, _tmp60_, 1, 1);
							_g_object_unref0 (cell);
							block6_data_unref (_data6_);
							_data6_ = NULL;
						}
					}
				}
			}
		}
	}
	_tmp61_ = self->priv->overlay;
	_tmp62_ = self->priv->drawing;
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = self->priv->overlay;
	_tmp64_ = self->priv->grid;
	gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp64_);
	_tmp65_ = self->priv->drawing;
	gtk_widget_show ((GtkWidget*) _tmp65_);
	_tmp66_ = self->priv->grid;
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
	_tmp67_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp67_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}


SudokuView* sudoku_view_new (SudokuGame* game) {
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
}


static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c) {
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble tile_length = 0.0;
	gint _tmp2_ = 0;
	SudokuGame* _tmp3_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextDirection _tmp7_ = 0;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp88_ = NULL;
	cairo_t* _tmp89_ = NULL;
	cairo_t* _tmp90_ = NULL;
	cairo_t* _tmp127_ = NULL;
	SudokuGame* _tmp128_ = NULL;
	gboolean _tmp129_ = FALSE;
	gboolean _tmp130_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->grid;
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
	board_length = _tmp1_;
	_tmp2_ = board_length;
	_tmp3_ = self->game;
	_tmp4_ = _tmp3_->board;
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
	_tmp6_ = _tmp5_;
	tile_length = ((gdouble) (_tmp2_ - 1)) / _tmp6_;
	_tmp7_ = gtk_widget_get_default_direction ();
	if (_tmp7_ == GTK_TEXT_DIR_RTL) {
		cairo_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		cairo_t* _tmp10_ = NULL;
		_tmp8_ = c;
		_tmp9_ = board_length;
		cairo_translate (_tmp8_, (gdouble) _tmp9_, (gdouble) 0);
		_tmp10_ = c;
		cairo_scale (_tmp10_, (gdouble) -1, (gdouble) 1);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				SudokuGame* _tmp14_ = NULL;
				SudokuBoard* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = self->game;
				_tmp15_ = _tmp14_->board;
				_tmp16_ = sudoku_board_get_cols (_tmp15_);
				_tmp17_ = _tmp16_;
				if (!(_tmp13_ < _tmp17_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							gint _tmp20_ = 0;
							SudokuGame* _tmp21_ = NULL;
							SudokuBoard* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							GdkRGBA _tmp29_ = {0};
							GdkRGBA _tmp30_ = {0};
							cairo_t* _tmp31_ = NULL;
							GdkRGBA _tmp32_ = {0};
							gdouble _tmp33_ = 0.0;
							GdkRGBA _tmp34_ = {0};
							gdouble _tmp35_ = 0.0;
							GdkRGBA _tmp36_ = {0};
							gdouble _tmp37_ = 0.0;
							cairo_t* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gdouble _tmp40_ = 0.0;
							gint _tmp41_ = 0;
							gdouble _tmp42_ = 0.0;
							gint _tmp43_ = 0;
							gdouble _tmp44_ = 0.0;
							gint _tmp45_ = 0;
							gdouble _tmp46_ = 0.0;
							cairo_t* _tmp47_ = NULL;
							if (!_tmp18_) {
								gint _tmp19_ = 0;
								_tmp19_ = j;
								j = _tmp19_ + 1;
							}
							_tmp18_ = FALSE;
							_tmp20_ = j;
							_tmp21_ = self->game;
							_tmp22_ = _tmp21_->board;
							_tmp23_ = sudoku_board_get_cols (_tmp22_);
							_tmp24_ = _tmp23_;
							if (!(_tmp20_ < _tmp24_)) {
								break;
							}
							_tmp25_ = self->priv->cells;
							_tmp25__length1 = self->priv->cells_length1;
							_tmp25__length2 = self->priv->cells_length2;
							_tmp26_ = i;
							_tmp27_ = j;
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
							sudoku_cell_view_get_background_color (_tmp28_, &_tmp29_);
							_tmp30_ = _tmp29_;
							background_color = _tmp30_;
							_tmp31_ = c;
							_tmp32_ = background_color;
							_tmp33_ = _tmp32_.red;
							_tmp34_ = background_color;
							_tmp35_ = _tmp34_.green;
							_tmp36_ = background_color;
							_tmp37_ = _tmp36_.blue;
							cairo_set_source_rgb (_tmp31_, _tmp33_, _tmp35_, _tmp37_);
							_tmp38_ = c;
							_tmp39_ = j;
							_tmp40_ = tile_length;
							_tmp41_ = i;
							_tmp42_ = tile_length;
							_tmp43_ = j;
							_tmp44_ = tile_length;
							_tmp45_ = i;
							_tmp46_ = tile_length;
							cairo_rectangle (_tmp38_, ((gint) (_tmp39_ * _tmp40_)) + 0.5, ((gint) (_tmp41_ * _tmp42_)) + 0.5, ((gint) ((_tmp43_ + 1) * _tmp44_)) + 0.5, ((gint) ((_tmp45_ + 1) * _tmp46_)) + 0.5);
							_tmp47_ = c;
							cairo_fill (_tmp47_);
						}
					}
				}
			}
		}
	}
	_tmp48_ = c;
	cairo_set_line_width (_tmp48_, (gdouble) 1);
	_tmp49_ = c;
	cairo_set_source_rgb (_tmp49_, 0.6, 0.6, 0.6);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				gint _tmp52_ = 0;
				SudokuGame* _tmp53_ = NULL;
				SudokuBoard* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				SudokuGame* _tmp58_ = NULL;
				SudokuBoard* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				cairo_t* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gdouble _tmp64_ = 0.0;
				cairo_t* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gdouble _tmp67_ = 0.0;
				gint _tmp68_ = 0;
				if (!_tmp50_) {
					gint _tmp51_ = 0;
					_tmp51_ = i;
					i = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp52_ = i;
				_tmp53_ = self->game;
				_tmp54_ = _tmp53_->board;
				_tmp55_ = sudoku_board_get_cols (_tmp54_);
				_tmp56_ = _tmp55_;
				if (!(_tmp52_ < _tmp56_)) {
					break;
				}
				_tmp57_ = i;
				_tmp58_ = self->game;
				_tmp59_ = _tmp58_->board;
				_tmp60_ = sudoku_board_get_block_cols (_tmp59_);
				_tmp61_ = _tmp60_;
				if ((_tmp57_ % _tmp61_) == 0) {
					continue;
				}
				_tmp62_ = c;
				_tmp63_ = i;
				_tmp64_ = tile_length;
				cairo_move_to (_tmp62_, ((gint) (_tmp63_ * _tmp64_)) + 0.5, (gdouble) 1);
				_tmp65_ = c;
				_tmp66_ = i;
				_tmp67_ = tile_length;
				_tmp68_ = board_length;
				cairo_line_to (_tmp65_, ((gint) (_tmp66_ * _tmp67_)) + 0.5, (gdouble) _tmp68_);
			}
		}
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp69_ = FALSE;
			_tmp69_ = TRUE;
			while (TRUE) {
				gint _tmp71_ = 0;
				SudokuGame* _tmp72_ = NULL;
				SudokuBoard* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				SudokuGame* _tmp77_ = NULL;
				SudokuBoard* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				cairo_t* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gdouble _tmp83_ = 0.0;
				cairo_t* _tmp84_ = NULL;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gdouble _tmp87_ = 0.0;
				if (!_tmp69_) {
					gint _tmp70_ = 0;
					_tmp70_ = i;
					i = _tmp70_ + 1;
				}
				_tmp69_ = FALSE;
				_tmp71_ = i;
				_tmp72_ = self->game;
				_tmp73_ = _tmp72_->board;
				_tmp74_ = sudoku_board_get_cols (_tmp73_);
				_tmp75_ = _tmp74_;
				if (!(_tmp71_ < _tmp75_)) {
					break;
				}
				_tmp76_ = i;
				_tmp77_ = self->game;
				_tmp78_ = _tmp77_->board;
				_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
				_tmp80_ = _tmp79_;
				if ((_tmp76_ % _tmp80_) == 0) {
					continue;
				}
				_tmp81_ = c;
				_tmp82_ = i;
				_tmp83_ = tile_length;
				cairo_move_to (_tmp81_, (gdouble) 1, ((gint) (_tmp82_ * _tmp83_)) + 0.5);
				_tmp84_ = c;
				_tmp85_ = board_length;
				_tmp86_ = i;
				_tmp87_ = tile_length;
				cairo_line_to (_tmp84_, (gdouble) _tmp85_, ((gint) (_tmp86_ * _tmp87_)) + 0.5);
			}
		}
	}
	_tmp88_ = c;
	cairo_stroke (_tmp88_);
	_tmp89_ = c;
	cairo_set_line_width (_tmp89_, (gdouble) 2);
	_tmp90_ = c;
	cairo_set_source_rgb (_tmp90_, 0.0, 0.0, 0.0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp91_ = FALSE;
			_tmp91_ = TRUE;
			while (TRUE) {
				gint _tmp97_ = 0;
				SudokuGame* _tmp98_ = NULL;
				SudokuBoard* _tmp99_ = NULL;
				gint _tmp100_ = 0;
				gint _tmp101_ = 0;
				cairo_t* _tmp102_ = NULL;
				gint _tmp103_ = 0;
				gdouble _tmp104_ = 0.0;
				cairo_t* _tmp105_ = NULL;
				gint _tmp106_ = 0;
				gdouble _tmp107_ = 0.0;
				gint _tmp108_ = 0;
				if (!_tmp91_) {
					gint _tmp92_ = 0;
					SudokuGame* _tmp93_ = NULL;
					SudokuBoard* _tmp94_ = NULL;
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
					_tmp92_ = i;
					_tmp93_ = self->game;
					_tmp94_ = _tmp93_->board;
					_tmp95_ = sudoku_board_get_block_cols (_tmp94_);
					_tmp96_ = _tmp95_;
					i = _tmp92_ + _tmp96_;
				}
				_tmp91_ = FALSE;
				_tmp97_ = i;
				_tmp98_ = self->game;
				_tmp99_ = _tmp98_->board;
				_tmp100_ = sudoku_board_get_cols (_tmp99_);
				_tmp101_ = _tmp100_;
				if (!(_tmp97_ <= _tmp101_)) {
					break;
				}
				_tmp102_ = c;
				_tmp103_ = i;
				_tmp104_ = tile_length;
				cairo_move_to (_tmp102_, ((gint) (_tmp103_ * _tmp104_)) + 0.5, (gdouble) 0);
				_tmp105_ = c;
				_tmp106_ = i;
				_tmp107_ = tile_length;
				_tmp108_ = board_length;
				cairo_line_to (_tmp105_, ((gint) (_tmp106_ * _tmp107_)) + 0.5, (gdouble) _tmp108_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp109_ = FALSE;
			_tmp109_ = TRUE;
			while (TRUE) {
				gint _tmp115_ = 0;
				SudokuGame* _tmp116_ = NULL;
				SudokuBoard* _tmp117_ = NULL;
				gint _tmp118_ = 0;
				gint _tmp119_ = 0;
				cairo_t* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				gdouble _tmp122_ = 0.0;
				cairo_t* _tmp123_ = NULL;
				gint _tmp124_ = 0;
				gint _tmp125_ = 0;
				gdouble _tmp126_ = 0.0;
				if (!_tmp109_) {
					gint _tmp110_ = 0;
					SudokuGame* _tmp111_ = NULL;
					SudokuBoard* _tmp112_ = NULL;
					gint _tmp113_ = 0;
					gint _tmp114_ = 0;
					_tmp110_ = i;
					_tmp111_ = self->game;
					_tmp112_ = _tmp111_->board;
					_tmp113_ = sudoku_board_get_block_rows (_tmp112_);
					_tmp114_ = _tmp113_;
					i = _tmp110_ + _tmp114_;
				}
				_tmp109_ = FALSE;
				_tmp115_ = i;
				_tmp116_ = self->game;
				_tmp117_ = _tmp116_->board;
				_tmp118_ = sudoku_board_get_cols (_tmp117_);
				_tmp119_ = _tmp118_;
				if (!(_tmp115_ <= _tmp119_)) {
					break;
				}
				_tmp120_ = c;
				_tmp121_ = i;
				_tmp122_ = tile_length;
				cairo_move_to (_tmp120_, (gdouble) 0, ((gint) (_tmp121_ * _tmp122_)) + 0.5);
				_tmp123_ = c;
				_tmp124_ = board_length;
				_tmp125_ = i;
				_tmp126_ = tile_length;
				cairo_line_to (_tmp123_, (gdouble) _tmp124_, ((gint) (_tmp125_ * _tmp126_)) + 0.5);
			}
		}
	}
	_tmp127_ = c;
	cairo_stroke (_tmp127_);
	_tmp128_ = self->game;
	_tmp129_ = sudoku_game_get_paused (_tmp128_);
	_tmp130_ = _tmp129_;
	if (_tmp130_) {
		cairo_t* _tmp131_ = NULL;
		cairo_t* _tmp132_ = NULL;
		cairo_t* _tmp133_ = NULL;
		cairo_t* _tmp134_ = NULL;
		gint _tmp135_ = 0;
		gchar* text = NULL;
		const gchar* _tmp136_ = NULL;
		gchar* _tmp137_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp138_ = NULL;
		const gchar* _tmp139_ = NULL;
		cairo_text_extents_t _tmp140_ = {0};
		cairo_t* _tmp141_ = NULL;
		gint _tmp142_ = 0;
		cairo_text_extents_t _tmp143_ = {0};
		gdouble _tmp144_ = 0.0;
		gint _tmp145_ = 0;
		cairo_text_extents_t _tmp146_ = {0};
		gdouble _tmp147_ = 0.0;
		cairo_t* _tmp148_ = NULL;
		cairo_t* _tmp149_ = NULL;
		const gchar* _tmp150_ = NULL;
		_tmp131_ = c;
		cairo_set_source_rgba (_tmp131_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp132_ = c;
		cairo_paint (_tmp132_);
		_tmp133_ = c;
		cairo_select_font_face (_tmp133_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp134_ = c;
		_tmp135_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp134_, _tmp135_ * 0.125);
		_tmp136_ = _ ("Paused");
		_tmp137_ = g_strdup (_tmp136_);
		text = _tmp137_;
		_tmp138_ = c;
		_tmp139_ = text;
		cairo_text_extents (_tmp138_, _tmp139_, &_tmp140_);
		extents = _tmp140_;
		_tmp141_ = c;
		_tmp142_ = board_length;
		_tmp143_ = extents;
		_tmp144_ = _tmp143_.width;
		_tmp145_ = board_length;
		_tmp146_ = extents;
		_tmp147_ = _tmp146_.height;
		cairo_move_to (_tmp141_, (_tmp142_ / 2.0) - (_tmp144_ / 2.0), (_tmp145_ / 2.0) + (_tmp147_ / 2.0));
		_tmp148_ = c;
		cairo_set_source_rgb (_tmp148_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp149_ = c;
		_tmp150_ = text;
		cairo_show_text (_tmp149_, _tmp150_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}


void sudoku_view_clear (SudokuView* self) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuCellView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							SudokuCellView* _tmp17_ = NULL;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = i;
							_tmp16_ = j;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							sudoku_cell_view_clear (_tmp17_);
						}
					}
				}
			}
		}
	}
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_warnings = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->game;
				_tmp5_ = _tmp4_->board;
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp3_ < _tmp7_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = j;
							_tmp11_ = self->game;
							_tmp12_ = _tmp11_->board;
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
							_tmp14_ = _tmp13_;
							if (!(_tmp10_ < _tmp14_)) {
								break;
							}
							_tmp15_ = self->priv->cells;
							_tmp15__length1 = self->priv->cells_length1;
							_tmp15__length2 = self->priv->cells_length2;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
							_tmp19_ = self->priv->_show_warnings;
							sudoku_cell_view_set_show_warnings (_tmp18_, _tmp19_);
						}
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "show-warnings");
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_possibilities;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_possibilities = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->game;
				_tmp5_ = _tmp4_->board;
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp3_ < _tmp7_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = j;
							_tmp11_ = self->game;
							_tmp12_ = _tmp11_->board;
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
							_tmp14_ = _tmp13_;
							if (!(_tmp10_ < _tmp14_)) {
								break;
							}
							_tmp15_ = self->priv->cells;
							_tmp15__length1 = self->priv->cells_length1;
							_tmp15__length2 = self->priv->cells_length2;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
							_tmp19_ = value;
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
						}
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "show-possibilities");
}


gboolean sudoku_view_get_highlighter (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_highlighter;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_highlighter (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_highlighter = _tmp0_;
	g_object_notify ((GObject *) self, "highlighter");
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER, g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sudoku_view_instance_init (SudokuView * self) {
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
	self->priv->previous_board_broken_state = FALSE;
	self->priv->selected_row = 0;
	self->priv->selected_col = 0;
	self->priv->_show_warnings = FALSE;
	self->priv->_show_possibilities = FALSE;
	self->priv->_highlighter = FALSE;
}


static void sudoku_view_finalize (GObject* obj) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
	_g_object_unref0 (self->game);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->drawing);
	_g_object_unref0 (self->priv->grid);
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SHOW_WARNINGS:
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER:
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SHOW_WARNINGS:
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER:
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



