/* rygel-media-object.c generated by valac 0.32.1, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
typedef struct _RygelMediaObjectApplyFragmentsData RygelMediaObjectApplyFragmentsData;
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	gchar* _id;
	gchar* _ref_id;
	gchar* _upnp_class;
	gchar* _date;
	gchar* _creator;
	guint64 _modified;
	guint _object_update_id;
	gchar* _artist;
	gchar* _genre;
	GeeArrayList* uris;
	GeeList* media_resources;
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _uri_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* uri;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GFile* file;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	GFile* _tmp14_;
	GCancellable* _tmp15_;
	gboolean _tmp16_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* writables;
	GeeArrayList* _tmp0_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _uri_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _uri_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* uri;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	GFile* file;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp15_;
	GCancellable* _tmp16_;
	gboolean _tmp17_;
	GeeArrayList* _tmp18_;
	GFile* _tmp19_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	gchar* replaced_string;
};

typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaObjectApplyFragmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GeeLinkedList* current_fragments;
	GeeLinkedList* new_fragments;
	RygelHTTPServer* http_server;
	GUPnPDIDLLiteFragmentResult result;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelSerializer* writer;
	RygelSerializer* _tmp0_;
	GUPnPDIDLLiteObject* didl_object;
	RygelSerializer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteObject* _tmp4_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	GUPnPDIDLLiteObject* _tmp7_;
	xmlNs* _tmp8_;
	xmlNs* _tmp9_;
	GUPnPDIDLLiteObject* _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeLinkedList* _tmp15_;
	gint _tmp16_;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUPnPDIDLLiteFragmentResult _tmp19_;
	GUPnPDIDLLiteFragmentResult _tmp20_;
	GUPnPDIDLLiteObject* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	GFileInfo* info;
	GFile* _tmp7_;
	GCancellable* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	gboolean _tmp11_;
	GError* _error_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()

static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;
static GRegex* rygel_media_object_pretty_name_regex;
static GRegex* rygel_media_object_pretty_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_ID,
	RYGEL_MEDIA_OBJECT_REF_ID,
	RYGEL_MEDIA_OBJECT_UPNP_CLASS,
	RYGEL_MEDIA_OBJECT_DATE,
	RYGEL_MEDIA_OBJECT_CREATOR,
	RYGEL_MEDIA_OBJECT_MODIFIED,
	RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_OBJECT_ARTIST,
	RYGEL_MEDIA_OBJECT_GENRE,
	RYGEL_MEDIA_OBJECT_PARENT,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS,
	RYGEL_MEDIA_OBJECT_RESTRICTED
};
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
static void rygel_media_object_real_add_uri (RygelMediaObject* self, const gchar* uri);
static void rygel_media_object_real_constructed (GObject* base);
static void rygel_media_object_get_writable_data_free (gpointer _data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self, const gchar* resource_name);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
void rygel_media_object_serialize_resource_list (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPServer* http_server, GError** error);
GHashTable* rygel_http_server_get_replacements (RygelHTTPServer* self);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self, RygelMediaObject* object, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
void rygel_media_resource_set_import_uri (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
void rygel_http_server_set_resource_delivery_options (RygelHTTPServer* self, RygelMediaResource* res);
GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self, GUPnPDIDLLiteResource* didl_resource, GHashTable* replacements);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error);
gboolean rygel_http_server_is_local (RygelHTTPServer* self);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_, const gchar* search_string, const gchar* replacement);
static void ___lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self);
RygelDataSource* rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
static RygelDataSource* rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
static gchar* rygel_media_object_get_first (RygelMediaObject* self, GList* contributors);
void rygel_media_object_set_artist (RygelMediaObject* self, const gchar* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void rygel_media_object_set_genre (RygelMediaObject* self, const gchar* value);
static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns);
static void rygel_media_object_apply_fragments_data_free (gpointer _data);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_);
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, RygelSerializerType type);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_updatable_object_commit (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_updatable_object_commit_finish (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
const gchar* rygel_media_object_get_genre (RygelMediaObject* self);
const gchar* rygel_media_object_get_creator (RygelMediaObject* self);
static gint rygel_media_object_compare_by_date (RygelMediaObject* self, RygelMediaObject* object);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_media_object_get_date (RygelMediaObject* self);
static gint rygel_media_object_compare_long (RygelMediaObject* self, glong a, glong b);
GQuark rygel_media_item_error_quark (void);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_internal_protocol_schemes (RygelMediaEngine* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_creator (RygelMediaObject* self, const gchar* value);
guint64 rygel_media_object_get_modified (RygelMediaObject* self);
void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_object_finalize (GObject* obj);
static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeList* rygel_media_object_get_uris (RygelMediaObject* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self) {
	gchar* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->uris;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	result = (gchar*) _tmp4_;
	return result;
}


static void rygel_media_object_real_add_uri (RygelMediaObject* self, const gchar* uri) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = uri;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
}


void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->add_uri (self, uri);
}


static void rygel_media_object_real_constructed (GObject* base) {
	RygelMediaObject * self;
	GeeArrayList* _tmp0_ = NULL;
	self = (RygelMediaObject*) base;
	G_OBJECT_CLASS (rygel_media_object_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->uris);
	self->priv->uris = _tmp0_;
}


static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_object_get_writable_co (_data_);
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_get_writable_co (_data_);
}


static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->priv->uris;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
		_data_->_uri_list = _data_->_tmp1_;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_uri_list;
		_data_->_tmp3_ = 0;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_uri_size = _data_->_tmp4_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp5_ = 0;
			_data_->_tmp5_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp5_ + 1;
			_data_->_tmp6_ = 0;
			_data_->_tmp6_ = _data_->_uri_index;
			_data_->_tmp7_ = 0;
			_data_->_tmp7_ = _data_->_uri_size;
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->_uri_list;
			_data_->_tmp9_ = 0;
			_data_->_tmp9_ = _data_->_uri_index;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_tmp9_);
			_data_->uri = (gchar*) _data_->_tmp10_;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->uri;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_file_new_for_uri (_data_->_tmp11_);
			_data_->file = _data_->_tmp12_;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->file;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->cancellable;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp14_, _data_->_tmp15_, rygel_media_object_get_writable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp16_ = FALSE;
			_data_->_tmp16_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp13_ = _data_->_tmp16_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp13_) {
				_data_->result = _data_->file;
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_object_get_writables_data_free (gpointer _data) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
}


void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writables);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_object_get_writables_co (_data_);
}


GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_get_writables_co (_data_);
}


static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_data_->writables = _data_->_tmp0_;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->uris;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_uri_list = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_uri_list;
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_uri_size = _data_->_tmp5_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = 0;
			_data_->_tmp6_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = 0;
			_data_->_tmp7_ = _data_->_uri_index;
			_data_->_tmp8_ = 0;
			_data_->_tmp8_ = _data_->_uri_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_uri_list;
			_data_->_tmp10_ = 0;
			_data_->_tmp10_ = _data_->_uri_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->uri = (gchar*) _data_->_tmp11_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->uri;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
			_data_->file = _data_->_tmp13_;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->file;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->cancellable;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp15_, _data_->_tmp16_, rygel_media_object_get_writables_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp17_ = FALSE;
			_data_->_tmp17_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp14_ = _data_->_tmp17_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				_g_object_unref0 (_data_->writables);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp14_) {
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->writables;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _data_->file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp18_, _data_->_tmp19_);
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = _data_->writables;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->writables);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Return the MediaResource list.
     */
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->media_resources;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self, const gchar* resource_name) {
	RygelMediaResource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (resource_name != NULL, NULL);
	{
		GeeList* _resource_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _resource_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _resource_index = 0;
		_tmp0_ = self->priv->media_resources;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_resource_list = _tmp1_;
		_tmp2_ = _resource_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_resource_size = _tmp4_;
		_resource_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelMediaResource* resource = NULL;
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			RygelMediaResource* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			_tmp5_ = _resource_index;
			_resource_index = _tmp5_ + 1;
			_tmp6_ = _resource_index;
			_tmp7_ = _resource_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _resource_list;
			_tmp9_ = _resource_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			resource = (RygelMediaResource*) _tmp10_;
			_tmp11_ = resource;
			_tmp12_ = rygel_media_resource_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = resource_name;
			_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
			_g_free0 (_tmp13_);
			if (_tmp15_) {
				result = resource;
				_g_object_unref0 (_resource_list);
				return result;
			}
			_g_object_unref0 (resource);
		}
		_g_object_unref0 (_resource_list);
	}
	result = NULL;
	return result;
}


static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, serializer, http_server, error);
}


/**
     * Serialize the resource list
     *
     * Any resource with an empty URIs will get a resource-based HTTP URI and have its protocol
     * and delivery options adjusted to the HTTPServer.
     *
     * Internal (e.g. "file:") resources will only be included when the http server
     * is on the local host.
     *
     * Resources will be serialized in list order.
     */
void rygel_media_object_serialize_resource_list (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPServer* http_server, GError** error) {
	GHashTable* replacements = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_object != NULL);
	g_return_if_fail (http_server != NULL);
	_tmp0_ = http_server;
	_tmp1_ = rygel_http_server_get_replacements (_tmp0_);
	replacements = _tmp1_;
	{
		GeeList* _res_list = NULL;
		GeeList* _tmp2_ = NULL;
		gint _res_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _res_index = 0;
		_tmp2_ = rygel_media_object_get_resource_list (self);
		_res_list = _tmp2_;
		_tmp3_ = _res_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_res_size = _tmp5_;
		_res_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelMediaResource* res = NULL;
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			RygelMediaResource* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp6_ = _res_index;
			_res_index = _tmp6_ + 1;
			_tmp7_ = _res_index;
			_tmp8_ = _res_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _res_list;
			_tmp10_ = _res_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			res = (RygelMediaResource*) _tmp11_;
			_tmp13_ = res;
			_tmp14_ = rygel_media_resource_get_uri (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == NULL) {
				_tmp12_ = TRUE;
			} else {
				RygelMediaResource* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				_tmp16_ = res;
				_tmp17_ = rygel_media_resource_get_uri (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp12_ = g_strcmp0 (_tmp18_, "") == 0;
			}
			if (_tmp12_) {
				gchar* uri = NULL;
				RygelHTTPServer* _tmp19_ = NULL;
				RygelMediaResource* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				GUPnPDIDLLiteResource* didl_resource = NULL;
				GUPnPDIDLLiteObject* _tmp32_ = NULL;
				GUPnPDIDLLiteResource* _tmp33_ = NULL;
				RygelHTTPServer* _tmp34_ = NULL;
				RygelMediaResource* _tmp35_ = NULL;
				RygelMediaResource* _tmp36_ = NULL;
				GUPnPDIDLLiteResource* _tmp37_ = NULL;
				GHashTable* _tmp38_ = NULL;
				GUPnPDIDLLiteResource* _tmp39_ = NULL;
				GUPnPDIDLLiteResource* _tmp40_ = NULL;
				RygelMediaResource* _tmp41_ = NULL;
				RygelMediaResource* _tmp42_ = NULL;
				_tmp19_ = http_server;
				_tmp20_ = res;
				_tmp21_ = rygel_media_resource_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = rygel_http_server_create_uri_for_object (_tmp19_, self, -1, -1, _tmp22_);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp22_);
				uri = _tmp24_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
					_tmp26_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) self) : NULL);
					_tmp27_ = _tmp26_;
					_tmp25_ = _tmp27_;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					RygelMediaResource* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					_tmp28_ = res;
					_tmp29_ = uri;
					rygel_media_resource_set_import_uri (_tmp28_, _tmp29_);
				} else {
					RygelMediaResource* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					_tmp30_ = res;
					_tmp31_ = uri;
					rygel_media_resource_set_uri (_tmp30_, _tmp31_);
				}
				_tmp32_ = didl_object;
				_tmp33_ = gupnp_didl_lite_object_add_resource (_tmp32_);
				didl_resource = _tmp33_;
				_tmp34_ = http_server;
				_tmp35_ = res;
				rygel_http_server_set_resource_delivery_options (_tmp34_, _tmp35_);
				_tmp36_ = res;
				_tmp37_ = didl_resource;
				_tmp38_ = replacements;
				_tmp39_ = rygel_media_resource_serialize (_tmp36_, _tmp37_, _tmp38_);
				_tmp40_ = _tmp39_;
				_g_object_unref0 (_tmp40_);
				_tmp41_ = res;
				rygel_media_resource_set_uri (_tmp41_, NULL);
				_tmp42_ = res;
				rygel_media_resource_set_import_uri (_tmp42_, NULL);
				_g_object_unref0 (didl_resource);
				_g_free0 (uri);
			} else {
				{
					gchar* protocol = NULL;
					RygelMediaResource* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gboolean _tmp47_ = FALSE;
					const gchar* _tmp48_ = NULL;
					_tmp43_ = res;
					_tmp44_ = rygel_media_resource_get_uri (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = rygel_media_object_get_protocol_for_uri (self, _tmp45_, &_inner_error_);
					protocol = _tmp46_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch14_g_error;
					}
					_tmp48_ = protocol;
					if (_tmp48_ != NULL) {
						gboolean _tmp49_ = FALSE;
						const gchar* _tmp50_ = NULL;
						_tmp50_ = protocol;
						if (g_strcmp0 (_tmp50_, "internal") != 0) {
							_tmp49_ = TRUE;
						} else {
							RygelHTTPServer* _tmp51_ = NULL;
							gboolean _tmp52_ = FALSE;
							_tmp51_ = http_server;
							_tmp52_ = rygel_http_server_is_local (_tmp51_);
							_tmp49_ = _tmp52_;
						}
						_tmp47_ = _tmp49_;
					} else {
						_tmp47_ = FALSE;
					}
					if (_tmp47_) {
						GUPnPDIDLLiteResource* didl_resource = NULL;
						GUPnPDIDLLiteObject* _tmp53_ = NULL;
						GUPnPDIDLLiteResource* _tmp54_ = NULL;
						RygelMediaResource* _tmp55_ = NULL;
						GUPnPDIDLLiteResource* _tmp56_ = NULL;
						GHashTable* _tmp57_ = NULL;
						GUPnPDIDLLiteResource* _tmp58_ = NULL;
						GUPnPDIDLLiteResource* _tmp59_ = NULL;
						_tmp53_ = didl_object;
						_tmp54_ = gupnp_didl_lite_object_add_resource (_tmp53_);
						didl_resource = _tmp54_;
						_tmp55_ = res;
						_tmp56_ = didl_resource;
						_tmp57_ = replacements;
						_tmp58_ = rygel_media_resource_serialize (_tmp55_, _tmp56_, _tmp57_);
						_tmp59_ = _tmp58_;
						_g_object_unref0 (_tmp59_);
						_g_object_unref0 (didl_resource);
					}
					_g_free0 (protocol);
				}
				goto __finally14;
				__catch14_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp60_ = NULL;
					RygelMediaResource* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					const gchar* _tmp63_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp60_ = _ ("Could not determine protocol for %s");
					_tmp61_ = res;
					_tmp62_ = rygel_media_resource_get_uri (_tmp61_);
					_tmp63_ = _tmp62_;
					g_warning (_tmp60_, _tmp63_);
					_g_error_free0 (e);
				}
				__finally14:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (res);
					_g_object_unref0 (_res_list);
					_g_hash_table_unref0 (replacements);
					return;
				}
			}
			_g_object_unref0 (res);
		}
		_g_object_unref0 (_res_list);
	}
	_g_hash_table_unref0 (replacements);
}


/**
     * Replace each key in replacement_pairs with its corresponding
     * value in the source_string and return the result.
     *
     * @param replacement_pairs HashTable of variable -> substitution pairs
     * @param source_string String that shall have the replacements applied
     * to.
     *
     * @return null if source_string is null, string with all replacements
     * applied otherwise.
     */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_free0 (_data4_->replaced_string);
		g_slice_free (Block4Data, _data4_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch15_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch15_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void __lambda4_ (Block4Data* _data4_, const gchar* search_string, const gchar* replacement) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (search_string != NULL);
	g_return_if_fail (replacement != NULL);
	_tmp0_ = _data4_->replaced_string;
	_tmp1_ = search_string;
	_tmp2_ = replacement;
	_tmp3_ = string_replace (_tmp0_, _tmp1_, _tmp2_);
	_g_free0 (_data4_->replaced_string);
	_data4_->replaced_string = _tmp3_;
}


static void ___lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda4_ (self, (const gchar*) key, (const gchar*) value);
}


gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string) {
	gchar* result = NULL;
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (replacement_pairs != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = source_string;
	if (_tmp0_ == NULL) {
		result = NULL;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	_tmp1_ = source_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data4_->replaced_string = _tmp2_;
	_tmp3_ = replacement_pairs;
	g_hash_table_foreach (_tmp3_, ___lambda4__gh_func, _data4_);
	_tmp4_ = _data4_->replaced_string;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


/**
     * Create a stream source for the given resource
     */
static RygelDataSource* rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_create_stream_source_for_resource'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelDataSource* rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->create_stream_source_for_resource (self, request, resource, error);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GUPnPDIDLLiteObject* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = didl_object;
	_tmp1_ = gupnp_didl_lite_object_get_title (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_media_object_set_title (self, _tmp2_);
	_tmp3_ = didl_object;
	_tmp4_ = gupnp_didl_lite_object_get_artists (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_media_object_get_first (self, _tmp5_);
	_tmp7_ = _tmp6_;
	rygel_media_object_set_artist (self, _tmp7_);
	_g_free0 (_tmp7_);
	__g_list_free__g_object_unref0_0 (_tmp5_);
	_tmp8_ = didl_object;
	_tmp9_ = gupnp_didl_lite_object_get_genre (_tmp8_);
	_tmp10_ = _tmp9_;
	rygel_media_object_set_genre (self, _tmp10_);
}


void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->apply_didl_lite (self, didl_object);
}


static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns) {
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	xmlAttr* attr = NULL;
	xmlNode* _tmp1_ = NULL;
	xmlAttr* _tmp2_ = NULL;
	xmlNode* child = NULL;
	xmlNode* _tmp26_ = NULL;
	xmlNode* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->properties;
	attr = _tmp2_;
	while (TRUE) {
		xmlAttr* _tmp3_ = NULL;
		xmlAttr* _tmp4_ = NULL;
		xmlNs* _tmp5_ = NULL;
		xmlNs* _tmp6_ = NULL;
		xmlAttr* _tmp10_ = NULL;
		xmlAttr* _tmp11_ = NULL;
		_tmp3_ = attr;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = attr;
		_tmp5_ = _tmp4_->ns;
		_tmp6_ = ns;
		if (_tmp5_ == _tmp6_) {
			GeeArrayList* _tmp7_ = NULL;
			xmlAttr* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp7_ = list;
			_tmp8_ = attr;
			_tmp9_ = _tmp8_->name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
		}
		_tmp10_ = attr;
		_tmp11_ = _tmp10_->next;
		attr = _tmp11_;
	}
	{
		GeeArrayList* _name_list = NULL;
		GeeArrayList* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		gint _name_size = 0;
		GeeArrayList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _name_index = 0;
		_tmp12_ = list;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_name_list = _tmp13_;
		_tmp14_ = _name_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_name_size = _tmp16_;
		_name_index = -1;
		while (TRUE) {
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* name = NULL;
			GeeArrayList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			xmlNode* _tmp23_ = NULL;
			xmlNs* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp17_ = _name_index;
			_name_index = _tmp17_ + 1;
			_tmp18_ = _name_index;
			_tmp19_ = _name_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _name_list;
			_tmp21_ = _name_index;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
			name = (gchar*) _tmp22_;
			_tmp23_ = node;
			_tmp24_ = ns;
			_tmp25_ = name;
			xmlUnsetNsProp (_tmp23_, _tmp24_, (xmlChar*) _tmp25_);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_list);
	}
	_tmp26_ = node;
	_tmp27_ = _tmp26_->children;
	child = _tmp27_;
	while (TRUE) {
		xmlNode* _tmp28_ = NULL;
		xmlNode* _tmp29_ = NULL;
		xmlNs* _tmp30_ = NULL;
		xmlNode* _tmp31_ = NULL;
		xmlNode* _tmp32_ = NULL;
		_tmp28_ = child;
		if (!(_tmp28_ != NULL)) {
			break;
		}
		_tmp29_ = child;
		_tmp30_ = ns;
		rygel_media_object_clean_node (self, _tmp29_, _tmp30_);
		_tmp31_ = child;
		_tmp32_ = _tmp31_->next;
		child = _tmp32_;
	}
	_g_object_unref0 (list);
}


static void rygel_media_object_apply_fragments_data_free (gpointer _data) {
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->current_fragments);
	_g_object_unref0 (_data_->new_fragments);
	_g_object_unref0 (_data_->http_server);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectApplyFragmentsData, _data_);
}


void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	RygelHTTPServer* _tmp5_ = NULL;
	RygelHTTPServer* _tmp6_ = NULL;
	_data_ = g_slice_new0 (RygelMediaObjectApplyFragmentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_apply_fragments);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_apply_fragments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = current_fragments;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->current_fragments);
	_data_->current_fragments = _tmp2_;
	_tmp3_ = new_fragments;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->new_fragments);
	_data_->new_fragments = _tmp4_;
	_tmp5_ = http_server;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->http_server);
	_data_->http_server = _tmp6_;
	rygel_media_object_apply_fragments_co (_data_);
}


GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_) {
	GUPnPDIDLLiteFragmentResult result;
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_apply_fragments_co (_data_);
}


static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = GUPNP_DIDL_LITE_FRAGMENT_RESULT_UNKNOWN_ERROR;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
		_data_->writer = _data_->_tmp0_;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->writer;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->http_server;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = rygel_media_object_serialize (_data_->self, _data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
		_data_->didl_object = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->writer);
			goto __catch16_g_error;
		}
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->didl_object;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = gupnp_didl_lite_object_get_xml_node (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->didl_object;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = gupnp_didl_lite_object_get_dlna_namespace (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		rygel_media_object_clean_node (_data_->self, _data_->_tmp6_, _data_->_tmp9_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->didl_object;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->current_fragments;
		_data_->_tmp12_ = 0;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp11_, &_data_->_tmp12_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14__length1 = 0;
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp14__length1 = _data_->_tmp12_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->new_fragments;
		_data_->_tmp16_ = 0;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp15_, &_data_->_tmp16_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18__length1 = 0;
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp18__length1 = _data_->_tmp16_;
		_data_->_tmp19_ = 0;
		_data_->_tmp19_ = gupnp_didl_lite_object_apply_fragments (_data_->_tmp10_, _data_->_tmp14_, _data_->_tmp12_, _data_->_tmp18_, _data_->_tmp16_);
		_data_->_result_ = _data_->_tmp19_;
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp20_ = 0;
		_data_->_tmp20_ = _data_->_result_;
		if (_data_->_tmp20_ == GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->didl_object;
			rygel_media_object_apply_didl_lite (_data_->self, _data_->_tmp21_);
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
				_data_->_state_ = 1;
				rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, rygel_media_object_apply_fragments_ready, _data_);
				return FALSE;
				_state_1:
				rygel_updatable_object_commit_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->didl_object);
					_g_object_unref0 (_data_->writer);
					goto __catch16_g_error;
				}
			}
		}
		_g_object_unref0 (_data_->didl_object);
		_g_object_unref0 (_data_->writer);
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->e;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		g_debug ("rygel-media-object.vala:382: Failed to apply fragments: %s. Ignoring.", _data_->_tmp23_);
		_g_error_free0 (_data_->e);
	}
	__finally16:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = property;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_ = NULL;
				RygelMediaObject* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				_tmp4_ = self->priv->_id;
				_tmp5_ = media_object;
				_tmp6_ = _tmp5_->priv->_id;
				_tmp7_ = rygel_media_object_compare_string_props (self, _tmp4_, _tmp6_);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				RygelMediaContainer* _tmp8_ = NULL;
				RygelMediaContainer* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				RygelMediaObject* _tmp11_ = NULL;
				RygelMediaContainer* _tmp12_ = NULL;
				RygelMediaContainer* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				_tmp8_ = rygel_media_object_get_parent (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = ((RygelMediaObject*) _tmp9_)->priv->_id;
				_tmp11_ = media_object;
				_tmp12_ = rygel_media_object_get_parent (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = ((RygelMediaObject*) _tmp13_)->priv->_id;
				_tmp15_ = rygel_media_object_compare_string_props (self, _tmp10_, _tmp14_);
				result = _tmp15_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				RygelMediaObject* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				_tmp16_ = rygel_media_object_get_title (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = media_object;
				_tmp19_ = rygel_media_object_get_title (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = rygel_media_object_compare_string_props (self, _tmp17_, _tmp20_);
				result = _tmp21_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp22_ = NULL;
				RygelMediaObject* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				_tmp22_ = self->priv->_upnp_class;
				_tmp23_ = media_object;
				_tmp24_ = _tmp23_->priv->_upnp_class;
				_tmp25_ = rygel_media_object_compare_string_props (self, _tmp22_, _tmp24_);
				result = _tmp25_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dc:artist")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp26_ = NULL;
				RygelMediaObject* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				_tmp26_ = self->priv->_artist;
				_tmp27_ = media_object;
				_tmp28_ = _tmp27_->priv->_artist;
				_tmp29_ = rygel_media_object_compare_string_props (self, _tmp26_, _tmp28_);
				result = _tmp29_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:genre")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp30_ = NULL;
				RygelMediaObject* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				_tmp30_ = self->priv->_genre;
				_tmp31_ = media_object;
				_tmp32_ = _tmp31_->priv->_genre;
				_tmp33_ = rygel_media_object_compare_string_props (self, _tmp30_, _tmp32_);
				result = _tmp33_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp34_ = NULL;
				RygelMediaObject* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				_tmp34_ = self->priv->_creator;
				_tmp35_ = media_object;
				_tmp36_ = _tmp35_->priv->_creator;
				_tmp37_ = rygel_media_object_compare_string_props (self, _tmp34_, _tmp36_);
				result = _tmp37_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				_tmp38_ = media_object;
				_tmp39_ = rygel_media_object_compare_by_date (self, _tmp38_);
				result = _tmp39_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
}


gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (prop1 != NULL, 0);
	g_return_val_if_fail (prop2 != NULL, 0);
	_tmp0_ = prop1;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = prop2;
		if (_tmp1_ == NULL) {
			result = 1;
			return result;
		} else {
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gint _tmp4_ = 0;
			_tmp2_ = prop1;
			_tmp3_ = prop2;
			_tmp4_ = g_utf8_collate (_tmp2_, _tmp3_);
			result = _tmp4_;
			return result;
		}
	}
}


gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = prop1;
	_tmp1_ = prop2;
	_tmp2_ = CLAMP (_tmp0_ - _tmp1_, -1, 1);
	result = _tmp2_;
	return result;
}


static void rygel_media_object_check_writable_data_free (gpointer _data) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
}


static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_check_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_media_object_check_writable_co (_data_);
}


static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_check_writable_co (_data_);
}


static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->file;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_get_uri_scheme (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = g_str_has_prefix (RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME, _data_->_tmp2_);
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	if (_data_->_tmp4_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->file;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = g_file_is_native (_data_->_tmp5_);
	if (!_data_->_tmp6_) {
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->file;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->cancellable;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp7_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp8_, rygel_media_object_check_writable_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch17_g_io_error_not_found;
			}
			goto __finally17;
		}
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->info;
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = g_file_info_get_attribute_boolean (_data_->_tmp10_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
		_data_->result = _data_->_tmp11_;
		_g_object_unref0 (_data_->info);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally17;
	__catch17_g_io_error_not_found:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = TRUE;
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally17:
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint rygel_media_object_compare_by_date (RygelMediaObject* self, RygelMediaObject* object) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (object != NULL, 0);
	_tmp0_ = self->priv->_date;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	} else {
		RygelMediaObject* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = object;
		_tmp2_ = _tmp1_->priv->_date;
		if (_tmp2_ == NULL) {
			result = 1;
			return result;
		} else {
			gchar* our_date = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* other_date = NULL;
			RygelMediaObject* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			GTimeVal tv1 = {0};
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GTimeVal tv2 = {0};
			RygelMediaObject* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			gint ret = 0;
			GTimeVal _tmp21_ = {0};
			glong _tmp22_ = 0L;
			GTimeVal _tmp23_ = {0};
			glong _tmp24_ = 0L;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			_tmp3_ = self->priv->_date;
			_tmp4_ = g_strdup (_tmp3_);
			our_date = _tmp4_;
			_tmp5_ = object;
			_tmp6_ = _tmp5_->priv->_date;
			_tmp7_ = g_strdup (_tmp6_);
			other_date = _tmp7_;
			_tmp8_ = our_date;
			_tmp9_ = string_contains (_tmp8_, "T");
			if (!_tmp9_) {
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				_tmp10_ = our_date;
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
				_g_free0 (our_date);
				our_date = _tmp11_;
			}
			_tmp12_ = other_date;
			_tmp13_ = string_contains (_tmp12_, "T");
			if (!_tmp13_) {
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp14_ = other_date;
				_tmp15_ = g_strconcat (_tmp14_, "T00:00:00Z", NULL);
				_g_free0 (other_date);
				other_date = _tmp15_;
			}
			g_get_current_time (&tv1);
			_tmp16_ = self->priv->_date;
			_tmp17_ = g_time_val_from_iso8601 (_tmp16_, &tv1);
			_vala_assert (_tmp17_, "tv1.from_iso8601 (this.date)");
			g_get_current_time (&tv2);
			_tmp18_ = object;
			_tmp19_ = _tmp18_->priv->_date;
			_tmp20_ = g_time_val_from_iso8601 (_tmp19_, &tv2);
			_vala_assert (_tmp20_, "tv2.from_iso8601 (object.date)");
			_tmp21_ = tv1;
			_tmp22_ = _tmp21_.tv_sec;
			_tmp23_ = tv2;
			_tmp24_ = _tmp23_.tv_sec;
			_tmp25_ = rygel_media_object_compare_long (self, _tmp22_, _tmp24_);
			ret = _tmp25_;
			_tmp26_ = ret;
			if (_tmp26_ == 0) {
				GTimeVal _tmp27_ = {0};
				glong _tmp28_ = 0L;
				GTimeVal _tmp29_ = {0};
				glong _tmp30_ = 0L;
				gint _tmp31_ = 0;
				_tmp27_ = tv1;
				_tmp28_ = _tmp27_.tv_usec;
				_tmp29_ = tv2;
				_tmp30_ = _tmp29_.tv_usec;
				_tmp31_ = rygel_media_object_compare_long (self, _tmp28_, _tmp30_);
				ret = _tmp31_;
			}
			result = ret;
			_g_free0 (other_date);
			_g_free0 (our_date);
			return result;
		}
	}
}


static gint rygel_media_object_compare_long (RygelMediaObject* self, glong a, glong b) {
	gint result = 0;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	if (_tmp0_ < _tmp1_) {
		result = -1;
		return result;
	} else {
		glong _tmp2_ = 0L;
		glong _tmp3_ = 0L;
		_tmp2_ = a;
		_tmp3_ = b;
		if (_tmp2_ > _tmp3_) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gchar* rygel_media_object_get_first (RygelMediaObject* self, GList* contributors) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contributors;
	if (_tmp0_ != NULL) {
		GList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = contributors;
		_tmp2_ = _tmp1_->data;
		_tmp3_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_strdup ("");
	result = _tmp6_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	gchar* scheme = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaEngine* engine = NULL;
	RygelMediaEngine* _tmp6_ = NULL;
	GList* schemes = NULL;
	RygelMediaEngine* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GCompareFunc _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
	scheme = _tmp1_;
	_tmp2_ = scheme;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		_tmp3_ = _ ("Bad URI: %s");
		_tmp4_ = uri;
		_tmp5_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp3_, _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (scheme);
		return NULL;
	}
	_tmp6_ = rygel_media_engine_get_default ();
	engine = _tmp6_;
	_tmp7_ = engine;
	_tmp8_ = rygel_media_engine_get_internal_protocol_schemes (_tmp7_);
	schemes = _tmp8_;
	_tmp9_ = schemes;
	_tmp10_ = scheme;
	_tmp11_ = g_strcmp0;
	_tmp12_ = g_list_find_custom (_tmp9_, _tmp10_, _tmp11_);
	if (_tmp12_ != NULL) {
		result = NULL;
		__g_list_free__g_free0_0 (schemes);
		_g_object_unref0 (engine);
		_g_free0 (scheme);
		return result;
	}
	_tmp13_ = scheme;
	if (g_strcmp0 (_tmp13_, "http") == 0) {
		gchar* _tmp14_ = NULL;
		_tmp14_ = g_strdup ("http-get");
		result = _tmp14_;
		__g_list_free__g_free0_0 (schemes);
		_g_object_unref0 (engine);
		_g_free0 (scheme);
		return result;
	} else {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = scheme;
		if (g_strcmp0 (_tmp15_, "file") == 0) {
			gchar* _tmp16_ = NULL;
			_tmp16_ = g_strdup ("internal");
			result = _tmp16_;
			__g_list_free__g_free0_0 (schemes);
			_g_object_unref0 (engine);
			_g_free0 (scheme);
			return result;
		} else {
			const gchar* _tmp17_ = NULL;
			_tmp17_ = scheme;
			if (g_strcmp0 (_tmp17_, "rtsp") == 0) {
				gchar* _tmp18_ = NULL;
				_tmp18_ = g_strdup ("rtsp-rtp-udp");
				result = _tmp18_;
				__g_list_free__g_free0_0 (schemes);
				_g_object_unref0 (engine);
				_g_free0 (scheme);
				return result;
			} else {
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				_tmp19_ = uri;
				_tmp20_ = scheme;
				g_debug ("Could not translate protocol scheme for  %s. " " Using '%s' as-is", _tmp19_, _tmp20_);
				result = scheme;
				__g_list_free__g_free0_0 (schemes);
				_g_object_unref0 (engine);
				return result;
			}
		}
	}
	__g_list_free__g_free0_0 (schemes);
	_g_object_unref0 (engine);
	_g_free0 (scheme);
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


const gchar* rygel_media_object_get_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ref_id;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_ref_id);
	self->priv->_ref_id = _tmp1_;
	g_object_notify ((GObject *) self, "ref-id");
}


const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upnp_class;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_upnp_class);
	self->priv->_upnp_class = _tmp1_;
	g_object_notify ((GObject *) self, "upnp-class");
}


const gchar* rygel_media_object_get_date (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_date);
	self->priv->_date = _tmp1_;
	g_object_notify ((GObject *) self, "date");
}


const gchar* rygel_media_object_get_creator (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_creator;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_creator (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_creator);
	self->priv->_creator = _tmp1_;
	g_object_notify ((GObject *) self, "creator");
}


guint64 rygel_media_object_get_modified (RygelMediaObject* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->priv->_modified;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value) {
	guint64 _tmp0_ = 0ULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modified = _tmp0_;
	g_object_notify ((GObject *) self, "modified");
}


guint rygel_media_object_get_object_update_id (RygelMediaObject* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_object_update_id;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_object_update_id = _tmp0_;
	g_object_notify ((GObject *) self, "object-update-id");
}


const gchar* rygel_media_object_get_artist (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_artist;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_artist (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_artist);
	self->priv->_artist = _tmp1_;
	g_object_notify ((GObject *) self, "artist");
}


const gchar* rygel_media_object_get_genre (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_genre;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_genre (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_genre);
	self->priv->_genre = _tmp1_;
	g_object_notify ((GObject *) self, "genre");
}


RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent_ptr;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->parent_ptr = _tmp0_;
	g_object_notify ((GObject *) self, "parent");
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_ref;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	rygel_media_object_set_parent (self, _tmp0_);
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_parent_ref);
	self->priv->_parent_ref = _tmp2_;
	g_object_notify ((GObject *) self, "parent-ref");
}


const gchar* rygel_media_object_get_title (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GRegex* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GRegex* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp1_ = rygel_media_object_real_name_regex;
		_tmp2_ = value;
		_tmp3_ = g_get_real_name ();
		_tmp4_ = g_regex_replace_literal (_tmp1_, _tmp2_, (gssize) -1, 0, _tmp3_, 0, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp5_;
		_tmp7_ = rygel_media_object_user_name_regex;
		_tmp8_ = self->priv->_title;
		_tmp9_ = g_get_user_name ();
		_tmp10_ = g_regex_replace_literal (_tmp7_, _tmp8_, (gssize) -1, 0, _tmp9_, 0, &_inner_error_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp11_;
		_tmp13_ = rygel_media_object_host_name_regex;
		_tmp14_ = self->priv->_title;
		_tmp15_ = g_get_host_name ();
		_tmp16_ = g_regex_replace_literal (_tmp13_, _tmp14_, (gssize) -1, 0, _tmp15_, 0, &_inner_error_);
		_tmp12_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp6_);
			_g_free0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_free0 (_tmp6_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp17_;
		_tmp19_ = rygel_media_object_pretty_name_regex;
		_tmp20_ = self->priv->_title;
		_tmp21_ = rygel_get_pretty_host_name ();
		_tmp22_ = _tmp21_;
		_tmp23_ = g_regex_replace_literal (_tmp19_, _tmp20_, (gssize) -1, 0, _tmp22_, 0, &_inner_error_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp18_ = _tmp24_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp12_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_free0 (_tmp12_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp25_ = _tmp18_;
		_tmp18_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp25_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp0_);
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "title");
}


GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
}


static GUPnPOCMFlags rygel_media_object_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaObject* self;
	self = base;
	result = GUPNP_OCM_FLAGS_NONE;
	return result;
}


gboolean rygel_media_object_get_restricted (RygelMediaObject* self) {
	gboolean result;
	GUPnPOCMFlags _tmp0_ = 0;
	GUPnPOCMFlags _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
	return result;
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	GError * _inner_error_ = NULL;
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
	((RygelMediaObjectClass *) klass)->add_uri = rygel_media_object_real_add_uri;
	((GObjectClass *) klass)->constructed = rygel_media_object_real_constructed;
	((RygelMediaObjectClass *) klass)->serialize = rygel_media_object_real_serialize;
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = rygel_media_object_real_create_stream_source_for_resource;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_media_object_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->compare_by_property = rygel_media_object_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_object_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_REF_ID, g_param_spec_string ("ref-id", "ref-id", "ref-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_UPNP_CLASS, g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_DATE, g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_CREATOR, g_param_spec_string ("creator", "creator", "creator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_MODIFIED, g_param_spec_uint64 ("modified", "modified", "modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID, g_param_spec_uint ("object-update-id", "object-update-id", "object-update-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ARTIST, g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_GENRE, g_param_spec_string ("genre", "genre", "genre", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT, g_param_spec_object ("parent", "parent", "parent", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The human-readable title of this container or item.
	     * These variables will be substituted:
	     *
	     *  - @@REALNAME@ will be substituted by the user's real name.
	     *  - @@USERNAME@ will be substituted by the users's login ID.
	     *  - @@HOSTNAME@ will be substituted by the name of the machine.
	     *  - @@ADDRESS@ will be substituted by the IP address of network interface
	     *    used for the UPnP communication.
	     *  - @@PRETTY_HOSTNAME@ will be substituted by the human readable name of the machine
	     *    (PRETTY_HOSTNAME field of /etc/machine-info)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED, g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_ = NULL;
		GRegex* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GRegex* _tmp15_ = NULL;
		GRegex* _tmp16_ = NULL;
		GRegex* _tmp17_ = NULL;
		GRegex* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GRegex* _tmp21_ = NULL;
		GRegex* _tmp22_ = NULL;
		GRegex* _tmp23_ = NULL;
		_tmp1_ = g_regex_escape_string ("@REALNAME@", -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_media_object_real_name_regex);
		rygel_media_object_real_name_regex = _tmp5_;
		_tmp7_ = g_regex_escape_string ("@USERNAME@", -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		_g_regex_unref0 (rygel_media_object_user_name_regex);
		rygel_media_object_user_name_regex = _tmp11_;
		_tmp13_ = g_regex_escape_string ("@HOSTNAME@", -1);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_regex_new (_tmp14_, 0, 0, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp12_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		_g_regex_unref0 (rygel_media_object_host_name_regex);
		rygel_media_object_host_name_regex = _tmp17_;
		_tmp19_ = g_regex_escape_string ("@PRETTY_HOSTNAME@", -1);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_regex_new (_tmp20_, 0, 0, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp18_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp23_ = _tmp18_;
		_tmp18_ = NULL;
		_g_regex_unref0 (rygel_media_object_pretty_name_regex);
		rygel_media_object_pretty_name_regex = _tmp23_;
		_g_regex_unref0 (_tmp18_);
		_g_regex_unref0 (_tmp12_);
		_g_regex_unref0 (_tmp6_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally19;
	__catch19_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	GeeLinkedList* _tmp0_ = NULL;
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
	_tmp0_ = gee_linked_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->media_resources = (GeeList*) _tmp0_;
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_ref_id);
	_g_free0 (self->priv->_upnp_class);
	_g_free0 (self->priv->_date);
	_g_free0 (self->priv->_creator);
	_g_free0 (self->priv->_artist);
	_g_free0 (self->priv->_genre);
	_g_object_unref0 (self->priv->uris);
	_g_object_unref0 (self->priv->media_resources);
	_g_object_unref0 (self->priv->_parent_ref);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


/**
 * Represents a media object (container or item).
 *
 * The derived RygelMediaContainer class represents a container
 * and the derived MediaItem classes represent media items.
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID:
		g_value_set_string (value, rygel_media_object_get_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID:
		g_value_set_string (value, rygel_media_object_get_ref_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
		g_value_set_string (value, rygel_media_object_get_upnp_class (self));
		break;
		case RYGEL_MEDIA_OBJECT_DATE:
		g_value_set_string (value, rygel_media_object_get_date (self));
		break;
		case RYGEL_MEDIA_OBJECT_CREATOR:
		g_value_set_string (value, rygel_media_object_get_creator (self));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED:
		g_value_set_uint64 (value, rygel_media_object_get_modified (self));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
		g_value_set_uint (value, rygel_media_object_get_object_update_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_ARTIST:
		g_value_set_string (value, rygel_media_object_get_artist (self));
		break;
		case RYGEL_MEDIA_OBJECT_GENRE:
		g_value_set_string (value, rygel_media_object_get_genre (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT:
		g_value_set_object (value, rygel_media_object_get_parent (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		g_value_set_string (value, rygel_media_object_get_title (self));
		break;
		case RYGEL_MEDIA_OBJECT_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags (self));
		break;
		case RYGEL_MEDIA_OBJECT_RESTRICTED:
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID:
		rygel_media_object_set_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID:
		rygel_media_object_set_ref_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
		rygel_media_object_set_upnp_class (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_DATE:
		rygel_media_object_set_date (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_CREATOR:
		rygel_media_object_set_creator (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED:
		rygel_media_object_set_modified (self, g_value_get_uint64 (value));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
		rygel_media_object_set_object_update_id (self, g_value_get_uint (value));
		break;
		case RYGEL_MEDIA_OBJECT_ARTIST:
		rygel_media_object_set_artist (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_GENRE:
		rygel_media_object_set_genre (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT:
		rygel_media_object_set_parent (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		rygel_media_object_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



