/* iagno.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_THEMES_DIALOG (themes_dialog_get_type ())
#define THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES_DIALOG, ThemesDialog))
#define THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES_DIALOG, ThemesDialogClass))
#define IS_THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES_DIALOG))
#define IS_THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES_DIALOG))
#define THEMES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES_DIALOG, ThemesDialogClass))

typedef struct _ThemesDialog ThemesDialog;
typedef struct _ThemesDialogClass ThemesDialogClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	GameWindow* window;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	ThemesDialog* themes_dialog;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
	GtkBox* color_box;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gchar* iagno_level;
static gchar* iagno_level = NULL;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean iagno_two_players;
static gboolean iagno_two_players = FALSE;
static gboolean* iagno_play_first;
static gboolean* iagno_play_first = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType themes_dialog_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static GType iagno_sound_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.7
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_theme_cb (Iagno* self);
static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static Iagno* iagno_new (void);
static Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
void game_view_set_theme (GameView* self, const gchar* value);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget);
static void iagno_start_game (Iagno* self);
static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void iagno_wait_cb (Iagno* self);
static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self);
static void iagno_undo_cb (Iagno* self);
static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self, GSettings* settings);
ThemesDialog* themes_dialog_new (GSettings* settings, GameView* view);
ThemesDialog* themes_dialog_construct (GType object_type, GSettings* settings, GameView* view);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self);
void game_view_set_game (GameView* self, Game* value);
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void iagno_update_ui (Iagno* self);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self, IagnoSound sound);
void game_view_update_scoreboard (GameView* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
void game_window_finish_game (GameWindow* self);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, "Start with an alternative position", NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_STRING, &iagno_level, "Set the level of the computer's AI", "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, "Size of the board (debug only)", "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[4] = {{"theme", _iagno_theme_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static GType iagno_sound_get_type (void) {
	static volatile gsize iagno_sound_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_sound_type_id__volatile)) {
		static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
		GType iagno_sound_type_id;
		iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
		g_once_init_leave (&iagno_sound_type_id__volatile, iagno_sound_type_id);
	}
	return iagno_sound_type_id__volatile;
}


static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_theme_cb ((Iagno*) self);
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_help_cb ((Iagno*) self);
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_about_cb ((Iagno*) self);
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	g_application_quit ((GApplication*) self);
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* _tmp1_ = NULL;
	Iagno* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("Iagno");
	g_set_application_name (_tmp0_);
	gtk_window_set_default_icon_name ("iagno");
	_tmp1_ = iagno_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return iagno_main (argv, argc);
}


static Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
	return self;
}


static Iagno* iagno_new (void) {
	return iagno_construct (TYPE_IAGNO);
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	self = (Iagno*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp3_ = iagno_size;
	if (_tmp3_ < 4) {
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = _ ("Size must be at least 4.");
		fprintf (_tmp4_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp6_ = options;
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
		_tmp8_ = FALSE;
		_tmp9_ = __bool_dup0 (&_tmp8_);
		_g_free0 (iagno_sound);
		iagno_sound = _tmp9_;
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = options;
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
		if (_tmp11_) {
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
			_tmp12_ = TRUE;
			_tmp13_ = __bool_dup0 (&_tmp12_);
			_g_free0 (iagno_sound);
			iagno_sound = _tmp13_;
		}
	}
	_tmp14_ = options;
	_tmp15_ = g_variant_dict_contains (_tmp14_, "two-players");
	if (_tmp15_) {
		iagno_two_players = TRUE;
	} else {
		GVariantDict* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = options;
		_tmp17_ = g_variant_dict_contains (_tmp16_, "first");
		if (_tmp17_) {
			gboolean _tmp18_ = FALSE;
			gboolean* _tmp19_ = NULL;
			_tmp18_ = TRUE;
			_tmp19_ = __bool_dup0 (&_tmp18_);
			_g_free0 (iagno_play_first);
			iagno_play_first = _tmp19_;
		} else {
			GVariantDict* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = options;
			_tmp21_ = g_variant_dict_contains (_tmp20_, "second");
			if (_tmp21_) {
				gboolean _tmp22_ = FALSE;
				gboolean* _tmp23_ = NULL;
				_tmp22_ = FALSE;
				_tmp23_ = __bool_dup0 (&_tmp22_);
				_g_free0 (iagno_play_first);
				iagno_play_first = _tmp23_;
			}
		}
	}
	result = -1;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Iagno* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->color_box);
		_g_object_unref0 (_data3_->level_box);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
	iagno_player_move_cb ((Iagno*) self, x, y);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self) {
	iagno_start_game ((Iagno*) self);
}


static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self) {
	iagno_wait_cb ((Iagno*) self);
}


static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self) {
	iagno_back_cb ((Iagno*) self);
}


static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
	iagno_undo_cb ((Iagno*) self);
}


static void __lambda8_ (Block3Data* _data3_) {
	Iagno* self;
	gboolean solo = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	self = _data3_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, "num-players");
	solo = _tmp1_ == 1;
	_tmp2_ = _data3_->level_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, solo);
	_tmp3_ = _data3_->color_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, solo);
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda8_ (self);
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	Block3Data* _data3_;
	GSettings* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean start_now = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean* _tmp11_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GameView* _tmp33_ = NULL;
	GameView* _tmp34_ = NULL;
	GtkDrawingArea* scoredrawing = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkDrawingArea* _tmp37_ = NULL;
	GameView* _tmp38_ = NULL;
	GtkDrawingArea* _tmp39_ = NULL;
	GameView* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GSettings* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GSettings* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GameView* _tmp54_ = NULL;
	GameWindow* _tmp55_ = NULL;
	GtkWidget* scoregrid = NULL;
	GtkBuilder* _tmp56_ = NULL;
	GObject* _tmp57_ = NULL;
	GtkWidget* _tmp58_ = NULL;
	GameWindow* _tmp59_ = NULL;
	GtkWidget* _tmp60_ = NULL;
	GameWindow* _tmp61_ = NULL;
	GameWindow* _tmp62_ = NULL;
	GameWindow* _tmp63_ = NULL;
	GameWindow* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	gchar** _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gint _tmp67__length1 = 0;
	gchar* _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gchar** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gchar* _tmp71_ = NULL;
	gchar** _tmp72_ = NULL;
	gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gchar* _tmp74_ = NULL;
	gchar** _tmp75_ = NULL;
	gchar** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	gchar* _tmp77_ = NULL;
	gchar** _tmp78_ = NULL;
	gchar** _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	GSettings* _tmp80_ = NULL;
	GAction* _tmp81_ = NULL;
	GAction* _tmp82_ = NULL;
	GSettings* _tmp83_ = NULL;
	GAction* _tmp84_ = NULL;
	GAction* _tmp85_ = NULL;
	GSettings* _tmp86_ = NULL;
	GAction* _tmp87_ = NULL;
	GAction* _tmp88_ = NULL;
	GSettings* _tmp89_ = NULL;
	GAction* _tmp90_ = NULL;
	GAction* _tmp91_ = NULL;
	GtkBuilder* _tmp92_ = NULL;
	GObject* _tmp93_ = NULL;
	GtkBox* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	GObject* _tmp96_ = NULL;
	GtkBox* _tmp97_ = NULL;
	GSettings* _tmp98_ = NULL;
	gboolean solo = FALSE;
	GSettings* _tmp99_ = NULL;
	gint _tmp100_ = 0;
	GtkBox* _tmp101_ = NULL;
	gboolean _tmp102_ = FALSE;
	GtkBox* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	GtkBuilder* _tmp105_ = NULL;
	GObject* _tmp106_ = NULL;
	GtkLabel* _tmp107_ = NULL;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkLabel* _tmp110_ = NULL;
	gboolean _tmp111_ = FALSE;
	GameWindow* _tmp112_ = NULL;
	self = (Iagno*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = iagno_sound;
	if (_tmp1_ != NULL) {
		GSettings* _tmp2_ = NULL;
		gboolean* _tmp3_ = NULL;
		_tmp2_ = self->priv->settings;
		_tmp3_ = iagno_sound;
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
	}
	_tmp5_ = iagno_two_players;
	if (_tmp5_ == TRUE) {
		_tmp4_ = TRUE;
	} else {
		gboolean* _tmp6_ = NULL;
		_tmp6_ = iagno_play_first;
		_tmp4_ = _tmp6_ != NULL;
	}
	start_now = _tmp4_;
	_tmp7_ = start_now;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		GSettings* _tmp10_ = NULL;
		_tmp9_ = iagno_two_players;
		if (_tmp9_) {
			_tmp8_ = 2;
		} else {
			_tmp8_ = 1;
		}
		_tmp10_ = self->priv->settings;
		g_settings_set_int (_tmp10_, "num-players", _tmp8_);
	}
	_tmp11_ = iagno_play_first;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_ = NULL;
		gboolean* _tmp13_ = NULL;
		GSettings* _tmp14_ = NULL;
		_tmp13_ = iagno_play_first;
		if (*_tmp13_) {
			_tmp12_ = "dark";
		} else {
			_tmp12_ = "light";
		}
		_tmp14_ = self->priv->settings;
		g_settings_set_string (_tmp14_, "color", _tmp12_);
	}
	_tmp17_ = iagno_level;
	if (g_strcmp0 (_tmp17_, "1") == 0) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = iagno_level;
		_tmp16_ = g_strcmp0 (_tmp18_, "2") == 0;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp19_ = NULL;
		_tmp19_ = iagno_level;
		_tmp15_ = g_strcmp0 (_tmp19_, "3") == 0;
	}
	if (_tmp15_) {
		GSettings* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp20_ = self->priv->settings;
		_tmp21_ = iagno_level;
		_tmp22_ = atoi (_tmp21_);
		g_settings_set_int (_tmp20_, "computer-level", _tmp22_);
	} else {
		const gchar* _tmp23_ = NULL;
		_tmp23_ = iagno_level;
		if (g_strcmp0 (_tmp23_, "one") == 0) {
			GSettings* _tmp24_ = NULL;
			_tmp24_ = self->priv->settings;
			g_settings_set_int (_tmp24_, "computer-level", 1);
		} else {
			const gchar* _tmp25_ = NULL;
			_tmp25_ = iagno_level;
			if (g_strcmp0 (_tmp25_, "two") == 0) {
				GSettings* _tmp26_ = NULL;
				_tmp26_ = self->priv->settings;
				g_settings_set_int (_tmp26_, "computer-level", 2);
			} else {
				const gchar* _tmp27_ = NULL;
				_tmp27_ = iagno_level;
				if (g_strcmp0 (_tmp27_, "three") == 0) {
					GSettings* _tmp28_ = NULL;
					_tmp28_ = self->priv->settings;
					g_settings_set_int (_tmp28_, "computer-level", 3);
				} else {
					const gchar* _tmp29_ = NULL;
					_tmp29_ = iagno_level;
					if (_tmp29_ != NULL) {
						FILE* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						_tmp30_ = stderr;
						_tmp31_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
						fprintf (_tmp30_, "%s\n", _tmp31_);
					}
				}
			}
		}
	}
	_tmp32_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno-screens.ui");
	builder = _tmp32_;
	_tmp33_ = game_view_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp33_;
	_tmp34_ = self->priv->view;
	g_signal_connect_object (_tmp34_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp35_ = builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "scoredrawing");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_drawing_area_get_type (), GtkDrawingArea));
	scoredrawing = _tmp37_;
	_tmp38_ = self->priv->view;
	_tmp39_ = scoredrawing;
	game_view_set_scoreboard (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->view;
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_string (_tmp41_, "theme");
	_tmp43_ = _tmp42_;
	game_view_set_theme (_tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = _ ("Iagno");
	_tmp45_ = self->priv->settings;
	_tmp46_ = g_settings_get_int (_tmp45_, "window-width");
	_tmp47_ = self->priv->settings;
	_tmp48_ = g_settings_get_int (_tmp47_, "window-height");
	_tmp49_ = self->priv->settings;
	_tmp50_ = g_settings_get_boolean (_tmp49_, "window-is-maximized");
	_tmp51_ = start_now;
	_tmp52_ = builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "new-game-screen");
	_tmp54_ = self->priv->view;
	_tmp55_ = game_window_new ("/org/gnome/iagno/ui/iagno.css", _tmp44_, _tmp46_, _tmp48_, _tmp50_, _tmp51_, GAME_WINDOW_FLAGS_SHOW_UNDO | GAME_WINDOW_FLAGS_SHOW_START_BUTTON, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp54_);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp55_;
	_tmp56_ = builder;
	_tmp57_ = gtk_builder_get_object (_tmp56_, "scoregrid");
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget));
	scoregrid = _tmp58_;
	_tmp59_ = self->priv->window;
	_tmp60_ = scoregrid;
	game_window_add_to_sidebox (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->window;
	g_signal_connect_object (_tmp61_, "play", (GCallback) _iagno_start_game_game_window_play, self, 0);
	_tmp62_ = self->priv->window;
	g_signal_connect_object (_tmp62_, "wait", (GCallback) _iagno_wait_cb_game_window_wait, self, 0);
	_tmp63_ = self->priv->window;
	g_signal_connect_object (_tmp63_, "back", (GCallback) _iagno_back_cb_game_window_back, self, 0);
	_tmp64_ = self->priv->window;
	g_signal_connect_object (_tmp64_, "undo", (GCallback) _iagno_undo_cb_game_window_undo, self, 0);
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
	_tmp65_ = g_strdup ("<Primary>n");
	_tmp66_ = g_new0 (gchar*, 1 + 1);
	_tmp66_[0] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp67_);
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
	_tmp68_ = g_strdup ("<Primary><Shift>n");
	_tmp69_ = g_new0 (gchar*, 1 + 1);
	_tmp69_[0] = _tmp68_;
	_tmp70_ = _tmp69_;
	_tmp70__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp70_);
	_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
	_tmp71_ = g_strdup ("<Primary>z");
	_tmp72_ = g_new0 (gchar*, 1 + 1);
	_tmp72_[0] = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp73_);
	_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
	_tmp74_ = g_strdup ("<Primary><Shift>z");
	_tmp75_ = g_new0 (gchar*, 1 + 1);
	_tmp75_[0] = _tmp74_;
	_tmp76_ = _tmp75_;
	_tmp76__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp76_);
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
	_tmp77_ = g_strdup ("Escape");
	_tmp78_ = g_new0 (gchar*, 1 + 1);
	_tmp78_[0] = _tmp77_;
	_tmp79_ = _tmp78_;
	_tmp79__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp79_);
	_tmp79_ = (_vala_array_free (_tmp79_, _tmp79__length1, (GDestroyNotify) g_free), NULL);
	_tmp80_ = self->priv->settings;
	_tmp81_ = g_settings_create_action (_tmp80_, "sound");
	_tmp82_ = _tmp81_;
	g_action_map_add_action ((GActionMap*) self, _tmp82_);
	_g_object_unref0 (_tmp82_);
	_tmp83_ = self->priv->settings;
	_tmp84_ = g_settings_create_action (_tmp83_, "color");
	_tmp85_ = _tmp84_;
	g_action_map_add_action ((GActionMap*) self, _tmp85_);
	_g_object_unref0 (_tmp85_);
	_tmp86_ = self->priv->settings;
	_tmp87_ = g_settings_create_action (_tmp86_, "num-players");
	_tmp88_ = _tmp87_;
	g_action_map_add_action ((GActionMap*) self, _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = self->priv->settings;
	_tmp90_ = g_settings_create_action (_tmp89_, "computer-level");
	_tmp91_ = _tmp90_;
	g_action_map_add_action ((GActionMap*) self, _tmp91_);
	_g_object_unref0 (_tmp91_);
	_tmp92_ = builder;
	_tmp93_ = gtk_builder_get_object (_tmp92_, "difficulty-box");
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_box_get_type (), GtkBox));
	_data3_->level_box = _tmp94_;
	_tmp95_ = builder;
	_tmp96_ = gtk_builder_get_object (_tmp95_, "color-box");
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_box_get_type (), GtkBox));
	_data3_->color_box = _tmp97_;
	_tmp98_ = self->priv->settings;
	g_signal_connect_data (_tmp98_, "changed::num-players", (GCallback) ___lambda8__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp99_ = self->priv->settings;
	_tmp100_ = g_settings_get_int (_tmp99_, "num-players");
	solo = _tmp100_ == 1;
	_tmp101_ = _data3_->level_box;
	_tmp102_ = solo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp101_, _tmp102_);
	_tmp103_ = _data3_->color_box;
	_tmp104_ = solo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp103_, _tmp104_);
	_tmp105_ = builder;
	_tmp106_ = gtk_builder_get_object (_tmp105_, "light-score-label");
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp107_;
	_tmp108_ = builder;
	_tmp109_ = gtk_builder_get_object (_tmp108_, "dark-score-label");
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp110_;
	_tmp111_ = start_now;
	if (_tmp111_) {
		iagno_start_game (self);
	}
	_tmp112_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp112_);
	_g_object_unref0 (scoregrid);
	_g_object_unref0 (scoredrawing);
	_g_object_unref0 (builder);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->settings;
	game_window_shutdown (_tmp0_, _tmp1_);
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static void iagno_theme_cb (Iagno* self) {
	ThemesDialog* _tmp0_ = NULL;
	ThemesDialog* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->themes_dialog;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_ = NULL;
		GameView* _tmp2_ = NULL;
		ThemesDialog* _tmp3_ = NULL;
		ThemesDialog* _tmp4_ = NULL;
		GameWindow* _tmp5_ = NULL;
		_tmp1_ = self->priv->settings;
		_tmp2_ = self->priv->view;
		_tmp3_ = themes_dialog_new (_tmp1_, _tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->themes_dialog);
		self->priv->themes_dialog = _tmp3_;
		_tmp4_ = self->priv->themes_dialog;
		_tmp5_ = self->priv->window;
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
	}
	_tmp6_ = self->priv->themes_dialog;
	gtk_window_present ((GtkWindow*) _tmp6_);
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:257: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Tiffany Antopolski");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = self->priv->window;
	_tmp6_ = _ ("Iagno");
	_tmp7_ = _ ("A disk flipping game derived from Reversi");
	_tmp8_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" "Copyright © 2013–2015 Michael Catanzaro\n" "Copyright © 2014–2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void iagno_back_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_ = NULL;
		_tmp6_ = self->priv->computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_is_complete (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ComputerPlayer* _tmp10_ = NULL;
		_tmp10_ = self->priv->computer;
		computer_player_move_async (_tmp10_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
	} else {
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			iagno_game_complete (self, FALSE);
		}
	}
}


static void iagno_wait_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer;
	if (_tmp0_ != NULL) {
		ComputerPlayer* _tmp1_ = NULL;
		_tmp1_ = self->priv->computer;
		computer_player_cancel_move (_tmp1_);
	}
}


static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self) {
	iagno_turn_ended_cb ((Iagno*) self);
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	Player _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = self->priv->computer;
	if (_tmp2_ != NULL) {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->computer;
		computer_player_cancel_move (_tmp3_);
	}
	_tmp4_ = iagno_alternative_start;
	_tmp5_ = iagno_size;
	_tmp6_ = game_new (_tmp4_, _tmp5_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp6_;
	_tmp7_ = self->priv->game;
	g_signal_connect_object (_tmp7_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
	_tmp8_ = self->priv->view;
	_tmp9_ = self->priv->game;
	game_view_set_game (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "num-players");
	if (_tmp11_ == 2) {
		_g_object_unref0 (self->priv->computer);
		self->priv->computer = NULL;
	} else {
		Game* _tmp12_ = NULL;
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		ComputerPlayer* _tmp15_ = NULL;
		_tmp12_ = self->priv->game;
		_tmp13_ = self->priv->settings;
		_tmp14_ = g_settings_get_int (_tmp13_, "computer-level");
		_tmp15_ = computer_player_new (_tmp12_, _tmp14_);
		_g_object_unref0 (self->priv->computer);
		self->priv->computer = _tmp15_;
	}
	_tmp16_ = self->priv->settings;
	_tmp17_ = g_settings_get_enum (_tmp16_, "color");
	if (_tmp17_ == 1) {
		self->priv->player_one = PLAYER_LIGHT;
	} else {
		self->priv->player_one = PLAYER_DARK;
	}
	iagno_update_ui (self);
	_tmp19_ = self->priv->player_one;
	if (_tmp19_ != PLAYER_DARK) {
		ComputerPlayer* _tmp20_ = NULL;
		_tmp20_ = self->priv->computer;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ComputerPlayer* _tmp21_ = NULL;
		_tmp21_ = self->priv->computer;
		computer_player_move_async (_tmp21_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
	}
}


static void iagno_update_ui (Iagno* self) {
	GameWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Player _tmp2_ = 0;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_set_subtitle (_tmp0_, NULL);
	_tmp2_ = self->priv->player_one;
	if (_tmp2_ == PLAYER_DARK) {
		_tmp1_ = TRUE;
	} else {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->computer;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		GameWindow* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp4_ = self->priv->window;
		_tmp5_ = _tmp4_->undo_action;
		_tmp6_ = self->priv->game;
		_tmp7_ = game_get_number_of_moves (_tmp6_);
		_tmp8_ = _tmp7_;
		g_simple_action_set_enabled (_tmp5_, _tmp8_ >= 1);
	} else {
		GameWindow* _tmp9_ = NULL;
		GSimpleAction* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp9_ = self->priv->window;
		_tmp10_ = _tmp9_->undo_action;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_number_of_moves (_tmp11_);
		_tmp13_ = _tmp12_;
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
	}
	_tmp14_ = self->priv->dark_score_label;
	_tmp15_ = _ ("%.2d");
	_tmp16_ = self->priv->game;
	_tmp17_ = game_get_n_dark_tiles (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf (_tmp15_, _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_label_set_text (_tmp14_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->light_score_label;
	_tmp22_ = _ ("%.2d");
	_tmp23_ = self->priv->game;
	_tmp24_ = game_get_n_light_tiles (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup_printf (_tmp22_, _tmp25_);
	_tmp27_ = _tmp26_;
	gtk_label_set_text (_tmp21_, _tmp27_);
	_g_free0 (_tmp27_);
}


static void iagno_undo_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GameView* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer;
	if (_tmp0_ == NULL) {
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = self->priv->game;
		game_undo (_tmp1_, 1);
		_tmp2_ = self->priv->game;
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			Game* _tmp5_ = NULL;
			_tmp5_ = self->priv->game;
			game_undo (_tmp5_, 1);
		}
	} else {
		ComputerPlayer* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		_tmp6_ = self->priv->computer;
		computer_player_cancel_move (_tmp6_);
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_current_color (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->player_one;
		if (_tmp9_ != _tmp10_) {
			Game* _tmp11_ = NULL;
			_tmp11_ = self->priv->game;
			game_undo (_tmp11_, 1);
		} else {
			Game* _tmp12_ = NULL;
			_tmp12_ = self->priv->game;
			game_undo (_tmp12_, 2);
		}
		while (TRUE) {
			Game* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Game* _tmp16_ = NULL;
			_tmp13_ = self->priv->game;
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
			_tmp15_ = _tmp14_;
			if (!(!_tmp15_)) {
				break;
			}
			_tmp16_ = self->priv->game;
			game_undo (_tmp16_, 2);
		}
	}
	iagno_update_ui (self);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp17_ = self->priv->view;
	game_view_update_scoreboard (_tmp17_);
}


static void iagno_turn_ended_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	iagno_update_ui (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		iagno_prepare_move (self);
	} else {
		Game* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = self->priv->game;
		_tmp4_ = game_get_is_complete (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			iagno_game_complete (self, TRUE);
		} else {
			iagno_pass (self);
		}
	}
}


static void iagno_prepare_move (Iagno* self) {
	GameView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp0_ = self->priv->view;
	game_view_update_scoreboard (_tmp0_);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_ = NULL;
		_tmp6_ = self->priv->computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gdouble _tmp7_ = 0.0;
		gboolean _tmp8_ = FALSE;
		ComputerPlayer* _tmp9_ = NULL;
		_tmp8_ = iagno_fast_mode;
		if (_tmp8_) {
			_tmp7_ = IAGNO_QUICK_MOVE_DELAY;
		} else {
			_tmp7_ = IAGNO_SLOW_MOVE_DELAY;
		}
		_tmp9_ = self->priv->computer;
		computer_player_move_async (_tmp9_, _tmp7_, NULL, NULL);
	}
}


static void iagno_pass (Iagno* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp0_ = self->priv->view;
	game_view_update_scoreboard (_tmp0_);
	_tmp1_ = self->priv->game;
	game_pass (_tmp1_);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		GameWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = self->priv->window;
		_tmp6_ = _ ("Light must pass, Dark’s move");
		game_window_set_subtitle (_tmp5_, _tmp6_);
	} else {
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = self->priv->window;
		_tmp8_ = _ ("Dark must pass, Light’s move");
		game_window_set_subtitle (_tmp7_, _tmp8_);
	}
}


static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound) {
	GameWindow* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_finish_game (_tmp0_);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_n_light_tiles (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->game;
	_tmp5_ = game_get_n_dark_tiles (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3_ > _tmp6_) {
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = self->priv->window;
		_tmp8_ = _ ("Light wins!");
		game_window_set_subtitle (_tmp7_, _tmp8_);
	} else {
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		Game* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp9_ = self->priv->game;
		_tmp10_ = game_get_n_dark_tiles (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->game;
		_tmp13_ = game_get_n_light_tiles (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp11_ > _tmp14_) {
			GameWindow* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp15_ = self->priv->window;
			_tmp16_ = _ ("Dark wins!");
			game_window_set_subtitle (_tmp15_, _tmp16_);
		} else {
			GameWindow* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			_tmp17_ = self->priv->window;
			_tmp18_ = _ ("The game is draw.");
			game_window_set_subtitle (_tmp17_, _tmp18_);
		}
	}
	_tmp19_ = play_gameover_sound;
	if (_tmp19_) {
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
	}
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_ = NULL;
		_tmp6_ = self->priv->computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = self->priv->game;
	_tmp11_ = x;
	_tmp12_ = y;
	_tmp13_ = game_place_tile (_tmp10_, _tmp11_, _tmp12_, TRUE);
	if (_tmp13_ == 0) {
		GameWindow* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = self->priv->window;
		_tmp15_ = _ ("You can’t move there!");
		game_window_set_subtitle (_tmp14_, _tmp15_);
	}
}


static void iagno_play_sound (Iagno* self, IagnoSound sound) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* name = NULL;
	IagnoSound _tmp2_ = 0;
	gchar* path = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint r = 0;
	GameView* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = sound;
	switch (_tmp2_) {
		case IAGNO_SOUND_FLIP:
		{
			GameView* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp3_ = self->priv->view;
			_tmp4_ = game_view_get_sound_flip (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (name);
			name = _tmp6_;
			break;
		}
		case IAGNO_SOUND_GAMEOVER:
		{
			GameView* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp7_ = self->priv->view;
			_tmp8_ = game_view_get_sound_gameover (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (name);
			name = _tmp10_;
			break;
		}
		default:
		{
			_g_free0 (name);
			return;
		}
	}
	_tmp11_ = name;
	_tmp12_ = g_build_filename (SOUND_DIRECTORY, _tmp11_, NULL);
	path = _tmp12_;
	_tmp13_ = self->priv->view;
	_tmp14_ = name;
	_tmp15_ = path;
	_tmp16_ = ca_gtk_play_for_widget ((GtkWidget*) _tmp13_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp14_, CA_PROP_MEDIA_FILENAME, _tmp15_, NULL);
	r = _tmp16_;
	_tmp17_ = r;
	if (_tmp17_ != 0) {
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		const gchar* _tmp20_ = NULL;
		_tmp18_ = path;
		_tmp19_ = r;
		_tmp20_ = ca_strerror (_tmp19_);
		g_warning ("iagno.vala:486: Error playing %s: %s", _tmp18_, _tmp20_);
	}
	_g_free0 (path);
	_g_free0 (name);
}


static void iagno_class_init (IagnoClass * klass) {
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
	((GApplicationClass *) klass)->startup = iagno_real_startup;
	((GApplicationClass *) klass)->activate = iagno_real_activate;
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}


static void iagno_instance_init (Iagno * self) {
	self->priv = IAGNO_GET_PRIVATE (self);
	self->priv->computer = NULL;
	self->priv->game = NULL;
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->themes_dialog);
	_g_object_unref0 (self->priv->computer);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



