/* sudoku-generator.c generated by valac 0.32.0.42-62a2, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "qqwing-wrapper.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUDOKU_GENERATOR_TYPE_WORKER (sudoku_generator_worker_get_type ())
#define SUDOKU_GENERATOR_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker))
#define SUDOKU_GENERATOR_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))
#define SUDOKU_GENERATOR_IS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_IS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))

typedef struct _SudokuGeneratorWorker SudokuGeneratorWorker;
typedef struct _SudokuGeneratorWorkerClass SudokuGeneratorWorkerClass;
typedef struct _Block1Data Block1Data;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;
typedef struct _SudokuGeneratorWorkerPrivate SudokuGeneratorWorkerPrivate;

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _Block1Data {
	int _ref_count_;
	GThreadPool* pool;
	gpointer _async_data_;
};

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint nboards;
	DifficultyCategory category;
	GCancellable* cancellable;
	GeeList* result;
	Block1Data* _data1_;
	GeeArrayList* boards;
	GeeArrayList* _tmp0_;
	guint _tmp1_;
	GThreadPool* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GThreadPool* _tmp9_;
	gint _tmp10_;
	DifficultyCategory _tmp11_;
	GeeArrayList* _tmp12_;
	SudokuGeneratorWorker* _tmp13_;
	GCancellable* _tmp14_;
	GError * _inner_error_;
};

struct _SudokuGeneratorWorker {
	GObject parent_instance;
	SudokuGeneratorWorkerPrivate * priv;
};

struct _SudokuGeneratorWorkerClass {
	GObjectClass parent_class;
};

struct _SudokuGeneratorWorkerPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
};


static gpointer sudoku_generator_parent_class = NULL;
static gpointer sudoku_generator_worker_parent_class = NULL;
static GMutex sudoku_generator_worker_mutex;
static GMutex sudoku_generator_worker_mutex = {0};

GType sudoku_generator_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
static SudokuGenerator* sudoku_generator_new (void);
static SudokuGenerator* sudoku_generator_construct (GType object_type);
GType difficulty_category_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
static SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static GType sudoku_generator_worker_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (SudokuGeneratorWorker* worker);
static void sudoku_generator_worker_run (SudokuGeneratorWorker* self);
static void ___lambda5__gfunc (gpointer data, gpointer self);
static void ___lambda6_ (Block1Data* _data1_);
static void ____lambda6__gfunc (gconstpointer data, gpointer self);
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
static SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
static SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
void sudoku_generator_print_stats (SudokuBoard* board);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gchar* sudoku_generator_qqwing_version (void);
#define SUDOKU_GENERATOR_WORKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerPrivate))
enum  {
	SUDOKU_GENERATOR_WORKER_DUMMY_PROPERTY
};
static gboolean ___lambda4_ (SudokuGeneratorWorker* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void sudoku_generator_worker_finalize (GObject* obj);


static SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator * self = NULL;
	self = (SudokuGenerator*) g_object_new (object_type, NULL);
	return self;
}


static SudokuGenerator* sudoku_generator_new (void) {
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
}


static SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint* puzzle = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint* _tmp7_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	DifficultyCategory _tmp8_ = 0;
	SudokuBoard* _tmp35_ = NULL;
	DifficultyCategory _tmp36_ = 0;
	_tmp0_ = sudoku_board_new (3, 3);
	board = _tmp0_;
	_tmp1_ = board;
	_tmp2_ = sudoku_board_get_rows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = board;
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gint, _tmp3_ * _tmp6_);
	puzzle = _tmp7_;
	puzzle_length1 = _tmp3_ * _tmp6_;
	_puzzle_size_ = puzzle_length1;
	_tmp8_ = category;
	if (_tmp8_ != DIFFICULTY_CATEGORY_CUSTOM) {
		DifficultyCategory _tmp9_ = 0;
		gint* _tmp10_ = NULL;
		_tmp9_ = category;
		_tmp10_ = qqwing_generate_puzzle ((gint) _tmp9_);
		puzzle = (g_free (puzzle), NULL);
		puzzle = _tmp10_;
		puzzle_length1 = -1;
		_puzzle_size_ = puzzle_length1;
	}
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = row;
					row = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = row;
				_tmp14_ = board;
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(_tmp13_ < _tmp16_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint val = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							if (!_tmp17_) {
								gint _tmp18_ = 0;
								_tmp18_ = col;
								col = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = col;
							_tmp20_ = board;
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(_tmp19_ < _tmp22_)) {
								break;
							}
							_tmp23_ = puzzle;
							_tmp23__length1 = puzzle_length1;
							_tmp24_ = row;
							_tmp25_ = board;
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = col;
							_tmp29_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
							val = _tmp29_;
							_tmp30_ = val;
							if (_tmp30_ != 0) {
								SudokuBoard* _tmp31_ = NULL;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								_tmp31_ = board;
								_tmp32_ = row;
								_tmp33_ = col;
								_tmp34_ = val;
								sudoku_board_insert (_tmp31_, _tmp32_, _tmp33_, _tmp34_, TRUE);
							}
						}
					}
				}
			}
		}
	}
	_tmp35_ = board;
	_tmp36_ = category;
	sudoku_board_set_difficulty_category (_tmp35_, _tmp36_);
	result = board;
	puzzle = (g_free (puzzle), NULL);
	return result;
}


static void sudoku_generator_generate_boards_async_data_free (gpointer _data) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, sudoku_generator_generate_boards_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
	_tmp0_ = nboards;
	_data_->nboards = _tmp0_;
	_tmp1_ = category;
	_data_->category = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	sudoku_generator_generate_boards_async_co (_data_);
}


GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error) {
	GeeList* result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_thread_pool_free0 (_data1_->pool);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda5_ (SudokuGeneratorWorker* worker) {
	SudokuGeneratorWorker* _tmp0_ = NULL;
	g_return_if_fail (worker != NULL);
	_tmp0_ = worker;
	sudoku_generator_worker_run (_tmp0_);
	_g_object_unref0 (worker);
}


static void ___lambda5__gfunc (gpointer data, gpointer self) {
	__lambda5_ ((SudokuGeneratorWorker*) data);
}


static void vala__g_thread_pool_free_wrapper (GThreadPool* pool, gboolean immediate, gboolean wait) {
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_ = NULL;
	GThreadPool* _tmp1_ = NULL;
	_tmp0_ = pool;
	pool = NULL;
	ptr = _tmp0_;
	_tmp1_ = ptr;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = ptr;
		_tmp3_ = immediate;
		_tmp4_ = wait;
		g_thread_pool_free ((GThreadPool*) _tmp2_, _tmp3_, _tmp4_);
	}
	_g_thread_pool_free0 (pool);
}


static void ___lambda6_ (Block1Data* _data1_) {
	GThreadPool* _tmp0_ = NULL;
	_tmp0_ = _data1_->pool;
	_data1_->pool = NULL;
	vala__g_thread_pool_free_wrapper (_tmp0_, TRUE, FALSE);
	sudoku_generator_generate_boards_async_co (_data1_->_async_data_);
}


static void ____lambda6__gfunc (gconstpointer data, gpointer self) {
	___lambda6_ (self);
}


static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
	return result;
}


static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_data_->boards = _data_->_tmp0_;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = g_get_num_processors ();
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_thread_pool_new (___lambda5__gfunc, NULL, (gint) _data_->_tmp1_, FALSE, &_data_->_inner_error_);
	_data_->_data1_->pool = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->cancellable;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->cancellable;
		g_cancellable_connect (_data_->_tmp4_, (GCallback) ____lambda6__gfunc, block1_data_ref (_data_->_data1_), block1_data_unref);
	}
	{
		_data_->i = 0;
		{
			_data_->_tmp5_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp5_) {
					_data_->_tmp6_ = 0;
					_data_->_tmp6_ = _data_->i;
					_data_->i = _data_->_tmp6_ + 1;
				}
				_data_->_tmp5_ = FALSE;
				_data_->_tmp7_ = 0;
				_data_->_tmp7_ = _data_->i;
				_data_->_tmp8_ = 0;
				_data_->_tmp8_ = _data_->nboards;
				if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
					break;
				}
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = _data_->_data1_->pool;
				_data_->_tmp10_ = 0;
				_data_->_tmp10_ = _data_->nboards;
				_data_->_tmp11_ = 0;
				_data_->_tmp11_ = _data_->category;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->boards;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = sudoku_generator_worker_new (_data_->_tmp10_, _data_->_tmp11_, (GeeList*) _data_->_tmp12_, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
				g_thread_pool_push (_data_->_tmp9_, _data_->_tmp13_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_g_object_unref0 (_data_->boards);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->boards);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				}
			}
		}
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->cancellable;
	g_cancellable_set_error_if_cancelled (_data_->_tmp14_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = (GeeList*) _data_->boards;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->boards);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void sudoku_generator_print_stats (SudokuBoard* board) {
	gint* cells = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint cells_length1 = 0;
	gint cells_length2 = 0;
	gint* puzzle = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint* _tmp10_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	gint* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	g_return_if_fail (board != NULL);
	_tmp0_ = board;
	_tmp3_ = sudoku_board_get_cells (_tmp0_, &_tmp1_, &_tmp2_);
	cells = _tmp3_;
	cells_length1 = _tmp1_;
	cells_length2 = _tmp2_;
	_tmp4_ = board;
	_tmp5_ = sudoku_board_get_rows (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = board;
	_tmp8_ = sudoku_board_get_cols (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_new0 (gint, _tmp6_ * _tmp9_);
	puzzle = _tmp10_;
	puzzle_length1 = _tmp6_ * _tmp9_;
	_puzzle_size_ = puzzle_length1;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = row;
					row = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = row;
				_tmp14_ = board;
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(_tmp13_ < _tmp16_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							if (!_tmp17_) {
								gint _tmp18_ = 0;
								_tmp18_ = col;
								col = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = col;
							_tmp20_ = board;
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(_tmp19_ < _tmp22_)) {
								break;
							}
							_tmp23_ = puzzle;
							_tmp23__length1 = puzzle_length1;
							_tmp24_ = row;
							_tmp25_ = board;
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = col;
							_tmp29_ = cells;
							_tmp29__length1 = cells_length1;
							_tmp29__length2 = cells_length2;
							_tmp30_ = row;
							_tmp31_ = col;
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
							_tmp23_[(_tmp24_ * _tmp27_) + _tmp28_] = _tmp32_;
							_tmp33_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
						}
					}
				}
			}
		}
	}
	_tmp34_ = puzzle;
	_tmp34__length1 = puzzle_length1;
	qqwing_print_stats (_tmp34_);
	puzzle = (g_free (puzzle), NULL);
	cells = (g_free (cells), NULL);
}


gchar* sudoku_generator_qqwing_version (void) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = qqwing_get_version ();
	result = _tmp0_;
	return result;
}


static SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
	SudokuGeneratorWorker * self = NULL;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	GSourceFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	g_return_val_if_fail (boards_list != NULL, NULL);
	self = (SudokuGeneratorWorker*) g_object_new (object_type, NULL);
	_tmp0_ = nsudokus;
	self->priv->nsudokus = _tmp0_;
	_tmp1_ = level;
	self->priv->level = _tmp1_;
	_tmp2_ = boards_list;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->boards_list);
	self->priv->boards_list = _tmp3_;
	_tmp4_ = callback;
	_tmp4__target = callback_target;
	self->priv->callback = _tmp4_;
	self->priv->callback_target = _tmp4__target;
	return self;
}


static SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
	return sudoku_generator_worker_construct (SUDOKU_GENERATOR_TYPE_WORKER, nsudokus, level, boards_list, callback, callback_target);
}


static gboolean ___lambda4_ (SudokuGeneratorWorker* self) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = self->priv->callback;
	_tmp0__target = self->priv->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((SudokuGeneratorWorker*) self);
	return result;
}


static void sudoku_generator_worker_run (SudokuGeneratorWorker* self) {
	SudokuBoard* board = NULL;
	DifficultyCategory _tmp0_ = 0;
	SudokuBoard* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->level;
	_tmp1_ = sudoku_generator_generate_board (_tmp0_);
	board = _tmp1_;
	g_mutex_lock (&sudoku_generator_worker_mutex);
	_tmp2_ = self->priv->boards_list;
	_tmp3_ = board;
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
	_tmp4_ = self->priv->boards_list;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->nsudokus;
	if (_tmp6_ == _tmp7_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
	}
	g_mutex_unlock (&sudoku_generator_worker_mutex);
	_g_object_unref0 (board);
}


static void sudoku_generator_worker_class_init (SudokuGeneratorWorkerClass * klass) {
	sudoku_generator_worker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuGeneratorWorkerPrivate));
	G_OBJECT_CLASS (klass)->finalize = sudoku_generator_worker_finalize;
}


static void sudoku_generator_worker_instance_init (SudokuGeneratorWorker * self) {
	self->priv = SUDOKU_GENERATOR_WORKER_GET_PRIVATE (self);
}


static void sudoku_generator_worker_finalize (GObject* obj) {
	SudokuGeneratorWorker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker);
	_g_object_unref0 (self->priv->boards_list);
	G_OBJECT_CLASS (sudoku_generator_worker_parent_class)->finalize (obj);
}


static GType sudoku_generator_worker_get_type (void) {
	static volatile gsize sudoku_generator_worker_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_worker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGeneratorWorker), 0, (GInstanceInitFunc) sudoku_generator_worker_instance_init, NULL };
		GType sudoku_generator_worker_type_id;
		sudoku_generator_worker_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGeneratorWorker", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_worker_type_id__volatile, sudoku_generator_worker_type_id);
	}
	return sudoku_generator_worker_type_id__volatile;
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, NULL };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGenerator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}



