/* gitg-commit.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from gitg-commit.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;
typedef struct _GitgCommitPrivate GitgCommitPrivate;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_note_unref0(var) ((var == NULL) ? NULL : (var = (ggit_note_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GITG_TYPE_DATE (gitg_date_get_type ())
#define GITG_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DATE, GitgDate))
#define GITG_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DATE, GitgDateClass))
#define GITG_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DATE))
#define GITG_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DATE))
#define GITG_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DATE, GitgDateClass))

typedef struct _GitgDate GitgDate;
typedef struct _GitgDateClass GitgDateClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GitgCommit {
	GgitCommit parent_instance;
	GitgCommitPrivate * priv;
};

struct _GitgCommitClass {
	GgitCommitClass parent_class;
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4,
	GITG_LANE_TAG_HIDDEN = 1 << 5
} GitgLaneTag;

struct _GitgCommitPrivate {
	GitgLaneTag _tag;
	guint d_mylane;
	GSList* d_lanes;
};

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};


static gpointer gitg_commit_parent_class = NULL;

GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
GType gitg_lane_get_type (void) G_GNUC_CONST;
#define GITG_COMMIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_COMMIT, GitgCommitPrivate))
enum  {
	GITG_COMMIT_DUMMY_PROPERTY,
	GITG_COMMIT_TAG,
	GITG_COMMIT_MYLANE,
	GITG_COMMIT_LANE,
	GITG_COMMIT_FORMAT_PATCH_NAME,
	GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY,
	GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY
};
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
GSList* gitg_commit_get_lanes (GitgCommit* self);
GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx);
GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane);
static void gitg_commit_update_lane_tag (GitgCommit* self);
GType gitg_color_get_type (void) G_GNUC_CONST;
GitgLaneTag gitg_commit_get_tag (GitgCommit* self);
void gitg_commit_update_lanes (GitgCommit* self, GSList* lanes, gint mylane);
GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options, gint parent);
GgitNote* gitg_commit_get_note (GitgCommit* self);
static void _vala_GgitOId_free (GgitOId* self);
GitgCommit* gitg_commit_new (void);
GitgCommit* gitg_commit_construct (GType object_type);
void gitg_commit_set_tag (GitgCommit* self, GitgLaneTag value);
guint gitg_commit_get_mylane (GitgCommit* self);
void gitg_commit_set_mylane (GitgCommit* self, guint value);
GitgLane* gitg_commit_get_lane (GitgCommit* self);
gchar* gitg_commit_get_format_patch_name (GitgCommit* self);
gchar* gitg_commit_get_committer_date_for_display (GitgCommit* self);
GitgDate* gitg_date_new_for_date_time (GDateTime* dt);
GitgDate* gitg_date_construct_for_date_time (GType object_type, GDateTime* dt);
GType gitg_date_get_type (void) G_GNUC_CONST;
gchar* gitg_date_for_display (GitgDate* self);
gchar* gitg_commit_get_author_date_for_display (GitgCommit* self);
static void gitg_commit_finalize (GObject* obj);
static void _vala_gitg_commit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_commit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 171 "gitg-commit.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_slist_free (self);
#line 180 "gitg-commit.c"
}


GSList* gitg_commit_get_lanes (GitgCommit* self) {
	GSList* result = NULL;
	GSList* _tmp0_ = NULL;
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_lanes;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp0_;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 195 "gitg-commit.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return self ? g_object_ref (self) : NULL;
#line 202 "gitg-commit.c"
}


GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx) {
	GSList* result = NULL;
	GitgLane* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSList* _tmp3_ = NULL;
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (lane != NULL, NULL);
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = lane;
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = idx;
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self->priv->d_lanes = g_slist_insert (self->priv->d_lanes, _tmp1_, _tmp2_);
#line 53 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = self->priv->d_lanes;
#line 53 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp3_;
#line 53 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 230 "gitg-commit.c"
}


GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane) {
	GSList* result = NULL;
	GitgLane* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (lane != NULL, NULL);
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = lane;
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self->priv->d_lanes = g_slist_remove (self->priv->d_lanes, _tmp0_);
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = self->priv->d_lanes;
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp1_;
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 252 "gitg-commit.c"
}


static void gitg_commit_update_lane_tag (GitgCommit* self) {
	GitgLane* lane = NULL;
	GSList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
	GitgLane* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	GitgLane* _tmp5_ = NULL;
	GitgLaneTag _tmp6_ = 0;
	GitgLaneTag _tmp7_ = 0;
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_lanes;
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = self->priv->d_mylane;
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = g_slist_nth_data (_tmp0_, _tmp1_);
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	lane = (GitgLane*) _tmp2_;
#line 66 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = lane;
#line 66 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	if (_tmp3_ == NULL) {
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		return;
#line 282 "gitg-commit.c"
	}
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = lane;
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp5_ = lane;
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp6_ = _tmp5_->tag;
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp7_ = self->priv->_tag;
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp5_->tag = _tmp6_ & ((~((GITG_LANE_TAG_SIGN_STASH | GITG_LANE_TAG_SIGN_STAGED) | GITG_LANE_TAG_SIGN_UNSTAGED)) | _tmp7_);
#line 294 "gitg-commit.c"
}


void gitg_commit_update_lanes (GitgCommit* self, GSList* lanes, gint mylane) {
	GSList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = lanes;
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	lanes = NULL;
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	__g_slist_free__g_object_unref0_0 (self->priv->d_lanes);
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self->priv->d_lanes = _tmp0_;
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = mylane;
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	if (_tmp1_ >= 0) {
#line 315 "gitg-commit.c"
		gint _tmp2_ = 0;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp2_ = mylane;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		self->priv->d_mylane = (guint) ((gushort) _tmp2_);
#line 321 "gitg-commit.c"
	}
#line 85 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	gitg_commit_update_lane_tag (self);
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	__g_slist_free__g_object_unref0_0 (lanes);
#line 327 "gitg-commit.c"
}


GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options, gint parent) {
	GgitDiff* result = NULL;
	GgitDiff* diff = NULL;
	GgitRepository* repo = NULL;
	GgitRepository* _tmp0_ = NULL;
	GgitDiff* _tmp37_ = NULL;
	GError * _inner_error_ = NULL;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	diff = NULL;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_object_get_owner ((GgitObject*) self);
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	repo = _tmp0_;
#line 346 "gitg-commit.c"
	{
		GgitCommitParents* parents = NULL;
		GgitCommitParents* _tmp1_ = NULL;
		GgitCommitParents* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp1_ = ggit_commit_get_parents ((GgitCommit*) self);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		parents = _tmp1_;
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp2_ = parents;
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp3_ = ggit_commit_parents_get_size (_tmp2_);
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp4_ = _tmp3_;
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		if (_tmp4_ == ((guint) 0)) {
#line 365 "gitg-commit.c"
			GgitDiff* _tmp5_ = NULL;
			GgitRepository* _tmp6_ = NULL;
			GgitTree* _tmp7_ = NULL;
			GgitTree* _tmp8_ = NULL;
			GgitDiffOptions* _tmp9_ = NULL;
			GgitDiff* _tmp10_ = NULL;
			GgitDiff* _tmp11_ = NULL;
			GgitDiff* _tmp12_ = NULL;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp6_ = repo;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp7_ = ggit_commit_get_tree ((GgitCommit*) self);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp8_ = _tmp7_;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp9_ = options;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp10_ = ggit_diff_new_tree_to_tree (_tmp6_, NULL, _tmp8_, _tmp9_, &_inner_error_);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp11_ = _tmp10_;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp8_);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp5_ = _tmp11_;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
				_g_object_unref0 (parents);
#line 394 "gitg-commit.c"
				goto __catch20_g_error;
			}
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp12_ = _tmp5_;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp5_ = NULL;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (diff);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			diff = _tmp12_;
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp5_);
#line 407 "gitg-commit.c"
		} else {
			gint _tmp13_ = 0;
			GgitCommitParents* _tmp14_ = NULL;
			guint _tmp15_ = 0U;
			guint _tmp16_ = 0U;
			GgitDiff* _tmp20_ = NULL;
			GgitRepository* _tmp21_ = NULL;
			GgitCommitParents* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			GgitCommit* _tmp24_ = NULL;
			GgitCommit* _tmp25_ = NULL;
			GgitTree* _tmp26_ = NULL;
			GgitTree* _tmp27_ = NULL;
			GgitTree* _tmp28_ = NULL;
			GgitTree* _tmp29_ = NULL;
			GgitDiffOptions* _tmp30_ = NULL;
			GgitDiff* _tmp31_ = NULL;
			GgitDiff* _tmp32_ = NULL;
			GgitDiff* _tmp33_ = NULL;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp13_ = parent;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp14_ = parents;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp15_ = ggit_commit_parents_get_size (_tmp14_);
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp16_ = _tmp15_;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			if (((guint) _tmp13_) >= _tmp16_) {
#line 437 "gitg-commit.c"
				GgitCommitParents* _tmp17_ = NULL;
				guint _tmp18_ = 0U;
				guint _tmp19_ = 0U;
#line 136 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
				_tmp17_ = parents;
#line 136 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
				_tmp18_ = ggit_commit_parents_get_size (_tmp17_);
#line 136 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
				_tmp19_ = _tmp18_;
#line 136 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
				parent = ((gint) _tmp19_) - 1;
#line 449 "gitg-commit.c"
			}
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp21_ = repo;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp22_ = parents;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp23_ = parent;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp24_ = ggit_commit_parents_get (_tmp22_, (guint) _tmp23_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp25_ = _tmp24_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp26_ = ggit_commit_get_tree (_tmp25_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp27_ = _tmp26_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp28_ = ggit_commit_get_tree ((GgitCommit*) self);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp29_ = _tmp28_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp30_ = options;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp31_ = ggit_diff_new_tree_to_tree (_tmp21_, _tmp27_, _tmp29_, _tmp30_, &_inner_error_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp32_ = _tmp31_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp29_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp27_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp25_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp20_ = _tmp32_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
				_g_object_unref0 (parents);
#line 487 "gitg-commit.c"
				goto __catch20_g_error;
			}
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp33_ = _tmp20_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp20_ = NULL;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (diff);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			diff = _tmp33_;
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp20_);
#line 500 "gitg-commit.c"
		}
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_g_object_unref0 (parents);
#line 504 "gitg-commit.c"
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		FILE* _tmp34_ = NULL;
		GError* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		e = _inner_error_;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_inner_error_ = NULL;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp34_ = stderr;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp35_ = e;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp36_ = _tmp35_->message;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		fprintf (_tmp34_, "Error when getting diff: %s\n", _tmp36_);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_g_error_free0 (e);
#line 527 "gitg-commit.c"
	}
	__finally20:
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_g_object_unref0 (repo);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_g_object_unref0 (diff);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		return NULL;
#line 542 "gitg-commit.c"
	}
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp37_ = diff;
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	if (_tmp37_ != NULL) {
#line 548 "gitg-commit.c"
		{
			GgitDiff* _tmp38_ = NULL;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_tmp38_ = diff;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			ggit_diff_find_similar (_tmp38_, NULL, &_inner_error_);
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 557 "gitg-commit.c"
				goto __catch21_g_error;
			}
		}
		goto __finally21;
		__catch21_g_error:
		{
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			g_clear_error (&_inner_error_);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_inner_error_ = NULL;
#line 568 "gitg-commit.c"
		}
		__finally21:
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (repo);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (diff);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			g_clear_error (&_inner_error_);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
			return NULL;
#line 583 "gitg-commit.c"
		}
	}
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = diff;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (repo);
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 592 "gitg-commit.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 599 "gitg-commit.c"
}


GgitNote* gitg_commit_get_note (GitgCommit* self) {
	GgitNote* result = NULL;
	GgitNote* note = NULL;
	GgitRepository* repo = NULL;
	GgitRepository* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 161 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	note = NULL;
#line 165 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_object_get_owner ((GgitObject*) self);
#line 165 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	repo = _tmp0_;
#line 617 "gitg-commit.c"
	{
		GgitNote* _tmp1_ = NULL;
		GgitOId* _tmp2_ = NULL;
		GgitOId* _tmp3_ = NULL;
		GgitNote* _tmp4_ = NULL;
		GgitNote* _tmp5_ = NULL;
		GgitNote* _tmp6_ = NULL;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp2_ = ggit_object_get_id ((GgitObject*) self);
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp3_ = _tmp2_;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp4_ = ggit_repository_read_note (repo, NULL, _tmp3_, &_inner_error_);
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp5_ = _tmp4_;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		__vala_GgitOId_free0 (_tmp3_);
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp1_ = _tmp5_;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 639 "gitg-commit.c"
			goto __catch22_g_error;
		}
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp6_ = _tmp1_;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_tmp1_ = NULL;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_ggit_note_unref0 (note);
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		note = _tmp6_;
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_ggit_note_unref0 (_tmp1_);
#line 652 "gitg-commit.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		e = _inner_error_;
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_inner_error_ = NULL;
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_g_error_free0 (e);
#line 664 "gitg-commit.c"
	}
	__finally22:
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_g_object_unref0 (repo);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		_ggit_note_unref0 (note);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_clear_error (&_inner_error_);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		return NULL;
#line 679 "gitg-commit.c"
	}
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = note;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (repo);
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 687 "gitg-commit.c"
}


GitgCommit* gitg_commit_construct (GType object_type) {
	GitgCommit * self = NULL;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self = (GitgCommit*) g_object_new (object_type, NULL);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return self;
#line 697 "gitg-commit.c"
}


GitgCommit* gitg_commit_new (void) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return gitg_commit_construct (GITG_TYPE_COMMIT);
#line 704 "gitg-commit.c"
}


GitgLaneTag gitg_commit_get_tag (GitgCommit* self) {
	GitgLaneTag result;
	GitgLaneTag _tmp0_ = 0;
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->_tag;
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp0_;
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 719 "gitg-commit.c"
}


void gitg_commit_set_tag (GitgCommit* self, GitgLaneTag value) {
	GitgLaneTag _tmp0_ = 0;
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = value;
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self->priv->_tag = _tmp0_;
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_notify ((GObject *) self, "tag");
#line 733 "gitg-commit.c"
}


guint gitg_commit_get_mylane (GitgCommit* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_mylane;
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp0_;
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 748 "gitg-commit.c"
}


void gitg_commit_set_mylane (GitgCommit* self, guint value) {
	guint _tmp0_ = 0U;
#line 38 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = value;
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self->priv->d_mylane = _tmp0_;
#line 41 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	gitg_commit_update_lane_tag (self);
#line 38 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_notify ((GObject *) self, "mylane");
#line 764 "gitg-commit.c"
}


GitgLane* gitg_commit_get_lane (GitgCommit* self) {
	GitgLane* result;
	GSList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_lanes;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = self->priv->d_mylane;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = g_slist_nth_data (_tmp0_, _tmp1_);
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = (GitgLane*) _tmp2_;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 785 "gitg-commit.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 798 "gitg-commit.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 829 "gitg-commit.c"
				goto __catch23_g_regex_error;
			}
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			return NULL;
#line 838 "gitg-commit.c"
		}
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 854 "gitg-commit.c"
				goto __catch23_g_regex_error;
			}
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
			return NULL;
#line 865 "gitg-commit.c"
		}
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 879 "gitg-commit.c"
	}
	goto __finally23;
	__catch23_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 893 "gitg-commit.c"
	}
	__finally23:
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		return NULL;
#line 904 "gitg-commit.c"
	}
}


gchar* gitg_commit_get_format_patch_name (GitgCommit* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 90 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_commit_get_subject ((GgitCommit*) self);
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = string_replace (_tmp0_, " ", "-");
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = _tmp1_;
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = string_replace (_tmp2_, "/", "-");
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = _tmp3_;
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_free0 (_tmp2_);
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp4_;
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 934 "gitg-commit.c"
}


gchar* gitg_commit_get_committer_date_for_display (GitgCommit* self) {
	gchar* result;
	GDateTime* dt = NULL;
	GgitSignature* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GitgDate* _tmp4_ = NULL;
	GitgDate* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_commit_get_committer ((GgitCommit*) self);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = _tmp0_;
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = ggit_signature_get_time (_tmp1_);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = _tmp2_;
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp1_);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	dt = _tmp3_;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = gitg_date_new_for_date_time (dt);
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp5_ = _tmp4_;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp6_ = gitg_date_for_display (_tmp5_);
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp7_ = _tmp6_;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp7_;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_date_time_unref0 (dt);
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 979 "gitg-commit.c"
}


gchar* gitg_commit_get_author_date_for_display (GitgCommit* self) {
	gchar* result;
	GDateTime* dt = NULL;
	GgitSignature* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GitgDate* _tmp4_ = NULL;
	GitgDate* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_commit_get_author ((GgitCommit*) self);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = _tmp0_;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = ggit_signature_get_time (_tmp1_);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = _tmp2_;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp1_);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	dt = _tmp3_;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = gitg_date_new_for_date_time (dt);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp5_ = _tmp4_;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp6_ = gitg_date_for_display (_tmp5_);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	result = _tmp7_;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	_g_date_time_unref0 (dt);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	return result;
#line 1024 "gitg-commit.c"
}


static void gitg_commit_class_init (GitgCommitClass * klass) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	gitg_commit_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_type_class_add_private (klass, sizeof (GitgCommitPrivate));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_get_property;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_set_property;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_finalize;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_TAG, g_param_spec_flags ("tag", "tag", "tag", GITG_TYPE_LANE_TAG, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_MYLANE, g_param_spec_uint ("mylane", "mylane", "mylane", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_LANE, g_param_spec_object ("lane", "lane", "lane", GITG_TYPE_LANE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_FORMAT_PATCH_NAME, g_param_spec_string ("format-patch-name", "format-patch-name", "format-patch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY, g_param_spec_string ("committer-date-for-display", "committer-date-for-display", "committer-date-for-display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY, g_param_spec_string ("author-date-for-display", "author-date-for-display", "author-date-for-display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1051 "gitg-commit.c"
}


static void gitg_commit_instance_init (GitgCommit * self) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self->priv = GITG_COMMIT_GET_PRIVATE (self);
#line 1058 "gitg-commit.c"
}


static void gitg_commit_finalize (GObject* obj) {
	GitgCommit * self;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT, GitgCommit);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	__g_slist_free__g_object_unref0_0 (self->priv->d_lanes);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (gitg_commit_parent_class)->finalize (obj);
#line 1070 "gitg-commit.c"
}


GType gitg_commit_get_type (void) {
	static volatile gsize gitg_commit_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_commit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgCommitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommit), 0, (GInstanceInitFunc) gitg_commit_instance_init, NULL };
		GType gitg_commit_type_id;
		gitg_commit_type_id = g_type_register_static (ggit_commit_get_type (), "GitgCommit", &g_define_type_info, 0);
		g_once_init_leave (&gitg_commit_type_id__volatile, gitg_commit_type_id);
	}
	return gitg_commit_type_id__volatile;
}


static void _vala_gitg_commit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT, GitgCommit);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	switch (property_id) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_TAG:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_value_set_flags (value, gitg_commit_get_tag (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_MYLANE:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_value_set_uint (value, gitg_commit_get_mylane (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_LANE:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_value_set_object (value, gitg_commit_get_lane (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_FORMAT_PATCH_NAME:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_value_take_string (value, gitg_commit_get_format_patch_name (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_value_take_string (value, gitg_commit_get_committer_date_for_display (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		g_value_take_string (value, gitg_commit_get_author_date_for_display (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 1127 "gitg-commit.c"
		default:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 1133 "gitg-commit.c"
	}
}


static void _vala_gitg_commit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT, GitgCommit);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
	switch (property_id) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_TAG:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		gitg_commit_set_tag (self, g_value_get_flags (value));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_MYLANE:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		gitg_commit_set_mylane (self, g_value_get_uint (value));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 1155 "gitg-commit.c"
		default:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-commit.vala"
		break;
#line 1161 "gitg-commit.c"
	}
}



