#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.gcm"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[2304]; const double alignment; void * const ptr;}  gcm_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x00, 0x00, 0xd4, 0xb5, 0x02, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x4c, 0x00, 0xb0, 0x00, 0x00, 0x00, 
  0xb4, 0x00, 0x00, 0x00, 0x4b, 0x50, 0x90, 0x0b, 
  0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x4c, 0x00, 0xb8, 0x00, 0x00, 0x00, 
  0xbc, 0x00, 0x00, 0x00, 0xf4, 0x3c, 0xaf, 0x8f, 
  0x03, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 
  0x0d, 0x00, 0x76, 0x00, 0xd0, 0x00, 0x00, 0x00, 
  0xdf, 0x08, 0x00, 0x00, 0x66, 0xec, 0xb7, 0xce, 
  0x04, 0x00, 0x00, 0x00, 0xdf, 0x08, 0x00, 0x00, 
  0x0e, 0x00, 0x4c, 0x00, 0xf0, 0x08, 0x00, 0x00, 
  0xf4, 0x08, 0x00, 0x00, 0xb0, 0xb7, 0x24, 0x30, 
  0x01, 0x00, 0x00, 0x00, 0xf4, 0x08, 0x00, 0x00, 
  0x06, 0x00, 0x4c, 0x00, 0xfc, 0x08, 0x00, 0x00, 
  0x00, 0x09, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x6f, 0x72, 0x67, 0x2f, 
  0x04, 0x00, 0x00, 0x00, 0x67, 0x63, 0x6d, 0x2d, 
  0x70, 0x69, 0x63, 0x6b, 0x65, 0x72, 0x2e, 0x75, 
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x2d, 0x43, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0xed, 0x5c, 0xdd, 0x53, 0xe3, 0x38, 
  0x12, 0x7f, 0xcf, 0x5f, 0xd1, 0xe7, 0xa7, 0x99, 
  0xba, 0x84, 0x24, 0x70, 0xb3, 0xbb, 0x57, 0x03, 
  0xd9, 0x0b, 0x2c, 0x30, 0x54, 0x0d, 0x0c, 0x15, 
  0x42, 0xcd, 0x71, 0x2f, 0x2e, 0xd9, 0xee, 0xc4, 
  0x3a, 0x64, 0xcb, 0x2b, 0xc9, 0x09, 0xb9, 0xbf, 
  0x7e, 0x5b, 0xb6, 0x93, 0x00, 0x71, 0xbe, 0x60, 
  0x86, 0x4b, 0xa8, 0xbc, 0x30, 0x76, 0xa4, 0x96, 
  0xfa, 0xeb, 0xd7, 0xb2, 0x5a, 0xea, 0x39, 0xfc, 
  0xfd, 0x21, 0x12, 0x30, 0x40, 0xa5, 0xb9, 0x8c, 
  0x8f, 0x9c, 0xe6, 0x5e, 0xc3, 0x01, 0x8c, 0x7d, 
  0x19, 0xf0, 0xb8, 0x7f, 0xe4, 0xdc, 0x76, 0xcf, 
  0x6a, 0xbf, 0x39, 0xbf, 0xb7, 0x2a, 0x87, 0x7f, 
  0xab, 0xd5, 0xe0, 0x1c, 0x63, 0x54, 0xcc, 0x60, 
  0x00, 0x43, 0x6e, 0x42, 0xe8, 0x0b, 0x16, 0x20, 
  0x1c, 0xec, 0x35, 0x7f, 0xdb, 0x6b, 0x42, 0xa5, 
  0x72, 0x7e, 0xf5, 0xed, 0xf2, 0x14, 0x4e, 0xa4, 
  0x90, 0x0a, 0x2e, 0x59, 0xcc, 0xfa, 0xa8, 0x2a, 
  0x27, 0x32, 0x19, 0x29, 0xde, 0x0f, 0x0d, 0x7c, 
  0x38, 0xf9, 0x08, 0xfb, 0x8d, 0x66, 0xb3, 0x46, 
  0x7f, 0x0e, 0xa0, 0xc3, 0xfd, 0x90, 0xa9, 0x00, 
  0xbe, 0xa4, 0xfd, 0x10, 0x35, 0x1c, 0xaa, 0xfc, 
  0xfd, 0x5f, 0x21, 0xbd, 0x6b, 0x8e, 0x7b, 0xbe, 
  0x8c, 0x5a, 0x95, 0x4a, 0x37, 0xe4, 0x1a, 0x12, 
  0x25, 0xfb, 0x8a, 0x45, 0x40, 0x8f, 0x3d, 0x85, 
  0x08, 0x5a, 0xf6, 0xcc, 0x90, 0x29, 0xfc, 0x0c, 
  0x23, 0x99, 0x82, 0xcf, 0x62, 0x50, 0x18, 0x70, 
  0x6d, 0x14, 0xf7, 0x52, 0x83, 0xc0, 0x0d, 0xb0, 
  0x38, 0xa8, 0x4b, 0x55, 0x89, 0x48, 0x86, 0xde, 
  0xc8, 0xfe, 0x90, 0xc6, 0x01, 0x2a, 0x30, 0x21, 
  0x82, 0x41, 0x15, 0x69, 0x90, 0xbd, 0xec, 0xe5, 
  0xfc, 0xea, 0xb6, 0x10, 0x49, 0xc0, 0x75, 0xea, 
  0x09, 0xee, 0xc3, 0x57, 0xee, 0x63, 0xac, 0xb1, 
  0xc2, 0x68, 0x5e, 0xfb, 0x8b, 0x0e, 0x49, 0x58, 
  0x6f, 0x94, 0x75, 0x3f, 0xb3, 0xb3, 0xdf, 0x14, 
  0xb3, 0xc3, 0x99, 0xa4, 0x51, 0x99, 0x21, 0xa5, 
  0x7d, 0x06, 0x24, 0x6d, 0xd0, 0x04, 0x85, 0x12, 
  0x61, 0xbf, 0x52, 0x4c, 0x50, 0x8c, 0x56, 0x05, 
  0xd2, 0xc8, 0x07, 0x66, 0x2c, 0xc3, 0x0a, 0x64, 
  0x62, 0x89, 0x3e, 0x12, 0x97, 0x23, 0x10, 0xa4, 
  0xcc, 0x09, 0xdd, 0xde, 0xac, 0xc0, 0x53, 0xb9, 
  0x02, 0xe0, 0x71, 0x36, 0x66, 0x28, 0x13, 0x12, 
  0x23, 0xa4, 0xd1, 0x48, 0xb0, 0x21, 0x17, 0x02, 
  0x3c, 0x84, 0x54, 0x63, 0x2f, 0x15, 0xd5, 0x0a, 
  0xf5, 0x84, 0xef, 0x17, 0xdd, 0x2f, 0xdf, 0x6e, 
  0xbb, 0xd0, 0xbe, 0xba, 0x83, 0xef, 0xed, 0x4e, 
  0xa7, 0x7d, 0xd5, 0xbd, 0xfb, 0x9c, 0x19, 0x4c, 
  0x52, 0x2b, 0x0e, 0x30, 0x1f, 0x87, 0x47, 0x89, 
  0xe0, 0xd6, 0x92, 0x4c, 0x29, 0x16, 0x9b, 0x11, 
  0x29, 0xa5, 0x72, 0x79, 0xda, 0x39, 0xf9, 0x42, 
  0xfd, 0xdb, 0xc7, 0x17, 0x5f, 0x2f, 0xba, 0x77, 
  0x96, 0xed, 0xb3, 0x8b, 0xee, 0xd5, 0xe9, 0xcd, 
  0x0d, 0x9c, 0x7d, 0xeb, 0x40, 0x1b, 0xae, 0xdb, 
  0x9d, 0xee, 0xc5, 0xc9, 0xed, 0xd7, 0x76, 0x07, 
  0xae, 0x6f, 0x3b, 0xd7, 0xdf, 0x6e, 0x4e, 0xf7, 
  0x00, 0x6e, 0xd0, 0x32, 0x84, 0x95, 0xf9, 0xea, 
  0x84, 0x1e, 0x8d, 0x14, 0x49, 0xd2, 0x5a, 0x80, 
  0x86, 0x71, 0xa1, 0x49, 0xd4, 0x3b, 0x32, 0x9e, 
  0x26, 0x96, 0x44, 0x00, 0x21, 0x1b, 0x20, 0x19, 
  0xd1, 0x47, 0x3e, 0x20, 0x86, 0x18, 0xf8, 0xe4, 
  0x34, 0xab, 0xd8, 0x48, 0xc8, 0xb8, 0x9f, 0x7b, 
  0xa2, 0x79, 0xa4, 0xb7, 0xcf, 0xc0, 0x7b, 0x10, 
  0x4b, 0x53, 0x85, 0xa1, 0xe2, 0xe4, 0x10, 0x46, 
  0xce, 0x5a, 0xaf, 0x32, 0xb5, 0x5e, 0x15, 0x2e, 
  0x62, 0x7f, 0xaf, 0x0a, 0x9f, 0x9a, 0xd4, 0x85, 
  0xc5, 0xf7, 0x82, 0xf4, 0x7c, 0x63, 0xa8, 0x33, 
  0x0d, 0x70, 0xc6, 0x7b, 0x34, 0xf8, 0x99, 0x90, 
  0x52, 0x55, 0xe1, 0x58, 0x6a, 0x63, 0xbb, 0x5f, 
  0xb6, 0x01, 0x1a, 0xfb, 0xcd, 0x66, 0xa3, 0xd6, 
  0x3c, 0x68, 0x34, 0xab, 0x70, 0x7b, 0xd3, 0x26, 
  0x71, 0x6a, 0x35, 0xc2, 0x08, 0x8f, 0xc9, 0x9c, 
  0x3d, 0xe6, 0x63, 0xab, 0x02, 0xe4, 0xd3, 0xf8, 
  0x67, 0xca, 0x15, 0x79, 0xb7, 0xe0, 0xde, 0x91, 
  0xd3, 0x37, 0xf7, 0x7f, 0x77, 0xa6, 0x38, 0x23, 
  0xd4, 0x34, 0x9c, 0x7a, 0xd6, 0x4f, 0x7a, 0xff, 
  0x45, 0xdf, 0x80, 0x2f, 0x98, 0xd6, 0x47, 0xce, 
  0xb9, 0xb9, 0xff, 0x83, 0x93, 0x68, 0x7d, 0x07, 
  0x78, 0x70, 0xe4, 0x04, 0xd9, 0xb3, 0x9b, 0x70, 
  0xff, 0x1e, 0x95, 0x63, 0xfb, 0x13, 0x05, 0x49, 
  0x9a, 0xa0, 0x22, 0x9b, 0xc5, 0x2c, 0xc2, 0x23, 
  0x87, 0x30, 0xe0, 0xf6, 0xa4, 0x9f, 0x6a, 0xa7, 
  0x75, 0xc6, 0x84, 0xc6, 0xc3, 0xfa, 0xb8, 0x43, 
  0x79, 0x7f, 0x4f, 0x2a, 0xc2, 0x83, 0x3b, 0xe4, 
  0x81, 0x09, 0x9d, 0xd6, 0xc1, 0xb2, 0xee, 0x86, 
  0x1b, 0x81, 0x0e, 0x18, 0xd2, 0x8e, 0x26, 0x87, 
  0x65, 0x9e, 0xa0, 0x1f, 0x47, 0xa8, 0x1d, 0x32, 
  0x54, 0x14, 0x61, 0x6c, 0x88, 0xeb, 0xef, 0x3c, 
  0x0e, 0xe4, 0x10, 0xb2, 0xae, 0xa4, 0x78, 0x42, 
  0x43, 0xe6, 0x13, 0xd6, 0x31, 0x55, 0x86, 0x51, 
  0x2b, 0x00, 0xe8, 0x44, 0x92, 0x9c, 0x36, 0x40, 
  0x68, 0x6a, 0xa1, 0x00, 0x43, 0xc6, 0x8e, 0x90, 
  0xe9, 0x54, 0xd9, 0xe7, 0x00, 0x07, 0x64, 0x59, 
  0xa7, 0x95, 0x47, 0x90, 0xeb, 0x4c, 0xe2, 0x65, 
  0xbc, 0x71, 0x5f, 0xc6, 0xae, 0x7d, 0x74, 0x5a, 
  0xfd, 0x58, 0x46, 0x58, 0xcb, 0x46, 0xaf, 0x45, 
  0x79, 0xf8, 0x59, 0x2a, 0xd9, 0x28, 0x41, 0x37, 
  0x24, 0xab, 0x39, 0xad, 0x5c, 0xcf, 0x33, 0x04, 
  0x7e, 0xc8, 0x85, 0x85, 0x1e, 0xd9, 0x35, 0x66, 
  0xa2, 0x96, 0xbd, 0x1e, 0x39, 0x03, 0x4f, 0x3e, 
  0x14, 0xb6, 0x28, 0xb3, 0xdf, 0x31, 0xb5, 0x3e, 
  0x32, 0x5e, 0xcd, 0x76, 0x6f, 0x4e, 0xfa, 0xcf, 
  0xb2, 0x31, 0xe0, 0x9a, 0x93, 0x52, 0x9d, 0x56, 
  0x57, 0xa5, 0x33, 0xc6, 0x7b, 0x89, 0xc1, 0xcb, 
  0x68, 0x22, 0xa6, 0xfa, 0x3c, 0x76, 0x05, 0xf6, 
  0x48, 0xda, 0xe6, 0xfe, 0x1a, 0x24, 0x59, 0xfc, 
  0x5e, 0x93, 0xc6, 0xc8, 0x64, 0x4d, 0x0a, 0x4f, 
  0x1a, 0x23, 0xa3, 0x55, 0x89, 0xa4, 0xe2, 0xe4, 
  0x78, 0x19, 0x80, 0x9d, 0x16, 0x81, 0xca, 0x70, 
  0x9f, 0x89, 0x55, 0x08, 0x75, 0xc2, 0x7c, 0x72, 
  0x36, 0xa7, 0x55, 0x3e, 0x4d, 0xb9, 0xbd, 0x99, 
  0x6f, 0x27, 0x72, 0x29, 0x70, 0xb0, 0x47, 0x66, 
  0x2c, 0x35, 0x7d, 0x4a, 0x52, 0xc4, 0xcf, 0x1d, 
  0xe0, 0x11, 0x7d, 0xf3, 0xc9, 0x00, 0x2f, 0x33, 
  0x2d, 0x51, 0xd5, 0xf3, 0x99, 0x9f, 0xfc, 0x46, 
  0x92, 0xdd, 0x93, 0x68, 0x8b, 0xc7, 0xc7, 0x87, 
  0x84, 0x96, 0xc7, 0x85, 0x83, 0xcf, 0x12, 0xf5, 
  0x68, 0x99, 0x59, 0x93, 0x24, 0x91, 0x9a, 0xe7, 
  0xd6, 0x69, 0xcc, 0x13, 0x61, 0x86, 0xdf, 0xc3, 
  0x7a, 0xa6, 0xef, 0xe7, 0xe6, 0x58, 0xa2, 0xf1, 
  0xb1, 0xae, 0x9f, 0x81, 0xec, 0x45, 0x40, 0x7b, 
  0xb9, 0x45, 0x5e, 0xe1, 0xa2, 0x0b, 0xdd, 0xf4, 
  0x9f, 0x73, 0x29, 0x66, 0x74, 0x53, 0xae, 0x9f, 
  0x8b, 0x88, 0x22, 0x61, 0xae, 0x21, 0x6e, 0x1f, 
  0xdd, 0x44, 0x51, 0x9c, 0xc5, 0xa1, 0xf3, 0x9c, 
  0xf4, 0x85, 0xea, 0x7a, 0x8d, 0xca, 0xca, 0x68, 
  0xc3, 0xb1, 0x87, 0xae, 0x3b, 0xe9, 0x60, 0x35, 
  0xc2, 0x32, 0xe8, 0xcc, 0x87, 0xcf, 0x22, 0x08, 
  0xad, 0xcb, 0x60, 0x8e, 0xa2, 0x75, 0xa9, 0x96, 
  0x02, 0x69, 0x0e, 0x98, 0x4a, 0x01, 0xb5, 0x8e, 
  0xe3, 0x9c, 0x66, 0x62, 0xd2, 0x47, 0x47, 0xe6, 
  0x3b, 0x58, 0xbc, 0xb9, 0xf4, 0x41, 0x93, 0x0a, 
  0xa3, 0xdf, 0xc8, 0x7d, 0x96, 0x92, 0x96, 0x0a, 
  0x53, 0x2e, 0xd0, 0xb9, 0xe2, 0x41, 0x2e, 0x4c, 
  0x9f, 0x9e, 0x16, 0x08, 0xf2, 0x2a, 0x61, 0x5e, 
  0x8b, 0x87, 0x52, 0x4c, 0x30, 0xc1, 0xfb, 0xe4, 
  0x01, 0xf4, 0xdd, 0x6b, 0x66, 0xbf, 0x6a, 0x96, 
  0x51, 0x2b, 0x39, 0x74, 0x27, 0xf1, 0xe4, 0x60, 
  0x6d, 0xde, 0xa5, 0x48, 0xa3, 0x78, 0x3a, 0x40, 
  0xf9, 0xfa, 0xbc, 0x9a, 0x4d, 0xca, 0xed, 0xf2, 
  0x95, 0x79, 0x28, 0x72, 0xc3, 0x08, 0xfb, 0xe8, 
  0x3e, 0x8c, 0xfe, 0xe7, 0xcc, 0x23, 0x7f, 0xa5, 
  0x65, 0x7e, 0x84, 0x75, 0x4a, 0xe3, 0x35, 0x0a, 
  0x12, 0x8a, 0xbd, 0x8a, 0x8f, 0x87, 0xc2, 0xca, 
  0x8d, 0xe5, 0xc4, 0xf3, 0x82, 0xd8, 0xf2, 0x60, 
  0x36, 0x6f, 0x72, 0xfb, 0x5d, 0xe8, 0x32, 0x63, 
  0x98, 0x4f, 0x5b, 0x82, 0xe6, 0x4b, 0xd8, 0xa7, 
  0x4f, 0xbe, 0xc9, 0x00, 0x2b, 0x89, 0xb0, 0x90, 
  0xc7, 0xd2, 0xd0, 0xf5, 0x23, 0x3d, 0xcc, 0xcd, 
  0xb7, 0x35, 0x5b, 0xe6, 0x67, 0x22, 0x97, 0x64, 
  0xe1, 0x5e, 0xcc, 0xee, 0xbb, 0xb2, 0x6d, 0x10, 
  0xed, 0xa9, 0x69, 0xb1, 0xd7, 0xd3, 0xaf, 0x90, 
  0x7f, 0xdf, 0xfd, 0xe7, 0x35, 0x8e, 0xb9, 0x9a, 
  0x5b, 0x68, 0x33, 0x12, 0x38, 0xbf, 0xdd, 0x5a, 
  0xcf, 0x1a, 0xa6, 0x18, 0x3b, 0xe0, 0x51, 0x2d, 
  0x17, 0xaa, 0xbe, 0x60, 0xcc, 0xfa, 0xc2, 0x41, 
  0x7f, 0x32, 0x1a, 0x1a, 0xef, 0x1d, 0x0d, 0xf4, 
  0xf7, 0xfd, 0xa2, 0x81, 0xa4, 0xb5, 0x99, 0xb4, 
  0x79, 0xa0, 0xb0, 0xc9, 0x42, 0xf8, 0xe3, 0x53, 
  0x63, 0xdc, 0x67, 0x18, 0xda, 0x9c, 0x51, 0x22, 
  0xb3, 0xa4, 0x80, 0xa5, 0xfd, 0x40, 0x8d, 0x1f, 
  0x77, 0xa8, 0x79, 0x7b, 0xd4, 0x34, 0x37, 0x1c, 
  0x35, 0x99, 0xa7, 0x64, 0x8e, 0xf2, 0x7e, 0xc1, 
  0x93, 0xe5, 0xa3, 0x15, 0xf6, 0x50, 0xe9, 0x71, 
  0x1e, 0x95, 0x45, 0x32, 0x8d, 0x8d, 0x4d, 0xcf, 
  0xb2, 0xc8, 0xb3, 0x3b, 0x5c, 0x10, 0x59, 0x7e, 
  0x5f, 0xe6, 0x69, 0x65, 0x02, 0x96, 0x96, 0xca, 
  0x69, 0x5d, 0x62, 0xc0, 0x19, 0x4c, 0x75, 0xb4, 
  0x43, 0xd0, 0xdb, 0x23, 0x68, 0x7f, 0xc3, 0x11, 
  0x64, 0x30, 0x4a, 0xec, 0x79, 0x52, 0xaa, 0x70, 
  0x07, 0xa1, 0x59, 0x08, 0xe5, 0x79, 0xf0, 0xee, 
  0x54, 0x49, 0x3b, 0x0c, 0xbd, 0x3d, 0x86, 0x0e, 
  0x36, 0x1c, 0x43, 0x85, 0x07, 0xed, 0xf0, 0x33, 
  0x8b, 0x9f, 0x76, 0xde, 0xb8, 0x43, 0xcd, 0xdb, 
  0xa3, 0xe6, 0x1f, 0x1b, 0x8e, 0x9a, 0xfc, 0x0c, 
  0x92, 0x18, 0x78, 0xbf, 0x90, 0x29, 0xf6, 0x33, 
  0x59, 0x5c, 0xb0, 0xc0, 0xb1, 0xc7, 0xea, 0x91, 
  0x27, 0x3d, 0xf9, 0x90, 0xdf, 0x1e, 0xd0, 0x43, 
  0x6e, 0x7c, 0x7b, 0xf7, 0xc2, 0xf6, 0xea, 0x9c, 
  0x1f, 0x53, 0x73, 0x3c, 0xbe, 0xc0, 0xe0, 0xa1, 
  0x19, 0x22, 0xc6, 0x10, 0xf0, 0x1e, 0xe1, 0xce, 
  0x02, 0x6c, 0xaa, 0x30, 0x0d, 0x3a, 0xf5, 0x43, 
  0x60, 0x1a, 0xda, 0x81, 0xf4, 0x72, 0x52, 0xbb, 
  0x87, 0xd2, 0xf4, 0x50, 0xac, 0x59, 0x59, 0xbf, 
  0x1d, 0xec, 0xde, 0x1e, 0x76, 0x9f, 0x36, 0x1c, 
  0x76, 0xaa, 0xef, 0xbd, 0xe7, 0x85, 0x0a, 0x35, 
  0xad, 0x4d, 0xc5, 0xc5, 0x87, 0x01, 0x13, 0x29, 
  0x4e, 0x6e, 0x1a, 0xf9, 0xa1, 0xa4, 0x55, 0xa9, 
  0x48, 0x40, 0xf0, 0x18, 0x3a, 0x18, 0x54, 0xe1, 
  0x5c, 0x11, 0xc6, 0xaa, 0x70, 0x4c, 0x1d, 0x27, 
  0x37, 0xae, 0x9c, 0x16, 0xc1, 0x68, 0x07, 0x9d, 
  0xb7, 0x87, 0xce, 0x2f, 0x1b, 0x0e, 0x1d, 0x54, 
  0x4a, 0xaa, 0x77, 0xfe, 0x95, 0xa7, 0x43, 0x39, 
  0xcc, 0xd7, 0xa3, 0x4c, 0xda, 0xf1, 0x8d, 0xb7, 
  0x47, 0x0b, 0x13, 0xad, 0x63, 0x84, 0x8f, 0x3d, 
  0xa7, 0x75, 0x6a, 0x3b, 0xec, 0x70, 0xf2, 0xf6, 
  0x38, 0xf9, 0x75, 0xf3, 0x73, 0xd9, 0xbb, 0xb3, 
  0xc3, 0xad, 0x3e, 0x3b, 0xdc, 0x9e, 0xbc, 0xef, 
  0xce, 0xd1, 0xb6, 0xda, 0xd1, 0xf6, 0xb7, 0x23, 
  0xb5, 0xb3, 0xf3, 0xb2, 0xad, 0xf6, 0xb2, 0x0d, 
  0x4b, 0x85, 0x9c, 0xd8, 0x24, 0xc0, 0xe4, 0xce, 
  0xe4, 0x38, 0x25, 0xb0, 0x35, 0x09, 0x91, 0x4d, 
  0xb7, 0xf6, 0x16, 0xec, 0xc0, 0x77, 0xf1, 0x64, 
  0xab, 0x3d, 0xec, 0x97, 0xed, 0x39, 0xd4, 0xdb, 
  0x79, 0xda, 0x56, 0x7b, 0xda, 0xc1, 0x36, 0xa4, 
  0x44, 0x76, 0x3e, 0xb6, 0xd5, 0x3e, 0xf6, 0x53, 
  0xd3, 0x09, 0xf3, 0x85, 0x9f, 0x4b, 0x54, 0x14, 
  0x00, 0xd9, 0xc2, 0xb0, 0x71, 0xe2, 0x6a, 0xb5, 
  0xcb, 0xe5, 0xcf, 0xbd, 0xb3, 0xb9, 0x0d, 0xf7, 
  0xca, 0x57, 0xc9, 0xcc, 0x8d, 0xcb, 0x00, 0xc6, 
  0xb5, 0x7d, 0x36, 0x23, 0x57, 0x5c, 0x9d, 0x87, 
  0x9e, 0x92, 0xd1, 0xa3, 0x9b, 0x75, 0xe3, 0x22, 
  0xc5, 0x4e, 0xde, 0xbc, 0x94, 0x1b, 0x72, 0x82, 
  0xbc, 0xb8, 0x55, 0xcf, 0xb5, 0xfd, 0xa4, 0x4b, 
  0xc1, 0xf1, 0x10, 0xb3, 0x62, 0xb4, 0x3c, 0xbd, 
  0x6e, 0x6b, 0x7e, 0x44, 0x30, 0x2f, 0xd9, 0x76, 
  0x58, 0x5f, 0x3c, 0xfe, 0xda, 0xde, 0xf1, 0xe3, 
  0x2a, 0x47, 0xd6, 0x2e, 0x8a, 0x59, 0xa1, 0x00, 
  0xab, 0x8c, 0x6c, 0x5a, 0x3b, 0xd2, 0xfc, 0x11, 
  0xb5, 0x23, 0xaf, 0xaf, 0x3a, 0x5b, 0xa7, 0xee, 
  0x6a, 0x79, 0xb9, 0xcc, 0x4f, 0xa8, 0x39, 0x7b, 
  0x2a, 0xe2, 0x93, 0xc6, 0x27, 0xa1, 0x21, 0x03, 
  0x83, 0xc7, 0xd4, 0x82, 0x2a, 0xd0, 0x2f, 0xc8, 
  0x08, 0x36, 0xc7, 0xac, 0x28, 0xa0, 0x09, 0xb3, 
  0xd7, 0xc7, 0x24, 0xff, 0xa7, 0x42, 0xd0, 0xe2, 
  0x0c, 0x61, 0x51, 0x95, 0x6d, 0xe9, 0xc2, 0x15, 
  0xca, 0xa1, 0xeb, 0x0b, 0xa9, 0xd1, 0xf5, 0xb2, 
  0x22, 0xc7, 0x05, 0x5c, 0xae, 0x52, 0xb6, 0x97, 
  0x8f, 0x91, 0x57, 0xee, 0x65, 0xcf, 0x6e, 0x5e, 
  0x09, 0x8c, 0x4b, 0x6a, 0xf8, 0x56, 0x89, 0x59, 
  0xf9, 0xe0, 0x60, 0xf0, 0xc1, 0x54, 0xed, 0x99, 
  0x41, 0x1f, 0x0d, 0x30, 0xb0, 0x05, 0xc7, 0x02, 
  0x41, 0xb3, 0x28, 0xa1, 0x7f, 0x64, 0x2f, 0x8f, 
  0x5a, 0x4e, 0xcb, 0xbd, 0xcc, 0x27, 0x5e, 0xd5, 
  0xcd, 0x52, 0x52, 0xc1, 0xb8, 0xa2, 0x33, 0x49, 
  0x90, 0x11, 0x27, 0x76, 0xdb, 0xbc, 0x56, 0x71, 
  0xe0, 0x6b, 0x2b, 0x11, 0xd7, 0x21, 0x2b, 0x2a, 
  0xeb, 0xb5, 0x1b, 0x60, 0x8f, 0x51, 0x60, 0x5e, 
  0x8f, 0xda, 0x4a, 0x9b, 0xfd, 0xff, 0x09, 0x82, 
  0xc7, 0x6b, 0xf2, 0x5b, 0xd4, 0x1b, 0x4e, 0x50, 
  0x49, 0x0b, 0xff, 0x5c, 0xd2, 0xd2, 0x43, 0x91, 
  0x27, 0xa7, 0x2b, 0x3a, 0xed, 0xf7, 0x51, 0x1b, 
  0x0c, 0x8a, 0x72, 0xda, 0xe7, 0x71, 0xbf, 0xe4, 
  0x60, 0x65, 0x36, 0x60, 0xad, 0x0a, 0xf7, 0x69, 
  0xc3, 0x61, 0xfd, 0x51, 0x55, 0xff, 0x5f, 0x78, 
  0x06, 0x39, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29, 0x63, 
  0x6f, 0x6c, 0x6f, 0x72, 0x2d, 0x6d, 0x61, 0x6e, 
  0x61, 0x67, 0x65, 0x72, 0x2f, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x67, 0x6e, 0x6f, 0x6d, 
  0x65, 0x2f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00
} };

static GStaticResource static_resource = { gcm_resource_data.data, sizeof (gcm_resource_data.data), NULL, NULL, NULL };
extern GResource *gcm_get_resource (void);
GResource *gcm_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for Win32 (x86) and x64 programs, as symbols on Win32 are prefixed
 * with an underscore but symbols on x64 are not.
 */
#ifdef _WIN64
#define G_MSVC_SYMBOL_PREFIX ""
#else
#define G_MSVC_SYMBOL_PREFIX "_"
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
