/* rygel-media-export-db-container.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-media-export-db-container.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportDbContainerGetChildrenData RygelMediaExportDbContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportDbContainerSearchData RygelMediaExportDbContainerSearchData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediaExportDbContainerFindObjectData RygelMediaExportDbContainerFindObjectData;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportDBContainerPrivate {
	GeeArrayList* _search_classes;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportDbContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportDBContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaExportMediaCache* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _RygelMediaExportDbContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportDBContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	RygelMediaExportMediaCache* _tmp0_;
	RygelSearchExpression* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	GError* _error_;
	GError* _tmp8_;
	RygelSearchExpression* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GCancellable* _tmp12_;
	guint _tmp13_;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError * _inner_error_;
};

struct _RygelMediaExportDbContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportDBContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaExportMediaCache* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_db_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_media_export_db_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_SEARCH_CLASSES
};
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
static void rygel_media_export_db_container_on_db_container_updated (RygelMediaExportDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated);
static void _rygel_media_export_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
GQuark rygel_media_export_database_error_quark (void);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_db_container_real_get_children_data_free (gpointer _data);
static void rygel_media_export_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_db_container_real_get_children_co (RygelMediaExportDbContainerGetChildrenData* _data_);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error);
static void rygel_media_export_db_container_real_search_data_free (gpointer _data);
static void rygel_media_export_db_container_real_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_media_export_db_container_real_search_co (RygelMediaExportDbContainerSearchData* _data_);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
static void rygel_media_export_db_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_export_db_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_db_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_db_container_real_find_object_co (RygelMediaExportDbContainerFindObjectData* _data_);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
static void rygel_media_export_db_container_finalize (GObject* obj);
static void _vala_rygel_media_export_db_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_db_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 202 "rygel-media-export-db-container.c"
}


static void _rygel_media_export_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_on_db_container_updated (self, _sender, container);
#line 209 "rygel-media-export-db-container.c"
}


RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title) {
	RygelMediaExportDBContainer * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaExportMediaCache* _tmp2_;
	RygelMediaExportMediaCache* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp0_ = id;
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp1_ = title;
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self = (RygelMediaExportDBContainer*) rygel_media_container_construct (object_type, _tmp0_, NULL, _tmp1_, 0);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp2_ = media_db;
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (self->media_db);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self->media_db = _tmp3_;
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp5_ = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp5_);
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_tmp5_);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) _rygel_media_export_db_container_on_db_container_updated_rygel_media_container_container_updated, self, 0);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_on_db_container_updated (self, (RygelMediaContainer*) self, (RygelMediaContainer*) self);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return self;
#line 255 "rygel-media-export-db-container.c"
}


RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title) {
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return rygel_media_export_db_container_construct (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, media_db, id, title);
#line 262 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_on_db_container_updated (RygelMediaExportDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated) {
	GError * _inner_error_ = NULL;
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_return_if_fail (container != NULL);
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_return_if_fail (container_updated != NULL);
#line 274 "rygel-media-export-db-container.c"
	{
		RygelMediaExportMediaCache* _tmp0_;
		const gchar* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_tmp0_ = self->media_db;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_tmp1_ = ((RygelMediaObject*) self)->id;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_tmp2_ = rygel_media_export_media_cache_get_child_count (_tmp0_, _tmp1_, &_inner_error_);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_tmp3_ = _tmp2_;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		if (_inner_error_ != NULL) {
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 292 "rygel-media-export-db-container.c"
				goto __catch3_rygel_media_export_database_error;
			}
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_clear_error (&_inner_error_);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			return;
#line 301 "rygel-media-export-db-container.c"
		}
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		((RygelMediaContainer*) self)->child_count = _tmp3_;
#line 305 "rygel-media-export-db-container.c"
	}
	goto __finally3;
	__catch3_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_error_ = _inner_error_;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_tmp4_ = _error_;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_tmp5_ = _tmp4_->message;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_debug ("rygel-media-export-db-container.vala:44: Could not get child count fro" \
"m database: %s", _tmp5_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		((RygelMediaContainer*) self)->child_count = 0;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_g_error_free0 (_error_);
#line 327 "rygel-media-export-db-container.c"
	}
	__finally3:
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_inner_error_ != NULL) {
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_clear_error (&_inner_error_);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return;
#line 338 "rygel-media-export-db-container.c"
	}
}


static void rygel_media_export_db_container_real_get_children_data_free (gpointer _data) {
	RygelMediaExportDbContainerGetChildrenData* _data_;
	_data_ = _data;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->result);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_slice_free (RygelMediaExportDbContainerGetChildrenData, _data_);
#line 354 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDBContainer * self;
	RygelMediaExportDbContainerGetChildrenData* _data_;
	RygelMediaExportDBContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self = (RygelMediaExportDBContainer*) base;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportDbContainerGetChildrenData);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_db_container_real_get_children);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_db_container_real_get_children_data_free);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->self = _tmp0_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp1_ = offset;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->offset = _tmp1_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp2_ = max_count;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->max_count = _tmp2_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp3_ = cancellable;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->cancellable = _tmp4_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_real_get_children_co (_data_);
#line 394 "rygel-media-export-db-container.c"
}


static RygelMediaObjects* rygel_media_export_db_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportDbContainerGetChildrenData* _data_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return NULL;
#line 405 "rygel-media-export-db-container.c"
	}
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	result = _data_->result;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->result = NULL;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return result;
#line 415 "rygel-media-export-db-container.c"
}


static gboolean rygel_media_export_db_container_real_get_children_co (RygelMediaExportDbContainerGetChildrenData* _data_) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	switch (_data_->_state_) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		case 0:
#line 424 "rygel-media-export-db-container.c"
		goto _state_0;
		default:
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_assert_not_reached ();
#line 429 "rygel-media-export-db-container.c"
	}
	_state_0:
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp0_ = _data_->self->media_db;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp1_ = _data_->offset;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp2_ = _data_->max_count;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp3_ = NULL;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp3_ = rygel_media_export_media_cache_get_children (_data_->_tmp0_, (RygelMediaContainer*) _data_->self, (glong) _data_->_tmp1_, (glong) _data_->_tmp2_, &_data_->_inner_error_);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_error_free (_data_->_inner_error_);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		if (_data_->_state_ == 0) {
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 454 "rygel-media-export-db-container.c"
		} else {
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 458 "rygel-media-export-db-container.c"
		}
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_object_unref (_data_->_async_result);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return FALSE;
#line 464 "rygel-media-export-db-container.c"
	}
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->result = _data_->_tmp4_;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_state_ == 0) {
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 472 "rygel-media-export-db-container.c"
	} else {
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 476 "rygel-media-export-db-container.c"
	}
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_unref (_data_->_async_result);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return FALSE;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_state_ == 0) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 486 "rygel-media-export-db-container.c"
	} else {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 490 "rygel-media-export-db-container.c"
	}
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_unref (_data_->_async_result);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return FALSE;
#line 496 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_real_search_data_free (gpointer _data) {
	RygelMediaExportDbContainerSearchData* _data_;
	_data_ = _data;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->result);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_slice_free (RygelMediaExportDbContainerSearchData, _data_);
#line 513 "rygel-media-export-db-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 520 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_real_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDbContainerSearchData* _data_;
	RygelMediaExportDBContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportDbContainerSearchData);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_db_container_real_search);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_db_container_real_search_data_free);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->self = _tmp0_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp1_ = expression;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->expression = _tmp2_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp3_ = offset;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->offset = _tmp3_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp4_ = max_count;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->max_count = _tmp4_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp5_ = cancellable;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->cancellable = _tmp6_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_real_search_co (_data_);
#line 565 "rygel-media-export-db-container.c"
}


static RygelMediaObjects* rygel_media_export_db_container_real_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportDbContainerSearchData* _data_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return NULL;
#line 576 "rygel-media-export-db-container.c"
	}
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (total_matches) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		*total_matches = _data_->total_matches;
#line 584 "rygel-media-export-db-container.c"
	}
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	result = _data_->result;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->result = NULL;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return result;
#line 592 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportDbContainerSearchData* _data_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = _user_data_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_source_object_ = source_object;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_res_ = _res_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_real_search_co (_data_);
#line 606 "rygel-media-export-db-container.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return self ? g_error_copy (self) : NULL;
#line 613 "rygel-media-export-db-container.c"
}


static gboolean rygel_media_export_db_container_real_search_co (RygelMediaExportDbContainerSearchData* _data_) {
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	switch (_data_->_state_) {
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		case 0:
#line 622 "rygel-media-export-db-container.c"
		goto _state_0;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		case 1:
#line 626 "rygel-media-export-db-container.c"
		goto _state_1;
		default:
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_assert_not_reached ();
#line 631 "rygel-media-export-db-container.c"
	}
	_state_0:
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->children = NULL;
#line 636 "rygel-media-export-db-container.c"
	{
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp0_ = _data_->self->media_db;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp1_ = _data_->expression;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp2_ = ((RygelMediaObject*) _data_->self)->id;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp3_ = _data_->offset;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp4_ = _data_->max_count;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp5_ = 0U;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp6_ = NULL;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp6_ = rygel_media_export_media_cache_get_objects_by_search_expression (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->total_matches = _data_->_tmp5_;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			if (_data_->_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
#line 662 "rygel-media-export-db-container.c"
				goto __catch4_rygel_media_export_media_cache_error;
			}
			goto __finally4;
		}
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_g_object_unref0 (_data_->children);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->children = _data_->_tmp7_;
#line 671 "rygel-media-export-db-container.c"
	}
	goto __finally4;
	__catch4_rygel_media_export_media_cache_error:
	{
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_inner_error_ = NULL;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_data_->_tmp8_ = _data_->_error_;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		if (g_error_matches (_data_->_tmp8_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH)) {
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp9_ = _data_->expression;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp10_ = _data_->offset;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp11_ = _data_->max_count;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp12_ = _data_->cancellable;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp13_ = 0U;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_state_ = 1;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, rygel_media_export_db_container_search_ready, _data_);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			return FALSE;
#line 700 "rygel-media-export-db-container.c"
			_state_1:
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp14_ = NULL;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp14_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp13_, &_data_->_inner_error_);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->total_matches = _data_->_tmp13_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp15_ = _data_->_tmp14_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
				_g_error_free0 (_data_->_error_);
#line 714 "rygel-media-export-db-container.c"
				goto __finally4;
			}
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_g_object_unref0 (_data_->children);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->children = _data_->_tmp15_;
#line 721 "rygel-media-export-db-container.c"
		} else {
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp16_ = _data_->_error_;
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_data_->_inner_error_ = _data_->_tmp17_;
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			_g_error_free0 (_data_->_error_);
#line 731 "rygel-media-export-db-container.c"
			goto __finally4;
		}
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_g_error_free0 (_data_->_error_);
#line 736 "rygel-media-export-db-container.c"
	}
	__finally4:
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_error_free (_data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		_g_object_unref0 (_data_->children);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		if (_data_->_state_ == 0) {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 751 "rygel-media-export-db-container.c"
		} else {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 755 "rygel-media-export-db-container.c"
		}
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_object_unref (_data_->_async_result);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return FALSE;
#line 761 "rygel-media-export-db-container.c"
	}
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->result = _data_->children;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 769 "rygel-media-export-db-container.c"
	} else {
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 773 "rygel-media-export-db-container.c"
	}
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return FALSE;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->children);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_state_ == 0) {
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 785 "rygel-media-export-db-container.c"
	} else {
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 789 "rygel-media-export-db-container.c"
	}
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_unref (_data_->_async_result);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return FALSE;
#line 795 "rygel-media-export-db-container.c"
}


void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS (self)->search (self, expression, offset, max_count, cancellable, _callback_, _user_data_);
#line 802 "rygel-media-export-db-container.c"
}


RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS (self)->search_finish (self, _res_, total_matches, error);
#line 809 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportDbContainerFindObjectData* _data_;
	_data_ = _data;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_free0 (_data_->id);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->result);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_slice_free (RygelMediaExportDbContainerFindObjectData, _data_);
#line 826 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDBContainer * self;
	RygelMediaExportDbContainerFindObjectData* _data_;
	RygelMediaExportDBContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self = (RygelMediaExportDBContainer*) base;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportDbContainerFindObjectData);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_db_container_real_find_object);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_db_container_real_find_object_data_free);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->self = _tmp0_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp1_ = id;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->id = _tmp2_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp3_ = cancellable;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->cancellable = _tmp4_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_real_find_object_co (_data_);
#line 864 "rygel-media-export-db-container.c"
}


static RygelMediaObject* rygel_media_export_db_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportDbContainerFindObjectData* _data_;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return NULL;
#line 875 "rygel-media-export-db-container.c"
	}
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	result = _data_->result;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->result = NULL;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return result;
#line 885 "rygel-media-export-db-container.c"
}


static gboolean rygel_media_export_db_container_real_find_object_co (RygelMediaExportDbContainerFindObjectData* _data_) {
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	switch (_data_->_state_) {
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		case 0:
#line 894 "rygel-media-export-db-container.c"
		goto _state_0;
		default:
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_assert_not_reached ();
#line 899 "rygel-media-export-db-container.c"
	}
	_state_0:
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp0_ = _data_->self->media_db;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp1_ = _data_->id;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp2_ = rygel_media_export_media_cache_get_object (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_error_free (_data_->_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		if (_data_->_state_ == 0) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 922 "rygel-media-export-db-container.c"
		} else {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 926 "rygel-media-export-db-container.c"
		}
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_object_unref (_data_->_async_result);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		return FALSE;
#line 932 "rygel-media-export-db-container.c"
	}
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_data_->result = _data_->_tmp3_;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_state_ == 0) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 940 "rygel-media-export-db-container.c"
	} else {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 944 "rygel-media-export-db-container.c"
	}
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_unref (_data_->_async_result);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return FALSE;
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	if (_data_->_state_ == 0) {
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 954 "rygel-media-export-db-container.c"
	} else {
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 958 "rygel-media-export-db-container.c"
	}
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_unref (_data_->_async_result);
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return FALSE;
#line 964 "rygel-media-export-db-container.c"
}


static GeeArrayList* rygel_media_export_db_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelMediaExportDBContainer* self;
	GeeArrayList* _tmp0_;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self = (RygelMediaExportDBContainer*) base;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp0_ = self->priv->_search_classes;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	return result;
#line 980 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelMediaExportDBContainer* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self = (RygelMediaExportDBContainer*) base;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp0_ = value;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self->priv->_search_classes = _tmp1_;
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 1000 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_class_init (RygelMediaExportDBContainerClass * klass) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportDBContainerPrivate));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_export_db_container_real_get_children;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_export_db_container_real_get_children_finish;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_db_container_real_search;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_db_container_real_search_finish;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_export_db_container_real_find_object;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_export_db_container_real_find_object_finish;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_db_container_get_property;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_db_container_set_property;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_db_container_finalize;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_DB_CONTAINER_SEARCH_CLASSES, "search-classes");
#line 1029 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	rygel_media_export_db_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, GCancellable*, GError**)) rygel_media_export_db_container_search;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	iface->search_finish = rygel_media_export_db_container_search_finish;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	iface->get_search_classes = rygel_media_export_db_container_real_get_search_classes;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	iface->set_search_classes = rygel_media_export_db_container_real_set_search_classes;
#line 1044 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_instance_init (RygelMediaExportDBContainer * self) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self->priv = RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_PRIVATE (self);
#line 1051 "rygel-media-export-db-container.c"
}


static void rygel_media_export_db_container_finalize (GObject* obj) {
	RygelMediaExportDBContainer * self;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	self = RYGEL_MEDIA_EXPORT_DB_CONTAINER (obj);
#line 27 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (self->media_db);
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	G_OBJECT_CLASS (rygel_media_export_db_container_parent_class)->finalize (obj);
#line 1065 "rygel-media-export-db-container.c"
}


GType rygel_media_export_db_container_get_type (void) {
	static volatile gsize rygel_media_export_db_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_db_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDBContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_db_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDBContainer), 0, (GInstanceInitFunc) rygel_media_export_db_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_media_export_db_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_db_container_type_id;
		rygel_media_export_db_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelMediaExportDBContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_db_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_media_export_db_container_type_id__volatile, rygel_media_export_db_container_type_id);
	}
	return rygel_media_export_db_container_type_id__volatile;
}


static void _vala_rygel_media_export_db_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportDBContainer * self;
	self = RYGEL_MEDIA_EXPORT_DB_CONTAINER (object);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		case RYGEL_MEDIA_EXPORT_DB_CONTAINER_SEARCH_CLASSES:
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		break;
#line 1094 "rygel-media-export-db-container.c"
		default:
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		break;
#line 1100 "rygel-media-export-db-container.c"
	}
}


static void _vala_rygel_media_export_db_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportDBContainer * self;
	self = RYGEL_MEDIA_EXPORT_DB_CONTAINER (object);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		case RYGEL_MEDIA_EXPORT_DB_CONTAINER_SEARCH_CLASSES:
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		break;
#line 1116 "rygel-media-export-db-container.c"
		default:
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-db-container.vala"
		break;
#line 1122 "rygel-media-export-db-container.c"
	}
}



