/* rygel-http-request.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-request.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpRequestRunData RygelHttpRequestRunData;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;
typedef struct _RygelHttpRequestFindItemData RygelHttpRequestFindItemData;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPRequestPrivate {
	RygelMediaContainer* root_container;
	GCancellable* _cancellable;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelHttpRequestRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	SoupServer* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupURI* _tmp3_;
	SoupURI* _tmp4_;
	const gchar* _tmp5_;
	RygelHTTPServer* _tmp6_;
	RygelHTTPItemURI* _tmp7_;
	RygelHTTPItemURI* _tmp8_;
	GError* _error_;
	GError* _tmp9_;
	GError * _inner_error_;
};

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHttpRequestFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelMediaContainer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* media_object;
	gboolean _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	RygelHTTPItemURI* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaItem* _tmp13_;
	GError * _inner_error_;
};


static gpointer rygel_http_request_parent_class = NULL;
static RygelStateMachineIface* rygel_http_request_rygel_state_machine_parent_iface = NULL;

GQuark rygel_http_request_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestPrivate))
enum  {
	RYGEL_HTTP_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_REQUEST_CANCELLABLE
};
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_request_real_run_data_free (gpointer _data);
static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_request_real_find_item_data_free (gpointer _data);
static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_request_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	return self ? g_object_ref (self) : NULL;
#line 298 "rygel-http-request.c"
}


RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPRequest * self = NULL;
	RygelHTTPServer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	RygelHTTPServer* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	SoupServer* _tmp6_;
	SoupMessage* _tmp7_;
	SoupMessage* _tmp8_;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self = (RygelHTTPRequest*) g_object_new (object_type, NULL);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = http_server;
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self->http_server = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp1_ = g_cancellable_new ();
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp2_ = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp2_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (_tmp2_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp3_ = http_server;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp4_ = _tmp3_->root_container;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->priv->root_container);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self->priv->root_container = _tmp5_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp6_ = server;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self->server = _tmp6_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp7_ = msg;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->msg);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self->msg = _tmp8_;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	return self;
#line 357 "rygel-http-request.c"
}


static void rygel_http_request_real_run_data_free (gpointer _data) {
	RygelHttpRequestRunData* _data_;
	_data_ = _data;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_slice_free (RygelHttpRequestRunData, _data_);
#line 368 "rygel-http-request.c"
}


static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPRequest * self;
	RygelHttpRequestRunData* _data_;
	RygelHTTPRequest* _tmp0_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self = (RygelHTTPRequest*) base;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_ = g_slice_new0 (RygelHttpRequestRunData);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_run);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_run_data_free);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->self = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_real_run_co (_data_);
#line 390 "rygel-http-request.c"
}


static void rygel_http_request_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpRequestRunData* _data_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 398 "rygel-http-request.c"
}


static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestRunData* _data_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_ = _user_data_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_source_object_ = source_object;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_res_ = _res_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_real_run_co (_data_);
#line 412 "rygel-http-request.c"
}


static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	switch (_data_->_state_) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case 0:
#line 421 "rygel-http-request.c"
		goto _state_0;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case 1:
#line 425 "rygel-http-request.c"
		goto _state_1;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case 2:
#line 429 "rygel-http-request.c"
		goto _state_2;
		default:
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_assert_not_reached ();
#line 434 "rygel-http-request.c"
	}
	_state_0:
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp0_ = _data_->self->server;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp1_ = _data_->self->msg;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	soup_server_pause_message (_data_->_tmp0_, _data_->_tmp1_);
#line 443 "rygel-http-request.c"
	{
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp2_ = _data_->self->msg;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp3_ = soup_message_get_uri (_data_->_tmp2_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp5_ = _data_->_tmp4_->path;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp6_ = _data_->self->http_server;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp7_ = rygel_http_item_uri_new_from_string (_data_->_tmp5_, _data_->_tmp6_, &_data_->_inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		if (_data_->_inner_error_ != NULL) {
#line 461 "rygel-http-request.c"
			goto __catch33_g_error;
		}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_g_object_unref0 (_data_->self->uri);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->self->uri = _data_->_tmp8_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_state_ = 1;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		rygel_http_request_find_item (_data_->self, rygel_http_request_run_ready, _data_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return FALSE;
#line 474 "rygel-http-request.c"
		_state_1:
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		rygel_http_request_find_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		if (_data_->_inner_error_ != NULL) {
#line 480 "rygel-http-request.c"
			goto __catch33_g_error;
		}
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_state_ = 2;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		rygel_http_request_handle (_data_->self, rygel_http_request_run_ready, _data_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return FALSE;
#line 489 "rygel-http-request.c"
		_state_2:
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		rygel_http_request_handle_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		if (_data_->_inner_error_ != NULL) {
#line 495 "rygel-http-request.c"
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_inner_error_ = NULL;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp9_ = _data_->_error_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		rygel_http_request_handle_error (_data_->self, _data_->_tmp9_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_g_error_free0 (_data_->_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		if (_data_->_state_ == 0) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 516 "rygel-http-request.c"
		} else {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 520 "rygel-http-request.c"
		}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_object_unref (_data_->_async_result);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return FALSE;
#line 526 "rygel-http-request.c"
	}
	__finally33:
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_data_->_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_clear_error (&_data_->_inner_error_);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return FALSE;
#line 537 "rygel-http-request.c"
	}
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_data_->_state_ == 0) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 543 "rygel-http-request.c"
	} else {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 547 "rygel-http-request.c"
	}
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_object_unref (_data_->_async_result);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	return FALSE;
#line 553 "rygel-http-request.c"
}


void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle (self, _callback_, _user_data_);
#line 560 "rygel-http-request.c"
}


void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle_finish (self, _res_, error);
#line 567 "rygel-http-request.c"
}


static void rygel_http_request_real_find_item_data_free (gpointer _data) {
	RygelHttpRequestFindItemData* _data_;
	_data_ = _data;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_slice_free (RygelHttpRequestFindItemData, _data_);
#line 578 "rygel-http-request.c"
}


static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
	RygelHTTPRequest* _tmp0_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_ = g_slice_new0 (RygelHttpRequestFindItemData);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_find_item);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_find_item_data_free);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->self = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_real_find_item_co (_data_);
#line 597 "rygel-http-request.c"
}


static void rygel_http_request_real_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
	RygelHttpRequestFindItemData* _data_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return;
#line 607 "rygel-http-request.c"
	}
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 611 "rygel-http-request.c"
}


static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_ = _user_data_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_source_object_ = source_object;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_res_ = _res_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_real_find_item_co (_data_);
#line 625 "rygel-http-request.c"
}


static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_) {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	switch (_data_->_state_) {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case 0:
#line 634 "rygel-http-request.c"
		goto _state_0;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case 1:
#line 638 "rygel-http-request.c"
		goto _state_1;
		default:
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_assert_not_reached ();
#line 643 "rygel-http-request.c"
	}
	_state_0:
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp0_ = _data_->self->priv->root_container;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp1_ = _data_->self->uri;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp2_ = _data_->_tmp1_->item_id;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_state_ = 1;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_media_container_find_object (_data_->_tmp0_, _data_->_tmp2_, NULL, rygel_http_request_find_item_ready, _data_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	return FALSE;
#line 658 "rygel-http-request.c"
	_state_1:
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp3_ = NULL;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp3_ = rygel_media_container_find_object_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->media_object = _data_->_tmp3_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_data_->_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_error_free (_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 676 "rygel-http-request.c"
		} else {
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 680 "rygel-http-request.c"
		}
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return FALSE;
#line 686 "rygel-http-request.c"
	}
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp5_ = _data_->media_object;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_data_->_tmp5_ == NULL) {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp4_ = TRUE;
#line 694 "rygel-http-request.c"
	} else {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp6_ = _data_->media_object;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp4_ = !RYGEL_IS_MEDIA_ITEM (_data_->_tmp6_);
#line 700 "rygel-http-request.c"
	}
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp7_ = _data_->_tmp4_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_data_->_tmp7_) {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp8_ = NULL;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp8_ = _ ("Requested item '%s' not found");
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp9_ = _data_->self->uri;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp10_ = _data_->_tmp9_->item_id;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_tmp11_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _data_->_tmp8_, _data_->_tmp10_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_data_->_inner_error_ = _data_->_tmp11_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_error_free (_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_g_object_unref0 (_data_->media_object);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		if (_data_->_state_ == 0) {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 728 "rygel-http-request.c"
		} else {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 732 "rygel-http-request.c"
		}
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_object_unref (_data_->_async_result);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		return FALSE;
#line 738 "rygel-http-request.c"
	}
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp12_ = _data_->media_object;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->_tmp13_ = _g_object_ref0 (RYGEL_MEDIA_ITEM (_data_->_tmp12_));
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (_data_->self->item);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_data_->self->item = _data_->_tmp13_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (_data_->media_object);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_data_->_state_ == 0) {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 754 "rygel-http-request.c"
	} else {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 758 "rygel-http-request.c"
	}
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_object_unref (_data_->_async_result);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	return FALSE;
#line 764 "rygel-http-request.c"
}


void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item (self, _callback_, _user_data_);
#line 771 "rygel-http-request.c"
}


void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item_finish (self, _res_, error);
#line 778 "rygel-http-request.c"
}


void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	guint status = 0U;
	GError* _tmp4_;
	guint _tmp7_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = _error_;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp1_ = _tmp0_->message;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_warning ("rygel-http-request.vala:90: %s", _tmp1_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp2_ = self->server;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp3_ = self->msg;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	soup_server_unpause_message (_tmp2_, _tmp3_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp4_ = _error_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_tmp4_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 808 "rygel-http-request.c"
		GError* _tmp5_;
		gint _tmp6_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_tmp5_ = _error_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_tmp6_ = _tmp5_->code;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		status = (guint) _tmp6_;
#line 817 "rygel-http-request.c"
	} else {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		status = (guint) SOUP_STATUS_NOT_FOUND;
#line 821 "rygel-http-request.c"
	}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp7_ = status;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_end (self, _tmp7_);
#line 827 "rygel-http-request.c"
}


void rygel_http_request_end (RygelHTTPRequest* self, guint status) {
	guint _tmp0_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = status;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	if (_tmp0_ != ((guint) SOUP_STATUS_NONE)) {
#line 839 "rygel-http-request.c"
		SoupMessage* _tmp1_;
		guint _tmp2_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_tmp1_ = self->msg;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		_tmp2_ = status;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		soup_message_set_status (_tmp1_, _tmp2_);
#line 848 "rygel-http-request.c"
	}
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 852 "rygel-http-request.c"
}


static GCancellable* rygel_http_request_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self = (RygelHTTPRequest*) base;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = self->priv->_cancellable;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	return result;
#line 868 "rygel-http-request.c"
}


static void rygel_http_request_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self = (RygelHTTPRequest*) base;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp0_ = value;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self->priv->_cancellable = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 888 "rygel-http-request.c"
}


static void rygel_http_request_class_init (RygelHTTPRequestClass * klass) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPRequestPrivate));
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_request_real_find_item;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_request_real_find_item_finish;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_request_get_property;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_request_set_property;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_request_finalize;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_REQUEST_CANCELLABLE, "cancellable");
#line 909 "rygel-http-request.c"
}


static void rygel_http_request_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	rygel_http_request_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_request_real_run;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	iface->run_finish = rygel_http_request_real_run_finish;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	iface->get_cancellable = rygel_http_request_real_get_cancellable;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	iface->set_cancellable = rygel_http_request_real_set_cancellable;
#line 924 "rygel-http-request.c"
}


static void rygel_http_request_instance_init (RygelHTTPRequest * self) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self->priv = RYGEL_HTTP_REQUEST_GET_PRIVATE (self);
#line 931 "rygel-http-request.c"
}


static void rygel_http_request_finalize (GObject* obj) {
	RygelHTTPRequest * self;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	self = RYGEL_HTTP_REQUEST (obj);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->priv->root_container);
#line 39 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->msg);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->uri);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	_g_object_unref0 (self->item);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	G_OBJECT_CLASS (rygel_http_request_parent_class)->finalize (obj);
#line 951 "rygel-http-request.c"
}


/**
 * Base class for HTTP client requests.
 */
GType rygel_http_request_get_type (void) {
	static volatile gsize rygel_http_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPRequest), 0, (GInstanceInitFunc) rygel_http_request_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_request_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_request_type_id;
		rygel_http_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPRequest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_http_request_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_request_type_id__volatile, rygel_http_request_type_id);
	}
	return rygel_http_request_type_id__volatile;
}


static void _vala_rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		break;
#line 983 "rygel-http-request.c"
		default:
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		break;
#line 989 "rygel-http-request.c"
	}
}


static void _vala_rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		break;
#line 1005 "rygel-http-request.c"
		default:
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-request.vala"
		break;
#line 1011 "rygel-http-request.c"
	}
}



