/* computer-player.c generated by valac 0.31.1.17-440e, the Vala compiler
 * generated from computer-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ComputerPlayerMoveAsyncData ComputerPlayerMoveAsyncData;

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))

#define TYPE_PLAYER (player_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint difficulty_level;
	guint pending_move_id;
	gboolean _move_pending;
	GRecMutex _move_pending_mutex;
};

struct _Block1Data {
	int _ref_count_;
	ComputerPlayer* self;
	gint x;
	gint y;
	gpointer _async_data_;
};

struct _ComputerPlayerMoveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComputerPlayer* self;
	gdouble delay_seconds;
	Block1Data* _data1_;
	GTimer* timer;
	GTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GTimer* _tmp3_;
	GThread* _tmp4_;
	GThread* _tmp5_;
	GTimer* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GTimer* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GTimer* _tmp13_;
	gdouble _tmp14_;
	guint _tmp15_;
};

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY
};
#define COMPUTER_PLAYER_POSITIVE_INFINITY 10000
#define COMPUTER_PLAYER_NEGATIVE_INFINITY -10000
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void computer_player_complete_move (ComputerPlayer* self, gint x, gint y);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
gchar* game_to_string (Game* self);
void computer_player_move (ComputerPlayer* self);
static void computer_player_run_search (ComputerPlayer* self, gint* x, gint* y);
static void computer_player_move_async_data_free (gpointer _data);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static gboolean computer_player_move_async_co (ComputerPlayerMoveAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean computer_player_get_move_pending (ComputerPlayer* self);
static gboolean _computer_player_move_async_co_gsource_func (gpointer self);
static void* __lambda4_ (Block1Data* _data1_);
static void computer_player_set_move_pending (ComputerPlayer* self, gboolean value);
static gpointer ___lambda4__gthread_func (gpointer self);
static gboolean __lambda5_ (Block1Data* _data1_);
static gboolean ___lambda5__gsource_func (gpointer self);
void computer_player_cancel_move (ComputerPlayer* self);
gboolean game_get_current_player_can_move (Game* self);
gint game_get_size (Game* self);
gint game_get_n_tiles (Game* self);
gint game_get_initial_number_of_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
static void computer_player_get_possible_moves_sorted (ComputerPlayer* self, Game* g, GList** moves);
static gint computer_player_search (ComputerPlayer* self, Game* g, gint depth, gint a, gint b);
void game_undo (Game* self, gint count);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
gboolean game_get_is_complete (Game* self);
gint game_get_n_current_tiles (Game* self);
gint game_get_n_opponent_tiles (Game* self);
static gint computer_player_calculate_heuristic (ComputerPlayer* self, Game* g);
void game_pass (Game* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
static gint computer_player_eval_heuristic (Game* g);
static gint computer_player_around (Game* g);
GType player_get_type (void) G_GNUC_CONST;
Player game_get_owner (Game* self, gint x, gint y);
Player game_get_current_color (Game* self);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_is_valid_location (Game* self, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static gpointer _g_object_ref0 (gpointer self) {
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 213 "computer-player.c"
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = game;
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self->priv->game = _tmp1_;
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = difficulty_level;
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self->priv->difficulty_level = _tmp2_;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return self;
#line 240 "computer-player.c"
}


ComputerPlayer* computer_player_new (Game* game, gint difficulty_level) {
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, difficulty_level);
#line 247 "computer-player.c"
}


static void computer_player_complete_move (ComputerPlayer* self, gint x, gint y) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = x;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = y;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp3_ = game_place_tile (_tmp0_, _tmp1_, _tmp2_, TRUE);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp3_ == 0) {
#line 268 "computer-player.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		Game* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp4_ = x;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp5_ = y;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp6_ = self->priv->game;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp7_ = game_to_string (_tmp6_);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp8_ = _tmp7_;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_critical ("computer-player.vala:95: Computer chose an invalid move: %d,%d\n%s", _tmp4_, _tmp5_, _tmp8_);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_g_free0 (_tmp8_);
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_assert_not_reached ();
#line 290 "computer-player.c"
	}
}


void computer_player_move (ComputerPlayer* self) {
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	x = 0;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	y = 0;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_run_search (self, &x, &y);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_complete_move (self, _tmp0_, _tmp1_);
#line 314 "computer-player.c"
}


static void computer_player_move_async_data_free (gpointer _data) {
	ComputerPlayerMoveAsyncData* _data_;
	_data_ = _data;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_object_unref0 (_data_->self);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_slice_free (ComputerPlayerMoveAsyncData, _data_);
#line 325 "computer-player.c"
}


void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComputerPlayerMoveAsyncData* _data_;
	ComputerPlayer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_ = g_slice_new0 (ComputerPlayerMoveAsyncData);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, computer_player_move_async);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, computer_player_move_async_data_free);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->self = _tmp0_;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = delay_seconds;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->delay_seconds = _tmp1_;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_move_async_co (_data_);
#line 349 "computer-player.c"
}


void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_) {
	ComputerPlayerMoveAsyncData* _data_;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 357 "computer-player.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return _data1_;
#line 366 "computer-player.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 375 "computer-player.c"
		ComputerPlayer* self;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		self = _data1_->self;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_g_object_unref0 (self);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_slice_free (Block1Data, _data1_);
#line 383 "computer-player.c"
	}
}


static gboolean _computer_player_move_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = computer_player_move_async_co (self);
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 393 "computer-player.c"
}


static void* __lambda4_ (Block1Data* _data1_) {
	ComputerPlayer* self;
	void* result = NULL;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self = _data1_->self;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_set_move_pending (self, TRUE);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_run_search (self, &_data1_->x, &_data1_->y);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_move_async_co (_data1_->_async_data_);
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = NULL;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 412 "computer-player.c"
}


static gpointer ___lambda4__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda4_ (self);
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	block1_data_unref (self);
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 423 "computer-player.c"
}


static gboolean __lambda5_ (Block1Data* _data1_) {
	ComputerPlayer* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self = _data1_->self;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = _data1_->x;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = _data1_->y;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_complete_move (self, _tmp0_, _tmp1_);
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = G_SOURCE_REMOVE;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 444 "computer-player.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 453 "computer-player.c"
}


static gboolean computer_player_move_async_co (ComputerPlayerMoveAsyncData* _data_) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	switch (_data_->_state_) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		case 0:
#line 462 "computer-player.c"
		goto _state_0;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		case 1:
#line 466 "computer-player.c"
		goto _state_1;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		case 2:
#line 470 "computer-player.c"
		goto _state_2;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		case 3:
#line 474 "computer-player.c"
		goto _state_3;
		default:
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_assert_not_reached ();
#line 479 "computer-player.c"
	}
	_state_0:
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp0_ = NULL;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp0_ = g_timer_new ();
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->timer = _data_->_tmp0_;
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_->x = 0;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_->y = 0;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	while (TRUE) {
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp1_ = FALSE;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp1_ = computer_player_get_move_pending (_data_->self);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp2_ = FALSE;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		if (!_data_->_tmp2_) {
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			break;
#line 514 "computer-player.c"
		}
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _computer_player_move_async_co_gsource_func, _data_, NULL);
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_state_ = 1;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return FALSE;
#line 522 "computer-player.c"
		_state_1:
		;
	}
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp3_ = NULL;
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp3_ = _data_->timer;
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_timer_start (_data_->_tmp3_);
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp4_ = NULL;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp4_ = g_thread_new ("AI thread", ___lambda4__gthread_func, block1_data_ref (_data_->_data1_));
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp5_ = NULL;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_thread_unref0 (_data_->_tmp5_);
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_state_ = 2;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return FALSE;
#line 546 "computer-player.c"
	_state_2:
	;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp6_ = NULL;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp6_ = _data_->timer;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_timer_stop (_data_->_tmp6_);
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp7_ = FALSE;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp7_ = computer_player_get_move_pending (_data_->self);
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp8_ = FALSE;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (!_data_->_tmp8_) {
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_g_timer_destroy0 (_data_->timer);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		block1_data_unref (_data_->_data1_);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_data1_ = NULL;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		if (_data_->_state_ == 0) {
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 575 "computer-player.c"
		} else {
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 579 "computer-player.c"
		}
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_object_unref (_data_->_async_result);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return FALSE;
#line 585 "computer-player.c"
	}
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp9_ = NULL;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp9_ = _data_->timer;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp10_ = 0.0;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp10_ = g_timer_elapsed (_data_->_tmp9_, NULL);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp11_ = 0.0;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_tmp11_ = _data_->delay_seconds;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_data_->_tmp10_ < _data_->_tmp11_) {
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp12_ = 0.0;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp12_ = _data_->delay_seconds;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp13_ = NULL;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp13_ = _data_->timer;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp14_ = 0.0;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp14_ = g_timer_elapsed (_data_->_tmp13_, NULL);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp15_ = 0U;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((_data_->_tmp12_ - _data_->_tmp14_) * 1000), _computer_player_move_async_co_gsource_func, _data_, NULL);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->self->priv->pending_move_id = _data_->_tmp15_;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_data_->_state_ = 3;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return FALSE;
#line 623 "computer-player.c"
		_state_3:
		;
	}
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->self->priv->pending_move_id = (guint) 0;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_set_move_pending (_data_->self, FALSE);
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_timer_destroy0 (_data_->timer);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	block1_data_unref (_data_->_data1_);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_data_->_data1_ = NULL;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_data_->_state_ == 0) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 643 "computer-player.c"
	} else {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 647 "computer-player.c"
	}
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_object_unref (_data_->_async_result);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return FALSE;
#line 653 "computer-player.c"
}


void computer_player_cancel_move (ComputerPlayer* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_ = 0U;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = computer_player_get_move_pending (self);
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = _tmp0_;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (!_tmp1_) {
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return;
#line 671 "computer-player.c"
	}
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = self->priv->pending_move_id;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 677 "computer-player.c"
		guint _tmp3_ = 0U;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp3_ = self->priv->pending_move_id;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_source_remove (_tmp3_);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		self->priv->pending_move_id = (guint) 0;
#line 685 "computer-player.c"
	}
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_set_move_pending (self, FALSE);
#line 689 "computer-player.c"
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return self ? computer_player_possible_move_dup (self) : NULL;
#line 696 "computer-player.c"
}


static void _computer_player_possible_move_free0_ (gpointer var) {
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
#line 703 "computer-player.c"
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_list_free (self);
#line 712 "computer-player.c"
}


static void computer_player_run_search (ComputerPlayer* self, gint* x, gint* y) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Game* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	Game* g = NULL;
	Game* _tmp16_ = NULL;
	Game* _tmp17_ = NULL;
	gint depth = 0;
	gint _tmp18_ = 0;
	gint a = 0;
	GList* moves = NULL;
	Game* _tmp19_ = NULL;
	GList* _tmp20_ = NULL;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_vala_return_if_fail (_tmp2_, "game.current_player_can_move");
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp4_ = self->priv->game;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp5_ = game_get_size (_tmp4_);
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp6_ = _tmp5_;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp6_ < 6) {
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp3_ = 2;
#line 759 "computer-player.c"
	} else {
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp3_ = 4;
#line 763 "computer-player.c"
	}
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp7_ = self->priv->game;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp8_ = game_get_n_tiles (_tmp7_);
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp9_ = _tmp8_;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp10_ = self->priv->game;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp11_ = game_get_initial_number_of_tiles (_tmp10_);
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp12_ = _tmp11_;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp9_ < (_tmp12_ + _tmp3_)) {
#line 779 "computer-player.c"
		Game* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp13_ = self->priv->game;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		computer_player_random_select (_tmp13_, &_tmp14_, &_tmp15_);
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		*x = _tmp14_;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		*y = _tmp15_;
#line 182 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return;
#line 793 "computer-player.c"
	}
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp16_ = self->priv->game;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp17_ = game_new_copy (_tmp16_);
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g = _tmp17_;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp18_ = self->priv->difficulty_level;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	depth = _tmp18_ * 2;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	a = COMPUTER_PLAYER_NEGATIVE_INFINITY - 1;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	moves = NULL;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp19_ = g;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_get_possible_moves_sorted (self, _tmp19_, &moves);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp20_ = moves;
#line 815 "computer-player.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		move_collection = _tmp20_;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 823 "computer-player.c"
			ComputerPlayerPossibleMove* _tmp21_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp21_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			move = _tmp21_;
#line 830 "computer-player.c"
			{
				Game* _tmp22_ = NULL;
				ComputerPlayerPossibleMove* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				ComputerPlayerPossibleMove* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint a_new = 0;
				Game* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				Game* _tmp49_ = NULL;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp22_ = g;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp23_ = move;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp24_ = (*_tmp23_).x;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp25_ = move;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp26_ = (*_tmp25_).y;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp27_ = game_place_tile (_tmp22_, _tmp24_, _tmp26_, TRUE);
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (_tmp27_ == 0) {
#line 860 "computer-player.c"
					gint _tmp28_ = 0;
					ComputerPlayerPossibleMove* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					ComputerPlayerPossibleMove* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					ComputerPlayerPossibleMove* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					Game* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp28_ = depth;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp29_ = move;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp30_ = (*_tmp29_).x;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp31_ = move;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp32_ = (*_tmp31_).y;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp33_ = move;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp34_ = (*_tmp33_).n_tiles;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp35_ = g;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp36_ = game_to_string (_tmp35_);
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp37_ = _tmp36_;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					g_critical ("computer-player.vala:201: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking.\n" \
"%s", _tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp37_);
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_g_free0 (_tmp37_);
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					g_assert_not_reached ();
#line 897 "computer-player.c"
				}
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp38_ = g;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp39_ = depth;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp40_ = a;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp41_ = computer_player_search (self, _tmp38_, _tmp39_, COMPUTER_PLAYER_NEGATIVE_INFINITY, -_tmp40_);
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				a_new = -1 * _tmp41_;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp42_ = a_new;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp43_ = a;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (_tmp42_ > _tmp43_) {
#line 915 "computer-player.c"
					gint _tmp44_ = 0;
					ComputerPlayerPossibleMove* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					ComputerPlayerPossibleMove* _tmp47_ = NULL;
					gint _tmp48_ = 0;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp44_ = a_new;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					a = _tmp44_;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp45_ = move;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp46_ = (*_tmp45_).x;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					*x = _tmp46_;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp47_ = move;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp48_ = (*_tmp47_).y;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					*y = _tmp48_;
#line 937 "computer-player.c"
				}
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp49_ = g;
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				game_undo (_tmp49_, 1);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_computer_player_possible_move_free0 (move);
#line 945 "computer-player.c"
			}
		}
	}
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_object_unref0 (g);
#line 953 "computer-player.c"
}


static gint computer_player_search (ComputerPlayer* self, Game* g, gint depth, gint a, gint b) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	Game* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp66_ = 0;
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = a;
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = b;
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_vala_return_val_if_fail (_tmp0_ <= _tmp1_, "a <= b", 0);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = g;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp3_ = game_get_is_complete (_tmp2_);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp4_ = _tmp3_;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp4_) {
#line 989 "computer-player.c"
		gint _tmp5_ = 0;
		Game* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp6_ = g;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp7_ = game_get_n_current_tiles (_tmp6_);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp8_ = _tmp7_;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp9_ = g;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp10_ = game_get_n_opponent_tiles (_tmp9_);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp11_ = _tmp10_;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		if (_tmp8_ > _tmp11_) {
#line 1011 "computer-player.c"
			Game* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp12_ = g;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp13_ = game_get_n_opponent_tiles (_tmp12_);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp14_ = _tmp13_;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp5_ = COMPUTER_PLAYER_POSITIVE_INFINITY - _tmp14_;
#line 1023 "computer-player.c"
		} else {
			Game* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp15_ = g;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp16_ = game_get_n_current_tiles (_tmp15_);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp17_ = _tmp16_;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp5_ = COMPUTER_PLAYER_NEGATIVE_INFINITY + _tmp17_;
#line 1036 "computer-player.c"
		}
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = _tmp5_;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 1042 "computer-player.c"
	}
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp18_ = computer_player_get_move_pending (self);
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp19_ = _tmp18_;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (!_tmp19_) {
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = 0;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 1054 "computer-player.c"
	}
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp20_ = depth;
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp20_ == 0) {
#line 1060 "computer-player.c"
		Game* _tmp21_ = NULL;
		gint _tmp22_ = 0;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp21_ = g;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp22_ = computer_player_calculate_heuristic (self, _tmp21_);
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = _tmp22_;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 1071 "computer-player.c"
	}
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp23_ = g;
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp24_ = game_get_current_player_can_move (_tmp23_);
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp25_ = _tmp24_;
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp25_) {
#line 1081 "computer-player.c"
		GList* moves = NULL;
		Game* _tmp26_ = NULL;
		GList* _tmp27_ = NULL;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		moves = NULL;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp26_ = g;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		computer_player_get_possible_moves_sorted (self, _tmp26_, &moves);
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp27_ = moves;
#line 1093 "computer-player.c"
		{
			GList* move_collection = NULL;
			GList* move_it = NULL;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			move_collection = _tmp27_;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 1101 "computer-player.c"
				ComputerPlayerPossibleMove* _tmp28_ = NULL;
				ComputerPlayerPossibleMove* move = NULL;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp28_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				move = _tmp28_;
#line 1108 "computer-player.c"
				{
					Game* _tmp29_ = NULL;
					ComputerPlayerPossibleMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					ComputerPlayerPossibleMove* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					gint a_new = 0;
					Game* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					Game* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp29_ = g;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp30_ = move;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp31_ = (*_tmp30_).x;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp32_ = move;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp33_ = (*_tmp32_).y;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp34_ = game_place_tile (_tmp29_, _tmp31_, _tmp33_, TRUE);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					if (_tmp34_ == 0) {
#line 1141 "computer-player.c"
						gint _tmp35_ = 0;
						ComputerPlayerPossibleMove* _tmp36_ = NULL;
						gint _tmp37_ = 0;
						ComputerPlayerPossibleMove* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						ComputerPlayerPossibleMove* _tmp40_ = NULL;
						gint _tmp41_ = 0;
						Game* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp35_ = depth;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp36_ = move;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp37_ = (*_tmp36_).x;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp38_ = move;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp39_ = (*_tmp38_).y;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp40_ = move;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp41_ = (*_tmp40_).n_tiles;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp42_ = g;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp43_ = game_to_string (_tmp42_);
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp44_ = _tmp43_;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						g_critical ("computer-player.vala:243: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking.\n" \
"%s", _tmp35_, _tmp37_, _tmp39_, _tmp41_, _tmp44_);
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_g_free0 (_tmp44_);
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						g_assert_not_reached ();
#line 1178 "computer-player.c"
					}
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp45_ = g;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp46_ = depth;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp47_ = b;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp48_ = a;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp49_ = computer_player_search (self, _tmp45_, _tmp46_ - 1, -_tmp47_, -_tmp48_);
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					a_new = -1 * _tmp49_;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp50_ = a_new;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp51_ = a;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					if (_tmp50_ > _tmp51_) {
#line 1198 "computer-player.c"
						gint _tmp52_ = 0;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp52_ = a_new;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						a = _tmp52_;
#line 1204 "computer-player.c"
					}
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp53_ = g;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					game_undo (_tmp53_, 1);
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp54_ = b;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp55_ = a;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					if (_tmp54_ <= _tmp55_) {
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_computer_player_possible_move_free0 (move);
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						break;
#line 1220 "computer-player.c"
					}
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_computer_player_possible_move_free0 (move);
#line 1224 "computer-player.c"
				}
			}
		}
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 1230 "computer-player.c"
	} else {
		Game* _tmp56_ = NULL;
		gint a_new = 0;
		Game* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		Game* _tmp65_ = NULL;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp56_ = g;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		game_pass (_tmp56_);
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp57_ = g;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp58_ = depth;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp59_ = b;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp60_ = a;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp61_ = computer_player_search (self, _tmp57_, _tmp58_ - 1, -_tmp59_, -_tmp60_);
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		a_new = -1 * _tmp61_;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp62_ = a_new;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp63_ = a;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		if (_tmp62_ > _tmp63_) {
#line 1264 "computer-player.c"
			gint _tmp64_ = 0;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp64_ = a_new;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			a = _tmp64_;
#line 1270 "computer-player.c"
		}
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp65_ = g;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		game_undo (_tmp65_, 1);
#line 1276 "computer-player.c"
	}
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp66_ = a;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = _tmp66_;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 1284 "computer-player.c"
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move ((ComputerPlayerPossibleMove*) a, (ComputerPlayerPossibleMove*) b);
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 1293 "computer-player.c"
}


static void computer_player_get_possible_moves_sorted (ComputerPlayer* self, Game* g, GList** moves) {
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 1302 "computer-player.c"
	{
		gint x = 0;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		x = 0;
#line 1307 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1314 "computer-player.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1321 "computer-player.c"
					gint _tmp1_ = 0;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1327 "computer-player.c"
				}
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp3_ = g;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp4_ = game_get_size (_tmp3_);
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp5_ = _tmp4_;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					break;
#line 1343 "computer-player.c"
				}
				{
					gint y = 0;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					y = 0;
#line 1349 "computer-player.c"
					{
						gboolean _tmp6_ = FALSE;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp6_ = TRUE;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1356 "computer-player.c"
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint n_tiles = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							ComputerPlayerPossibleMove move = {0};
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							ComputerPlayerPossibleMove _tmp20_ = {0};
							ComputerPlayerPossibleMove* _tmp21_ = NULL;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!_tmp6_) {
#line 1375 "computer-player.c"
								gint _tmp7_ = 0;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp7_ = y;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								y = _tmp7_ + 1;
#line 1381 "computer-player.c"
							}
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp6_ = FALSE;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp10_ = game_get_size (_tmp9_);
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!(_tmp8_ < _tmp11_)) {
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								break;
#line 1397 "computer-player.c"
							}
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp13_ = x;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp14_ = y;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp15_ = game_place_tile (_tmp12_, _tmp13_, _tmp14_, FALSE);
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							n_tiles = _tmp15_;
#line 279 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp16_ = n_tiles;
#line 279 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (_tmp16_ <= 0) {
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								continue;
#line 1415 "computer-player.c"
							}
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp17_ = x;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp18_ = y;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp19_ = n_tiles;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							computer_player_possible_move_init (&move, _tmp17_, _tmp18_, _tmp19_);
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp20_ = move;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp21_ = _computer_player_possible_move_dup0 (&_tmp20_);
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							*moves = g_list_insert_sorted (*moves, _tmp21_, _computer_player_compare_move_gcompare_func);
#line 1431 "computer-player.c"
						}
					}
				}
			}
		}
	}
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = b;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = (*_tmp0_).n_tiles;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = a;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp3_ = (*_tmp2_).n_tiles;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = _tmp1_ - _tmp3_;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 1459 "computer-player.c"
}


static gint computer_player_calculate_heuristic (ComputerPlayer* self, Game* g) {
	gint result = 0;
	gint tile_difference = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Game* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Game* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Game* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = game_get_n_current_tiles (_tmp0_);
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp3_ = g;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp4_ = game_get_n_opponent_tiles (_tmp3_);
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp5_ = _tmp4_;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	tile_difference = _tmp2_ - _tmp5_;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp6_ = self->priv->difficulty_level;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp6_ == 1) {
#line 1503 "computer-player.c"
		gint _tmp7_ = 0;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp7_ = tile_difference;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = -_tmp7_;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 1511 "computer-player.c"
	}
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp8_ = g;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp9_ = game_get_n_tiles (_tmp8_);
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp10_ = _tmp9_;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp10_ >= 54) {
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = tile_difference;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 1525 "computer-player.c"
	}
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp11_ = tile_difference;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp12_ = g;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp13_ = computer_player_eval_heuristic (_tmp12_);
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp14_ = g;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp15_ = computer_player_around (_tmp14_);
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = (_tmp11_ + _tmp13_) + _tmp15_;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 1541 "computer-player.c"
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	count = 0;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = game_get_size (_tmp0_);
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp2_ != 8) {
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = 0;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 1567 "computer-player.c"
	}
	{
		gint x = 0;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		x = 0;
#line 1573 "computer-player.c"
		{
			gboolean _tmp3_ = FALSE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp3_ = TRUE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1580 "computer-player.c"
				gint _tmp5_ = 0;
				Game* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!_tmp3_) {
#line 1587 "computer-player.c"
					gint _tmp4_ = 0;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp4_ = x;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					x = _tmp4_ + 1;
#line 1593 "computer-player.c"
				}
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp3_ = FALSE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp5_ = x;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp6_ = g;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp7_ = game_get_size (_tmp6_);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp8_ = _tmp7_;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					break;
#line 1609 "computer-player.c"
				}
				{
					gint y = 0;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					y = 0;
#line 1615 "computer-player.c"
					{
						gboolean _tmp9_ = FALSE;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp9_ = TRUE;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1622 "computer-player.c"
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint h = 0;
							gint _tmp15_ = 0;
							Game* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							Game* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							Player _tmp24_ = 0;
							Game* _tmp25_ = NULL;
							Player _tmp26_ = 0;
							Player _tmp27_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!_tmp9_) {
#line 1645 "computer-player.c"
								gint _tmp10_ = 0;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp10_ = y;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								y = _tmp10_ + 1;
#line 1651 "computer-player.c"
							}
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp9_ = FALSE;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp11_ = y;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp13_ = game_get_size (_tmp12_);
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp14_ = _tmp13_;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!(_tmp11_ < _tmp14_)) {
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								break;
#line 1667 "computer-player.c"
							}
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp15_ = y;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp16_ = g;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp17_ = game_get_size (_tmp16_);
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp18_ = _tmp17_;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp19_ = x;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp20_ = COMPUTER_PLAYER_heuristic[(_tmp15_ * _tmp18_) + _tmp19_];
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							h = _tmp20_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp21_ = g;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp22_ = x;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp23_ = y;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp24_ = game_get_owner (_tmp21_, _tmp22_, _tmp23_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp25_ = g;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp26_ = game_get_current_color (_tmp25_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp27_ = _tmp26_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (_tmp24_ != _tmp27_) {
#line 1699 "computer-player.c"
								gint _tmp28_ = 0;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp28_ = h;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								h = -_tmp28_;
#line 1705 "computer-player.c"
							}
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp29_ = count;
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp30_ = h;
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							count = _tmp29_ + _tmp30_;
#line 1713 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = count;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 1724 "computer-player.c"
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	count = 0;
#line 1735 "computer-player.c"
	{
		gint x = 0;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		x = 0;
#line 1740 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1747 "computer-player.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1754 "computer-player.c"
					gint _tmp1_ = 0;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1760 "computer-player.c"
				}
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp3_ = g;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp4_ = game_get_size (_tmp3_);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp5_ = _tmp4_;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					break;
#line 1776 "computer-player.c"
				}
				{
					gint y = 0;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					y = 0;
#line 1782 "computer-player.c"
					{
						gboolean _tmp6_ = FALSE;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp6_ = TRUE;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1789 "computer-player.c"
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint a = 0;
							gint _tmp12_ = 0;
							Game* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Game* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							Game* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							Game* _tmp28_ = NULL;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							Game* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							Game* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							Game* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							Game* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							Game* _tmp54_ = NULL;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							Player _tmp57_ = 0;
							Game* _tmp58_ = NULL;
							Player _tmp59_ = 0;
							Player _tmp60_ = 0;
							gint _tmp63_ = 0;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!_tmp6_) {
#line 1847 "computer-player.c"
								gint _tmp7_ = 0;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp7_ = y;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								y = _tmp7_ + 1;
#line 1853 "computer-player.c"
							}
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp6_ = FALSE;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp10_ = game_get_size (_tmp9_);
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!(_tmp8_ < _tmp11_)) {
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								break;
#line 1869 "computer-player.c"
							}
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = 0;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp12_ = a;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp13_ = g;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp14_ = x;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp15_ = y;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp16_ = computer_player_is_empty (_tmp13_, _tmp14_ + 1, _tmp15_);
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp12_ - _tmp16_;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp17_ = a;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp18_ = g;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp19_ = x;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp20_ = y;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp21_ = computer_player_is_empty (_tmp18_, _tmp19_ + 1, _tmp20_ + 1);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp17_ - _tmp21_;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp22_ = a;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp23_ = g;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp24_ = x;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp25_ = y;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp26_ = computer_player_is_empty (_tmp23_, _tmp24_, _tmp25_ + 1);
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp22_ - _tmp26_;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp27_ = a;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp28_ = g;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp29_ = x;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp30_ = y;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp31_ = computer_player_is_empty (_tmp28_, _tmp29_ - 1, _tmp30_ + 1);
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp27_ - _tmp31_;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp32_ = a;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp33_ = g;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp34_ = x;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp35_ = y;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp36_ = computer_player_is_empty (_tmp33_, _tmp34_ - 1, _tmp35_);
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp32_ - _tmp36_;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp37_ = a;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp38_ = g;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp39_ = x;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp40_ = y;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp41_ = computer_player_is_empty (_tmp38_, _tmp39_ - 1, _tmp40_ - 1);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp37_ - _tmp41_;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp42_ = a;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp43_ = g;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp44_ = x;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp45_ = y;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp46_ = computer_player_is_empty (_tmp43_, _tmp44_, _tmp45_ - 1);
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp42_ - _tmp46_;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp47_ = a;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp48_ = g;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp49_ = x;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp50_ = y;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp51_ = computer_player_is_empty (_tmp48_, _tmp49_ + 1, _tmp50_ - 1);
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							a = _tmp47_ - _tmp51_;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp52_ = a;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (_tmp52_ == 0) {
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								a = 2;
#line 1975 "computer-player.c"
							}
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp54_ = g;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp55_ = x;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp56_ = y;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp57_ = game_get_owner (_tmp54_, _tmp55_, _tmp56_);
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp58_ = g;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp59_ = game_get_current_color (_tmp58_);
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp60_ = _tmp59_;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (_tmp57_ == _tmp60_) {
#line 1993 "computer-player.c"
								gint _tmp61_ = 0;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp61_ = a;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp53_ = _tmp61_;
#line 1999 "computer-player.c"
							} else {
								gint _tmp62_ = 0;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp62_ = a;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp53_ = -_tmp62_;
#line 2006 "computer-player.c"
							}
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp63_ = count;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							count = _tmp63_ + _tmp53_;
#line 2012 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = count;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 2023 "computer-player.c"
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = g;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = x;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp3_ = y;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp4_ = game_is_valid_location (_tmp1_, _tmp2_, _tmp3_);
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp4_) {
#line 2046 "computer-player.c"
		Game* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Player _tmp8_ = 0;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp5_ = g;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp6_ = x;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp7_ = y;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp8_ = game_get_owner (_tmp5_, _tmp6_, _tmp7_);
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp0_ = _tmp8_ == PLAYER_NONE;
#line 2061 "computer-player.c"
	} else {
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		_tmp0_ = FALSE;
#line 2065 "computer-player.c"
	}
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp0_) {
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		result = 1;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		return result;
#line 2073 "computer-player.c"
	}
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = 0;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 2079 "computer-player.c"
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp24_ = NULL;
	gint32 i = 0;
	GList* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gint32 _tmp27_ = 0;
	gint xy = 0;
	GList* _tmp28_ = NULL;
	gconstpointer _tmp29_ = NULL;
	Game* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	Game* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	moves = NULL;
#line 2105 "computer-player.c"
	{
		gint x = 0;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		x = 0;
#line 2110 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
			while (TRUE) {
#line 2117 "computer-player.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 2124 "computer-player.c"
					gint _tmp1_ = 0;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 2130 "computer-player.c"
				}
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp3_ = g;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp4_ = game_get_size (_tmp3_);
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				_tmp5_ = _tmp4_;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					break;
#line 2146 "computer-player.c"
				}
				{
					gint y = 0;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
					y = 0;
#line 2152 "computer-player.c"
					{
						gboolean _tmp6_ = FALSE;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						_tmp6_ = TRUE;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
						while (TRUE) {
#line 2159 "computer-player.c"
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Game* _tmp15_ = NULL;
							Player _tmp16_ = 0;
							Player _tmp17_ = 0;
							gboolean _tmp18_ = FALSE;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!_tmp6_) {
#line 2173 "computer-player.c"
								gint _tmp7_ = 0;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp7_ = y;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								y = _tmp7_ + 1;
#line 2179 "computer-player.c"
							}
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp6_ = FALSE;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp10_ = game_get_size (_tmp9_);
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (!(_tmp8_ < _tmp11_)) {
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								break;
#line 2195 "computer-player.c"
							}
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp13_ = x;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp14_ = y;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp15_ = g;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp16_ = game_get_current_color (_tmp15_);
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp17_ = _tmp16_;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							_tmp18_ = game_can_place (_tmp12_, _tmp13_, _tmp14_, _tmp17_);
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
							if (_tmp18_) {
#line 2213 "computer-player.c"
								gint _tmp19_ = 0;
								Game* _tmp20_ = NULL;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp19_ = x;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp20_ = g;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp21_ = game_get_size (_tmp20_);
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp22_ = _tmp21_;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								_tmp23_ = y;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp19_ * _tmp22_) + _tmp23_)));
#line 2231 "computer-player.c"
							}
						}
					}
				}
			}
		}
	}
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp24_ = moves;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (_tmp24_ == NULL) {
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		g_assert_not_reached ();
#line 2245 "computer-player.c"
	}
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp25_ = moves;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp26_ = g_list_length (_tmp25_);
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp27_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp26_));
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	i = _tmp27_;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp28_ = moves;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp29_ = g_list_nth_data (_tmp28_, (guint) i);
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	xy = (gint) ((gintptr) _tmp29_);
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp30_ = g;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp31_ = game_get_size (_tmp30_);
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp32_ = _tmp31_;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_vala_move_x = xy / _tmp32_;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp33_ = g;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp34_ = game_get_size (_tmp33_);
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp35_ = _tmp34_;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_vala_move_y = xy % _tmp35_;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_list_free0 (moves);
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (move_x) {
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		*move_x = _vala_move_x;
#line 2283 "computer-player.c"
	}
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	if (move_y) {
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		*move_y = _vala_move_y;
#line 2289 "computer-player.c"
	}
}


static gboolean computer_player_get_move_pending (ComputerPlayer* self) {
	gboolean result;
	gboolean _result_ = FALSE;
	gboolean _tmp0_ = FALSE;
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_rec_mutex_lock (&self->priv->_move_pending_mutex);
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->_move_pending;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_result_ = _tmp0_;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_rec_mutex_unlock (&self->priv->_move_pending_mutex);
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	result = _result_;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return result;
#line 2312 "computer-player.c"
}


static void computer_player_set_move_pending (ComputerPlayer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_rec_mutex_lock (&self->priv->_move_pending_mutex);
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = value;
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self->priv->_move_pending = _tmp0_;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_rec_mutex_unlock (&self->priv->_move_pending_mutex);
#line 2328 "computer-player.c"
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	(*self).x = _tmp0_;
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	(*self).y = _tmp1_;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_tmp2_ = n_tiles;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	(*self).n_tiles = _tmp2_;
#line 2350 "computer-player.c"
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	return dup;
#line 2362 "computer-player.c"
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_free (self);
#line 2369 "computer-player.c"
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	computer_player_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
#line 2395 "computer-player.c"
}


static void computer_player_instance_init (ComputerPlayer * self) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self->priv->pending_move_id = (guint) 0;
#line 2404 "computer-player.c"
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	_vala_clear_GRecMutex (&self->priv->_move_pending_mutex);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
#line 2418 "computer-player.c"
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	switch (property_id) {
#line 2439 "computer-player.c"
		default:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		break;
#line 2445 "computer-player.c"
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
	switch (property_id) {
#line 2455 "computer-player.c"
		default:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/computer-player.vala"
		break;
#line 2461 "computer-player.c"
	}
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



