/* rygel-http-byte-seek-request.c generated by valac 0.31.1.6-4f062, the Vala compiler
 * generated from rygel-http-byte-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;
typedef struct _RygelHTTPByteSeekRequestPrivate RygelHTTPByteSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPByteSeekRequestPrivate * priv;
};

struct _RygelHTTPByteSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelHTTPByteSeekRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_byte_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE
};
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, RygelHTTPGet* request, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string);
static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self, gint64 value);
gboolean rygel_http_byte_seek_request_supported (RygelHTTPGet* request);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_byte_seek_request_requested (RygelHTTPGet* request);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self);
static void rygel_http_byte_seek_request_finalize (GObject* obj);
static void _vala_rygel_http_byte_seek_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_byte_seek_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPByteSeekRequest * self = NULL;
	const gchar* range = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint64 start_byte = 0LL;
	gint64 end_byte = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPGet* _tmp6_ = NULL;
	RygelHTTPGetHandler* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* parsed_range = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gchar** range_tokens = NULL;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gint64 _tmp27_ = 0LL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint64 _tmp33_ = 0LL;
	gboolean _tmp42_ = FALSE;
	gchar** _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	const gchar* _tmp44_ = NULL;
	gint64 _tmp77_ = 0LL;
	gint64 _tmp78_ = 0LL;
	gint64 _tmp79_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelHTTPByteSeekRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
	range = _tmp3_;
	_tmp4_ = range;
	if (_tmp4_ == NULL) {
		GError* _tmp5_ = NULL;
		_tmp5_ = g_error_new_literal (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Range header not present");
		_inner_error_ = _tmp5_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = request;
	_tmp7_ = _tmp6_->handler;
	_tmp8_ = rygel_http_get_handler_get_resource_size (_tmp7_);
	total_size = _tmp8_;
	_tmp9_ = total_size;
	if (_tmp9_ < ((gint64) 0)) {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp10_ = range;
	_tmp11_ = g_str_has_prefix (_tmp10_, "bytes=");
	if (!_tmp11_) {
		gchar* msg = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		_tmp12_ = g_strdup ("Invalid Range value (missing 'bytes=' field): '%s'");
		msg = _tmp12_;
		_tmp13_ = msg;
		_tmp14_ = range;
		_tmp15_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp13_, _tmp14_);
		_inner_error_ = _tmp15_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp16_ = range;
	_tmp17_ = string_substring (_tmp16_, (glong) 6, (glong) -1);
	parsed_range = _tmp17_;
	_tmp18_ = string_contains (parsed_range, "-");
	if (!_tmp18_) {
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		_tmp19_ = range;
		_tmp20_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range request with no '-': '%s'", _tmp19_);
		_inner_error_ = _tmp20_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = _tmp21_ = g_strsplit (parsed_range, "-", 2);
	range_tokens = _tmp22_;
	range_tokens_length1 = _vala_array_length (_tmp21_);
	_range_tokens_size_ = range_tokens_length1;
	_tmp23_ = range_tokens;
	_tmp23__length1 = range_tokens_length1;
	_tmp24_ = _tmp23_[0];
	_tmp25_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp28_ = int64_try_parse (_tmp26_, &_tmp27_);
	start_byte = _tmp27_;
	_tmp29_ = !_tmp28_;
	_g_free0 (_tmp26_);
	if (_tmp29_) {
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		_tmp30_ = range;
		_tmp31_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range start value: '%s'", _tmp30_);
		_inner_error_ = _tmp31_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp33_ = total_size;
	if (_tmp33_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp34_ = 0LL;
		gint64 _tmp35_ = 0LL;
		_tmp34_ = start_byte;
		_tmp35_ = total_size;
		_tmp32_ = _tmp34_ >= _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gchar* msg = NULL;
		gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gint64 _tmp38_ = 0LL;
		gint64 _tmp39_ = 0LL;
		const gchar* _tmp40_ = NULL;
		GError* _tmp41_ = NULL;
		_tmp36_ = g_strdup ("Range start value %lld is larger than content size %lld: '%s'");
		msg = _tmp36_;
		_tmp37_ = msg;
		_tmp38_ = start_byte;
		_tmp39_ = total_size;
		_tmp40_ = range;
		_tmp41_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp37_, _tmp38_, _tmp39_, _tmp40_);
		_inner_error_ = _tmp41_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp43_ = range_tokens;
	_tmp43__length1 = range_tokens_length1;
	_tmp44_ = _tmp43_[1];
	if (_tmp44_ == NULL) {
		_tmp42_ = TRUE;
	} else {
		gchar** _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		const gchar* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		_tmp45_ = range_tokens;
		_tmp45__length1 = range_tokens_length1;
		_tmp46_ = _tmp45_[1];
		_tmp47_ = strlen (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp42_ = _tmp48_ == 0;
	}
	if (_tmp42_) {
		gint64 _tmp49_ = 0LL;
		_tmp49_ = total_size;
		if (_tmp49_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			gint64 _tmp50_ = 0LL;
			gint64 _tmp51_ = 0LL;
			gint64 _tmp52_ = 0LL;
			_tmp50_ = total_size;
			end_byte = _tmp50_ - 1;
			_tmp51_ = end_byte;
			_tmp52_ = start_byte;
			rygel_http_byte_seek_request_set_range_length (self, (_tmp51_ - _tmp52_) + 1);
		} else {
			end_byte = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
			rygel_http_byte_seek_request_set_range_length (self, RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED);
		}
	} else {
		gchar** _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		gint64 _tmp57_ = 0LL;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		gint64 _tmp62_ = 0LL;
		gint64 _tmp63_ = 0LL;
		gboolean _tmp70_ = FALSE;
		gint64 _tmp71_ = 0LL;
		gint64 _tmp75_ = 0LL;
		gint64 _tmp76_ = 0LL;
		_tmp53_ = range_tokens;
		_tmp53__length1 = range_tokens_length1;
		_tmp54_ = _tmp53_[1];
		_tmp55_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp58_ = int64_try_parse (_tmp56_, &_tmp57_);
		end_byte = _tmp57_;
		_tmp59_ = !_tmp58_;
		_g_free0 (_tmp56_);
		if (_tmp59_) {
			const gchar* _tmp60_ = NULL;
			GError* _tmp61_ = NULL;
			_tmp60_ = range;
			_tmp61_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range end value: '%s'", _tmp60_);
			_inner_error_ = _tmp61_;
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp62_ = end_byte;
		_tmp63_ = start_byte;
		if (_tmp62_ < _tmp63_) {
			gchar* msg = NULL;
			gchar* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			gint64 _tmp66_ = 0LL;
			gint64 _tmp67_ = 0LL;
			const gchar* _tmp68_ = NULL;
			GError* _tmp69_ = NULL;
			_tmp64_ = g_strdup ("Range end value %lld is smaller than range start value %lld: '%s'");
			msg = _tmp64_;
			_tmp65_ = msg;
			_tmp66_ = end_byte;
			_tmp67_ = start_byte;
			_tmp68_ = range;
			_tmp69_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp65_, _tmp66_, _tmp67_, _tmp68_);
			_inner_error_ = _tmp69_;
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
		_tmp71_ = total_size;
		if (_tmp71_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			gint64 _tmp72_ = 0LL;
			gint64 _tmp73_ = 0LL;
			_tmp72_ = end_byte;
			_tmp73_ = total_size;
			_tmp70_ = _tmp72_ >= _tmp73_;
		} else {
			_tmp70_ = FALSE;
		}
		if (_tmp70_) {
			gint64 _tmp74_ = 0LL;
			_tmp74_ = total_size;
			end_byte = _tmp74_ - 1;
		}
		_tmp75_ = end_byte;
		_tmp76_ = start_byte;
		rygel_http_byte_seek_request_set_range_length (self, (_tmp75_ - _tmp76_) + 1);
	}
	_tmp77_ = start_byte;
	rygel_http_byte_seek_request_set_start_byte (self, _tmp77_);
	_tmp78_ = end_byte;
	rygel_http_byte_seek_request_set_end_byte (self, _tmp78_);
	_tmp79_ = total_size;
	rygel_http_byte_seek_request_set_total_size (self, _tmp79_);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	return self;
}


RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (RygelHTTPGet* request, GError** error) {
	return rygel_http_byte_seek_request_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, request, error);
}


gboolean rygel_http_byte_seek_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = request;
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
		hack = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_tmp3_ = rygel_client_hacks_force_seek (hack);
		force_seek = _tmp3_;
		_g_object_unref0 (hack);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = force_seek;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		RygelHTTPGet* _tmp6_ = NULL;
		RygelHTTPGetHandler* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = request;
		_tmp7_ = _tmp6_->handler;
		_tmp8_ = rygel_http_get_handler_supports_byte_seek (_tmp7_);
		_tmp4_ = _tmp8_;
	}
	result = _tmp4_;
	return result;
}


gboolean rygel_http_byte_seek_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
	result = _tmp3_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string) {
	gchar* result = NULL;
	gint i = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (number_string != NULL, NULL);
	i = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar _tmp3_ = '\0';
		gint _tmp8_ = 0;
		_tmp1_ = number_string;
		_tmp2_ = i;
		_tmp3_ = string_get (_tmp1_, (glong) _tmp2_);
		if (_tmp3_ == '0') {
			gint _tmp4_ = 0;
			const gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp4_ = i;
			_tmp5_ = number_string;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp0_ = _tmp4_ < _tmp7_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	_tmp9_ = i;
	if (_tmp9_ == 0) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = number_string;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	} else {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		_tmp12_ = number_string;
		_tmp13_ = i;
		_tmp14_ = number_string;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
		result = _tmp17_;
		return result;
	}
}


gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_byte;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_byte = _tmp0_;
	g_object_notify ((GObject *) self, "start-byte");
}


gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_byte;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_byte = _tmp0_;
	g_object_notify ((GObject *) self, "end-byte");
}


gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_range_length;
	result = _tmp0_;
	return result;
}


static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_range_length = _tmp0_;
	g_object_notify ((GObject *) self, "range-length");
}


gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_size;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_size = _tmp0_;
	g_object_notify ((GObject *) self, "total-size");
}


static void rygel_http_byte_seek_request_class_init (RygelHTTPByteSeekRequestClass * klass) {
	rygel_http_byte_seek_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekRequestPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_byte_seek_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_byte_seek_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_request_finalize;
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The length of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_byte_seek_request_instance_init (RygelHTTPByteSeekRequest * self) {
	self->priv = RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_PRIVATE (self);
}


static void rygel_http_byte_seek_request_finalize (GObject* obj) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	G_OBJECT_CLASS (rygel_http_byte_seek_request_parent_class)->finalize (obj);
}


GType rygel_http_byte_seek_request_get_type (void) {
	static volatile gsize rygel_http_byte_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekRequest), 0, (GInstanceInitFunc) rygel_http_byte_seek_request_instance_init, NULL };
		GType rygel_http_byte_seek_request_type_id;
		rygel_http_byte_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPByteSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_request_type_id__volatile, rygel_http_byte_seek_request_type_id);
	}
	return rygel_http_byte_seek_request_type_id__volatile;
}


static void _vala_rygel_http_byte_seek_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_start_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_end_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_range_length (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_byte_seek_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE:
		rygel_http_byte_seek_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE:
		rygel_http_byte_seek_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH:
		rygel_http_byte_seek_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE:
		rygel_http_byte_seek_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



