/* rygel-lms-album.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-lms-album.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_ALBUM (rygel_lms_album_get_type ())
#define RYGEL_LMS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_ALBUM, RygelLMSAlbum))
#define RYGEL_LMS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_ALBUM, RygelLMSAlbumClass))
#define RYGEL_LMS_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_ALBUM))
#define RYGEL_LMS_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_ALBUM))
#define RYGEL_LMS_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_ALBUM, RygelLMSAlbumClass))

typedef struct _RygelLMSAlbum RygelLMSAlbum;
typedef struct _RygelLMSAlbumClass RygelLMSAlbumClass;
typedef struct _RygelLMSAlbumPrivate RygelLMSAlbumPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;

struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	sqlite3_stmt* stmt_all;
	sqlite3_stmt* stmt_find_object;
	sqlite3_stmt* stmt_added;
	sqlite3_stmt* stmt_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSAlbum {
	RygelLMSCategoryContainer parent_instance;
	RygelLMSAlbumPrivate * priv;
};

struct _RygelLMSAlbumClass {
	RygelLMSCategoryContainerClass parent_class;
};


static gpointer rygel_lms_album_parent_class = NULL;

GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
GType rygel_lms_album_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_LMS_ALBUM_DUMMY_PROPERTY
};
#define RYGEL_LMS_ALBUM_SQL_ALL_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALBUM_SQL_COUNT_TEMPLATE "SELECT COUNT(audios.id) " "FROM audios, files " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s;"
#define RYGEL_LMS_ALBUM_SQL_COUNT_WITH_FILTER_TEMPLATE "SELECT COUNT(audios.id), audios.title as title, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s;"
#define RYGEL_LMS_ALBUM_SQL_FIND_OBJECT_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND files.id = ? AND audios.id = files.id " "AND audios.album_id = %s;"
#define RYGEL_LMS_ALBUM_SQL_ADDED_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALBUM_SQL_REMOVED_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime <> 0 AND audios.id = files.id AND audios.album_id = %s " "AND update_id > ? AND update_id <= ?;"
static RygelMediaObject* rygel_lms_album_real_object_from_statement (RygelLMSCategoryContainer* base, sqlite3_stmt* statement);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self, gint db_id);
gchar* rygel_lms_category_container_build_reference_id (RygelLMSCategoryContainer* self, gint db_id);
static gchar* rygel_lms_album_get_sql_all (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_find_object (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_count (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_added (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_removed (const gchar* db_id);
static gchar* rygel_lms_album_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base, const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_all (RygelLMSCategoryContainer* self);
const gchar* rygel_lms_category_container_get_db_id (RygelLMSCategoryContainer* self);
static gchar* rygel_lms_album_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base, const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_count (RygelLMSCategoryContainer* self);
gpointer rygel_lms_database_ref (gpointer instance);
void rygel_lms_database_unref (gpointer instance);
GParamSpec* rygel_lms_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_lms_value_set_database (GValue* value, gpointer v_object);
void rygel_lms_value_take_database (GValue* value, gpointer v_object);
gpointer rygel_lms_value_get_database (const GValue* value);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
RygelLMSAlbum* rygel_lms_album_new (const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db);
RygelLMSAlbum* rygel_lms_album_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db, const gchar* sql_all, const gchar* sql_find_object, const gchar* sql_count, const gchar* sql_added, const gchar* sql_removed);


static RygelMediaObject* rygel_lms_album_real_object_from_statement (RygelLMSCategoryContainer* base, sqlite3_stmt* statement) {
	RygelLMSAlbum * self;
	RygelMediaObject* result = NULL;
	gint id = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* path = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* mime_type = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gchar* title = NULL;
	sqlite3_stmt* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* song_id = NULL;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	RygelMusicItem* song = NULL;
	RygelMusicItem* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	sqlite3_stmt* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	sqlite3_stmt* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	sqlite3_stmt* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	sqlite3_stmt* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	sqlite3_stmt* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	sqlite3_stmt* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	sqlite3_stmt* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp43_ = NULL;
	GFile* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	self = (RygelLMSAlbum*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = statement;
	_tmp1_ = sqlite3_column_int (_tmp0_, 0);
	id = _tmp1_;
	_tmp2_ = statement;
	_tmp3_ = sqlite3_column_text (_tmp2_, 1);
	_tmp4_ = g_strdup (_tmp3_);
	path = _tmp4_;
	_tmp5_ = statement;
	_tmp6_ = sqlite3_column_text (_tmp5_, 10);
	_tmp7_ = g_strdup (_tmp6_);
	mime_type = _tmp7_;
	_tmp9_ = mime_type;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp10_ = mime_type;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == 0;
	}
	if (_tmp8_) {
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = id;
		_tmp14_ = path;
		g_debug ("rygel-lms-album.vala:111: Music item %d (%s) has no MIME type", _tmp13_, _tmp14_);
	}
	_tmp15_ = statement;
	_tmp16_ = sqlite3_column_text (_tmp15_, 3);
	_tmp17_ = g_strdup (_tmp16_);
	title = _tmp17_;
	_tmp18_ = id;
	_tmp19_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, _tmp18_);
	song_id = _tmp19_;
	_tmp20_ = rygel_music_item_new (song_id, (RygelMediaContainer*) self, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
	song = _tmp20_;
	_tmp21_ = id;
	_tmp22_ = rygel_lms_category_container_build_reference_id ((RygelLMSCategoryContainer*) self, _tmp21_);
	_tmp23_ = _tmp22_;
	rygel_media_object_set_ref_id ((RygelMediaObject*) song, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = statement;
	_tmp25_ = sqlite3_column_int (_tmp24_, 2);
	rygel_media_file_item_set_size ((RygelMediaFileItem*) song, (gint64) _tmp25_);
	_tmp26_ = statement;
	_tmp27_ = sqlite3_column_int (_tmp26_, 4);
	rygel_music_item_set_track_number (song, _tmp27_);
	_tmp28_ = statement;
	_tmp29_ = sqlite3_column_int (_tmp28_, 5);
	rygel_audio_item_set_duration ((RygelAudioItem*) song, (glong) _tmp29_);
	_tmp30_ = statement;
	_tmp31_ = sqlite3_column_int (_tmp30_, 6);
	rygel_audio_item_set_channels ((RygelAudioItem*) song, _tmp31_);
	_tmp32_ = statement;
	_tmp33_ = sqlite3_column_int (_tmp32_, 7);
	rygel_audio_item_set_sample_freq ((RygelAudioItem*) song, _tmp33_);
	_tmp34_ = statement;
	_tmp35_ = sqlite3_column_int (_tmp34_, 8);
	rygel_audio_item_set_bitrate ((RygelAudioItem*) song, _tmp35_);
	_tmp36_ = statement;
	_tmp37_ = sqlite3_column_text (_tmp36_, 9);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) song, _tmp37_);
	_tmp38_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) song, _tmp38_);
	_tmp39_ = statement;
	_tmp40_ = sqlite3_column_text (_tmp39_, 11);
	rygel_media_object_set_artist ((RygelMediaObject*) song, _tmp40_);
	_tmp41_ = statement;
	_tmp42_ = sqlite3_column_text (_tmp41_, 12);
	rygel_audio_item_set_album ((RygelAudioItem*) song, _tmp42_);
	_tmp43_ = path;
	_tmp44_ = g_file_new_for_path (_tmp43_);
	file = _tmp44_;
	_tmp45_ = g_file_get_uri (file);
	_tmp46_ = _tmp45_;
	rygel_media_object_add_uri ((RygelMediaObject*) song, _tmp46_);
	_g_free0 (_tmp46_);
	result = (RygelMediaObject*) song;
	_g_object_unref0 (file);
	_g_free0 (song_id);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}


static gchar* rygel_lms_album_get_sql_all (const gchar* db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = db_id;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_ALL_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_album_get_sql_find_object (const gchar* db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = db_id;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_FIND_OBJECT_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_album_get_sql_count (const gchar* db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = db_id;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_COUNT_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_album_get_sql_added (const gchar* db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = db_id;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_ADDED_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_album_get_sql_removed (const gchar* db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = db_id;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_REMOVED_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_album_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base, const gchar* filter) {
	RygelLMSAlbum * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* filter_str = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	self = (RygelLMSAlbum*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = filter;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = rygel_lms_category_container_get_sql_all ((RygelLMSCategoryContainer*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = rygel_lms_category_container_get_db_id ((RygelLMSCategoryContainer*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = filter;
	_tmp9_ = g_strdup_printf ("%s AND %s", _tmp7_, _tmp8_);
	filter_str = _tmp9_;
	_tmp10_ = filter_str;
	_tmp11_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_ALL_TEMPLATE, _tmp10_);
	result = _tmp11_;
	_g_free0 (filter_str);
	return result;
}


static gchar* rygel_lms_album_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base, const gchar* filter) {
	RygelLMSAlbum * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* filter_str = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	self = (RygelLMSAlbum*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = filter;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = rygel_lms_category_container_get_sql_count ((RygelLMSCategoryContainer*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = rygel_lms_category_container_get_db_id ((RygelLMSCategoryContainer*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = filter;
	_tmp9_ = g_strdup_printf ("%s AND %s", _tmp7_, _tmp8_);
	filter_str = _tmp9_;
	_tmp10_ = filter_str;
	_tmp11_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_COUNT_WITH_FILTER_TEMPLATE, _tmp10_);
	result = _tmp11_;
	_g_free0 (filter_str);
	return result;
}


RygelLMSAlbum* rygel_lms_album_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db) {
	RygelLMSAlbum * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelLMSDatabase* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = db_id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = lms_db;
	_tmp4_ = db_id;
	_tmp5_ = rygel_lms_album_get_sql_all (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = db_id;
	_tmp8_ = rygel_lms_album_get_sql_find_object (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = db_id;
	_tmp11_ = rygel_lms_album_get_sql_count (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = db_id;
	_tmp14_ = rygel_lms_album_get_sql_added (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = db_id;
	_tmp17_ = rygel_lms_album_get_sql_removed (_tmp16_);
	_tmp18_ = _tmp17_;
	self = (RygelLMSAlbum*) rygel_lms_category_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp6_, _tmp9_, _tmp12_, _tmp15_, _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	return self;
}


RygelLMSAlbum* rygel_lms_album_new (const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db) {
	return rygel_lms_album_construct (RYGEL_LMS_TYPE_ALBUM, db_id, parent, title, lms_db);
}


static void rygel_lms_album_class_init (RygelLMSAlbumClass * klass) {
	rygel_lms_album_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = rygel_lms_album_real_object_from_statement;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = rygel_lms_album_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = rygel_lms_album_real_get_sql_count_with_filter;
}


static void rygel_lms_album_instance_init (RygelLMSAlbum * self) {
}


GType rygel_lms_album_get_type (void) {
	static volatile gsize rygel_lms_album_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_album_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAlbumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_album_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAlbum), 0, (GInstanceInitFunc) rygel_lms_album_instance_init, NULL };
		GType rygel_lms_album_type_id;
		rygel_lms_album_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAlbum", &g_define_type_info, 0);
		g_once_init_leave (&rygel_lms_album_type_id__volatile, rygel_lms_album_type_id);
	}
	return rygel_lms_album_type_id__volatile;
}



