/* rygel-gst-data-source.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from rygel-gst-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/gst.h>
#include <gst/base/base.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE
} RygelGstDataSourceError;
#define RYGEL_GST_DATA_SOURCE_ERROR rygel_gst_data_source_error_quark ()
struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelGstDataSourcePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeekRequest* seek;
	RygelGstSink* sink;
	guint bus_watch_id;
};

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_gst_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_gst_data_source_rygel_data_source_parent_iface = NULL;

GQuark rygel_gst_data_source_error_quark (void);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GType rygel_gst_sink_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourcePrivate))
enum  {
	RYGEL_GST_DATA_SOURCE_DUMMY_PROPERTY
};
RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, RygelMediaResource* resource, GError** error);
RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, RygelMediaResource* resource, GError** error);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static GeeList* rygel_gst_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error);
static void rygel_gst_data_source_real_start (RygelDataSource* base, GError** error);
static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error);
static void rygel_gst_data_source_real_freeze (RygelDataSource* base);
void rygel_gst_sink_freeze (RygelGstSink* self);
static void rygel_gst_data_source_real_thaw (RygelDataSource* base);
void rygel_gst_sink_thaw (RygelGstSink* self);
static void rygel_gst_data_source_real_stop (RygelDataSource* base);
static gboolean __lambda6_ (RygelGstDataSource* self);
static gboolean ___lambda6__gsource_func (gpointer self);
RygelGstSink* rygel_gst_sink_new (RygelDataSource* source, RygelHTTPSeekRequest* offsets);
RygelGstSink* rygel_gst_sink_construct (GType object_type, RygelDataSource* source, RygelHTTPSeekRequest* offsets);
static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad);
static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
#define RYGEL_GST_SINK_NAME "http-gst-sink"
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value);
static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value);
static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
static gboolean ___lambda5_ (RygelGstDataSource* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void rygel_gst_data_source_finalize (GObject* obj);


GQuark rygel_gst_data_source_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_data_source_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, RygelMediaResource* resource, GError** error) {
	RygelGstDataSource * self = NULL;
	RygelMediaResource* _tmp0_ = NULL;
	RygelMediaResource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = resource;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->res);
	self->res = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = rygel_gst_utils_create_source_for_uri (_tmp2_);
	_g_object_unref0 (self->src);
	self->src = _tmp3_;
	_tmp4_ = self->src;
	if (_tmp4_ == NULL) {
		gchar* msg = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		_tmp5_ = _ ("Could not create GstElement for URI %s");
		_tmp6_ = g_strdup (_tmp5_);
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = uri;
		_tmp9_ = g_error_new (RYGEL_GST_DATA_SOURCE_ERROR, RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, _tmp7_, _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, RygelMediaResource* resource, GError** error) {
	return rygel_gst_data_source_construct (RYGEL_TYPE_GST_DATA_SOURCE, uri, resource, error);
}


RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element) {
	RygelGstDataSource * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = element;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->src);
	self->src = _tmp1_;
	return self;
}


RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element) {
	return rygel_gst_data_source_construct_from_element (RYGEL_TYPE_GST_DATA_SOURCE, element);
}


static GeeList* rygel_gst_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error) {
	RygelGstDataSource * self;
	GeeList* result = NULL;
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	RygelPlaySpeedRequest* _tmp1_ = NULL;
	RygelHTTPSeekRequest* _tmp4_ = NULL;
	RygelHTTPSeekRequest* _tmp35_ = NULL;
	RygelHTTPSeekRequest* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	response_list = _tmp0_;
	_tmp1_ = playspeed_request;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = _ ("Playspeed not supported");
		_tmp3_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _tmp2_);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (response_list);
		return NULL;
	}
	_tmp4_ = seek_request;
	if (_tmp4_ == NULL) {
		g_debug ("rygel-gst-data-source.vala:76: No seek requested - sending entire bina" \
"ry");
	} else {
		RygelHTTPSeekRequest* _tmp5_ = NULL;
		_tmp5_ = seek_request;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			RygelHTTPByteSeekResponse* seek_response = NULL;
			RygelHTTPSeekRequest* _tmp6_ = NULL;
			RygelHTTPByteSeekResponse* _tmp7_ = NULL;
			RygelHTTPByteSeekResponse* _tmp8_ = NULL;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			RygelHTTPByteSeekResponse* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			RygelHTTPByteSeekResponse* _tmp14_ = NULL;
			_tmp6_ = seek_request;
			_tmp7_ = rygel_http_byte_seek_response_new_from_request (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp6_) : NULL);
			seek_response = _tmp7_;
			_tmp8_ = seek_response;
			_tmp9_ = rygel_http_byte_seek_response_get_start_byte (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = seek_response;
			_tmp12_ = rygel_http_byte_seek_response_get_end_byte (_tmp11_);
			_tmp13_ = _tmp12_;
			g_debug ("rygel-gst-data-source.vala:81: Processing byte seek request for bytes " \
"%lld-%lld", _tmp10_, _tmp13_);
			_tmp14_ = seek_response;
			gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp14_);
			_g_object_unref0 (seek_response);
		} else {
			RygelHTTPSeekRequest* _tmp15_ = NULL;
			_tmp15_ = seek_request;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
				RygelHTTPTimeSeekRequest* time_seek = NULL;
				RygelHTTPSeekRequest* _tmp16_ = NULL;
				RygelHTTPTimeSeekRequest* _tmp17_ = NULL;
				RygelHTTPTimeSeekResponse* seek_response = NULL;
				RygelHTTPTimeSeekRequest* _tmp18_ = NULL;
				RygelMediaResource* _tmp19_ = NULL;
				glong _tmp20_ = 0L;
				glong _tmp21_ = 0L;
				RygelHTTPTimeSeekResponse* _tmp22_ = NULL;
				RygelHTTPTimeSeekResponse* _tmp23_ = NULL;
				gint64 _tmp24_ = 0LL;
				gint64 _tmp25_ = 0LL;
				RygelHTTPTimeSeekResponse* _tmp26_ = NULL;
				gint64 _tmp27_ = 0LL;
				gint64 _tmp28_ = 0LL;
				RygelHTTPTimeSeekResponse* _tmp29_ = NULL;
				_tmp16_ = seek_request;
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) _tmp16_) : NULL);
				time_seek = _tmp17_;
				_tmp18_ = time_seek;
				_tmp19_ = self->res;
				_tmp20_ = rygel_media_resource_get_duration (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = rygel_http_time_seek_response_new_from_request (_tmp18_, (gint64) (_tmp21_ * G_TIME_SPAN_SECOND));
				seek_response = _tmp22_;
				_tmp23_ = seek_response;
				_tmp24_ = rygel_http_time_seek_response_get_start_time (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = seek_response;
				_tmp27_ = rygel_http_time_seek_response_get_end_time (_tmp26_);
				_tmp28_ = _tmp27_;
				g_debug ("rygel-gst-data-source.vala:95: Processing time seek request for %lldms" \
"-%lldms", _tmp25_, _tmp28_);
				_tmp29_ = seek_response;
				gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp29_);
				_g_object_unref0 (seek_response);
				_g_object_unref0 (time_seek);
			} else {
				const gchar* _tmp30_ = NULL;
				RygelHTTPSeekRequest* _tmp31_ = NULL;
				GType _tmp32_ = 0UL;
				const gchar* _tmp33_ = NULL;
				GError* _tmp34_ = NULL;
				_tmp30_ = _ ("HTTPSeekRequest type %s unsupported");
				_tmp31_ = seek_request;
				_tmp32_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp31_);
				_tmp33_ = g_type_name (_tmp32_);
				_tmp34_ = g_error_new (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp30_, _tmp33_);
				_inner_error_ = _tmp34_;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (response_list);
				return NULL;
			}
		}
	}
	_tmp35_ = seek_request;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (self->priv->seek);
	self->priv->seek = _tmp36_;
	result = (GeeList*) response_list;
	return result;
}


static void rygel_gst_data_source_real_start (RygelDataSource* base, GError** error) {
	RygelGstDataSource * self;
	GstElement* _tmp0_ = NULL;
	RygelHTTPSeekRequest* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->src;
	rygel_gst_data_source_prepare_pipeline (self, "RygelGstDataSource", _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = self->priv->seek;
	if (_tmp1_ != NULL) {
		GstPipeline* _tmp2_ = NULL;
		_tmp2_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_PAUSED);
	} else {
		GstPipeline* _tmp3_ = NULL;
		_tmp3_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp3_, GST_STATE_PLAYING);
	}
}


static void rygel_gst_data_source_real_freeze (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_freeze (_tmp0_);
}


static void rygel_gst_data_source_real_thaw (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_thaw (_tmp0_);
}


static gboolean __lambda6_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ((RygelGstDataSource*) self);
	return result;
}


static void rygel_gst_data_source_real_stop (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GstPipeline* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	_tmp1_ = _tmp0_->cancellable;
	g_cancellable_cancel (_tmp1_);
	_tmp2_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
	_tmp3_ = self->priv->bus_watch_id;
	if (_tmp3_ != ((guint) 0)) {
		guint _tmp4_ = 0U;
		_tmp4_ = self->priv->bus_watch_id;
		g_source_remove (_tmp4_);
		self->priv->bus_watch_id = (guint) 0;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_gst_data_source_src_pad_added ((RygelGstDataSource*) self, _sender, pad);
}


static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_gst_data_source_bus_handler ((RygelGstDataSource*) self, bus, message);
	return result;
}


static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error) {
	RygelHTTPSeekRequest* _tmp0_ = NULL;
	RygelGstSink* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GstPipeline* _tmp3_ = NULL;
	GstPipeline* _tmp4_ = NULL;
	GstPipeline* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	RygelGstSink* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	guint16 _tmp11_ = 0U;
	GstBus* bus = NULL;
	GstPipeline* _tmp27_ = NULL;
	GstBus* _tmp28_ = NULL;
	GstBus* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = self->priv->seek;
	_tmp1_ = rygel_gst_sink_new ((RygelDataSource*) self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = (GstPipeline*) gst_pipeline_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp3_;
	_tmp4_ = self->priv->pipeline;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("Failed to create pipeline");
		_tmp6_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = self->priv->pipeline;
	_tmp8_ = src;
	_tmp9_ = self->priv->sink;
	gst_bin_add_many ((GstBin*) _tmp7_, _tmp8_, (GstElement*) _tmp9_, NULL);
	_tmp10_ = src;
	_tmp11_ = _tmp10_->numsrcpads;
	if (((gint) _tmp11_) == 0) {
		GstElement* _tmp12_ = NULL;
		_tmp12_ = src;
		g_signal_connect_object (_tmp12_, "pad-added", (GCallback) _rygel_gst_data_source_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		GstElement* _tmp13_ = NULL;
		RygelGstSink* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = src;
		_tmp14_ = self->priv->sink;
		_tmp15_ = gst_element_link (_tmp13_, (GstElement*) _tmp14_);
		if (!_tmp15_) {
			const gchar* _tmp16_ = NULL;
			GstElement* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			RygelGstSink* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			GError* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
			_tmp16_ = _ ("Failed to link %s to %s");
			_tmp17_ = src;
			g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->sink;
			g_object_get ((GstObject*) _tmp21_, "name", &_tmp22_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_;
			_tmp25_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp16_, _tmp20_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp24_);
			_g_free0 (_tmp20_);
			_inner_error_ = _tmp26_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp27_ = self->priv->pipeline;
	_tmp28_ = gst_pipeline_get_bus (_tmp27_);
	bus = _tmp28_;
	_tmp29_ = bus;
	_tmp30_ = gst_bus_add_watch_full (_tmp29_, G_PRIORITY_DEFAULT, _rygel_gst_data_source_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	self->priv->bus_watch_id = _tmp30_;
	_g_object_unref0 (bus);
}


static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad) {
	GstCaps* caps = NULL;
	GstPad* _tmp0_ = NULL;
	GstCaps* _tmp1_ = NULL;
	GstElement* sink = NULL;
	GstPipeline* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstPad* sink_pad = NULL;
	GstElement* depay = NULL;
	GstCaps* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstPad* _tmp29_ = NULL;
	GstPad* _tmp30_ = NULL;
	GstPadLinkReturn _tmp31_ = 0;
	GstElement* _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	_tmp0_ = src_pad;
	_tmp1_ = gst_pad_query_caps (_tmp0_, NULL);
	caps = _tmp1_;
	_tmp2_ = self->priv->pipeline;
	_tmp3_ = gst_bin_get_by_name ((GstBin*) _tmp2_, RYGEL_GST_SINK_NAME);
	sink = _tmp3_;
	_tmp4_ = caps;
	_tmp5_ = rygel_gst_utils_get_rtp_depayloader (_tmp4_);
	depay = _tmp5_;
	_tmp6_ = depay;
	if (_tmp6_ != NULL) {
		GstPipeline* _tmp7_ = NULL;
		GstElement* _tmp8_ = NULL;
		GstElement* _tmp9_ = NULL;
		GstElement* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GstElement* _tmp21_ = NULL;
		GstPad* _tmp22_ = NULL;
		GstCaps* _tmp23_ = NULL;
		GstPad* _tmp24_ = NULL;
		_tmp7_ = self->priv->pipeline;
		_tmp8_ = depay;
		gst_bin_add ((GstBin*) _tmp7_, _tmp8_);
		_tmp9_ = depay;
		_tmp10_ = sink;
		_tmp11_ = gst_element_link (_tmp9_, _tmp10_);
		if (!_tmp11_) {
			const gchar* _tmp12_ = NULL;
			GstElement* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			GstElement* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp12_ = _ ("Failed to link %s to %s");
			_tmp13_ = depay;
			g_object_get ((GstObject*) _tmp13_, "name", &_tmp14_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = sink;
			g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			g_critical (_tmp12_, _tmp16_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
			g_signal_emit_by_name ((RygelDataSource*) self, "done");
			_g_object_unref0 (depay);
			_g_object_unref0 (sink_pad);
			_g_object_unref0 (sink);
			_gst_caps_unref0 (caps);
			return;
		}
		_tmp21_ = depay;
		_tmp22_ = src_pad;
		_tmp23_ = caps;
		_tmp24_ = gst_element_get_compatible_pad (_tmp21_, _tmp22_, _tmp23_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp24_;
	} else {
		GstElement* _tmp25_ = NULL;
		GstPad* _tmp26_ = NULL;
		GstCaps* _tmp27_ = NULL;
		GstPad* _tmp28_ = NULL;
		_tmp25_ = sink;
		_tmp26_ = src_pad;
		_tmp27_ = caps;
		_tmp28_ = gst_element_get_compatible_pad (_tmp25_, _tmp26_, _tmp27_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp28_;
	}
	_tmp29_ = src_pad;
	_tmp30_ = sink_pad;
	_tmp31_ = gst_pad_link_full (_tmp29_, _tmp30_, GST_PAD_LINK_CHECK_DEFAULT);
	if (_tmp31_ != GST_PAD_LINK_OK) {
		const gchar* _tmp32_ = NULL;
		GstPad* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GstPad* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp32_ = _ ("Failed to link pad %s to %s");
		_tmp33_ = src_pad;
		g_object_get ((GstObject*) _tmp33_, "name", &_tmp34_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_;
		_tmp37_ = sink_pad;
		g_object_get ((GstObject*) _tmp37_, "name", &_tmp38_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp39_;
		g_critical (_tmp32_, _tmp36_, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp36_);
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
		_g_object_unref0 (depay);
		_g_object_unref0 (sink_pad);
		_g_object_unref0 (sink);
		_gst_caps_unref0 (caps);
		return;
	}
	_tmp41_ = depay;
	if (_tmp41_ != NULL) {
		GstElement* _tmp42_ = NULL;
		_tmp42_ = depay;
		gst_element_sync_state_with_parent (_tmp42_);
	}
	_g_object_unref0 (depay);
	_g_object_unref0 (sink_pad);
	_g_object_unref0 (sink);
	_gst_caps_unref0 (caps);
}


static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value) {
	g_object_set (obj, "streamable", value, NULL);
}


static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value) {
	g_object_set (obj, "fragment-duration", value, NULL);
}


static gboolean ___lambda5_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ ((RygelGstDataSource*) self);
	return result;
}


static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	gboolean _tmp50_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		GstMessage* _tmp2_ = NULL;
		GstMessageType _tmp3_ = 0;
		_tmp2_ = message;
		_tmp3_ = _tmp2_->type;
		if (_tmp3_ == GST_MESSAGE_STATE_CHANGED) {
			GstMessage* _tmp4_ = NULL;
			GstObject* _tmp5_ = NULL;
			GstPipeline* _tmp6_ = NULL;
			GstState old_state = 0;
			GstState new_state = 0;
			GstMessage* _tmp7_ = NULL;
			GstState _tmp8_ = 0;
			GstState _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			GstState _tmp11_ = 0;
			RygelHTTPSeekRequest* _tmp22_ = NULL;
			_tmp4_ = message;
			_tmp5_ = _tmp4_->src;
			_tmp6_ = self->priv->pipeline;
			if (_tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
				result = TRUE;
				return result;
			}
			_tmp7_ = message;
			gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, NULL);
			old_state = _tmp8_;
			new_state = _tmp9_;
			_tmp11_ = old_state;
			if (_tmp11_ == GST_STATE_NULL) {
				GstState _tmp12_ = 0;
				_tmp12_ = new_state;
				_tmp10_ = _tmp12_ == GST_STATE_READY;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				GstElement* element = NULL;
				GstPipeline* _tmp13_ = NULL;
				GstElement* _tmp14_ = NULL;
				GstElement* _tmp15_ = NULL;
				_tmp13_ = self->priv->pipeline;
				_tmp14_ = gst_bin_get_by_name ((GstBin*) _tmp13_, "muxer");
				element = _tmp14_;
				_tmp15_ = element;
				if (_tmp15_ != NULL) {
					gchar* name = NULL;
					GstElement* _tmp16_ = NULL;
					GstElementFactory* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					_tmp16_ = element;
					_tmp17_ = gst_element_get_factory (_tmp16_);
					_tmp18_ = gst_object_get_name ((GstObject*) _tmp17_);
					name = _tmp18_;
					_tmp19_ = name;
					if (g_strcmp0 (_tmp19_, "mp4mux") == 0) {
						GstElement* _tmp20_ = NULL;
						GstElement* _tmp21_ = NULL;
						_tmp20_ = element;
						_dynamic_set_streamable0 (_tmp20_, TRUE);
						_tmp21_ = element;
						_dynamic_set_fragment_duration1 (_tmp21_, 1000);
					}
					_g_free0 (name);
				}
				_g_object_unref0 (element);
			}
			_tmp22_ = self->priv->seek;
			if (_tmp22_ != NULL) {
				gboolean _tmp23_ = FALSE;
				GstState _tmp24_ = 0;
				_tmp24_ = old_state;
				if (_tmp24_ == GST_STATE_READY) {
					GstState _tmp25_ = 0;
					_tmp25_ = new_state;
					_tmp23_ = _tmp25_ == GST_STATE_PAUSED;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					gboolean _tmp26_ = FALSE;
					_tmp26_ = rygel_gst_data_source_perform_seek (self);
					if (_tmp26_) {
						GstPipeline* _tmp27_ = NULL;
						_tmp27_ = self->priv->pipeline;
						gst_element_set_state ((GstElement*) _tmp27_, GST_STATE_PLAYING);
					}
				}
			}
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			GstMessage* _tmp28_ = NULL;
			GstMessageType _tmp29_ = 0;
			_tmp28_ = message;
			_tmp29_ = _tmp28_->type;
			if (_tmp29_ == GST_MESSAGE_ERROR) {
				GstMessage* _tmp30_ = NULL;
				GError* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				GstPipeline* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				_tmp30_ = message;
				gst_message_parse_error (_tmp30_, &_tmp31_, &_tmp32_);
				_g_error_free0 (err);
				err = _tmp31_;
				_g_free0 (err_msg);
				err_msg = _tmp32_;
				_tmp33_ = _ ("Error from pipeline %s: %s");
				_tmp34_ = self->priv->pipeline;
				g_object_get ((GstObject*) _tmp34_, "name", &_tmp35_, NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = _tmp36_;
				_tmp38_ = err_msg;
				g_critical (_tmp33_, _tmp37_, _tmp38_);
				_g_free0 (_tmp37_);
				ret = FALSE;
			} else {
				GstMessage* _tmp39_ = NULL;
				GstMessageType _tmp40_ = 0;
				_tmp39_ = message;
				_tmp40_ = _tmp39_->type;
				if (_tmp40_ == GST_MESSAGE_WARNING) {
					GstMessage* _tmp41_ = NULL;
					GError* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					GstPipeline* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
					_tmp41_ = message;
					gst_message_parse_warning (_tmp41_, &_tmp42_, &_tmp43_);
					_g_error_free0 (err);
					err = _tmp42_;
					_g_free0 (err_msg);
					err_msg = _tmp43_;
					_tmp44_ = _ ("Warning from pipeline %s: %s");
					_tmp45_ = self->priv->pipeline;
					g_object_get ((GstObject*) _tmp45_, "name", &_tmp46_, NULL);
					_tmp47_ = _tmp46_;
					_tmp48_ = _tmp47_;
					_tmp49_ = err_msg;
					g_warning (_tmp44_, _tmp48_, _tmp49_);
					_g_free0 (_tmp48_);
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
	_tmp50_ = ret;
	if (!_tmp50_) {
		g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->bus_watch_id = (guint) 0;
	}
	result = ret;
	return result;
}


static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self) {
	gboolean result = FALSE;
	GstSeekType stop_type = 0;
	GstFormat format = 0;
	GstSeekFlags flags = 0;
	gint64 start = 0LL;
	gint64 stop = 0LL;
	RygelHTTPSeekRequest* _tmp0_ = NULL;
	gint64 _tmp31_ = 0LL;
	GstPipeline* _tmp32_ = NULL;
	GstFormat _tmp33_ = 0;
	GstSeekFlags _tmp34_ = 0;
	gint64 _tmp35_ = 0LL;
	GstSeekType _tmp36_ = 0;
	gint64 _tmp37_ = 0LL;
	gboolean _tmp38_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	stop_type = GST_SEEK_TYPE_NONE;
	flags = GST_SEEK_FLAG_FLUSH;
	_tmp0_ = self->priv->seek;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
		RygelHTTPTimeSeekRequest* time_seek = NULL;
		RygelHTTPSeekRequest* _tmp1_ = NULL;
		RygelHTTPTimeSeekRequest* _tmp2_ = NULL;
		GstSeekFlags _tmp3_ = 0;
		RygelHTTPTimeSeekRequest* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		RygelHTTPTimeSeekRequest* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		_tmp1_ = self->priv->seek;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) _tmp1_) : NULL);
		time_seek = _tmp2_;
		format = GST_FORMAT_TIME;
		_tmp3_ = flags;
		flags = _tmp3_ | GST_SEEK_FLAG_KEY_UNIT;
		_tmp4_ = time_seek;
		_tmp5_ = _tmp4_->start_time;
		start = _tmp5_ * GST_USECOND;
		_tmp6_ = time_seek;
		_tmp7_ = _tmp6_->end_time;
		stop = _tmp7_ * GST_USECOND;
		_tmp8_ = start;
		_tmp9_ = stop;
		g_debug ("rygel-gst-data-source.vala:285: Performing time-range seek: %lldns to " \
"%lldns", _tmp8_, _tmp9_);
		_g_object_unref0 (time_seek);
	} else {
		RygelHTTPSeekRequest* _tmp10_ = NULL;
		_tmp10_ = self->priv->seek;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			RygelHTTPByteSeekRequest* byte_seek = NULL;
			RygelHTTPSeekRequest* _tmp11_ = NULL;
			RygelHTTPByteSeekRequest* _tmp12_ = NULL;
			RygelHTTPByteSeekRequest* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
			RygelHTTPByteSeekRequest* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			gint64 _tmp18_ = 0LL;
			GstSeekFlags _tmp19_ = 0;
			RygelHTTPByteSeekRequest* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			gint64 _tmp22_ = 0LL;
			RygelHTTPByteSeekRequest* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
			gint64 _tmp25_ = 0LL;
			gint64 _tmp26_ = 0LL;
			gint64 _tmp27_ = 0LL;
			_tmp11_ = self->priv->seek;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp11_) : NULL);
			byte_seek = _tmp12_;
			_tmp13_ = byte_seek;
			_tmp14_ = rygel_http_byte_seek_request_get_range_length (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = byte_seek;
			_tmp17_ = rygel_http_byte_seek_request_get_total_size (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp15_ >= _tmp18_) {
				result = TRUE;
				_g_object_unref0 (byte_seek);
				return result;
			}
			format = GST_FORMAT_BYTES;
			_tmp19_ = flags;
			flags = _tmp19_ | GST_SEEK_FLAG_ACCURATE;
			_tmp20_ = byte_seek;
			_tmp21_ = rygel_http_byte_seek_request_get_start_byte (_tmp20_);
			_tmp22_ = _tmp21_;
			start = _tmp22_;
			_tmp23_ = byte_seek;
			_tmp24_ = rygel_http_byte_seek_request_get_end_byte (_tmp23_);
			_tmp25_ = _tmp24_;
			stop = _tmp25_;
			_tmp26_ = start;
			_tmp27_ = stop;
			g_debug ("rygel-gst-data-source.vala:297: Performing byte-range seek: bytes %lld" \
" to %lld", _tmp26_, _tmp27_);
			_g_object_unref0 (byte_seek);
		} else {
			GError* _result_ = NULL;
			const gchar* _tmp28_ = NULL;
			GError* _tmp29_ = NULL;
			GError* _tmp30_ = NULL;
			_tmp28_ = _ ("Unsupported seek type");
			_tmp29_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp28_);
			_result_ = _tmp29_;
			_tmp30_ = _result_;
			g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp30_);
			result = FALSE;
			_g_error_free0 (_result_);
			return result;
		}
	}
	_tmp31_ = stop;
	if (_tmp31_ > ((gint64) 0)) {
		stop_type = GST_SEEK_TYPE_SET;
	}
	_tmp32_ = self->priv->pipeline;
	_tmp33_ = format;
	_tmp34_ = flags;
	_tmp35_ = start;
	_tmp36_ = stop_type;
	_tmp37_ = stop;
	_tmp38_ = gst_element_seek ((GstElement*) _tmp32_, 1.0, _tmp33_, _tmp34_, GST_SEEK_TYPE_SET, _tmp35_, _tmp36_, _tmp37_ + 1);
	if (!_tmp38_) {
		const gchar* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		gint64 _tmp41_ = 0LL;
		const gchar* _tmp42_ = NULL;
		GError* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
		_tmp39_ = _ ("Failed to seek to offsets %lld:%lld");
		_tmp40_ = start;
		_tmp41_ = stop;
		g_warning (_tmp39_, _tmp40_, _tmp41_);
		_tmp42_ = _ ("Failed to seek");
		_tmp43_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp42_);
		_tmp44_ = _tmp43_;
		g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp44_);
		_g_error_free0 (_tmp44_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void rygel_gst_data_source_class_init (RygelGstDataSourceClass * klass) {
	rygel_gst_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstDataSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_data_source_finalize;
}


static void rygel_gst_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
	rygel_gst_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->preroll = (GeeList* (*)(RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_gst_data_source_real_preroll;
	iface->start = (void (*)(RygelDataSource*, GError**)) rygel_gst_data_source_real_start;
	iface->freeze = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_freeze;
	iface->thaw = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_thaw;
	iface->stop = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_stop;
}


static void rygel_gst_data_source_instance_init (RygelGstDataSource * self) {
	self->priv = RYGEL_GST_DATA_SOURCE_GET_PRIVATE (self);
	self->priv->seek = NULL;
}


static void rygel_gst_data_source_finalize (GObject* obj) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	GstPipeline* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource);
	_tmp0_ = self->priv->sink;
	if (_tmp0_ != NULL) {
		RygelGstSink* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
		_tmp1_ = self->priv->sink;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = self->priv->pipeline;
	if (_tmp3_ != NULL) {
		GstPipeline* _tmp4_ = NULL;
		_tmp4_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
	}
	_g_object_unref0 (self->src);
	_g_object_unref0 (self->res);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->seek);
	_g_object_unref0 (self->priv->sink);
	G_OBJECT_CLASS (rygel_gst_data_source_parent_class)->finalize (obj);
}


GType rygel_gst_data_source_get_type (void) {
	static volatile gsize rygel_gst_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstDataSource), 0, (GInstanceInitFunc) rygel_gst_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_gst_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_gst_data_source_type_id;
		rygel_gst_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_gst_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_gst_data_source_type_id__volatile, rygel_gst_data_source_type_id);
	}
	return rygel_gst_data_source_type_id__volatile;
}



