/* chess-view.c generated by valac 0.29.3.11-7fa8, the Vala compiler
 * generated from chess-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <stdio.h>
#include "libchess.h"
#include <glib/gi18n-lib.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessViewPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
	ChessScene* _scene;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GObject parent_instance;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GObjectClass parent_class;
};


static gpointer chess_view_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW, ChessViewPrivate))
enum  {
	CHESS_VIEW_DUMMY_PROPERTY,
	CHESS_VIEW_SCENE
};
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view_render_piece (ChessView* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view_load_theme (ChessView* self, cairo_t* c);
static gboolean chess_view_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view_get_border_size (ChessView* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view_draw_piece (ChessView* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
static gboolean chess_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view_scene_changed_cb (ChessView* self, ChessScene* scene);
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
static void chess_view_finalize (GObject* obj);
static void _vala_chess_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView* chess_view_construct (GType object_type) {
	ChessView * self = NULL;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self = (ChessView*) g_object_new (object_type, NULL);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK));
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return self;
#line 165 "chess-view.c"
}


ChessView* chess_view_new (void) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return chess_view_construct (TYPE_CHESS_VIEW);
#line 172 "chess-view.c"
}


static gboolean chess_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView * self;
	gboolean result = FALSE;
	gint short_edge = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gdouble extra = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self = (ChessView*) base;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	short_edge = _tmp2_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp3_ = short_edge;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp4_ = self->priv->border;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->square_size = (gint) _tmp5_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp6_ = self->priv->square_size;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	extra = _tmp6_ * 0.1;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp7_ = extra;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp7_ < ((gdouble) 3)) {
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		extra = (gdouble) 3;
#line 221 "chess-view.c"
	}
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp8_ = self->priv->square_size;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp9_ = extra;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	result = TRUE;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return result;
#line 233 "chess-view.c"
}


static void chess_view_render_piece (ChessView* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_t* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	RsvgHandle* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	RsvgHandle* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	RsvgHandle* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	cairo_t* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	RsvgHandle* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	RsvgHandle* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	RsvgHandle* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	cairo_t* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c1 != NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c2 != NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (name != NULL);
#line 280 "chess-view.c"
	{
		RsvgHandle* _tmp0_ = NULL;
		ChessScene* _tmp1_ = NULL;
		ChessScene* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		RsvgHandle* _tmp10_ = NULL;
		RsvgHandle* _tmp11_ = NULL;
		RsvgHandle* _tmp12_ = NULL;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp1_ = chess_view_get_scene (self);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp2_ = _tmp1_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp3_ = chess_scene_get_theme_name (_tmp2_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp4_ = _tmp3_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp5_ = name;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp6_ = g_strconcat (_tmp5_, ".svg", NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp7_ = _tmp6_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp8_ = g_build_filename (PKGDATADIR, "pieces", _tmp4_, _tmp7_, NULL, NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp9_ = _tmp8_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp10_ = rsvg_handle_new_from_file (_tmp9_, &_inner_error_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp11_ = _tmp10_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_free0 (_tmp9_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_free0 (_tmp7_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp0_ = _tmp11_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "chess-view.c"
			goto __catch14_g_error;
		}
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp12_ = _tmp0_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp0_ = NULL;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (handle);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		handle = _tmp12_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (_tmp0_);
#line 338 "chess-view.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		e = _inner_error_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_inner_error_ = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp13_ = stderr;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp14_ = e;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp15_ = _tmp14_->message;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		fprintf (_tmp13_, "Failed to load piece svg: %s", _tmp15_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_error_free0 (e);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (handle);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		return;
#line 365 "chess-view.c"
	}
	__finally14:
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_g_object_unref0 (handle);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		g_clear_error (&_inner_error_);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		return;
#line 378 "chess-view.c"
	}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp16_ = c1;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_save (_tmp16_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp17_ = c1;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp18_ = self->priv->square_size;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp19_ = offset;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp17_, (gdouble) (_tmp18_ * _tmp19_), (gdouble) 0);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp20_ = c1;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp21_ = self->priv->square_size;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp22_ = handle;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp22_, "width", &_tmp23_, NULL);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp24_ = _tmp23_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp25_ = self->priv->square_size;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp26_ = handle;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp26_, "height", &_tmp27_, NULL);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp28_ = _tmp27_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_scale (_tmp20_, ((gdouble) _tmp21_) / _tmp24_, ((gdouble) _tmp25_) / _tmp28_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp29_ = handle;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp30_ = c1;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	rsvg_handle_render_cairo (_tmp29_, _tmp30_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp31_ = c1;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_restore (_tmp31_);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp32_ = c2;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_save (_tmp32_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp33_ = c2;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp34_ = self->priv->selected_square_size;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp35_ = offset;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp33_, (gdouble) (_tmp34_ * _tmp35_), (gdouble) 0);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp36_ = c2;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp37_ = self->priv->selected_square_size;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp38_ = handle;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp38_, "width", &_tmp39_, NULL);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp40_ = _tmp39_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp41_ = self->priv->selected_square_size;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp42_ = handle;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_object_get (_tmp42_, "height", &_tmp43_, NULL);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp44_ = _tmp43_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_scale (_tmp36_, ((gdouble) _tmp37_) / _tmp40_, ((gdouble) _tmp41_) / _tmp44_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp45_ = handle;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp46_ = c2;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	rsvg_handle_render_cairo (_tmp45_, _tmp46_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp47_ = c2;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_restore (_tmp47_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_g_object_unref0 (handle);
#line 466 "chess-view.c"
}


static void chess_view_load_theme (ChessView* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	ChessScene* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	cairo_surface_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	cairo_surface_t* _tmp18_ = NULL;
	cairo_t* c1 = NULL;
	cairo_surface_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* c2 = NULL;
	cairo_surface_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
	cairo_t* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	ChessScene* _tmp47_ = NULL;
	ChessScene* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c != NULL);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = chess_view_get_scene (self);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp3_ = _tmp2_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp5_ = _tmp4_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp6_ = self->priv->loaded_theme_name;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
#line 537 "chess-view.c"
		cairo_surface_t* _tmp7_ = NULL;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp7_ = self->priv->model_surface;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp1_ = _tmp7_ != NULL;
#line 543 "chess-view.c"
	} else {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp1_ = FALSE;
#line 547 "chess-view.c"
	}
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp1_) {
#line 551 "chess-view.c"
		gint _tmp8_ = 0;
		cairo_surface_t* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp8_ = self->priv->square_size;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp9_ = self->priv->model_surface;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp10_ = cairo_image_surface_get_height (_tmp9_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp0_ = _tmp8_ == _tmp10_;
#line 563 "chess-view.c"
	} else {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp0_ = FALSE;
#line 567 "chess-view.c"
	}
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp0_) {
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		return;
#line 573 "chess-view.c"
	}
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp11_ = self->priv->square_size;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp12_ = self->priv->square_size;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp13_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp11_, _tmp12_);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->model_surface);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->model_surface = _tmp13_;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp14_ = c;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp15_ = cairo_get_target (_tmp14_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp16_ = self->priv->selected_square_size;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp17_ = self->priv->selected_square_size;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp18_ = cairo_surface_create_similar (_tmp15_, CAIRO_CONTENT_COLOR_ALPHA, 12 * _tmp16_, _tmp17_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->selected_model_surface = _tmp18_;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp19_ = self->priv->model_surface;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp20_ = cairo_create (_tmp19_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	c1 = _tmp20_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp21_ = self->priv->selected_model_surface;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp22_ = cairo_create (_tmp21_);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	c2 = _tmp22_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp23_ = c1;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp24_ = c2;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp23_, _tmp24_, "whitePawn", 0);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp25_ = c1;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp26_ = c2;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp25_, _tmp26_, "whiteRook", 1);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp27_ = c1;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp28_ = c2;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp27_, _tmp28_, "whiteKnight", 2);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp29_ = c1;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp30_ = c2;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp29_, _tmp30_, "whiteBishop", 3);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp31_ = c1;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp32_ = c2;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp31_, _tmp32_, "whiteQueen", 4);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp33_ = c1;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp34_ = c2;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp33_, _tmp34_, "whiteKing", 5);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp35_ = c1;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp36_ = c2;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp35_, _tmp36_, "blackPawn", 6);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp37_ = c1;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp38_ = c2;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp37_, _tmp38_, "blackRook", 7);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp39_ = c1;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp40_ = c2;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp39_, _tmp40_, "blackKnight", 8);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp41_ = c1;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp42_ = c2;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp41_, _tmp42_, "blackBishop", 9);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp43_ = c1;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp44_ = c2;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp43_, _tmp44_, "blackQueen", 10);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp45_ = c1;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp46_ = c2;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_render_piece (self, _tmp45_, _tmp46_, "blackKing", 11);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp47_ = chess_view_get_scene (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp48_ = _tmp47_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp49_ = chess_scene_get_theme_name (_tmp48_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp50_ = _tmp49_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_g_free0 (self->priv->loaded_theme_name);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->loaded_theme_name = _tmp51_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_cairo_destroy0 (c2);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_cairo_destroy0 (c1);
#line 701 "chess-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 708 "chess-view.c"
}


static gboolean chess_view_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	ChessScene* _tmp5_ = NULL;
	ChessScene* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gint board_size = 0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	ChessScene* _tmp40_ = NULL;
	ChessScene* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	ChessScene* _tmp185_ = NULL;
	ChessScene* _tmp186_ = NULL;
	ChessGame* _tmp187_ = NULL;
	ChessGame* _tmp188_ = NULL;
	gboolean _tmp189_ = FALSE;
	gboolean _tmp190_ = FALSE;
	ChessScene* _tmp197_ = NULL;
	ChessScene* _tmp198_ = NULL;
	GList* _tmp199_ = NULL;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self = (ChessView*) base;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = c;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_load_theme (self, _tmp0_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp1_ = c;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp1_, (gdouble) (_tmp2_ / 2), (gdouble) (_tmp3_ / 2));
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp4_ = c;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp5_ = chess_view_get_scene (self);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp6_ = _tmp5_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp7_ = chess_scene_get_board_angle (_tmp6_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp8_ = _tmp7_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_rotate (_tmp4_, (G_PI * _tmp8_) / 180.0);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp9_ = self->priv->square_size;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp10_ = chess_view_get_border_size (self);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp11_ = _tmp10_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp12_ = ceil ((_tmp9_ * 4) + _tmp11_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	board_size = (gint) _tmp12_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp13_ = c;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_set_source_rgb (_tmp13_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp14_ = c;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp15_ = board_size;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp16_ = board_size;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp17_ = board_size;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp18_ = board_size;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_rectangle (_tmp14_, (gdouble) (-_tmp15_), (gdouble) (-_tmp16_), (gdouble) (_tmp17_ * 2), (gdouble) (_tmp18_ * 2));
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp19_ = c;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_fill (_tmp19_);
#line 807 "chess-view.c"
	{
		gint file = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		file = 0;
#line 812 "chess-view.c"
		{
			gboolean _tmp20_ = FALSE;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp20_ = TRUE;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			while (TRUE) {
#line 819 "chess-view.c"
				gint _tmp22_ = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (!_tmp20_) {
#line 823 "chess-view.c"
					gint _tmp21_ = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp21_ = file;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					file = _tmp21_ + 1;
#line 829 "chess-view.c"
				}
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp20_ = FALSE;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp22_ = file;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (!(_tmp22_ < 8)) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					break;
#line 839 "chess-view.c"
				}
				{
					gint rank = 0;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					rank = 0;
#line 845 "chess-view.c"
					{
						gboolean _tmp23_ = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						_tmp23_ = TRUE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						while (TRUE) {
#line 852 "chess-view.c"
							gint _tmp25_ = 0;
							gint x = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint y = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							cairo_t* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							cairo_t* _tmp39_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (!_tmp23_) {
#line 870 "chess-view.c"
								gint _tmp24_ = 0;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp24_ = rank;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								rank = _tmp24_ + 1;
#line 876 "chess-view.c"
							}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp23_ = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp25_ = rank;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (!(_tmp25_ < 8)) {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								break;
#line 886 "chess-view.c"
							}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp26_ = file;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp27_ = self->priv->square_size;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							x = (gint) ((_tmp26_ - 4) * _tmp27_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp28_ = rank;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp29_ = self->priv->square_size;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							y = (gint) ((3 - _tmp28_) * _tmp29_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp30_ = c;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp31_ = x;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp32_ = y;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp33_ = self->priv->square_size;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp34_ = self->priv->square_size;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							cairo_rectangle (_tmp30_, (gdouble) _tmp31_, (gdouble) _tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp35_ = file;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp36_ = rank;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (((_tmp35_ + _tmp36_) % 2) == 0) {
#line 918 "chess-view.c"
								cairo_t* _tmp37_ = NULL;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp37_ = c;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_set_source_rgb (_tmp37_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
#line 924 "chess-view.c"
							} else {
								cairo_t* _tmp38_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp38_ = c;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_set_source_rgb (_tmp38_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
#line 931 "chess-view.c"
							}
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp39_ = c;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							cairo_fill (_tmp39_);
#line 937 "chess-view.c"
						}
					}
				}
			}
		}
	}
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp40_ = chess_view_get_scene (self);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp41_ = _tmp40_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp42_ = chess_scene_get_show_numbering (_tmp41_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp43_ = _tmp42_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp43_) {
#line 954 "chess-view.c"
		cairo_t* _tmp44_ = NULL;
		cairo_t* _tmp45_ = NULL;
		gdouble _tmp46_ = 0.0;
		gdouble _tmp47_ = 0.0;
		cairo_t* _tmp48_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp49_ = NULL;
		cairo_text_extents_t _tmp50_ = {0};
		gdouble y_offset = 0.0;
		gint _tmp51_ = 0;
		cairo_text_extents_t _tmp52_ = {0};
		gdouble _tmp53_ = 0.0;
		cairo_text_extents_t _tmp54_ = {0};
		gdouble _tmp55_ = 0.0;
		cairo_text_extents_t _tmp56_ = {0};
		gdouble _tmp57_ = 0.0;
		gdouble top = 0.0;
		gint _tmp58_ = 0;
		gdouble _tmp59_ = 0.0;
		gdouble bottom = 0.0;
		gint _tmp60_ = 0;
		gdouble _tmp61_ = 0.0;
		gdouble _tmp62_ = 0.0;
		gdouble _tmp63_ = 0.0;
		gdouble file_offset = 0.0;
		gint _tmp64_ = 0;
		gdouble rank_offset = 0.0;
		gint _tmp65_ = 0;
		gchar** files = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** ranks = NULL;
		gint ranks_length1 = 0;
		gint _ranks_size_ = 0;
		cairo_matrix_t matrix = {0};
		cairo_t* _tmp66_ = NULL;
		cairo_matrix_t _tmp67_ = {0};
		ChessScene* _tmp68_ = NULL;
		ChessScene* _tmp69_ = NULL;
		gdouble _tmp70_ = 0.0;
		gdouble _tmp71_ = 0.0;
		cairo_t* _tmp108_ = NULL;
		cairo_t* _tmp109_ = NULL;
		cairo_matrix_t _tmp110_ = {0};
		cairo_t* _tmp184_ = NULL;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp44_ = c;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_set_source_rgb (_tmp44_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp45_ = c;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp46_ = chess_view_get_border_size (self);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp47_ = _tmp46_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_set_font_size (_tmp45_, _tmp47_ * 0.6);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp48_ = c;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_select_font_face (_tmp48_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp49_ = c;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_text_extents (_tmp49_, "abcdefgh", &_tmp50_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		extents = _tmp50_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp51_ = self->priv->square_size;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp52_ = extents;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp53_ = _tmp52_.height;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp54_ = extents;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp55_ = _tmp54_.height;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp56_ = extents;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp57_ = _tmp56_.y_bearing;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		y_offset = ((((_tmp51_ / 2) - _tmp53_) / 2) + _tmp55_) + _tmp57_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp58_ = self->priv->square_size;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp59_ = y_offset;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		top = -((_tmp58_ * 4) + _tmp59_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp60_ = self->priv->square_size;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp61_ = chess_view_get_border_size (self);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp62_ = _tmp61_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp63_ = y_offset;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		bottom = ((_tmp60_ * 4) + _tmp62_) - _tmp63_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp64_ = self->priv->square_size;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		file_offset = -(_tmp64_ * 3.5);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp65_ = self->priv->square_size;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		rank_offset = -(_tmp65_ * 3.5);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp66_ = c;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_get_matrix (_tmp66_, &_tmp67_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		matrix = _tmp67_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp68_ = chess_view_get_scene (self);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp69_ = _tmp68_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp70_ = chess_scene_get_board_angle (_tmp69_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp71_ = _tmp70_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		if (_tmp71_ == 180.0) {
#line 1078 "chess-view.c"
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar** _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar** _tmp89_ = NULL;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp72_ = g_strdup ("h");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp73_ = g_strdup ("g");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp74_ = g_strdup ("f");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp75_ = g_strdup ("e");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp76_ = g_strdup ("d");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp77_ = g_strdup ("c");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp78_ = g_strdup ("b");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp79_ = g_strdup ("a");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_ = g_new0 (gchar*, 8 + 1);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[0] = _tmp72_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[1] = _tmp73_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[2] = _tmp74_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[3] = _tmp75_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[4] = _tmp76_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[5] = _tmp77_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[6] = _tmp78_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp80_[7] = _tmp79_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			files = _tmp80_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			files_length1 = 8;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_files_size_ = files_length1;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp81_ = g_strdup ("1");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp82_ = g_strdup ("2");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp83_ = g_strdup ("3");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp84_ = g_strdup ("4");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp85_ = g_strdup ("5");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp86_ = g_strdup ("6");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp87_ = g_strdup ("7");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp88_ = g_strdup ("8");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_ = g_new0 (gchar*, 8 + 1);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[0] = _tmp81_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[1] = _tmp82_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[2] = _tmp83_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[3] = _tmp84_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[4] = _tmp85_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[5] = _tmp86_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[6] = _tmp87_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp89_[7] = _tmp88_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			ranks = _tmp89_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			ranks_length1 = 8;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_ranks_size_ = ranks_length1;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			cairo_matrix_scale (&matrix, (gdouble) -1, (gdouble) -1);
#line 1183 "chess-view.c"
		} else {
			gchar* _tmp90_ = NULL;
			gchar* _tmp91_ = NULL;
			gchar* _tmp92_ = NULL;
			gchar* _tmp93_ = NULL;
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_ = NULL;
			gchar* _tmp97_ = NULL;
			gchar** _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_ = NULL;
			gchar** _tmp107_ = NULL;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp90_ = g_strdup ("a");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp91_ = g_strdup ("b");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp92_ = g_strdup ("c");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp93_ = g_strdup ("d");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp94_ = g_strdup ("e");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp95_ = g_strdup ("f");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp96_ = g_strdup ("g");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp97_ = g_strdup ("h");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_ = g_new0 (gchar*, 8 + 1);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[0] = _tmp90_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[1] = _tmp91_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[2] = _tmp92_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[3] = _tmp93_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[4] = _tmp94_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[5] = _tmp95_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[6] = _tmp96_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp98_[7] = _tmp97_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			files = _tmp98_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			files_length1 = 8;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_files_size_ = files_length1;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp99_ = g_strdup ("8");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp100_ = g_strdup ("7");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp101_ = g_strdup ("6");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp102_ = g_strdup ("5");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp103_ = g_strdup ("4");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp104_ = g_strdup ("3");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp105_ = g_strdup ("2");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp106_ = g_strdup ("1");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_ = g_new0 (gchar*, 8 + 1);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[0] = _tmp99_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[1] = _tmp100_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[2] = _tmp101_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[3] = _tmp102_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[4] = _tmp103_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[5] = _tmp104_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[6] = _tmp105_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp107_[7] = _tmp106_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			ranks = _tmp107_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			ranks_length1 = 8;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_ranks_size_ = ranks_length1;
#line 1287 "chess-view.c"
		}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp108_ = c;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_save (_tmp108_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp109_ = c;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp110_ = matrix;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_set_matrix (_tmp109_, &_tmp110_);
#line 1299 "chess-view.c"
		{
			gint i = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			i = 0;
#line 1304 "chess-view.c"
			{
				gboolean _tmp111_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp111_ = TRUE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				while (TRUE) {
#line 1311 "chess-view.c"
					gint _tmp113_ = 0;
					cairo_t* _tmp114_ = NULL;
					gchar** _tmp115_ = NULL;
					gint _tmp115__length1 = 0;
					gint _tmp116_ = 0;
					const gchar* _tmp117_ = NULL;
					cairo_text_extents_t _tmp118_ = {0};
					cairo_t* _tmp119_ = NULL;
					cairo_t* _tmp120_ = NULL;
					gdouble _tmp121_ = 0.0;
					cairo_text_extents_t _tmp122_ = {0};
					gdouble _tmp123_ = 0.0;
					gdouble _tmp124_ = 0.0;
					cairo_t* _tmp125_ = NULL;
					gchar** _tmp126_ = NULL;
					gint _tmp126__length1 = 0;
					gint _tmp127_ = 0;
					const gchar* _tmp128_ = NULL;
					cairo_t* _tmp129_ = NULL;
					cairo_t* _tmp130_ = NULL;
					cairo_t* _tmp131_ = NULL;
					gdouble _tmp132_ = 0.0;
					cairo_text_extents_t _tmp133_ = {0};
					gdouble _tmp134_ = 0.0;
					gdouble _tmp135_ = 0.0;
					cairo_t* _tmp136_ = NULL;
					gchar** _tmp137_ = NULL;
					gint _tmp137__length1 = 0;
					gint _tmp138_ = 0;
					const gchar* _tmp139_ = NULL;
					cairo_t* _tmp140_ = NULL;
					cairo_t* _tmp141_ = NULL;
					gchar** _tmp142_ = NULL;
					gint _tmp142__length1 = 0;
					gint _tmp143_ = 0;
					const gchar* _tmp144_ = NULL;
					cairo_text_extents_t _tmp145_ = {0};
					cairo_text_extents_t _tmp146_ = {0};
					gdouble _tmp147_ = 0.0;
					cairo_text_extents_t _tmp148_ = {0};
					gdouble _tmp149_ = 0.0;
					cairo_t* _tmp150_ = NULL;
					cairo_t* _tmp151_ = NULL;
					gint _tmp152_ = 0;
					gdouble _tmp153_ = 0.0;
					gdouble _tmp154_ = 0.0;
					gdouble _tmp155_ = 0.0;
					gdouble _tmp156_ = 0.0;
					cairo_text_extents_t _tmp157_ = {0};
					gdouble _tmp158_ = 0.0;
					gdouble _tmp159_ = 0.0;
					gdouble _tmp160_ = 0.0;
					cairo_t* _tmp161_ = NULL;
					gchar** _tmp162_ = NULL;
					gint _tmp162__length1 = 0;
					gint _tmp163_ = 0;
					const gchar* _tmp164_ = NULL;
					cairo_t* _tmp165_ = NULL;
					cairo_t* _tmp166_ = NULL;
					cairo_t* _tmp167_ = NULL;
					gint _tmp168_ = 0;
					gdouble _tmp169_ = 0.0;
					gdouble _tmp170_ = 0.0;
					cairo_text_extents_t _tmp171_ = {0};
					gdouble _tmp172_ = 0.0;
					gdouble _tmp173_ = 0.0;
					gdouble _tmp174_ = 0.0;
					cairo_t* _tmp175_ = NULL;
					gchar** _tmp176_ = NULL;
					gint _tmp176__length1 = 0;
					gint _tmp177_ = 0;
					const gchar* _tmp178_ = NULL;
					cairo_t* _tmp179_ = NULL;
					gdouble _tmp180_ = 0.0;
					gint _tmp181_ = 0;
					gdouble _tmp182_ = 0.0;
					gint _tmp183_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					if (!_tmp111_) {
#line 1391 "chess-view.c"
						gint _tmp112_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						_tmp112_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						i = _tmp112_ + 1;
#line 1397 "chess-view.c"
					}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp111_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp113_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					if (!(_tmp113_ < 8)) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						break;
#line 1407 "chess-view.c"
					}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp114_ = c;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp115_ = ranks;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp115__length1 = ranks_length1;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp116_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp117_ = _tmp115_[_tmp116_];
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_text_extents (_tmp114_, _tmp117_, &_tmp118_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					extents = _tmp118_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp119_ = c;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp119_);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp120_ = c;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp121_ = file_offset;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp122_ = extents;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp123_ = _tmp122_.width;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp124_ = top;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp120_, _tmp121_ - (_tmp123_ / 2), _tmp124_);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp125_ = c;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp126_ = files;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp126__length1 = files_length1;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp127_ = i;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp128_ = _tmp126_[_tmp127_];
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp125_, _tmp128_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp129_ = c;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp129_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp130_ = c;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp130_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp131_ = c;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp132_ = file_offset;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp133_ = extents;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp134_ = _tmp133_.width;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp135_ = bottom;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp131_, _tmp132_ - (_tmp134_ / 2), _tmp135_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp136_ = c;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp137_ = files;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp137__length1 = files_length1;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp138_ = i;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp139_ = _tmp137_[_tmp138_];
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp136_, _tmp139_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp140_ = c;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp140_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp141_ = c;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp142_ = ranks;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp142__length1 = ranks_length1;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp143_ = i;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp144_ = _tmp142_[_tmp143_];
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_text_extents (_tmp141_, _tmp144_, &_tmp145_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					extents = _tmp145_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp146_ = extents;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp147_ = _tmp146_.y_bearing;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp148_ = extents;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp149_ = _tmp148_.height;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					y_offset = -(_tmp147_ + (_tmp149_ / 2));
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp150_ = c;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp150_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp151_ = c;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp152_ = self->priv->square_size;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp153_ = chess_view_get_border_size (self);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp154_ = _tmp153_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp155_ = chess_view_get_border_size (self);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp156_ = _tmp155_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp157_ = extents;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp158_ = _tmp157_.width;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp159_ = rank_offset;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp160_ = y_offset;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp151_, -(((((gdouble) _tmp152_) * 4) + _tmp154_) - ((_tmp156_ - _tmp158_) / 2)), _tmp159_ + _tmp160_);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp161_ = c;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp162_ = ranks;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp162__length1 = ranks_length1;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp163_ = i;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp164_ = _tmp162_[_tmp163_];
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp161_, _tmp164_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp165_ = c;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp165_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp166_ = c;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_save (_tmp166_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp167_ = c;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp168_ = self->priv->square_size;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp169_ = chess_view_get_border_size (self);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp170_ = _tmp169_;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp171_ = extents;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp172_ = _tmp171_.width;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp173_ = rank_offset;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp174_ = y_offset;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_move_to (_tmp167_, (((gdouble) _tmp168_) * 4) + ((_tmp170_ - _tmp172_) / 2), _tmp173_ + _tmp174_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp175_ = c;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp176_ = ranks;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp176__length1 = ranks_length1;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp177_ = i;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp178_ = _tmp176_[_tmp177_];
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_show_text (_tmp175_, _tmp178_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp179_ = c;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					cairo_restore (_tmp179_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp180_ = file_offset;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp181_ = self->priv->square_size;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					file_offset = _tmp180_ + _tmp181_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp182_ = rank_offset;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp183_ = self->priv->square_size;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					rank_offset = _tmp182_ + _tmp183_;
#line 1603 "chess-view.c"
				}
			}
		}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp184_ = c;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_restore (_tmp184_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 1615 "chess-view.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp185_ = chess_view_get_scene (self);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp186_ = _tmp185_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp187_ = chess_scene_get_game (_tmp186_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp188_ = _tmp187_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp189_ = chess_game_get_should_show_paused_overlay (_tmp188_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp190_ = _tmp189_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp190_) {
#line 1631 "chess-view.c"
		cairo_t* _tmp191_ = NULL;
		ChessScene* _tmp192_ = NULL;
		ChessScene* _tmp193_ = NULL;
		gdouble _tmp194_ = 0.0;
		gdouble _tmp195_ = 0.0;
		cairo_t* _tmp196_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp191_ = c;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp192_ = chess_view_get_scene (self);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp193_ = _tmp192_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp194_ = chess_scene_get_board_angle (_tmp193_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp195_ = _tmp194_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		cairo_rotate (_tmp191_, (G_PI * _tmp195_) / 180.0);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp196_ = c;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		chess_view_draw_paused_overlay (self, _tmp196_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		result = TRUE;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		return result;
#line 1658 "chess-view.c"
	}
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp197_ = chess_view_get_scene (self);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp198_ = _tmp197_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp199_ = _tmp198_->pieces;
#line 1666 "chess-view.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		model_collection = _tmp199_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1674 "chess-view.c"
			ChessModel* _tmp200_ = NULL;
			ChessModel* model = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp200_ = _g_object_ref0 ((ChessModel*) model_it->data);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			model = _tmp200_;
#line 1681 "chess-view.c"
			{
				cairo_t* _tmp201_ = NULL;
				cairo_t* _tmp202_ = NULL;
				ChessModel* _tmp203_ = NULL;
				gdouble _tmp204_ = 0.0;
				gint _tmp205_ = 0;
				ChessModel* _tmp206_ = NULL;
				gdouble _tmp207_ = 0.0;
				gint _tmp208_ = 0;
				cairo_t* _tmp209_ = NULL;
				gint _tmp210_ = 0;
				gint _tmp211_ = 0;
				cairo_t* _tmp212_ = NULL;
				ChessScene* _tmp213_ = NULL;
				ChessScene* _tmp214_ = NULL;
				gdouble _tmp215_ = 0.0;
				gdouble _tmp216_ = 0.0;
				cairo_surface_t* _tmp217_ = NULL;
				ChessModel* _tmp218_ = NULL;
				gboolean _tmp219_ = FALSE;
				gint _tmp222_ = 0;
				ChessModel* _tmp223_ = NULL;
				gboolean _tmp224_ = FALSE;
				gdouble _tmp227_ = 0.0;
				gboolean _tmp228_ = FALSE;
				ChessModel* _tmp229_ = NULL;
				gboolean _tmp230_ = FALSE;
				cairo_t* _tmp235_ = NULL;
				ChessModel* _tmp236_ = NULL;
				ChessPiece* _tmp237_ = NULL;
				cairo_t* _tmp238_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp201_ = c;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				cairo_save (_tmp201_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp202_ = c;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp203_ = model;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp204_ = _tmp203_->x;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp205_ = self->priv->square_size;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp206_ = model;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp207_ = _tmp206_->y;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp208_ = self->priv->square_size;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				cairo_translate (_tmp202_, (_tmp204_ - 4) * _tmp205_, (3 - _tmp207_) * _tmp208_);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp209_ = c;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp210_ = self->priv->square_size;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp211_ = self->priv->square_size;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				cairo_translate (_tmp209_, (gdouble) (_tmp210_ / 2), (gdouble) (_tmp211_ / 2));
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp212_ = c;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp213_ = chess_view_get_scene (self);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp214_ = _tmp213_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp215_ = chess_scene_get_board_angle (_tmp214_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp216_ = _tmp215_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				cairo_rotate (_tmp212_, ((-G_PI) * _tmp216_) / 180.0);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp218_ = model;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp219_ = _tmp218_->is_selected;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (_tmp219_) {
#line 1759 "chess-view.c"
					cairo_surface_t* _tmp220_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp220_ = self->priv->selected_model_surface;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp217_ = _tmp220_;
#line 1765 "chess-view.c"
				} else {
					cairo_surface_t* _tmp221_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp221_ = self->priv->model_surface;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp217_ = _tmp221_;
#line 1772 "chess-view.c"
				}
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp223_ = model;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp224_ = _tmp223_->is_selected;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (_tmp224_) {
#line 1780 "chess-view.c"
					gint _tmp225_ = 0;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp225_ = self->priv->selected_square_size;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp222_ = _tmp225_;
#line 1786 "chess-view.c"
				} else {
					gint _tmp226_ = 0;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp226_ = self->priv->square_size;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp222_ = _tmp226_;
#line 1793 "chess-view.c"
				}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp229_ = model;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp230_ = _tmp229_->under_threat;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (_tmp230_) {
#line 1801 "chess-view.c"
					ChessScene* _tmp231_ = NULL;
					ChessScene* _tmp232_ = NULL;
					gboolean _tmp233_ = FALSE;
					gboolean _tmp234_ = FALSE;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp231_ = chess_view_get_scene (self);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp232_ = _tmp231_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp233_ = chess_scene_get_show_move_hints (_tmp232_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp234_ = _tmp233_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp228_ = _tmp234_;
#line 1816 "chess-view.c"
				} else {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp228_ = FALSE;
#line 1820 "chess-view.c"
				}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (_tmp228_) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp227_ = 0.8;
#line 1826 "chess-view.c"
				} else {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp227_ = 1.0;
#line 1830 "chess-view.c"
				}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp235_ = c;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp236_ = model;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp237_ = _tmp236_->piece;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				chess_view_draw_piece (self, _tmp235_, _tmp217_, _tmp222_, _tmp237_, _tmp227_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp238_ = c;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				cairo_restore (_tmp238_);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_g_object_unref0 (model);
#line 1846 "chess-view.c"
			}
		}
	}
	{
		gint rank = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		rank = 0;
#line 1854 "chess-view.c"
		{
			gboolean _tmp239_ = FALSE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			_tmp239_ = TRUE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
			while (TRUE) {
#line 1861 "chess-view.c"
				gint _tmp241_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (!_tmp239_) {
#line 1865 "chess-view.c"
					gint _tmp240_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					_tmp240_ = rank;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					rank = _tmp240_ + 1;
#line 1871 "chess-view.c"
				}
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp239_ = FALSE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				_tmp241_ = rank;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
				if (!(_tmp241_ < 8)) {
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					break;
#line 1881 "chess-view.c"
				}
				{
					gint file = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
					file = 0;
#line 1887 "chess-view.c"
					{
						gboolean _tmp242_ = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						_tmp242_ = TRUE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
						while (TRUE) {
#line 1894 "chess-view.c"
							gint _tmp244_ = 0;
							gboolean _tmp245_ = FALSE;
							ChessScene* _tmp246_ = NULL;
							ChessScene* _tmp247_ = NULL;
							gboolean _tmp248_ = FALSE;
							gboolean _tmp249_ = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (!_tmp242_) {
#line 1903 "chess-view.c"
								gint _tmp243_ = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp243_ = file;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								file = _tmp243_ + 1;
#line 1909 "chess-view.c"
							}
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp242_ = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp244_ = file;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (!(_tmp244_ < 8)) {
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								break;
#line 1919 "chess-view.c"
							}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp246_ = chess_view_get_scene (self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp247_ = _tmp246_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp248_ = chess_scene_get_show_move_hints (_tmp247_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							_tmp249_ = _tmp248_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (_tmp249_) {
#line 1931 "chess-view.c"
								ChessScene* _tmp250_ = NULL;
								ChessScene* _tmp251_ = NULL;
								gint _tmp252_ = 0;
								gint _tmp253_ = 0;
								gboolean _tmp254_ = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp250_ = chess_view_get_scene (self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp251_ = _tmp250_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp252_ = rank;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp253_ = file;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp254_ = chess_scene_can_move (_tmp251_, _tmp252_, _tmp253_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp245_ = _tmp254_;
#line 1949 "chess-view.c"
							} else {
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp245_ = FALSE;
#line 1953 "chess-view.c"
							}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
							if (_tmp245_) {
#line 1957 "chess-view.c"
								cairo_t* _tmp255_ = NULL;
								cairo_t* _tmp256_ = NULL;
								gint _tmp257_ = 0;
								gint _tmp258_ = 0;
								gint _tmp259_ = 0;
								gint _tmp260_ = 0;
								cairo_t* _tmp261_ = NULL;
								gint _tmp262_ = 0;
								gint _tmp263_ = 0;
								cairo_t* _tmp264_ = NULL;
								ChessScene* _tmp265_ = NULL;
								ChessScene* _tmp266_ = NULL;
								gdouble _tmp267_ = 0.0;
								gdouble _tmp268_ = 0.0;
								cairo_t* _tmp269_ = NULL;
								cairo_surface_t* _tmp270_ = NULL;
								gint _tmp271_ = 0;
								ChessScene* _tmp272_ = NULL;
								ChessScene* _tmp273_ = NULL;
								ChessPiece* _tmp274_ = NULL;
								ChessPiece* _tmp275_ = NULL;
								cairo_t* _tmp276_ = NULL;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp255_ = c;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_save (_tmp255_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp256_ = c;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp257_ = file;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp258_ = self->priv->square_size;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp259_ = rank;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp260_ = self->priv->square_size;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_translate (_tmp256_, (gdouble) ((_tmp257_ - 4) * _tmp258_), (gdouble) ((3 - _tmp259_) * _tmp260_));
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp261_ = c;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp262_ = self->priv->square_size;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp263_ = self->priv->square_size;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_translate (_tmp261_, (gdouble) (_tmp262_ / 2), (gdouble) (_tmp263_ / 2));
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp264_ = c;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp265_ = chess_view_get_scene (self);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp266_ = _tmp265_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp267_ = chess_scene_get_board_angle (_tmp266_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp268_ = _tmp267_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_rotate (_tmp264_, ((-G_PI) * _tmp268_) / 180.0);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp269_ = c;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp270_ = self->priv->model_surface;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp271_ = self->priv->square_size;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp272_ = chess_view_get_scene (self);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp273_ = _tmp272_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp274_ = chess_scene_get_selected_piece (_tmp273_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp275_ = _tmp274_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								chess_view_draw_piece (self, _tmp269_, _tmp270_, _tmp271_, _tmp275_, 0.1);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_g_object_unref0 (_tmp275_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								_tmp276_ = c;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
								cairo_restore (_tmp276_);
#line 2038 "chess-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	result = TRUE;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return result;
#line 2050 "chess-view.c"
}


static void chess_view_draw_piece (ChessView* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha) {
	cairo_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint offset = 0;
	ChessPiece* _tmp3_ = NULL;
	PieceType _tmp4_ = 0;
	ChessPiece* _tmp5_ = NULL;
	Color _tmp6_ = 0;
	Color _tmp7_ = 0;
	cairo_t* _tmp9_ = NULL;
	cairo_surface_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	cairo_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c != NULL);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (surface != NULL);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (piece != NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = c;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp1_ = size;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = size;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_translate (_tmp0_, (gdouble) ((-_tmp1_) / 2), (gdouble) ((-_tmp2_) / 2));
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp3_ = piece;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp4_ = _tmp3_->type;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	offset = (gint) _tmp4_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp5_ = piece;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp6_ = chess_piece_get_color (_tmp5_);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp7_ = _tmp6_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp7_ == COLOR_BLACK) {
#line 2104 "chess-view.c"
		gint _tmp8_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp8_ = offset;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		offset = _tmp8_ + 6;
#line 2110 "chess-view.c"
	}
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp9_ = c;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp10_ = surface;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp11_ = offset;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp12_ = size;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_set_source_surface (_tmp9_, _tmp10_, (gdouble) ((-_tmp11_) * _tmp12_), (gdouble) 0);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp13_ = c;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp14_ = size;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp15_ = size;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_rectangle (_tmp13_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp14_, (gdouble) _tmp15_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp16_ = c;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_clip (_tmp16_);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp17_ = c;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp18_ = alpha;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_paint_with_alpha (_tmp17_, _tmp18_);
#line 2140 "chess-view.c"
}


static gboolean chess_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	ChessScene* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	gint file = 0;
	GdkEventButton* _tmp14_ = NULL;
	gdouble _tmp15_ = 0.0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gdouble _tmp19_ = 0.0;
	gint rank = 0;
	GdkEventButton* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gdouble _tmp25_ = 0.0;
	ChessScene* _tmp26_ = NULL;
	ChessScene* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	ChessScene* _tmp39_ = NULL;
	ChessScene* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self = (ChessView*) base;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = chess_view_get_scene (self);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp3_ = _tmp2_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp4_ = chess_scene_get_game (_tmp3_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp5_ = _tmp4_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp5_ == NULL) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp1_ = TRUE;
#line 2195 "chess-view.c"
	} else {
		GdkEventButton* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp6_ = event;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp7_ = _tmp6_->button;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp1_ = _tmp7_ != ((guint) 1);
#line 2205 "chess-view.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp1_) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp0_ = TRUE;
#line 2211 "chess-view.c"
	} else {
		ChessScene* _tmp8_ = NULL;
		ChessScene* _tmp9_ = NULL;
		ChessGame* _tmp10_ = NULL;
		ChessGame* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp8_ = chess_view_get_scene (self);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp9_ = _tmp8_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp10_ = chess_scene_get_game (_tmp9_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp11_ = _tmp10_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp12_ = chess_game_get_should_show_paused_overlay (_tmp11_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp13_ = _tmp12_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp0_ = _tmp13_;
#line 2233 "chess-view.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp0_) {
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		result = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		return result;
#line 2241 "chess-view.c"
	}
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp14_ = event;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp15_ = _tmp14_->x;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp16_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp17_ = self->priv->square_size;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp18_ = self->priv->square_size;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp19_ = floor (((_tmp15_ - (0.5 * _tmp16_)) + (_tmp17_ * 4)) / _tmp18_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	file = (gint) _tmp19_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp20_ = event;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp21_ = _tmp20_->y;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp22_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp23_ = self->priv->square_size;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp24_ = self->priv->square_size;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp25_ = floor (((_tmp21_ - (0.5 * _tmp22_)) + (_tmp23_ * 4)) / _tmp24_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	rank = 7 - ((gint) _tmp25_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp26_ = chess_view_get_scene (self);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp27_ = _tmp26_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp28_ = chess_scene_get_board_angle (_tmp27_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp29_ = _tmp28_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp29_ == 180.0) {
#line 2281 "chess-view.c"
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp30_ = rank;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		rank = 7 - _tmp30_;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp31_ = file;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		file = 7 - _tmp31_;
#line 2292 "chess-view.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp35_ = file;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp35_ < 0) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp34_ = TRUE;
#line 2300 "chess-view.c"
	} else {
		gint _tmp36_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp36_ = file;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp34_ = _tmp36_ >= 8;
#line 2307 "chess-view.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp34_) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp33_ = TRUE;
#line 2313 "chess-view.c"
	} else {
		gint _tmp37_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp37_ = rank;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp33_ = _tmp37_ < 0;
#line 2320 "chess-view.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp33_) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp32_ = TRUE;
#line 2326 "chess-view.c"
	} else {
		gint _tmp38_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp38_ = rank;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		_tmp32_ = _tmp38_ >= 8;
#line 2333 "chess-view.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	if (_tmp32_) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		result = FALSE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		return result;
#line 2341 "chess-view.c"
	}
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp39_ = chess_view_get_scene (self);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp40_ = _tmp39_;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp41_ = file;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp42_ = rank;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_scene_select_square (_tmp40_, _tmp41_, _tmp42_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	result = TRUE;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return result;
#line 2357 "chess-view.c"
}


static void chess_view_scene_changed_cb (ChessView* self, ChessScene* scene) {
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (scene != NULL);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 2368 "chess-view.c"
}


void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* text = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp8_ = NULL;
	cairo_text_extents_t _tmp9_ = {0};
	cairo_t* _tmp10_ = NULL;
	cairo_text_extents_t _tmp11_ = {0};
	gdouble _tmp12_ = 0.0;
	cairo_text_extents_t _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (c != NULL);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = c;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_save (_tmp0_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp1_ = c;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_set_source_rgba (_tmp1_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = c;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_paint (_tmp2_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp3_ = c;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_select_font_face (_tmp3_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp4_ = c;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_set_font_size (_tmp4_, _tmp5_ * 0.125);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp6_ = _ ("Paused");
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	text = _tmp7_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp8_ = c;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_text_extents (_tmp8_, text, &_tmp9_);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	extents = _tmp9_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp10_ = c;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp11_ = extents;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp12_ = _tmp11_.width;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp13_ = extents;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp14_ = _tmp13_.height;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_move_to (_tmp10_, (-_tmp12_) / 2.0, _tmp14_ / 2.0);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp15_ = c;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_set_source_rgb (_tmp15_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp16_ = c;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_show_text (_tmp16_, text);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp17_ = c;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	cairo_restore (_tmp17_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_g_free0 (text);
#line 2457 "chess-view.c"
}


ChessScene* chess_view_get_scene (ChessView* self) {
	ChessScene* result;
	ChessScene* _tmp0_ = NULL;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = self->priv->_scene;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	result = _tmp0_;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return result;
#line 2472 "chess-view.c"
}


static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_scene_changed_cb ((ChessView*) self, _sender);
#line 2479 "chess-view.c"
}


void chess_view_set_scene (ChessView* self, ChessScene* value) {
	ChessScene* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	ChessScene* _tmp2_ = NULL;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = value;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_g_object_unref0 (self->priv->_scene);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->_scene = _tmp1_;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp2_ = self->priv->_scene;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _chess_view_scene_changed_cb_chess_scene_changed, self, 0);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_object_notify ((GObject *) self, "scene");
#line 2505 "chess-view.c"
}


static gdouble chess_view_get_border_size (ChessView* self) {
	gdouble result;
	gint _tmp0_ = 0;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = self->priv->square_size;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	result = (gdouble) (_tmp0_ / 2);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	return result;
#line 2520 "chess-view.c"
}


static void chess_view_class_init (ChessViewClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	chess_view_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_type_class_add_private (klass, sizeof (ChessViewPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	((GtkWidgetClass *) klass)->configure_event = chess_view_real_configure_event;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	((GtkWidgetClass *) klass)->draw = chess_view_real_draw;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = chess_view_real_button_press_event;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view_get_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_view_set_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_view_finalize;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_VIEW_SCENE, g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2543 "chess-view.c"
}


static void chess_view_instance_init (ChessView * self) {
	gchar* _tmp0_ = NULL;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv = CHESS_VIEW_GET_PRIVATE (self);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->border = 6;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_tmp0_ = g_strdup ("");
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self->priv->loaded_theme_name = _tmp0_;
#line 2557 "chess-view.c"
}


static void chess_view_finalize (GObject* obj) {
	ChessView * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW, ChessView);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->model_surface);
#line 18 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_g_free0 (self->priv->loaded_theme_name);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	_g_object_unref0 (self->priv->_scene);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	G_OBJECT_CLASS (chess_view_parent_class)->finalize (obj);
#line 2575 "chess-view.c"
}


GType chess_view_get_type (void) {
	static volatile gsize chess_view_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView), 0, (GInstanceInitFunc) chess_view_instance_init, NULL };
		GType chess_view_type_id;
		chess_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "ChessView", &g_define_type_info, 0);
		g_once_init_leave (&chess_view_type_id__volatile, chess_view_type_id);
	}
	return chess_view_type_id__volatile;
}


static void _vala_chess_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		case CHESS_VIEW_SCENE:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		g_value_set_object (value, chess_view_get_scene (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		break;
#line 2602 "chess-view.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		break;
#line 2608 "chess-view.c"
	}
}


static void _vala_chess_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		case CHESS_VIEW_SCENE:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		chess_view_set_scene (self, g_value_get_object (value));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		break;
#line 2624 "chess-view.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-view.vala"
		break;
#line 2630 "chess-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



