/* gitg-ext-message-id.c generated by valac 0.28.0.11-bbdd, the Vala compiler
 * generated from gitg-ext-message-id.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GITG_EXT_TYPE_MESSAGE_ID (gitg_ext_message_id_get_type ())
#define GITG_EXT_MESSAGE_ID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId))
#define GITG_EXT_MESSAGE_ID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageIdClass))
#define GITG_EXT_IS_MESSAGE_ID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_TYPE_MESSAGE_ID))
#define GITG_EXT_IS_MESSAGE_ID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_EXT_TYPE_MESSAGE_ID))
#define GITG_EXT_MESSAGE_ID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageIdClass))

typedef struct _GitgExtMessageId GitgExtMessageId;
typedef struct _GitgExtMessageIdClass GitgExtMessageIdClass;
typedef struct _GitgExtMessageIdPrivate GitgExtMessageIdPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgExtMessageId {
	GObject parent_instance;
	GitgExtMessageIdPrivate * priv;
};

struct _GitgExtMessageIdClass {
	GObjectClass parent_class;
};

struct _GitgExtMessageIdPrivate {
	gchar* _object_path;
	gchar* _method;
};


static gpointer gitg_ext_message_id_parent_class = NULL;

GType gitg_ext_message_id_get_type (void) G_GNUC_CONST;
#define GITG_EXT_MESSAGE_ID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageIdPrivate))
enum  {
	GITG_EXT_MESSAGE_ID_DUMMY_PROPERTY,
	GITG_EXT_MESSAGE_ID_OBJECT_PATH,
	GITG_EXT_MESSAGE_ID_METHOD,
	GITG_EXT_MESSAGE_ID_ID
};
guint gitg_ext_message_id_hash (GitgExtMessageId* self);
gchar* gitg_ext_message_id_get_id (GitgExtMessageId* self);
gboolean gitg_ext_message_id_equal (GitgExtMessageId* self, GitgExtMessageId* other);
GitgExtMessageId* gitg_ext_message_id_new (const gchar* object_path, const gchar* method);
GitgExtMessageId* gitg_ext_message_id_construct (GType object_type, const gchar* object_path, const gchar* method);
GitgExtMessageId* gitg_ext_message_id_copy (GitgExtMessageId* self);
const gchar* gitg_ext_message_id_get_object_path (GitgExtMessageId* self);
const gchar* gitg_ext_message_id_get_method (GitgExtMessageId* self);
gboolean gitg_ext_message_id_valid_object_path (const gchar* path);
void gitg_ext_message_id_set_object_path (GitgExtMessageId* self, const gchar* value);
void gitg_ext_message_id_set_method (GitgExtMessageId* self, const gchar* value);
static void gitg_ext_message_id_finalize (GObject* obj);
static void _vala_gitg_ext_message_id_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_ext_message_id_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Message hash.
 *
 * Get a hash for the message identifier suitable for use in a hash table.
 * The hash is simply a string hash of the full id of the message identifier.
 *
 * @return the message identifier hash.
 *
 */
guint gitg_ext_message_id_hash (GitgExtMessageId* self) {
	guint result = 0U;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 74 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = gitg_ext_message_id_get_id (self);
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = _tmp0_;
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp2_ = _tmp1_;
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp3_ = g_str_hash (_tmp2_);
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp4_ = _tmp3_;
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (_tmp2_);
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = _tmp4_;
#line 76 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 117 "gitg-ext-message-id.c"
}


/**
 * Compare two messages for equality.
 *
 * Compare two messages. Two message identifiers are equal when they have
 * the same object path and the same method name.
 *
 * @param other the message identifier to compare to.
 *
 * @return true if the message identifiers are equal, false otherwise.
 *
 */
gboolean gitg_ext_message_id_equal (GitgExtMessageId* self, GitgExtMessageId* other) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GitgExtMessageId* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 90 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (other != NULL, FALSE);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = gitg_ext_message_id_get_id (self);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = _tmp0_;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp2_ = _tmp1_;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp3_ = other;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp4_ = gitg_ext_message_id_get_id (_tmp3_);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp5_ = _tmp4_;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp6_ = _tmp5_;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp7_ = g_strcmp0 (_tmp2_, _tmp6_) == 0;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (_tmp6_);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (_tmp2_);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = _tmp7_;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 170 "gitg-ext-message-id.c"
}


/**
 * Construct message identifier with object path and method.
 *
 * Create a new message identifier object with the given object path and
 * method name.
 *
 * @param object_path the object path
 * @param method the method name
 *
 * @return a new message identifier.
 *
 */
GitgExtMessageId* gitg_ext_message_id_construct (GType object_type, const gchar* object_path, const gchar* method) {
	GitgExtMessageId * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (object_path != NULL, NULL);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = object_path;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = method;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	self = (GitgExtMessageId*) g_object_new (object_type, "object-path", _tmp0_, "method", _tmp1_, NULL);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return self;
#line 202 "gitg-ext-message-id.c"
}


GitgExtMessageId* gitg_ext_message_id_new (const gchar* object_path, const gchar* method) {
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return gitg_ext_message_id_construct (GITG_EXT_TYPE_MESSAGE_ID, object_path, method);
#line 209 "gitg-ext-message-id.c"
}


/**
 * Create a copy of the message identifier.
 *
 * Create an exact copy of the message identifier.
 *
 * @return a new message identifier.
 *
 */
GitgExtMessageId* gitg_ext_message_id_copy (GitgExtMessageId* self) {
	GitgExtMessageId* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GitgExtMessageId* _tmp2_ = NULL;
#line 120 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = self->priv->_object_path;
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = self->priv->_method;
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp2_ = gitg_ext_message_id_new (_tmp0_, _tmp1_);
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = _tmp2_;
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 238 "gitg-ext-message-id.c"
}


/**
 * Check whether an object path is a valid path.
 *
 * Check whether the given path is a valid object path. A valid object path
 * starts with a forward slash, followed by at least one alpha character,
 * or underscore. Further valid characters include alphanumeric characters,
 * underscores or path separators (forward slash).
 *
 * Example: /path/to/object
 *
 * @return true if the specified path is valid, false otherwise
 *
 */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 269 "gitg-ext-message-id.c"
}


gboolean gitg_ext_message_id_valid_object_path (const gchar* path) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	gint i = 0;
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 140 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = path;
#line 140 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	if (_tmp0_ == NULL) {
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		result = FALSE;
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		return result;
#line 289 "gitg-ext-message-id.c"
	}
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = path;
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp2_ = string_get (_tmp1_, (glong) 0);
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	if (_tmp2_ != '/') {
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		result = FALSE;
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		return result;
#line 301 "gitg-ext-message-id.c"
	}
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	i = 0;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	while (TRUE) {
#line 307 "gitg-ext-message-id.c"
		gint _tmp3_ = 0;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar c = '\0';
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gchar _tmp9_ = '\0';
		gchar _tmp10_ = '\0';
		gint _tmp25_ = 0;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp3_ = i;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp4_ = path;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp5_ = strlen (_tmp4_);
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp6_ = _tmp5_;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		if (!(_tmp3_ < _tmp6_)) {
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			break;
#line 330 "gitg-ext-message-id.c"
		}
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp7_ = path;
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp8_ = i;
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		c = _tmp9_;
#line 156 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp10_ = c;
#line 156 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		if (_tmp10_ == '/') {
#line 344 "gitg-ext-message-id.c"
			gint _tmp11_ = 0;
			gboolean _tmp12_ = FALSE;
			gint _tmp13_ = 0;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 158 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp11_ = i;
#line 158 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			i = _tmp11_ + 1;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp13_ = i;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp14_ = path;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp15_ = strlen (_tmp14_);
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp16_ = _tmp15_;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			if (_tmp13_ == _tmp16_) {
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp12_ = TRUE;
#line 367 "gitg-ext-message-id.c"
			} else {
				gboolean _tmp17_ = FALSE;
				gchar _tmp18_ = '\0';
				gboolean _tmp19_ = FALSE;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp18_ = c;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp19_ = g_ascii_isalpha (_tmp18_);
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				if (_tmp19_) {
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
					_tmp17_ = TRUE;
#line 380 "gitg-ext-message-id.c"
				} else {
					gchar _tmp20_ = '\0';
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
					_tmp20_ = c;
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
					_tmp17_ = _tmp20_ == '_';
#line 387 "gitg-ext-message-id.c"
				}
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp12_ = !_tmp17_;
#line 391 "gitg-ext-message-id.c"
			}
#line 160 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			if (_tmp12_) {
#line 162 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				result = FALSE;
#line 162 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				return result;
#line 399 "gitg-ext-message-id.c"
			}
		} else {
			gboolean _tmp21_ = FALSE;
			gchar _tmp22_ = '\0';
			gboolean _tmp23_ = FALSE;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp22_ = c;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			_tmp23_ = g_ascii_isalnum (_tmp22_);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			if (_tmp23_) {
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp21_ = TRUE;
#line 413 "gitg-ext-message-id.c"
			} else {
				gchar _tmp24_ = '\0';
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp24_ = c;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				_tmp21_ = _tmp24_ == '_';
#line 420 "gitg-ext-message-id.c"
			}
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
			if (!_tmp21_) {
#line 167 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				result = FALSE;
#line 167 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
				return result;
#line 428 "gitg-ext-message-id.c"
			}
		}
#line 170 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		_tmp25_ = i;
#line 170 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		i = _tmp25_ + 1;
#line 435 "gitg-ext-message-id.c"
	}
#line 173 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = TRUE;
#line 173 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 441 "gitg-ext-message-id.c"
}


const gchar* gitg_ext_message_id_get_object_path (GitgExtMessageId* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = self->priv->_object_path;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = _tmp0_;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 456 "gitg-ext-message-id.c"
}


void gitg_ext_message_id_set_object_path (GitgExtMessageId* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = value;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (self->priv->_object_path);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	self->priv->_object_path = _tmp1_;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_object_notify ((GObject *) self, "object-path");
#line 475 "gitg-ext-message-id.c"
}


const gchar* gitg_ext_message_id_get_method (GitgExtMessageId* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = self->priv->_method;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = _tmp0_;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 490 "gitg-ext-message-id.c"
}


void gitg_ext_message_id_set_method (GitgExtMessageId* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = value;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (self->priv->_method);
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	self->priv->_method = _tmp1_;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_object_notify ((GObject *) self, "method");
#line 509 "gitg-ext-message-id.c"
}


gchar* gitg_ext_message_id_get_id (GitgExtMessageId* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp0_ = self->priv->_object_path;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp1_ = g_strconcat (_tmp0_, ".", NULL);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp2_ = _tmp1_;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp3_ = self->priv->_method;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_tmp5_ = _tmp4_;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (_tmp2_);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	result = _tmp5_;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	return result;
#line 541 "gitg-ext-message-id.c"
}


static void gitg_ext_message_id_class_init (GitgExtMessageIdClass * klass) {
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	gitg_ext_message_id_parent_class = g_type_class_peek_parent (klass);
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_type_class_add_private (klass, sizeof (GitgExtMessageIdPrivate));
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ext_message_id_get_property;
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ext_message_id_set_property;
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_ext_message_id_finalize;
#line 556 "gitg-ext-message-id.c"
	/**
	 * Message object path.
	 */
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_EXT_MESSAGE_ID_OBJECT_PATH, g_param_spec_string ("object-path", "object-path", "object-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 562 "gitg-ext-message-id.c"
	/**
	 * Message method.
	 */
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_EXT_MESSAGE_ID_METHOD, g_param_spec_string ("method", "method", "method", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 568 "gitg-ext-message-id.c"
	/**
	 * Full id of the message.
	 *
	 * Get the full id of the message identifier. The full id is simply
	 * <path>.<method>
	 *
	 */
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_EXT_MESSAGE_ID_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 578 "gitg-ext-message-id.c"
}


static void gitg_ext_message_id_instance_init (GitgExtMessageId * self) {
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	self->priv = GITG_EXT_MESSAGE_ID_GET_PRIVATE (self);
#line 585 "gitg-ext-message-id.c"
}


static void gitg_ext_message_id_finalize (GObject* obj) {
	GitgExtMessageId * self;
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (self->priv->_object_path);
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	_g_free0 (self->priv->_method);
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	G_OBJECT_CLASS (gitg_ext_message_id_parent_class)->finalize (obj);
#line 599 "gitg-ext-message-id.c"
}


/**
 * Message identifier object.
 *
 * The message identifier object is used to identify messages sent over the
 * MessageBus. The message identifier contains an object path and a method.
 * Both are simple strings and combined describe the location of a message as
 * a kind of method on an object.
 *
 * Valid object paths start with a forward slash and further path elements are
 * seperated by more forward slashes. The first element needs to start with
 * an alpha character (or underscore) while further characters can be
 * alpha numeric or underscores. An example of a valid path is:
 *
 * /path/to/object
 *
 * Method names on the other hand do not have any restrictions.
 *
 */
GType gitg_ext_message_id_get_type (void) {
	static volatile gsize gitg_ext_message_id_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_ext_message_id_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgExtMessageIdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_message_id_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgExtMessageId), 0, (GInstanceInitFunc) gitg_ext_message_id_instance_init, NULL };
		GType gitg_ext_message_id_type_id;
		gitg_ext_message_id_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgExtMessageId", &g_define_type_info, 0);
		g_once_init_leave (&gitg_ext_message_id_type_id__volatile, gitg_ext_message_id_type_id);
	}
	return gitg_ext_message_id_type_id__volatile;
}


static void _vala_gitg_ext_message_id_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgExtMessageId * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId);
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	switch (property_id) {
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		case GITG_EXT_MESSAGE_ID_OBJECT_PATH:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		g_value_set_string (value, gitg_ext_message_id_get_object_path (self));
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		case GITG_EXT_MESSAGE_ID_METHOD:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		g_value_set_string (value, gitg_ext_message_id_get_method (self));
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		case GITG_EXT_MESSAGE_ID_ID:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		g_value_take_string (value, gitg_ext_message_id_get_id (self));
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 656 "gitg-ext-message-id.c"
		default:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 662 "gitg-ext-message-id.c"
	}
}


static void _vala_gitg_ext_message_id_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgExtMessageId * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId);
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
	switch (property_id) {
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		case GITG_EXT_MESSAGE_ID_OBJECT_PATH:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		gitg_ext_message_id_set_object_path (self, g_value_get_string (value));
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		case GITG_EXT_MESSAGE_ID_METHOD:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		gitg_ext_message_id_set_method (self, g_value_get_string (value));
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 684 "gitg-ext-message-id.c"
		default:
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/gregier/hacking/gnome/gitg/libgitg-ext/gitg-ext-message-id.vala"
		break;
#line 690 "gitg-ext-message-id.c"
	}
}



