/* gitg-remote.c generated by valac 0.28.0.11-bbdd, the Vala compiler
 * generated from gitg-remote.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define GITG_TYPE_REMOTE_STATE (gitg_remote_state_get_type ())

#define GITG_TYPE_REMOTE (gitg_remote_get_type ())
#define GITG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE, GitgRemote))
#define GITG_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE, GitgRemoteClass))
#define GITG_IS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE))
#define GITG_IS_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE))
#define GITG_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE, GitgRemoteClass))

typedef struct _GitgRemote GitgRemote;
typedef struct _GitgRemoteClass GitgRemoteClass;
typedef struct _GitgRemotePrivate GitgRemotePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
typedef struct _GitgRemoteConnectData GitgRemoteConnectData;
typedef struct _GitgRemoteDisconnectData GitgRemoteDisconnectData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;
typedef struct _GitgRemoteDownloadInternData GitgRemoteDownloadInternData;
typedef struct _GitgRemoteDownloadData GitgRemoteDownloadData;
typedef struct _GitgRemoteFetchData GitgRemoteFetchData;

typedef enum  {
	GITG_REMOTE_STATE_DISCONNECTED,
	GITG_REMOTE_STATE_CONNECTING,
	GITG_REMOTE_STATE_CONNECTED,
	GITG_REMOTE_STATE_TRANSFERRING
} GitgRemoteState;

typedef enum  {
	GITG_REMOTE_ERROR_ALREADY_CONNECTED,
	GITG_REMOTE_ERROR_ALREADY_CONNECTING,
	GITG_REMOTE_ERROR_ALREADY_DISCONNECTED,
	GITG_REMOTE_ERROR_STILL_CONNECTING
} GitgRemoteError;
#define GITG_REMOTE_ERROR gitg_remote_error_quark ()
struct _GitgRemote {
	GgitRemote parent_instance;
	GitgRemotePrivate * priv;
};

struct _GitgRemoteClass {
	GgitRemoteClass parent_class;
};

struct _GitgRemotePrivate {
	GitgRemoteState d_state;
	GError* d_authentication_error;
};

struct _Block13Data {
	int _ref_count_;
	GitgRemote* self;
	GgitDirection direction;
	gpointer _async_data_;
};

typedef void (*GitgAsyncThreadFunc) (void* user_data, GError** error);
struct _GitgRemoteConnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	GgitDirection direction;
	Block13Data* _data13_;
	GgitDirection _tmp0_;
	gboolean _tmp1_;
	GitgRemoteState _tmp2_;
	GitgRemoteState _tmp3_;
	GError* _tmp4_;
	GitgRemoteState _tmp5_;
	GitgRemoteState _tmp6_;
	GError* _tmp7_;
	GError* e;
	gboolean _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _GitgRemoteDisconnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	gboolean _tmp0_;
	GitgRemoteState _tmp1_;
	GitgRemoteState _tmp2_;
	GError* _tmp3_;
	GError* e;
	GError* _tmp4_;
	GError* _tmp5_;
	GError * _inner_error_;
};

struct _Block14Data {
	int _ref_count_;
	GitgRemote* self;
	GgitSignature* signature;
	gchar* message;
	gpointer _async_data_;
};

struct _GitgRemoteDownloadInternData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	GgitSignature* signature;
	gchar* message;
	Block14Data* _data14_;
	GgitSignature* _tmp0_;
	const gchar* _tmp1_;
	gboolean dis;
	gboolean _tmp2_;
	GError* e;
	gboolean _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

struct _GitgRemoteDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	GError * _inner_error_;
};

struct _GitgRemoteFetchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	GgitSignature* signature;
	gchar* message;
	GgitSignature* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_;
};


static gpointer gitg_remote_parent_class = NULL;

GType gitg_remote_state_get_type (void) G_GNUC_CONST;
GQuark gitg_remote_error_quark (void);
GType gitg_remote_get_type (void) G_GNUC_CONST;
#define GITG_REMOTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REMOTE, GitgRemotePrivate))
enum  {
	GITG_REMOTE_DUMMY_PROPERTY,
	GITG_REMOTE_AUTHENTICATION_ERROR,
	GITG_REMOTE_STATE
};
static void gitg_remote_update_state (GitgRemote* self, gboolean force_disconnect);
void gitg_remote_disconnect (GitgRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_disconnect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static void ____lambda38_ (GitgRemote* self, GObject* obj, GAsyncResult* res);
static void _____lambda38__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_remote_set_state (GitgRemote* self, GitgRemoteState value);
static void gitg_remote_connect_data_free (gpointer _data);
void gitg_remote_connect (GitgRemote* self, GgitDirection direction, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_connect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_connect_co (GitgRemoteConnectData* _data_);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
GitgRemoteState gitg_remote_get_state (GitgRemote* self);
void gitg_async_thread (GitgAsyncThreadFunc func, void* func_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_async_thread_finish (GAsyncResult* _res_, GError** error);
static void ____lambda39_ (Block13Data* _data13_, GError** error);
static void _____lambda39__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_remote_connect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_remote_disconnect_data_free (gpointer _data);
static gboolean gitg_remote_disconnect_co (GitgRemoteDisconnectData* _data_);
static void ___lambda37_ (GitgRemote* self, GError** error);
static void ____lambda37__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_remote_disconnect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_remote_download_intern_data_free (gpointer _data);
static void gitg_remote_download_intern (GitgRemote* self, GgitSignature* signature, const gchar* message, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gitg_remote_download_intern_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_download_intern_co (GitgRemoteDownloadInternData* _data_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void gitg_remote_download_intern_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void ___lambda40_ (Block14Data* _data14_, GError** error);
static void ____lambda40__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_remote_download_data_free (gpointer _data);
void gitg_remote_download (GitgRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_download_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_download_co (GitgRemoteDownloadData* _data_);
static void gitg_remote_download_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_remote_fetch_data_free (gpointer _data);
void gitg_remote_fetch (GitgRemote* self, GgitSignature* signature, const gchar* message, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_fetch_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_fetch_co (GitgRemoteFetchData* _data_);
static void gitg_remote_fetch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GitgRemote* gitg_remote_new (void);
GitgRemote* gitg_remote_construct (GType object_type);
GError* gitg_remote_get_authentication_error (GitgRemote* self);
static void gitg_remote_finalize (GObject* obj);
static void _vala_gitg_remote_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_remote_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType gitg_remote_state_get_type (void) {
	static volatile gsize gitg_remote_state_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_remote_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_REMOTE_STATE_DISCONNECTED, "GITG_REMOTE_STATE_DISCONNECTED", "disconnected"}, {GITG_REMOTE_STATE_CONNECTING, "GITG_REMOTE_STATE_CONNECTING", "connecting"}, {GITG_REMOTE_STATE_CONNECTED, "GITG_REMOTE_STATE_CONNECTED", "connected"}, {GITG_REMOTE_STATE_TRANSFERRING, "GITG_REMOTE_STATE_TRANSFERRING", "transferring"}, {0, NULL, NULL}};
		GType gitg_remote_state_type_id;
		gitg_remote_state_type_id = g_enum_register_static ("GitgRemoteState", values);
		g_once_init_leave (&gitg_remote_state_type_id__volatile, gitg_remote_state_type_id);
	}
	return gitg_remote_state_type_id__volatile;
}


GQuark gitg_remote_error_quark (void) {
	return g_quark_from_static_string ("gitg_remote_error-quark");
}


static void ____lambda38_ (GitgRemote* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (res != NULL);
#line 270 "gitg-remote.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 71 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = res;
#line 71 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_disconnect_finish (self, _tmp0_, &_inner_error_);
#line 71 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "gitg-remote.c"
			goto __catch53_g_error;
		}
	}
	goto __finally53;
	__catch53_g_error:
	{
#line 69 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_clear_error (&_inner_error_);
#line 69 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_inner_error_ = NULL;
#line 290 "gitg-remote.c"
	}
	__finally53:
#line 69 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 69 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 69 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_clear_error (&_inner_error_);
#line 69 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 301 "gitg-remote.c"
	}
}


static void _____lambda38__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	____lambda38_ ((GitgRemote*) self, source_object, res);
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_unref (self);
#line 311 "gitg-remote.c"
}


static void gitg_remote_update_state (GitgRemote* self, gboolean force_disconnect) {
	gboolean _tmp0_ = FALSE;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = ggit_remote_get_connected ((GgitRemote*) self);
#line 64 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_) {
#line 323 "gitg-remote.c"
		gboolean _tmp1_ = FALSE;
#line 66 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = force_disconnect;
#line 66 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_tmp1_) {
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			gitg_remote_disconnect (self, _____lambda38__gasync_ready_callback, g_object_ref (self));
#line 331 "gitg-remote.c"
		} else {
#line 77 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_state (self, GITG_REMOTE_STATE_CONNECTED);
#line 78 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_g_error_free0 (self->priv->d_authentication_error);
#line 78 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			self->priv->d_authentication_error = NULL;
#line 339 "gitg-remote.c"
		}
	} else {
#line 83 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_set_state (self, GITG_REMOTE_STATE_DISCONNECTED);
#line 344 "gitg-remote.c"
	}
}


static void gitg_remote_connect_data_free (gpointer _data) {
	GitgRemoteConnectData* _data_;
	_data_ = _data;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteConnectData, _data_);
#line 356 "gitg-remote.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return self ? g_object_ref (self) : NULL;
#line 363 "gitg-remote.c"
}


void gitg_remote_connect (GitgRemote* self, GgitDirection direction, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteConnectData* _data_;
	GitgRemote* _tmp0_ = NULL;
	GgitDirection _tmp1_ = 0;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteConnectData);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_connect);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_connect_data_free);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = direction;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->direction = _tmp1_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_connect_co (_data_);
#line 387 "gitg-remote.c"
}


void gitg_remote_connect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteConnectData* _data_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 397 "gitg-remote.c"
	}
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 401 "gitg-remote.c"
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return _data13_;
#line 410 "gitg-remote.c"
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 419 "gitg-remote.c"
		GitgRemote* self;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		self = _data13_->self;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (self);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_slice_free (Block13Data, _data13_);
#line 427 "gitg-remote.c"
	}
}


static void ____lambda39_ (Block13Data* _data13_, GError** error) {
	GitgRemote* self;
	GgitDirection _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	self = _data13_->self;
#line 110 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _data13_->direction;
#line 110 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	ggit_remote_connect (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), _tmp0_, &_inner_error_);
#line 110 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 110 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 110 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 448 "gitg-remote.c"
	}
}


static void _____lambda39__gitg_async_thread_func (gpointer self, GError** error) {
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	____lambda39_ (self, error);
#line 456 "gitg-remote.c"
}


static void gitg_remote_connect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteConnectData* _data_;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_connect_co (_data_);
#line 470 "gitg-remote.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return self ? g_error_copy (self) : NULL;
#line 477 "gitg-remote.c"
}


static gboolean gitg_remote_connect_co (GitgRemoteConnectData* _data_) {
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 486 "gitg-remote.c"
		goto _state_0;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 490 "gitg-remote.c"
		goto _state_1;
		default:
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 495 "gitg-remote.c"
	}
	_state_0:
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data13_ = g_slice_new0 (Block13Data);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data13_->_ref_count_ = 1;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data13_->self = g_object_ref (_data_->self);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = 0;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->direction;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data13_->direction = _data_->_tmp0_;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data13_->_async_data_ = _data_;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = FALSE;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = ggit_remote_get_connected ((GgitRemote*) _data_->self);
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_data_->_tmp1_) {
#line 91 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = 0;
#line 91 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = gitg_remote_get_state (_data_->self);
#line 91 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = 0;
#line 91 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 91 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp3_ != GITG_REMOTE_STATE_CONNECTED) {
#line 93 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_CONNECTED);
#line 530 "gitg-remote.c"
		}
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_CONNECTED, "already connected");
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp4_;
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		block13_data_unref (_data_->_data13_);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_data13_ = NULL;
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 550 "gitg-remote.c"
		} else {
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 554 "gitg-remote.c"
		}
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 560 "gitg-remote.c"
	} else {
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = 0;
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = gitg_remote_get_state (_data_->self);
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp6_ = 0;
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp6_ == GITG_REMOTE_STATE_CONNECTING) {
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp7_ = NULL;
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp7_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_CONNECTING, "already connecting");
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_inner_error_ = _data_->_tmp7_;
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_error_free (_data_->_inner_error_);
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			block13_data_unref (_data_->_data13_);
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_data13_ = NULL;
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			if (_data_->_state_ == 0) {
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 590 "gitg-remote.c"
			} else {
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 594 "gitg-remote.c"
			}
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_object_unref (_data_->_async_result);
#line 100 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 600 "gitg-remote.c"
		}
	}
#line 103 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_CONNECTING);
#line 105 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	while (TRUE) {
#line 607 "gitg-remote.c"
		{
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_state_ = 1;
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			gitg_async_thread (_____lambda39__gitg_async_thread_func, _data_->_data13_, gitg_remote_connect_ready, _data_);
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 615 "gitg-remote.c"
			_state_1:
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 109 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 621 "gitg-remote.c"
				goto __catch54_g_error;
			}
		}
		goto __finally54;
		__catch54_g_error:
		{
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->e = _data_->_inner_error_;
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_inner_error_ = NULL;
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp9_ = NULL;
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp9_ = _data_->e;
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp10_ = NULL;
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp10_ = _data_->_tmp9_->message;
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			if (g_strcmp0 (_data_->_tmp10_, "Unexpected HTTP status code: 401") == 0) {
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp8_ = TRUE;
#line 644 "gitg-remote.c"
			} else {
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp11_ = NULL;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp11_ = _data_->e;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp12_ = NULL;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp12_ = _data_->_tmp11_->message;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp8_ = g_strcmp0 (_data_->_tmp12_, "error authenticating: Username/PublicKey combination invalid") == 0;
#line 656 "gitg-remote.c"
			}
#line 118 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			if (_data_->_tmp8_) {
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp13_ = NULL;
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp13_ = _data_->e;
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp14_ = NULL;
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_g_error_free0 (_data_->self->priv->d_authentication_error);
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->self->priv->d_authentication_error = _data_->_tmp14_;
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_g_error_free0 (_data_->e);
#line 122 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				continue;
#line 676 "gitg-remote.c"
			} else {
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				gitg_remote_update_state (_data_->self, FALSE);
#line 127 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp15_ = NULL;
#line 127 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp15_ = _data_->e;
#line 127 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp16_ = NULL;
#line 127 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 127 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_data_->_inner_error_ = _data_->_tmp16_;
#line 127 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				_g_error_free0 (_data_->e);
#line 692 "gitg-remote.c"
				goto __finally54;
			}
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_g_error_free0 (_data_->e);
#line 697 "gitg-remote.c"
		}
		__finally54:
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_error_free (_data_->_inner_error_);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			block13_data_unref (_data_->_data13_);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_data13_ = NULL;
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			if (_data_->_state_ == 0) {
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 714 "gitg-remote.c"
			} else {
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 718 "gitg-remote.c"
			}
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_object_unref (_data_->_async_result);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 724 "gitg-remote.c"
		}
#line 131 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (_data_->self->priv->d_authentication_error);
#line 131 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->self->priv->d_authentication_error = NULL;
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		break;
#line 732 "gitg-remote.c"
	}
#line 135 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_state (_data_->self, FALSE);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	block13_data_unref (_data_->_data13_);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data13_ = NULL;
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 744 "gitg-remote.c"
	} else {
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 748 "gitg-remote.c"
	}
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 87 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 754 "gitg-remote.c"
}


static void gitg_remote_disconnect_data_free (gpointer _data) {
	GitgRemoteDisconnectData* _data_;
	_data_ = _data;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteDisconnectData, _data_);
#line 765 "gitg-remote.c"
}


void gitg_remote_disconnect (GitgRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteDisconnectData* _data_;
	GitgRemote* _tmp0_ = NULL;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteDisconnectData);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_disconnect);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_disconnect_data_free);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_disconnect_co (_data_);
#line 784 "gitg-remote.c"
}


void gitg_remote_disconnect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteDisconnectData* _data_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 794 "gitg-remote.c"
	}
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 798 "gitg-remote.c"
}


static void ___lambda37_ (GitgRemote* self, GError** error) {
#line 153 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	ggit_remote_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote));
#line 805 "gitg-remote.c"
}


static void ____lambda37__gitg_async_thread_func (gpointer self, GError** error) {
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	___lambda37_ ((GitgRemote*) self, error);
#line 812 "gitg-remote.c"
}


static void gitg_remote_disconnect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteDisconnectData* _data_;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_disconnect_co (_data_);
#line 826 "gitg-remote.c"
}


static gboolean gitg_remote_disconnect_co (GitgRemoteDisconnectData* _data_) {
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 835 "gitg-remote.c"
		goto _state_0;
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 839 "gitg-remote.c"
		goto _state_1;
		default:
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 844 "gitg-remote.c"
	}
	_state_0:
#line 140 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = FALSE;
#line 140 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = ggit_remote_get_connected ((GgitRemote*) _data_->self);
#line 140 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (!_data_->_tmp0_) {
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp1_ = 0;
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp1_ = gitg_remote_get_state (_data_->self);
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = 0;
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp2_ != GITG_REMOTE_STATE_DISCONNECTED) {
#line 144 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_DISCONNECTED);
#line 865 "gitg-remote.c"
		}
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = NULL;
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_DISCONNECTED, "already disconnected");
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 881 "gitg-remote.c"
		} else {
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 885 "gitg-remote.c"
		}
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 147 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 891 "gitg-remote.c"
	}
	{
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_state_ = 1;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread (____lambda37__gitg_async_thread_func, _data_->self, gitg_remote_disconnect_ready, _data_);
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 900 "gitg-remote.c"
		_state_1:
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 906 "gitg-remote.c"
			goto __catch55_g_error;
		}
	}
	goto __finally55;
	__catch55_g_error:
	{
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->e = _data_->_inner_error_;
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = NULL;
#line 158 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_update_state (_data_->self, FALSE);
#line 159 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 159 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = _data_->e;
#line 159 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = NULL;
#line 159 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
#line 159 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 159 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (_data_->e);
#line 931 "gitg-remote.c"
		goto __finally55;
	}
	__finally55:
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 945 "gitg-remote.c"
		} else {
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 949 "gitg-remote.c"
		}
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 955 "gitg-remote.c"
	}
#line 162 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_state (_data_->self, FALSE);
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 963 "gitg-remote.c"
	} else {
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 967 "gitg-remote.c"
	}
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 973 "gitg-remote.c"
}


static void gitg_remote_download_intern_data_free (gpointer _data) {
	GitgRemoteDownloadInternData* _data_;
	_data_ = _data;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteDownloadInternData, _data_);
#line 984 "gitg-remote.c"
}


static void gitg_remote_download_intern (GitgRemote* self, GgitSignature* signature, const gchar* message, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteDownloadInternData* _data_;
	GitgRemote* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GgitSignature* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteDownloadInternData);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_download_intern);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_download_intern_data_free);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = signature;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->signature);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->signature = _tmp2_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = message;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->message);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->message = _tmp4_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_co (_data_);
#line 1023 "gitg-remote.c"
}


static void gitg_remote_download_intern_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteDownloadInternData* _data_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 1033 "gitg-remote.c"
	}
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1037 "gitg-remote.c"
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return _data14_;
#line 1046 "gitg-remote.c"
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 1055 "gitg-remote.c"
		GitgRemote* self;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		self = _data14_->self;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (_data14_->signature);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_free0 (_data14_->message);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (self);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_slice_free (Block14Data, _data14_);
#line 1067 "gitg-remote.c"
	}
}


static void gitg_remote_download_intern_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteDownloadInternData* _data_;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_co (_data_);
#line 1082 "gitg-remote.c"
}


static void ___lambda40_ (Block14Data* _data14_, GError** error) {
	GitgRemote* self;
	GgitSignature* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	self = _data14_->self;
#line 180 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	ggit_remote_download (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), NULL, &_inner_error_);
#line 180 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 180 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 1100 "gitg-remote.c"
	}
#line 182 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _data14_->signature;
#line 182 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != NULL) {
#line 1106 "gitg-remote.c"
		GgitSignature* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 184 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = _data14_->signature;
#line 184 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = _data14_->message;
#line 184 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		ggit_remote_update_tips (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), _tmp1_, _tmp2_, &_inner_error_);
#line 184 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 184 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_propagate_error (error, _inner_error_);
#line 184 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			return;
#line 1121 "gitg-remote.c"
		}
	}
}


static void ____lambda40__gitg_async_thread_func (gpointer self, GError** error) {
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	___lambda40_ (self, error);
#line 1130 "gitg-remote.c"
}


static gboolean gitg_remote_download_intern_co (GitgRemoteDownloadInternData* _data_) {
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1139 "gitg-remote.c"
		goto _state_0;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1143 "gitg-remote.c"
		goto _state_1;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 2:
#line 1147 "gitg-remote.c"
		goto _state_2;
		default:
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1152 "gitg-remote.c"
	}
	_state_0:
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_ = g_slice_new0 (Block14Data);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_->_ref_count_ = 1;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_->self = g_object_ref (_data_->self);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = NULL;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->signature;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->_data14_->signature);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_->signature = _data_->_tmp0_;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = NULL;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = _data_->message;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->_data14_->message);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_->message = _data_->_tmp1_;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_->_async_data_ = _data_;
#line 167 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->dis = FALSE;
#line 169 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp2_ = FALSE;
#line 169 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp2_ = ggit_remote_get_connected ((GgitRemote*) _data_->self);
#line 169 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (!_data_->_tmp2_) {
#line 171 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->dis = TRUE;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_state_ = 1;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_connect (_data_->self, GGIT_DIRECTION_FETCH, gitg_remote_download_intern_ready, _data_);
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1195 "gitg-remote.c"
		_state_1:
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_connect_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_error_free (_data_->_inner_error_);
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			block14_data_unref (_data_->_data14_);
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			_data_->_data14_ = NULL;
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			if (_data_->_state_ == 0) {
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1213 "gitg-remote.c"
			} else {
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1217 "gitg-remote.c"
			}
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_object_unref (_data_->_async_result);
#line 172 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 1223 "gitg-remote.c"
		}
	}
#line 175 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_TRANSFERRING);
#line 1228 "gitg-remote.c"
	{
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_state_ = 2;
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread (____lambda40__gitg_async_thread_func, _data_->_data14_, gitg_remote_download_intern_ready, _data_);
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1236 "gitg-remote.c"
		_state_2:
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1242 "gitg-remote.c"
			goto __catch56_g_error;
		}
	}
	goto __finally56;
	__catch56_g_error:
	{
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->e = _data_->_inner_error_;
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = NULL;
#line 190 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = FALSE;
#line 190 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = _data_->dis;
#line 190 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_update_state (_data_->self, _data_->_tmp3_);
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = _data_->e;
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = NULL;
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (_data_->e);
#line 1271 "gitg-remote.c"
		goto __finally56;
	}
	__finally56:
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		block14_data_unref (_data_->_data14_);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_data_->_data14_ = NULL;
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1289 "gitg-remote.c"
		} else {
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1293 "gitg-remote.c"
		}
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1299 "gitg-remote.c"
	}
#line 194 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp6_ = FALSE;
#line 194 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp6_ = _data_->dis;
#line 194 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_state (_data_->self, _data_->_tmp6_);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	block14_data_unref (_data_->_data14_);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_data14_ = NULL;
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1315 "gitg-remote.c"
	} else {
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1319 "gitg-remote.c"
	}
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 165 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1325 "gitg-remote.c"
}


static void gitg_remote_download_data_free (gpointer _data) {
	GitgRemoteDownloadData* _data_;
	_data_ = _data;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteDownloadData, _data_);
#line 1336 "gitg-remote.c"
}


void gitg_remote_download (GitgRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteDownloadData* _data_;
	GitgRemote* _tmp0_ = NULL;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteDownloadData);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_download);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_download_data_free);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_co (_data_);
#line 1355 "gitg-remote.c"
}


void gitg_remote_download_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteDownloadData* _data_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 1365 "gitg-remote.c"
	}
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1369 "gitg-remote.c"
}


static void gitg_remote_download_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteDownloadData* _data_;
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_co (_data_);
#line 1383 "gitg-remote.c"
}


static gboolean gitg_remote_download_co (GitgRemoteDownloadData* _data_) {
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1392 "gitg-remote.c"
		goto _state_0;
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1396 "gitg-remote.c"
		goto _state_1;
		default:
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1401 "gitg-remote.c"
	}
	_state_0:
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_state_ = 1;
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern (_data_->self, NULL, NULL, gitg_remote_download_ready, _data_);
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1410 "gitg-remote.c"
	_state_1:
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1424 "gitg-remote.c"
		} else {
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1428 "gitg-remote.c"
		}
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 199 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1434 "gitg-remote.c"
	}
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1440 "gitg-remote.c"
	} else {
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1444 "gitg-remote.c"
	}
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 197 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1450 "gitg-remote.c"
}


static void gitg_remote_fetch_data_free (gpointer _data) {
	GitgRemoteFetchData* _data_;
	_data_ = _data;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->signature);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->message);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteFetchData, _data_);
#line 1465 "gitg-remote.c"
}


void gitg_remote_fetch (GitgRemote* self, GgitSignature* signature, const gchar* message, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteFetchData* _data_;
	GitgRemote* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GgitSignature* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteFetchData);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_fetch);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_fetch_data_free);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = signature;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->signature);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->signature = _tmp2_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = message;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->message);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->message = _tmp4_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_fetch_co (_data_);
#line 1504 "gitg-remote.c"
}


void gitg_remote_fetch_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteFetchData* _data_;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return;
#line 1514 "gitg-remote.c"
	}
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1518 "gitg-remote.c"
}


static void gitg_remote_fetch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteFetchData* _data_;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_fetch_co (_data_);
#line 1532 "gitg-remote.c"
}


static gboolean gitg_remote_fetch_co (GitgRemoteFetchData* _data_) {
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1541 "gitg-remote.c"
		goto _state_0;
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1545 "gitg-remote.c"
		goto _state_1;
		default:
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1550 "gitg-remote.c"
	}
	_state_0:
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = NULL;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->signature;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = NULL;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = _data_->message;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_data_->_state_ = 1;
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern (_data_->self, _data_->_tmp0_, _data_->_tmp1_, gitg_remote_fetch_ready, _data_);
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1567 "gitg-remote.c"
	_state_1:
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1581 "gitg-remote.c"
		} else {
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1585 "gitg-remote.c"
		}
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 204 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1591 "gitg-remote.c"
	}
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1597 "gitg-remote.c"
	} else {
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1601 "gitg-remote.c"
	}
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 202 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1607 "gitg-remote.c"
}


GitgRemote* gitg_remote_construct (GType object_type) {
	GitgRemote * self = NULL;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemote*) g_object_new (object_type, NULL);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return self;
#line 1617 "gitg-remote.c"
}


GitgRemote* gitg_remote_new (void) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return gitg_remote_construct (GITG_TYPE_REMOTE);
#line 1624 "gitg-remote.c"
}


GError* gitg_remote_get_authentication_error (GitgRemote* self) {
	GError* result;
	GError* _tmp0_ = NULL;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_authentication_error;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	result = _tmp0_;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return result;
#line 1639 "gitg-remote.c"
}


GitgRemoteState gitg_remote_get_state (GitgRemote* self) {
	GitgRemoteState result;
	GitgRemoteState _tmp0_ = 0;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_state;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	result = _tmp0_;
#line 51 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	return result;
#line 1654 "gitg-remote.c"
}


static void gitg_remote_set_state (GitgRemote* self, GitgRemoteState value) {
	GitgRemoteState _tmp0_ = 0;
	GitgRemoteState _tmp1_ = 0;
#line 52 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_state;
#line 54 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = value;
#line 54 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != _tmp1_) {
#line 1669 "gitg-remote.c"
		GitgRemoteState _tmp2_ = 0;
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = value;
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		self->priv->d_state = _tmp2_;
#line 57 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_object_notify ((GObject*) self, "state");
#line 1677 "gitg-remote.c"
	}
#line 52 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_notify ((GObject *) self, "state");
#line 1681 "gitg-remote.c"
}


static void gitg_remote_class_init (GitgRemoteClass * klass) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	gitg_remote_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_type_class_add_private (klass, sizeof (GitgRemotePrivate));
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_remote_get_property;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_remote_set_property;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_finalize;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_AUTHENTICATION_ERROR, g_param_spec_pointer ("authentication-error", "authentication-error", "authentication-error", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_STATE, g_param_spec_enum ("state", "state", "state", GITG_TYPE_REMOTE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1700 "gitg-remote.c"
}


static void gitg_remote_instance_init (GitgRemote * self) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	self->priv = GITG_REMOTE_GET_PRIVATE (self);
#line 1707 "gitg-remote.c"
}


static void gitg_remote_finalize (GObject* obj) {
	GitgRemote * self;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REMOTE, GitgRemote);
#line 42 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	_g_error_free0 (self->priv->d_authentication_error);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (gitg_remote_parent_class)->finalize (obj);
#line 1719 "gitg-remote.c"
}


GType gitg_remote_get_type (void) {
	static volatile gsize gitg_remote_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_remote_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemote), 0, (GInstanceInitFunc) gitg_remote_instance_init, NULL };
		GType gitg_remote_type_id;
		gitg_remote_type_id = g_type_register_static (ggit_remote_get_type (), "GitgRemote", &g_define_type_info, 0);
		g_once_init_leave (&gitg_remote_type_id__volatile, gitg_remote_type_id);
	}
	return gitg_remote_type_id__volatile;
}


static void _vala_gitg_remote_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE, GitgRemote);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (property_id) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_AUTHENTICATION_ERROR:
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_value_set_pointer (value, gitg_remote_get_authentication_error (self));
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		break;
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_STATE:
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		g_value_set_enum (value, gitg_remote_get_state (self));
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		break;
#line 1752 "gitg-remote.c"
		default:
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		break;
#line 1758 "gitg-remote.c"
	}
}


static void _vala_gitg_remote_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE, GitgRemote);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
	switch (property_id) {
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_STATE:
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		gitg_remote_set_state (self, g_value_get_enum (value));
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		break;
#line 1774 "gitg-remote.c"
		default:
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-remote.vala"
		break;
#line 1780 "gitg-remote.c"
	}
}



