/* rygel-media-query-action.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from rygel-media-query-action.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaQueryActionRunData RygelMediaQueryActionRunData;
typedef struct _RygelMediaQueryActionFetchMediaObjectData RygelMediaQueryActionFetchMediaObjectData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelMediaQueryActionPrivate {
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaQueryActionRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	RygelMediaObjects* results;
	RygelMediaObject* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaObject* _tmp7_;
	guint32 _tmp8_;
	RygelMediaObjects* _tmp9_;
	RygelSerializer* _tmp10_;
	RygelHTTPServer* _tmp11_;
	RygelClientHacks* _tmp12_;
	GError* err;
	GError* _tmp13_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaQueryActionFetchMediaObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaObject* _tmp5_;
	const gchar* _tmp6_;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError * _inner_error_;
};


static gpointer rygel_media_query_action_parent_class = NULL;
static RygelStateMachineIface* rygel_media_query_action_rygel_state_machine_parent_iface = NULL;

GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionPrivate))
enum  {
	RYGEL_MEDIA_QUERY_ACTION_DUMMY_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, RygelSerializerType type);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static void rygel_media_query_action_real_run_data_free (gpointer _data);
static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
void rygel_media_objects_serialize (RygelMediaObjects* self, RygelSerializer* serializer, RygelHTTPServer* http_server, RygelClientHacks* hacks, GError** error);
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
void rygel_client_hacks_filter_sort_criteria (RygelClientHacks* self, gchar** sort_criteria);
static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self, GError** error);
void rygel_client_hacks_translate_container_id (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data);
static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_serializer_filter (RygelSerializer* self, const gchar* filter_string);
gchar* rygel_serializer_get_string (RygelSerializer* self);
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_finalize (GObject* obj);
static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
	g_boxed_free (gupnp_service_action_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelMediaQueryAction * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelContentDirectory* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	RygelHTTPServer* _tmp5_ = NULL;
	RygelContentDirectory* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	RygelContentDirectory* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	GUPnPServiceAction* _tmp10_ = NULL;
	RygelSerializer* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelMediaQueryAction*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir;
	_tmp1_ = _tmp0_->root_container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp2_;
	_tmp3_ = content_dir;
	_tmp4_ = _tmp3_->http_server;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp5_;
	_tmp6_ = content_dir;
	_tmp7_ = _tmp6_->system_update_id;
	self->system_update_id = _tmp7_;
	_tmp8_ = content_dir;
	_tmp9_ = _tmp8_->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp9_);
	_tmp10_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->action);
	self->action = _tmp10_;
	_tmp11_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
	_g_object_unref0 (self->serializer);
	self->serializer = _tmp11_;
	{
		RygelClientHacks* _tmp12_ = NULL;
		GUPnPServiceAction* _tmp13_ = NULL;
		SoupMessage* _tmp14_ = NULL;
		SoupMessage* _tmp15_ = NULL;
		RygelClientHacks* _tmp16_ = NULL;
		RygelClientHacks* _tmp17_ = NULL;
		RygelClientHacks* _tmp18_ = NULL;
		_tmp13_ = self->action;
		_tmp14_ = gupnp_service_action_get_message (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = rygel_client_hacks_create (_tmp15_, &_inner_error_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_tmp12_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch70_g_error;
		}
		_tmp18_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (self->hacks);
		self->hacks = _tmp18_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally70;
	__catch70_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally70:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_GUPnPServiceAction_free0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}


static void rygel_media_query_action_real_run_data_free (gpointer _data) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaQueryActionRunData, _data_);
}


static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryAction * self;
	RygelMediaQueryActionRunData* _data_;
	RygelMediaQueryAction* _tmp0_ = NULL;
	self = (RygelMediaQueryAction*) base;
	_data_ = g_slice_new0 (RygelMediaQueryActionRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_query_action_real_run_co (_data_);
}


static void rygel_media_query_action_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_query_action_real_run_co (_data_);
}


static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		rygel_media_query_action_parse_args (_data_->self, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch71_g_error;
		}
		_data_->_state_ = 1;
		rygel_media_query_action_fetch_media_object (_data_->self, rygel_media_query_action_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = rygel_media_query_action_fetch_media_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->media_object = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch71_g_error;
		}
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->media_object;
		_data_->_state_ = 2;
		rygel_media_query_action_fetch_results (_data_->self, _data_->_tmp1_, rygel_media_query_action_run_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = rygel_media_query_action_fetch_results_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->results = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->media_object);
			goto __catch71_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->results;
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->self->number_returned = (guint) _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->media_object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, RYGEL_TYPE_MEDIA_CONTAINER)) {
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->media_object;
			_data_->_tmp8_ = 0U;
			_data_->_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer)->update_id;
			_data_->self->update_id = (guint) _data_->_tmp8_;
		} else {
			_data_->self->update_id = (guint) G_MAXUINT32;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->results;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->serializer;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->self->http_server;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->hacks;
		rygel_media_objects_serialize (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->results);
			_g_object_unref0 (_data_->media_object);
			goto __catch71_g_error;
		}
		rygel_media_query_action_conclude (_data_->self);
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->media_object);
	}
	goto __finally71;
	__catch71_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->err;
		rygel_media_query_action_handle_error (_data_->self, _data_->_tmp13_);
		_g_error_free0 (_data_->err);
	}
	__finally71:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error) {
	gint64 index = 0LL;
	gint64 requested_count = 0LL;
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp9_ = FALSE;
	gint64 _tmp10_ = 0LL;
	const gchar* _tmp14_ = NULL;
	gint64 _tmp17_ = 0LL;
	gint64 _tmp18_ = 0LL;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	RygelClientHacks* _tmp21_ = NULL;
	RygelClientHacks* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 6)) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = _ ("Invalid number of arguments");
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp2_);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = self->action;
	_tmp5_ = self->object_id_arg;
	gupnp_service_action_get (_tmp4_, _tmp5_, G_TYPE_STRING, &self->object_id, "Filter", G_TYPE_STRING, &self->filter, "StartingIndex", G_TYPE_INT64, &index, "RequestedCount", G_TYPE_INT64, &requested_count, "SortCriteria", G_TYPE_STRING, &self->sort_criteria, NULL);
	_tmp6_ = self->object_id;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		_tmp7_ = _ ("ObjectID argument missing");
		_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp10_ = index;
	if (_tmp10_ < ((gint64) 0)) {
		_tmp9_ = TRUE;
	} else {
		gint64 _tmp11_ = 0LL;
		_tmp11_ = requested_count;
		_tmp9_ = _tmp11_ < ((gint64) 0);
	}
	if (_tmp9_) {
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		_tmp12_ = _ ("Invalid range");
		_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp12_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp14_ = self->filter;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		_tmp15_ = _ ("Missing filter");
		_tmp16_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp15_);
		_inner_error_ = _tmp16_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp17_ = index;
	self->index = (guint) _tmp17_;
	_tmp18_ = requested_count;
	self->requested_count = (guint) _tmp18_;
	_tmp19_ = self->sort_criteria;
	if (g_strcmp0 (_tmp19_, "") == 0) {
		_g_free0 (self->sort_criteria);
		self->sort_criteria = NULL;
	}
	_tmp21_ = self->hacks;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_ = NULL;
		_tmp22_ = self->sort_criteria;
		_tmp20_ = _tmp22_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		RygelClientHacks* _tmp23_ = NULL;
		_tmp23_ = self->hacks;
		rygel_client_hacks_filter_sort_criteria (_tmp23_, &self->sort_criteria);
	}
	rygel_media_query_action_validate_sort_criteria (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp24_ = self->hacks;
	if (_tmp24_ != NULL) {
		RygelClientHacks* _tmp25_ = NULL;
		_tmp25_ = self->hacks;
		rygel_client_hacks_translate_container_id (_tmp25_, self, &self->object_id);
	}
}


void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->parse_args (self, error);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self, GError** error) {
	const gchar* _tmp0_ = NULL;
	GeeHashSet* supported_props = NULL;
	GeeHashSet* _tmp1_ = NULL;
	gchar** requested_sort_props = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint requested_sort_props_length1 = 0;
	gint _requested_sort_props_size_ = 0;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->sort_criteria;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	supported_props = _tmp1_;
	_tmp2_ = self->sort_criteria;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
	requested_sort_props = _tmp4_;
	requested_sort_props_length1 = _vala_array_length (_tmp3_);
	_requested_sort_props_size_ = requested_sort_props_length1;
	_tmp6_ = _tmp5_ = g_strsplit (RYGEL_MEDIA_OBJECTS_SORT_CAPS, ",", 0);
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp6_;
		property_collection_length1 = _vala_array_length (_tmp5_);
		for (property_it = 0; property_it < _vala_array_length (_tmp5_); property_it = property_it + 1) {
			gchar* _tmp7_ = NULL;
			gchar* property = NULL;
			_tmp7_ = g_strdup (property_collection[property_it]);
			property = _tmp7_;
			{
				GeeHashSet* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				_tmp8_ = supported_props;
				_tmp9_ = property;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_g_free0 (property);
			}
		}
		property_collection = (_vala_array_free (property_collection, property_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp10_ = requested_sort_props;
	_tmp10__length1 = requested_sort_props_length1;
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp10_;
		property_collection_length1 = _tmp10__length1;
		for (property_it = 0; property_it < _tmp10__length1; property_it = property_it + 1) {
			gchar* _tmp11_ = NULL;
			gchar* property = NULL;
			_tmp11_ = g_strdup (property_collection[property_it]);
			property = _tmp11_;
			{
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				GeeHashSet* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				_tmp13_ = property;
				_tmp14_ = g_str_has_prefix (_tmp13_, "+");
				if (_tmp14_) {
					_tmp12_ = TRUE;
				} else {
					const gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					_tmp15_ = property;
					_tmp16_ = g_str_has_prefix (_tmp15_, "-");
					_tmp12_ = _tmp16_;
				}
				if (!_tmp12_) {
					const gchar* _tmp17_ = NULL;
					GError* _tmp18_ = NULL;
					_tmp17_ = property;
					_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is missing + or - modifier", _tmp17_);
					_inner_error_ = _tmp18_;
					g_propagate_error (error, _inner_error_);
					_g_free0 (property);
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (supported_props);
					return;
				}
				_tmp19_ = supported_props;
				_tmp20_ = property;
				_tmp21_ = property;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = string_slice (_tmp20_, (glong) 1, (glong) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp19_, _tmp25_);
				_tmp27_ = !_tmp26_;
				_g_free0 (_tmp25_);
				if (_tmp27_) {
					const gchar* _tmp28_ = NULL;
					GError* _tmp29_ = NULL;
					_tmp28_ = property;
					_tmp29_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is invalid or not supported", _tmp28_);
					_inner_error_ = _tmp29_;
					g_propagate_error (error, _inner_error_);
					_g_free0 (property);
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (supported_props);
					return;
				}
				_g_free0 (property);
			}
		}
	}
	requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (supported_props);
}


void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results (self, media_object, _callback_, _user_data_);
}


RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results_finish (self, _res_, error);
}


static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaQueryActionFetchMediaObjectData, _data_);
}


static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	RygelMediaQueryAction* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelMediaQueryActionFetchMediaObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_fetch_media_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_fetch_media_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_query_action_fetch_media_object_co (_data_);
}


static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_query_action_fetch_media_object_co (_data_);
}


static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->object_id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->root_container;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp3_) == 0) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->root_container;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _g_object_ref0 ((RygelMediaObject*) _data_->_tmp4_);
		_data_->result = _data_->_tmp5_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->object_id;
		g_debug ("rygel-media-query-action.vala:188: searching for object '%s'..", _data_->_tmp6_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->root_container;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->object_id;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_state_ = 1;
		rygel_media_container_find_object (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_, rygel_media_query_action_fetch_media_object_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = rygel_media_container_find_object_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->media_object = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->media_object;
		if (_data_->_tmp12_ == NULL) {
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->self->object_id_arg;
			if (g_strcmp0 (_data_->_tmp13_, "ObjectID") == 0) {
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _ ("No such object");
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp14_);
				_data_->_inner_error_ = _data_->_tmp15_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->media_object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _ ("No such container");
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _data_->_tmp16_);
				_data_->_inner_error_ = _data_->_tmp17_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->media_object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->self->object_id;
		g_debug ("rygel-media-query-action.vala:200: object '%s' found.", _data_->_tmp18_);
		_data_->result = _data_->media_object;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_query_action_conclude (RygelMediaQueryAction* self) {
	RygelSerializer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* didl = NULL;
	RygelSerializer* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GUPnPServiceAction* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GUPnPServiceAction* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->serializer;
	_tmp1_ = self->filter;
	rygel_serializer_filter (_tmp0_, _tmp1_);
	_tmp2_ = self->serializer;
	_tmp3_ = rygel_serializer_get_string (_tmp2_);
	didl = _tmp3_;
	_tmp4_ = self->update_id;
	if (_tmp4_ == ((guint) G_MAXUINT32)) {
		guint32 _tmp5_ = 0U;
		_tmp5_ = self->system_update_id;
		self->update_id = (guint) _tmp5_;
	}
	_tmp6_ = self->action;
	_tmp7_ = didl;
	_tmp8_ = self->number_returned;
	_tmp9_ = self->total_matches;
	_tmp10_ = self->update_id;
	gupnp_service_action_set (_tmp6_, "Result", G_TYPE_STRING, _tmp7_, "NumberReturned", G_TYPE_UINT, _tmp8_, "TotalMatches", G_TYPE_UINT, _tmp9_, "UpdateID", G_TYPE_UINT, _tmp10_, NULL);
	_tmp11_ = self->action;
	gupnp_service_action_return (_tmp11_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	GError* _tmp0_ = NULL;
	_tmp0_ = _error_;
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		GUPnPServiceAction* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp1_ = self->action;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->code;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
	} else {
		GUPnPServiceAction* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = self->action;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->handle_error (self, _error_);
}


static GCancellable* rygel_media_query_action_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_ = NULL;
	self = (RygelMediaQueryAction*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_media_query_action_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	self = (RygelMediaQueryAction*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_query_action_class_init (RygelMediaQueryActionClass * klass) {
	rygel_media_query_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaQueryActionPrivate));
	((RygelMediaQueryActionClass *) klass)->parse_args = rygel_media_query_action_real_parse_args;
	((RygelMediaQueryActionClass *) klass)->handle_error = rygel_media_query_action_real_handle_error;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_query_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_query_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_query_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_media_query_action_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_query_action_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_query_action_real_run;
	iface->run_finish = rygel_media_query_action_real_run_finish;
	iface->get_cancellable = rygel_media_query_action_real_get_cancellable;
	iface->set_cancellable = rygel_media_query_action_real_set_cancellable;
}


static void rygel_media_query_action_instance_init (RygelMediaQueryAction * self) {
	self->priv = RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE (self);
}


static void rygel_media_query_action_finalize (GObject* obj) {
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
	_g_free0 (self->object_id);
	_g_free0 (self->browse_flag);
	_g_free0 (self->filter);
	_g_free0 (self->sort_criteria);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->http_server);
	__vala_GUPnPServiceAction_free0 (self->action);
	_g_object_unref0 (self->serializer);
	_g_object_unref0 (self->hacks);
	_g_free0 (self->object_id_arg);
	G_OBJECT_CLASS (rygel_media_query_action_parent_class)->finalize (obj);
}


/**
 * Base class of Browse and Search actions.
 */
GType rygel_media_query_action_get_type (void) {
	static volatile gsize rygel_media_query_action_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_query_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaQueryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_query_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaQueryAction), 0, (GInstanceInitFunc) rygel_media_query_action_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_query_action_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_query_action_type_id;
		rygel_media_query_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaQueryAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_media_query_action_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_query_action_type_id__volatile, rygel_media_query_action_type_id);
	}
	return rygel_media_query_action_type_id__volatile;
}


static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



