/* game-view.c generated by valac 0.28.0.2-022b, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoardViewPrivate BoardViewPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	ClutterTexture* highlight_texture;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	gint current_level;
	GList* actor_remove_queue;
	ClutterActor* board_group;
	BoardView* board_view;
	BoardView* new_board_view;
	ClutterActor* key_cursor_view;
	ClutterTimeline* timeline;
	gint key_cursor_x;
	gint key_cursor_y;
	gboolean key_cursor_ready;
	gint last_direction;
	gint last_sign;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};


static gpointer game_view_parent_class = NULL;

void setup_animation (ClutterActor* actor, ClutterAnimationMode mode, guint duration);
GType game_view_get_type (void) G_GNUC_CONST;
GType board_view_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static BoardView* game_view_create_board_view (GameView* self, gint level);
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
void board_view_load_level (BoardView* self, gint level);
static void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self);
static void game_view_light_toggled_cb (GameView* self);
static void _game_view_light_toggled_cb_board_view_light_toggled (BoardView* _sender, gpointer self);
static void game_view_transition_complete_cb (GameView* self);
gint board_view_get_moves (BoardView* self);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
void game_view_swap_board (GameView* self, gint direction);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void game_view_activate_cursor (GameView* self);
void board_view_move_to (BoardView* self, gint x, gint y);
void game_view_reset_game (GameView* self);
static void game_view_finalize (GObject* obj);


void setup_animation (ClutterActor* actor, ClutterAnimationMode mode, guint duration) {
	ClutterActor* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	ClutterActor* _tmp2_ = NULL;
	ClutterAnimationMode _tmp3_ = 0;
#line 11 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (actor != NULL);
#line 12 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = actor;
#line 12 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = duration;
#line 12 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_easing_duration (_tmp0_, _tmp1_);
#line 13 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp2_ = actor;
#line 13 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp3_ = mode;
#line 13 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_easing_mode (_tmp2_, _tmp3_);
#line 143 "game-view.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 150 "game-view.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 24 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_list_free (self);
#line 159 "game-view.c"
}


GameView* game_view_construct (GType object_type, gint level) {
	GameView * self = NULL;
	ClutterTexture* _tmp20_ = NULL;
	ClutterTexture* _tmp21_ = NULL;
	ClutterTexture* _tmp22_ = NULL;
	ClutterTexture* _tmp23_ = NULL;
	ClutterTexture* _tmp24_ = NULL;
	ClutterTexture* _tmp25_ = NULL;
	ClutterActor* _tmp26_ = NULL;
	ClutterActor* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	BoardView* _tmp30_ = NULL;
	BoardView* _tmp31_ = NULL;
	ClutterActor* _tmp32_ = NULL;
	BoardView* _tmp33_ = NULL;
	gfloat real_board_width = 0.0F;
	ClutterTexture* _tmp34_ = NULL;
	gfloat _tmp35_ = 0.0F;
	gfloat _tmp36_ = 0.0F;
	gfloat real_board_height = 0.0F;
	ClutterTexture* _tmp37_ = NULL;
	gfloat _tmp38_ = 0.0F;
	gfloat _tmp39_ = 0.0F;
	ClutterTexture* _tmp40_ = NULL;
	ClutterClone* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterActor* _tmp43_ = NULL;
	ClutterActor* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
#line 43 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 195 "game-view.c"
	{
		ClutterTexture* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		ClutterTexture* _tmp3_ = NULL;
		ClutterTexture* _tmp4_ = NULL;
		ClutterTexture* _tmp5_ = NULL;
		ClutterTexture* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		ClutterTexture* _tmp9_ = NULL;
		ClutterTexture* _tmp10_ = NULL;
		ClutterTexture* _tmp11_ = NULL;
		ClutterTexture* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		ClutterTexture* _tmp15_ = NULL;
		ClutterTexture* _tmp16_ = NULL;
		ClutterTexture* _tmp17_ = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp1_ = g_build_filename (DATADIR, "highlight.svg", NULL);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp2_ = _tmp1_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp3_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp2_, &_inner_error_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_object_ref_sink (_tmp3_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_free0 (_tmp2_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = _tmp4_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 233 "game-view.c"
				goto __catch1_clutter_texture_error;
			}
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			return NULL;
#line 242 "game-view.c"
		}
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp5_ = _tmp0_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_object_ref_sink (_tmp5_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_object_unref0 (self->priv->highlight_texture);
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->highlight_texture = _tmp5_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp7_ = g_build_filename (DATADIR, "off.svg", NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp9_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp8_, &_inner_error_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_object_ref_sink (_tmp9_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp10_ = _tmp9_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_free0 (_tmp8_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp6_ = _tmp10_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_g_object_unref0 (_tmp0_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 274 "game-view.c"
				goto __catch1_clutter_texture_error;
			}
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_g_object_unref0 (_tmp0_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			return NULL;
#line 285 "game-view.c"
		}
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp11_ = _tmp6_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp6_ = NULL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_object_ref_sink (_tmp11_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_object_unref0 (self->priv->off_texture);
#line 48 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->off_texture = _tmp11_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp13_ = g_build_filename (DATADIR, "on.svg", NULL);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp14_ = _tmp13_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp15_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp14_, &_inner_error_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_object_ref_sink (_tmp15_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp16_ = _tmp15_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_free0 (_tmp14_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp12_ = _tmp16_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_g_object_unref0 (_tmp6_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_g_object_unref0 (_tmp0_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 319 "game-view.c"
				goto __catch1_clutter_texture_error;
			}
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_g_object_unref0 (_tmp6_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_g_object_unref0 (_tmp0_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			return NULL;
#line 332 "game-view.c"
		}
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp17_ = _tmp12_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp12_ = NULL;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_object_ref_sink (_tmp17_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_object_unref0 (self->priv->on_texture);
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->on_texture = _tmp17_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_object_unref0 (_tmp12_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_object_unref0 (_tmp6_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_object_unref0 (_tmp0_);
#line 350 "game-view.c"
	}
	goto __finally1;
	__catch1_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		e = _inner_error_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_inner_error_ = NULL;
#line 53 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp18_ = e;
#line 53 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp19_ = _tmp18_->message;
#line 53 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_warning ("game-view.vala:53: Failed to load textures: %s", _tmp19_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_g_error_free0 (e);
#line 370 "game-view.c"
	}
	__finally1:
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		return NULL;
#line 381 "game-view.c"
	}
#line 57 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp20_ = self->priv->highlight_texture;
#line 57 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_hide ((ClutterActor*) _tmp20_);
#line 58 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp21_ = self->priv->highlight_texture;
#line 58 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp21_);
#line 59 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp22_ = self->priv->off_texture;
#line 59 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_hide ((ClutterActor*) _tmp22_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp23_ = self->priv->off_texture;
#line 60 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp23_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp24_ = self->priv->on_texture;
#line 61 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_hide ((ClutterActor*) _tmp24_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp25_ = self->priv->on_texture;
#line 62 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp25_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp26_ = clutter_actor_new ();
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_object_ref_sink (_tmp26_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->board_group);
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->board_group = _tmp26_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp27_ = self->priv->board_group;
#line 65 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, _tmp27_);
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp28_ = level;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->current_level = _tmp28_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp29_ = self->priv->current_level;
#line 68 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp30_ = game_view_create_board_view (self, _tmp29_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->board_view);
#line 68 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->board_view = _tmp30_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp31_ = self->priv->board_view;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp31_->playable = TRUE;
#line 70 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp32_ = self->priv->board_group;
#line 70 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp33_ = self->priv->board_view;
#line 70 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child (_tmp32_, (ClutterActor*) _tmp33_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp34_ = self->priv->off_texture;
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp35_ = clutter_actor_get_width ((ClutterActor*) _tmp34_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp36_ = _tmp35_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	real_board_width = (5 * _tmp36_) + 4;
#line 73 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp37_ = self->priv->off_texture;
#line 73 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp38_ = clutter_actor_get_height ((ClutterActor*) _tmp37_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp39_ = _tmp38_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	real_board_height = (5 * _tmp39_) + 4;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_size ((ClutterActor*) self, real_board_width, real_board_height);
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp40_ = self->priv->highlight_texture;
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp41_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp40_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_object_ref_sink (_tmp41_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->key_cursor_view);
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->key_cursor_view = (ClutterActor*) _tmp41_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp42_ = self->priv->key_cursor_view;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_position (_tmp42_, (gfloat) (-100), (gfloat) (-100));
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp43_ = self->priv->key_cursor_view;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_object_set (_tmp43_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
#line 79 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp44_ = self->priv->key_cursor_view;
#line 79 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, _tmp44_);
#line 43 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	return self;
#line 483 "game-view.c"
}


GameView* game_view_new (gint level) {
#line 43 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW, level);
#line 490 "game-view.c"
}


static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self) {
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	game_view_game_won_cb ((GameView*) self);
#line 497 "game-view.c"
}


static void _game_view_light_toggled_cb_board_view_light_toggled (BoardView* _sender, gpointer self) {
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	game_view_light_toggled_cb ((GameView*) self);
#line 504 "game-view.c"
}


static BoardView* game_view_create_board_view (GameView* self, gint level) {
	BoardView* result = NULL;
	BoardView* view = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = self->priv->off_texture;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = self->priv->on_texture;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp2_ = board_view_new (_tmp0_, _tmp1_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_object_ref_sink (_tmp2_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	view = _tmp2_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp3_ = level;
#line 85 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_load_level (view, _tmp3_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_connect_object (view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, self, 0);
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_connect_object (view, "light-toggled", (GCallback) _game_view_light_toggled_cb_board_view_light_toggled, self, 0);
#line 88 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	view->playable = FALSE;
#line 89 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	result = view;
#line 89 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	return result;
#line 541 "game-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 548 "game-view.c"
}


static void game_view_transition_complete_cb (GameView* self) {
	BoardView* _tmp0_ = NULL;
	BoardView* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	BoardView* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 93 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = self->priv->board_view;
#line 95 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = self->priv->new_board_view;
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->board_view);
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->board_view = _tmp2_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp3_ = self->priv->board_view;
#line 97 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp3_->playable = TRUE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->new_board_view);
#line 98 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->new_board_view = NULL;
#line 99 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->timeline);
#line 99 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->timeline = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp4_ = self->priv->actor_remove_queue;
#line 586 "game-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		actor_collection = _tmp4_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 594 "game-view.c"
			ClutterActor* _tmp5_ = NULL;
			ClutterActor* actor = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_tmp5_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			actor = _tmp5_;
#line 601 "game-view.c"
			{
				ClutterActor* _tmp6_ = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				_tmp6_ = actor;
#line 103 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				clutter_actor_destroy (_tmp6_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				_g_object_unref0 (actor);
#line 610 "game-view.c"
			}
		}
	}
#line 104 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
#line 104 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->actor_remove_queue = NULL;
#line 618 "game-view.c"
}


static void game_view_light_toggled_cb (GameView* self) {
	BoardView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 109 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = self->priv->board_view;
#line 109 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = board_view_get_moves (_tmp0_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 109 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_emit_by_name (self, "moves-changed", _tmp2_);
#line 636 "game-view.c"
}


static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	game_view_transition_complete_cb ((GameView*) self);
#line 643 "game-view.c"
}


static void game_view_game_won_cb (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	gint direction = 0;
	gint sign = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	BoardView* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	BoardView* _tmp19_ = NULL;
	ClutterTimeline* _tmp20_ = NULL;
	BoardView* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	ClutterTimeline* _tmp24_ = NULL;
	BoardView* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	ClutterTimeline* _tmp28_ = NULL;
	ClutterTimeline* _tmp29_ = NULL;
	gint _tmp30_ = 0;
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = self->priv->timeline;
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp1_ != NULL) {
#line 676 "game-view.c"
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp2_ = self->priv->timeline;
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = _tmp3_;
#line 685 "game-view.c"
	} else {
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = FALSE;
#line 689 "game-view.c"
	}
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp0_) {
#line 117 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		return;
#line 695 "game-view.c"
	}
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp4_ = self->priv->current_level;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->current_level = _tmp4_ + 1;
#line 122 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	direction = 0;
#line 123 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	sign = 0;
#line 705 "game-view.c"
	{
		gboolean _tmp5_ = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp5_ = TRUE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		while (TRUE) {
#line 712 "game-view.c"
			gint32 _tmp11_ = 0;
			gint _tmp12_ = 0;
			gboolean _tmp13_ = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			if (!_tmp5_) {
#line 718 "game-view.c"
				gboolean _tmp6_ = FALSE;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				_tmp7_ = self->priv->last_direction;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				_tmp8_ = direction;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				if (_tmp7_ == _tmp8_) {
#line 728 "game-view.c"
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
					_tmp9_ = self->priv->last_sign;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
					_tmp10_ = sign;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
					_tmp6_ = _tmp9_ == _tmp10_;
#line 737 "game-view.c"
				} else {
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
					_tmp6_ = FALSE;
#line 741 "game-view.c"
				}
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				if (!_tmp6_) {
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
					break;
#line 747 "game-view.c"
				}
			}
#line 124 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_tmp5_ = FALSE;
#line 126 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_tmp11_ = g_random_int_range ((gint32) 0, (gint32) 2);
#line 126 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			direction = (gint) _tmp11_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			_tmp13_ = g_random_boolean ();
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			if (_tmp13_) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				_tmp12_ = 1;
#line 762 "game-view.c"
			} else {
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
				_tmp12_ = -1;
#line 766 "game-view.c"
			}
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
			sign = _tmp12_;
#line 770 "game-view.c"
		}
	}
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp14_ = direction;
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->last_direction = _tmp14_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp15_ = sign;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->last_sign = _tmp15_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp16_ = self->priv->current_level;
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp17_ = game_view_create_board_view (self, _tmp16_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->new_board_view);
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->new_board_view = _tmp17_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp18_ = self->priv->board_group;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp19_ = self->priv->new_board_view;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child (_tmp18_, (ClutterActor*) _tmp19_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp20_ = clutter_timeline_new ((guint) 1500);
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->timeline);
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->timeline = _tmp20_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp21_ = self->priv->new_board_view;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp22_ = direction;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp23_ = sign;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp24_ = self->priv->timeline;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_slide_in (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp25_ = self->priv->board_view;
#line 138 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp26_ = direction;
#line 138 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp27_ = sign;
#line 138 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp28_ = self->priv->timeline;
#line 138 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_slide_out (_tmp25_, _tmp26_, _tmp27_, _tmp28_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp29_ = self->priv->timeline;
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_connect_object (_tmp29_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
#line 141 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp30_ = self->priv->current_level;
#line 141 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_emit_by_name (self, "level-changed", _tmp30_);
#line 829 "game-view.c"
}


void game_view_swap_board (GameView* self, gint direction) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ClutterTimeline* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	BoardView* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	BoardView* _tmp11_ = NULL;
	BoardView* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	BoardView* _tmp14_ = NULL;
	BoardView* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	ClutterTimeline* _tmp17_ = NULL;
	BoardView* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ClutterTimeline* _tmp20_ = NULL;
	ClutterTimeline* _tmp21_ = NULL;
	gint _tmp22_ = 0;
#line 148 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = self->priv->timeline;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp1_ != NULL) {
#line 861 "game-view.c"
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp2_ = self->priv->timeline;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = _tmp3_;
#line 870 "game-view.c"
	} else {
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = FALSE;
#line 874 "game-view.c"
	}
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp0_) {
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		return;
#line 880 "game-view.c"
	}
#line 153 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp4_ = self->priv->current_level;
#line 153 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp5_ = direction;
#line 153 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->current_level = _tmp4_ + _tmp5_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp6_ = self->priv->current_level;
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp6_ <= 0) {
#line 156 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->current_level = 1;
#line 157 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		return;
#line 896 "game-view.c"
	}
#line 160 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp7_ = clutter_timeline_new ((guint) 500);
#line 160 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->timeline);
#line 160 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->timeline = _tmp7_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp8_ = self->priv->current_level;
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp9_ = game_view_create_board_view (self, _tmp8_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->new_board_view);
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->new_board_view = _tmp9_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp10_ = self->priv->board_group;
#line 163 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp11_ = self->priv->new_board_view;
#line 163 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child (_tmp10_, (ClutterActor*) _tmp11_);
#line 164 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp12_ = self->priv->new_board_view;
#line 164 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp13_ = direction;
#line 164 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_z_position ((ClutterActor*) _tmp12_, (gfloat) ((-250) * _tmp13_));
#line 165 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp14_ = self->priv->new_board_view;
#line 165 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) _tmp14_, (guint) 0);
#line 167 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp15_ = self->priv->new_board_view;
#line 167 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp16_ = direction;
#line 167 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp17_ = self->priv->timeline;
#line 167 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_swap_in (_tmp15_, (gfloat) _tmp16_, _tmp17_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp18_ = self->priv->board_view;
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp19_ = direction;
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp20_ = self->priv->timeline;
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_swap_out (_tmp18_, (gfloat) _tmp19_, _tmp20_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp21_ = self->priv->timeline;
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_connect_object (_tmp21_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
#line 171 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp22_ = self->priv->current_level;
#line 171 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_emit_by_name (self, "level-changed", _tmp22_);
#line 952 "game-view.c"
}


void game_view_hide_cursor (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
#line 174 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 176 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = self->priv->key_cursor_view;
#line 176 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	setup_animation (_tmp0_, CLUTTER_EASE_OUT_SINE, (guint) 250);
#line 177 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = self->priv->key_cursor_view;
#line 177 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_opacity (_tmp1_, (guint8) 0);
#line 178 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->key_cursor_ready = FALSE;
#line 971 "game-view.c"
}


void game_view_move_cursor (GameView* self, gint x_step, gint y_step) {
	gboolean _tmp0_ = FALSE;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	BoardView* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gboolean _tmp18_ = FALSE;
#line 181 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 183 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = self->priv->key_cursor_ready;
#line 183 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp0_) {
#line 991 "game-view.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp1_ = self->priv->key_cursor_x;
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp2_ = x_step;
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->key_cursor_x = _tmp1_ + _tmp2_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp3_ = self->priv->key_cursor_y;
#line 186 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp4_ = y_step;
#line 186 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->key_cursor_y = _tmp3_ + _tmp4_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp5_ = self->priv->key_cursor_x;
#line 187 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp6_ = MAX (_tmp5_, 0);
#line 187 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->key_cursor_x = _tmp6_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp7_ = self->priv->key_cursor_x;
#line 188 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp8_ = MIN (_tmp7_, 4);
#line 188 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->key_cursor_x = _tmp8_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp9_ = self->priv->key_cursor_y;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp10_ = MAX (_tmp9_, 0);
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->key_cursor_y = _tmp10_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp11_ = self->priv->key_cursor_y;
#line 190 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp12_ = MIN (_tmp11_, 4);
#line 190 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		self->priv->key_cursor_y = _tmp12_;
#line 1040 "game-view.c"
	}
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp13_ = self->priv->board_view;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp14_ = self->priv->key_cursor_x;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp15_ = self->priv->key_cursor_y;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_get_light_position (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_tmp17_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	x = _tmp16_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	y = _tmp17_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp18_ = self->priv->key_cursor_ready;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp18_) {
#line 1058 "game-view.c"
		ClutterActor* _tmp19_ = NULL;
		ClutterActor* _tmp20_ = NULL;
		gfloat _tmp21_ = 0.0F;
		gfloat _tmp22_ = 0.0F;
#line 198 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp19_ = self->priv->key_cursor_view;
#line 198 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		setup_animation (_tmp19_, CLUTTER_EASE_OUT_SINE, (guint) 250);
#line 199 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp20_ = self->priv->key_cursor_view;
#line 199 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp21_ = x;
#line 199 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp22_ = y;
#line 199 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		clutter_actor_set_position (_tmp20_, _tmp21_, _tmp22_);
#line 1075 "game-view.c"
	} else {
		ClutterActor* _tmp23_ = NULL;
		ClutterActor* _tmp24_ = NULL;
		gfloat _tmp25_ = 0.0F;
		gfloat _tmp26_ = 0.0F;
		ClutterActor* _tmp27_ = NULL;
		ClutterActor* _tmp28_ = NULL;
#line 203 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp23_ = self->priv->key_cursor_view;
#line 203 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		clutter_actor_set_opacity (_tmp23_, (guint) 0);
#line 204 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp24_ = self->priv->key_cursor_view;
#line 204 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp25_ = x;
#line 204 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp26_ = y;
#line 204 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		clutter_actor_set_position (_tmp24_, _tmp25_, _tmp26_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp27_ = self->priv->key_cursor_view;
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		setup_animation (_tmp27_, CLUTTER_EASE_OUT_SINE, (guint) 250);
#line 206 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp28_ = self->priv->key_cursor_view;
#line 206 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		clutter_actor_set_opacity (_tmp28_, (guint8) 255);
#line 1103 "game-view.c"
	}
#line 209 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->key_cursor_ready = TRUE;
#line 1107 "game-view.c"
}


void game_view_activate_cursor (GameView* self) {
	gboolean _tmp0_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp0_ = self->priv->key_cursor_ready;
#line 214 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp0_) {
#line 1119 "game-view.c"
		BoardView* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp1_ = self->priv->board_view;
#line 215 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp2_ = self->priv->key_cursor_x;
#line 215 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp3_ = self->priv->key_cursor_y;
#line 215 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		board_view_move_to (_tmp1_, _tmp2_, _tmp3_);
#line 1131 "game-view.c"
	}
}


void game_view_reset_game (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	ClutterTimeline* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	BoardView* _tmp6_ = NULL;
	ClutterActor* _tmp7_ = NULL;
	BoardView* _tmp8_ = NULL;
	BoardView* _tmp9_ = NULL;
	BoardView* _tmp10_ = NULL;
	BoardView* _tmp11_ = NULL;
	ClutterTimeline* _tmp12_ = NULL;
	BoardView* _tmp13_ = NULL;
	ClutterTimeline* _tmp14_ = NULL;
	ClutterTimeline* _tmp15_ = NULL;
	gint _tmp16_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp1_ = self->priv->timeline;
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp1_ != NULL) {
#line 1158 "game-view.c"
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp2_ = self->priv->timeline;
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = _tmp3_;
#line 1167 "game-view.c"
	} else {
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		_tmp0_ = FALSE;
#line 1171 "game-view.c"
	}
#line 220 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	if (_tmp0_) {
#line 221 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
		return;
#line 1177 "game-view.c"
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->current_level = 1;
#line 225 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp4_ = clutter_timeline_new ((guint) 500);
#line 225 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->timeline);
#line 225 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->timeline = _tmp4_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp5_ = self->priv->current_level;
#line 227 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp6_ = game_view_create_board_view (self, _tmp5_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->new_board_view);
#line 227 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->new_board_view = _tmp6_;
#line 228 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp7_ = self->priv->board_group;
#line 228 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp8_ = self->priv->new_board_view;
#line 228 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_add_child (_tmp7_, (ClutterActor*) _tmp8_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp9_ = self->priv->new_board_view;
#line 229 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_z_position ((ClutterActor*) _tmp9_, (gfloat) 250);
#line 230 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp10_ = self->priv->new_board_view;
#line 230 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) _tmp10_, (guint) 0);
#line 232 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp11_ = self->priv->new_board_view;
#line 232 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp12_ = self->priv->timeline;
#line 232 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_swap_in (_tmp11_, (gfloat) (-1), _tmp12_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp13_ = self->priv->board_view;
#line 233 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp14_ = self->priv->timeline;
#line 233 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	board_view_swap_out (_tmp13_, (gfloat) (-1), _tmp14_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp15_ = self->priv->timeline;
#line 234 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_connect_object (_tmp15_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
#line 236 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_tmp16_ = self->priv->current_level;
#line 236 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_emit_by_name (self, "level-changed", _tmp16_);
#line 1229 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_new ("level_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	g_signal_new ("moves_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 1244 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 24 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->actor_remove_queue = NULL;
#line 28 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->new_board_view = NULL;
#line 32 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->key_cursor_x = 0;
#line 33 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->key_cursor_y = 0;
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->key_cursor_ready = FALSE;
#line 36 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->last_direction = 0;
#line 38 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self->priv->last_sign = 0;
#line 1265 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 18 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->highlight_texture);
#line 19 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->off_texture);
#line 20 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->on_texture);
#line 24 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
#line 26 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->board_group);
#line 27 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->board_view);
#line 28 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->new_board_view);
#line 29 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->key_cursor_view);
#line 31 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	_g_object_unref0 (self->priv->timeline);
#line 16 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 1293 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}



